/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net;

import android.util.Log;
import com.android.internal.net.DNParser;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.security.auth.x500.X500Principal;

public class DomainNameValidator {
    private static final int ALT_DNS_NAME = 2;
    private static final int ALT_IPA_NAME = 7;
    private static final boolean DEBUG = false;
    private static final boolean LOG_ENABLED = false;
    private static Pattern QUICK_IP_PATTERN;
    private static final String TAG = "DomainNameValidator";

    static {
        try {
            QUICK_IP_PATTERN = Pattern.compile("^[a-f0-9\\.:]+$");
        }
        catch (PatternSyntaxException patternSyntaxException) {}
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean domainTokenMatch(String string2, String string3) {
        int n;
        if (string2 == null) return false;
        if (string3 == null) return false;
        int n2 = string3.indexOf(42);
        if (n2 < 0) return false;
        int n3 = string3.length() - 1;
        if (n3 > (n = string2.length())) return false;
        String string4 = string3.substring(0, n2);
        int n4 = n2 + 1;
        String string5 = string3.substring(n4);
        if (!string2.startsWith(string4)) return false;
        if (!string2.endsWith(string5)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isIpAddress(String string2) {
        if (string2 == null) return false;
        if (string2.length() == 0) return false;
        boolean bl = true;
        if (!bl) return bl;
        try {
            bl = QUICK_IP_PATTERN.matcher(string2).matches();
            if (!bl) return bl;
            String string3 = InetAddress.getByName(string2).getHostAddress();
            boolean bl2 = string2.equals(string3);
            return bl2;
        }
        catch (UnknownHostException unknownHostException) {
            if (unknownHostException.getMessage() != null) return false;
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean match(X509Certificate x509Certificate, String string2) {
        if (x509Certificate == null) return false;
        if (string2 == null) return false;
        if (string2.length() == 0) {
            return false;
        }
        if (DomainNameValidator.isIpAddress(string2 = string2.toLowerCase())) return DomainNameValidator.matchIpAddress(x509Certificate, string2);
        return DomainNameValidator.matchDns(x509Certificate, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean matchDns(String string2, String string3) {
        String[] stringArray;
        int n;
        if (string2 == null) return false;
        if (string2.length() == 0) return false;
        if (string3 == null) return false;
        if (string3.length() == 0) {
            return false;
        }
        boolean bl = string2.equals(string3 = string3.toLowerCase());
        if (bl) return bl;
        String[] stringArray2 = string2.split("\\.");
        int n2 = stringArray2.length;
        if (n2 >= (n = (stringArray = string3.split("\\.")).length)) {
            int n3 = n - 1;
            while (n3 >= 0) {
                String string4 = stringArray2[n3];
                String string5 = stringArray[n3];
                bl = string4.equals(string5);
                if (!bl) {
                    if (n3 != 0) return false;
                    if (n2 == n) return false;
                    bl = true;
                    if (!bl) return bl;
                    bl = stringArray[0].equals("*");
                    if (bl) return bl;
                    String string6 = stringArray2[0];
                    String string7 = stringArray[0];
                    bl = DomainNameValidator.domainTokenMatch(string6, string7);
                    return bl;
                }
                n3 += -1;
            }
            return bl;
        }
        String string8 = "*." + string2;
        return string3.equals(string8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean matchDns(X509Certificate x509Certificate, String string2) {
        boolean bl = false;
        try {
            Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
            if (collection != null) {
                for (List<?> list : collection) {
                    boolean bl2;
                    Integer n;
                    int n2;
                    if (list == null || 2 > (n2 = list.size()) || (n = (Integer)list.get(0)) == null || n != 2) continue;
                    bl = true;
                    String string3 = (String)list.get(1);
                    if (string3 == null || !(bl2 = DomainNameValidator.matchDns(string2, string3))) continue;
                    return true;
                }
            }
        }
        catch (CertificateParsingException certificateParsingException) {
            String string4 = certificateParsingException.getMessage();
            if (string4 == null) {
                string4 = "failed to parse certificate";
            }
            String string5 = "DomainNameValidator.matchDns(): " + string4;
            int n = Log.w(TAG, string5);
            return false;
        }
        if (bl) return false;
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        String string6 = new DNParser(x500Principal).find("cn");
        if (string6 == null) return false;
        return DomainNameValidator.matchDns(string2, string6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean matchIpAddress(X509Certificate x509Certificate, String string2) {
        try {
            boolean bl;
            String string3;
            Integer n;
            int n2;
            List<?> list;
            Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
            if (collection == null) return false;
            Iterator<List<?>> iterator = collection.iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while ((list = iterator.next()) == null || 2 > (n2 = list.size()) || (n = (Integer)list.get(0)) == null || n != 7 || (string3 = (String)list.get(1)) == null || !(bl = string2.equalsIgnoreCase(string3)));
            return true;
        }
        catch (CertificateParsingException certificateParsingException) {
            // empty catch block
        }
        return false;
    }
}

