/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.nfc;

import android.nfc.ErrorCodes;
import android.nfc.ILlcpConnectionlessSocket;
import android.nfc.LlcpPacket;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;

public class LlcpConnectionlessSocket {
    private static final String TAG = "LlcpConnectionlessSocket";
    protected int mHandle;
    protected ILlcpConnectionlessSocket mService;

    LlcpConnectionlessSocket(ILlcpConnectionlessSocket iLlcpConnectionlessSocket, int n) {
        this.mService = iLlcpConnectionlessSocket;
        this.mHandle = n;
    }

    public void close() {
        try {
            ILlcpConnectionlessSocket iLlcpConnectionlessSocket = this.mService;
            int n = this.mHandle;
            iLlcpConnectionlessSocket.close(n);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "RemoteException in close(): ", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getSap() {
        int n = 0;
        try {
            ILlcpConnectionlessSocket iLlcpConnectionlessSocket = this.mService;
            int n2 = this.mHandle;
            int n3 = iLlcpConnectionlessSocket.getSap(n2);
            return n3;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LlcpPacket receiveFrom() throws IOException {
        try {
            ILlcpConnectionlessSocket iLlcpConnectionlessSocket = this.mService;
            int n = this.mHandle;
            LlcpPacket llcpPacket = iLlcpConnectionlessSocket.receiveFrom(n);
            if (llcpPacket == null) throw new IOException();
            return llcpPacket;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "RemoteException in receiveFrom(): ", remoteException);
            return null;
        }
    }

    public void sendTo(LlcpPacket llcpPacket) throws IOException {
        try {
            ILlcpConnectionlessSocket iLlcpConnectionlessSocket = this.mService;
            int n = this.mHandle;
            if (!ErrorCodes.isError(iLlcpConnectionlessSocket.sendTo(n, llcpPacket))) {
                return;
            }
            throw new IOException();
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "RemoteException in sendTo(): ", remoteException);
            return;
        }
    }
}

