/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.nfc;

import android.nfc.ErrorCodes;
import android.nfc.ILlcpServiceSocket;
import android.nfc.ILlcpSocket;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.nfc.LlcpException;
import com.android.internal.nfc.LlcpSocket;
import java.io.IOException;

public class LlcpServiceSocket {
    private static final String TAG = "LlcpServiceSocket";
    protected int mHandle;
    private final ILlcpSocket mLlcpSocketService;
    protected ILlcpServiceSocket mService;

    public LlcpServiceSocket(ILlcpServiceSocket iLlcpServiceSocket, ILlcpSocket iLlcpSocket, int n) {
        this.mService = iLlcpServiceSocket;
        this.mHandle = n;
        this.mLlcpSocketService = iLlcpSocket;
    }

    static LlcpException convertErrorToLlcpException(int n) {
        return LlcpServiceSocket.convertErrorToLlcpException(n, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    static LlcpException convertErrorToLlcpException(int n, String string2) {
        String string3 = string2 == null ? "" : " (" + string2 + ")";
        switch (n) {
            default: {
                String string4 = "Unkown error code " + n + string3;
                return new LlcpException(string4);
            }
            case -10: {
                String string5 = "Error during the creation of an Llcp socket" + string3;
                return new LlcpException(string5);
            }
            case -9: 
        }
        String string6 = "Not enough ressources are available" + string3;
        return new LlcpException(string6);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LlcpSocket accept() throws IOException, LlcpException {
        int n;
        try {
            ILlcpServiceSocket iLlcpServiceSocket = this.mService;
            int n2 = this.mHandle;
            n = iLlcpServiceSocket.accept(n2);
            if (ErrorCodes.isError(n)) {
                if (n != -1) throw LlcpServiceSocket.convertErrorToLlcpException(n);
                throw new IOException();
            }
        }
        catch (RemoteException remoteException) {
            int n3 = Log.e(TAG, "RemoteException in accept(): ", remoteException);
            return null;
        }
        {
            ILlcpSocket iLlcpSocket = this.mLlcpSocketService;
            return new LlcpSocket(iLlcpSocket, n);
        }
    }

    public void close() {
        try {
            ILlcpServiceSocket iLlcpServiceSocket = this.mService;
            int n = this.mHandle;
            iLlcpServiceSocket.close(n);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "RemoteException in close(): ", remoteException);
            return;
        }
    }
}

