/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.nfc;

import android.nfc.ErrorCodes;
import android.nfc.ILlcpSocket;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.nfc.LlcpException;
import java.io.IOException;

public class LlcpSocket {
    private static final String TAG = "LlcpSocket";
    protected int mHandle;
    protected ILlcpSocket mService;

    public LlcpSocket(ILlcpSocket iLlcpSocket, int n) {
        this.mService = iLlcpSocket;
        this.mHandle = n;
    }

    static LlcpException convertErrorToLlcpException(int n) {
        return LlcpSocket.convertErrorToLlcpException(n, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    static LlcpException convertErrorToLlcpException(int n, String string2) {
        String string3 = string2 == null ? "" : " (" + string2 + ")";
        switch (n) {
            default: {
                String string4 = "Unkown error code " + n + string3;
                return new LlcpException(string4);
            }
            case -10: {
                String string5 = "Error during the creation of an Llcp socket" + string3;
                return new LlcpException(string5);
            }
            case -9: {
                String string6 = "Not enough ressources are available" + string3;
                return new LlcpException(string6);
            }
            case -11: 
        }
        String string7 = "Socket not connected to an Llcp Service" + string3;
        return new LlcpException(string7);
    }

    public void close() throws IOException {
        try {
            ILlcpSocket iLlcpSocket = this.mService;
            int n = this.mHandle;
            if (!ErrorCodes.isError(iLlcpSocket.close(n))) {
                return;
            }
            throw new IOException();
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "RemoteException in close(): ", remoteException);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(int n) throws IOException, LlcpException {
        try {
            ILlcpSocket iLlcpSocket = this.mService;
            int n2 = this.mHandle;
            int n3 = iLlcpSocket.connect(n2, n);
            if (!ErrorCodes.isError(n3)) {
                return;
            }
            if (n3 != -1) throw LlcpSocket.convertErrorToLlcpException(n3);
            throw new IOException();
        }
        catch (RemoteException remoteException) {
            int n4 = Log.e(TAG, "RemoteException in accept(): ", remoteException);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(String string2) throws IOException, LlcpException {
        try {
            ILlcpSocket iLlcpSocket = this.mService;
            int n = this.mHandle;
            int n2 = iLlcpSocket.connectByName(n, string2);
            if (!ErrorCodes.isError(n2)) {
                return;
            }
            if (n2 != -1) throw LlcpSocket.convertErrorToLlcpException(n2);
            throw new IOException();
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "RemoteException in accept(): ", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getLocalSap() {
        try {
            ILlcpSocket iLlcpSocket = this.mService;
            int n = this.mHandle;
            int n2 = iLlcpSocket.getLocalSap(n);
            return n2;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "RemoteException in getLocalSap(): ", remoteException);
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getLocalSocketMiu() {
        try {
            ILlcpSocket iLlcpSocket = this.mService;
            int n = this.mHandle;
            int n2 = iLlcpSocket.getLocalSocketMiu(n);
            return n2;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "RemoteException in getLocalSocketMiu(): ", remoteException);
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getLocalSocketRw() {
        try {
            ILlcpSocket iLlcpSocket = this.mService;
            int n = this.mHandle;
            int n2 = iLlcpSocket.getLocalSocketRw(n);
            return n2;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "RemoteException in getLocalSocketRw(): ", remoteException);
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getRemoteSocketMiu() throws LlcpException {
        try {
            ILlcpSocket iLlcpSocket = this.mService;
            int n = this.mHandle;
            int n2 = iLlcpSocket.getRemoteSocketMiu(n);
            if (n2 == 65525) throw LlcpSocket.convertErrorToLlcpException(n2);
            return n2;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "RemoteException in getRemoteSocketMiu(): ", remoteException);
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getRemoteSocketRw() throws LlcpException {
        try {
            ILlcpSocket iLlcpSocket = this.mService;
            int n = this.mHandle;
            int n2 = iLlcpSocket.getRemoteSocketRw(n);
            if (n2 == 65525) throw LlcpSocket.convertErrorToLlcpException(n2);
            return n2;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "RemoteException in getRemoteSocketRw(): ", remoteException);
            return 0;
        }
    }

    public int receive(byte[] byArray) throws IOException {
        int n;
        try {
            ILlcpSocket iLlcpSocket = this.mService;
            int n2 = this.mHandle;
            n = iLlcpSocket.receive(n2, byArray);
            if (n == 0) {
                throw new IOException();
            }
        }
        catch (RemoteException remoteException) {
            int n3 = Log.e(TAG, "RemoteException in receive(): ", remoteException);
        }
        return n;
    }

    public void send(byte[] byArray) throws IOException {
        try {
            ILlcpSocket iLlcpSocket = this.mService;
            int n = this.mHandle;
            if (!ErrorCodes.isError(iLlcpSocket.send(n, byArray))) {
                return;
            }
            throw new IOException();
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "RemoteException in send(): ", remoteException);
            return;
        }
    }
}

