/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.nfc;

import android.nfc.IP2pInitiator;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.nfc.P2pDevice;
import java.io.IOException;

public class P2pInitiator
extends P2pDevice {
    private static final String TAG = "P2pInitiator";
    private final IP2pInitiator mService;

    P2pInitiator(IP2pInitiator iP2pInitiator, int n) {
        this.mService = iP2pInitiator;
        this.mHandle = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] getGeneralBytes() {
        try {
            IP2pInitiator iP2pInitiator = this.mService;
            int n = this.mHandle;
            byte[] byArray = iP2pInitiator.getGeneralBytes(n);
            return byArray;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "RemoteException in getGeneralBytes(): ", remoteException);
            return null;
        }
    }

    @Override
    public int getMode() {
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] receive() throws IOException {
        try {
            IP2pInitiator iP2pInitiator = this.mService;
            int n = this.mHandle;
            byte[] byArray = iP2pInitiator.receive(n);
            if (byArray != null) return byArray;
            throw new IOException("Tag has been lost");
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "RemoteException in receive(): ", remoteException);
            return null;
        }
    }

    public void send(byte[] byArray) throws IOException {
        try {
            IP2pInitiator iP2pInitiator = this.mService;
            int n = this.mHandle;
            if (iP2pInitiator.send(n, byArray)) {
                return;
            }
            throw new IOException("Tag has been lost");
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "RemoteException in send(): ", remoteException);
            return;
        }
    }
}

