/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.nfc;

import android.nfc.ErrorCodes;
import android.nfc.IP2pTarget;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.nfc.NfcException;
import com.android.internal.nfc.P2pDevice;
import java.io.IOException;

public class P2pTarget
extends P2pDevice {
    private static final String TAG = "P2pTarget";
    private final boolean isClosed;
    private boolean isConnected = false;
    private final IP2pTarget mService;

    P2pTarget(IP2pTarget iP2pTarget, int n) {
        this.isClosed = false;
        this.mService = iP2pTarget;
        this.mHandle = n;
    }

    public void checkState() throws NfcException {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect() throws NfcException {
        this.checkState();
        if (this.isConnected) {
            throw new NfcException("Already connected");
        }
        try {
            IP2pTarget iP2pTarget = this.mService;
            int n = this.mHandle;
            int n2 = iP2pTarget.connect(n);
            if (ErrorCodes.isError(n2) && n2 == -1) {
                throw new NfcException("Failed to connect");
            }
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "RemoteException in connect(): ", remoteException);
            return;
        }
        boolean bl = true;
        {
            this.isConnected = bl;
            return;
        }
    }

    public void disconnect() throws NfcException {
        this.checkState();
        try {
            IP2pTarget iP2pTarget = this.mService;
            int n = this.mHandle;
            boolean bl = iP2pTarget.disconnect(n);
            this.isConnected = true;
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "RemoteException in disconnect(): ", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] getGeneralBytes() throws IOException {
        try {
            if (!this.isConnected) throw new IOException("Target not in connected state");
            IP2pTarget iP2pTarget = this.mService;
            int n = this.mHandle;
            return iP2pTarget.getGeneralBytes(n);
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "RemoteException in getGeneralBytes(): ", remoteException);
            return null;
        }
    }

    @Override
    public int getMode() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] transceive(byte[] byArray) throws IOException, NfcException {
        this.checkState();
        try {
            IP2pTarget iP2pTarget = this.mService;
            int n = this.mHandle;
            byte[] byArray2 = iP2pTarget.transceive(n, byArray);
            if (byArray2 != null) return byArray2;
            throw new IOException("Transceive failed");
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "RemoteException in transceive(): ", remoteException);
            return null;
        }
    }
}

