/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.FileUtils;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class AtomicFile {
    private final File mBackupName;
    private final File mBaseName;

    public AtomicFile(File file) {
        File file2;
        this.mBaseName = file;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = file.getPath();
        String string3 = stringBuilder.append(string2).append(".bak").toString();
        this.mBackupName = file2 = new File(string3);
    }

    public void failWrite(FileOutputStream fileOutputStream) {
        if (fileOutputStream == null) {
            return;
        }
        boolean bl = FileUtils.sync(fileOutputStream);
        try {
            fileOutputStream.close();
            boolean bl2 = this.mBaseName.delete();
            File file = this.mBackupName;
            File file2 = this.mBaseName;
            boolean bl3 = file.renameTo(file2);
            return;
        }
        catch (IOException iOException) {
            int n = Log.w("AtomicFile", "failWrite: Got exception:", iOException);
            return;
        }
    }

    public void finishWrite(FileOutputStream fileOutputStream) {
        if (fileOutputStream == null) {
            return;
        }
        boolean bl = FileUtils.sync(fileOutputStream);
        try {
            fileOutputStream.close();
            boolean bl2 = this.mBackupName.delete();
            return;
        }
        catch (IOException iOException) {
            int n = Log.w("AtomicFile", "finishWrite: Got exception:", iOException);
            return;
        }
    }

    public File getBaseFile() {
        return this.mBaseName;
    }

    public FileOutputStream openAppend() throws IOException {
        try {
            File file = this.mBaseName;
            FileOutputStream fileOutputStream = new FileOutputStream(file, true);
            return fileOutputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            StringBuilder stringBuilder = new StringBuilder().append("Couldn't append ");
            File file = this.mBaseName;
            String string2 = stringBuilder.append(file).toString();
            throw new IOException(string2);
        }
    }

    public FileInputStream openRead() throws FileNotFoundException {
        if (this.mBackupName.exists()) {
            boolean bl = this.mBaseName.delete();
            File file = this.mBackupName;
            File file2 = this.mBaseName;
            boolean bl2 = file.renameTo(file2);
        }
        File file = this.mBaseName;
        return new FileInputStream(file);
    }

    public byte[] readFully() throws IOException {
        int n;
        byte[] byArray;
        FileInputStream fileInputStream = this.openRead();
        int n2 = 0;
        try {
            byArray = new byte[fileInputStream.available()];
            while (true) {
                int n3;
                int n4;
                if ((n = (n4 = fileInputStream.read(byArray, n2, n3 = byArray.length - n2))) > 0) break block4;
                break;
            }
        }
        catch (Throwable throwable) {
            fileInputStream.close();
            throw throwable;
        }
        {
            int n5;
            block4: {
                fileInputStream.close();
                return byArray;
            }
            n2 += n;
            int n6 = fileInputStream.available();
            if (n6 <= (n5 = byArray.length - n2)) continue;
            byte[] byArray2 = new byte[n2 + n6];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byArray = byArray2;
            continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileOutputStream startWrite() throws IOException {
        if (this.mBaseName.exists()) {
            if (!this.mBackupName.exists()) {
                File file = this.mBaseName;
                File file2 = this.mBackupName;
                if (!file.renameTo(file2)) {
                    StringBuilder stringBuilder = new StringBuilder().append("Couldn't rename file ");
                    File file3 = this.mBaseName;
                    StringBuilder stringBuilder2 = stringBuilder.append(file3).append(" to backup file ");
                    File file4 = this.mBackupName;
                    String string2 = stringBuilder2.append(file4).toString();
                    int n = Log.w("AtomicFile", string2);
                }
            } else {
                boolean bl = this.mBaseName.delete();
            }
        }
        try {
            File file = this.mBaseName;
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            File file = this.mBaseName.getParentFile();
            if (!file.mkdir()) {
                StringBuilder stringBuilder = new StringBuilder().append("Couldn't create directory ");
                File file5 = this.mBaseName;
                String string3 = stringBuilder.append(file5).toString();
                throw new IOException(string3);
            }
            int n = FileUtils.setPermissions(file.getPath(), 505, -1, -1);
            try {
                File file6 = this.mBaseName;
                return new FileOutputStream(file6);
            }
            catch (FileNotFoundException fileNotFoundException2) {
                StringBuilder stringBuilder = new StringBuilder().append("Couldn't create ");
                File file7 = this.mBaseName;
                String string4 = stringBuilder.append(file7).toString();
                throw new IOException(string4);
            }
        }
    }

    public void truncate() throws IOException {
        try {
            File file = this.mBaseName;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            boolean bl = FileUtils.sync(fileOutputStream);
            fileOutputStream.close();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            StringBuilder stringBuilder = new StringBuilder().append("Couldn't append ");
            File file = this.mBaseName;
            String string2 = stringBuilder.append(file).toString();
            throw new IOException(string2);
        }
        catch (IOException iOException) {
            return;
        }
    }
}

