/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.bluetooth.BluetoothHeadset;
import android.net.TrafficStats;
import android.os.BatteryStats;
import android.os.FileUtils;
import android.os.Handler;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFormatException;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemClock;
import android.os.WorkSource;
import android.telephony.SignalStrength;
import android.util.Log;
import android.util.Printer;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.util.JournaledFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public final class BatteryStatsImpl
extends BatteryStats {
    private static final String BATCHED_WAKELOCK_NAME = "*overflow*";
    private static final int BATTERY_PLUGGED_NONE = 0;
    public static final Parcelable.Creator<BatteryStatsImpl> CREATOR;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_HISTORY = false;
    static final long DELAY_UPDATE_WAKELOCKS = 5000L;
    private static final int MAGIC = -1166707595;
    private static final int MAX_HISTORY_ITEMS = 2000;
    private static final int MAX_MAX_HISTORY_ITEMS = 3000;
    private static final int MAX_WAKELOCKS_PER_UID = 30;
    static final int MSG_REPORT_POWER_CHANGE = 2;
    static final int MSG_UPDATE_WAKELOCKS = 1;
    private static final int[] PROC_WAKELOCKS_FORMAT;
    private static final String TAG = "BatteryStatsImpl";
    private static final int VERSION = 52;
    private static int sKernelWakelockUpdateVersion;
    private static int sNumSpeedSteps;
    boolean mAudioOn;
    StopwatchTimer mAudioOnTimer;
    long mBatteryLastRealtime;
    long mBatteryLastUptime;
    long mBatteryRealtime;
    long mBatteryUptime;
    boolean mBluetoothOn;
    StopwatchTimer mBluetoothOnTimer;
    private int mBluetoothPingCount;
    private int mBluetoothPingStart;
    BluetoothHeadset mBtHeadset;
    private BatteryCallback mCallback;
    int mChangedStates;
    int mDischargeCurrentLevel;
    int mDischargeStartLevel;
    int mDischargeUnplugLevel;
    private final JournaledFile mFile;
    final ArrayList<StopwatchTimer> mFullTimers;
    final ArrayList<StopwatchTimer> mFullWifiLockTimers;
    boolean mGlobalWifiRunning;
    StopwatchTimer mGlobalWifiRunningTimer;
    int mGpsNesting;
    private final MyHandler mHandler;
    boolean mHaveBatteryLevel;
    int mHighDischargeAmountSinceCharge;
    BatteryStats.HistoryItem mHistory;
    long mHistoryBaseTime;
    BatteryStats.HistoryItem mHistoryCache;
    final BatteryStats.HistoryItem mHistoryCur;
    BatteryStats.HistoryItem mHistoryEnd;
    private BatteryStats.HistoryItem mHistoryIterator;
    BatteryStats.HistoryItem mHistoryLastEnd;
    Counter mInputEventCounter;
    private final HashMap<String, SamplingTimer> mKernelWakelockStats;
    final ArrayList<StopwatchTimer> mLastPartialTimers;
    long mLastRealtime;
    long mLastUptime;
    long mLastWriteTime;
    int mLowDischargeAmountSinceCharge;
    private long[] mMobileDataRx;
    private long[] mMobileDataTx;
    int mNumHistoryItems;
    boolean mOnBattery;
    boolean mOnBatteryInternal;
    final ArrayList<StopwatchTimer> mPartialTimers;
    Parcel mPendingWrite;
    int mPhoneDataConnectionType;
    final StopwatchTimer[] mPhoneDataConnectionsTimer;
    boolean mPhoneOn;
    StopwatchTimer mPhoneOnTimer;
    private int mPhoneServiceState;
    private int mPhoneServiceStateRaw;
    StopwatchTimer mPhoneSignalScanningTimer;
    int mPhoneSignalStrengthBin;
    int mPhoneSignalStrengthBinRaw;
    final StopwatchTimer[] mPhoneSignalStrengthsTimer;
    private int mPhoneSimStateRaw;
    private final Map<String, KernelWakelockStats> mProcWakelockFileStats;
    private final long[] mProcWakelocksData;
    private final String[] mProcWakelocksName;
    private long mRadioDataStart;
    private long mRadioDataUptime;
    long mRealtime;
    long mRealtimeStart;
    boolean mRecordingHistory;
    final ArrayList<StopwatchTimer> mScanWifiLockTimers;
    int mScreenBrightnessBin;
    final StopwatchTimer[] mScreenBrightnessTimer;
    boolean mScreenOn;
    StopwatchTimer mScreenOnTimer;
    int mSensorNesting;
    final SparseArray<ArrayList<StopwatchTimer>> mSensorTimers;
    boolean mShuttingDown;
    int mStartCount;
    private long[] mTotalDataRx;
    private long[] mTotalDataTx;
    long mTrackBatteryPastRealtime;
    long mTrackBatteryPastUptime;
    long mTrackBatteryRealtimeStart;
    long mTrackBatteryUptimeStart;
    private HashMap<String, Integer> mUidCache;
    final SparseArray<Uid> mUidStats;
    final ArrayList<Unpluggable> mUnpluggables;
    long mUnpluggedBatteryRealtime;
    long mUnpluggedBatteryUptime;
    long mUptime;
    long mUptimeStart;
    boolean mVideoOn;
    StopwatchTimer mVideoOnTimer;
    int mWakeLockNesting;
    int mWifiFullLockNesting;
    int mWifiMulticastNesting;
    final ArrayList<StopwatchTimer> mWifiMulticastTimers;
    boolean mWifiOn;
    StopwatchTimer mWifiOnTimer;
    int mWifiOnUid;
    final ArrayList<StopwatchTimer> mWifiRunningTimers;
    int mWifiScanLockNesting;
    final ArrayList<StopwatchTimer> mWindowTimers;
    final ReentrantLock mWriteLock;

    static {
        sKernelWakelockUpdateVersion = 0;
        PROC_WAKELOCKS_FORMAT = new int[]{4105, 8201, 9, 9, 9, 8201};
        CREATOR = new Parcelable.Creator<BatteryStatsImpl>(){

            @Override
            public BatteryStatsImpl createFromParcel(Parcel parcel) {
                return new BatteryStatsImpl(parcel);
            }

            public BatteryStatsImpl[] newArray(int n) {
                return new BatteryStatsImpl[n];
            }
        };
    }

    public BatteryStatsImpl() {
        ReentrantLock reentrantLock;
        BatteryStats.HistoryItem historyItem;
        SparseArray sparseArray = new SparseArray();
        this.mUidStats = sparseArray;
        ArrayList arrayList = new ArrayList();
        this.mPartialTimers = arrayList;
        ArrayList arrayList2 = new ArrayList();
        this.mFullTimers = arrayList2;
        ArrayList arrayList3 = new ArrayList();
        this.mWindowTimers = arrayList3;
        SparseArray sparseArray2 = new SparseArray();
        this.mSensorTimers = sparseArray2;
        ArrayList arrayList4 = new ArrayList();
        this.mWifiRunningTimers = arrayList4;
        ArrayList arrayList5 = new ArrayList();
        this.mFullWifiLockTimers = arrayList5;
        ArrayList arrayList6 = new ArrayList();
        this.mScanWifiLockTimers = arrayList6;
        ArrayList arrayList7 = new ArrayList();
        this.mWifiMulticastTimers = arrayList7;
        ArrayList arrayList8 = new ArrayList();
        this.mLastPartialTimers = arrayList8;
        ArrayList arrayList9 = new ArrayList();
        this.mUnpluggables = arrayList9;
        this.mHaveBatteryLevel = false;
        this.mRecordingHistory = true;
        this.mHistoryCur = historyItem = new BatteryStats.HistoryItem();
        this.mScreenBrightnessBin = -1;
        StopwatchTimer[] stopwatchTimerArray = new StopwatchTimer[5];
        this.mScreenBrightnessTimer = stopwatchTimerArray;
        this.mPhoneSignalStrengthBin = -1;
        this.mPhoneSignalStrengthBinRaw = -1;
        StopwatchTimer[] stopwatchTimerArray2 = new StopwatchTimer[5];
        this.mPhoneSignalStrengthsTimer = stopwatchTimerArray2;
        this.mPhoneDataConnectionType = -1;
        StopwatchTimer[] stopwatchTimerArray3 = new StopwatchTimer[14];
        this.mPhoneDataConnectionsTimer = stopwatchTimerArray3;
        this.mWifiOnUid = -1;
        this.mLastWriteTime = 0L;
        Object var16_16 = null;
        this.mMobileDataTx = var16_16;
        Object var17_17 = null;
        this.mMobileDataRx = var17_17;
        Object var18_18 = null;
        this.mTotalDataTx = var18_18;
        Object var19_19 = null;
        this.mTotalDataRx = var19_19;
        this.mBluetoothPingStart = -1;
        this.mPhoneServiceState = -1;
        this.mPhoneServiceStateRaw = -1;
        this.mPhoneSimStateRaw = -1;
        HashMap hashMap = new HashMap();
        this.mKernelWakelockStats = hashMap;
        String[] stringArray = new String[3];
        this.mProcWakelocksName = stringArray;
        Object var22_22 = null;
        this.mProcWakelocksData = var22_22;
        HashMap<String, KernelWakelockStats> hashMap2 = new HashMap<String, KernelWakelockStats>();
        this.mProcWakelockFileStats = hashMap2;
        HashMap hashMap3 = new HashMap();
        this.mUidCache = hashMap3;
        this.mChangedStates = 0;
        this.mWifiFullLockNesting = 0;
        this.mWifiScanLockNesting = 0;
        this.mWifiMulticastNesting = 0;
        this.mPendingWrite = null;
        this.mWriteLock = reentrantLock = new ReentrantLock();
        this.mFile = null;
        this.mHandler = null;
    }

    public BatteryStatsImpl(Parcel parcel) {
        ReentrantLock reentrantLock;
        BatteryStats.HistoryItem historyItem;
        SparseArray sparseArray = new SparseArray();
        this.mUidStats = sparseArray;
        ArrayList arrayList = new ArrayList();
        this.mPartialTimers = arrayList;
        ArrayList arrayList2 = new ArrayList();
        this.mFullTimers = arrayList2;
        ArrayList arrayList3 = new ArrayList();
        this.mWindowTimers = arrayList3;
        SparseArray sparseArray2 = new SparseArray();
        this.mSensorTimers = sparseArray2;
        ArrayList arrayList4 = new ArrayList();
        this.mWifiRunningTimers = arrayList4;
        ArrayList arrayList5 = new ArrayList();
        this.mFullWifiLockTimers = arrayList5;
        ArrayList arrayList6 = new ArrayList();
        this.mScanWifiLockTimers = arrayList6;
        ArrayList arrayList7 = new ArrayList();
        this.mWifiMulticastTimers = arrayList7;
        ArrayList arrayList8 = new ArrayList();
        this.mLastPartialTimers = arrayList8;
        ArrayList arrayList9 = new ArrayList();
        this.mUnpluggables = arrayList9;
        this.mHaveBatteryLevel = false;
        this.mRecordingHistory = true;
        this.mHistoryCur = historyItem = new BatteryStats.HistoryItem();
        this.mScreenBrightnessBin = -1;
        StopwatchTimer[] stopwatchTimerArray = new StopwatchTimer[5];
        this.mScreenBrightnessTimer = stopwatchTimerArray;
        this.mPhoneSignalStrengthBin = -1;
        this.mPhoneSignalStrengthBinRaw = -1;
        StopwatchTimer[] stopwatchTimerArray2 = new StopwatchTimer[5];
        this.mPhoneSignalStrengthsTimer = stopwatchTimerArray2;
        this.mPhoneDataConnectionType = -1;
        StopwatchTimer[] stopwatchTimerArray3 = new StopwatchTimer[14];
        this.mPhoneDataConnectionsTimer = stopwatchTimerArray3;
        this.mWifiOnUid = -1;
        this.mLastWriteTime = 0L;
        Object var17_17 = null;
        this.mMobileDataTx = var17_17;
        Object var18_18 = null;
        this.mMobileDataRx = var18_18;
        Object var19_19 = null;
        this.mTotalDataTx = var19_19;
        Object var20_20 = null;
        this.mTotalDataRx = var20_20;
        this.mBluetoothPingStart = -1;
        this.mPhoneServiceState = -1;
        this.mPhoneServiceStateRaw = -1;
        this.mPhoneSimStateRaw = -1;
        HashMap hashMap = new HashMap();
        this.mKernelWakelockStats = hashMap;
        String[] stringArray = new String[3];
        this.mProcWakelocksName = stringArray;
        Object var23_23 = null;
        this.mProcWakelocksData = var23_23;
        HashMap<String, KernelWakelockStats> hashMap2 = new HashMap<String, KernelWakelockStats>();
        this.mProcWakelockFileStats = hashMap2;
        HashMap hashMap3 = new HashMap();
        this.mUidCache = hashMap3;
        this.mChangedStates = 0;
        this.mWifiFullLockNesting = 0;
        this.mWifiScanLockNesting = 0;
        this.mWifiMulticastNesting = 0;
        this.mPendingWrite = null;
        this.mWriteLock = reentrantLock = new ReentrantLock();
        this.mFile = null;
        this.mHandler = null;
        this.readFromParcel(parcel);
    }

    public BatteryStatsImpl(String string2) {
        long l;
        long l2;
        long l3;
        long l4;
        StopwatchTimer stopwatchTimer;
        StopwatchTimer stopwatchTimer2;
        StopwatchTimer stopwatchTimer3;
        StopwatchTimer stopwatchTimer4;
        StopwatchTimer stopwatchTimer5;
        StopwatchTimer stopwatchTimer6;
        StopwatchTimer stopwatchTimer7;
        Counter counter;
        StopwatchTimer stopwatchTimer8;
        int n;
        MyHandler myHandler;
        JournaledFile journaledFile;
        ReentrantLock reentrantLock;
        BatteryStats.HistoryItem historyItem;
        SparseArray sparseArray = new SparseArray();
        this.mUidStats = sparseArray;
        ArrayList arrayList = new ArrayList();
        this.mPartialTimers = arrayList;
        ArrayList arrayList2 = new ArrayList();
        this.mFullTimers = arrayList2;
        ArrayList arrayList3 = new ArrayList();
        this.mWindowTimers = arrayList3;
        SparseArray sparseArray2 = new SparseArray();
        this.mSensorTimers = sparseArray2;
        ArrayList arrayList4 = new ArrayList();
        this.mWifiRunningTimers = arrayList4;
        ArrayList arrayList5 = new ArrayList();
        this.mFullWifiLockTimers = arrayList5;
        ArrayList arrayList6 = new ArrayList();
        this.mScanWifiLockTimers = arrayList6;
        ArrayList arrayList7 = new ArrayList();
        this.mWifiMulticastTimers = arrayList7;
        ArrayList arrayList8 = new ArrayList();
        this.mLastPartialTimers = arrayList8;
        ArrayList arrayList9 = new ArrayList();
        this.mUnpluggables = arrayList9;
        this.mHaveBatteryLevel = false;
        this.mRecordingHistory = true;
        this.mHistoryCur = historyItem = new BatteryStats.HistoryItem();
        this.mScreenBrightnessBin = -1;
        StopwatchTimer[] stopwatchTimerArray = new StopwatchTimer[5];
        this.mScreenBrightnessTimer = stopwatchTimerArray;
        this.mPhoneSignalStrengthBin = -1;
        this.mPhoneSignalStrengthBinRaw = -1;
        StopwatchTimer[] stopwatchTimerArray2 = new StopwatchTimer[5];
        this.mPhoneSignalStrengthsTimer = stopwatchTimerArray2;
        this.mPhoneDataConnectionType = -1;
        StopwatchTimer[] stopwatchTimerArray3 = new StopwatchTimer[14];
        this.mPhoneDataConnectionsTimer = stopwatchTimerArray3;
        this.mWifiOnUid = -1;
        this.mLastWriteTime = 0L;
        Object var17_17 = null;
        this.mMobileDataTx = var17_17;
        Object var18_18 = null;
        this.mMobileDataRx = var18_18;
        Object var19_19 = null;
        this.mTotalDataTx = var19_19;
        Object var20_20 = null;
        this.mTotalDataRx = var20_20;
        this.mBluetoothPingStart = -1;
        this.mPhoneServiceState = -1;
        this.mPhoneServiceStateRaw = -1;
        this.mPhoneSimStateRaw = -1;
        HashMap hashMap = new HashMap();
        this.mKernelWakelockStats = hashMap;
        String[] stringArray = new String[3];
        this.mProcWakelocksName = stringArray;
        Object var23_23 = null;
        this.mProcWakelocksData = var23_23;
        HashMap<String, KernelWakelockStats> hashMap2 = new HashMap<String, KernelWakelockStats>();
        this.mProcWakelockFileStats = hashMap2;
        HashMap hashMap3 = new HashMap();
        this.mUidCache = hashMap3;
        this.mChangedStates = 0;
        this.mWifiFullLockNesting = 0;
        this.mWifiScanLockNesting = 0;
        this.mWifiMulticastNesting = 0;
        this.mPendingWrite = null;
        this.mWriteLock = reentrantLock = new ReentrantLock();
        File file = new File(string2);
        String string3 = string2 + ".tmp";
        File file2 = new File(string3);
        this.mFile = journaledFile = new JournaledFile(file, file2);
        this.mHandler = myHandler = new MyHandler();
        this.mStartCount = n = this.mStartCount + 1;
        ArrayList<Unpluggable> arrayList10 = this.mUnpluggables;
        this.mScreenOnTimer = stopwatchTimer8 = new StopwatchTimer(null, -1, null, arrayList10);
        for (int i = 0; i < 5; ++i) {
            StopwatchTimer stopwatchTimer9;
            StopwatchTimer[] stopwatchTimerArray4 = this.mScreenBrightnessTimer;
            int n2 = 65436 - i;
            ArrayList<Unpluggable> arrayList11 = this.mUnpluggables;
            stopwatchTimerArray4[i] = stopwatchTimer9 = new StopwatchTimer(null, n2, null, arrayList11);
        }
        ArrayList<Unpluggable> arrayList12 = this.mUnpluggables;
        this.mInputEventCounter = counter = new Counter(arrayList12);
        ArrayList<Unpluggable> arrayList13 = this.mUnpluggables;
        this.mPhoneOnTimer = stopwatchTimer7 = new StopwatchTimer(null, -1, null, arrayList13);
        for (int i = 0; i < 5; ++i) {
            StopwatchTimer stopwatchTimer10;
            StopwatchTimer[] stopwatchTimerArray5 = this.mPhoneSignalStrengthsTimer;
            int n3 = 65336 - i;
            ArrayList<Unpluggable> arrayList14 = this.mUnpluggables;
            stopwatchTimerArray5[i] = stopwatchTimer10 = new StopwatchTimer(null, n3, null, arrayList14);
        }
        ArrayList<Unpluggable> arrayList15 = this.mUnpluggables;
        this.mPhoneSignalScanningTimer = stopwatchTimer6 = new StopwatchTimer(null, 65337, null, arrayList15);
        for (int i = 0; i < 14; ++i) {
            StopwatchTimer stopwatchTimer11;
            StopwatchTimer[] stopwatchTimerArray6 = this.mPhoneDataConnectionsTimer;
            int n4 = 65236 - i;
            ArrayList<Unpluggable> arrayList16 = this.mUnpluggables;
            stopwatchTimerArray6[i] = stopwatchTimer11 = new StopwatchTimer(null, n4, null, arrayList16);
        }
        ArrayList<Unpluggable> arrayList17 = this.mUnpluggables;
        this.mWifiOnTimer = stopwatchTimer5 = new StopwatchTimer(null, -1, null, arrayList17);
        ArrayList<Unpluggable> arrayList18 = this.mUnpluggables;
        this.mGlobalWifiRunningTimer = stopwatchTimer4 = new StopwatchTimer(null, -1, null, arrayList18);
        ArrayList<Unpluggable> arrayList19 = this.mUnpluggables;
        this.mBluetoothOnTimer = stopwatchTimer3 = new StopwatchTimer(null, -1, null, arrayList19);
        ArrayList<Unpluggable> arrayList20 = this.mUnpluggables;
        this.mAudioOnTimer = stopwatchTimer2 = new StopwatchTimer(null, -1, null, arrayList20);
        ArrayList<Unpluggable> arrayList21 = this.mUnpluggables;
        this.mVideoOnTimer = stopwatchTimer = new StopwatchTimer(null, -1, null, arrayList21);
        this.mOnBatteryInternal = false;
        this.mOnBattery = false;
        this.initTimes();
        this.mTrackBatteryPastUptime = 0L;
        this.mTrackBatteryPastRealtime = 0L;
        this.mTrackBatteryUptimeStart = l4 = SystemClock.uptimeMillis() * 1000L;
        this.mUptimeStart = l4;
        this.mTrackBatteryRealtimeStart = l3 = SystemClock.elapsedRealtime() * 1000L;
        this.mRealtimeStart = l3;
        long l5 = this.mUptimeStart;
        this.mUnpluggedBatteryUptime = l2 = this.getBatteryUptimeLocked(l5);
        long l6 = this.mRealtimeStart;
        this.mUnpluggedBatteryRealtime = l = this.getBatteryRealtimeLocked(l6);
        this.mDischargeStartLevel = 0;
        this.mDischargeUnplugLevel = 0;
        this.mDischargeCurrentLevel = 0;
        this.mLowDischargeAmountSinceCharge = 0;
        this.mHighDischargeAmountSinceCharge = 0;
    }

    private void doDataPlug(long[] lArray, long l) {
        long l2;
        lArray[1] = l2 = lArray[3];
        lArray[3] = 65535L;
    }

    private void doDataUnplug(long[] lArray, long l) {
        lArray[3] = l;
    }

    private int fixPhoneServiceState(int n, int n2) {
        if (this.mPhoneSimStateRaw == 1 && n == 1 && n2 > 0) {
            n = 0;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getCurrentBluetoothPingCount() {
        if (this.mBtHeadset == null) return -1;
        return this.mBtHeadset.getBatteryUsageHint();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getCurrentRadioDataUptime() {
        try {
            File file = new File("/sys/devices/virtual/net/rmnet0/awake_time_ms");
            if (!file.exists()) {
                return 0L;
            }
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string2 = bufferedReader.readLine();
            bufferedReader.close();
            long l = Long.parseLong(string2);
            return l * 1000L;
        }
        catch (IOException iOException) {
            return 0L;
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getTcpBytes(long l, long[] lArray, int n) {
        if (n == 1) {
            return lArray[1];
        }
        if (n == 3) {
            if (lArray[3] < 0L) {
                return lArray[1];
            }
            long l2 = lArray[3];
            return l - l2;
        }
        if (n == 0) {
            long l3 = lArray[2];
            long l4 = l - l3;
            long l5 = lArray[0];
            return l4 + l5;
        }
        long l6 = lArray[2];
        return l - l6;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Map<String, KernelWakelockStats> parseProcWakelocks(byte[] byArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 0;
        while ((n4 = ++n6) < (n3 = n) && byArray[n6] != 10 && byArray[n6] != null) {
        }
        int n7 = n2 = n6 + 1;
        synchronized (this) {
            int n8;
            int n9;
            int n10;
            Map<String, KernelWakelockStats> map = this.mProcWakelockFileStats;
            ++sKernelWakelockUpdateVersion;
            while ((n10 = n2) < (n9 = n)) {
                int n11;
                int n12;
                int n13;
                int n14;
                int n15;
                n2 = n7;
                while ((n15 = ++n2) < (n14 = n) && byArray[n2] != 10 && byArray[n2] != null) {
                }
                int n16 = n;
                if ((n13 = n2++) < n16) {
                    // empty if block
                }
                String[] stringArray = this.mProcWakelocksName;
                long[] lArray = this.mProcWakelocksData;
                int n17 = n7;
                while ((n12 = ++n17) < (n11 = n2)) {
                    if ((byArray[n17] & 0x80) == 0) continue;
                    byArray[n17] = 63;
                }
                int[] nArray = PROC_WAKELOCKS_FORMAT;
                boolean bl = Process.parseProcLine(byArray, n7, n2, nArray, stringArray, lArray, null);
                String string2 = stringArray[0];
                int n18 = (int)lArray[1];
                long l = (lArray[2] + 500L) / 1000L;
                if (bl && string2.length() > 0) {
                    if (!map.containsKey(string2)) {
                        int n19 = sKernelWakelockUpdateVersion;
                        BatteryStatsImpl batteryStatsImpl = this;
                        KernelWakelockStats kernelWakelockStats = batteryStatsImpl.new KernelWakelockStats(n18, l, n19);
                        Map<String, KernelWakelockStats> map2 = map;
                        String string3 = string2;
                        KernelWakelockStats kernelWakelockStats2 = kernelWakelockStats;
                        KernelWakelockStats kernelWakelockStats3 = map2.put(string3, kernelWakelockStats2);
                        ++n5;
                    } else {
                        KernelWakelockStats kernelWakelockStats = map.get(string2);
                        int n20 = kernelWakelockStats.mVersion;
                        int n21 = sKernelWakelockUpdateVersion;
                        if (n20 != n21) {
                            long l2;
                            int n22;
                            kernelWakelockStats.mCount = n22 = kernelWakelockStats.mCount + n18;
                            kernelWakelockStats.mTotalTime = l2 = kernelWakelockStats.mTotalTime + l;
                        } else {
                            int n23;
                            long l3;
                            int n24;
                            kernelWakelockStats.mCount = n24 = n18;
                            kernelWakelockStats.mTotalTime = l3 = l;
                            kernelWakelockStats.mVersion = n23 = sKernelWakelockUpdateVersion;
                            ++n5;
                        }
                    }
                }
                n7 = n2;
            }
            int n25 = map.size();
            if (n25 != (n8 = n5)) {
                Iterator<KernelWakelockStats> iterator = map.values().iterator();
                while (iterator.hasNext()) {
                    int n26 = iterator.next().mVersion;
                    int n27 = sKernelWakelockUpdateVersion;
                    if (n26 == n27) continue;
                    iterator.remove();
                }
            }
            return map;
        }
    }

    static byte[] readFully(FileInputStream fileInputStream) throws IOException {
        int n = 0;
        byte[] byArray = new byte[fileInputStream.available()];
        int n2;
        int n3;
        while ((n3 = fileInputStream.read(byArray, n, n2 = byArray.length - n)) > 0) {
            int n4;
            int n5 = fileInputStream.available();
            if (n5 <= (n4 = byArray.length - (n += n3))) continue;
            byte[] byArray2 = new byte[n + n5];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            byArray = byArray2;
        }
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Map<String, KernelWakelockStats> readKernelWakelockStats() {
        byte[] byArray = new byte[4096];
        try {
            FileInputStream fileInputStream = new FileInputStream("/proc/wakelocks");
            int n = fileInputStream.read(byArray);
            fileInputStream.close();
            if (n <= 0) return this.parseProcWakelocks(byArray, n);
            int n2 = 0;
            while (n2 < n) {
                byte by = byArray[n2];
                if (by == null) {
                    n = n2;
                    return this.parseProcWakelocks(byArray, n);
                }
                ++n2;
            }
            return this.parseProcWakelocks(byArray, n);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void readSummaryFromParcel(Parcel parcel) {
        int n;
        int n2;
        boolean bl;
        boolean bl2;
        boolean bl3;
        int n3;
        int n4;
        int n5;
        int n6;
        boolean bl4;
        int n7;
        int n8;
        boolean bl5;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        long l;
        long l2;
        long l3;
        long l4;
        int n14;
        int n15;
        int n16 = parcel.readInt();
        int n17 = n16;
        if (n17 != (n15 = 52)) {
            StringBuilder stringBuilder = new StringBuilder().append("readFromParcel: version got ");
            int n18 = n16;
            String string2 = stringBuilder.append(n18).append(", expected ").append(52).append("; erasing old stats").toString();
            int n19 = Slog.w("BatteryStats", string2);
            return;
        }
        this.readHistory(parcel);
        this.mStartCount = n14 = parcel.readInt();
        this.mBatteryUptime = l4 = parcel.readLong();
        this.mBatteryRealtime = l3 = parcel.readLong();
        this.mUptime = l2 = parcel.readLong();
        this.mRealtime = l = parcel.readLong();
        this.mDischargeUnplugLevel = n13 = parcel.readInt();
        this.mDischargeCurrentLevel = n12 = parcel.readInt();
        this.mLowDischargeAmountSinceCharge = n11 = parcel.readInt();
        this.mHighDischargeAmountSinceCharge = n10 = parcel.readInt();
        this.mStartCount = n9 = this.mStartCount + 1;
        this.mScreenOn = bl5 = false;
        StopwatchTimer stopwatchTimer = this.mScreenOnTimer;
        Parcel parcel2 = parcel;
        stopwatchTimer.readSummaryFromParcelLocked(parcel2);
        int n20 = 0;
        while ((n8 = ++n20) < (n7 = 5)) {
            StopwatchTimer stopwatchTimer2 = this.mScreenBrightnessTimer[n20];
            Parcel parcel3 = parcel;
            stopwatchTimer2.readSummaryFromParcelLocked(parcel3);
        }
        Counter counter = this.mInputEventCounter;
        Parcel parcel4 = parcel;
        counter.readSummaryFromParcelLocked(parcel4);
        this.mPhoneOn = bl4 = false;
        StopwatchTimer stopwatchTimer3 = this.mPhoneOnTimer;
        Parcel parcel5 = parcel;
        stopwatchTimer3.readSummaryFromParcelLocked(parcel5);
        int n21 = 0;
        while ((n6 = ++n21) < (n5 = 5)) {
            StopwatchTimer stopwatchTimer4 = this.mPhoneSignalStrengthsTimer[n21];
            Parcel parcel6 = parcel;
            stopwatchTimer4.readSummaryFromParcelLocked(parcel6);
        }
        StopwatchTimer stopwatchTimer5 = this.mPhoneSignalScanningTimer;
        Parcel parcel7 = parcel;
        stopwatchTimer5.readSummaryFromParcelLocked(parcel7);
        int n22 = 0;
        while ((n4 = ++n22) < (n3 = 14)) {
            StopwatchTimer stopwatchTimer6 = this.mPhoneDataConnectionsTimer[n22];
            Parcel parcel8 = parcel;
            stopwatchTimer6.readSummaryFromParcelLocked(parcel8);
        }
        this.mWifiOn = bl3 = false;
        StopwatchTimer stopwatchTimer7 = this.mWifiOnTimer;
        Parcel parcel9 = parcel;
        stopwatchTimer7.readSummaryFromParcelLocked(parcel9);
        this.mGlobalWifiRunning = bl2 = false;
        StopwatchTimer stopwatchTimer8 = this.mGlobalWifiRunningTimer;
        Parcel parcel10 = parcel;
        stopwatchTimer8.readSummaryFromParcelLocked(parcel10);
        this.mBluetoothOn = bl = false;
        StopwatchTimer stopwatchTimer9 = this.mBluetoothOnTimer;
        Parcel parcel11 = parcel;
        stopwatchTimer9.readSummaryFromParcelLocked(parcel11);
        int n23 = n2 = parcel.readInt();
        int n24 = 10000;
        if (n23 > n24) {
            StringBuilder stringBuilder = new StringBuilder().append("File corrupt: too many kernel wake locks ");
            int n25 = n2;
            String string3 = stringBuilder.append(n25).toString();
            int n26 = Slog.w(TAG, string3);
            return;
        }
        for (int i = 0; i < n2; ++i) {
            if (parcel.readInt() == 0) continue;
            String string4 = parcel.readString();
            BatteryStatsImpl batteryStatsImpl = this;
            String string5 = string4;
            SamplingTimer samplingTimer = batteryStatsImpl.getKernelWakelockTimerLocked(string5);
            Parcel parcel12 = parcel;
            samplingTimer.readSummaryFromParcelLocked(parcel12);
        }
        sNumSpeedSteps = parcel.readInt();
        int n27 = parcel.readInt();
        int n28 = n27;
        if (n28 > (n = 10000)) {
            StringBuilder stringBuilder = new StringBuilder().append("File corrupt: too many uids ");
            int n29 = n27;
            String string6 = stringBuilder.append(n29).toString();
            int n30 = Slog.w(TAG, string6);
            return;
        }
        int n31 = 0;
        while (n31 < n27) {
            long l5;
            long l6;
            int n32;
            int n33;
            int n34;
            int n35;
            int n36;
            int n37;
            int n38;
            int n39;
            boolean bl6;
            boolean bl7;
            boolean bl8;
            boolean bl9;
            boolean bl10;
            boolean bl11;
            Uid uid;
            int n40 = parcel.readInt();
            Uid uid2 = uid;
            BatteryStatsImpl batteryStatsImpl = this;
            int n41 = n40;
            uid2(n41);
            SparseArray<Uid> sparseArray = this.mUidStats;
            int n42 = n40;
            Uid uid3 = uid;
            sparseArray.put(n42, uid3);
            uid.mWifiRunning = bl11 = false;
            if (parcel.readInt() != 0) {
                StopwatchTimer stopwatchTimer10 = uid.mWifiRunningTimer;
                Parcel parcel13 = parcel;
                stopwatchTimer10.readSummaryFromParcelLocked(parcel13);
            }
            uid.mFullWifiLockOut = bl10 = false;
            if (parcel.readInt() != 0) {
                StopwatchTimer stopwatchTimer11 = uid.mFullWifiLockTimer;
                Parcel parcel14 = parcel;
                stopwatchTimer11.readSummaryFromParcelLocked(parcel14);
            }
            uid.mScanWifiLockOut = bl9 = false;
            if (parcel.readInt() != 0) {
                StopwatchTimer stopwatchTimer12 = uid.mScanWifiLockTimer;
                Parcel parcel15 = parcel;
                stopwatchTimer12.readSummaryFromParcelLocked(parcel15);
            }
            uid.mWifiMulticastEnabled = bl8 = false;
            if (parcel.readInt() != 0) {
                StopwatchTimer stopwatchTimer13 = uid.mWifiMulticastTimer;
                Parcel parcel16 = parcel;
                stopwatchTimer13.readSummaryFromParcelLocked(parcel16);
            }
            uid.mAudioTurnedOn = bl7 = false;
            if (parcel.readInt() != 0) {
                StopwatchTimer stopwatchTimer14 = uid.mAudioTurnedOnTimer;
                Parcel parcel17 = parcel;
                stopwatchTimer14.readSummaryFromParcelLocked(parcel17);
            }
            uid.mVideoTurnedOn = bl6 = false;
            if (parcel.readInt() != 0) {
                StopwatchTimer stopwatchTimer15 = uid.mVideoTurnedOnTimer;
                Parcel parcel18 = parcel;
                stopwatchTimer15.readSummaryFromParcelLocked(parcel18);
            }
            if (parcel.readInt() != 0) {
                int n43;
                int n44;
                if (uid.mUserActivityCounters == null) {
                    uid.initUserActivityLocked();
                }
                n22 = 0;
                while ((n44 = ++n22) < (n43 = 7)) {
                    Counter counter2 = uid.mUserActivityCounters[n22];
                    Parcel parcel19 = parcel;
                    counter2.readSummaryFromParcelLocked(parcel19);
                }
            }
            if ((n39 = (n38 = parcel.readInt())) > (n37 = 100)) {
                StringBuilder stringBuilder = new StringBuilder().append("File corrupt: too many wake locks ");
                int n45 = n38;
                String string7 = stringBuilder.append(n45).toString();
                int n46 = Slog.w(TAG, string7);
                return;
            }
            for (int i = 0; i < n38; ++i) {
                String string8 = parcel.readString();
                if (parcel.readInt() != 0) {
                    Uid uid4 = uid;
                    String string9 = string8;
                    int n47 = 1;
                    StopwatchTimer stopwatchTimer16 = uid4.getWakeTimerLocked(string9, n47);
                    Parcel parcel20 = parcel;
                    stopwatchTimer16.readSummaryFromParcelLocked(parcel20);
                }
                if (parcel.readInt() != 0) {
                    Uid uid5 = uid;
                    String string10 = string8;
                    int n48 = 0;
                    StopwatchTimer stopwatchTimer17 = uid5.getWakeTimerLocked(string10, n48);
                    Parcel parcel21 = parcel;
                    stopwatchTimer17.readSummaryFromParcelLocked(parcel21);
                }
                if (parcel.readInt() == 0) continue;
                Uid uid6 = uid;
                String string11 = string8;
                int n49 = 2;
                StopwatchTimer stopwatchTimer18 = uid6.getWakeTimerLocked(string11, n49);
                Parcel parcel22 = parcel;
                stopwatchTimer18.readSummaryFromParcelLocked(parcel22);
            }
            int n50 = parcel.readInt();
            int n51 = n50;
            if (n51 > (n36 = 1000)) {
                StringBuilder stringBuilder = new StringBuilder().append("File corrupt: too many sensors ");
                int n52 = n50;
                String string12 = stringBuilder.append(n52).toString();
                int n53 = Slog.w(TAG, string12);
                return;
            }
            for (n35 = 0; n35 < n50; ++n35) {
                int n54 = parcel.readInt();
                if (parcel.readInt() == 0) continue;
                Uid uid7 = uid;
                int n55 = n54;
                boolean bl12 = true;
                StopwatchTimer stopwatchTimer19 = uid7.getSensorTimerLocked(n55, bl12);
                Parcel parcel23 = parcel;
                stopwatchTimer19.readSummaryFromParcelLocked(parcel23);
            }
            n50 = parcel.readInt();
            int n56 = n50;
            if (n56 > (n34 = 1000)) {
                StringBuilder stringBuilder = new StringBuilder().append("File corrupt: too many processes ");
                int n57 = n50;
                String string13 = stringBuilder.append(n57).toString();
                int n58 = Slog.w(TAG, string13);
                return;
            }
            for (n33 = 0; n33 < n50; ++n33) {
                int n59;
                int n60;
                int n61;
                int n62;
                long l7;
                long l8;
                long l9;
                long l10;
                long l11;
                long l12;
                String string14 = parcel.readString();
                Uid uid8 = uid;
                String string15 = string14;
                Uid.Proc proc = uid8.getProcessStatsLocked(string15);
                proc.mLoadedUserTime = l12 = (l11 = parcel.readLong());
                proc.mUserTime = l10 = l11;
                proc.mLoadedSystemTime = l9 = (l8 = parcel.readLong());
                proc.mSystemTime = l7 = l8;
                proc.mLoadedStarts = n62 = (n61 = parcel.readInt());
                proc.mStarts = n60 = n61;
                int n63 = parcel.readInt();
                int n64 = n63;
                if (n64 > (n59 = 100)) {
                    StringBuilder stringBuilder = new StringBuilder().append("File corrupt: too many speed bins ");
                    int n65 = n63;
                    String string16 = stringBuilder.append(n65).toString();
                    int n66 = Slog.w(TAG, string16);
                    return;
                }
                SamplingCounter[] samplingCounterArray = new SamplingCounter[n63];
                proc.mSpeedBins = samplingCounterArray;
                n22 = 0;
                while (n22 < n63) {
                    if (parcel.readInt() != 0) {
                        SamplingCounter samplingCounter;
                        SamplingCounter[] samplingCounterArray2 = proc.mSpeedBins;
                        ArrayList<Unpluggable> arrayList = this.mUnpluggables;
                        samplingCounterArray2[n22] = samplingCounter = new SamplingCounter(arrayList);
                        SamplingCounter samplingCounter2 = proc.mSpeedBins[n22];
                        Parcel parcel24 = parcel;
                        samplingCounter2.readSummaryFromParcelLocked(parcel24);
                    }
                    int n67 = n22 + 1;
                }
                Uid.Proc proc2 = proc;
                Parcel parcel25 = parcel;
                if (proc2.readExcessivePowerFromParcelLocked(parcel25)) continue;
                return;
            }
            n50 = parcel.readInt();
            int n68 = n50;
            if (n68 > (n32 = 10000)) {
                StringBuilder stringBuilder = new StringBuilder().append("File corrupt: too many packages ");
                int n69 = n50;
                String string17 = stringBuilder.append(n69).toString();
                int n70 = Slog.w(TAG, string17);
                return;
            }
            for (n33 = 0; n33 < n50; ++n33) {
                int n71;
                int n72;
                int n73;
                int n74;
                String string18 = parcel.readString();
                Uid uid9 = uid;
                String string19 = string18;
                Uid.Pkg pkg = uid9.getPackageStatsLocked(string19);
                pkg.mLoadedWakeups = n74 = (n73 = parcel.readInt());
                pkg.mWakeups = n72 = n73;
                int n75 = parcel.readInt();
                int n76 = n75;
                if (n76 > (n71 = 1000)) {
                    StringBuilder stringBuilder = new StringBuilder().append("File corrupt: too many services ");
                    int n77 = n75;
                    String string20 = stringBuilder.append(n77).toString();
                    int n78 = Slog.w(TAG, string20);
                    return;
                }
                n35 = 0;
                while (n35 < n75) {
                    int n79;
                    int n80;
                    int n81;
                    int n82;
                    int n83;
                    int n84;
                    long l13;
                    long l14;
                    long l15;
                    String string21 = parcel.readString();
                    Uid uid10 = uid;
                    String string22 = string18;
                    String string23 = string21;
                    Uid.Pkg.Serv serv = uid10.getServiceStatsLocked(string22, string23);
                    serv.mLoadedStartTime = l15 = (l14 = parcel.readLong());
                    serv.mStartTime = l13 = l14;
                    serv.mLoadedStarts = n84 = (n83 = parcel.readInt());
                    serv.mStarts = n82 = n83;
                    serv.mLoadedLaunches = n81 = (n80 = parcel.readInt());
                    serv.mLaunches = n79 = n80;
                    int n85 = n35 + 1;
                }
            }
            uid.mLoadedTcpBytesReceived = l6 = parcel.readLong();
            uid.mLoadedTcpBytesSent = l5 = parcel.readLong();
            ++n31;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateAllPhoneStateLocked(int n, int n2, int n3) {
        boolean bl = false;
        boolean bl2 = false;
        this.mPhoneServiceStateRaw = n;
        this.mPhoneSimStateRaw = n2;
        this.mPhoneSignalStrengthBinRaw = n3;
        if (n2 == 1 && n == 1 && n3 > 0) {
            n = 0;
        }
        if (n == 3) {
            n3 = -1;
        } else if (n != 0 && n == 1) {
            bl = true;
            n3 = 0;
            if (!this.mPhoneSignalScanningTimer.isRunningLocked()) {
                int n4;
                BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                historyItem.states = n4 = historyItem.states | 0x4000000;
                bl2 = true;
                this.mPhoneSignalScanningTimer.startRunningLocked(this);
            }
        }
        if (!bl && this.mPhoneSignalScanningTimer.isRunningLocked()) {
            int n5;
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = n5 = historyItem.states & 0xFBFFFFFF;
            bl2 = true;
            this.mPhoneSignalScanningTimer.stopRunningLocked(this);
        }
        if (this.mPhoneServiceState != n) {
            int n6;
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            int n7 = this.mHistoryCur.states & 0xFFFFF0FF;
            int n8 = n << 8;
            historyItem.states = n6 = n7 | n8;
            bl2 = true;
            this.mPhoneServiceState = n;
        }
        if (this.mPhoneSignalStrengthBin != n3) {
            if (this.mPhoneSignalStrengthBin >= 0) {
                StopwatchTimer[] stopwatchTimerArray = this.mPhoneSignalStrengthsTimer;
                int n9 = this.mPhoneSignalStrengthBin;
                stopwatchTimerArray[n9].stopRunningLocked(this);
            }
            if (n3 >= 0) {
                int n10;
                if (!this.mPhoneSignalStrengthsTimer[n3].isRunningLocked()) {
                    this.mPhoneSignalStrengthsTimer[n3].startRunningLocked(this);
                }
                BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                int n11 = this.mHistoryCur.states & 0xFFFFFF0F;
                int n12 = n3 << 4;
                historyItem.states = n10 = n11 | n12;
                bl2 = true;
            } else {
                this.stopAllSignalStrengthTimersLocked(-1);
            }
            this.mPhoneSignalStrengthBin = n3;
        }
        if (!bl2) {
            return;
        }
        long l = SystemClock.elapsedRealtime();
        this.addHistoryRecordLocked(l);
    }

    void addHistoryRecordLocked(long l) {
        byte by;
        byte by2;
        int n;
        int n2;
        int n3;
        int n4;
        long l2;
        long l3;
        if (!this.mHaveBatteryLevel) {
            return;
        }
        if (!this.mRecordingHistory) {
            return;
        }
        if (this.mHistoryEnd != null && this.mHistoryEnd.cmd == null && (l3 = this.mHistoryBaseTime + l) < (l2 = this.mHistoryEnd.time + 2000L) && ((n4 = (n3 = this.mHistoryEnd.states) ^ (n2 = this.mHistoryCur.states)) & (n = this.mChangedStates)) == 0) {
            int n5;
            BatteryStats.HistoryItem historyItem;
            BatteryStats.HistoryItem historyItem2;
            if (this.mHistoryLastEnd != null && this.mHistoryLastEnd.cmd == null && (historyItem2 = this.mHistoryLastEnd).same(historyItem = this.mHistoryCur)) {
                BatteryStats.HistoryItem historyItem3;
                BatteryStats.HistoryItem historyItem4;
                BatteryStats.HistoryItem historyItem5;
                this.mHistoryLastEnd.next = null;
                BatteryStats.HistoryItem historyItem6 = this.mHistoryEnd;
                historyItem6.next = historyItem5 = this.mHistoryCache;
                this.mHistoryCache = historyItem4 = this.mHistoryEnd;
                this.mHistoryEnd = historyItem3 = this.mHistoryLastEnd;
                this.mHistoryLastEnd = null;
                return;
            }
            int n6 = this.mChangedStates;
            int n7 = this.mHistoryEnd.states;
            int n8 = this.mHistoryCur.states;
            int n9 = n7 ^ n8;
            this.mChangedStates = n5 = n6 | n9;
            BatteryStats.HistoryItem historyItem7 = this.mHistoryEnd;
            long l4 = this.mHistoryEnd.time;
            BatteryStats.HistoryItem historyItem8 = this.mHistoryCur;
            historyItem7.setTo(l4, (byte)0, historyItem8);
            return;
        }
        this.mChangedStates = 0;
        if (this.mNumHistoryItems == 2000 || this.mNumHistoryItems == 3000) {
            this.addHistoryRecordLocked(l, (byte)2);
        }
        if (this.mNumHistoryItems >= 2000 && this.mHistoryEnd != null && (by2 = this.mHistoryEnd.batteryLevel) != (by = this.mHistoryCur.batteryLevel)) {
            if (this.mNumHistoryItems >= 3000) {
                return;
            }
            int n10 = this.mHistoryEnd.states;
            int n11 = this.mHistoryCur.states;
            if (((n10 ^ n11) & 0x78000000) == 0) {
                return;
            }
        }
        this.addHistoryRecordLocked(l, (byte)0);
    }

    /*
     * Enabled aggressive block sorting
     */
    void addHistoryRecordLocked(long l, byte by) {
        BatteryStats.HistoryItem historyItem = this.mHistoryCache;
        if (historyItem != null) {
            BatteryStats.HistoryItem historyItem2;
            this.mHistoryCache = historyItem2 = historyItem.next;
        } else {
            historyItem = new BatteryStats.HistoryItem();
        }
        long l2 = this.mHistoryBaseTime + l;
        BatteryStats.HistoryItem historyItem3 = this.mHistoryCur;
        historyItem.setTo(l2, by, historyItem3);
        this.addHistoryRecordLocked(historyItem);
    }

    void addHistoryRecordLocked(BatteryStats.HistoryItem historyItem) {
        BatteryStats.HistoryItem historyItem2;
        int n;
        this.mNumHistoryItems = n = this.mNumHistoryItems + 1;
        historyItem.next = null;
        this.mHistoryLastEnd = historyItem2 = this.mHistoryEnd;
        if (this.mHistoryEnd != null) {
            this.mHistoryEnd.next = historyItem;
            this.mHistoryEnd = historyItem;
            return;
        }
        this.mHistoryEnd = historyItem;
        this.mHistory = historyItem;
    }

    void clearHistoryLocked() {
        if (this.mHistory != null) {
            BatteryStats.HistoryItem historyItem;
            BatteryStats.HistoryItem historyItem2;
            BatteryStats.HistoryItem historyItem3 = this.mHistoryEnd;
            historyItem3.next = historyItem2 = this.mHistoryCache;
            this.mHistoryCache = historyItem = this.mHistory;
            this.mHistoryEnd = null;
            this.mHistoryLastEnd = null;
            this.mHistory = null;
        }
        this.mNumHistoryItems = 0;
        this.mHistoryBaseTime = 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commitPendingDataToDisk() {
        ReentrantLock reentrantLock;
        Parcel parcel;
        synchronized (this) {
            parcel = this.mPendingWrite;
            this.mPendingWrite = null;
            if (parcel == null) {
                return;
            }
            this.mWriteLock.lock();
        }
        try {
            File file = this.mFile.chooseForWrite();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = parcel.marshall();
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            boolean bl = FileUtils.sync(fileOutputStream);
            fileOutputStream.close();
            this.mFile.commit();
            parcel.recycle();
            reentrantLock = this.mWriteLock;
        }
        catch (IOException iOException) {
            try {
                int n = Slog.w("BatteryStats", "Error writing battery statistics", iOException);
                this.mFile.rollback();
                parcel.recycle();
                reentrantLock = this.mWriteLock;
            }
            catch (Throwable throwable) {
                parcel.recycle();
                this.mWriteLock.unlock();
                throw throwable;
            }
        }
        reentrantLock.unlock();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long computeBatteryRealtime(long l, int n) {
        switch (n) {
            default: {
                return 0L;
            }
            case 0: {
                long l2 = this.mBatteryRealtime;
                long l3 = this.getBatteryRealtimeLocked(l);
                return l2 + l3;
            }
            case 1: {
                return this.mBatteryLastRealtime;
            }
            case 2: {
                return this.getBatteryRealtimeLocked(l);
            }
            case 3: 
        }
        long l4 = this.getBatteryRealtimeLocked(l);
        long l5 = this.mUnpluggedBatteryRealtime;
        return l4 - l5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long computeBatteryUptime(long l, int n) {
        switch (n) {
            default: {
                return 0L;
            }
            case 0: {
                long l2 = this.mBatteryUptime;
                long l3 = this.getBatteryUptime(l);
                return l2 + l3;
            }
            case 1: {
                return this.mBatteryLastUptime;
            }
            case 2: {
                return this.getBatteryUptime(l);
            }
            case 3: 
        }
        long l4 = this.getBatteryUptimeLocked(l);
        long l5 = this.mUnpluggedBatteryUptime;
        return l4 - l5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long computeRealtime(long l, int n) {
        switch (n) {
            default: {
                return 0L;
            }
            case 0: {
                long l2 = this.mRealtime;
                long l3 = this.mRealtimeStart;
                long l4 = l - l3;
                return l2 + l4;
            }
            case 1: {
                return this.mLastRealtime;
            }
            case 2: {
                long l5 = this.mRealtimeStart;
                return l - l5;
            }
            case 3: 
        }
        long l6 = this.mTrackBatteryRealtimeStart;
        return l - l6;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long computeUptime(long l, int n) {
        switch (n) {
            default: {
                return 0L;
            }
            case 0: {
                long l2 = this.mUptime;
                long l3 = this.mUptimeStart;
                long l4 = l - l3;
                return l2 + l4;
            }
            case 1: {
                return this.mLastUptime;
            }
            case 2: {
                long l5 = this.mUptimeStart;
                return l - l5;
            }
            case 3: 
        }
        long l6 = this.mTrackBatteryUptimeStart;
        return l - l6;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void distributeWorkLocked(int n) {
        Uid uid = this.mUidStats.get(1010);
        if (uid == null) {
            return;
        }
        long l = SystemClock.elapsedRealtime() * 1000L;
        BatteryStatsImpl batteryStatsImpl = this;
        long l2 = l;
        int n2 = n;
        long l3 = batteryStatsImpl.computeBatteryRealtime(l2, n2);
        Iterator<Uid.Proc> iterator = uid.mProcessStats.values().iterator();
        block0: while (iterator.hasNext()) {
            Uid.Proc proc = iterator.next();
            BatteryStatsImpl batteryStatsImpl2 = this;
            long l4 = l3;
            int n3 = n;
            long l5 = batteryStatsImpl2.getGlobalWifiRunningTime(l4, n3);
            int n4 = 0;
            while (true) {
                int n5;
                int n6;
                int n7;
                long l6;
                long l7;
                long l8;
                long l9;
                long l10;
                long l11;
                int n8;
                long l12;
                Uid uid2;
                long l13;
                int n9;
                int n10;
                int n11;
                if ((n11 = ++n4) >= (n10 = (n9 = this.mUidStats.size()))) continue block0;
                SparseArray<Uid> sparseArray = this.mUidStats;
                int n12 = n4;
                Uid uid3 = sparseArray.valueAt(n12);
                int n13 = uid3.mUid;
                n10 = 1010;
                if (n13 == n10 || (l13 = (uid2 = uid3).getWifiRunningTime(l12 = l3, n8 = n)) <= 0L) continue;
                Uid uid4 = uid3;
                String string2 = "*wifi*";
                Uid.Proc proc2 = uid4.getProcessStatsLocked(string2);
                Uid.Proc proc3 = proc;
                int n14 = n;
                long l14 = proc3.getUserTime(n14) * l13 / l5;
                proc2.mUserTime = l11 = proc2.mUserTime + l14;
                proc.mUserTime = l10 = proc.mUserTime - l14;
                Uid.Proc proc4 = proc;
                int n15 = n;
                long l15 = proc4.getSystemTime(n15) * l13 / l5;
                proc2.mSystemTime = l9 = proc2.mSystemTime + l15;
                proc.mSystemTime = l8 = proc.mSystemTime - l15;
                Uid.Proc proc5 = proc;
                int n16 = n;
                long l16 = proc5.getForegroundTime(n16) * l13 / l5;
                proc2.mForegroundTime = l7 = proc2.mForegroundTime + l16;
                proc.mForegroundTime = l6 = proc.mForegroundTime - l16;
                int n17 = 0;
                while ((n7 = ++n17) < (n6 = (n5 = proc.mSpeedBins.length))) {
                    SamplingCounter samplingCounter = proc.mSpeedBins[n17];
                    if (samplingCounter == null) continue;
                    SamplingCounter samplingCounter2 = samplingCounter;
                    int n18 = n;
                    long l17 = (long)samplingCounter2.getCountLocked(n18) * l13 / l5;
                    SamplingCounter samplingCounter3 = proc2.mSpeedBins[n17];
                    if (samplingCounter3 == null) {
                        ArrayList<Unpluggable> arrayList = this.mUnpluggables;
                        SamplingCounter samplingCounter4 = samplingCounter3;
                        ArrayList<Unpluggable> arrayList2 = arrayList;
                        samplingCounter4(arrayList2);
                        proc2.mSpeedBins[n17] = samplingCounter3;
                    }
                    AtomicInteger atomicInteger = samplingCounter3.mCount;
                    int n19 = (int)l17;
                    int n20 = atomicInteger.addAndGet(n19);
                    AtomicInteger atomicInteger2 = samplingCounter.mCount;
                    int n21 = (int)(-l17);
                    int n22 = atomicInteger2.addAndGet(n21);
                }
                long l18 = l5 - l13;
            }
            break;
        }
        return;
    }

    public void doPlugLocked(long l, long l2) {
        int n;
        long l3;
        for (int i = this.mUidStats.size() - 1; i >= 0; i += -1) {
            long l4;
            Uid uid = this.mUidStats.valueAt(i);
            if (uid.mStartedTcpBytesReceived >= 0L) {
                long l5;
                uid.mCurrentTcpBytesReceived = l5 = uid.computeCurrentTcpBytesReceived();
                uid.mStartedTcpBytesReceived = 65535L;
            }
            if (uid.mStartedTcpBytesSent < 0L) continue;
            uid.mCurrentTcpBytesSent = l4 = uid.computeCurrentTcpBytesSent();
            uid.mStartedTcpBytesSent = 65535L;
        }
        for (int i = this.mUnpluggables.size() - 1; i >= 0; i += -1) {
            this.mUnpluggables.get(i).plug(l, l2);
        }
        long[] lArray = this.mMobileDataRx;
        long l6 = TrafficStats.getMobileRxBytes();
        this.doDataPlug(lArray, l6);
        long[] lArray2 = this.mMobileDataTx;
        long l7 = TrafficStats.getMobileTxBytes();
        this.doDataPlug(lArray2, l7);
        long[] lArray3 = this.mTotalDataRx;
        long l8 = TrafficStats.getTotalRxBytes();
        this.doDataPlug(lArray3, l8);
        long[] lArray4 = this.mTotalDataTx;
        long l9 = TrafficStats.getTotalTxBytes();
        this.doDataPlug(lArray4, l9);
        this.mRadioDataUptime = l3 = this.getRadioDataUptime();
        this.mRadioDataStart = 65535L;
        this.mBluetoothPingCount = n = this.getBluetoothPingCount();
        this.mBluetoothPingStart = -1;
    }

    public void doUnplugLocked(long l, long l2) {
        int n;
        long l3;
        for (int i = this.mUidStats.size() - 1; i >= 0; i += -1) {
            long l4;
            long l5;
            long l6;
            long l7;
            Uid uid = this.mUidStats.valueAt(i);
            uid.mStartedTcpBytesReceived = l7 = TrafficStats.getUidRxBytes(uid.mUid);
            uid.mStartedTcpBytesSent = l6 = TrafficStats.getUidTxBytes(uid.mUid);
            uid.mTcpBytesReceivedAtLastUnplug = l5 = uid.mCurrentTcpBytesReceived;
            uid.mTcpBytesSentAtLastUnplug = l4 = uid.mCurrentTcpBytesSent;
        }
        for (int i = this.mUnpluggables.size() - 1; i >= 0; i += -1) {
            this.mUnpluggables.get(i).unplug(l, l2);
        }
        long[] lArray = this.mMobileDataRx;
        long l8 = TrafficStats.getMobileRxBytes();
        this.doDataUnplug(lArray, l8);
        long[] lArray2 = this.mMobileDataTx;
        long l9 = TrafficStats.getMobileTxBytes();
        this.doDataUnplug(lArray2, l9);
        long[] lArray3 = this.mTotalDataRx;
        long l10 = TrafficStats.getTotalRxBytes();
        this.doDataUnplug(lArray3, l10);
        long[] lArray4 = this.mTotalDataTx;
        long l11 = TrafficStats.getTotalTxBytes();
        this.doDataUnplug(lArray4, l11);
        this.mRadioDataStart = l3 = this.getCurrentRadioDataUptime();
        this.mRadioDataUptime = 0L;
        this.mBluetoothPingStart = n = this.getCurrentBluetoothPingCount();
        this.mBluetoothPingCount = 0;
    }

    @Override
    public void dumpLocked(PrintWriter printWriter) {
        super.dumpLocked(printWriter);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void finishAddingCpuLocked(int n, int n2, int n3, long[] lArray) {
        boolean bl;
        int n4;
        int n5 = this.mPartialTimers.size();
        if (n != 0) {
            Uid uid;
            int n6;
            int n7 = 0;
            for (n6 = 0; n6 < n5; ++n6) {
                Uid uid2;
                StopwatchTimer stopwatchTimer = this.mPartialTimers.get(n6);
                if (!stopwatchTimer.mInList || (uid2 = stopwatchTimer.mUid) == null || uid2.mUid == 1000) continue;
                ++n7;
            }
            if (n7 != 0) {
                for (n6 = 0; n6 < n5; ++n6) {
                    Uid uid3;
                    StopwatchTimer stopwatchTimer = this.mPartialTimers.get(n6);
                    if (!stopwatchTimer.mInList || (uid3 = stopwatchTimer.mUid) == null || uid3.mUid == 1000) continue;
                    int n8 = n2 / n7;
                    int n9 = n3 / n7;
                    n2 -= n8;
                    n3 -= n9;
                    n7 += -1;
                    Uid.Proc proc = uid3.getProcessStatsLocked("*wakelock*");
                    proc.addCpuTimeLocked(n8, n9);
                    Uid.Proc proc2 = proc;
                    long[] lArray2 = lArray;
                    proc2.addSpeedStepTimes(lArray2);
                }
            }
            if ((n2 != 0 || n3 != 0) && (uid = this.getUidStatsLocked(1000)) != null) {
                Uid.Proc proc;
                Uid.Proc proc3 = proc = uid.getProcessStatsLocked("*lost*");
                int n10 = n2;
                int n11 = n3;
                proc3.addCpuTimeLocked(n10, n11);
                Uid.Proc proc4 = proc;
                long[] lArray3 = lArray;
                proc4.addSpeedStepTimes(lArray3);
            }
        }
        boolean bl2 = n5 != (n4 = this.mLastPartialTimers.size());
        for (int i = 0; i < n4 && !bl2; bl2 |= bl, ++i) {
            StopwatchTimer stopwatchTimer;
            StopwatchTimer stopwatchTimer2 = this.mPartialTimers.get(i);
            bl = stopwatchTimer2 != (stopwatchTimer = this.mLastPartialTimers.get(i));
        }
        if (bl2) {
            for (int i = 0; i < n4; ++i) {
                boolean bl3;
                StopwatchTimer stopwatchTimer = this.mLastPartialTimers.get(i);
                stopwatchTimer.mInList = bl3 = false;
            }
        } else {
            int n12 = 0;
            while (true) {
                boolean bl4;
                if (n12 >= n4) {
                    return;
                }
                StopwatchTimer stopwatchTimer = this.mPartialTimers.get(n12);
                stopwatchTimer.mInList = bl4 = true;
                ++n12;
            }
        }
        this.mLastPartialTimers.clear();
        int n13 = 0;
        while (n13 < n5) {
            StopwatchTimer stopwatchTimer = this.mPartialTimers.get(n13);
            stopwatchTimer.mInList = true;
            boolean bl5 = this.mLastPartialTimers.add(stopwatchTimer);
            ++n13;
        }
        return;
    }

    public long getAwakeTimeBattery() {
        long l = this.getBatteryUptimeLocked();
        return this.computeBatteryUptime(l, 2);
    }

    public long getAwakeTimePlugged() {
        long l = SystemClock.uptimeMillis() * 1000L;
        long l2 = this.getAwakeTimeBattery();
        return l - l2;
    }

    @Override
    public long getBatteryRealtime(long l) {
        return this.getBatteryRealtimeLocked(l);
    }

    long getBatteryRealtimeLocked(long l) {
        long l2 = this.mTrackBatteryPastRealtime;
        if (this.mOnBatteryInternal) {
            long l3 = this.mTrackBatteryRealtimeStart;
            long l4 = l - l3;
            l2 += l4;
        }
        return l2;
    }

    @Override
    public long getBatteryUptime(long l) {
        return this.getBatteryUptimeLocked(l);
    }

    long getBatteryUptimeLocked() {
        long l = SystemClock.uptimeMillis() * 1000L;
        return this.getBatteryUptime(l);
    }

    long getBatteryUptimeLocked(long l) {
        long l2 = this.mTrackBatteryPastUptime;
        if (this.mOnBatteryInternal) {
            long l3 = this.mTrackBatteryUptimeStart;
            long l4 = l - l3;
            l2 += l4;
        }
        return l2;
    }

    @Override
    public long getBluetoothOnTime(long l, int n) {
        return this.mBluetoothOnTimer.getTotalTimeLocked(l, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getBluetoothPingCount() {
        if (this.mBluetoothPingStart == -1) {
            return this.mBluetoothPingCount;
        }
        if (this.mBtHeadset == null) return 0;
        int n = this.getCurrentBluetoothPingCount();
        int n2 = this.mBluetoothPingStart;
        return n - n2;
    }

    @Override
    public int getCpuSpeedSteps() {
        return sNumSpeedSteps;
    }

    @Override
    public int getDischargeCurrentLevel() {
        synchronized (this) {
            int n = this.getDischargeCurrentLevelLocked();
            return n;
        }
    }

    public int getDischargeCurrentLevelLocked() {
        return this.mDischargeCurrentLevel;
    }

    @Override
    public int getDischargeStartLevel() {
        synchronized (this) {
            int n = this.getDischargeStartLevelLocked();
            return n;
        }
    }

    public int getDischargeStartLevelLocked() {
        return this.mDischargeUnplugLevel;
    }

    @Override
    public long getGlobalWifiRunningTime(long l, int n) {
        return this.mGlobalWifiRunningTimer.getTotalTimeLocked(l, n);
    }

    @Override
    public int getHighDischargeAmountSinceCharge() {
        synchronized (this) {
            int n;
            int n2;
            int n3 = this.mHighDischargeAmountSinceCharge;
            if (this.mOnBattery && (n2 = this.mDischargeCurrentLevel) < (n = this.mDischargeUnplugLevel)) {
                int n4 = this.mDischargeUnplugLevel;
                int n5 = this.mDischargeCurrentLevel;
                int n6 = n4 - n5;
                n3 += n6;
            }
            return n3;
        }
    }

    @Override
    public BatteryStats.HistoryItem getHistory() {
        return this.mHistory;
    }

    @Override
    public long getHistoryBaseTime() {
        return this.mHistoryBaseTime;
    }

    @Override
    public int getInputEventCount(int n) {
        return this.mInputEventCounter.getCountLocked(n);
    }

    @Override
    public boolean getIsOnBattery() {
        return this.mOnBattery;
    }

    public Map<String, ? extends SamplingTimer> getKernelWakelockStats() {
        return this.mKernelWakelockStats;
    }

    public SamplingTimer getKernelWakelockTimerLocked(String string2) {
        SamplingTimer samplingTimer = this.mKernelWakelockStats.get(string2);
        if (samplingTimer == null) {
            ArrayList<Unpluggable> arrayList = this.mUnpluggables;
            boolean bl = this.mOnBatteryInternal;
            samplingTimer = new SamplingTimer(arrayList, bl, true);
            SamplingTimer samplingTimer2 = this.mKernelWakelockStats.put(string2, samplingTimer);
        }
        return samplingTimer;
    }

    @Override
    public int getLowDischargeAmountSinceCharge() {
        synchronized (this) {
            int n;
            int n2;
            int n3 = this.mLowDischargeAmountSinceCharge;
            if (this.mOnBattery && (n2 = this.mDischargeCurrentLevel) < (n = this.mDischargeUnplugLevel)) {
                int n4 = this.mDischargeUnplugLevel;
                int n5 = this.mDischargeCurrentLevel;
                int n6 = n4 - n5 - 1;
                n3 += n6;
            }
            return n3;
        }
    }

    public long getMobileTcpBytesReceived(int n) {
        long l = TrafficStats.getMobileRxBytes();
        long[] lArray = this.mMobileDataRx;
        return this.getTcpBytes(l, lArray, n);
    }

    public long getMobileTcpBytesSent(int n) {
        long l = TrafficStats.getMobileTxBytes();
        long[] lArray = this.mMobileDataTx;
        return this.getTcpBytes(l, lArray, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getNextHistoryLocked(BatteryStats.HistoryItem historyItem) {
        BatteryStats.HistoryItem historyItem2;
        BatteryStats.HistoryItem historyItem3 = this.mHistoryIterator;
        if (historyItem3 == null) {
            return false;
        }
        historyItem.setTo(historyItem3);
        this.mHistoryIterator = historyItem2 = historyItem3.next;
        return true;
    }

    public Uid.Pkg getPackageStatsLocked(int n, String string2) {
        return this.getUidStatsLocked(n).getPackageStatsLocked(string2);
    }

    @Override
    public int getPhoneDataConnectionCount(int n, int n2) {
        return this.mPhoneDataConnectionsTimer[n].getCountLocked(n2);
    }

    @Override
    public long getPhoneDataConnectionTime(int n, long l, int n2) {
        return this.mPhoneDataConnectionsTimer[n].getTotalTimeLocked(l, n2);
    }

    @Override
    public long getPhoneOnTime(long l, int n) {
        return this.mPhoneOnTimer.getTotalTimeLocked(l, n);
    }

    @Override
    public long getPhoneSignalScanningTime(long l, int n) {
        return this.mPhoneSignalScanningTimer.getTotalTimeLocked(l, n);
    }

    @Override
    public int getPhoneSignalStrengthCount(int n, int n2) {
        return this.mPhoneDataConnectionsTimer[n].getCountLocked(n2);
    }

    @Override
    public long getPhoneSignalStrengthTime(int n, long l, int n2) {
        return this.mPhoneSignalStrengthsTimer[n].getTotalTimeLocked(l, n2);
    }

    public Uid.Proc getProcessStatsLocked(int n, String string2) {
        return this.getUidStatsLocked(n).getProcessStatsLocked(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Uid.Proc getProcessStatsLocked(String string2, int n) {
        int n2;
        if (this.mUidCache.containsKey(string2)) {
            n2 = this.mUidCache.get(string2);
            return this.getUidStatsLocked(n2).getProcessStatsLocked(string2);
        }
        n2 = Process.getUidForPid(n);
        HashMap<String, Integer> hashMap = this.mUidCache;
        Integer n3 = n2;
        Integer n4 = hashMap.put(string2, n3);
        return this.getUidStatsLocked(n2).getProcessStatsLocked(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getProcessWakeTime(int n, int n2, long l) {
        long l2;
        Uid uid = this.mUidStats.get(n);
        if (uid == null) return 0L;
        BatteryStats.Uid.Pid pid = uid.mPids.get(n2);
        if (pid == null) return 0L;
        long l3 = pid.mWakeSum;
        if (pid.mWakeStart != 0L) {
            long l4 = pid.mWakeStart;
            l2 = l - l4;
            return l3 + l2;
        }
        l2 = 0L;
        return l3 + l2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getRadioDataUptime() {
        if (this.mRadioDataStart == 65535L) {
            return this.mRadioDataUptime;
        }
        long l = this.getCurrentRadioDataUptime();
        long l2 = this.mRadioDataStart;
        return l - l2;
    }

    @Override
    public long getRadioDataUptimeMs() {
        return this.getRadioDataUptime() / 1000L;
    }

    @Override
    public long getScreenBrightnessTime(int n, long l, int n2) {
        return this.mScreenBrightnessTimer[n].getTotalTimeLocked(l, n2);
    }

    @Override
    public long getScreenOnTime(long l, int n) {
        return this.mScreenOnTimer.getTotalTimeLocked(l, n);
    }

    public Uid.Pkg.Serv getServiceStatsLocked(int n, String string2, String string3) {
        return this.getUidStatsLocked(n).getServiceStatsLocked(string2, string3);
    }

    @Override
    public int getStartCount() {
        return this.mStartCount;
    }

    public long getTotalTcpBytesReceived(int n) {
        long l = TrafficStats.getTotalRxBytes();
        long[] lArray = this.mTotalDataRx;
        return this.getTcpBytes(l, lArray, n);
    }

    public long getTotalTcpBytesSent(int n) {
        long l = TrafficStats.getTotalTxBytes();
        long[] lArray = this.mTotalDataTx;
        return this.getTcpBytes(l, lArray, n);
    }

    @Override
    public SparseArray<? extends BatteryStats.Uid> getUidStats() {
        return this.mUidStats;
    }

    public Uid getUidStatsLocked(int n) {
        Uid uid = this.mUidStats.get(n);
        if (uid == null) {
            uid = new Uid(n);
            this.mUidStats.put(n, uid);
        }
        return uid;
    }

    @Override
    public long getWifiOnTime(long l, int n) {
        return this.mWifiOnTimer.getTotalTimeLocked(l, n);
    }

    void initTimes() {
        long l;
        long l2;
        long l3;
        long l4;
        this.mTrackBatteryPastUptime = 0L;
        this.mBatteryRealtime = 0L;
        this.mTrackBatteryPastRealtime = 0L;
        this.mBatteryUptime = 0L;
        this.mTrackBatteryUptimeStart = l4 = SystemClock.uptimeMillis() * 1000L;
        this.mUptimeStart = l4;
        this.mTrackBatteryRealtimeStart = l3 = SystemClock.elapsedRealtime() * 1000L;
        this.mRealtimeStart = l3;
        long l5 = this.mUptimeStart;
        this.mUnpluggedBatteryUptime = l2 = this.getBatteryUptimeLocked(l5);
        long l6 = this.mRealtimeStart;
        this.mUnpluggedBatteryRealtime = l = this.getBatteryRealtimeLocked(l6);
    }

    public boolean isOnBattery() {
        return this.mOnBattery;
    }

    public boolean isScreenOn() {
        return this.mScreenOn;
    }

    public void noteAudioOffLocked(int n) {
        if (this.mAudioOn) {
            int n2;
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = n2 = historyItem.states & 0xFFF7FFFF;
            long l = SystemClock.elapsedRealtime();
            this.addHistoryRecordLocked(l);
            this.mAudioOn = false;
            this.mAudioOnTimer.stopRunningLocked(this);
        }
        this.getUidStatsLocked(n).noteAudioTurnedOffLocked();
    }

    public void noteAudioOnLocked(int n) {
        if (!this.mAudioOn) {
            int n2;
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = n2 = historyItem.states | 0x80000;
            long l = SystemClock.elapsedRealtime();
            this.addHistoryRecordLocked(l);
            this.mAudioOn = true;
            this.mAudioOnTimer.startRunningLocked(this);
        }
        this.getUidStatsLocked(n).noteAudioTurnedOnLocked();
    }

    public void noteBluetoothOffLocked() {
        int n;
        if (!this.mBluetoothOn) {
            return;
        }
        BatteryStats.HistoryItem historyItem = this.mHistoryCur;
        historyItem.states = n = historyItem.states & 0xFFEFFFFF;
        long l = SystemClock.elapsedRealtime();
        this.addHistoryRecordLocked(l);
        this.mBluetoothOn = false;
        this.mBluetoothOnTimer.stopRunningLocked(this);
    }

    public void noteBluetoothOnLocked() {
        int n;
        if (this.mBluetoothOn) {
            return;
        }
        BatteryStats.HistoryItem historyItem = this.mHistoryCur;
        historyItem.states = n = historyItem.states | 0x100000;
        long l = SystemClock.elapsedRealtime();
        this.addHistoryRecordLocked(l);
        this.mBluetoothOn = true;
        this.mBluetoothOnTimer.startRunningLocked(this);
    }

    public void noteFullWifiLockAcquiredFromSourceLocked(WorkSource workSource) {
        int n = workSource.size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = workSource.get(n2);
            this.noteFullWifiLockAcquiredLocked(n3);
            ++n2;
        }
        return;
    }

    public void noteFullWifiLockAcquiredLocked(int n) {
        int n2;
        if (this.mWifiFullLockNesting == 0) {
            int n3;
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = n3 = historyItem.states | 0x800000;
            long l = SystemClock.elapsedRealtime();
            this.addHistoryRecordLocked(l);
        }
        this.mWifiFullLockNesting = n2 = this.mWifiFullLockNesting + 1;
        this.getUidStatsLocked(n).noteFullWifiLockAcquiredLocked();
    }

    public void noteFullWifiLockReleasedFromSourceLocked(WorkSource workSource) {
        int n = workSource.size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = workSource.get(n2);
            this.noteFullWifiLockReleasedLocked(n3);
            ++n2;
        }
        return;
    }

    public void noteFullWifiLockReleasedLocked(int n) {
        int n2;
        this.mWifiFullLockNesting = n2 = this.mWifiFullLockNesting - 1;
        if (this.mWifiFullLockNesting == 0) {
            int n3;
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = n3 = historyItem.states & 0xFF7FFFFF;
            long l = SystemClock.elapsedRealtime();
            this.addHistoryRecordLocked(l);
        }
        this.getUidStatsLocked(n).noteFullWifiLockReleasedLocked();
    }

    public void noteInputEventAtomic() {
        this.mInputEventCounter.stepAtomic();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void notePhoneDataConnectionStateLocked(int n, boolean bl) {
        int n2;
        int n3 = 0;
        if (bl) {
            switch (n) {
                default: {
                    n3 = 13;
                    break;
                }
                case 2: {
                    n3 = 2;
                    break;
                }
                case 1: {
                    n3 = 1;
                    break;
                }
                case 3: {
                    n3 = 3;
                    break;
                }
                case 4: {
                    n3 = 4;
                    break;
                }
                case 5: {
                    n3 = 5;
                    break;
                }
                case 6: {
                    n3 = 6;
                    break;
                }
                case 7: {
                    n3 = 7;
                    break;
                }
                case 8: {
                    n3 = 8;
                    break;
                }
                case 9: {
                    n3 = 9;
                    break;
                }
                case 10: {
                    n3 = 10;
                    break;
                }
                case 11: {
                    n3 = 11;
                    break;
                }
                case 12: {
                    n3 = 12;
                }
            }
        }
        if (this.mPhoneDataConnectionType != n3) {
            return;
        }
        BatteryStats.HistoryItem historyItem = this.mHistoryCur;
        int n4 = this.mHistoryCur.states & 0xFFFF0FFF;
        int n5 = n3 << 12;
        historyItem.states = n2 = n4 | n5;
        long l = SystemClock.elapsedRealtime();
        this.addHistoryRecordLocked(l);
        if (this.mPhoneDataConnectionType >= 0) {
            StopwatchTimer[] stopwatchTimerArray = this.mPhoneDataConnectionsTimer;
            int n6 = this.mPhoneDataConnectionType;
            stopwatchTimerArray[n6].stopRunningLocked(this);
        }
        this.mPhoneDataConnectionType = n3;
        this.mPhoneDataConnectionsTimer[n3].startRunningLocked(this);
    }

    public void notePhoneOffLocked() {
        int n;
        if (!this.mPhoneOn) {
            return;
        }
        BatteryStats.HistoryItem historyItem = this.mHistoryCur;
        historyItem.states = n = historyItem.states & 0xF7FFFFFF;
        long l = SystemClock.elapsedRealtime();
        this.addHistoryRecordLocked(l);
        this.mPhoneOn = false;
        this.mPhoneOnTimer.stopRunningLocked(this);
    }

    public void notePhoneOnLocked() {
        int n;
        if (this.mPhoneOn) {
            return;
        }
        BatteryStats.HistoryItem historyItem = this.mHistoryCur;
        historyItem.states = n = historyItem.states | 0x8000000;
        long l = SystemClock.elapsedRealtime();
        this.addHistoryRecordLocked(l);
        this.mPhoneOn = true;
        this.mPhoneOnTimer.startRunningLocked(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void notePhoneSignalStrengthLocked(SignalStrength signalStrength) {
        int n;
        int n2;
        int n3 = !signalStrength.isGsm() ? ((n2 = signalStrength.getCdmaDbm()) >= 65461 ? 4 : (n2 >= 65451 ? 3 : (n2 >= 65441 ? 2 : (n2 >= 65436 ? 1 : 0)))) : ((n = signalStrength.getGsmSignalStrength()) < 0 || n >= 99 ? 0 : (n >= 16 ? 4 : (n >= 8 ? 3 : (n >= 4 ? 2 : 1))));
        int n4 = this.mPhoneServiceStateRaw;
        int n5 = this.mPhoneSimStateRaw;
        this.updateAllPhoneStateLocked(n4, n5, n3);
    }

    public void notePhoneStateLocked(int n, int n2) {
        int n3 = this.mPhoneSignalStrengthBinRaw;
        this.updateAllPhoneStateLocked(n, n2, n3);
    }

    public void noteProcessDiedLocked(int n, int n2) {
        Uid uid = this.mUidStats.get(n);
        if (uid == null) {
            return;
        }
        uid.mPids.remove(n2);
    }

    public void noteScanWifiLockAcquiredFromSourceLocked(WorkSource workSource) {
        int n = workSource.size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = workSource.get(n2);
            this.noteScanWifiLockAcquiredLocked(n3);
            ++n2;
        }
        return;
    }

    public void noteScanWifiLockAcquiredLocked(int n) {
        int n2;
        if (this.mWifiScanLockNesting == 0) {
            int n3;
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = n3 = historyItem.states | 0x400000;
            long l = SystemClock.elapsedRealtime();
            this.addHistoryRecordLocked(l);
        }
        this.mWifiScanLockNesting = n2 = this.mWifiScanLockNesting + 1;
        this.getUidStatsLocked(n).noteScanWifiLockAcquiredLocked();
    }

    public void noteScanWifiLockReleasedFromSourceLocked(WorkSource workSource) {
        int n = workSource.size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = workSource.get(n2);
            this.noteScanWifiLockReleasedLocked(n3);
            ++n2;
        }
        return;
    }

    public void noteScanWifiLockReleasedLocked(int n) {
        int n2;
        this.mWifiScanLockNesting = n2 = this.mWifiScanLockNesting - 1;
        if (this.mWifiScanLockNesting == 0) {
            int n3;
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = n3 = historyItem.states & 0xFFBFFFFF;
            long l = SystemClock.elapsedRealtime();
            this.addHistoryRecordLocked(l);
        }
        this.getUidStatsLocked(n).noteScanWifiLockReleasedLocked();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void noteScreenBrightnessLocked(int n) {
        int n2;
        int n3 = n / 51;
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 >= 5) {
            n3 = 4;
        }
        if (this.mScreenBrightnessBin != n3) {
            return;
        }
        BatteryStats.HistoryItem historyItem = this.mHistoryCur;
        int n4 = this.mHistoryCur.states & 0xFFFFFFF0;
        int n5 = n3 << 0;
        historyItem.states = n2 = n4 | n5;
        long l = SystemClock.elapsedRealtime();
        this.addHistoryRecordLocked(l);
        if (this.mScreenOn) {
            if (this.mScreenBrightnessBin >= 0) {
                StopwatchTimer[] stopwatchTimerArray = this.mScreenBrightnessTimer;
                int n6 = this.mScreenBrightnessBin;
                stopwatchTimerArray[n6].stopRunningLocked(this);
            }
            this.mScreenBrightnessTimer[n3].startRunningLocked(this);
        }
        this.mScreenBrightnessBin = n3;
    }

    public void noteScreenOffLocked() {
        int n;
        if (!this.mScreenOn) {
            return;
        }
        BatteryStats.HistoryItem historyItem = this.mHistoryCur;
        historyItem.states = n = historyItem.states & 0xDFFFFFFF;
        long l = SystemClock.elapsedRealtime();
        this.addHistoryRecordLocked(l);
        this.mScreenOn = false;
        this.mScreenOnTimer.stopRunningLocked(this);
        if (this.mScreenBrightnessBin >= 0) {
            StopwatchTimer[] stopwatchTimerArray = this.mScreenBrightnessTimer;
            int n2 = this.mScreenBrightnessBin;
            stopwatchTimerArray[n2].stopRunningLocked(this);
        }
        this.noteStopWakeLocked(-1, -1, "dummy", 0);
    }

    public void noteScreenOnLocked() {
        int n;
        if (this.mScreenOn) {
            return;
        }
        BatteryStats.HistoryItem historyItem = this.mHistoryCur;
        historyItem.states = n = historyItem.states | 0x20000000;
        long l = SystemClock.elapsedRealtime();
        this.addHistoryRecordLocked(l);
        this.mScreenOn = true;
        this.mScreenOnTimer.startRunningLocked(this);
        if (this.mScreenBrightnessBin >= 0) {
            StopwatchTimer[] stopwatchTimerArray = this.mScreenBrightnessTimer;
            int n2 = this.mScreenBrightnessBin;
            stopwatchTimerArray[n2].startRunningLocked(this);
        }
        this.noteStartWakeLocked(-1, -1, "dummy", 0);
    }

    public void noteStartGpsLocked(int n) {
        int n2;
        if (this.mGpsNesting == 0) {
            int n3;
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = n3 = historyItem.states | 0x10000000;
            long l = SystemClock.elapsedRealtime();
            this.addHistoryRecordLocked(l);
        }
        this.mGpsNesting = n2 = this.mGpsNesting + 1;
        this.getUidStatsLocked(n).noteStartGps();
    }

    public void noteStartSensorLocked(int n, int n2) {
        int n3;
        if (this.mSensorNesting == 0) {
            int n4;
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = n4 = historyItem.states | 0x10000;
            long l = SystemClock.elapsedRealtime();
            this.addHistoryRecordLocked(l);
        }
        this.mSensorNesting = n3 = this.mSensorNesting + 1;
        this.getUidStatsLocked(n).noteStartSensor(n2);
    }

    public void noteStartWakeFromSourceLocked(WorkSource workSource, int n, String string2, int n2) {
        int n3 = workSource.size();
        int n4 = 0;
        while (n4 < n3) {
            int n5 = workSource.get(n4);
            this.noteStartWakeLocked(n5, n, string2, n2);
            ++n4;
        }
        return;
    }

    public void noteStartWakeLocked(int n, int n2, String string2, int n3) {
        if (n3 == 0) {
            int n4;
            if (this.mWakeLockNesting == 0) {
                int n5;
                BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                historyItem.states = n5 = historyItem.states | 0x20000;
                long l = SystemClock.elapsedRealtime();
                this.addHistoryRecordLocked(l);
            }
            this.mWakeLockNesting = n4 = this.mWakeLockNesting + 1;
        }
        if (n < 0) {
            return;
        }
        if (!this.mHandler.hasMessages(1)) {
            Message message = this.mHandler.obtainMessage(1);
            boolean bl = this.mHandler.sendMessageDelayed(message, 5000L);
        }
        this.getUidStatsLocked(n).noteStartWakeLocked(n2, string2, n3);
    }

    public void noteStopGpsLocked(int n) {
        int n2;
        this.mGpsNesting = n2 = this.mGpsNesting - 1;
        if (this.mGpsNesting == 0) {
            int n3;
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = n3 = historyItem.states & 0xEFFFFFFF;
            long l = SystemClock.elapsedRealtime();
            this.addHistoryRecordLocked(l);
        }
        this.getUidStatsLocked(n).noteStopGps();
    }

    public void noteStopSensorLocked(int n, int n2) {
        int n3;
        this.mSensorNesting = n3 = this.mSensorNesting - 1;
        if (this.mSensorNesting == 0) {
            int n4;
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = n4 = historyItem.states & 0xFFFEFFFF;
            long l = SystemClock.elapsedRealtime();
            this.addHistoryRecordLocked(l);
        }
        this.getUidStatsLocked(n).noteStopSensor(n2);
    }

    public void noteStopWakeFromSourceLocked(WorkSource workSource, int n, String string2, int n2) {
        int n3 = workSource.size();
        int n4 = 0;
        while (n4 < n3) {
            int n5 = workSource.get(n4);
            this.noteStopWakeLocked(n5, n, string2, n2);
            ++n4;
        }
        return;
    }

    public void noteStopWakeLocked(int n, int n2, String string2, int n3) {
        if (n3 == 0) {
            int n4;
            this.mWakeLockNesting = n4 = this.mWakeLockNesting - 1;
            if (this.mWakeLockNesting == 0) {
                int n5;
                BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                historyItem.states = n5 = historyItem.states & 0xFFFDFFFF;
                long l = SystemClock.elapsedRealtime();
                this.addHistoryRecordLocked(l);
            }
        }
        if (n < 0) {
            return;
        }
        if (!this.mHandler.hasMessages(1)) {
            Message message = this.mHandler.obtainMessage(1);
            boolean bl = this.mHandler.sendMessageDelayed(message, 5000L);
        }
        this.getUidStatsLocked(n).noteStopWakeLocked(n2, string2, n3);
    }

    public void noteUserActivityLocked(int n, int n2) {
        this.getUidStatsLocked(n).noteUserActivityLocked(n2);
    }

    public void noteVideoOffLocked(int n) {
        if (this.mVideoOn) {
            int n2;
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = n2 = historyItem.states & 0xFFFBFFFF;
            long l = SystemClock.elapsedRealtime();
            this.addHistoryRecordLocked(l);
            this.mVideoOn = false;
            this.mVideoOnTimer.stopRunningLocked(this);
        }
        this.getUidStatsLocked(n).noteVideoTurnedOffLocked();
    }

    public void noteVideoOnLocked(int n) {
        if (!this.mVideoOn) {
            int n2;
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = n2 = historyItem.states | 0x40000;
            long l = SystemClock.elapsedRealtime();
            this.addHistoryRecordLocked(l);
            this.mVideoOn = true;
            this.mVideoOnTimer.startRunningLocked(this);
        }
        this.getUidStatsLocked(n).noteVideoTurnedOnLocked();
    }

    public void noteWifiMulticastDisabledFromSourceLocked(WorkSource workSource) {
        int n = workSource.size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = workSource.get(n2);
            this.noteWifiMulticastDisabledLocked(n3);
            ++n2;
        }
        return;
    }

    public void noteWifiMulticastDisabledLocked(int n) {
        int n2;
        this.mWifiMulticastNesting = n2 = this.mWifiMulticastNesting - 1;
        if (this.mWifiMulticastNesting == 0) {
            int n3;
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = n3 = historyItem.states & 0xFFDFFFFF;
            long l = SystemClock.elapsedRealtime();
            this.addHistoryRecordLocked(l);
        }
        this.getUidStatsLocked(n).noteWifiMulticastDisabledLocked();
    }

    public void noteWifiMulticastEnabledFromSourceLocked(WorkSource workSource) {
        int n = workSource.size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = workSource.get(n2);
            this.noteWifiMulticastEnabledLocked(n3);
            ++n2;
        }
        return;
    }

    public void noteWifiMulticastEnabledLocked(int n) {
        int n2;
        if (this.mWifiMulticastNesting == 0) {
            int n3;
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = n3 = historyItem.states | 0x200000;
            long l = SystemClock.elapsedRealtime();
            this.addHistoryRecordLocked(l);
        }
        this.mWifiMulticastNesting = n2 = this.mWifiMulticastNesting + 1;
        this.getUidStatsLocked(n).noteWifiMulticastEnabledLocked();
    }

    public void noteWifiOffLocked() {
        if (this.mWifiOn) {
            int n;
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = n = historyItem.states & 0xFDFFFFFF;
            long l = SystemClock.elapsedRealtime();
            this.addHistoryRecordLocked(l);
            this.mWifiOn = false;
            this.mWifiOnTimer.stopRunningLocked(this);
        }
        if (this.mWifiOnUid < 0) {
            return;
        }
        int n = this.mWifiOnUid;
        this.getUidStatsLocked(n).noteWifiStoppedLocked();
        this.mWifiOnUid = -1;
    }

    public void noteWifiOnLocked() {
        int n;
        if (this.mWifiOn) {
            return;
        }
        BatteryStats.HistoryItem historyItem = this.mHistoryCur;
        historyItem.states = n = historyItem.states | 0x2000000;
        long l = SystemClock.elapsedRealtime();
        this.addHistoryRecordLocked(l);
        this.mWifiOn = true;
        this.mWifiOnTimer.startRunningLocked(this);
    }

    public void noteWifiRunningChangedLocked(WorkSource workSource, WorkSource workSource2) {
        if (this.mGlobalWifiRunning) {
            int n = workSource.size();
            for (int i = 0; i < n; ++i) {
                int n2 = workSource.get(i);
                this.getUidStatsLocked(n2).noteWifiStoppedLocked();
            }
            int n3 = workSource2.size();
            int n4 = 0;
            while (true) {
                if (n4 >= n3) {
                    return;
                }
                int n5 = workSource2.get(n4);
                this.getUidStatsLocked(n5).noteWifiRunningLocked();
                ++n4;
            }
        }
        int n = Log.w(TAG, "noteWifiRunningChangedLocked -- called while WIFI not running");
    }

    public void noteWifiRunningLocked(WorkSource workSource) {
        if (!this.mGlobalWifiRunning) {
            int n;
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = n = historyItem.states | 0x1000000;
            long l = SystemClock.elapsedRealtime();
            this.addHistoryRecordLocked(l);
            this.mGlobalWifiRunning = true;
            this.mGlobalWifiRunningTimer.startRunningLocked(this);
            int n2 = workSource.size();
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return;
                }
                int n4 = workSource.get(n3);
                this.getUidStatsLocked(n4).noteWifiRunningLocked();
                ++n3;
            }
        }
        int n = Log.w(TAG, "noteWifiRunningLocked -- called while WIFI running");
    }

    public void noteWifiStoppedLocked(WorkSource workSource) {
        if (this.mGlobalWifiRunning) {
            int n;
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = n = historyItem.states & 0xFEFFFFFF;
            long l = SystemClock.elapsedRealtime();
            this.addHistoryRecordLocked(l);
            this.mGlobalWifiRunning = false;
            this.mGlobalWifiRunningTimer.stopRunningLocked(this);
            int n2 = workSource.size();
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return;
                }
                int n4 = workSource.get(n3);
                this.getUidStatsLocked(n4).noteWifiStoppedLocked();
                ++n3;
            }
        }
        int n = Log.w(TAG, "noteWifiStoppedLocked -- called while WIFI not running");
    }

    public void readFromParcel(Parcel parcel) {
        this.readFromParcelLocked(parcel);
    }

    /*
     * Enabled aggressive block sorting
     */
    void readFromParcelLocked(Parcel parcel) {
        int n;
        int n2;
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        int n3;
        int n4;
        int n5;
        int n6;
        long l8;
        long l9;
        long l10;
        long l11;
        long l12;
        long l13;
        boolean bl;
        boolean bl2;
        long l14;
        long l15;
        long l16;
        long l17;
        long l18;
        long l19;
        StopwatchTimer stopwatchTimer;
        boolean bl3;
        StopwatchTimer stopwatchTimer2;
        boolean bl4;
        StopwatchTimer stopwatchTimer3;
        boolean bl5;
        StopwatchTimer stopwatchTimer4;
        StopwatchTimer stopwatchTimer5;
        boolean bl6;
        Counter counter;
        Counter counter2;
        StopwatchTimer stopwatchTimer6;
        boolean bl7;
        long l20;
        long l21;
        long l22;
        long l23;
        int n7;
        if (parcel.readInt() != -1166707595) {
            throw new ParcelFormatException("Bad magic number");
        }
        this.readHistory(parcel);
        this.mStartCount = n7 = parcel.readInt();
        this.mBatteryUptime = l23 = parcel.readLong();
        this.mBatteryLastUptime = l22 = 0L;
        this.mBatteryRealtime = l21 = parcel.readLong();
        this.mBatteryLastRealtime = l20 = 0L;
        this.mScreenOn = bl7 = false;
        ArrayList<Unpluggable> arrayList = this.mUnpluggables;
        Parcel parcel2 = parcel;
        this.mScreenOnTimer = stopwatchTimer6 = new StopwatchTimer(null, -1, null, arrayList, parcel2);
        for (int i = 0; i < 5; ++i) {
            StopwatchTimer stopwatchTimer7;
            StopwatchTimer[] stopwatchTimerArray = this.mScreenBrightnessTimer;
            int n8 = 65436 - i;
            ArrayList<Unpluggable> arrayList2 = this.mUnpluggables;
            Parcel parcel3 = parcel;
            stopwatchTimerArray[i] = stopwatchTimer7 = new StopwatchTimer(null, n8, null, arrayList2, parcel3);
        }
        ArrayList<Unpluggable> arrayList3 = this.mUnpluggables;
        Counter counter3 = counter2;
        ArrayList<Unpluggable> arrayList4 = arrayList3;
        Parcel parcel4 = parcel;
        counter3(arrayList4, parcel4);
        this.mInputEventCounter = counter = counter2;
        this.mPhoneOn = bl6 = false;
        ArrayList<Unpluggable> arrayList5 = this.mUnpluggables;
        Parcel parcel5 = parcel;
        this.mPhoneOnTimer = stopwatchTimer5 = new StopwatchTimer(null, -1, null, arrayList5, parcel5);
        for (int i = 0; i < 5; ++i) {
            StopwatchTimer stopwatchTimer8;
            StopwatchTimer[] stopwatchTimerArray = this.mPhoneSignalStrengthsTimer;
            int n9 = 65336 - i;
            ArrayList<Unpluggable> arrayList6 = this.mUnpluggables;
            Parcel parcel6 = parcel;
            stopwatchTimerArray[i] = stopwatchTimer8 = new StopwatchTimer(null, n9, null, arrayList6, parcel6);
        }
        ArrayList<Unpluggable> arrayList7 = this.mUnpluggables;
        Parcel parcel7 = parcel;
        this.mPhoneSignalScanningTimer = stopwatchTimer4 = new StopwatchTimer(null, 65337, null, arrayList7, parcel7);
        for (int i = 0; i < 14; ++i) {
            StopwatchTimer stopwatchTimer9;
            StopwatchTimer[] stopwatchTimerArray = this.mPhoneDataConnectionsTimer;
            int n10 = 65236 - i;
            ArrayList<Unpluggable> arrayList8 = this.mUnpluggables;
            Parcel parcel8 = parcel;
            stopwatchTimerArray[i] = stopwatchTimer9 = new StopwatchTimer(null, n10, null, arrayList8, parcel8);
        }
        this.mWifiOn = bl5 = false;
        ArrayList<Unpluggable> arrayList9 = this.mUnpluggables;
        Parcel parcel9 = parcel;
        this.mWifiOnTimer = stopwatchTimer3 = new StopwatchTimer(null, -1, null, arrayList9, parcel9);
        this.mGlobalWifiRunning = bl4 = false;
        ArrayList<Unpluggable> arrayList10 = this.mUnpluggables;
        Parcel parcel10 = parcel;
        this.mGlobalWifiRunningTimer = stopwatchTimer2 = new StopwatchTimer(null, -1, null, arrayList10, parcel10);
        this.mBluetoothOn = bl3 = false;
        ArrayList<Unpluggable> arrayList11 = this.mUnpluggables;
        Parcel parcel11 = parcel;
        this.mBluetoothOnTimer = stopwatchTimer = new StopwatchTimer(null, -1, null, arrayList11, parcel11);
        this.mUptime = l19 = parcel.readLong();
        this.mUptimeStart = l18 = parcel.readLong();
        this.mLastUptime = l17 = 0L;
        this.mRealtime = l16 = parcel.readLong();
        this.mRealtimeStart = l15 = parcel.readLong();
        this.mLastRealtime = l14 = 0L;
        boolean bl8 = parcel.readInt() != 0;
        this.mOnBattery = bl2 = bl8;
        this.mOnBatteryInternal = bl = false;
        this.mTrackBatteryPastUptime = l13 = parcel.readLong();
        this.mTrackBatteryUptimeStart = l12 = parcel.readLong();
        this.mTrackBatteryPastRealtime = l11 = parcel.readLong();
        this.mTrackBatteryRealtimeStart = l10 = parcel.readLong();
        this.mUnpluggedBatteryUptime = l9 = parcel.readLong();
        this.mUnpluggedBatteryRealtime = l8 = parcel.readLong();
        this.mDischargeUnplugLevel = n6 = parcel.readInt();
        this.mDischargeCurrentLevel = n5 = parcel.readInt();
        this.mLowDischargeAmountSinceCharge = n4 = parcel.readInt();
        this.mHighDischargeAmountSinceCharge = n3 = parcel.readInt();
        this.mLastWriteTime = l7 = parcel.readLong();
        long[] lArray = this.mMobileDataRx;
        lArray[1] = l6 = parcel.readLong();
        this.mMobileDataRx[3] = 65535L;
        long[] lArray2 = this.mMobileDataTx;
        lArray2[1] = l5 = parcel.readLong();
        this.mMobileDataTx[3] = 65535L;
        long[] lArray3 = this.mTotalDataRx;
        lArray3[1] = l4 = parcel.readLong();
        this.mTotalDataRx[3] = 65535L;
        long[] lArray4 = this.mTotalDataTx;
        lArray4[1] = l3 = parcel.readLong();
        this.mTotalDataTx[3] = 65535L;
        this.mRadioDataUptime = l2 = parcel.readLong();
        this.mRadioDataStart = l = 65535L;
        this.mBluetoothPingCount = n2 = parcel.readInt();
        this.mBluetoothPingStart = n = -1;
        this.mKernelWakelockStats.clear();
        int n11 = parcel.readInt();
        for (int i = 0; i < n11; ++i) {
            SamplingTimer samplingTimer;
            if (parcel.readInt() == 0) continue;
            String string2 = parcel.readString();
            int n12 = parcel.readInt();
            ArrayList<Unpluggable> arrayList12 = this.mUnpluggables;
            boolean bl9 = this.mOnBattery;
            SamplingTimer samplingTimer2 = samplingTimer;
            ArrayList<Unpluggable> arrayList13 = arrayList12;
            boolean bl10 = bl9;
            Parcel parcel12 = parcel;
            samplingTimer2(arrayList13, bl10, parcel12);
            HashMap<String, SamplingTimer> hashMap = this.mKernelWakelockStats;
            String string3 = string2;
            SamplingTimer samplingTimer3 = samplingTimer;
            SamplingTimer samplingTimer4 = hashMap.put(string3, samplingTimer3);
        }
        this.mPartialTimers.clear();
        this.mFullTimers.clear();
        this.mWindowTimers.clear();
        this.mWifiRunningTimers.clear();
        this.mFullWifiLockTimers.clear();
        this.mScanWifiLockTimers.clear();
        this.mWifiMulticastTimers.clear();
        sNumSpeedSteps = parcel.readInt();
        int n13 = parcel.readInt();
        this.mUidStats.clear();
        int n14 = 0;
        while (n14 < n13) {
            Uid uid;
            int n15 = parcel.readInt();
            Uid uid2 = uid;
            BatteryStatsImpl batteryStatsImpl = this;
            int n16 = n15;
            uid2(n16);
            ArrayList<Unpluggable> arrayList14 = this.mUnpluggables;
            Uid uid3 = uid;
            ArrayList<Unpluggable> arrayList15 = arrayList14;
            Parcel parcel13 = parcel;
            uid3.readFromParcelLocked(arrayList15, parcel13);
            SparseArray<Uid> sparseArray = this.mUidStats;
            int n17 = n15;
            Uid uid4 = uid;
            sparseArray.append(n17, uid4);
            ++n14;
        }
        return;
    }

    void readHistory(Parcel parcel) {
        long l;
        long l2;
        this.mHistoryCache = null;
        this.mHistoryEnd = null;
        this.mHistory = null;
        this.mHistoryBaseTime = 0L;
        while ((l2 = parcel.readLong()) >= 0L) {
            long l3;
            BatteryStats.HistoryItem historyItem = new BatteryStats.HistoryItem(l2, parcel);
            this.addHistoryRecordLocked(historyItem);
            long l4 = historyItem.time;
            long l5 = this.mHistoryBaseTime;
            if (l4 <= l5) continue;
            this.mHistoryBaseTime = l3 = historyItem.time;
        }
        long l6 = SystemClock.elapsedRealtime() - 30000L;
        if (l6 <= 0L) {
            return;
        }
        this.mHistoryBaseTime = l = this.mHistoryBaseTime - l6;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readLocked() {
        if (this.mFile == null) {
            int n = Slog.w("BatteryStats", "readLocked: no file associated with this instance");
            return;
        }
        this.mUidStats.clear();
        try {
            File file = this.mFile.chooseForRead();
            if (!file.exists()) {
                return;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = BatteryStatsImpl.readFully(fileInputStream);
            Parcel parcel = Parcel.obtain();
            int n = byArray.length;
            parcel.unmarshall(byArray, 0, n);
            parcel.setDataPosition(0);
            fileInputStream.close();
            this.readSummaryFromParcel(parcel);
        }
        catch (IOException iOException) {
            int n = Slog.e("BatteryStats", "Error reading battery statistics", iOException);
        }
        long l = SystemClock.elapsedRealtime();
        this.addHistoryRecordLocked(l, (byte)1);
    }

    public void removeUidStatsLocked(int n) {
        this.mUidStats.remove(n);
    }

    public void reportExcessiveCpuLocked(int n, String string2, long l, long l2) {
        Uid uid = this.mUidStats.get(n);
        if (uid == null) {
            return;
        }
        String string3 = string2;
        long l3 = l;
        long l4 = l2;
        uid.reportExcessiveCpuLocked(string3, l3, l4);
    }

    public void reportExcessiveWakeLocked(int n, String string2, long l, long l2) {
        Uid uid = this.mUidStats.get(n);
        if (uid == null) {
            return;
        }
        String string3 = string2;
        long l3 = l;
        long l4 = l2;
        uid.reportExcessiveWakeLocked(string3, l3, l4);
    }

    public void resetAllStatsLocked() {
        int n;
        this.mStartCount = 0;
        this.initTimes();
        boolean bl = this.mScreenOnTimer.reset(this, false);
        for (int i = 0; i < 5; ++i) {
            boolean bl2 = this.mScreenBrightnessTimer[i].reset(this, false);
        }
        this.mInputEventCounter.reset(false);
        boolean bl3 = this.mPhoneOnTimer.reset(this, false);
        boolean bl4 = this.mAudioOnTimer.reset(this, false);
        boolean bl5 = this.mVideoOnTimer.reset(this, false);
        for (int i = 0; i < 5; ++i) {
            boolean bl6 = this.mPhoneSignalStrengthsTimer[i].reset(this, false);
        }
        boolean bl7 = this.mPhoneSignalScanningTimer.reset(this, false);
        for (int i = 0; i < 14; ++i) {
            boolean bl8 = this.mPhoneDataConnectionsTimer[i].reset(this, false);
        }
        boolean bl9 = this.mWifiOnTimer.reset(this, false);
        boolean bl10 = this.mGlobalWifiRunningTimer.reset(this, false);
        boolean bl11 = this.mBluetoothOnTimer.reset(this, false);
        for (int i = 0; i < (n = this.mUidStats.size()); ++i) {
            if (!this.mUidStats.valueAt(i).reset()) continue;
            SparseArray<Uid> sparseArray = this.mUidStats;
            int n2 = this.mUidStats.keyAt(i);
            sparseArray.remove(n2);
            i += -1;
        }
        if (this.mKernelWakelockStats.size() > 0) {
            for (SamplingTimer samplingTimer : this.mKernelWakelockStats.values()) {
                boolean bl12 = this.mUnpluggables.remove(samplingTimer);
            }
            this.mKernelWakelockStats.clear();
        }
        this.mLowDischargeAmountSinceCharge = 0;
        this.mHighDischargeAmountSinceCharge = 0;
        this.clearHistoryLocked();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setBatteryState(int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl;
        boolean bl2 = n3 == 0;
        int n7 = this.mHistoryCur.batteryStatus;
        if (!this.mHaveBatteryLevel) {
            this.mHaveBatteryLevel = true;
            boolean bl3 = this.mOnBattery;
            if (bl2 != bl3) {
                if (bl2) {
                    int n8;
                    BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                    historyItem.states = n8 = historyItem.states & 0xBFFFFFFF;
                } else {
                    int n9;
                    BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                    historyItem.states = n9 = historyItem.states | 0x40000000;
                }
            }
            n7 = n;
        }
        if (bl2) {
            this.mDischargeCurrentLevel = n4;
            this.mRecordingHistory = true;
        }
        if (bl2 != (bl = this.mOnBattery)) {
            char c;
            char c2;
            byte by;
            byte by2;
            byte by3;
            byte by4;
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.batteryLevel = by4 = (byte)n4;
            BatteryStats.HistoryItem historyItem2 = this.mHistoryCur;
            historyItem2.batteryStatus = by3 = (byte)n;
            BatteryStats.HistoryItem historyItem3 = this.mHistoryCur;
            historyItem3.batteryHealth = by2 = (byte)n2;
            BatteryStats.HistoryItem historyItem4 = this.mHistoryCur;
            historyItem4.batteryPlugType = by = (byte)n3;
            BatteryStats.HistoryItem historyItem5 = this.mHistoryCur;
            historyItem5.batteryTemperature = c2 = (char)n5;
            BatteryStats.HistoryItem historyItem6 = this.mHistoryCur;
            historyItem6.batteryVoltage = c = (char)n6;
            this.setOnBattery(bl2, n7, n4);
        } else {
            int n10;
            int n11;
            int n12;
            int n13;
            boolean bl4 = false;
            if (this.mHistoryCur.batteryLevel != n4) {
                byte by;
                BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                historyItem.batteryLevel = by = (byte)n4;
                bl4 = true;
            }
            if (this.mHistoryCur.batteryStatus != n) {
                byte by;
                BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                historyItem.batteryStatus = by = (byte)n;
                bl4 = true;
            }
            if (this.mHistoryCur.batteryHealth != n2) {
                byte by;
                BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                historyItem.batteryHealth = by = (byte)n2;
                bl4 = true;
            }
            if (this.mHistoryCur.batteryPlugType != n3) {
                byte by;
                BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                historyItem.batteryPlugType = by = (byte)n3;
                bl4 = true;
            }
            if (n5 >= (n13 = this.mHistoryCur.batteryTemperature + 10) || n5 <= (n12 = this.mHistoryCur.batteryTemperature - 10)) {
                char c;
                BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                historyItem.batteryTemperature = c = (char)n5;
                bl4 = true;
            }
            if (n6 > (n11 = this.mHistoryCur.batteryVoltage + 20) || n6 < (n10 = this.mHistoryCur.batteryVoltage - 20)) {
                char c;
                BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                historyItem.batteryVoltage = c = (char)n6;
                bl4 = true;
            }
            if (bl4) {
                long l = SystemClock.elapsedRealtime();
                this.addHistoryRecordLocked(l);
            }
        }
        if (bl2) {
            return;
        }
        if (n != 5) {
            return;
        }
        this.mRecordingHistory = false;
    }

    public void setBtHeadset(BluetoothHeadset bluetoothHeadset) {
        if (bluetoothHeadset != null && this.mBtHeadset == null && this.isOnBattery() && this.mBluetoothPingStart == -1) {
            int n;
            this.mBluetoothPingStart = n = this.getCurrentBluetoothPingCount();
        }
        this.mBtHeadset = bluetoothHeadset;
    }

    public void setCallback(BatteryCallback batteryCallback) {
        this.mCallback = batteryCallback;
    }

    public void setNumSpeedSteps(int n) {
        if (sNumSpeedSteps != 0) {
            return;
        }
        sNumSpeedSteps = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setOnBattery(boolean bl, int n, int n2) {
        synchronized (this) {
            boolean bl2 = false;
            Message message = this.mHandler.obtainMessage(2);
            int n3 = bl ? 1 : 0;
            message.arg1 = n3;
            boolean bl3 = this.mHandler.sendMessage(message);
            this.mOnBatteryInternal = bl;
            this.mOnBattery = bl;
            long l = SystemClock.uptimeMillis() * 1000L;
            long l2 = SystemClock.elapsedRealtime();
            long l3 = l2 * 1000L;
            if (bl) {
                long l4;
                long l5;
                int n4;
                byte by;
                if (n == 5 || n2 >= 90 || this.mDischargeCurrentLevel < 20 && n2 >= 80) {
                    bl2 = true;
                    this.resetAllStatsLocked();
                    this.mDischargeStartLevel = n2;
                }
                this.updateKernelWakelocksLocked();
                BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                historyItem.batteryLevel = by = (byte)n2;
                BatteryStats.HistoryItem historyItem2 = this.mHistoryCur;
                historyItem2.states = n4 = historyItem2.states & 0xBFFFFFFF;
                this.addHistoryRecordLocked(l2);
                this.mTrackBatteryUptimeStart = l;
                this.mTrackBatteryRealtimeStart = l3;
                this.mUnpluggedBatteryUptime = l5 = this.getBatteryUptimeLocked(l);
                this.mUnpluggedBatteryRealtime = l4 = this.getBatteryRealtimeLocked(l3);
                this.mDischargeUnplugLevel = n2;
                this.mDischargeCurrentLevel = n2;
                long l6 = this.mUnpluggedBatteryUptime;
                long l7 = this.mUnpluggedBatteryRealtime;
                this.doUnplugLocked(l6, l7);
            } else {
                long l8;
                long l9;
                int n5;
                byte by;
                this.updateKernelWakelocksLocked();
                BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                historyItem.batteryLevel = by = (byte)n2;
                BatteryStats.HistoryItem historyItem3 = this.mHistoryCur;
                historyItem3.states = n5 = historyItem3.states | 0x40000000;
                this.addHistoryRecordLocked(l2);
                long l10 = this.mTrackBatteryPastUptime;
                long l11 = this.mTrackBatteryUptimeStart;
                long l12 = l - l11;
                this.mTrackBatteryPastUptime = l9 = l10 + l12;
                long l13 = this.mTrackBatteryPastRealtime;
                long l14 = this.mTrackBatteryRealtimeStart;
                long l15 = l3 - l14;
                this.mTrackBatteryPastRealtime = l8 = l13 + l15;
                this.mDischargeCurrentLevel = n2;
                int n6 = this.mDischargeUnplugLevel;
                if (n2 < n6) {
                    int n7;
                    int n8;
                    int n9 = this.mLowDischargeAmountSinceCharge;
                    int n10 = this.mDischargeUnplugLevel - n2 - 1;
                    this.mLowDischargeAmountSinceCharge = n8 = n9 + n10;
                    int n11 = this.mHighDischargeAmountSinceCharge;
                    int n12 = this.mDischargeUnplugLevel - n2;
                    this.mHighDischargeAmountSinceCharge = n7 = n11 + n12;
                }
                long l16 = this.getBatteryUptimeLocked(l);
                long l17 = this.getBatteryRealtimeLocked(l3);
                this.doPlugLocked(l16, l17);
            }
            if ((bl2 || this.mLastWriteTime + 60000L < l2) && this.mFile != null) {
                this.writeAsyncLocked();
            }
            return;
        }
    }

    public void setRadioScanningTimeout(long l) {
        if (this.mPhoneSignalScanningTimer == null) {
            return;
        }
        this.mPhoneSignalScanningTimer.setTimeout(l);
    }

    public void shutdownLocked() {
        this.writeSyncLocked();
        this.mShuttingDown = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int startAddingCpuLocked() {
        this.mHandler.removeMessages(1);
        if (this.mScreenOn) {
            return 0;
        }
        int n = this.mPartialTimers.size();
        if (n == 0) {
            this.mLastPartialTimers.clear();
            return 0;
        }
        int n2 = 0;
        while (n2 < n) {
            Uid uid;
            StopwatchTimer stopwatchTimer = this.mPartialTimers.get(n2);
            if (stopwatchTimer.mInList && (uid = stopwatchTimer.mUid) != null && uid.mUid != 1000) {
                return 50;
            }
            ++n2;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean startIteratingHistoryLocked() {
        BatteryStats.HistoryItem historyItem;
        this.mHistoryIterator = historyItem = this.mHistory;
        if (historyItem == null) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    void stopAllSignalStrengthTimersLocked(int n) {
        int n2 = 0;
        while (n2 < 5) {
            if (n2 == n) {
                while (this.mPhoneSignalStrengthsTimer[n2].isRunningLocked()) {
                    this.mPhoneSignalStrengthsTimer[n2].stopRunningLocked(this);
                }
            }
            ++n2;
        }
        return;
    }

    public void updateKernelWakelocksLocked() {
        int n;
        Map<String, KernelWakelockStats> map = this.readKernelWakelockStats();
        if (map == null) {
            int n2 = Slog.w(TAG, "Couldn't get kernel wake lock stats");
            return;
        }
        for (Map.Entry<String, KernelWakelockStats> entry : map.entrySet()) {
            String string2 = entry.getKey();
            KernelWakelockStats kernelWakelockStats = entry.getValue();
            SamplingTimer samplingTimer = this.mKernelWakelockStats.get(string2);
            if (samplingTimer == null) {
                ArrayList<Unpluggable> arrayList = this.mUnpluggables;
                boolean bl = this.mOnBatteryInternal;
                samplingTimer = new SamplingTimer(arrayList, bl, true);
                SamplingTimer samplingTimer2 = this.mKernelWakelockStats.put(string2, samplingTimer);
            }
            int n3 = kernelWakelockStats.mCount;
            samplingTimer.updateCurrentReportedCount(n3);
            long l = kernelWakelockStats.mTotalTime;
            samplingTimer.updateCurrentReportedTotalTime(l);
            int n4 = sKernelWakelockUpdateVersion;
            samplingTimer.setUpdateVersion(n4);
        }
        int n5 = map.size();
        if (n5 != (n = this.mKernelWakelockStats.size())) {
            return;
        }
        Iterator<Map.Entry<String, Object>> iterator = this.mKernelWakelockStats.entrySet().iterator();
        while (iterator.hasNext()) {
            int n6;
            SamplingTimer samplingTimer = (SamplingTimer)iterator.next().getValue();
            int n7 = samplingTimer.getUpdateVersion();
            if (n7 == (n6 = sKernelWakelockUpdateVersion)) continue;
            samplingTimer.setStale();
        }
        return;
    }

    public void writeAsyncLocked() {
        this.writeLocked(false);
    }

    void writeHistory(Parcel parcel) {
        BatteryStats.HistoryItem historyItem = this.mHistory;
        while (historyItem != null) {
            if (historyItem.time >= 0L) {
                historyItem.writeToParcel(parcel, 0);
            }
            historyItem = historyItem.next;
        }
        parcel.writeLong(65535L);
    }

    void writeLocked(boolean bl) {
        long l;
        if (this.mFile == null) {
            int n = Slog.w("BatteryStats", "writeLocked: no file associated with this instance");
            return;
        }
        if (this.mShuttingDown) {
            return;
        }
        Parcel parcel = Parcel.obtain();
        this.writeSummaryToParcel(parcel);
        this.mLastWriteTime = l = SystemClock.elapsedRealtime();
        if (this.mPendingWrite != null) {
            this.mPendingWrite.recycle();
        }
        this.mPendingWrite = parcel;
        if (bl) {
            this.commitPendingDataToDisk();
            return;
        }
        new Thread("BatteryStats-Write"){

            @Override
            public void run() {
                Process.setThreadPriority(10);
                BatteryStatsImpl.this.commitPendingDataToDisk();
            }
        }.start();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void writeSummaryToParcel(Parcel parcel) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        long l = SystemClock.uptimeMillis() * 1000L;
        long l2 = SystemClock.elapsedRealtime() * 1000L;
        BatteryStatsImpl batteryStatsImpl = this;
        long l3 = l;
        long l4 = batteryStatsImpl.getBatteryUptimeLocked(l3);
        BatteryStatsImpl batteryStatsImpl2 = this;
        long l5 = l2;
        long l6 = batteryStatsImpl2.getBatteryRealtimeLocked(l5);
        Parcel parcel2 = parcel;
        int n7 = 52;
        parcel2.writeInt(n7);
        this.writeHistory(parcel);
        int n8 = this.mStartCount;
        Parcel parcel3 = parcel;
        int n9 = n8;
        parcel3.writeInt(n9);
        BatteryStatsImpl batteryStatsImpl3 = this;
        long l7 = l;
        int n10 = 0;
        long l8 = batteryStatsImpl3.computeBatteryUptime(l7, n10);
        Parcel parcel4 = parcel;
        long l9 = l8;
        parcel4.writeLong(l9);
        BatteryStatsImpl batteryStatsImpl4 = this;
        long l10 = l2;
        int n11 = 0;
        long l11 = batteryStatsImpl4.computeBatteryRealtime(l10, n11);
        Parcel parcel5 = parcel;
        long l12 = l11;
        parcel5.writeLong(l12);
        BatteryStatsImpl batteryStatsImpl5 = this;
        long l13 = l;
        int n12 = 0;
        long l14 = batteryStatsImpl5.computeUptime(l13, n12);
        Parcel parcel6 = parcel;
        long l15 = l14;
        parcel6.writeLong(l15);
        BatteryStatsImpl batteryStatsImpl6 = this;
        long l16 = l2;
        int n13 = 0;
        long l17 = batteryStatsImpl6.computeRealtime(l16, n13);
        Parcel parcel7 = parcel;
        long l18 = l17;
        parcel7.writeLong(l18);
        int n14 = this.mDischargeUnplugLevel;
        Parcel parcel8 = parcel;
        int n15 = n14;
        parcel8.writeInt(n15);
        int n16 = this.mDischargeCurrentLevel;
        Parcel parcel9 = parcel;
        int n17 = n16;
        parcel9.writeInt(n17);
        int n18 = this.getLowDischargeAmountSinceCharge();
        Parcel parcel10 = parcel;
        int n19 = n18;
        parcel10.writeInt(n19);
        int n20 = this.getHighDischargeAmountSinceCharge();
        Parcel parcel11 = parcel;
        int n21 = n20;
        parcel11.writeInt(n21);
        StopwatchTimer stopwatchTimer = this.mScreenOnTimer;
        Parcel parcel12 = parcel;
        long l19 = l6;
        stopwatchTimer.writeSummaryFromParcelLocked(parcel12, l19);
        int n22 = 0;
        while ((n6 = ++n22) < (n5 = 5)) {
            StopwatchTimer stopwatchTimer2 = this.mScreenBrightnessTimer[n22];
            Parcel parcel13 = parcel;
            long l20 = l6;
            stopwatchTimer2.writeSummaryFromParcelLocked(parcel13, l20);
        }
        Counter counter = this.mInputEventCounter;
        Parcel parcel14 = parcel;
        counter.writeSummaryFromParcelLocked(parcel14);
        StopwatchTimer stopwatchTimer3 = this.mPhoneOnTimer;
        Parcel parcel15 = parcel;
        long l21 = l6;
        stopwatchTimer3.writeSummaryFromParcelLocked(parcel15, l21);
        int n23 = 0;
        while ((n4 = ++n23) < (n3 = 5)) {
            StopwatchTimer stopwatchTimer4 = this.mPhoneSignalStrengthsTimer[n23];
            Parcel parcel16 = parcel;
            long l22 = l6;
            stopwatchTimer4.writeSummaryFromParcelLocked(parcel16, l22);
        }
        StopwatchTimer stopwatchTimer5 = this.mPhoneSignalScanningTimer;
        Parcel parcel17 = parcel;
        long l23 = l6;
        stopwatchTimer5.writeSummaryFromParcelLocked(parcel17, l23);
        int n24 = 0;
        while ((n2 = ++n24) < (n = 14)) {
            StopwatchTimer stopwatchTimer6 = this.mPhoneDataConnectionsTimer[n24];
            Parcel parcel18 = parcel;
            long l24 = l6;
            stopwatchTimer6.writeSummaryFromParcelLocked(parcel18, l24);
        }
        StopwatchTimer stopwatchTimer7 = this.mWifiOnTimer;
        Parcel parcel19 = parcel;
        long l25 = l6;
        stopwatchTimer7.writeSummaryFromParcelLocked(parcel19, l25);
        StopwatchTimer stopwatchTimer8 = this.mGlobalWifiRunningTimer;
        Parcel parcel20 = parcel;
        long l26 = l6;
        stopwatchTimer8.writeSummaryFromParcelLocked(parcel20, l26);
        StopwatchTimer stopwatchTimer9 = this.mBluetoothOnTimer;
        Parcel parcel21 = parcel;
        long l27 = l6;
        stopwatchTimer9.writeSummaryFromParcelLocked(parcel21, l27);
        int n25 = this.mKernelWakelockStats.size();
        Parcel parcel22 = parcel;
        int n26 = n25;
        parcel22.writeInt(n26);
        for (Map.Entry<String, SamplingTimer> entry : this.mKernelWakelockStats.entrySet()) {
            if ((Timer)entry.getValue() != null) {
                Parcel parcel23 = parcel;
                int n27 = 1;
                parcel23.writeInt(n27);
                String string2 = entry.getKey();
                Parcel parcel24 = parcel;
                String string3 = string2;
                parcel24.writeString(string3);
                SamplingTimer samplingTimer = entry.getValue();
                Parcel parcel25 = parcel;
                long l28 = l6;
                samplingTimer.writeSummaryFromParcelLocked(parcel25, l28);
                continue;
            }
            Parcel parcel26 = parcel;
            int n28 = 0;
            parcel26.writeInt(n28);
        }
        int n29 = sNumSpeedSteps;
        Parcel parcel27 = parcel;
        int n30 = n29;
        parcel27.writeInt(n30);
        int n31 = this.mUidStats.size();
        Parcel parcel28 = parcel;
        int n32 = n31;
        parcel28.writeInt(n32);
        int n33 = 0;
        int n34;
        int n35;
        while ((n35 = ++n33) < (n34 = n31)) {
            SparseArray<Uid> sparseArray = this.mUidStats;
            int n36 = n33;
            int n37 = sparseArray.keyAt(n36);
            Parcel parcel29 = parcel;
            int n38 = n37;
            parcel29.writeInt(n38);
            SparseArray<Uid> sparseArray2 = this.mUidStats;
            int n39 = n33;
            Uid uid = sparseArray2.valueAt(n39);
            if (uid.mWifiRunningTimer != null) {
                Parcel parcel30 = parcel;
                int n40 = 1;
                parcel30.writeInt(n40);
                StopwatchTimer stopwatchTimer10 = uid.mWifiRunningTimer;
                Parcel parcel31 = parcel;
                long l29 = l6;
                stopwatchTimer10.writeSummaryFromParcelLocked(parcel31, l29);
            } else {
                Parcel parcel32 = parcel;
                int n41 = 0;
                parcel32.writeInt(n41);
            }
            if (uid.mFullWifiLockTimer != null) {
                Parcel parcel33 = parcel;
                int n42 = 1;
                parcel33.writeInt(n42);
                StopwatchTimer stopwatchTimer11 = uid.mFullWifiLockTimer;
                Parcel parcel34 = parcel;
                long l30 = l6;
                stopwatchTimer11.writeSummaryFromParcelLocked(parcel34, l30);
            } else {
                Parcel parcel35 = parcel;
                int n43 = 0;
                parcel35.writeInt(n43);
            }
            if (uid.mScanWifiLockTimer != null) {
                Parcel parcel36 = parcel;
                int n44 = 1;
                parcel36.writeInt(n44);
                StopwatchTimer stopwatchTimer12 = uid.mScanWifiLockTimer;
                Parcel parcel37 = parcel;
                long l31 = l6;
                stopwatchTimer12.writeSummaryFromParcelLocked(parcel37, l31);
            } else {
                Parcel parcel38 = parcel;
                int n45 = 0;
                parcel38.writeInt(n45);
            }
            if (uid.mWifiMulticastTimer != null) {
                Parcel parcel39 = parcel;
                int n46 = 1;
                parcel39.writeInt(n46);
                StopwatchTimer stopwatchTimer13 = uid.mWifiMulticastTimer;
                Parcel parcel40 = parcel;
                long l32 = l6;
                stopwatchTimer13.writeSummaryFromParcelLocked(parcel40, l32);
            } else {
                Parcel parcel41 = parcel;
                int n47 = 0;
                parcel41.writeInt(n47);
            }
            if (uid.mAudioTurnedOnTimer != null) {
                Parcel parcel42 = parcel;
                int n48 = 1;
                parcel42.writeInt(n48);
                StopwatchTimer stopwatchTimer14 = uid.mAudioTurnedOnTimer;
                Parcel parcel43 = parcel;
                long l33 = l6;
                stopwatchTimer14.writeSummaryFromParcelLocked(parcel43, l33);
            } else {
                Parcel parcel44 = parcel;
                int n49 = 0;
                parcel44.writeInt(n49);
            }
            if (uid.mVideoTurnedOnTimer != null) {
                Parcel parcel45 = parcel;
                int n50 = 1;
                parcel45.writeInt(n50);
                StopwatchTimer stopwatchTimer15 = uid.mVideoTurnedOnTimer;
                Parcel parcel46 = parcel;
                long l34 = l6;
                stopwatchTimer15.writeSummaryFromParcelLocked(parcel46, l34);
            } else {
                Parcel parcel47 = parcel;
                int n51 = 0;
                parcel47.writeInt(n51);
            }
            if (uid.mUserActivityCounters == null) {
                Parcel parcel48 = parcel;
                int n52 = 0;
                parcel48.writeInt(n52);
            } else {
                int n53;
                int n54;
                Parcel parcel49 = parcel;
                int n55 = 1;
                parcel49.writeInt(n55);
                n24 = 0;
                while ((n54 = ++n24) < (n53 = 7)) {
                    Counter counter2 = uid.mUserActivityCounters[n24];
                    Parcel parcel50 = parcel;
                    counter2.writeSummaryFromParcelLocked(parcel50);
                }
            }
            int n56 = uid.mWakelockStats.size();
            Parcel parcel51 = parcel;
            int n57 = n56;
            parcel51.writeInt(n57);
            if (n56 > 0) {
                for (Map.Entry<String, Object> entry : uid.mWakelockStats.entrySet()) {
                    String string4 = entry.getKey();
                    Parcel parcel52 = parcel;
                    String string5 = string4;
                    parcel52.writeString(string5);
                    Uid.Wakelock wakelock = (Uid.Wakelock)entry.getValue();
                    if (wakelock.mTimerFull != null) {
                        Parcel parcel53 = parcel;
                        int n58 = 1;
                        parcel53.writeInt(n58);
                        StopwatchTimer stopwatchTimer16 = wakelock.mTimerFull;
                        Parcel parcel54 = parcel;
                        long l35 = l6;
                        stopwatchTimer16.writeSummaryFromParcelLocked(parcel54, l35);
                    } else {
                        Parcel parcel55 = parcel;
                        int n59 = 0;
                        parcel55.writeInt(n59);
                    }
                    if (wakelock.mTimerPartial != null) {
                        Parcel parcel56 = parcel;
                        int n60 = 1;
                        parcel56.writeInt(n60);
                        StopwatchTimer stopwatchTimer17 = wakelock.mTimerPartial;
                        Parcel parcel57 = parcel;
                        long l36 = l6;
                        stopwatchTimer17.writeSummaryFromParcelLocked(parcel57, l36);
                    } else {
                        Parcel parcel58 = parcel;
                        int n61 = 0;
                        parcel58.writeInt(n61);
                    }
                    if (wakelock.mTimerWindow != null) {
                        Parcel parcel59 = parcel;
                        int n62 = 1;
                        parcel59.writeInt(n62);
                        StopwatchTimer stopwatchTimer18 = wakelock.mTimerWindow;
                        Parcel parcel60 = parcel;
                        long l37 = l6;
                        stopwatchTimer18.writeSummaryFromParcelLocked(parcel60, l37);
                        continue;
                    }
                    Parcel parcel61 = parcel;
                    int n63 = 0;
                    parcel61.writeInt(n63);
                }
            }
            int n64 = uid.mSensorStats.size();
            Parcel parcel62 = parcel;
            int n65 = n64;
            parcel62.writeInt(n65);
            if (n64 > 0) {
                for (Map.Entry<Object, Object> entry : uid.mSensorStats.entrySet()) {
                    int n66 = (Integer)entry.getKey();
                    Parcel parcel63 = parcel;
                    int n67 = n66;
                    parcel63.writeInt(n67);
                    Uid.Sensor sensor = (Uid.Sensor)entry.getValue();
                    if (sensor.mTimer != null) {
                        Parcel parcel64 = parcel;
                        int n68 = 1;
                        parcel64.writeInt(n68);
                        StopwatchTimer stopwatchTimer19 = sensor.mTimer;
                        Parcel parcel65 = parcel;
                        long l38 = l6;
                        stopwatchTimer19.writeSummaryFromParcelLocked(parcel65, l38);
                        continue;
                    }
                    Parcel parcel66 = parcel;
                    int n69 = 0;
                    parcel66.writeInt(n69);
                }
            }
            int n70 = uid.mProcessStats.size();
            Parcel parcel67 = parcel;
            int n71 = n70;
            parcel67.writeInt(n71);
            if (n70 > 0) {
                for (Map.Entry<Object, Object> entry : uid.mProcessStats.entrySet()) {
                    int n72;
                    int n73;
                    String string6 = (String)entry.getKey();
                    Parcel parcel68 = parcel;
                    String string7 = string6;
                    parcel68.writeString(string7);
                    Uid.Proc proc = (Uid.Proc)entry.getValue();
                    long l39 = proc.mUserTime;
                    Parcel parcel69 = parcel;
                    long l40 = l39;
                    parcel69.writeLong(l40);
                    long l41 = proc.mSystemTime;
                    Parcel parcel70 = parcel;
                    long l42 = l41;
                    parcel70.writeLong(l42);
                    int n74 = proc.mStarts;
                    Parcel parcel71 = parcel;
                    int n75 = n74;
                    parcel71.writeInt(n75);
                    int n76 = proc.mSpeedBins.length;
                    Parcel parcel72 = parcel;
                    int n77 = n76;
                    parcel72.writeInt(n77);
                    n24 = 0;
                    while ((n73 = n24) < (n72 = n76)) {
                        if (proc.mSpeedBins[n24] != null) {
                            Parcel parcel73 = parcel;
                            int n78 = 1;
                            parcel73.writeInt(n78);
                            SamplingCounter samplingCounter = proc.mSpeedBins[n24];
                            Parcel parcel74 = parcel;
                            samplingCounter.writeSummaryFromParcelLocked(parcel74);
                        } else {
                            Parcel parcel75 = parcel;
                            int n79 = 0;
                            parcel75.writeInt(n79);
                        }
                        int n80 = n24 + 1;
                    }
                    Uid.Proc proc2 = proc;
                    Parcel parcel76 = parcel;
                    proc2.writeExcessivePowerToParcelLocked(parcel76);
                }
            }
            int n81 = uid.mPackageStats.size();
            Parcel parcel77 = parcel;
            int n82 = n81;
            parcel77.writeInt(n82);
            if (n81 > 0) {
                for (Map.Entry<Object, Object> entry : uid.mPackageStats.entrySet()) {
                    String string8 = (String)entry.getKey();
                    Parcel parcel78 = parcel;
                    String string9 = string8;
                    parcel78.writeString(string9);
                    Uid.Pkg pkg = (Uid.Pkg)entry.getValue();
                    int n83 = pkg.mWakeups;
                    Parcel parcel79 = parcel;
                    int n84 = n83;
                    parcel79.writeInt(n84);
                    int n85 = pkg.mServiceStats.size();
                    Parcel parcel80 = parcel;
                    int n86 = n85;
                    parcel80.writeInt(n86);
                    if (n85 <= 0) continue;
                    for (Map.Entry<String, Uid.Pkg.Serv> entry2 : pkg.mServiceStats.entrySet()) {
                        Uid.Pkg.Serv serv;
                        String string10 = entry2.getKey();
                        Parcel parcel81 = parcel;
                        String string11 = string10;
                        parcel81.writeString(string11);
                        Uid.Pkg.Serv serv2 = serv = entry2.getValue();
                        long l43 = l4;
                        long l44 = serv2.getStartTimeToNowLocked(l43);
                        Parcel parcel82 = parcel;
                        long l45 = l44;
                        parcel82.writeLong(l45);
                        int n87 = serv.mStarts;
                        Parcel parcel83 = parcel;
                        int n88 = n87;
                        parcel83.writeInt(n88);
                        int n89 = serv.mLaunches;
                        Parcel parcel84 = parcel;
                        int n90 = n89;
                        parcel84.writeInt(n90);
                    }
                }
            }
            Uid uid2 = uid;
            int n91 = 0;
            long l46 = uid2.getTcpBytesReceived(n91);
            Parcel parcel85 = parcel;
            long l47 = l46;
            parcel85.writeLong(l47);
            Uid uid3 = uid;
            int n92 = 0;
            long l48 = uid3.getTcpBytesSent(n92);
            Parcel parcel86 = parcel;
            long l49 = l48;
            parcel86.writeLong(l49);
        }
        return;
    }

    public void writeSyncLocked() {
        this.writeLocked(true);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        this.writeToParcelLocked(parcel, true, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    void writeToParcelLocked(Parcel parcel, boolean bl, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        long l = SystemClock.uptimeMillis() * 1000L;
        long l2 = SystemClock.elapsedRealtime() * 1000L;
        BatteryStatsImpl batteryStatsImpl = this;
        long l3 = l;
        long l4 = batteryStatsImpl.getBatteryUptimeLocked(l3);
        BatteryStatsImpl batteryStatsImpl2 = this;
        long l5 = l2;
        long l6 = batteryStatsImpl2.getBatteryRealtimeLocked(l5);
        Parcel parcel2 = parcel;
        int n8 = -1166707595;
        parcel2.writeInt(n8);
        this.writeHistory(parcel);
        int n9 = this.mStartCount;
        Parcel parcel3 = parcel;
        int n10 = n9;
        parcel3.writeInt(n10);
        long l7 = this.mBatteryUptime;
        Parcel parcel4 = parcel;
        long l8 = l7;
        parcel4.writeLong(l8);
        long l9 = this.mBatteryRealtime;
        Parcel parcel5 = parcel;
        long l10 = l9;
        parcel5.writeLong(l10);
        StopwatchTimer stopwatchTimer = this.mScreenOnTimer;
        Parcel parcel6 = parcel;
        long l11 = l6;
        stopwatchTimer.writeToParcel(parcel6, l11);
        int n11 = 0;
        while ((n7 = ++n11) < (n6 = 5)) {
            StopwatchTimer stopwatchTimer2 = this.mScreenBrightnessTimer[n11];
            Parcel parcel7 = parcel;
            long l12 = l6;
            stopwatchTimer2.writeToParcel(parcel7, l12);
        }
        Counter counter = this.mInputEventCounter;
        Parcel parcel8 = parcel;
        counter.writeToParcel(parcel8);
        StopwatchTimer stopwatchTimer3 = this.mPhoneOnTimer;
        Parcel parcel9 = parcel;
        long l13 = l6;
        stopwatchTimer3.writeToParcel(parcel9, l13);
        int n12 = 0;
        while ((n5 = ++n12) < (n4 = 5)) {
            StopwatchTimer stopwatchTimer4 = this.mPhoneSignalStrengthsTimer[n12];
            Parcel parcel10 = parcel;
            long l14 = l6;
            stopwatchTimer4.writeToParcel(parcel10, l14);
        }
        StopwatchTimer stopwatchTimer5 = this.mPhoneSignalScanningTimer;
        Parcel parcel11 = parcel;
        long l15 = l6;
        stopwatchTimer5.writeToParcel(parcel11, l15);
        int n13 = 0;
        while ((n3 = n13) < (n2 = 14)) {
            StopwatchTimer stopwatchTimer6 = this.mPhoneDataConnectionsTimer[n13];
            Parcel parcel12 = parcel;
            long l16 = l6;
            stopwatchTimer6.writeToParcel(parcel12, l16);
            int n14 = n13 + 1;
        }
        StopwatchTimer stopwatchTimer7 = this.mWifiOnTimer;
        Parcel parcel13 = parcel;
        long l17 = l6;
        stopwatchTimer7.writeToParcel(parcel13, l17);
        StopwatchTimer stopwatchTimer8 = this.mGlobalWifiRunningTimer;
        Parcel parcel14 = parcel;
        long l18 = l6;
        stopwatchTimer8.writeToParcel(parcel14, l18);
        StopwatchTimer stopwatchTimer9 = this.mBluetoothOnTimer;
        Parcel parcel15 = parcel;
        long l19 = l6;
        stopwatchTimer9.writeToParcel(parcel15, l19);
        long l20 = this.mUptime;
        Parcel parcel16 = parcel;
        long l21 = l20;
        parcel16.writeLong(l21);
        long l22 = this.mUptimeStart;
        Parcel parcel17 = parcel;
        long l23 = l22;
        parcel17.writeLong(l23);
        long l24 = this.mRealtime;
        Parcel parcel18 = parcel;
        long l25 = l24;
        parcel18.writeLong(l25);
        long l26 = this.mRealtimeStart;
        Parcel parcel19 = parcel;
        long l27 = l26;
        parcel19.writeLong(l27);
        int n15 = this.mOnBattery ? 1 : 0;
        Parcel parcel20 = parcel;
        int n16 = n15;
        parcel20.writeInt(n16);
        Parcel parcel21 = parcel;
        long l28 = l4;
        parcel21.writeLong(l28);
        long l29 = this.mTrackBatteryUptimeStart;
        Parcel parcel22 = parcel;
        long l30 = l29;
        parcel22.writeLong(l30);
        Parcel parcel23 = parcel;
        long l31 = l6;
        parcel23.writeLong(l31);
        long l32 = this.mTrackBatteryRealtimeStart;
        Parcel parcel24 = parcel;
        long l33 = l32;
        parcel24.writeLong(l33);
        long l34 = this.mUnpluggedBatteryUptime;
        Parcel parcel25 = parcel;
        long l35 = l34;
        parcel25.writeLong(l35);
        long l36 = this.mUnpluggedBatteryRealtime;
        Parcel parcel26 = parcel;
        long l37 = l36;
        parcel26.writeLong(l37);
        int n17 = this.mDischargeUnplugLevel;
        Parcel parcel27 = parcel;
        int n18 = n17;
        parcel27.writeInt(n18);
        int n19 = this.mDischargeCurrentLevel;
        Parcel parcel28 = parcel;
        int n20 = n19;
        parcel28.writeInt(n20);
        int n21 = this.mLowDischargeAmountSinceCharge;
        Parcel parcel29 = parcel;
        int n22 = n21;
        parcel29.writeInt(n22);
        int n23 = this.mHighDischargeAmountSinceCharge;
        Parcel parcel30 = parcel;
        int n24 = n23;
        parcel30.writeInt(n24);
        long l38 = this.mLastWriteTime;
        Parcel parcel31 = parcel;
        long l39 = l38;
        parcel31.writeLong(l39);
        BatteryStatsImpl batteryStatsImpl3 = this;
        int n25 = 3;
        long l40 = batteryStatsImpl3.getMobileTcpBytesReceived(n25);
        Parcel parcel32 = parcel;
        long l41 = l40;
        parcel32.writeLong(l41);
        BatteryStatsImpl batteryStatsImpl4 = this;
        int n26 = 3;
        long l42 = batteryStatsImpl4.getMobileTcpBytesSent(n26);
        Parcel parcel33 = parcel;
        long l43 = l42;
        parcel33.writeLong(l43);
        BatteryStatsImpl batteryStatsImpl5 = this;
        int n27 = 3;
        long l44 = batteryStatsImpl5.getTotalTcpBytesReceived(n27);
        Parcel parcel34 = parcel;
        long l45 = l44;
        parcel34.writeLong(l45);
        BatteryStatsImpl batteryStatsImpl6 = this;
        int n28 = 3;
        long l46 = batteryStatsImpl6.getTotalTcpBytesSent(n28);
        Parcel parcel35 = parcel;
        long l47 = l46;
        parcel35.writeLong(l47);
        long l48 = this.getRadioDataUptime();
        Parcel parcel36 = parcel;
        long l49 = l48;
        parcel36.writeLong(l49);
        int n29 = this.getBluetoothPingCount();
        Parcel parcel37 = parcel;
        int n30 = n29;
        parcel37.writeInt(n30);
        if (!bl) {
            Parcel parcel38 = parcel;
            int n31 = 0;
            parcel38.writeInt(n31);
        } else {
            int n32 = this.mKernelWakelockStats.size();
            Parcel parcel39 = parcel;
            int n33 = n32;
            parcel39.writeInt(n33);
            for (Map.Entry<String, SamplingTimer> entry : this.mKernelWakelockStats.entrySet()) {
                SamplingTimer samplingTimer = entry.getValue();
                if (samplingTimer != null) {
                    Parcel parcel40 = parcel;
                    int n34 = 1;
                    parcel40.writeInt(n34);
                    String string2 = entry.getKey();
                    Parcel parcel41 = parcel;
                    String string3 = string2;
                    parcel41.writeString(string3);
                    Parcel parcel42 = parcel;
                    SamplingTimer samplingTimer2 = samplingTimer;
                    long l50 = l6;
                    Timer.writeTimerToParcel(parcel42, samplingTimer2, l50);
                    continue;
                }
                Parcel parcel43 = parcel;
                int n35 = 0;
                parcel43.writeInt(n35);
            }
        }
        int n36 = sNumSpeedSteps;
        Parcel parcel44 = parcel;
        int n37 = n36;
        parcel44.writeInt(n37);
        if (!bl) {
            Parcel parcel45 = parcel;
            int n38 = 0;
            parcel45.writeInt(n38);
            return;
        }
        int n39 = this.mUidStats.size();
        Parcel parcel46 = parcel;
        int n40 = n39;
        parcel46.writeInt(n40);
        n13 = 0;
        while (n13 < n39) {
            SparseArray<Uid> sparseArray = this.mUidStats;
            int n41 = n13;
            int n42 = sparseArray.keyAt(n41);
            Parcel parcel47 = parcel;
            int n43 = n42;
            parcel47.writeInt(n43);
            SparseArray<Uid> sparseArray2 = this.mUidStats;
            int n44 = n13++;
            Uid uid = sparseArray2.valueAt(n44);
            Parcel parcel48 = parcel;
            long l51 = l6;
            uid.writeToParcelLocked(parcel48, l51);
        }
        return;
    }

    public void writeToParcelWithoutUids(Parcel parcel, int n) {
        this.writeToParcelLocked(parcel, false, n);
    }

    public final class Uid
    extends BatteryStats.Uid {
        boolean mAudioTurnedOn;
        StopwatchTimer mAudioTurnedOnTimer;
        long mCurrentTcpBytesReceived;
        long mCurrentTcpBytesSent;
        boolean mFullWifiLockOut;
        StopwatchTimer mFullWifiLockTimer;
        long mLoadedTcpBytesReceived;
        long mLoadedTcpBytesSent;
        final HashMap<String, Pkg> mPackageStats;
        final SparseArray<BatteryStats.Uid.Pid> mPids;
        final HashMap<String, Proc> mProcessStats;
        boolean mScanWifiLockOut;
        StopwatchTimer mScanWifiLockTimer;
        final HashMap<Integer, Sensor> mSensorStats;
        long mStartedTcpBytesReceived = 65535L;
        long mStartedTcpBytesSent = 65535L;
        long mTcpBytesReceivedAtLastUnplug;
        long mTcpBytesSentAtLastUnplug;
        final int mUid;
        Counter[] mUserActivityCounters;
        boolean mVideoTurnedOn;
        StopwatchTimer mVideoTurnedOnTimer;
        final HashMap<String, Wakelock> mWakelockStats;
        boolean mWifiMulticastEnabled;
        StopwatchTimer mWifiMulticastTimer;
        boolean mWifiRunning;
        StopwatchTimer mWifiRunningTimer;

        public Uid(int n) {
            StopwatchTimer stopwatchTimer;
            StopwatchTimer stopwatchTimer2;
            StopwatchTimer stopwatchTimer3;
            StopwatchTimer stopwatchTimer4;
            StopwatchTimer stopwatchTimer5;
            StopwatchTimer stopwatchTimer6;
            HashMap hashMap = new HashMap();
            this.mWakelockStats = hashMap;
            HashMap hashMap2 = new HashMap();
            this.mSensorStats = hashMap2;
            HashMap hashMap3 = new HashMap();
            this.mProcessStats = hashMap3;
            HashMap hashMap4 = new HashMap();
            this.mPackageStats = hashMap4;
            SparseArray sparseArray = new SparseArray();
            this.mPids = sparseArray;
            this.mUid = n;
            ArrayList<StopwatchTimer> arrayList = BatteryStatsImpl.this.mWifiRunningTimers;
            ArrayList<Unpluggable> arrayList2 = BatteryStatsImpl.this.mUnpluggables;
            this.mWifiRunningTimer = stopwatchTimer6 = new StopwatchTimer(this, 4, arrayList, arrayList2);
            ArrayList<StopwatchTimer> arrayList3 = BatteryStatsImpl.this.mFullWifiLockTimers;
            ArrayList<Unpluggable> arrayList4 = BatteryStatsImpl.this.mUnpluggables;
            this.mFullWifiLockTimer = stopwatchTimer5 = new StopwatchTimer(this, 5, arrayList3, arrayList4);
            ArrayList<StopwatchTimer> arrayList5 = BatteryStatsImpl.this.mScanWifiLockTimers;
            ArrayList<Unpluggable> arrayList6 = BatteryStatsImpl.this.mUnpluggables;
            this.mScanWifiLockTimer = stopwatchTimer4 = new StopwatchTimer(this, 6, arrayList5, arrayList6);
            ArrayList<StopwatchTimer> arrayList7 = BatteryStatsImpl.this.mWifiMulticastTimers;
            ArrayList<Unpluggable> arrayList8 = BatteryStatsImpl.this.mUnpluggables;
            this.mWifiMulticastTimer = stopwatchTimer3 = new StopwatchTimer(this, 7, arrayList7, arrayList8);
            ArrayList<Unpluggable> arrayList9 = BatteryStatsImpl.this.mUnpluggables;
            this.mAudioTurnedOnTimer = stopwatchTimer2 = new StopwatchTimer(this, 7, null, arrayList9);
            ArrayList<Unpluggable> arrayList10 = BatteryStatsImpl.this.mUnpluggables;
            this.mVideoTurnedOnTimer = stopwatchTimer = new StopwatchTimer(this, 8, null, arrayList10);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public long computeCurrentTcpBytesReceived() {
            long l;
            long l2 = this.mCurrentTcpBytesReceived;
            if (this.mStartedTcpBytesReceived >= 0L) {
                long l3 = TrafficStats.getUidRxBytes(this.mUid);
                long l4 = this.mStartedTcpBytesReceived;
                l = l3 - l4;
                return l2 + l;
            }
            l = 0L;
            return l2 + l;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public long computeCurrentTcpBytesSent() {
            long l;
            long l2 = this.mCurrentTcpBytesSent;
            if (this.mStartedTcpBytesSent >= 0L) {
                long l3 = TrafficStats.getUidTxBytes(this.mUid);
                long l4 = this.mStartedTcpBytesSent;
                l = l3 - l4;
                return l2 + l;
            }
            l = 0L;
            return l2 + l;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long getAudioTurnedOnTime(long l, int n) {
            if (this.mAudioTurnedOnTimer != null) return this.mAudioTurnedOnTimer.getTotalTimeLocked(l, n);
            return 0L;
        }

        public BatteryStatsImpl getBatteryStats() {
            return BatteryStatsImpl.this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long getFullWifiLockTime(long l, int n) {
            if (this.mFullWifiLockTimer != null) return this.mFullWifiLockTimer.getTotalTimeLocked(l, n);
            return 0L;
        }

        @Override
        public Map<String, ? extends BatteryStats.Uid.Pkg> getPackageStats() {
            return this.mPackageStats;
        }

        public Pkg getPackageStatsLocked(String string2) {
            Pkg pkg = this.mPackageStats.get(string2);
            if (pkg == null) {
                pkg = new Pkg();
                Pkg pkg2 = this.mPackageStats.put(string2, pkg);
            }
            return pkg;
        }

        @Override
        public SparseArray<? extends BatteryStats.Uid.Pid> getPidStats() {
            return this.mPids;
        }

        public BatteryStats.Uid.Pid getPidStatsLocked(int n) {
            BatteryStats.Uid.Pid pid = this.mPids.get(n);
            if (pid == null) {
                pid = new BatteryStats.Uid.Pid();
                this.mPids.put(n, pid);
            }
            return pid;
        }

        @Override
        public Map<String, ? extends BatteryStats.Uid.Proc> getProcessStats() {
            return this.mProcessStats;
        }

        public Proc getProcessStatsLocked(String string2) {
            Proc proc = this.mProcessStats.get(string2);
            if (proc == null) {
                proc = new Proc();
                Proc proc2 = this.mProcessStats.put(string2, proc);
            }
            return proc;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long getScanWifiLockTime(long l, int n) {
            if (this.mScanWifiLockTimer != null) return this.mScanWifiLockTimer.getTotalTimeLocked(l, n);
            return 0L;
        }

        @Override
        public Map<Integer, ? extends BatteryStats.Uid.Sensor> getSensorStats() {
            return this.mSensorStats;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public StopwatchTimer getSensorTimerLocked(int n, boolean bl) {
            void var11_13;
            StopwatchTimer stopwatchTimer;
            StopwatchTimer stopwatchTimer2;
            HashMap<Integer, Sensor> hashMap = this.mSensorStats;
            Integer n2 = n;
            Sensor sensor = hashMap.get(n2);
            if (sensor == null) {
                if (!bl) {
                    return null;
                }
                sensor = new Sensor(n);
                HashMap<Integer, Sensor> hashMap2 = this.mSensorStats;
                Integer n3 = n;
                Sensor sensor2 = hashMap2.put(n3, sensor);
            }
            if ((stopwatchTimer2 = sensor.mTimer) != null) {
                return stopwatchTimer2;
            }
            ArrayList<StopwatchTimer> arrayList = BatteryStatsImpl.this.mSensorTimers.get(n);
            if (arrayList == null) {
                ArrayList arrayList2 = new ArrayList();
                BatteryStatsImpl.this.mSensorTimers.put(n, arrayList2);
            }
            ArrayList<Unpluggable> arrayList3 = BatteryStatsImpl.this.mUnpluggables;
            sensor.mTimer = stopwatchTimer = new StopwatchTimer(this, 3, (ArrayList<StopwatchTimer>)var11_13, arrayList3);
            return stopwatchTimer;
        }

        public Pkg.Serv getServiceStatsLocked(String string2, String string3) {
            Pkg pkg = this.getPackageStatsLocked(string2);
            Pkg.Serv serv = pkg.mServiceStats.get(string3);
            if (serv == null) {
                serv = pkg.newServiceStatsLocked();
                Pkg.Serv serv2 = pkg.mServiceStats.put(string3, serv);
            }
            return serv;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long getTcpBytesReceived(int n) {
            if (n == 1) {
                return this.mLoadedTcpBytesReceived;
            }
            long l = this.computeCurrentTcpBytesReceived();
            if (n == 3) {
                long l2 = this.mTcpBytesReceivedAtLastUnplug;
                l -= l2;
                return l;
            }
            if (n != 0) return l;
            long l3 = this.mLoadedTcpBytesReceived;
            l += l3;
            return l;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long getTcpBytesSent(int n) {
            if (n == 1) {
                return this.mLoadedTcpBytesSent;
            }
            long l = this.computeCurrentTcpBytesSent();
            if (n == 3) {
                long l2 = this.mTcpBytesSentAtLastUnplug;
                l -= l2;
                return l;
            }
            if (n != 0) return l;
            long l3 = this.mLoadedTcpBytesSent;
            l += l3;
            return l;
        }

        @Override
        public int getUid() {
            return this.mUid;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getUserActivityCount(int n, int n2) {
            if (this.mUserActivityCounters != null) return this.mUserActivityCounters[n].getCountLocked(n2);
            return 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long getVideoTurnedOnTime(long l, int n) {
            if (this.mVideoTurnedOnTimer != null) return this.mVideoTurnedOnTimer.getTotalTimeLocked(l, n);
            return 0L;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public StopwatchTimer getWakeTimerLocked(String string2, int n) {
            Wakelock wakelock = this.mWakelockStats.get(string2);
            if (wakelock == null) {
                if (this.mWakelockStats.size() > 30) {
                    string2 = BatteryStatsImpl.BATCHED_WAKELOCK_NAME;
                    wakelock = this.mWakelockStats.get(string2);
                }
                if (wakelock == null) {
                    wakelock = new Wakelock();
                    Wakelock wakelock2 = this.mWakelockStats.put(string2, wakelock);
                }
            }
            switch (n) {
                default: {
                    String string3 = "type=" + n;
                    throw new IllegalArgumentException(string3);
                }
                case 0: {
                    StopwatchTimer stopwatchTimer;
                    StopwatchTimer stopwatchTimer2 = wakelock.mTimerPartial;
                    if (stopwatchTimer2 != null) return stopwatchTimer2;
                    ArrayList<StopwatchTimer> arrayList = BatteryStatsImpl.this.mPartialTimers;
                    ArrayList<Unpluggable> arrayList2 = BatteryStatsImpl.this.mUnpluggables;
                    wakelock.mTimerPartial = stopwatchTimer = new StopwatchTimer(this, 0, arrayList, arrayList2);
                    return stopwatchTimer2;
                }
                case 1: {
                    StopwatchTimer stopwatchTimer;
                    StopwatchTimer stopwatchTimer3 = wakelock.mTimerFull;
                    if (stopwatchTimer3 != null) return stopwatchTimer3;
                    ArrayList<StopwatchTimer> arrayList = BatteryStatsImpl.this.mFullTimers;
                    ArrayList<Unpluggable> arrayList3 = BatteryStatsImpl.this.mUnpluggables;
                    wakelock.mTimerFull = stopwatchTimer = new StopwatchTimer(this, 1, arrayList, arrayList3);
                    return stopwatchTimer3;
                }
                case 2: 
            }
            StopwatchTimer stopwatchTimer = wakelock.mTimerWindow;
            if (stopwatchTimer != null) return stopwatchTimer;
            ArrayList<StopwatchTimer> arrayList = BatteryStatsImpl.this.mWindowTimers;
            ArrayList<Unpluggable> arrayList4 = BatteryStatsImpl.this.mUnpluggables;
            wakelock.mTimerWindow = stopwatchTimer = new StopwatchTimer(this, 2, arrayList, arrayList4);
            return stopwatchTimer;
        }

        @Override
        public Map<String, ? extends BatteryStats.Uid.Wakelock> getWakelockStats() {
            return this.mWakelockStats;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long getWifiMulticastTime(long l, int n) {
            if (this.mWifiMulticastTimer != null) return this.mWifiMulticastTimer.getTotalTimeLocked(l, n);
            return 0L;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long getWifiRunningTime(long l, int n) {
            if (this.mWifiRunningTimer != null) return this.mWifiRunningTimer.getTotalTimeLocked(l, n);
            return 0L;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean hasUserActivity() {
            if (this.mUserActivityCounters == null) return false;
            return true;
        }

        void initUserActivityLocked() {
            Counter[] counterArray = new Counter[7];
            this.mUserActivityCounters = counterArray;
            int n = 0;
            while (n < 7) {
                Counter counter;
                Counter[] counterArray2 = this.mUserActivityCounters;
                ArrayList<Unpluggable> arrayList = BatteryStatsImpl.this.mUnpluggables;
                counterArray2[n] = counter = new Counter(arrayList);
                ++n;
            }
            return;
        }

        @Override
        public void noteAudioTurnedOffLocked() {
            if (!this.mAudioTurnedOn) {
                return;
            }
            this.mAudioTurnedOn = false;
            StopwatchTimer stopwatchTimer = this.mAudioTurnedOnTimer;
            BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
            stopwatchTimer.stopRunningLocked(batteryStatsImpl);
        }

        @Override
        public void noteAudioTurnedOnLocked() {
            if (this.mAudioTurnedOn) {
                return;
            }
            this.mAudioTurnedOn = true;
            if (this.mAudioTurnedOnTimer == null) {
                StopwatchTimer stopwatchTimer;
                ArrayList<Unpluggable> arrayList = BatteryStatsImpl.this.mUnpluggables;
                this.mAudioTurnedOnTimer = stopwatchTimer = new StopwatchTimer(this, 7, null, arrayList);
            }
            StopwatchTimer stopwatchTimer = this.mAudioTurnedOnTimer;
            BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
            stopwatchTimer.startRunningLocked(batteryStatsImpl);
        }

        @Override
        public void noteFullWifiLockAcquiredLocked() {
            if (this.mFullWifiLockOut) {
                return;
            }
            this.mFullWifiLockOut = true;
            if (this.mFullWifiLockTimer == null) {
                StopwatchTimer stopwatchTimer;
                ArrayList<StopwatchTimer> arrayList = BatteryStatsImpl.this.mFullWifiLockTimers;
                ArrayList<Unpluggable> arrayList2 = BatteryStatsImpl.this.mUnpluggables;
                this.mFullWifiLockTimer = stopwatchTimer = new StopwatchTimer(this, 5, arrayList, arrayList2);
            }
            StopwatchTimer stopwatchTimer = this.mFullWifiLockTimer;
            BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
            stopwatchTimer.startRunningLocked(batteryStatsImpl);
        }

        @Override
        public void noteFullWifiLockReleasedLocked() {
            if (!this.mFullWifiLockOut) {
                return;
            }
            this.mFullWifiLockOut = false;
            StopwatchTimer stopwatchTimer = this.mFullWifiLockTimer;
            BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
            stopwatchTimer.stopRunningLocked(batteryStatsImpl);
        }

        @Override
        public void noteScanWifiLockAcquiredLocked() {
            if (this.mScanWifiLockOut) {
                return;
            }
            this.mScanWifiLockOut = true;
            if (this.mScanWifiLockTimer == null) {
                StopwatchTimer stopwatchTimer;
                ArrayList<StopwatchTimer> arrayList = BatteryStatsImpl.this.mScanWifiLockTimers;
                ArrayList<Unpluggable> arrayList2 = BatteryStatsImpl.this.mUnpluggables;
                this.mScanWifiLockTimer = stopwatchTimer = new StopwatchTimer(this, 6, arrayList, arrayList2);
            }
            StopwatchTimer stopwatchTimer = this.mScanWifiLockTimer;
            BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
            stopwatchTimer.startRunningLocked(batteryStatsImpl);
        }

        @Override
        public void noteScanWifiLockReleasedLocked() {
            if (!this.mScanWifiLockOut) {
                return;
            }
            this.mScanWifiLockOut = false;
            StopwatchTimer stopwatchTimer = this.mScanWifiLockTimer;
            BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
            stopwatchTimer.stopRunningLocked(batteryStatsImpl);
        }

        public void noteStartGps() {
            StopwatchTimer stopwatchTimer = this.getSensorTimerLocked(55536, true);
            if (stopwatchTimer == null) {
                return;
            }
            BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
            stopwatchTimer.startRunningLocked(batteryStatsImpl);
        }

        public void noteStartSensor(int n) {
            StopwatchTimer stopwatchTimer = this.getSensorTimerLocked(n, true);
            if (stopwatchTimer == null) {
                return;
            }
            BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
            stopwatchTimer.startRunningLocked(batteryStatsImpl);
        }

        public void noteStartWakeLocked(int n, String string2, int n2) {
            long l;
            StopwatchTimer stopwatchTimer = this.getWakeTimerLocked(string2, n2);
            if (stopwatchTimer != null) {
                BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
                stopwatchTimer.startRunningLocked(batteryStatsImpl);
            }
            if (n < 0) {
                return;
            }
            if (n2 != 0) {
                return;
            }
            BatteryStats.Uid.Pid pid = this.getPidStatsLocked(n);
            if (pid.mWakeStart != 0L) {
                return;
            }
            pid.mWakeStart = l = SystemClock.elapsedRealtime();
        }

        public void noteStopGps() {
            StopwatchTimer stopwatchTimer = this.getSensorTimerLocked(55536, false);
            if (stopwatchTimer == null) {
                return;
            }
            BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
            stopwatchTimer.stopRunningLocked(batteryStatsImpl);
        }

        public void noteStopSensor(int n) {
            StopwatchTimer stopwatchTimer = this.getSensorTimerLocked(n, false);
            if (stopwatchTimer == null) {
                return;
            }
            BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
            stopwatchTimer.stopRunningLocked(batteryStatsImpl);
        }

        public void noteStopWakeLocked(int n, String string2, int n2) {
            long l;
            StopwatchTimer stopwatchTimer = this.getWakeTimerLocked(string2, n2);
            if (stopwatchTimer != null) {
                BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
                stopwatchTimer.stopRunningLocked(batteryStatsImpl);
            }
            if (n < 0) {
                return;
            }
            if (n2 != 0) {
                return;
            }
            BatteryStats.Uid.Pid pid = this.mPids.get(n);
            if (pid == null) {
                return;
            }
            if (pid.mWakeStart == 0L) {
                return;
            }
            long l2 = pid.mWakeSum;
            long l3 = SystemClock.elapsedRealtime();
            long l4 = pid.mWakeStart;
            long l5 = l3 - l4;
            pid.mWakeSum = l = l2 + l5;
            pid.mWakeStart = 0L;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void noteUserActivityLocked(int n) {
            if (this.mUserActivityCounters == null) {
                this.initUserActivityLocked();
            }
            if (n < 0) {
                n = 0;
            } else if (n >= 7) {
                n = 6;
            }
            this.mUserActivityCounters[n].stepAtomic();
        }

        @Override
        public void noteVideoTurnedOffLocked() {
            if (!this.mVideoTurnedOn) {
                return;
            }
            this.mVideoTurnedOn = false;
            StopwatchTimer stopwatchTimer = this.mVideoTurnedOnTimer;
            BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
            stopwatchTimer.stopRunningLocked(batteryStatsImpl);
        }

        @Override
        public void noteVideoTurnedOnLocked() {
            if (this.mVideoTurnedOn) {
                return;
            }
            this.mVideoTurnedOn = true;
            if (this.mVideoTurnedOnTimer == null) {
                StopwatchTimer stopwatchTimer;
                ArrayList<Unpluggable> arrayList = BatteryStatsImpl.this.mUnpluggables;
                this.mVideoTurnedOnTimer = stopwatchTimer = new StopwatchTimer(this, 8, null, arrayList);
            }
            StopwatchTimer stopwatchTimer = this.mVideoTurnedOnTimer;
            BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
            stopwatchTimer.startRunningLocked(batteryStatsImpl);
        }

        @Override
        public void noteWifiMulticastDisabledLocked() {
            if (!this.mWifiMulticastEnabled) {
                return;
            }
            this.mWifiMulticastEnabled = false;
            StopwatchTimer stopwatchTimer = this.mWifiMulticastTimer;
            BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
            stopwatchTimer.stopRunningLocked(batteryStatsImpl);
        }

        @Override
        public void noteWifiMulticastEnabledLocked() {
            if (this.mWifiMulticastEnabled) {
                return;
            }
            this.mWifiMulticastEnabled = true;
            if (this.mWifiMulticastTimer == null) {
                StopwatchTimer stopwatchTimer;
                ArrayList<StopwatchTimer> arrayList = BatteryStatsImpl.this.mWifiMulticastTimers;
                ArrayList<Unpluggable> arrayList2 = BatteryStatsImpl.this.mUnpluggables;
                this.mWifiMulticastTimer = stopwatchTimer = new StopwatchTimer(this, 7, arrayList, arrayList2);
            }
            StopwatchTimer stopwatchTimer = this.mWifiMulticastTimer;
            BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
            stopwatchTimer.startRunningLocked(batteryStatsImpl);
        }

        @Override
        public void noteWifiRunningLocked() {
            if (this.mWifiRunning) {
                return;
            }
            this.mWifiRunning = true;
            if (this.mWifiRunningTimer == null) {
                StopwatchTimer stopwatchTimer;
                ArrayList<StopwatchTimer> arrayList = BatteryStatsImpl.this.mWifiRunningTimers;
                ArrayList<Unpluggable> arrayList2 = BatteryStatsImpl.this.mUnpluggables;
                this.mWifiRunningTimer = stopwatchTimer = new StopwatchTimer(this, 4, arrayList, arrayList2);
            }
            StopwatchTimer stopwatchTimer = this.mWifiRunningTimer;
            BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
            stopwatchTimer.startRunningLocked(batteryStatsImpl);
        }

        @Override
        public void noteWifiStoppedLocked() {
            if (!this.mWifiRunning) {
                return;
            }
            this.mWifiRunning = false;
            StopwatchTimer stopwatchTimer = this.mWifiRunningTimer;
            BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
            stopwatchTimer.stopRunningLocked(batteryStatsImpl);
        }

        /*
         * Enabled aggressive block sorting
         */
        void readFromParcelLocked(ArrayList<Unpluggable> arrayList, Parcel parcel) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            boolean bl5;
            boolean bl6;
            long l;
            long l2;
            long l3;
            long l4;
            long l5;
            long l6;
            int n;
            int n2;
            int n3 = parcel.readInt();
            this.mWakelockStats.clear();
            int n4 = 0;
            while ((n2 = ++n4) < (n = n3)) {
                Wakelock wakelock;
                String string2 = parcel.readString();
                Wakelock wakelock2 = wakelock;
                Uid uid = this;
                wakelock2();
                Wakelock wakelock3 = wakelock;
                ArrayList<Unpluggable> arrayList2 = arrayList;
                Parcel parcel2 = parcel;
                wakelock3.readFromParcelLocked(arrayList2, parcel2);
                if (this.mWakelockStats.size() >= 30) continue;
                HashMap<String, Wakelock> hashMap = this.mWakelockStats;
                String string3 = string2;
                Wakelock wakelock4 = wakelock;
                Wakelock wakelock5 = hashMap.put(string3, wakelock4);
            }
            int n5 = parcel.readInt();
            this.mSensorStats.clear();
            for (int i = 0; i < n5; ++i) {
                Sensor sensor;
                int n6 = parcel.readInt();
                Sensor sensor2 = sensor;
                Uid uid = this;
                int n7 = n6;
                sensor2(n7);
                ArrayList<Unpluggable> arrayList3 = BatteryStatsImpl.this.mUnpluggables;
                Sensor sensor3 = sensor;
                ArrayList<Unpluggable> arrayList4 = arrayList3;
                Parcel parcel3 = parcel;
                sensor3.readFromParcelLocked(arrayList4, parcel3);
                HashMap<Integer, Sensor> hashMap = this.mSensorStats;
                Integer n8 = n6;
                HashMap<Integer, Sensor> hashMap2 = hashMap;
                Integer n9 = n8;
                Sensor sensor4 = sensor;
                Sensor sensor5 = hashMap2.put(n9, sensor4);
            }
            int n10 = parcel.readInt();
            this.mProcessStats.clear();
            for (int i = 0; i < n10; ++i) {
                Proc proc;
                String string4 = parcel.readString();
                Proc proc2 = proc;
                Uid uid = this;
                proc2();
                Proc proc3 = proc;
                Parcel parcel4 = parcel;
                proc3.readFromParcelLocked(parcel4);
                HashMap<String, Proc> hashMap = this.mProcessStats;
                String string5 = string4;
                Proc proc4 = proc;
                Proc proc5 = hashMap.put(string5, proc4);
            }
            int n11 = parcel.readInt();
            this.mPackageStats.clear();
            for (int i = 0; i < n11; ++i) {
                Pkg pkg;
                String string6 = parcel.readString();
                Pkg pkg2 = pkg;
                Uid uid = this;
                pkg2();
                Pkg pkg3 = pkg;
                Parcel parcel5 = parcel;
                pkg3.readFromParcelLocked(parcel5);
                HashMap<String, Pkg> hashMap = this.mPackageStats;
                String string7 = string6;
                Pkg pkg4 = pkg;
                Pkg pkg5 = hashMap.put(string7, pkg4);
            }
            this.mLoadedTcpBytesReceived = l6 = parcel.readLong();
            this.mLoadedTcpBytesSent = l5 = parcel.readLong();
            this.mCurrentTcpBytesReceived = l4 = parcel.readLong();
            this.mCurrentTcpBytesSent = l3 = parcel.readLong();
            this.mTcpBytesReceivedAtLastUnplug = l2 = parcel.readLong();
            this.mTcpBytesSentAtLastUnplug = l = parcel.readLong();
            this.mWifiRunning = bl6 = false;
            if (parcel.readInt() != 0) {
                StopwatchTimer stopwatchTimer;
                ArrayList<StopwatchTimer> arrayList5 = BatteryStatsImpl.this.mWifiRunningTimers;
                ArrayList<Unpluggable> arrayList6 = BatteryStatsImpl.this.mUnpluggables;
                Uid uid = this;
                Parcel parcel6 = parcel;
                this.mWifiRunningTimer = stopwatchTimer = new StopwatchTimer(uid, 4, arrayList5, arrayList6, parcel6);
            } else {
                Object var113_71 = null;
                this.mWifiRunningTimer = var113_71;
            }
            this.mFullWifiLockOut = bl5 = false;
            if (parcel.readInt() != 0) {
                StopwatchTimer stopwatchTimer;
                ArrayList<StopwatchTimer> arrayList7 = BatteryStatsImpl.this.mFullWifiLockTimers;
                ArrayList<Unpluggable> arrayList8 = BatteryStatsImpl.this.mUnpluggables;
                Uid uid = this;
                Parcel parcel7 = parcel;
                this.mFullWifiLockTimer = stopwatchTimer = new StopwatchTimer(uid, 5, arrayList7, arrayList8, parcel7);
            } else {
                Object var114_78 = null;
                this.mFullWifiLockTimer = var114_78;
            }
            this.mScanWifiLockOut = bl4 = false;
            if (parcel.readInt() != 0) {
                StopwatchTimer stopwatchTimer;
                ArrayList<StopwatchTimer> arrayList9 = BatteryStatsImpl.this.mScanWifiLockTimers;
                ArrayList<Unpluggable> arrayList10 = BatteryStatsImpl.this.mUnpluggables;
                Uid uid = this;
                Parcel parcel8 = parcel;
                this.mScanWifiLockTimer = stopwatchTimer = new StopwatchTimer(uid, 6, arrayList9, arrayList10, parcel8);
            } else {
                Object var115_85 = null;
                this.mScanWifiLockTimer = var115_85;
            }
            this.mWifiMulticastEnabled = bl3 = false;
            if (parcel.readInt() != 0) {
                StopwatchTimer stopwatchTimer;
                ArrayList<StopwatchTimer> arrayList11 = BatteryStatsImpl.this.mWifiMulticastTimers;
                ArrayList<Unpluggable> arrayList12 = BatteryStatsImpl.this.mUnpluggables;
                Uid uid = this;
                Parcel parcel9 = parcel;
                this.mWifiMulticastTimer = stopwatchTimer = new StopwatchTimer(uid, 7, arrayList11, arrayList12, parcel9);
            } else {
                Object var116_92 = null;
                this.mWifiMulticastTimer = var116_92;
            }
            this.mAudioTurnedOn = bl2 = false;
            if (parcel.readInt() != 0) {
                StopwatchTimer stopwatchTimer;
                ArrayList<Unpluggable> arrayList13 = BatteryStatsImpl.this.mUnpluggables;
                Uid uid = this;
                Parcel parcel10 = parcel;
                this.mAudioTurnedOnTimer = stopwatchTimer = new StopwatchTimer(uid, 7, null, arrayList13, parcel10);
            } else {
                Object var117_98 = null;
                this.mAudioTurnedOnTimer = var117_98;
            }
            this.mVideoTurnedOn = bl = false;
            if (parcel.readInt() != 0) {
                StopwatchTimer stopwatchTimer;
                ArrayList<Unpluggable> arrayList14 = BatteryStatsImpl.this.mUnpluggables;
                Uid uid = this;
                Parcel parcel11 = parcel;
                this.mVideoTurnedOnTimer = stopwatchTimer = new StopwatchTimer(uid, 8, null, arrayList14, parcel11);
            } else {
                Object var118_104 = null;
                this.mVideoTurnedOnTimer = var118_104;
            }
            if (parcel.readInt() == 0) {
                Object var119_113 = null;
                this.mUserActivityCounters = var119_113;
                return;
            }
            Counter[] counterArray = new Counter[7];
            this.mUserActivityCounters = counterArray;
            int n12 = 0;
            while (n12 < 7) {
                Counter counter;
                Counter[] counterArray2 = this.mUserActivityCounters;
                ArrayList<Unpluggable> arrayList15 = BatteryStatsImpl.this.mUnpluggables;
                Counter counter2 = counter;
                ArrayList<Unpluggable> arrayList16 = arrayList15;
                Parcel parcel12 = parcel;
                counter2(arrayList16, parcel12);
                counterArray2[n12] = counter;
                ++n12;
            }
            return;
        }

        public void reportExcessiveCpuLocked(String string2, long l, long l2) {
            Proc proc = this.getProcessStatsLocked(string2);
            if (proc == null) {
                return;
            }
            proc.addExcessiveCpu(l, l2);
        }

        public void reportExcessiveWakeLocked(String string2, long l, long l2) {
            Proc proc = this.getProcessStatsLocked(string2);
            if (proc == null) {
                return;
            }
            proc.addExcessiveWake(l, l2);
        }

        /*
         * Enabled aggressive block sorting
         */
        boolean reset() {
            int n;
            long l;
            long l2;
            long l3;
            long l4;
            boolean bl = false;
            if (this.mWifiRunningTimer != null) {
                StopwatchTimer stopwatchTimer = this.mWifiRunningTimer;
                BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
                boolean bl2 = !stopwatchTimer.reset(batteryStatsImpl, false);
                boolean bl3 = false | bl2;
                boolean bl4 = this.mWifiRunning;
                bl = bl3 | bl4;
            }
            if (this.mFullWifiLockTimer != null) {
                StopwatchTimer stopwatchTimer = this.mFullWifiLockTimer;
                BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
                boolean bl5 = !stopwatchTimer.reset(batteryStatsImpl, false);
                boolean bl6 = bl | bl5;
                boolean bl7 = this.mFullWifiLockOut;
                bl = bl6 | bl7;
            }
            if (this.mScanWifiLockTimer != null) {
                StopwatchTimer stopwatchTimer = this.mScanWifiLockTimer;
                BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
                boolean bl8 = !stopwatchTimer.reset(batteryStatsImpl, false);
                boolean bl9 = bl | bl8;
                boolean bl10 = this.mScanWifiLockOut;
                bl = bl9 | bl10;
            }
            if (this.mWifiMulticastTimer != null) {
                StopwatchTimer stopwatchTimer = this.mWifiMulticastTimer;
                BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
                boolean bl11 = !stopwatchTimer.reset(batteryStatsImpl, false);
                boolean bl12 = bl | bl11;
                boolean bl13 = this.mWifiMulticastEnabled;
                bl = bl12 | bl13;
            }
            if (this.mAudioTurnedOnTimer != null) {
                StopwatchTimer stopwatchTimer = this.mAudioTurnedOnTimer;
                BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
                boolean bl14 = !stopwatchTimer.reset(batteryStatsImpl, false);
                boolean bl15 = bl | bl14;
                boolean bl16 = this.mAudioTurnedOn;
                bl = bl15 | bl16;
            }
            if (this.mVideoTurnedOnTimer != null) {
                StopwatchTimer stopwatchTimer = this.mVideoTurnedOnTimer;
                BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
                boolean bl17 = !stopwatchTimer.reset(batteryStatsImpl, false);
                boolean bl18 = bl | bl17;
                boolean bl19 = this.mVideoTurnedOn;
                bl = bl18 | bl19;
            }
            this.mLoadedTcpBytesSent = l4 = 0L;
            this.mLoadedTcpBytesReceived = l3 = 0L;
            this.mCurrentTcpBytesSent = l2 = 0L;
            this.mCurrentTcpBytesReceived = l = 0L;
            if (this.mUserActivityCounters != null) {
                int n2;
                int n3;
                n = 0;
                while ((n3 = ++n) < (n2 = 7)) {
                    this.mUserActivityCounters[n].reset(false);
                }
            }
            if (this.mWakelockStats.size() > 0) {
                Iterator<Map.Entry<String, Wakelock>> iterator = this.mWakelockStats.entrySet().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().getValue().reset()) {
                        iterator.remove();
                        continue;
                    }
                    bl = true;
                }
            }
            if (this.mSensorStats.size() > 0) {
                Iterator<Map.Entry<Integer, Sensor>> iterator = this.mSensorStats.entrySet().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().getValue().reset()) {
                        iterator.remove();
                        continue;
                    }
                    bl = true;
                }
            }
            if (this.mProcessStats.size() > 0) {
                Iterator<Map.Entry<String, Proc>> iterator = this.mProcessStats.entrySet().iterator();
                while (iterator.hasNext()) {
                    iterator.next().getValue().detach();
                }
                this.mProcessStats.clear();
            }
            if (this.mPids.size() > 0) {
                int n4;
                int n5;
                int n6;
                n = 0;
                while (!bl && (n6 = n) < (n5 = (n4 = this.mPids.size()))) {
                    SparseArray<BatteryStats.Uid.Pid> sparseArray = this.mPids;
                    int n7 = n;
                    if (sparseArray.valueAt((int)n7).mWakeStart != 0L) {
                        bl = true;
                    }
                    ++n;
                }
            }
            if (this.mPackageStats.size() > 0) {
                Iterator<Map.Entry<String, Pkg>> iterator = this.mPackageStats.entrySet().iterator();
                while (iterator.hasNext()) {
                    Pkg pkg = iterator.next().getValue();
                    pkg.detach();
                    if (pkg.mServiceStats.size() <= 0) continue;
                    Iterator<Map.Entry<String, Pkg.Serv>> iterator2 = pkg.mServiceStats.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        iterator2.next().getValue().detach();
                    }
                }
                this.mPackageStats.clear();
            }
            this.mPids.clear();
            if (!bl) {
                if (this.mWifiRunningTimer != null) {
                    this.mWifiRunningTimer.detach();
                }
                if (this.mFullWifiLockTimer != null) {
                    this.mFullWifiLockTimer.detach();
                }
                if (this.mScanWifiLockTimer != null) {
                    this.mScanWifiLockTimer.detach();
                }
                if (this.mWifiMulticastTimer != null) {
                    this.mWifiMulticastTimer.detach();
                }
                if (this.mAudioTurnedOnTimer != null) {
                    this.mAudioTurnedOnTimer.detach();
                }
                if (this.mVideoTurnedOnTimer != null) {
                    this.mVideoTurnedOnTimer.detach();
                }
                if (this.mUserActivityCounters != null) {
                    int n8;
                    int n9;
                    n = 0;
                    while ((n9 = ++n) < (n8 = 7)) {
                        this.mUserActivityCounters[n].detach();
                    }
                }
            }
            if (bl) return false;
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        void writeToParcelLocked(Parcel parcel, long l) {
            int n = this.mWakelockStats.size();
            parcel.writeInt(n);
            for (Map.Entry<String, Wakelock> entry : this.mWakelockStats.entrySet()) {
                String string2 = entry.getKey();
                parcel.writeString(string2);
                entry.getValue().writeToParcelLocked(parcel, l);
            }
            int n2 = this.mSensorStats.size();
            parcel.writeInt(n2);
            for (Map.Entry<Integer, Sensor> entry : this.mSensorStats.entrySet()) {
                int n3 = entry.getKey();
                parcel.writeInt(n3);
                entry.getValue().writeToParcelLocked(parcel, l);
            }
            int n4 = this.mProcessStats.size();
            parcel.writeInt(n4);
            for (Map.Entry<String, Proc> entry : this.mProcessStats.entrySet()) {
                String string3 = entry.getKey();
                parcel.writeString(string3);
                entry.getValue().writeToParcelLocked(parcel);
            }
            int n5 = this.mPackageStats.size();
            parcel.writeInt(n5);
            for (Map.Entry<String, Pkg> entry : this.mPackageStats.entrySet()) {
                String string4 = entry.getKey();
                parcel.writeString(string4);
                entry.getValue().writeToParcelLocked(parcel);
            }
            long l2 = this.mLoadedTcpBytesReceived;
            parcel.writeLong(l2);
            long l3 = this.mLoadedTcpBytesSent;
            parcel.writeLong(l3);
            long l4 = this.computeCurrentTcpBytesReceived();
            parcel.writeLong(l4);
            long l5 = this.computeCurrentTcpBytesSent();
            parcel.writeLong(l5);
            long l6 = this.mTcpBytesReceivedAtLastUnplug;
            parcel.writeLong(l6);
            long l7 = this.mTcpBytesSentAtLastUnplug;
            parcel.writeLong(l7);
            if (this.mWifiRunningTimer != null) {
                parcel.writeInt(1);
                this.mWifiRunningTimer.writeToParcel(parcel, l);
            } else {
                parcel.writeInt(0);
            }
            if (this.mFullWifiLockTimer != null) {
                parcel.writeInt(1);
                this.mFullWifiLockTimer.writeToParcel(parcel, l);
            } else {
                parcel.writeInt(0);
            }
            if (this.mScanWifiLockTimer != null) {
                parcel.writeInt(1);
                this.mScanWifiLockTimer.writeToParcel(parcel, l);
            } else {
                parcel.writeInt(0);
            }
            if (this.mWifiMulticastTimer != null) {
                parcel.writeInt(1);
                this.mWifiMulticastTimer.writeToParcel(parcel, l);
            } else {
                parcel.writeInt(0);
            }
            if (this.mAudioTurnedOnTimer != null) {
                parcel.writeInt(1);
                this.mAudioTurnedOnTimer.writeToParcel(parcel, l);
            } else {
                parcel.writeInt(0);
            }
            if (this.mVideoTurnedOnTimer != null) {
                parcel.writeInt(1);
                this.mVideoTurnedOnTimer.writeToParcel(parcel, l);
            } else {
                parcel.writeInt(0);
            }
            if (this.mUserActivityCounters == null) {
                parcel.writeInt(0);
                return;
            }
            parcel.writeInt(1);
            int n6 = 0;
            while (n6 < 7) {
                this.mUserActivityCounters[n6].writeToParcel(parcel);
                ++n6;
            }
            return;
        }

        public final class Pkg
        extends BatteryStats.Uid.Pkg
        implements Unpluggable {
            int mLastWakeups;
            int mLoadedWakeups;
            final HashMap<String, Serv> mServiceStats;
            int mUnpluggedWakeups;
            int mWakeups;

            Pkg() {
                HashMap hashMap = new HashMap();
                this.mServiceStats = hashMap;
                boolean bl = BatteryStatsImpl.this.mUnpluggables.add(this);
            }

            void detach() {
                boolean bl = BatteryStatsImpl.this.mUnpluggables.remove(this);
            }

            public BatteryStatsImpl getBatteryStats() {
                return BatteryStatsImpl.this;
            }

            @Override
            public Map<String, ? extends BatteryStats.Uid.Pkg.Serv> getServiceStats() {
                return this.mServiceStats;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public int getWakeups(int n) {
                if (n == 1) {
                    return this.mLastWakeups;
                }
                int n2 = this.mWakeups;
                if (n == 2) {
                    int n3 = this.mLoadedWakeups;
                    n2 -= n3;
                    return n2;
                }
                if (n != 3) return n2;
                int n4 = this.mUnpluggedWakeups;
                n2 -= n4;
                return n2;
            }

            public void incWakeupsLocked() {
                int n;
                this.mWakeups = n = this.mWakeups + 1;
            }

            final Serv newServiceStatsLocked() {
                return new Serv();
            }

            @Override
            public void plug(long l, long l2) {
            }

            void readFromParcelLocked(Parcel parcel) {
                int n;
                int n2;
                int n3;
                this.mWakeups = n3 = parcel.readInt();
                this.mLoadedWakeups = n2 = parcel.readInt();
                this.mLastWakeups = 0;
                this.mUnpluggedWakeups = n = parcel.readInt();
                int n4 = parcel.readInt();
                this.mServiceStats.clear();
                int n5 = 0;
                while (n5 < n4) {
                    String string2 = parcel.readString();
                    Serv serv = new Serv();
                    Serv serv2 = this.mServiceStats.put(string2, serv);
                    serv.readFromParcelLocked(parcel);
                    ++n5;
                }
                return;
            }

            @Override
            public void unplug(long l, long l2) {
                int n;
                this.mUnpluggedWakeups = n = this.mWakeups;
            }

            void writeToParcelLocked(Parcel parcel) {
                int n = this.mWakeups;
                parcel.writeInt(n);
                int n2 = this.mLoadedWakeups;
                parcel.writeInt(n2);
                int n3 = this.mUnpluggedWakeups;
                parcel.writeInt(n3);
                int n4 = this.mServiceStats.size();
                parcel.writeInt(n4);
                Iterator<Map.Entry<String, Serv>> iterator = this.mServiceStats.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Serv> entry = iterator.next();
                    String string2 = entry.getKey();
                    parcel.writeString(string2);
                    entry.getValue().writeToParcelLocked(parcel);
                }
                return;
            }

            public final class Serv
            extends BatteryStats.Uid.Pkg.Serv
            implements Unpluggable {
                int mLastLaunches;
                long mLastStartTime;
                int mLastStarts;
                boolean mLaunched;
                long mLaunchedSince;
                long mLaunchedTime;
                int mLaunches;
                int mLoadedLaunches;
                long mLoadedStartTime;
                int mLoadedStarts;
                boolean mRunning;
                long mRunningSince;
                long mStartTime;
                int mStarts;
                int mUnpluggedLaunches;
                long mUnpluggedStartTime;
                int mUnpluggedStarts;

                Serv() {
                    boolean bl = BatteryStatsImpl.this.mUnpluggables.add(this);
                }

                void detach() {
                    boolean bl = BatteryStatsImpl.this.mUnpluggables.remove(this);
                }

                public BatteryStatsImpl getBatteryStats() {
                    return BatteryStatsImpl.this;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                long getLaunchTimeToNowLocked(long l) {
                    if (!this.mLaunched) {
                        return this.mLaunchedTime;
                    }
                    long l2 = this.mLaunchedTime + l;
                    long l3 = this.mLaunchedSince;
                    return l2 - l3;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public int getLaunches(int n) {
                    if (n == 1) {
                        return this.mLastLaunches;
                    }
                    int n2 = this.mLaunches;
                    if (n == 2) {
                        int n3 = this.mLoadedLaunches;
                        n2 -= n3;
                        return n2;
                    }
                    if (n != 3) return n2;
                    int n4 = this.mUnpluggedLaunches;
                    n2 -= n4;
                    return n2;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public long getStartTime(long l, int n) {
                    if (n == 1) {
                        return this.mLastStartTime;
                    }
                    long l2 = this.getStartTimeToNowLocked(l);
                    if (n == 2) {
                        long l3 = this.mLoadedStartTime;
                        l2 -= l3;
                        return l2;
                    }
                    if (n != 3) return l2;
                    long l4 = this.mUnpluggedStartTime;
                    l2 -= l4;
                    return l2;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                long getStartTimeToNowLocked(long l) {
                    if (!this.mRunning) {
                        return this.mStartTime;
                    }
                    long l2 = this.mStartTime + l;
                    long l3 = this.mRunningSince;
                    return l2 - l3;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public int getStarts(int n) {
                    if (n == 1) {
                        return this.mLastStarts;
                    }
                    int n2 = this.mStarts;
                    if (n == 2) {
                        int n3 = this.mLoadedStarts;
                        n2 -= n3;
                        return n2;
                    }
                    if (n != 3) return n2;
                    int n4 = this.mUnpluggedStarts;
                    n2 -= n4;
                    return n2;
                }

                @Override
                public void plug(long l, long l2) {
                }

                /*
                 * Enabled aggressive block sorting
                 */
                void readFromParcelLocked(Parcel parcel) {
                    int n;
                    int n2;
                    long l;
                    int n3;
                    int n4;
                    long l2;
                    int n5;
                    long l3;
                    long l4;
                    int n6;
                    long l5;
                    long l6;
                    this.mStartTime = l6 = parcel.readLong();
                    this.mRunningSince = l5 = parcel.readLong();
                    boolean bl = parcel.readInt() != 0;
                    this.mRunning = bl;
                    this.mStarts = n6 = parcel.readInt();
                    this.mLaunchedTime = l4 = parcel.readLong();
                    this.mLaunchedSince = l3 = parcel.readLong();
                    boolean bl2 = parcel.readInt() != 0;
                    this.mLaunched = bl2;
                    this.mLaunches = n5 = parcel.readInt();
                    this.mLoadedStartTime = l2 = parcel.readLong();
                    this.mLoadedStarts = n4 = parcel.readInt();
                    this.mLoadedLaunches = n3 = parcel.readInt();
                    this.mLastStartTime = 0L;
                    this.mLastStarts = 0;
                    this.mLastLaunches = 0;
                    this.mUnpluggedStartTime = l = parcel.readLong();
                    this.mUnpluggedStarts = n2 = parcel.readInt();
                    this.mUnpluggedLaunches = n = parcel.readInt();
                }

                public void startLaunchedLocked() {
                    long l;
                    int n;
                    if (this.mLaunched) {
                        return;
                    }
                    this.mLaunches = n = this.mLaunches + 1;
                    this.mLaunchedSince = l = BatteryStatsImpl.this.getBatteryUptimeLocked();
                    this.mLaunched = true;
                }

                public void startRunningLocked() {
                    long l;
                    int n;
                    if (this.mRunning) {
                        return;
                    }
                    this.mStarts = n = this.mStarts + 1;
                    this.mRunningSince = l = BatteryStatsImpl.this.getBatteryUptimeLocked();
                    this.mRunning = true;
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public void stopLaunchedLocked() {
                    long l;
                    if (!this.mLaunched) {
                        return;
                    }
                    long l2 = BatteryStatsImpl.this.getBatteryUptimeLocked();
                    long l3 = l2 - (l = this.mLaunchedSince);
                    if (l3 > 0L) {
                        long l4;
                        this.mLaunchedTime = l4 = this.mLaunchedTime + l3;
                    } else {
                        int n;
                        this.mLaunches = n = this.mLaunches - 1;
                    }
                    this.mLaunched = false;
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public void stopRunningLocked() {
                    long l;
                    if (!this.mRunning) {
                        return;
                    }
                    long l2 = BatteryStatsImpl.this.getBatteryUptimeLocked();
                    long l3 = l2 - (l = this.mRunningSince);
                    if (l3 > 0L) {
                        long l4;
                        this.mStartTime = l4 = this.mStartTime + l3;
                    } else {
                        int n;
                        this.mStarts = n = this.mStarts - 1;
                    }
                    this.mRunning = false;
                }

                @Override
                public void unplug(long l, long l2) {
                    int n;
                    int n2;
                    long l3;
                    this.mUnpluggedStartTime = l3 = this.getStartTimeToNowLocked(l);
                    this.mUnpluggedStarts = n2 = this.mStarts;
                    this.mUnpluggedLaunches = n = this.mLaunches;
                }

                /*
                 * Enabled aggressive block sorting
                 */
                void writeToParcelLocked(Parcel parcel) {
                    long l = this.mStartTime;
                    parcel.writeLong(l);
                    long l2 = this.mRunningSince;
                    parcel.writeLong(l2);
                    int n = this.mRunning ? 1 : 0;
                    parcel.writeInt(n);
                    int n2 = this.mStarts;
                    parcel.writeInt(n2);
                    long l3 = this.mLaunchedTime;
                    parcel.writeLong(l3);
                    long l4 = this.mLaunchedSince;
                    parcel.writeLong(l4);
                    int n3 = this.mLaunched ? 1 : 0;
                    parcel.writeInt(n3);
                    int n4 = this.mLaunches;
                    parcel.writeInt(n4);
                    long l5 = this.mLoadedStartTime;
                    parcel.writeLong(l5);
                    int n5 = this.mLoadedStarts;
                    parcel.writeInt(n5);
                    int n6 = this.mLoadedLaunches;
                    parcel.writeInt(n6);
                    long l6 = this.mUnpluggedStartTime;
                    parcel.writeLong(l6);
                    int n7 = this.mUnpluggedStarts;
                    parcel.writeInt(n7);
                    int n8 = this.mUnpluggedLaunches;
                    parcel.writeInt(n8);
                }
            }
        }

        public final class Proc
        extends BatteryStats.Uid.Proc
        implements Unpluggable {
            ArrayList<BatteryStats.Uid.Proc.ExcessivePower> mExcessivePower;
            long mForegroundTime;
            long mLastForegroundTime;
            int mLastStarts;
            long mLastSystemTime;
            long mLastUserTime;
            long mLoadedForegroundTime;
            int mLoadedStarts;
            long mLoadedSystemTime;
            long mLoadedUserTime;
            SamplingCounter[] mSpeedBins;
            int mStarts;
            long mSystemTime;
            long mUnpluggedForegroundTime;
            int mUnpluggedStarts;
            long mUnpluggedSystemTime;
            long mUnpluggedUserTime;
            long mUserTime;

            Proc() {
                boolean bl = BatteryStatsImpl.this.mUnpluggables.add(this);
                SamplingCounter[] samplingCounterArray = new SamplingCounter[BatteryStatsImpl.this.getCpuSpeedSteps()];
                this.mSpeedBins = samplingCounterArray;
            }

            public void addCpuTimeLocked(int n, int n2) {
                long l;
                long l2;
                long l3 = this.mUserTime;
                long l4 = n;
                this.mUserTime = l2 = l3 + l4;
                long l5 = this.mSystemTime;
                long l6 = n2;
                this.mSystemTime = l = l5 + l6;
            }

            public void addExcessiveCpu(long l, long l2) {
                if (this.mExcessivePower == null) {
                    ArrayList arrayList = new ArrayList();
                    this.mExcessivePower = arrayList;
                }
                BatteryStats.Uid.Proc.ExcessivePower excessivePower = new BatteryStats.Uid.Proc.ExcessivePower();
                excessivePower.type = 2;
                excessivePower.overTime = l;
                excessivePower.usedTime = l2;
                boolean bl = this.mExcessivePower.add(excessivePower);
            }

            public void addExcessiveWake(long l, long l2) {
                if (this.mExcessivePower == null) {
                    ArrayList arrayList = new ArrayList();
                    this.mExcessivePower = arrayList;
                }
                BatteryStats.Uid.Proc.ExcessivePower excessivePower = new BatteryStats.Uid.Proc.ExcessivePower();
                excessivePower.type = 1;
                excessivePower.overTime = l;
                excessivePower.usedTime = l2;
                boolean bl = this.mExcessivePower.add(excessivePower);
            }

            public void addForegroundTimeLocked(long l) {
                long l2;
                this.mForegroundTime = l2 = this.mForegroundTime + l;
            }

            public void addSpeedStepTimes(long[] lArray) {
                int n = 0;
                int n2;
                while (n < (n2 = this.mSpeedBins.length)) {
                    int n3 = lArray.length;
                    if (n >= n3) {
                        return;
                    }
                    if (lArray[n] != 0L) {
                        SamplingCounter samplingCounter = this.mSpeedBins[n];
                        if (samplingCounter == null) {
                            SamplingCounter[] samplingCounterArray = this.mSpeedBins;
                            ArrayList<Unpluggable> arrayList = BatteryStatsImpl.this.mUnpluggables;
                            samplingCounterArray[n] = samplingCounter = new SamplingCounter(arrayList);
                        }
                        long l = lArray[n];
                        samplingCounter.addCountAtomic(l);
                    }
                    ++n;
                }
                return;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public int countExcessivePowers() {
                if (this.mExcessivePower == null) return 0;
                return this.mExcessivePower.size();
            }

            void detach() {
                boolean bl = BatteryStatsImpl.this.mUnpluggables.remove(this);
                int n = 0;
                int n2;
                while (n < (n2 = this.mSpeedBins.length)) {
                    SamplingCounter samplingCounter = this.mSpeedBins[n];
                    if (samplingCounter != null) {
                        boolean bl2 = BatteryStatsImpl.this.mUnpluggables.remove(samplingCounter);
                        this.mSpeedBins[n] = null;
                    }
                    ++n;
                }
                return;
            }

            public BatteryStatsImpl getBatteryStats() {
                return BatteryStatsImpl.this;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public BatteryStats.Uid.Proc.ExcessivePower getExcessivePower(int n) {
                if (this.mExcessivePower == null) return null;
                return this.mExcessivePower.get(n);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public long getForegroundTime(int n) {
                if (n == 1) {
                    return this.mLastForegroundTime;
                }
                long l = this.mForegroundTime;
                if (n == 2) {
                    long l2 = this.mLoadedForegroundTime;
                    l -= l2;
                    return l;
                }
                if (n != 3) return l;
                long l3 = this.mUnpluggedForegroundTime;
                l -= l3;
                return l;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public int getStarts(int n) {
                if (n == 1) {
                    return this.mLastStarts;
                }
                int n2 = this.mStarts;
                if (n == 2) {
                    int n3 = this.mLoadedStarts;
                    n2 -= n3;
                    return n2;
                }
                if (n != 3) return n2;
                int n4 = this.mUnpluggedStarts;
                n2 -= n4;
                return n2;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public long getSystemTime(int n) {
                if (n == 1) {
                    return this.mLastSystemTime;
                }
                long l = this.mSystemTime;
                if (n == 2) {
                    long l2 = this.mLoadedSystemTime;
                    l -= l2;
                    return l;
                }
                if (n != 3) return l;
                long l3 = this.mUnpluggedSystemTime;
                l -= l3;
                return l;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public long getTimeAtCpuSpeedStep(int n, int n2) {
                int n3 = this.mSpeedBins.length;
                if (n >= n3) return 0L;
                SamplingCounter samplingCounter = this.mSpeedBins[n];
                if (samplingCounter == null) return 0L;
                return samplingCounter.getCountLocked(n2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public long getUserTime(int n) {
                if (n == 1) {
                    return this.mLastUserTime;
                }
                long l = this.mUserTime;
                if (n == 2) {
                    long l2 = this.mLoadedUserTime;
                    l -= l2;
                    return l;
                }
                if (n != 3) return l;
                long l3 = this.mUnpluggedUserTime;
                l -= l3;
                return l;
            }

            public void incStartsLocked() {
                int n;
                this.mStarts = n = this.mStarts + 1;
            }

            @Override
            public void plug(long l, long l2) {
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            boolean readExcessivePowerFromParcelLocked(Parcel parcel) {
                int n = parcel.readInt();
                if (n == 0) {
                    this.mExcessivePower = null;
                    return true;
                }
                if (n > 10000) {
                    String string2 = "File corrupt: too many excessive power entries " + n;
                    int n2 = Slog.w(BatteryStatsImpl.TAG, string2);
                    return false;
                }
                ArrayList arrayList = new ArrayList();
                this.mExcessivePower = arrayList;
                int n3 = 0;
                while (n3 < n) {
                    long l;
                    long l2;
                    int n4;
                    BatteryStats.Uid.Proc.ExcessivePower excessivePower = new BatteryStats.Uid.Proc.ExcessivePower();
                    excessivePower.type = n4 = parcel.readInt();
                    excessivePower.overTime = l2 = parcel.readLong();
                    excessivePower.usedTime = l = parcel.readLong();
                    boolean bl = this.mExcessivePower.add(excessivePower);
                    ++n3;
                }
                return true;
            }

            /*
             * Enabled aggressive block sorting
             */
            void readFromParcelLocked(Parcel parcel) {
                int n;
                int n2;
                long l;
                long l2;
                long l3;
                int n3;
                long l4;
                long l5;
                long l6;
                int n4;
                long l7;
                long l8;
                long l9;
                this.mUserTime = l9 = parcel.readLong();
                this.mSystemTime = l8 = parcel.readLong();
                this.mForegroundTime = l7 = parcel.readLong();
                this.mStarts = n4 = parcel.readInt();
                this.mLoadedUserTime = l6 = parcel.readLong();
                this.mLoadedSystemTime = l5 = parcel.readLong();
                this.mLoadedForegroundTime = l4 = parcel.readLong();
                this.mLoadedStarts = n3 = parcel.readInt();
                this.mLastUserTime = 0L;
                this.mLastSystemTime = 0L;
                this.mLastForegroundTime = 0L;
                this.mLastStarts = 0;
                this.mUnpluggedUserTime = l3 = parcel.readLong();
                this.mUnpluggedSystemTime = l2 = parcel.readLong();
                this.mUnpluggedForegroundTime = l = parcel.readLong();
                this.mUnpluggedStarts = n2 = parcel.readInt();
                int n5 = parcel.readInt();
                int n6 = n5 >= (n = BatteryStatsImpl.this.getCpuSpeedSteps()) ? n5 : n;
                SamplingCounter[] samplingCounterArray = new SamplingCounter[n6];
                this.mSpeedBins = samplingCounterArray;
                int n7 = 0;
                while (true) {
                    if (n7 >= n5) {
                        boolean bl = this.readExcessivePowerFromParcelLocked(parcel);
                        return;
                    }
                    if (parcel.readInt() != 0) {
                        SamplingCounter samplingCounter;
                        SamplingCounter[] samplingCounterArray2 = this.mSpeedBins;
                        ArrayList<Unpluggable> arrayList = BatteryStatsImpl.this.mUnpluggables;
                        samplingCounterArray2[n7] = samplingCounter = new SamplingCounter(arrayList, parcel);
                    }
                    ++n7;
                }
            }

            @Override
            public void unplug(long l, long l2) {
                long l3;
                int n;
                long l4;
                long l5;
                this.mUnpluggedUserTime = l5 = this.mUserTime;
                this.mUnpluggedSystemTime = l4 = this.mSystemTime;
                this.mUnpluggedStarts = n = this.mStarts;
                this.mUnpluggedForegroundTime = l3 = this.mForegroundTime;
            }

            void writeExcessivePowerToParcelLocked(Parcel parcel) {
                if (this.mExcessivePower == null) {
                    parcel.writeInt(0);
                    return;
                }
                int n = this.mExcessivePower.size();
                parcel.writeInt(n);
                int n2 = 0;
                while (n2 < n) {
                    BatteryStats.Uid.Proc.ExcessivePower excessivePower = this.mExcessivePower.get(n2);
                    int n3 = excessivePower.type;
                    parcel.writeInt(n3);
                    long l = excessivePower.overTime;
                    parcel.writeLong(l);
                    long l2 = excessivePower.usedTime;
                    parcel.writeLong(l2);
                    ++n2;
                }
                return;
            }

            /*
             * Enabled aggressive block sorting
             */
            void writeToParcelLocked(Parcel parcel) {
                long l = this.mUserTime;
                parcel.writeLong(l);
                long l2 = this.mSystemTime;
                parcel.writeLong(l2);
                long l3 = this.mForegroundTime;
                parcel.writeLong(l3);
                int n = this.mStarts;
                parcel.writeInt(n);
                long l4 = this.mLoadedUserTime;
                parcel.writeLong(l4);
                long l5 = this.mLoadedSystemTime;
                parcel.writeLong(l5);
                long l6 = this.mLoadedForegroundTime;
                parcel.writeLong(l6);
                int n2 = this.mLoadedStarts;
                parcel.writeInt(n2);
                long l7 = this.mUnpluggedUserTime;
                parcel.writeLong(l7);
                long l8 = this.mUnpluggedSystemTime;
                parcel.writeLong(l8);
                long l9 = this.mUnpluggedForegroundTime;
                parcel.writeLong(l9);
                int n3 = this.mUnpluggedStarts;
                parcel.writeInt(n3);
                int n4 = this.mSpeedBins.length;
                parcel.writeInt(n4);
                int n5 = 0;
                while (true) {
                    int n6;
                    if (n5 >= (n6 = this.mSpeedBins.length)) {
                        this.writeExcessivePowerToParcelLocked(parcel);
                        return;
                    }
                    SamplingCounter samplingCounter = this.mSpeedBins[n5];
                    if (samplingCounter != null) {
                        parcel.writeInt(1);
                        samplingCounter.writeToParcel(parcel);
                    } else {
                        parcel.writeInt(0);
                    }
                    ++n5;
                }
            }
        }

        public final class Sensor
        extends BatteryStats.Uid.Sensor {
            final int mHandle;
            StopwatchTimer mTimer;

            public Sensor(int n) {
                this.mHandle = n;
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private StopwatchTimer readTimerFromParcel(ArrayList<Unpluggable> arrayList, Parcel parcel) {
                void var6_8;
                if (parcel.readInt() == 0) {
                    return null;
                }
                SparseArray<ArrayList<StopwatchTimer>> sparseArray = BatteryStatsImpl.this.mSensorTimers;
                int n = this.mHandle;
                ArrayList<StopwatchTimer> arrayList2 = sparseArray.get(n);
                if (arrayList2 == null) {
                    ArrayList arrayList3 = new ArrayList();
                    SparseArray<ArrayList<StopwatchTimer>> sparseArray2 = BatteryStatsImpl.this.mSensorTimers;
                    int n2 = this.mHandle;
                    sparseArray2.put(n2, arrayList3);
                }
                Uid uid = Uid.this;
                ArrayList<Unpluggable> arrayList4 = arrayList;
                Parcel parcel2 = parcel;
                return new StopwatchTimer(uid, 0, (ArrayList<StopwatchTimer>)var6_8, arrayList4, parcel2);
            }

            @Override
            public int getHandle() {
                return this.mHandle;
            }

            @Override
            public Timer getSensorTime() {
                return this.mTimer;
            }

            void readFromParcelLocked(ArrayList<Unpluggable> arrayList, Parcel parcel) {
                StopwatchTimer stopwatchTimer;
                this.mTimer = stopwatchTimer = this.readTimerFromParcel(arrayList, parcel);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            boolean reset() {
                StopwatchTimer stopwatchTimer = this.mTimer;
                BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
                if (!stopwatchTimer.reset(batteryStatsImpl, true)) return false;
                this.mTimer = null;
                return true;
            }

            void writeToParcelLocked(Parcel parcel, long l) {
                StopwatchTimer stopwatchTimer = this.mTimer;
                Timer.writeTimerToParcel(parcel, stopwatchTimer, l);
            }
        }

        public final class Wakelock
        extends BatteryStats.Uid.Wakelock {
            StopwatchTimer mTimerFull;
            StopwatchTimer mTimerPartial;
            StopwatchTimer mTimerWindow;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private StopwatchTimer readTimerFromParcel(int n, ArrayList<StopwatchTimer> arrayList, ArrayList<Unpluggable> arrayList2, Parcel parcel) {
                if (parcel.readInt() == 0) {
                    return null;
                }
                Uid uid = Uid.this;
                int n2 = n;
                ArrayList<StopwatchTimer> arrayList3 = arrayList;
                ArrayList<Unpluggable> arrayList4 = arrayList2;
                Parcel parcel2 = parcel;
                return new StopwatchTimer(uid, n2, arrayList3, arrayList4, parcel2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Timer getWakeTime(int n) {
                switch (n) {
                    default: {
                        String string2 = "type = " + n;
                        throw new IllegalArgumentException(string2);
                    }
                    case 1: {
                        return this.mTimerFull;
                    }
                    case 0: {
                        return this.mTimerPartial;
                    }
                    case 2: 
                }
                return this.mTimerWindow;
            }

            void readFromParcelLocked(ArrayList<Unpluggable> arrayList, Parcel parcel) {
                StopwatchTimer stopwatchTimer;
                StopwatchTimer stopwatchTimer2;
                StopwatchTimer stopwatchTimer3;
                ArrayList<StopwatchTimer> arrayList2 = BatteryStatsImpl.this.mPartialTimers;
                this.mTimerPartial = stopwatchTimer3 = this.readTimerFromParcel(0, arrayList2, arrayList, parcel);
                ArrayList<StopwatchTimer> arrayList3 = BatteryStatsImpl.this.mFullTimers;
                this.mTimerFull = stopwatchTimer2 = this.readTimerFromParcel(1, arrayList3, arrayList, parcel);
                ArrayList<StopwatchTimer> arrayList4 = BatteryStatsImpl.this.mWindowTimers;
                this.mTimerWindow = stopwatchTimer = this.readTimerFromParcel(2, arrayList4, arrayList, parcel);
            }

            /*
             * Enabled aggressive block sorting
             */
            boolean reset() {
                boolean bl = false;
                if (this.mTimerFull != null) {
                    StopwatchTimer stopwatchTimer = this.mTimerFull;
                    BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
                    boolean bl2 = !stopwatchTimer.reset(batteryStatsImpl, false);
                    bl = false | bl2;
                }
                if (this.mTimerPartial != null) {
                    StopwatchTimer stopwatchTimer = this.mTimerPartial;
                    BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
                    boolean bl3 = !stopwatchTimer.reset(batteryStatsImpl, false);
                    bl |= bl3;
                }
                if (this.mTimerWindow != null) {
                    StopwatchTimer stopwatchTimer = this.mTimerWindow;
                    BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
                    boolean bl4 = !stopwatchTimer.reset(batteryStatsImpl, false);
                    bl |= bl4;
                }
                if (!bl) {
                    if (this.mTimerFull != null) {
                        this.mTimerFull.detach();
                        this.mTimerFull = null;
                    }
                    if (this.mTimerPartial != null) {
                        this.mTimerPartial.detach();
                        this.mTimerPartial = null;
                    }
                    if (this.mTimerWindow != null) {
                        this.mTimerWindow.detach();
                        this.mTimerWindow = null;
                    }
                }
                if (bl) return false;
                return true;
            }

            void writeToParcelLocked(Parcel parcel, long l) {
                StopwatchTimer stopwatchTimer = this.mTimerPartial;
                Timer.writeTimerToParcel(parcel, stopwatchTimer, l);
                StopwatchTimer stopwatchTimer2 = this.mTimerFull;
                Timer.writeTimerToParcel(parcel, stopwatchTimer2, l);
                StopwatchTimer stopwatchTimer3 = this.mTimerWindow;
                Timer.writeTimerToParcel(parcel, stopwatchTimer3, l);
            }
        }
    }

    private class KernelWakelockStats {
        public int mCount;
        public long mTotalTime;
        public int mVersion;

        KernelWakelockStats(int n, long l, int n2) {
            this.mCount = n;
            this.mTotalTime = l;
            this.mVersion = n2;
        }
    }

    public static final class StopwatchTimer
    extends Timer {
        long mAcquireTime;
        boolean mInList;
        int mNesting;
        long mTimeout;
        final ArrayList<StopwatchTimer> mTimerPool;
        final Uid mUid;
        long mUpdateTime;

        StopwatchTimer(Uid uid, int n, ArrayList<StopwatchTimer> arrayList, ArrayList<Unpluggable> arrayList2) {
            super(n, arrayList2);
            this.mUid = uid;
            this.mTimerPool = arrayList;
        }

        StopwatchTimer(Uid uid, int n, ArrayList<StopwatchTimer> arrayList, ArrayList<Unpluggable> arrayList2, Parcel parcel) {
            super(n, arrayList2, parcel);
            long l;
            this.mUid = uid;
            this.mTimerPool = arrayList;
            this.mUpdateTime = l = parcel.readLong();
        }

        private static void refreshTimersLocked(BatteryStatsImpl batteryStatsImpl, ArrayList<StopwatchTimer> arrayList) {
            long l = SystemClock.elapsedRealtime() * 1000L;
            long l2 = batteryStatsImpl.getBatteryRealtimeLocked(l);
            int n = arrayList.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                StopwatchTimer stopwatchTimer = arrayList.get(n2);
                long l3 = stopwatchTimer.mUpdateTime;
                long l4 = l2 - l3;
                if (l4 > 0L) {
                    long l5;
                    long l6 = stopwatchTimer.mTotalTime;
                    long l7 = n;
                    long l8 = l4 / l7;
                    stopwatchTimer.mTotalTime = l5 = l6 + l8;
                }
                stopwatchTimer.mUpdateTime = l2;
                n2 += -1;
            }
            return;
        }

        @Override
        protected int computeCurrentCountLocked() {
            return this.mCount;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected long computeRunTimeLocked(long l) {
            long l2;
            long l3;
            long l4;
            long l5;
            if (this.mTimeout > 0L && l > (l5 = (l4 = this.mUpdateTime) + (l3 = this.mTimeout))) {
                long l6 = this.mUpdateTime;
                long l7 = this.mTimeout;
                l = l6 + l7;
            }
            long l8 = this.mTotalTime;
            if (this.mNesting <= 0) {
                l2 = 0L;
                return l8 + l2;
            }
            long l9 = this.mUpdateTime;
            long l10 = l - l9;
            int n = this.mTimerPool != null ? this.mTimerPool.size() : 1;
            long l11 = n;
            l2 = l10 / l11;
            return l8 + l2;
        }

        @Override
        void detach() {
            super.detach();
            if (this.mTimerPool == null) {
                return;
            }
            boolean bl = this.mTimerPool.remove(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean isRunningLocked() {
            if (this.mNesting <= 0) return false;
            return true;
        }

        @Override
        public void logState(Printer printer, String string2) {
            super.logState(printer, string2);
            StringBuilder stringBuilder = new StringBuilder().append(string2).append("mNesting=");
            int n = this.mNesting;
            StringBuilder stringBuilder2 = stringBuilder.append(n).append("mUpdateTime=");
            long l = this.mUpdateTime;
            StringBuilder stringBuilder3 = stringBuilder2.append(l).append(" mAcquireTime=");
            long l2 = this.mAcquireTime;
            String string3 = stringBuilder3.append(l2).toString();
            printer.println(string3);
        }

        @Override
        public void plug(long l, long l2) {
            if (this.mNesting <= 0) {
                return;
            }
            super.plug(l, l2);
            this.mUpdateTime = l2;
        }

        @Override
        void readSummaryFromParcelLocked(Parcel parcel) {
            super.readSummaryFromParcelLocked(parcel);
            this.mNesting = 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        boolean reset(BatteryStatsImpl batteryStatsImpl, boolean bl) {
            long l;
            boolean bl2 = this.mNesting <= 0;
            boolean bl3 = bl2 && bl;
            boolean bl4 = super.reset(batteryStatsImpl, bl3);
            if (this.mNesting > 0) {
                long l2;
                long l3 = SystemClock.elapsedRealtime() * 1000L;
                this.mUpdateTime = l2 = batteryStatsImpl.getBatteryRealtimeLocked(l3);
            }
            this.mAcquireTime = l = this.mTotalTime;
            return bl2;
        }

        void setTimeout(long l) {
            this.mTimeout = l;
        }

        void startRunningLocked(BatteryStatsImpl batteryStatsImpl) {
            long l;
            int n;
            long l2;
            int n2;
            int n3 = this.mNesting;
            this.mNesting = n2 = n3 + 1;
            if (n3 != 0) {
                return;
            }
            long l3 = SystemClock.elapsedRealtime() * 1000L;
            this.mUpdateTime = l2 = batteryStatsImpl.getBatteryRealtimeLocked(l3);
            if (this.mTimerPool != null) {
                ArrayList<StopwatchTimer> arrayList = this.mTimerPool;
                StopwatchTimer.refreshTimersLocked(batteryStatsImpl, arrayList);
                boolean bl = this.mTimerPool.add(this);
            }
            this.mCount = n = this.mCount + 1;
            this.mAcquireTime = l = this.mTotalTime;
        }

        /*
         * Enabled aggressive block sorting
         */
        void stopRunningLocked(BatteryStatsImpl batteryStatsImpl) {
            int n;
            long l;
            long l2;
            int n2;
            if (this.mNesting == 0) {
                return;
            }
            this.mNesting = n2 = this.mNesting - 1;
            if (n2 != 0) {
                return;
            }
            if (this.mTimerPool != null) {
                ArrayList<StopwatchTimer> arrayList = this.mTimerPool;
                StopwatchTimer.refreshTimersLocked(batteryStatsImpl, arrayList);
                boolean bl = this.mTimerPool.remove(this);
            } else {
                long l3;
                long l4 = SystemClock.elapsedRealtime() * 1000L;
                long l5 = batteryStatsImpl.getBatteryRealtimeLocked(l4);
                this.mNesting = 1;
                this.mTotalTime = l3 = this.computeRunTimeLocked(l5);
                this.mNesting = 0;
            }
            if ((l2 = this.mTotalTime) != (l = this.mAcquireTime)) {
                return;
            }
            this.mCount = n = this.mCount - 1;
        }

        @Override
        public void writeToParcel(Parcel parcel, long l) {
            super.writeToParcel(parcel, l);
            long l2 = this.mUpdateTime;
            parcel.writeLong(l2);
        }
    }

    public static final class SamplingTimer
    extends Timer {
        int mCurrentReportedCount;
        long mCurrentReportedTotalTime;
        boolean mInDischarge;
        boolean mTrackingReportedValues;
        int mUnpluggedReportedCount;
        long mUnpluggedReportedTotalTime;
        int mUpdateVersion;

        /*
         * Enabled aggressive block sorting
         */
        SamplingTimer(ArrayList<Unpluggable> arrayList, boolean bl, Parcel parcel) {
            super(0, arrayList, parcel);
            long l;
            long l2;
            int n;
            int n2;
            this.mCurrentReportedCount = n2 = parcel.readInt();
            this.mUnpluggedReportedCount = n = parcel.readInt();
            this.mCurrentReportedTotalTime = l2 = parcel.readLong();
            this.mUnpluggedReportedTotalTime = l = parcel.readLong();
            boolean bl2 = parcel.readInt() == 1;
            this.mTrackingReportedValues = bl2;
            this.mInDischarge = bl;
        }

        SamplingTimer(ArrayList<Unpluggable> arrayList, boolean bl, boolean bl2) {
            super(0, arrayList);
            this.mTrackingReportedValues = bl2;
            this.mInDischarge = bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected int computeCurrentCountLocked() {
            int n;
            int n2 = this.mCount;
            if (this.mInDischarge && this.mTrackingReportedValues) {
                int n3 = this.mCurrentReportedCount;
                int n4 = this.mUnpluggedReportedCount;
                n = n3 - n4;
                return n2 + n;
            }
            n = 0;
            return n2 + n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected long computeRunTimeLocked(long l) {
            long l2;
            long l3 = this.mTotalTime;
            if (this.mInDischarge && this.mTrackingReportedValues) {
                long l4 = this.mCurrentReportedTotalTime;
                long l5 = this.mUnpluggedReportedTotalTime;
                l2 = l4 - l5;
                return l3 + l2;
            }
            l2 = 0L;
            return l3 + l2;
        }

        public int getUpdateVersion() {
            return this.mUpdateVersion;
        }

        @Override
        public void logState(Printer printer, String string2) {
            super.logState(printer, string2);
            StringBuilder stringBuilder = new StringBuilder().append(string2).append("mCurrentReportedCount=");
            int n = this.mCurrentReportedCount;
            StringBuilder stringBuilder2 = stringBuilder.append(n).append(" mUnpluggedReportedCount=");
            int n2 = this.mUnpluggedReportedCount;
            StringBuilder stringBuilder3 = stringBuilder2.append(n2).append(" mCurrentReportedTotalTime=");
            long l = this.mCurrentReportedTotalTime;
            StringBuilder stringBuilder4 = stringBuilder3.append(l).append(" mUnpluggedReportedTotalTime=");
            long l2 = this.mUnpluggedReportedTotalTime;
            String string3 = stringBuilder4.append(l2).toString();
            printer.println(string3);
        }

        @Override
        public void plug(long l, long l2) {
            super.plug(l, l2);
            this.mInDischarge = false;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        void readSummaryFromParcelLocked(Parcel parcel) {
            int n;
            long l;
            super.readSummaryFromParcelLocked(parcel);
            this.mCurrentReportedTotalTime = l = parcel.readLong();
            this.mUnpluggedReportedTotalTime = l;
            this.mCurrentReportedCount = n = parcel.readInt();
            this.mUnpluggedReportedCount = n;
            boolean bl = parcel.readInt() == 1;
            this.mTrackingReportedValues = bl;
        }

        @Override
        boolean reset(BatteryStatsImpl batteryStatsImpl, boolean bl) {
            boolean bl2 = super.reset(batteryStatsImpl, bl);
            this.setStale();
            return true;
        }

        public void setStale() {
            this.mTrackingReportedValues = false;
            this.mUnpluggedReportedTotalTime = 0L;
            this.mUnpluggedReportedCount = 0;
        }

        public void setUpdateVersion(int n) {
            this.mUpdateVersion = n;
        }

        @Override
        public void unplug(long l, long l2) {
            super.unplug(l, l2);
            if (this.mTrackingReportedValues) {
                int n;
                long l3;
                this.mUnpluggedReportedTotalTime = l3 = this.mCurrentReportedTotalTime;
                this.mUnpluggedReportedCount = n = this.mCurrentReportedCount;
            }
            this.mInDischarge = true;
        }

        public void updateCurrentReportedCount(int n) {
            if (this.mInDischarge && this.mUnpluggedReportedCount == 0) {
                this.mUnpluggedReportedCount = n;
                this.mTrackingReportedValues = true;
            }
            this.mCurrentReportedCount = n;
        }

        public void updateCurrentReportedTotalTime(long l) {
            if (this.mInDischarge && this.mUnpluggedReportedTotalTime == 0L) {
                this.mUnpluggedReportedTotalTime = l;
                this.mTrackingReportedValues = true;
            }
            this.mCurrentReportedTotalTime = l;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        void writeSummaryFromParcelLocked(Parcel parcel, long l) {
            super.writeSummaryFromParcelLocked(parcel, l);
            long l2 = this.mCurrentReportedTotalTime;
            parcel.writeLong(l2);
            int n = this.mCurrentReportedCount;
            parcel.writeInt(n);
            int n2 = this.mTrackingReportedValues ? 1 : 0;
            parcel.writeInt(n2);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, long l) {
            super.writeToParcel(parcel, l);
            int n = this.mCurrentReportedCount;
            parcel.writeInt(n);
            int n2 = this.mUnpluggedReportedCount;
            parcel.writeInt(n2);
            long l2 = this.mCurrentReportedTotalTime;
            parcel.writeLong(l2);
            long l3 = this.mUnpluggedReportedTotalTime;
            parcel.writeLong(l3);
            int n3 = this.mTrackingReportedValues ? 1 : 0;
            parcel.writeInt(n3);
        }
    }

    public static abstract class Timer
    extends BatteryStats.Timer
    implements Unpluggable {
        int mCount;
        int mLastCount;
        long mLastTime;
        int mLoadedCount;
        long mLoadedTime;
        long mTotalTime;
        final int mType;
        final ArrayList<Unpluggable> mUnpluggables;
        int mUnpluggedCount;
        long mUnpluggedTime;

        Timer(int n, ArrayList<Unpluggable> arrayList) {
            this.mType = n;
            this.mUnpluggables = arrayList;
            boolean bl = arrayList.add(this);
        }

        Timer(int n, ArrayList<Unpluggable> arrayList, Parcel parcel) {
            long l;
            long l2;
            long l3;
            int n2;
            int n3;
            int n4;
            this.mType = n;
            this.mUnpluggables = arrayList;
            this.mCount = n4 = parcel.readInt();
            this.mLoadedCount = n3 = parcel.readInt();
            this.mLastCount = 0;
            this.mUnpluggedCount = n2 = parcel.readInt();
            this.mTotalTime = l3 = parcel.readLong();
            this.mLoadedTime = l2 = parcel.readLong();
            this.mLastTime = 0L;
            this.mUnpluggedTime = l = parcel.readLong();
            boolean bl = arrayList.add(this);
        }

        public static void writeTimerToParcel(Parcel parcel, Timer timer, long l) {
            if (timer == null) {
                parcel.writeInt(0);
                return;
            }
            parcel.writeInt(1);
            timer.writeToParcel(parcel, l);
        }

        protected abstract int computeCurrentCountLocked();

        protected abstract long computeRunTimeLocked(long var1);

        void detach() {
            boolean bl = this.mUnpluggables.remove(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getCountLocked(int n) {
            if (n == 1) {
                return this.mLastCount;
            }
            int n2 = this.computeCurrentCountLocked();
            if (n == 3) {
                int n3 = this.mUnpluggedCount;
                n2 -= n3;
                return n2;
            }
            if (n == 0) return n2;
            int n4 = this.mLoadedCount;
            n2 -= n4;
            return n2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long getTotalTimeLocked(long l, int n) {
            if (n == 1) {
                return this.mLastTime;
            }
            long l2 = this.computeRunTimeLocked(l);
            if (n == 3) {
                long l3 = this.mUnpluggedTime;
                l2 -= l3;
                return l2;
            }
            if (n == 0) return l2;
            long l4 = this.mLoadedTime;
            l2 -= l4;
            return l2;
        }

        @Override
        public void logState(Printer printer, String string2) {
            StringBuilder stringBuilder = new StringBuilder().append(string2).append(" mCount=");
            int n = this.mCount;
            StringBuilder stringBuilder2 = stringBuilder.append(n).append(" mLoadedCount=");
            int n2 = this.mLoadedCount;
            StringBuilder stringBuilder3 = stringBuilder2.append(n2).append(" mLastCount=");
            int n3 = this.mLastCount;
            StringBuilder stringBuilder4 = stringBuilder3.append(n3).append(" mUnpluggedCount=");
            int n4 = this.mUnpluggedCount;
            String string3 = stringBuilder4.append(n4).toString();
            printer.println(string3);
            StringBuilder stringBuilder5 = new StringBuilder().append(string2).append("mTotalTime=");
            long l = this.mTotalTime;
            StringBuilder stringBuilder6 = stringBuilder5.append(l).append(" mLoadedTime=");
            long l2 = this.mLoadedTime;
            String string4 = stringBuilder6.append(l2).toString();
            printer.println(string4);
            StringBuilder stringBuilder7 = new StringBuilder().append(string2).append("mLastTime=");
            long l3 = this.mLastTime;
            StringBuilder stringBuilder8 = stringBuilder7.append(l3).append(" mUnpluggedTime=");
            long l4 = this.mUnpluggedTime;
            String string5 = stringBuilder8.append(l4).toString();
            printer.println(string5);
        }

        @Override
        public void plug(long l, long l2) {
            int n;
            long l3;
            this.mTotalTime = l3 = this.computeRunTimeLocked(l2);
            this.mCount = n = this.computeCurrentCountLocked();
        }

        void readSummaryFromParcelLocked(Parcel parcel) {
            int n;
            int n2;
            long l;
            long l2;
            this.mLoadedTime = l2 = parcel.readLong() * 1000L;
            this.mTotalTime = l2;
            this.mLastTime = 0L;
            this.mUnpluggedTime = l = this.mTotalTime;
            this.mLoadedCount = n2 = parcel.readInt();
            this.mCount = n2;
            this.mLastCount = 0;
            this.mUnpluggedCount = n = this.mCount;
        }

        boolean reset(BatteryStatsImpl batteryStatsImpl, boolean bl) {
            this.mLastTime = 0L;
            this.mLoadedTime = 0L;
            this.mTotalTime = 0L;
            this.mLastCount = 0;
            this.mLoadedCount = 0;
            this.mCount = 0;
            if (bl) {
                this.detach();
            }
            return true;
        }

        @Override
        public void unplug(long l, long l2) {
            int n;
            long l3;
            this.mUnpluggedTime = l3 = this.computeRunTimeLocked(l2);
            this.mUnpluggedCount = n = this.mCount;
        }

        void writeSummaryFromParcelLocked(Parcel parcel, long l) {
            long l2 = this.computeRunTimeLocked(l);
            long l3 = (500L + l2) / 1000L;
            parcel.writeLong(l3);
            int n = this.mCount;
            parcel.writeInt(n);
        }

        public void writeToParcel(Parcel parcel, long l) {
            int n = this.mCount;
            parcel.writeInt(n);
            int n2 = this.mLoadedCount;
            parcel.writeInt(n2);
            int n3 = this.mUnpluggedCount;
            parcel.writeInt(n3);
            long l2 = this.computeRunTimeLocked(l);
            parcel.writeLong(l2);
            long l3 = this.mLoadedTime;
            parcel.writeLong(l3);
            long l4 = this.mUnpluggedTime;
            parcel.writeLong(l4);
        }
    }

    public static class SamplingCounter
    extends Counter {
        SamplingCounter(ArrayList<Unpluggable> arrayList) {
            super(arrayList);
        }

        SamplingCounter(ArrayList<Unpluggable> arrayList, Parcel parcel) {
            super(arrayList, parcel);
        }

        public void addCountAtomic(long l) {
            AtomicInteger atomicInteger = this.mCount;
            int n = (int)l;
            int n2 = atomicInteger.addAndGet(n);
        }
    }

    public static class Counter
    extends BatteryStats.Counter
    implements Unpluggable {
        final AtomicInteger mCount;
        int mLastCount;
        int mLoadedCount;
        int mPluggedCount;
        final ArrayList<Unpluggable> mUnpluggables;
        int mUnpluggedCount;

        Counter(ArrayList<Unpluggable> arrayList) {
            AtomicInteger atomicInteger;
            this.mCount = atomicInteger = new AtomicInteger();
            this.mUnpluggables = arrayList;
            boolean bl = arrayList.add(this);
        }

        Counter(ArrayList<Unpluggable> arrayList, Parcel parcel) {
            int n;
            int n2;
            int n3;
            AtomicInteger atomicInteger;
            this.mCount = atomicInteger = new AtomicInteger();
            this.mUnpluggables = arrayList;
            this.mPluggedCount = n3 = parcel.readInt();
            AtomicInteger atomicInteger2 = this.mCount;
            int n4 = this.mPluggedCount;
            atomicInteger2.set(n4);
            this.mLoadedCount = n2 = parcel.readInt();
            this.mLastCount = 0;
            this.mUnpluggedCount = n = parcel.readInt();
            boolean bl = arrayList.add(this);
        }

        public static void writeCounterToParcel(Parcel parcel, Counter counter) {
            if (counter == null) {
                parcel.writeInt(0);
                return;
            }
            parcel.writeInt(1);
            counter.writeToParcel(parcel);
        }

        void detach() {
            boolean bl = this.mUnpluggables.remove(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getCountLocked(int n) {
            if (n == 1) {
                return this.mLastCount;
            }
            int n2 = this.mCount.get();
            if (n == 3) {
                int n3 = this.mUnpluggedCount;
                n2 -= n3;
                return n2;
            }
            if (n == 0) return n2;
            int n4 = this.mLoadedCount;
            n2 -= n4;
            return n2;
        }

        @Override
        public void logState(Printer printer, String string2) {
            StringBuilder stringBuilder = new StringBuilder().append(string2).append("mCount=");
            int n = this.mCount.get();
            StringBuilder stringBuilder2 = stringBuilder.append(n).append(" mLoadedCount=");
            int n2 = this.mLoadedCount;
            StringBuilder stringBuilder3 = stringBuilder2.append(n2).append(" mLastCount=");
            int n3 = this.mLastCount;
            StringBuilder stringBuilder4 = stringBuilder3.append(n3).append(" mUnpluggedCount=");
            int n4 = this.mUnpluggedCount;
            StringBuilder stringBuilder5 = stringBuilder4.append(n4).append(" mPluggedCount=");
            int n5 = this.mPluggedCount;
            String string3 = stringBuilder5.append(n5).toString();
            printer.println(string3);
        }

        @Override
        public void plug(long l, long l2) {
            int n;
            this.mPluggedCount = n = this.mCount.get();
        }

        void readSummaryFromParcelLocked(Parcel parcel) {
            int n;
            int n2;
            this.mLoadedCount = n2 = parcel.readInt();
            AtomicInteger atomicInteger = this.mCount;
            int n3 = this.mLoadedCount;
            atomicInteger.set(n3);
            this.mLastCount = 0;
            this.mPluggedCount = n = this.mLoadedCount;
            this.mUnpluggedCount = n;
        }

        void reset(boolean bl) {
            this.mCount.set(0);
            this.mUnpluggedCount = 0;
            this.mPluggedCount = 0;
            this.mLastCount = 0;
            this.mLoadedCount = 0;
            if (!bl) {
                return;
            }
            this.detach();
        }

        void stepAtomic() {
            int n = this.mCount.incrementAndGet();
        }

        @Override
        public void unplug(long l, long l2) {
            int n;
            this.mUnpluggedCount = n = this.mPluggedCount;
            AtomicInteger atomicInteger = this.mCount;
            int n2 = this.mPluggedCount;
            atomicInteger.set(n2);
        }

        void writeSummaryFromParcelLocked(Parcel parcel) {
            int n = this.mCount.get();
            parcel.writeInt(n);
        }

        public void writeToParcel(Parcel parcel) {
            int n = this.mCount.get();
            parcel.writeInt(n);
            int n2 = this.mLoadedCount;
            parcel.writeInt(n2);
            int n3 = this.mUnpluggedCount;
            parcel.writeInt(n3);
        }
    }

    public static interface Unpluggable {
        public void plug(long var1, long var3);

        public void unplug(long var1, long var3);
    }

    final class MyHandler
    extends Handler {
        MyHandler() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handleMessage(Message message) {
            BatteryCallback batteryCallback = BatteryStatsImpl.this.mCallback;
            switch (message.what) {
                default: {
                    return;
                }
                case 1: {
                    if (batteryCallback == null) {
                        return;
                    }
                    batteryCallback.batteryNeedsCpuUpdate();
                    return;
                }
                case 2: 
            }
            if (batteryCallback == null) {
                return;
            }
            boolean bl = message.arg1 != 0;
            batteryCallback.batteryPowerChanged(bl);
        }
    }

    public static interface BatteryCallback {
        public void batteryNeedsCpuUpdate();

        public void batteryPowerChanged(boolean var1);
    }
}

