/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Formatter;
import java.util.Locale;

abstract class LoggingPrintStream
extends PrintStream {
    private final StringBuilder builder;
    private CharBuffer decodedChars;
    private CharsetDecoder decoder;
    private ByteBuffer encodedBytes;
    private final Formatter formatter;

    protected LoggingPrintStream() {
        Formatter formatter;
        StringBuilder stringBuilder;
        OutputStream outputStream = new OutputStream(){

            @Override
            public void write(int n) throws IOException {
                throw new AssertionError();
            }
        };
        super(outputStream);
        StringBuilder stringBuilder2 = this.builder = (stringBuilder = new StringBuilder());
        this.formatter = formatter = new Formatter(stringBuilder2, null);
    }

    private void flush(boolean bl) {
        int n;
        int n2 = this.builder.length();
        int n3 = 0;
        while (n3 < n2 && (n = this.builder.indexOf("\n", n3)) != -1) {
            String string2 = this.builder.substring(n3, n);
            this.log(string2);
            n3 = n + 1;
        }
        if (bl) {
            if (n3 < n2) {
                String string3 = this.builder.substring(n3);
                this.log(string3);
            }
            this.builder.setLength(0);
            return;
        }
        StringBuilder stringBuilder = this.builder.delete(0, n3);
    }

    @Override
    public PrintStream append(char c) {
        synchronized (this) {
            this.print(c);
            return this;
        }
    }

    @Override
    public PrintStream append(CharSequence charSequence) {
        synchronized (this) {
            StringBuilder stringBuilder = this.builder.append(charSequence);
            this.flush(false);
            return this;
        }
    }

    @Override
    public PrintStream append(CharSequence charSequence, int n, int n2) {
        synchronized (this) {
            StringBuilder stringBuilder = this.builder.append(charSequence, n, n2);
            this.flush(false);
            return this;
        }
    }

    @Override
    public boolean checkError() {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
        synchronized (this) {
            this.flush(true);
            return;
        }
    }

    @Override
    public PrintStream format(String string2, Object ... objectArray) {
        Locale locale = Locale.getDefault();
        return this.format(locale, string2, objectArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PrintStream format(Locale locale, String string2, Object ... objectArray) {
        synchronized (this) {
            if (string2 == null) {
                throw new NullPointerException("format");
            }
            Formatter formatter = this.formatter.format(locale, string2, objectArray);
            this.flush(false);
            return this;
        }
    }

    protected abstract void log(String var1);

    @Override
    public void print(char c) {
        synchronized (this) {
            StringBuilder stringBuilder = this.builder.append(c);
            if (c == '\n') {
                this.flush(false);
            }
            return;
        }
    }

    @Override
    public void print(double d) {
        synchronized (this) {
            StringBuilder stringBuilder = this.builder.append(d);
            return;
        }
    }

    @Override
    public void print(float f) {
        synchronized (this) {
            StringBuilder stringBuilder = this.builder.append(f);
            return;
        }
    }

    @Override
    public void print(int n) {
        synchronized (this) {
            StringBuilder stringBuilder = this.builder.append(n);
            return;
        }
    }

    @Override
    public void print(long l) {
        synchronized (this) {
            StringBuilder stringBuilder = this.builder.append(l);
            return;
        }
    }

    @Override
    public void print(Object object) {
        synchronized (this) {
            StringBuilder stringBuilder = this.builder.append(object);
            this.flush(false);
            return;
        }
    }

    @Override
    public void print(String string2) {
        synchronized (this) {
            StringBuilder stringBuilder = this.builder.append(string2);
            this.flush(false);
            return;
        }
    }

    @Override
    public void print(boolean bl) {
        synchronized (this) {
            StringBuilder stringBuilder = this.builder.append(bl);
            return;
        }
    }

    @Override
    public void print(char[] cArray) {
        synchronized (this) {
            StringBuilder stringBuilder = this.builder.append(cArray);
            this.flush(false);
            return;
        }
    }

    @Override
    public PrintStream printf(String string2, Object ... objectArray) {
        return this.format(string2, objectArray);
    }

    @Override
    public PrintStream printf(Locale locale, String string2, Object ... objectArray) {
        return this.format(locale, string2, objectArray);
    }

    @Override
    public void println() {
        synchronized (this) {
            this.flush(true);
            return;
        }
    }

    @Override
    public void println(char c) {
        synchronized (this) {
            StringBuilder stringBuilder = this.builder.append(c);
            this.flush(true);
            return;
        }
    }

    @Override
    public void println(double d) {
        synchronized (this) {
            StringBuilder stringBuilder = this.builder.append(d);
            this.flush(true);
            return;
        }
    }

    @Override
    public void println(float f) {
        synchronized (this) {
            StringBuilder stringBuilder = this.builder.append(f);
            this.flush(true);
            return;
        }
    }

    @Override
    public void println(int n) {
        synchronized (this) {
            StringBuilder stringBuilder = this.builder.append(n);
            this.flush(true);
            return;
        }
    }

    @Override
    public void println(long l) {
        synchronized (this) {
            StringBuilder stringBuilder = this.builder.append(l);
            this.flush(true);
            return;
        }
    }

    @Override
    public void println(Object object) {
        synchronized (this) {
            StringBuilder stringBuilder = this.builder.append(object);
            this.flush(true);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void println(String string2) {
        synchronized (this) {
            if (this.builder.length() == 0) {
                int n;
                int n2 = string2.length();
                int n3 = 0;
                while (n3 < n2 && (n = string2.indexOf(10, n3)) != -1) {
                    String string3 = string2.substring(n3, n);
                    this.log(string3);
                    n3 = n + 1;
                }
                if (n3 < n2) {
                    String string4 = string2.substring(n3);
                    this.log(string4);
                }
            } else {
                StringBuilder stringBuilder = this.builder.append(string2);
                this.flush(true);
            }
            return;
        }
    }

    @Override
    public void println(boolean bl) {
        synchronized (this) {
            StringBuilder stringBuilder = this.builder.append(bl);
            this.flush(true);
            return;
        }
    }

    @Override
    public void println(char[] cArray) {
        synchronized (this) {
            StringBuilder stringBuilder = this.builder.append(cArray);
            this.flush(true);
            return;
        }
    }

    @Override
    protected void setError() {
    }

    @Override
    public void write(int n) {
        byte by = (byte)n;
        byte[] byArray = new byte[]{by};
        this.write(byArray, 0, 1);
    }

    @Override
    public void write(byte[] byArray) {
        int n = byArray.length;
        this.write(byArray, 0, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(byte[] byArray, int n, int n2) {
        synchronized (this) {
            if (this.decoder == null) {
                CharsetDecoder charsetDecoder;
                CharBuffer charBuffer;
                ByteBuffer byteBuffer;
                this.encodedBytes = byteBuffer = ByteBuffer.allocate(80);
                this.decodedChars = charBuffer = CharBuffer.allocate(80);
                CharsetDecoder charsetDecoder2 = Charset.defaultCharset().newDecoder();
                CodingErrorAction codingErrorAction = CodingErrorAction.REPLACE;
                CharsetDecoder charsetDecoder3 = charsetDecoder2.onMalformedInput(codingErrorAction);
                CodingErrorAction codingErrorAction2 = CodingErrorAction.REPLACE;
                this.decoder = charsetDecoder = charsetDecoder3.onUnmappableCharacter(codingErrorAction2);
            }
            int n3 = n + n2;
            while (true) {
                CoderResult coderResult;
                if (n >= n3) {
                    boolean bl = false;
                    this.flush(bl);
                    return;
                }
                int n4 = this.encodedBytes.remaining();
                int n5 = n3 - n;
                int n6 = Math.min(n4, n5);
                ByteBuffer byteBuffer = this.encodedBytes.put(byArray, n, n6);
                n += n6;
                Buffer buffer = this.encodedBytes.flip();
                do {
                    CharsetDecoder charsetDecoder = this.decoder;
                    ByteBuffer byteBuffer2 = this.encodedBytes;
                    CharBuffer charBuffer = this.decodedChars;
                    coderResult = charsetDecoder.decode(byteBuffer2, charBuffer, false);
                    Buffer buffer2 = this.decodedChars.flip();
                    StringBuilder stringBuilder = this.builder;
                    CharBuffer charBuffer2 = this.decodedChars;
                    StringBuilder stringBuilder2 = stringBuilder.append(charBuffer2);
                    Buffer buffer3 = this.decodedChars.clear();
                } while (coderResult.isOverflow());
                ByteBuffer byteBuffer3 = this.encodedBytes.compact();
            }
        }
    }
}

