/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.app.ActivityManagerNative;
import android.app.ApplicationErrorReport;
import android.app.IActivityManager;
import android.ddm.DdmRegister;
import android.os.Build;
import android.os.Debug;
import android.os.IBinder;
import android.os.Process;
import android.os.SystemProperties;
import android.util.Slog;
import com.android.internal.logging.AndroidConfig;
import com.android.internal.os.AndroidPrintStream;
import com.android.internal.os.ZygoteInit;
import dalvik.system.VMRuntime;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.LogManager;
import org.apache.harmony.luni.internal.util.TimezoneGetter;

public class RuntimeInit {
    private static final String TAG = "AndroidRuntime";
    private static boolean initialized;
    private static IBinder mApplicationObject;
    private static volatile boolean mCrashing;
    private static final AtomicInteger sInReportException;

    static {
        mCrashing = false;
        sInReportException = new AtomicInteger();
        DdmRegister.registerHandlers();
    }

    static /* synthetic */ boolean access$002(boolean bl) {
        mCrashing = bl;
        return bl;
    }

    private static final void commonInit() {
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtHandler());
        if (RuntimeInit.getQwertyKeyboard() == 1) {
            String string2 = System.setProperty("qwerty", "1");
        }
        TimezoneGetter.setInstance((TimezoneGetter)new TimezoneGetter(){

            public String getId() {
                return SystemProperties.get("persist.sys.timezone");
            }
        });
        TimeZone.setDefault(null);
        LogManager.getLogManager().reset();
        AndroidConfig androidConfig = new AndroidConfig();
        String string3 = RuntimeInit.getDefaultUserAgent();
        String string4 = System.setProperty("http.agent", string3);
        if (SystemProperties.get("ro.kernel.android.tracing").equals("1")) {
            int n = Slog.i(TAG, "NOTE: emulator trace profiling enabled");
            Debug.enableEmulatorTraceOutput();
        }
        initialized = true;
    }

    public static final native void finishInit();

    public static final IBinder getApplicationObject() {
        return mApplicationObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String getDefaultUserAgent() {
        String string2;
        String string3;
        StringBuilder stringBuilder = new StringBuilder(64);
        StringBuilder stringBuilder2 = stringBuilder.append("Dalvik/");
        String string4 = System.getProperty("java.vm.version");
        StringBuilder stringBuilder3 = stringBuilder.append(string4);
        StringBuilder stringBuilder4 = stringBuilder.append(" (Linux; U; Android ");
        String string5 = Build.VERSION.RELEASE;
        String string6 = string5.length() > 0 ? string5 : "1.0";
        StringBuilder stringBuilder5 = stringBuilder.append(string6);
        String string7 = Build.VERSION.CODENAME;
        if ("REL".equals(string7) && (string3 = Build.MODEL).length() > 0) {
            StringBuilder stringBuilder6 = stringBuilder.append("; ");
            StringBuilder stringBuilder7 = stringBuilder.append(string3);
        }
        if ((string2 = Build.ID).length() > 0) {
            StringBuilder stringBuilder8 = stringBuilder.append(" Build/");
            StringBuilder stringBuilder9 = stringBuilder.append(string2);
        }
        StringBuilder stringBuilder10 = stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static native int getQwertyKeyboard();

    private static void invokeStaticMain(String string2, String[] stringArray) throws ZygoteInit.MethodAndArgsCaller {
        AnnotatedElement annotatedElement;
        Class<?> clazz;
        AnnotatedElement annotatedElement2;
        float f = VMRuntime.getRuntime().setTargetHeapUtilization(0.75f);
        try {
            annotatedElement2 = Class.forName(string2);
            clazz = annotatedElement2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string3 = "Missing class when invoking static main " + string2;
            throw new RuntimeException(string3, classNotFoundException);
        }
        try {
            Class[] classArray = new Class[]{String[].class};
            annotatedElement = annotatedElement2 = clazz.getMethod("main", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string4 = "Missing static main on " + string2;
            throw new RuntimeException(string4, noSuchMethodException);
        }
        catch (SecurityException securityException) {
            String string5 = "Problem getting static main on " + string2;
            throw new RuntimeException(string5, securityException);
        }
        int n = ((Method)annotatedElement).getModifiers();
        if (!Modifier.isStatic(n) || !Modifier.isPublic(n)) {
            String string6 = "Main method is not public and static on " + string2;
            throw new RuntimeException(string6);
        }
        throw new ZygoteInit.MethodAndArgsCaller((Method)annotatedElement, stringArray);
    }

    public static final native int isComputerOn();

    public static final void main(String[] stringArray) {
        RuntimeInit.commonInit();
        RuntimeInit.finishInit();
    }

    public static final void setApplicationObject(IBinder iBinder) {
        mApplicationObject = iBinder;
    }

    public static final native void turnComputerOn();

    public static void wtf(String string2, Throwable throwable) {
        try {
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            IBinder iBinder = mApplicationObject;
            ApplicationErrorReport.CrashInfo crashInfo = new ApplicationErrorReport.CrashInfo(throwable);
            if (!iActivityManager.handleApplicationWtf(iBinder, string2, crashInfo)) {
                return;
            }
            Process.killProcess(Process.myPid());
            System.exit(10);
            return;
        }
        catch (Throwable throwable2) {
            int n = Slog.e(TAG, "Error reporting WTF", throwable2);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void zygoteInit(String[] stringArray) throws ZygoteInit.MethodAndArgsCaller {
        int n;
        int n2;
        int n3;
        System.setOut(new AndroidPrintStream(4, "System.out"));
        System.setErr(new AndroidPrintStream(5, "System.err"));
        RuntimeInit.commonInit();
        RuntimeInit.zygoteInitNative();
        for (n3 = 0; n3 < (n2 = stringArray.length); ++n3) {
            String string2 = stringArray[n3];
            if (string2.equals("--")) {
                ++n3;
                break;
            }
            if (!string2.startsWith("--")) break;
            if (!string2.startsWith("--nice-name=")) continue;
            int n4 = string2.indexOf(61) + 1;
            Process.setArgV0(string2.substring(n4));
        }
        if (n3 != (n = stringArray.length)) {
            int n5 = Slog.e(TAG, "Missing classname argument to RuntimeInit!");
            return;
        }
        int n6 = n3 + 1;
        String string3 = stringArray[n3];
        String[] stringArray2 = new String[stringArray.length - n6];
        int n7 = stringArray2.length;
        System.arraycopy(stringArray, n6, stringArray2, 0, n7);
        RuntimeInit.invokeStaticMain(string3, stringArray2);
        int n8 = n6;
    }

    public static final native void zygoteInitNative();

    private static class UncaughtHandler
    implements Thread.UncaughtExceptionHandler {
        private UncaughtHandler() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            block11: {
                boolean bl = mCrashing;
                if (!bl) break block11;
                Process.killProcess(Process.myPid());
                System.exit(10);
                return;
            }
            boolean bl = true;
            try {
                boolean bl2 = RuntimeInit.access$002(bl);
                if (mApplicationObject == null) {
                    StringBuilder stringBuilder = new StringBuilder().append("*** FATAL EXCEPTION IN SYSTEM PROCESS: ");
                    String string2 = thread.getName();
                    String string3 = stringBuilder.append(string2).toString();
                    int n = Slog.e(RuntimeInit.TAG, string3, throwable);
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append("FATAL EXCEPTION: ");
                    String string4 = thread.getName();
                    String string5 = stringBuilder.append(string4).toString();
                    int n = Slog.e(RuntimeInit.TAG, string5, throwable);
                }
                IActivityManager iActivityManager = ActivityManagerNative.getDefault();
                IBinder iBinder = mApplicationObject;
                ApplicationErrorReport.CrashInfo crashInfo = new ApplicationErrorReport.CrashInfo(throwable);
                iActivityManager.handleApplicationCrash(iBinder, crashInfo);
                return;
            }
            catch (Throwable throwable2) {
                try {
                    int n = Slog.e(RuntimeInit.TAG, "Error reporting crash", throwable2);
                    return;
                }
                catch (Throwable throwable3) {
                    return;
                }
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
            finally {
                Process.killProcess(Process.myPid());
                System.exit(10);
            }
        }
    }
}

