/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.SystemProperties;
import android.util.Log;
import dalvik.system.SamplingProfiler;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class SamplingProfilerIntegration {
    private static SamplingProfiler INSTANCE;
    private static final String TAG = "SamplingProfilerIntegration";
    static boolean dirMade;
    private static final boolean enabled;
    static volatile boolean pending;
    private static final Executor snapshotWriter;

    /*
     * Enabled aggressive block sorting
     */
    static {
        String string2 = SystemProperties.get("persist.sampling_profiler");
        enabled = "1".equals(string2);
        if (enabled) {
            snapshotWriter = Executors.newSingleThreadExecutor();
            int n = Log.i(TAG, "Profiler is enabled.");
        } else {
            snapshotWriter = null;
            int n = Log.i(TAG, "Profiler is disabled.");
        }
        dirMade = false;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void start() {
        if (!enabled) {
            return;
        }
        SamplingProfiler.ThreadSet threadSet = SamplingProfiler.newThreadGroupTheadSet((ThreadGroup)Thread.currentThread().getThreadGroup());
        INSTANCE = new SamplingProfiler(4, threadSet);
        INSTANCE.start(10);
    }

    public static void writeSnapshot(final String string2) {
        if (!enabled) {
            return;
        }
        if (pending) {
            return;
        }
        pending = true;
        Executor executor = snapshotWriter;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                block6: {
                    block5: {
                        if (dirMade) break block5;
                        boolean bl = new File("/sdcard/snapshots").mkdirs();
                        if (!new File("/sdcard/snapshots").isDirectory()) break block6;
                        dirMade = true;
                    }
                    String string22 = string2;
                    SamplingProfilerIntegration.writeSnapshot("/sdcard/snapshots", string22);
                    return;
                }
                String string3 = "Creation of " + "/sdcard/snapshots" + " failed.";
                int n = Log.w(SamplingProfilerIntegration.TAG, string3);
                return;
                finally {
                    pending = false;
                }
            }
        };
        executor.execute(runnable);
    }

    /*
     * Unable to fully structure code
     */
    private static void writeSnapshot(String var0, String var1_1) {
        block11: {
            if (!SamplingProfilerIntegration.enabled) {
                return;
            }
            SamplingProfilerIntegration.INSTANCE.stop();
            var2_2 = System.currentTimeMillis();
            var4_3 = new StringBuilder().append(var0).append("/");
            var5_4 = var1_1.replace(':', '.');
            var6_5 = var4_3.append(var5_4).append("-");
            var7_6 = System.currentTimeMillis();
            var9_7 = var6_5.append(var7_6).append(".snapshot").toString();
            var10_8 = 0;
            while (true) {
                try {
                    var11_9 = new FileOutputStream(var9_7);
                    var12_10 = new BufferedOutputStream(var11_9);
                    var13_11 = new PrintStream(var12_10);
                }
                catch (FileNotFoundException var15_15) {
                    if (++var10_8 > 3) {
                        var16_16 = "Could not open " + var9_7 + ".";
                        var17_17 = Log.e("SamplingProfilerIntegration", var16_16);
                        return;
                    }
                    var18_13 = 2500L;
                    try {
                        Thread.sleep(var18_13);
                    }
                    catch (InterruptedException var20_14) {}
                    continue;
                }
                SamplingProfilerIntegration.INSTANCE.writeHprofData(var13_11);
                ** if (!var13_11.checkError()) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    var14_12 = Log.e("SamplingProfilerIntegration", "Error writing snapshot.");
                    return;
                }
lbl-1000:
                // 1 sources

                {
                    break block11;
                }
                break;
            }
            finally {
                var13_11.close();
            }
        }
        var22_19 = System.currentTimeMillis() - var2_2;
        var24_20 = "Wrote snapshot for " + var1_1 + " in " + var22_19 + "ms.";
        var25_21 = Log.i("SamplingProfilerIntegration", var24_20);
    }

    public static void writeZygoteSnapshot() {
        if (!enabled) {
            return;
        }
        boolean bl = new File("/data/zygote/snapshots").mkdirs();
        SamplingProfilerIntegration.writeSnapshot("/data/zygote/snapshots", "zygote");
        INSTANCE.shutdown();
        INSTANCE = null;
    }
}

