/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.net.Credentials;
import android.net.LocalSocket;
import android.os.SystemProperties;
import android.util.Log;
import com.android.internal.os.RuntimeInit;
import com.android.internal.os.ZygoteInit;
import com.android.internal.os.ZygoteSecurityException;
import dalvik.system.PathClassLoader;
import dalvik.system.Zygote;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;

class ZygoteConnection {
    private static final int CONNECTION_TIMEOUT_MILLIS = 1000;
    private static final int MAX_ZYGOTE_ARGC = 1024;
    private static final String TAG = "Zygote";
    private static final int[][] intArray2d;
    private static LocalSocket sPeerWaitSocket;
    private final LocalSocket mSocket;
    private final DataOutputStream mSocketOutStream;
    private final BufferedReader mSocketReader;
    private final Credentials peer;

    static {
        int[] nArray = new int[]{0, 0};
        intArray2d = (int[][])Array.newInstance(Integer.TYPE, nArray);
        sPeerWaitSocket = null;
    }

    ZygoteConnection(LocalSocket localSocket) throws IOException {
        BufferedReader bufferedReader;
        DataOutputStream dataOutputStream;
        this.mSocket = localSocket;
        OutputStream outputStream = localSocket.getOutputStream();
        this.mSocketOutStream = dataOutputStream = new DataOutputStream(outputStream);
        InputStream inputStream = localSocket.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        this.mSocketReader = bufferedReader = new BufferedReader(inputStreamReader, 256);
        this.mSocket.setSoTimeout(1000);
        try {
            Credentials credentials;
            this.peer = credentials = this.mSocket.getPeerCredentials();
            return;
        }
        catch (IOException iOException) {
            int n = Log.e(TAG, "Cannot read peer credentials", iOException);
            throw iOException;
        }
    }

    private static void applyCapabilitiesSecurityPolicy(Arguments arguments, Credentials credentials) throws ZygoteSecurityException {
        long l;
        if (arguments.permittedCapabilities == 0L && arguments.effectiveCapabilities == 0L) {
            return;
        }
        if (credentials.getUid() == 0) {
            return;
        }
        try {
            long l2;
            l = l2 = ZygoteInit.capgetPermitted(credentials.getPid());
            long l3 = arguments.permittedCapabilities ^ 0xFFFFL;
            long l4 = arguments.effectiveCapabilities;
            if ((l3 & l4) != 0L) {
                throw new ZygoteSecurityException("Effective capabilities cannot be superset of  permitted capabilities");
            }
        }
        catch (IOException iOException) {
            throw new ZygoteSecurityException("Error retrieving peer's capabilities.");
        }
        long l5 = l ^ 0xFFFFL;
        long l6 = arguments.permittedCapabilities;
        if ((l5 & l6) == 0L) {
            return;
        }
        throw new ZygoteSecurityException("Peer specified unpermitted capabilities");
    }

    private static void applyDebuggerSecurityPolicy(Arguments arguments) {
        int n;
        String string2 = SystemProperties.get("ro.debuggable");
        if (!"1".equals(string2)) {
            return;
        }
        arguments.debugFlags = n = arguments.debugFlags | 1;
    }

    private static void applyRlimitSecurityPolicy(Arguments arguments, Credentials credentials) throws ZygoteSecurityException {
        int n = credentials.getUid();
        if (n == 0) {
            return;
        }
        if (n == 1000) {
            return;
        }
        if (arguments.rlimits == null) {
            return;
        }
        throw new ZygoteSecurityException("This UID may not specify rlimits.");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void applyUidSecurityPolicy(Arguments arguments, Credentials credentials) throws ZygoteSecurityException {
        int n;
        int n2 = credentials.getUid();
        if (n2 != 0) {
            if (n2 == 1000) {
                String string2 = SystemProperties.get("ro.factorytest");
                boolean bl = !string2.equals("1") && !string2.equals("2");
                if (bl && arguments.uidSpecified && arguments.uid < 1000) {
                    throw new ZygoteSecurityException("System UID may not launch process with UID < 1000");
                }
            } else if (arguments.uidSpecified || arguments.gidSpecified || arguments.gids != null) {
                throw new ZygoteSecurityException("App UIDs may not specify uid's or gid's");
            }
        }
        if (!arguments.uidSpecified) {
            int n3;
            arguments.uid = n3 = credentials.getUid();
            arguments.uidSpecified = true;
        }
        if (arguments.gidSpecified) {
            return;
        }
        arguments.gid = n = credentials.getGid();
        arguments.gidSpecified = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleChildProc(Arguments arguments, FileDescriptor[] fileDescriptorArray, PrintStream printStream) throws ZygoteInit.MethodAndArgsCaller {
        String string2;
        ClassLoader classLoader;
        if (arguments.peerWait) {
            try {
                ZygoteInit.setCloseOnExec(this.mSocket.getFileDescriptor(), true);
                sPeerWaitSocket = this.mSocket;
            }
            catch (IOException iOException) {
                int n = Log.e(TAG, "Zygote Child: error setting peer wait socket to be close-on-exec", iOException);
            }
        } else {
            this.closeSocket();
            ZygoteInit.closeServerSocket();
        }
        if (fileDescriptorArray != null) {
            int n = 0;
            try {
                FileDescriptor fileDescriptor = fileDescriptorArray[n];
                FileDescriptor fileDescriptor2 = fileDescriptorArray[1];
                FileDescriptor fileDescriptor3 = fileDescriptorArray[2];
                ZygoteInit.reopenStdio(fileDescriptor, fileDescriptor2, fileDescriptor3);
                FileDescriptor[] fileDescriptorArray2 = fileDescriptorArray;
                int n2 = fileDescriptorArray2.length;
                for (int i = 0; i < n2; ++i) {
                    ZygoteInit.closeDescriptor(fileDescriptorArray2[i]);
                }
                printStream = System.err;
            }
            catch (IOException iOException) {
                int n3 = Log.e(TAG, "Error reopening stdio", iOException);
            }
        }
        if (arguments.runtimeInit) {
            RuntimeInit.zygoteInit(arguments.remainingArgs);
            return;
        }
        if (arguments.classpath != null) {
            String string3 = arguments.classpath;
            ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
            classLoader = new PathClassLoader(string3, classLoader2);
        } else {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try {
            string2 = arguments.remainingArgs[0];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            ZygoteConnection.logAndPrintError(printStream, "Missing required class name argument", null);
            return;
        }
        String[] stringArray = new String[arguments.remainingArgs.length - 1];
        String[] stringArray2 = arguments.remainingArgs;
        int n = stringArray.length;
        System.arraycopy(stringArray2, 1, stringArray, 0, n);
        try {
            ZygoteInit.invokeStaticMain(classLoader, string2, stringArray);
            return;
        }
        catch (RuntimeException runtimeException) {
            ZygoteConnection.logAndPrintError(printStream, "Error starting. ", runtimeException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleParentProc(int n, FileDescriptor[] fileDescriptorArray, Arguments arguments) {
        if (n > 0) {
            try {
                int n2 = ZygoteInit.getpgid(this.peer.getPid());
                int n3 = ZygoteInit.setpgid(n, n2);
            }
            catch (IOException iOException) {
                int n4 = Log.i(TAG, "Zygote: setpgid failed. This is normal if peer is not in our session");
            }
        }
        if (fileDescriptorArray != null) {
            FileDescriptor[] fileDescriptorArray2 = fileDescriptorArray;
            try {
                int n5 = fileDescriptorArray2.length;
                for (int i = 0; i < n5; ++i) {
                    ZygoteInit.closeDescriptor(fileDescriptorArray2[i]);
                }
            }
            catch (IOException iOException) {
                int n6 = Log.e(TAG, "Error closing passed descriptors in parent process", iOException);
            }
        }
        try {
            this.mSocketOutStream.writeInt(n);
            if (!arguments.peerWait) return false;
        }
        catch (IOException iOException) {
            int n7 = Log.e(TAG, "Error reading from command socket", iOException);
            return true;
        }
        try {
            this.mSocket.close();
            return true;
        }
        catch (IOException iOException) {
            int n8 = Log.e(TAG, "Zygote: error closing sockets", iOException);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void logAndPrintError(PrintStream printStream, String string2, Throwable throwable) {
        int n = Log.e(TAG, string2, throwable);
        if (printStream == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append(string2);
        Object object = throwable == null ? "" : throwable;
        String string3 = stringBuilder.append(object).toString();
        printStream.println(string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String[] readArgumentList() throws IOException {
        int n;
        try {
            String string2 = this.mSocketReader.readLine();
            if (string2 == null) {
                return null;
            }
            int n2 = Integer.parseInt(string2);
            n = n2;
            if (n > 1024) {
                throw new IOException("max arg count exceeded");
            }
        }
        catch (NumberFormatException numberFormatException) {
            int n3 = Log.e(TAG, "invalid Zygote wire format: non-int at argc");
            throw new IOException("invalid wire format");
        }
        String[] stringArray = new String[n];
        int n4 = 0;
        while (n4 < n) {
            String string3;
            stringArray[n4] = string3 = this.mSocketReader.readLine();
            if (stringArray[n4] == null) {
                throw new IOException("truncated request");
            }
            ++n4;
        }
        return stringArray;
    }

    void closeSocket() {
        try {
            this.mSocket.close();
            return;
        }
        catch (IOException iOException) {
            int n = Log.e(TAG, "Exception while closing command socket in parent", iOException);
            return;
        }
    }

    FileDescriptor getFileDesciptor() {
        return this.mSocket.getFileDescriptor();
    }

    /*
     * Enabled aggressive block sorting
     */
    void run() throws ZygoteInit.MethodAndArgsCaller {
        int n = 10;
        do {
            if (n <= 0) {
                ZygoteInit.gc();
                n = 10;
                continue;
            }
            n += -1;
        } while (!this.runOnce());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    boolean runOnce() throws ZygoteInit.MethodAndArgsCaller {
        block15: {
            block14: {
                var1_1 = null;
                try {
                    var2_2 = this.readArgumentList();
                    var4_4 = var3_3 /* !! */  = this.mSocket.getAncillaryFileDescriptors();
                    if (var2_2 != null) break block14;
                    this.closeSocket();
                    var5_5 = true;
                }
                catch (IOException var6_6) {
                    var7_7 = new StringBuilder().append("IOException on command socket ");
                    var8_8 = var6_6.getMessage();
                    var9_9 = var7_7.append(var8_8).toString();
                    var10_10 = Log.w("Zygote", var9_9);
                    this.closeSocket();
                    var5_5 = true;
                }
lbl8:
                // 4 sources

                return var5_5;
            }
            var11_11 = null;
            if (var4_4 != false && var4_4.length >= 3) {
                var12_12 = var4_4[2];
                var13_13 = new FileOutputStream(var12_12);
                var11_11 = new PrintStream(var13_13);
            }
            var14_14 = new Arguments(var2_2);
            try {
                var15_15 = this.peer;
                ZygoteConnection.applyUidSecurityPolicy(var14_14, var15_15);
                ZygoteConnection.applyDebuggerSecurityPolicy(var14_14);
                var16_16 = this.peer;
                ZygoteConnection.applyRlimitSecurityPolicy(var14_14, var16_16);
                var17_17 = this.peer;
                ZygoteConnection.applyCapabilitiesSecurityPolicy(var14_14, var17_17);
                var18_18 = null;
                if (var14_14.rlimits != null) {
                    var19_19 = var14_14.rlimits;
                    var20_20 = ZygoteConnection.intArray2d;
                    var18_18 = (int[][])var19_19.toArray((T[])var20_20);
                }
                var21_21 = var14_14.uid;
                var22_22 = var14_14.gid;
                var23_23 = var14_14.gids;
                var24_24 = var14_14.debugFlags;
                var3_3 /* !! */  = (FileDescriptor[])Zygote.forkAndSpecialize((int)var21_21, (int)var22_22, (int[])var23_23, (int)var24_24, (int[][])var18_18);
            }
            catch (ZygoteSecurityException var26_30) {
                var1_1 = var14_14;
                ** continue;
            }
            catch (IllegalArgumentException var26_31) {
                var1_1 = var14_14;
                ** continue;
            }
            var25_25 /* !! */  = (int)var3_3 /* !! */ ;
            var1_1 = var14_14;
lbl46:
            // 3 sources

            while (var25_25 /* !! */  == 0) {
                this.handleChildProc(var1_1, var4_4, var11_11);
                var5_5 = true;
                ** GOTO lbl8
            }
            break block15;
            catch (IllegalArgumentException var26_26) lbl-1000:
            // 2 sources

            {
                while (true) {
                    ZygoteConnection.logAndPrintError(var11_11, "Invalid zygote arguments", (Throwable)var26_27);
                    var25_25 /* !! */  = -1;
                    ** GOTO lbl46
                    break;
                }
            }
            catch (ZygoteSecurityException var26_28) lbl-1000:
            // 2 sources

            {
                while (true) {
                    ZygoteConnection.logAndPrintError(var11_11, "Zygote security policy prevents request: ", (Throwable)var26_29);
                    var25_25 /* !! */  = -1;
                    ** GOTO lbl46
                    break;
                }
            }
        }
        var5_5 = this.handleParentProc(var25_25 /* !! */ , var4_4, var1_1);
        ** while (true)
    }

    static class Arguments {
        boolean capabilitiesSpecified;
        String classpath;
        int debugFlags;
        long effectiveCapabilities;
        int gid = 0;
        boolean gidSpecified;
        int[] gids;
        boolean peerWait;
        long permittedCapabilities;
        String[] remainingArgs;
        ArrayList<int[]> rlimits;
        boolean runtimeInit;
        int uid = 0;
        boolean uidSpecified;

        Arguments(String[] stringArray) throws IllegalArgumentException {
            this.parseArgs(stringArray);
        }

        /*
         * Unable to fully structure code
         */
        private void parseArgs(String[] var1_1) throws IllegalArgumentException {
            block15: {
                block28: {
                    block27: {
                        block25: {
                            block26: {
                                block24: {
                                    block23: {
                                        block22: {
                                            block21: {
                                                block20: {
                                                    block19: {
                                                        block18: {
                                                            var2_2 = 0;
                                                            block2: while (true) {
                                                                block17: {
                                                                    block16: {
                                                                        if (var2_2 >= (var3_3 = var1_1.length)) break block16;
                                                                        var4_4 = var1_1[var2_2];
                                                                        if (!var4_4.equals("--")) break block17;
                                                                        ++var2_2;
                                                                    }
lbl8:
                                                                    // 2 sources

                                                                    while (this.runtimeInit && this.classpath != null) {
                                                                        throw new IllegalArgumentException("--runtime-init and -classpath are incompatible");
                                                                    }
                                                                    break block15;
                                                                }
                                                                if (!var4_4.startsWith("--setuid=")) break;
                                                                if (this.uidSpecified) {
                                                                    throw new IllegalArgumentException("Duplicate arg specified");
                                                                }
                                                                this.uidSpecified = true;
                                                                var5_5 = var4_4.indexOf(61) + 1;
                                                                this.uid = var6_6 = Integer.parseInt(var4_4.substring(var5_5));
lbl18:
                                                                // 13 sources

                                                                while (true) {
                                                                    ++var2_2;
                                                                    continue block2;
                                                                    break;
                                                                }
                                                                break;
                                                            }
                                                            if (!var4_4.startsWith("--setgid=")) break block18;
                                                            if (this.gidSpecified) {
                                                                throw new IllegalArgumentException("Duplicate arg specified");
                                                            }
                                                            this.gidSpecified = true;
                                                            var7_7 = var4_4.indexOf(61) + 1;
                                                            this.gid = var8_8 = Integer.parseInt(var4_4.substring(var7_7));
                                                            ** GOTO lbl18
                                                        }
                                                        if (!var4_4.equals("--enable-debugger")) break block19;
                                                        this.debugFlags = var9_9 = this.debugFlags | 1;
                                                        ** GOTO lbl18
                                                    }
                                                    if (!var4_4.equals("--enable-safemode")) break block20;
                                                    this.debugFlags = var10_10 = this.debugFlags | 8;
                                                    ** GOTO lbl18
                                                }
                                                if (!var4_4.equals("--enable-checkjni")) break block21;
                                                this.debugFlags = var11_11 = this.debugFlags | 2;
                                                ** GOTO lbl18
                                            }
                                            if (!var4_4.equals("--enable-assert")) break block22;
                                            this.debugFlags = var12_12 = this.debugFlags | 4;
                                            ** GOTO lbl18
                                        }
                                        if (!var4_4.equals("--peer-wait")) break block23;
                                        this.peerWait = true;
                                        ** GOTO lbl18
                                    }
                                    if (!var4_4.equals("--runtime-init")) break block24;
                                    this.runtimeInit = true;
                                    ** GOTO lbl18
                                }
                                if (!var4_4.startsWith("--capabilities=")) break block25;
                                if (this.capabilitiesSpecified) {
                                    throw new IllegalArgumentException("Duplicate arg specified");
                                }
                                this.capabilitiesSpecified = true;
                                var13_13 = var4_4.indexOf(61) + 1;
                                var14_14 = var4_4.substring(var13_13).split(",", 2);
                                if (var14_14.length != 1) break block26;
                                this.permittedCapabilities = var17_16 = (this.effectiveCapabilities = (var15_15 = Long.decode(var14_14[0]).longValue()));
                                ** GOTO lbl18
                            }
                            this.permittedCapabilities = var19_17 = Long.decode(var14_14[0]).longValue();
                            this.effectiveCapabilities = var21_18 = Long.decode(var14_14[1]).longValue();
                            ** GOTO lbl18
                        }
                        if (!var4_4.startsWith("--rlimit=")) break block27;
                        var23_19 = var4_4.indexOf(61) + 1;
                        var24_20 = var4_4.substring(var23_19).split(",");
                        if (var24_20.length != 3) {
                            throw new IllegalArgumentException("--rlimit= should have 3 comma-delimited ints");
                        }
                        var25_21 = new int[var24_20.length];
                        for (var26_22 = 0; var26_22 < (var27_23 = var24_20.length); ++var26_22) {
                            var25_21[var26_22] = var28_24 = Integer.parseInt(var24_20[var26_22]);
                        }
                        if (this.rlimits == null) {
                            var29_25 = new ArrayList<E>();
                            this.rlimits = var29_25;
                        }
                        var30_26 = this.rlimits.add(var25_21);
                        ** GOTO lbl18
                    }
                    if (!var4_4.equals("-classpath")) break block28;
                    if (this.classpath != null) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    ++var2_2;
                    try {
                        this.classpath = var31_27 = var1_1[var2_2];
                        ** GOTO lbl18
                    }
                    catch (IndexOutOfBoundsException var32_33) {
                        throw new IllegalArgumentException("-classpath requires argument");
                    }
                }
                if (!var4_4.startsWith("--setgroups=")) ** GOTO lbl8
                if (this.gids != null) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                var33_28 = var4_4.indexOf(61) + 1;
                var34_29 = var4_4.substring(var33_28).split(",");
                var35_30 = new int[var34_29.length];
                this.gids = var35_30;
                var26_22 = var34_29.length - 1;
                while (true) {
                    if (var26_22 >= 0) ** break;
                    ** continue;
                    var36_31 = this.gids;
                    var36_31[var26_22] = var37_32 = Integer.parseInt(var34_29[var26_22]);
                    var26_22 += -1;
                }
            }
            var38_34 = new String[var1_1.length - var2_2];
            var39_35 = this.remainingArgs = var38_34;
            var40_36 = this.remainingArgs.length;
            System.arraycopy(var1_1, var2_2, var39_35, 0, var40_36);
        }
    }
}

