/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os.storage;

import android.app.ProgressDialog;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Environment;
import android.os.IBinder;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.storage.IMountService;
import android.os.storage.StorageEventListener;
import android.os.storage.StorageManager;
import android.util.Log;
import android.widget.Toast;

public class ExternalStorageFormatter
extends Service
implements DialogInterface.OnCancelListener {
    public static final ComponentName COMPONENT_NAME;
    public static final String EXTRA_ALWAYS_RESET = "always_reset";
    public static final String FORMAT_AND_FACTORY_RESET = "com.android.internal.os.storage.FORMAT_AND_FACTORY_RESET";
    public static final String FORMAT_ONLY = "com.android.internal.os.storage.FORMAT_ONLY";
    static final String TAG = "ExternalStorageFormatter";
    private boolean mAlwaysReset = false;
    private boolean mFactoryReset = false;
    private IMountService mMountService = null;
    private ProgressDialog mProgressDialog = null;
    StorageEventListener mStorageListener;
    private StorageManager mStorageManager = null;
    private PowerManager.WakeLock mWakeLock;

    static {
        String string2 = ExternalStorageFormatter.class.getName();
        COMPONENT_NAME = new ComponentName("android", string2);
    }

    public ExternalStorageFormatter() {
        StorageEventListener storageEventListener;
        this.mStorageListener = storageEventListener = new StorageEventListener(){

            @Override
            public void onStorageStateChanged(String string2, String string3, String string4) {
                String string5 = "Received storage state changed notification that " + string2 + " changed state from " + string3 + " to " + string4;
                int n = Log.i(ExternalStorageFormatter.TAG, string5);
                ExternalStorageFormatter.this.updateProgressState();
            }
        };
    }

    void fail(int n) {
        Toast.makeText((Context)this, n, 1).show();
        if (this.mAlwaysReset) {
            Intent intent = new Intent("android.intent.action.MASTER_CLEAR");
            this.sendBroadcast(intent);
        }
        this.stopSelf();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    IMountService getMountService() {
        block4: {
            block3: {
                IMountService iMountService;
                if (this.mMountService != null) break block3;
                IBinder iBinder = ServiceManager.getService("mount");
                if (iBinder == null) break block4;
                this.mMountService = iMountService = IMountService.Stub.asInterface(iBinder);
            }
            return this.mMountService;
        }
        int n = Log.e(TAG, "Can't get mount service");
        return this.mMountService;
    }

    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onCancel(DialogInterface dialogInterface) {
        IMountService iMountService = this.getMountService();
        String string2 = Environment.getExternalStorageDirectory().toString();
        try {
            int n = iMountService.mountVolume(string2);
        }
        catch (RemoteException remoteException) {
            int n = Log.w(TAG, "Failed talking with mount service", remoteException);
        }
        this.stopSelf();
    }

    @Override
    public void onCreate() {
        PowerManager.WakeLock wakeLock;
        super.onCreate();
        if (this.mStorageManager == null) {
            StorageManager storageManager;
            StorageManager storageManager2 = this.mStorageManager = (storageManager = (StorageManager)this.getSystemService("storage"));
            StorageEventListener storageEventListener = this.mStorageListener;
            storageManager2.registerListener(storageEventListener);
        }
        this.mWakeLock = wakeLock = ((PowerManager)this.getSystemService("power")).newWakeLock(1, TAG);
        this.mWakeLock.acquire();
    }

    @Override
    public void onDestroy() {
        if (this.mStorageManager != null) {
            StorageManager storageManager = this.mStorageManager;
            StorageEventListener storageEventListener = this.mStorageListener;
            storageManager.unregisterListener(storageEventListener);
        }
        if (this.mProgressDialog != null) {
            this.mProgressDialog.dismiss();
        }
        this.mWakeLock.release();
        super.onDestroy();
    }

    @Override
    public int onStartCommand(Intent intent, int n, int n2) {
        String string2 = intent.getAction();
        if (FORMAT_AND_FACTORY_RESET.equals(string2)) {
            this.mFactoryReset = true;
        }
        if (intent.getBooleanExtra(EXTRA_ALWAYS_RESET, false)) {
            this.mAlwaysReset = true;
        }
        if (this.mProgressDialog == null) {
            ProgressDialog progressDialog;
            this.mProgressDialog = progressDialog = new ProgressDialog(this);
            this.mProgressDialog.setIndeterminate(true);
            this.mProgressDialog.setCancelable(true);
            this.mProgressDialog.getWindow().setType(2003);
            if (!this.mAlwaysReset) {
                this.mProgressDialog.setOnCancelListener(this);
            }
            this.updateProgressState();
            this.mProgressDialog.show();
        }
        return 3;
    }

    public void updateProgressDialog(int n) {
        if (this.mProgressDialog == null) {
            ProgressDialog progressDialog;
            this.mProgressDialog = progressDialog = new ProgressDialog(this);
            this.mProgressDialog.setIndeterminate(true);
            this.mProgressDialog.setCancelable(false);
            this.mProgressDialog.getWindow().setType(2003);
            this.mProgressDialog.show();
        }
        ProgressDialog progressDialog = this.mProgressDialog;
        CharSequence charSequence = this.getText(n);
        progressDialog.setMessage(charSequence);
    }

    void updateProgressState() {
        String string2 = Environment.getExternalStorageState();
        if ("mounted".equals(string2) || "mounted_ro".equals(string2)) {
            this.updateProgressDialog(17040247);
            IMountService iMountService = this.getMountService();
            String string3 = Environment.getExternalStorageDirectory().toString();
            boolean bl = true;
            try {
                iMountService.unmountVolume(string3, bl);
                return;
            }
            catch (RemoteException remoteException) {
                int n = Log.w(TAG, "Failed talking with mount service", remoteException);
                return;
            }
        }
        if ("nofs".equals(string2) || "unmounted".equals(string2) || "unmountable".equals(string2)) {
            this.updateProgressDialog(17040248);
            final IMountService iMountService = this.getMountService();
            final String string4 = Environment.getExternalStorageDirectory().toString();
            if (iMountService != null) {
                new Thread(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        boolean bl = false;
                        try {
                            IMountService iMountService2 = iMountService;
                            String string2 = string4;
                            int n = iMountService2.formatVolume(string2);
                            bl = true;
                        }
                        catch (Exception exception) {
                            Toast.makeText((Context)ExternalStorageFormatter.this, 17040249, 1).show();
                        }
                        if (bl && ExternalStorageFormatter.this.mFactoryReset) {
                            ExternalStorageFormatter externalStorageFormatter = ExternalStorageFormatter.this;
                            Intent intent = new Intent("android.intent.action.MASTER_CLEAR");
                            externalStorageFormatter.sendBroadcast(intent);
                            ExternalStorageFormatter.this.stopSelf();
                            return;
                        }
                        if (!bl && ExternalStorageFormatter.this.mAlwaysReset) {
                            ExternalStorageFormatter externalStorageFormatter = ExternalStorageFormatter.this;
                            Intent intent = new Intent("android.intent.action.MASTER_CLEAR");
                            externalStorageFormatter.sendBroadcast(intent);
                        } else {
                            try {
                                IMountService iMountService3 = iMountService;
                                String string3 = string4;
                                int n = iMountService3.mountVolume(string3);
                            }
                            catch (RemoteException remoteException) {
                                int n = Log.w(ExternalStorageFormatter.TAG, "Failed talking with mount service", remoteException);
                            }
                        }
                        ExternalStorageFormatter.this.stopSelf();
                    }
                }.start();
                return;
            }
            int n = Log.w("MediaFormat", "Unable to locate IMountService");
            return;
        }
        if ("bad_removal".equals(string2)) {
            this.fail(17040250);
            return;
        }
        if ("checking".equals(string2)) {
            this.fail(17040251);
            return;
        }
        if ("removed".equals(string2)) {
            this.fail(17040252);
            return;
        }
        if ("shared".equals(string2)) {
            this.fail(17040253);
            return;
        }
        this.fail(17040254);
        String string5 = "Unknown storage state: " + string2;
        int n = Log.w(TAG, string5);
        this.stopSelf();
    }
}

