/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.DialogPreference;
import android.preference.Preference;
import android.util.AttributeSet;

public class YesNoPreference
extends DialogPreference {
    private boolean mWasPositiveResult;

    public YesNoPreference(Context context) {
        this(context, null);
    }

    public YesNoPreference(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0x1010090);
    }

    public YesNoPreference(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    public boolean getValue() {
        return this.mWasPositiveResult;
    }

    @Override
    protected void onDialogClosed(boolean bl) {
        super.onDialogClosed(bl);
        Boolean bl2 = bl;
        if (!this.callChangeListener(bl2)) {
            return;
        }
        this.setValue(bl);
    }

    @Override
    protected Object onGetDefaultValue(TypedArray typedArray, int n) {
        return typedArray.getBoolean(n, false);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (!parcelable.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState)parcelable;
        Parcelable parcelable2 = savedState.getSuperState();
        super.onRestoreInstanceState(parcelable2);
        boolean bl = savedState.wasPositiveResult;
        this.setValue(bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Parcelable onSaveInstanceState() {
        boolean bl;
        Parcelable parcelable = super.onSaveInstanceState();
        if (this.isPersistent()) {
            return parcelable;
        }
        SavedState savedState = new SavedState(parcelable);
        savedState.wasPositiveResult = bl = this.getValue();
        return savedState;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onSetInitialValue(boolean bl, Object object) {
        boolean bl2;
        if (bl) {
            boolean bl3 = this.mWasPositiveResult;
            bl2 = this.getPersistedBoolean(bl3);
        } else {
            bl2 = (Boolean)object;
        }
        this.setValue(bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setValue(boolean bl) {
        this.mWasPositiveResult = bl;
        boolean bl2 = this.persistBoolean(bl);
        boolean bl3 = !bl;
        this.notifyDependencyChange(bl3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldDisableDependents() {
        if (!this.mWasPositiveResult) return true;
        if (!super.shouldDisableDependents()) return false;
        return true;
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        boolean wasPositiveResult;

        /*
         * Enabled aggressive block sorting
         */
        public SavedState(Parcel parcel) {
            super(parcel);
            boolean bl = parcel.readInt() == 1;
            this.wasPositiveResult = bl;
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            int n2 = this.wasPositiveResult ? 1 : 0;
            parcel.writeInt(n2);
        }
    }
}

