/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.service.wallpaper;

import android.app.WallpaperManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.os.HandlerThread;
import android.os.Looper;
import android.service.wallpaper.WallpaperService;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import com.android.internal.view.WindowManagerPolicyThread;

public class ImageWallpaper
extends WallpaperService {
    private HandlerThread mThread;
    WallpaperManager mWallpaperManager;

    @Override
    public void onCreate() {
        HandlerThread handlerThread;
        WallpaperManager wallpaperManager;
        super.onCreate();
        this.mWallpaperManager = wallpaperManager = (WallpaperManager)this.getSystemService("wallpaper");
        Looper looper = WindowManagerPolicyThread.getLooper();
        if (looper != null) {
            this.setCallbackLooper(looper);
            return;
        }
        this.mThread = handlerThread = new HandlerThread("Wallpaper", -1);
        this.mThread.start();
        Looper looper2 = this.mThread.getLooper();
        this.setCallbackLooper(looper2);
    }

    @Override
    public WallpaperService.Engine onCreateEngine() {
        return new DrawableEngine();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.mThread == null) {
            return;
        }
        boolean bl = this.mThread.quit();
    }

    class DrawableEngine
    extends WallpaperService.Engine {
        Drawable mBackground;
        private final Object mLock;
        private WallpaperObserver mReceiver;
        float mXOffset;
        float mYOffset;

        DrawableEngine() {
            Object object;
            this.mLock = object = new Object();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void drawFrame() {
            SurfaceHolder surfaceHolder = this.getSurfaceHolder();
            Canvas canvas = surfaceHolder.lockCanvas();
            if (canvas == null) {
                return;
            }
            Rect rect = surfaceHolder.getSurfaceFrame();
            Object object = this.mLock;
            synchronized (object) {
                int n;
                int n2;
                Drawable drawable2 = this.mBackground;
                int n3 = rect.width();
                int n4 = rect.height();
                int n5 = drawable2 != null ? drawable2.getIntrinsicWidth() : 0;
                int n6 = drawable2 != null ? drawable2.getIntrinsicHeight() : 0;
                int n7 = n3 - n5;
                int n8 = n4 - n6;
                if (n7 < 0) {
                    float f = n7;
                    float f2 = this.mXOffset;
                    n2 = (int)(f * f2 + 0.5f);
                } else {
                    n2 = n7 / 2;
                }
                if (n8 < 0) {
                    float f = n8;
                    float f3 = this.mYOffset;
                    n = (int)(f * f3 + 0.5f);
                } else {
                    n = n8 / 2;
                }
                float f = n2;
                float f4 = n;
                canvas.translate(f, f4);
                if (n7 < 0 || n8 < 0) {
                    int n9 = canvas.save(2);
                    float f5 = n5;
                    float f6 = n6;
                    Region.Op op = Region.Op.DIFFERENCE;
                    boolean bl = canvas.clipRect(0.0f, 0.0f, f5, f6, op);
                    canvas.drawColor(-16777216);
                    canvas.restore();
                }
                if (drawable2 != null) {
                    drawable2.draw(canvas);
                }
            }
            surfaceHolder.unlockCanvasAndPost(canvas);
        }

        @Override
        public void onCreate(SurfaceHolder surfaceHolder) {
            WallpaperObserver wallpaperObserver;
            super.onCreate(surfaceHolder);
            IntentFilter intentFilter = new IntentFilter("android.intent.action.WALLPAPER_CHANGED");
            this.mReceiver = wallpaperObserver = new WallpaperObserver();
            ImageWallpaper imageWallpaper = ImageWallpaper.this;
            WallpaperObserver wallpaperObserver2 = this.mReceiver;
            Intent intent = imageWallpaper.registerReceiver(wallpaperObserver2, intentFilter);
            this.updateWallpaper();
            surfaceHolder.setSizeFromLayout();
        }

        @Override
        public void onDestroy() {
            super.onDestroy();
            ImageWallpaper imageWallpaper = ImageWallpaper.this;
            WallpaperObserver wallpaperObserver = this.mReceiver;
            imageWallpaper.unregisterReceiver(wallpaperObserver);
        }

        @Override
        public void onOffsetsChanged(float f, float f2, float f3, float f4, int n, int n2) {
            this.mXOffset = f;
            this.mYOffset = f2;
            this.drawFrame();
        }

        @Override
        public void onSurfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
            super.onSurfaceChanged(surfaceHolder, n, n2, n3);
            this.drawFrame();
        }

        @Override
        public void onSurfaceCreated(SurfaceHolder surfaceHolder) {
            super.onSurfaceCreated(surfaceHolder);
        }

        @Override
        public void onSurfaceDestroyed(SurfaceHolder surfaceHolder) {
            super.onSurfaceDestroyed(surfaceHolder);
        }

        @Override
        public void onTouchEvent(MotionEvent motionEvent) {
            super.onTouchEvent(motionEvent);
        }

        @Override
        public void onVisibilityChanged(boolean bl) {
            this.drawFrame();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void updateWallpaper() {
            Object object = this.mLock;
            synchronized (object) {
                try {
                    Drawable drawable2;
                    this.mBackground = drawable2 = ImageWallpaper.this.mWallpaperManager.getFastDrawable();
                }
                catch (RuntimeException runtimeException) {
                    int n = Log.w("ImageWallpaper", "Unable to load wallpaper!", runtimeException);
                }
                return;
            }
        }

        class WallpaperObserver
        extends BroadcastReceiver {
            WallpaperObserver() {
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                DrawableEngine.this.updateWallpaper();
                DrawableEngine.this.drawFrame();
                System.gc();
            }
        }
    }
}

