/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.statusbar;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.android.internal.statusbar.StatusBarIcon;
import com.android.internal.statusbar.StatusBarNotification;

public interface IStatusBar
extends IInterface {
    public void addNotification(IBinder var1, StatusBarNotification var2) throws RemoteException;

    public void animateCollapse() throws RemoteException;

    public void animateExpand() throws RemoteException;

    public void disable(int var1) throws RemoteException;

    public void removeIcon(int var1) throws RemoteException;

    public void removeNotification(IBinder var1) throws RemoteException;

    public void setIcon(int var1, StatusBarIcon var2) throws RemoteException;

    public void updateNotification(IBinder var1, StatusBarNotification var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IStatusBar {
        private static final String DESCRIPTOR = "com.android.internal.statusbar.IStatusBar";
        static final int TRANSACTION_addNotification = 3;
        static final int TRANSACTION_animateCollapse = 8;
        static final int TRANSACTION_animateExpand = 7;
        static final int TRANSACTION_disable = 6;
        static final int TRANSACTION_removeIcon = 2;
        static final int TRANSACTION_removeNotification = 5;
        static final int TRANSACTION_setIcon = 1;
        static final int TRANSACTION_updateNotification = 4;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static IStatusBar asInterface(IBinder iBinder) {
            void var1_2;
            if (iBinder == null) {
                return var1_2;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IStatusBar) {
                IStatusBar iStatusBar = (IStatusBar)iInterface;
                return var1_2;
            }
            Proxy proxy = new Proxy(iBinder);
            return var1_2;
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n3 = parcel.readInt();
                    StatusBarIcon statusBarIcon = parcel.readInt() != 0 ? StatusBarIcon.CREATOR.createFromParcel(parcel) : null;
                    this.setIcon(n3, statusBarIcon);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n4 = parcel.readInt();
                    this.removeIcon(n4);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    StatusBarNotification statusBarNotification = parcel.readInt() != 0 ? StatusBarNotification.CREATOR.createFromParcel(parcel) : null;
                    this.addNotification(iBinder, statusBarNotification);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    StatusBarNotification statusBarNotification = parcel.readInt() != 0 ? StatusBarNotification.CREATOR.createFromParcel(parcel) : null;
                    this.updateNotification(iBinder, statusBarNotification);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    this.removeNotification(iBinder);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n5 = parcel.readInt();
                    this.disable(n5);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.animateExpand();
                    return true;
                }
                case 8: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            this.animateCollapse();
            return true;
        }

        private static class Proxy
        implements IStatusBar {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addNotification(IBinder iBinder, StatusBarNotification statusBarNotification) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    if (statusBarNotification != null) {
                        parcel.writeInt(1);
                        statusBarNotification.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl = this.mRemote.transact(3, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void animateCollapse() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(8, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void animateExpand() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(7, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public void disable(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    boolean bl = this.mRemote.transact(6, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void removeIcon(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    boolean bl = this.mRemote.transact(2, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void removeNotification(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(5, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setIcon(int n, StatusBarIcon statusBarIcon) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    if (statusBarIcon != null) {
                        parcel.writeInt(1);
                        statusBarIcon.writeToParcel(parcel, 0);
                    } else {
                        int n2 = 0;
                        parcel.writeInt(n2);
                    }
                    boolean bl = this.mRemote.transact(1, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void updateNotification(IBinder iBinder, StatusBarNotification statusBarNotification) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    if (statusBarNotification != null) {
                        parcel.writeInt(1);
                        statusBarNotification.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl = this.mRemote.transact(4, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }
        }
    }
}

