/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.statusbar;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.statusbar.StatusBarIcon;
import java.io.PrintWriter;

public class StatusBarIconList
implements Parcelable {
    public static final Parcelable.Creator<StatusBarIconList> CREATOR = new Parcelable.Creator<StatusBarIconList>(){

        @Override
        public StatusBarIconList createFromParcel(Parcel parcel) {
            return new StatusBarIconList(parcel);
        }

        public StatusBarIconList[] newArray(int n) {
            return new StatusBarIconList[n];
        }
    };
    private StatusBarIcon[] mIcons;
    private String[] mSlots;

    public StatusBarIconList() {
    }

    public StatusBarIconList(Parcel parcel) {
        this.readFromParcel(parcel);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void copyFrom(StatusBarIconList statusBarIconList) {
        if (statusBarIconList.mSlots == null) {
            this.mSlots = null;
            this.mIcons = null;
            return;
        }
        int n = statusBarIconList.mSlots.length;
        String[] stringArray = new String[n];
        this.mSlots = stringArray;
        StatusBarIcon[] statusBarIconArray = new StatusBarIcon[n];
        this.mIcons = statusBarIconArray;
        int n2 = 0;
        while (n2 < n) {
            String string2;
            String[] stringArray2 = this.mSlots;
            stringArray2[n2] = string2 = statusBarIconList.mSlots[n2];
            StatusBarIcon[] statusBarIconArray2 = this.mIcons;
            StatusBarIcon statusBarIcon = statusBarIconList.mIcons[n2] != null ? statusBarIconList.mIcons[n2].clone() : null;
            statusBarIconArray2[n2] = statusBarIcon;
            ++n2;
        }
        return;
    }

    public void defineSlots(String[] stringArray) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        this.mSlots = stringArray2;
        for (int i = 0; i < n; ++i) {
            String string2;
            stringArray2[i] = string2 = stringArray[i];
        }
        StatusBarIcon[] statusBarIconArray = new StatusBarIcon[n];
        this.mIcons = statusBarIconArray;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void dump(PrintWriter printWriter) {
        int n = this.mSlots.length;
        printWriter.println("Icon list:");
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray = new Object[3];
            Integer n3 = n2;
            objectArray[0] = n3;
            String string2 = this.mSlots[n2];
            objectArray[1] = string2;
            StatusBarIcon statusBarIcon = this.mIcons[n2];
            objectArray[2] = statusBarIcon;
            PrintWriter printWriter2 = printWriter.printf("  %2d: (%s) %s\n", objectArray);
            ++n2;
        }
        return;
    }

    public StatusBarIcon getIcon(int n) {
        return this.mIcons[n];
    }

    public String getSlot(int n) {
        return this.mSlots[n];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getSlotIndex(String string2) {
        int n = this.mSlots.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = this.mSlots[n2];
            if (string2.equals(string3)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int getViewIndex(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.mIcons[i] == null) continue;
            ++n2;
        }
        return n2;
    }

    public void readFromParcel(Parcel parcel) {
        String[] stringArray = parcel.readStringArray();
        this.mSlots = stringArray;
        int n = parcel.readInt();
        if (n < 0) {
            this.mIcons = null;
            return;
        }
        StatusBarIcon[] statusBarIconArray = new StatusBarIcon[n];
        this.mIcons = statusBarIconArray;
        int n2 = 0;
        while (n2 < n) {
            if (parcel.readInt() != 0) {
                StatusBarIcon statusBarIcon;
                StatusBarIcon[] statusBarIconArray2 = this.mIcons;
                statusBarIconArray2[n2] = statusBarIcon = new StatusBarIcon(parcel);
            }
            ++n2;
        }
        return;
    }

    public void removeIcon(int n) {
        this.mIcons[n] = null;
    }

    public void setIcon(int n, StatusBarIcon statusBarIcon) {
        StatusBarIcon statusBarIcon2;
        StatusBarIcon[] statusBarIconArray = this.mIcons;
        statusBarIconArray[n] = statusBarIcon2 = statusBarIcon.clone();
    }

    public int size() {
        return this.mSlots.length;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        String[] stringArray = this.mSlots;
        parcel.writeStringArray(stringArray);
        if (this.mIcons == null) {
            parcel.writeInt(-1);
            return;
        }
        int n2 = this.mIcons.length;
        parcel.writeInt(n2);
        int n3 = 0;
        while (n3 < n2) {
            StatusBarIcon statusBarIcon = this.mIcons[n3];
            if (statusBarIcon == null) {
                parcel.writeInt(0);
            } else {
                parcel.writeInt(1);
                statusBarIcon.writeToParcel(parcel, n);
            }
            ++n3;
        }
        return;
    }
}

