/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.IccUtils;
import java.util.Arrays;

public class AdnRecord
implements Parcelable {
    static final int ADN_BCD_NUMBER_LENGTH = 0;
    static final int ADN_CAPABILITY_ID = 12;
    static final int ADN_DIALING_NUMBER_END = 11;
    static final int ADN_DIALING_NUMBER_START = 2;
    static final int ADN_EXTENSION_ID = 13;
    static final int ADN_TON_AND_NPI = 1;
    public static final Parcelable.Creator<AdnRecord> CREATOR = new Parcelable.Creator<AdnRecord>(){

        @Override
        public AdnRecord createFromParcel(Parcel parcel) {
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String[] stringArray = parcel.readStringArray();
            return new AdnRecord(n, n2, string2, string3, stringArray);
        }

        public AdnRecord[] newArray(int n) {
            return new AdnRecord[n];
        }
    };
    static final int EXT_RECORD_LENGTH_BYTES = 13;
    static final int EXT_RECORD_TYPE_ADDITIONAL_DATA = 2;
    static final int EXT_RECORD_TYPE_MASK = 3;
    static final int FOOTER_SIZE_BYTES = 14;
    static final String LOG_TAG = "GSM";
    static final int MAX_EXT_CALLED_PARTY_LENGTH = 10;
    static final int MAX_NUMBER_SIZE_BYTES = 11;
    String alphaTag;
    int efid;
    String[] emails;
    int extRecord;
    String number;
    int recordNumber;

    public AdnRecord(int n, int n2, String string2, String string3) {
        this.alphaTag = null;
        this.number = null;
        this.extRecord = 255;
        this.efid = n;
        this.recordNumber = n2;
        this.alphaTag = string2;
        this.number = string3;
        this.emails = null;
    }

    public AdnRecord(int n, int n2, String string2, String string3, String[] stringArray) {
        this.alphaTag = null;
        this.number = null;
        this.extRecord = 255;
        this.efid = n;
        this.recordNumber = n2;
        this.alphaTag = string2;
        this.number = string3;
        this.emails = stringArray;
    }

    public AdnRecord(int n, int n2, byte[] byArray) {
        this.alphaTag = null;
        this.number = null;
        this.extRecord = 255;
        this.efid = n;
        this.recordNumber = n2;
        this.parseRecord(byArray);
    }

    public AdnRecord(String string2, String string3) {
        this(0, 0, string2, string3);
    }

    public AdnRecord(String string2, String string3, String[] stringArray) {
        AdnRecord adnRecord = this;
        int n = 0;
        String string4 = string2;
        String string5 = string3;
        String[] stringArray2 = stringArray;
        adnRecord(0, n, string4, string5, stringArray2);
    }

    public AdnRecord(byte[] byArray) {
        this(0, 0, byArray);
    }

    private void parseRecord(byte[] byArray) {
        try {
            int n;
            String string2;
            String string3;
            int n2 = byArray.length - 14;
            this.alphaTag = string3 = IccUtils.adnStringFieldToString(byArray, 0, n2);
            int n3 = byArray.length - 14;
            int n4 = byArray[n3] & 0xFF;
            if (n4 > 11) {
                this.number = "";
                return;
            }
            int n5 = n3 + 1;
            this.number = string2 = PhoneNumberUtils.calledPartyBCDToString(byArray, n5, n4);
            int n6 = byArray.length - 1;
            this.extRecord = n = byArray[n6] & 0xFF;
            this.emails = null;
            return;
        }
        catch (RuntimeException runtimeException) {
            int n = Log.w(LOG_TAG, "Error parsing AdnRecord", runtimeException);
            this.number = "";
            this.alphaTag = "";
            this.emails = null;
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean stringCompareNullEqualsEmpty(String string2, String string3) {
        if (string2 == string3) {
            return true;
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 != null) return string2.equals(string3);
        string3 = "";
        return string2.equals(string3);
    }

    public void appendExtRecord(byte[] byArray) {
        try {
            String string2;
            if (byArray.length != 13) {
                return;
            }
            if ((byArray[0] & 3) != 2) {
                return;
            }
            if ((byArray[1] & 0xFF) > 10) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = this.number;
            StringBuilder stringBuilder2 = stringBuilder.append(string3);
            int n = byArray[1] & 0xFF;
            String string4 = PhoneNumberUtils.calledPartyBCDFragmentToString(byArray, 2, n);
            this.number = string2 = stringBuilder2.append(string4).toString();
            return;
        }
        catch (RuntimeException runtimeException) {
            int n = Log.w(LOG_TAG, "Error parsing AdnRecord ext record", runtimeException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] buildAdnString(int n) {
        byte by;
        int n2 = n - 14;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = -1;
        }
        if (TextUtils.isEmpty(this.number)) {
            int n3 = Log.w(LOG_TAG, "[buildAdnString] Empty dialing number");
            return byArray;
        }
        if (this.number.length() > 20) {
            int n4 = Log.w(LOG_TAG, "[buildAdnString] Max length of dialing number is 20");
            return null;
        }
        if (this.alphaTag != null && this.alphaTag.length() > n2) {
            String string2 = "[buildAdnString] Max length of tag is " + n2;
            int n5 = Log.w(LOG_TAG, string2);
            return null;
        }
        byte[] byArray2 = PhoneNumberUtils.numberToCalledPartyBCD(this.number);
        int n6 = n2 + 1;
        int n7 = byArray2.length;
        System.arraycopy(byArray2, 0, byArray, n6, n7);
        int n8 = n2 + 0;
        byArray[n8] = by = (byte)byArray2.length;
        int n9 = n2 + 12;
        byArray[n9] = -1;
        int n10 = n2 + 13;
        byArray[n10] = -1;
        if (TextUtils.isEmpty(this.alphaTag)) return byArray;
        byte[] byArray3 = GsmAlphabet.stringToGsm8BitPacked(this.alphaTag);
        int n11 = byArray3.length;
        System.arraycopy(byArray3, 0, byArray, 0, n11);
        return byArray;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String getAlphaTag() {
        return this.alphaTag;
    }

    public String[] getEmails() {
        return this.emails;
    }

    public String getNumber() {
        return this.number;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasExtendedRecord() {
        if (this.extRecord == 0) return false;
        if (this.extRecord == 255) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEmpty() {
        if (!TextUtils.isEmpty(this.alphaTag)) return false;
        if (!TextUtils.isEmpty(this.number)) return false;
        if (this.emails != null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEqual(AdnRecord adnRecord) {
        String string2 = this.alphaTag;
        String string3 = adnRecord.alphaTag;
        if (!AdnRecord.stringCompareNullEqualsEmpty(string2, string3)) return false;
        String string4 = this.number;
        String string5 = adnRecord.number;
        if (!AdnRecord.stringCompareNullEqualsEmpty(string4, string5)) return false;
        Object[] objectArray = this.emails;
        Object[] objectArray2 = adnRecord.emails;
        if (!Arrays.equals(objectArray, objectArray2)) return false;
        return true;
    }

    public void setEmails(String[] stringArray) {
        this.emails = stringArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("ADN Record '");
        String string2 = this.alphaTag;
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("' '");
        String string3 = this.number;
        StringBuilder stringBuilder3 = stringBuilder2.append(string3).append(" ");
        String[] stringArray = this.emails;
        return stringBuilder3.append(stringArray).append("'").toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = this.efid;
        parcel.writeInt(n2);
        int n3 = this.recordNumber;
        parcel.writeInt(n3);
        String string2 = this.alphaTag;
        parcel.writeString(string2);
        String string3 = this.number;
        parcel.writeString(string3);
        String[] stringArray = this.emails;
        parcel.writeStringArray(stringArray);
    }
}

