/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.util.SparseArray;
import com.android.internal.telephony.AdnRecord;
import com.android.internal.telephony.AdnRecordLoader;
import com.android.internal.telephony.IccConstants;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.gsm.UsimPhoneBookManager;
import java.util.ArrayList;
import java.util.Iterator;

public final class AdnRecordCache
extends Handler
implements IccConstants {
    static final int EVENT_LOAD_ALL_ADN_LIKE_DONE = 1;
    static final int EVENT_UPDATE_ADN_DONE = 2;
    SparseArray<ArrayList<AdnRecord>> adnLikeFiles;
    SparseArray<ArrayList<Message>> adnLikeWaiters;
    private UsimPhoneBookManager mUsimPhoneBookManager;
    PhoneBase phone;
    SparseArray<Message> userWriteResponse;

    public AdnRecordCache(PhoneBase phoneBase) {
        UsimPhoneBookManager usimPhoneBookManager;
        SparseArray sparseArray = new SparseArray();
        this.adnLikeFiles = sparseArray;
        SparseArray sparseArray2 = new SparseArray();
        this.adnLikeWaiters = sparseArray2;
        SparseArray sparseArray3 = new SparseArray();
        this.userWriteResponse = sparseArray3;
        this.phone = phoneBase;
        this.mUsimPhoneBookManager = usimPhoneBookManager = new UsimPhoneBookManager(phoneBase, this);
    }

    private void clearUserWriters() {
        int n = this.userWriteResponse.size();
        for (int i = 0; i < n; ++i) {
            Message message = this.userWriteResponse.valueAt(i);
            this.sendErrorResponse(message, "AdnCace reset");
        }
        this.userWriteResponse.clear();
    }

    private void clearWaiters() {
        int n = this.adnLikeWaiters.size();
        for (int i = 0; i < n; ++i) {
            ArrayList<Message> arrayList = this.adnLikeWaiters.valueAt(i);
            RuntimeException runtimeException = new RuntimeException("AdnCache reset");
            AsyncResult asyncResult = new AsyncResult(null, null, runtimeException);
            this.notifyWaiters(arrayList, asyncResult);
        }
        this.adnLikeWaiters.clear();
    }

    private void notifyWaiters(ArrayList<Message> arrayList, AsyncResult asyncResult) {
        if (arrayList == null) {
            return;
        }
        int n = 0;
        int n2 = arrayList.size();
        while (n < n2) {
            Message message = arrayList.get(n);
            Object object = asyncResult.result;
            Throwable throwable = asyncResult.exception;
            AsyncResult asyncResult2 = AsyncResult.forMessage(message, object, throwable);
            message.sendToTarget();
            ++n;
        }
        return;
    }

    private void sendErrorResponse(Message message, String string2) {
        if (message == null) {
            return;
        }
        RuntimeException runtimeException = new RuntimeException(string2);
        AsyncResult.forMessage((Message)message).exception = runtimeException;
        message.sendToTarget();
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     */
    int extensionEfForEf(int n) {
        int n2 = 28490;
        int n3 = 0;
        block7: do {
            switch (n3 == 0 ? n : n3) {
                default: {
                    n2 = -1;
                    n3 = 28474;
                    continue block7;
                }
                case 28615: {
                    n2 = 28616;
                    n3 = 28474;
                    continue block7;
                }
                case 28489: {
                    n2 = 28492;
                    n3 = 28474;
                    continue block7;
                }
                case 28475: {
                    n2 = 28491;
                }
                case 28474: 
                case 28480: {
                    return n2;
                }
                case 20272: 
            }
            return 0;
        } while (true);
        return 0;
    }

    public ArrayList<AdnRecord> getRecordsIfLoaded(int n) {
        return this.adnLikeFiles.get(n);
    }

    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                return;
            }
            case 1: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                int n = message.arg1;
                ArrayList<Message> arrayList = this.adnLikeWaiters.get(n);
                this.adnLikeWaiters.delete(n);
                if (asyncResult.exception == null) {
                    SparseArray<ArrayList<AdnRecord>> sparseArray = this.adnLikeFiles;
                    ArrayList arrayList2 = (ArrayList)asyncResult.result;
                    sparseArray.put(n, arrayList2);
                }
                this.notifyWaiters(arrayList, asyncResult);
                return;
            }
            case 2: 
        }
        AsyncResult asyncResult = (AsyncResult)message.obj;
        int n = message.arg1;
        int n2 = message.arg2;
        AdnRecord adnRecord = (AdnRecord)asyncResult.userObj;
        if (asyncResult.exception == null) {
            ArrayList<AdnRecord> arrayList = this.adnLikeFiles.get(n);
            int n3 = n2 - 1;
            AdnRecord adnRecord2 = arrayList.set(n3, adnRecord);
        }
        Message message2 = this.userWriteResponse.get(n);
        this.userWriteResponse.delete(n);
        Throwable throwable = asyncResult.exception;
        AsyncResult asyncResult2 = AsyncResult.forMessage(message2, null, throwable);
        message2.sendToTarget();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void requestLoadAllAdnLike(int n, int n2, Message message) {
        ArrayList<AdnRecord> arrayList = n == 20272 ? this.mUsimPhoneBookManager.loadEfFilesFromUsim() : this.getRecordsIfLoaded(n);
        if (arrayList != null) {
            if (message == null) {
                return;
            }
            AsyncResult.forMessage((Message)message).result = arrayList;
            message.sendToTarget();
            return;
        }
        ArrayList<Message> arrayList2 = this.adnLikeWaiters.get(n);
        if (arrayList2 != null) {
            boolean bl = arrayList2.add(message);
            return;
        }
        ArrayList<Message> arrayList3 = new ArrayList<Message>();
        boolean bl = arrayList3.add(message);
        this.adnLikeWaiters.put(n, arrayList3);
        if (n2 >= 0) {
            PhoneBase phoneBase = this.phone;
            AdnRecordLoader adnRecordLoader = new AdnRecordLoader(phoneBase);
            Message message2 = this.obtainMessage(1, n, 0);
            adnRecordLoader.loadAllFromEF(n, n2, message2);
            return;
        }
        if (message == null) {
            return;
        }
        AsyncResult asyncResult = AsyncResult.forMessage(message);
        String string2 = "EF is not known ADN-like EF:" + n;
        RuntimeException runtimeException = new RuntimeException(string2);
        asyncResult.exception = runtimeException;
        message.sendToTarget();
    }

    public void reset() {
        this.adnLikeFiles.clear();
        this.mUsimPhoneBookManager.reset();
        this.clearWaiters();
        this.clearUserWriters();
    }

    public void updateAdnByIndex(int n, AdnRecord adnRecord, int n2, String string2, Message message) {
        int n3 = this.extensionEfForEf(n);
        if (n3 < 0) {
            String string3 = "EF is not known ADN-like EF:" + n;
            this.sendErrorResponse(message, string3);
            return;
        }
        if (this.userWriteResponse.get(n) != null) {
            String string4 = "Have pending update for EF:" + n;
            this.sendErrorResponse(message, string4);
            return;
        }
        this.userWriteResponse.put(n, message);
        PhoneBase phoneBase = this.phone;
        AdnRecordLoader adnRecordLoader = new AdnRecordLoader(phoneBase);
        Message message2 = this.obtainMessage(2, n, n2, adnRecord);
        AdnRecord adnRecord2 = adnRecord;
        int n4 = n;
        int n5 = n2;
        String string5 = string2;
        adnRecordLoader.updateEF(adnRecord2, n4, n3, n5, string5, message2);
    }

    public void updateAdnBySearch(int n, AdnRecord adnRecord, AdnRecord adnRecord2, String string2, Message message) {
        int n2 = this.extensionEfForEf(n);
        if (n2 < 0) {
            StringBuilder stringBuilder = new StringBuilder().append("EF is not known ADN-like EF:");
            int n3 = n;
            String string3 = stringBuilder.append(n3).toString();
            AdnRecordCache adnRecordCache = this;
            Message message2 = message;
            String string4 = string3;
            adnRecordCache.sendErrorResponse(message2, string4);
            return;
        }
        ArrayList<AdnRecord> arrayList = this.getRecordsIfLoaded(n);
        if (arrayList == null) {
            StringBuilder stringBuilder = new StringBuilder().append("Adn list not exist for EF:");
            int n4 = n;
            String string5 = stringBuilder.append(n4).toString();
            AdnRecordCache adnRecordCache = this;
            Message message3 = message;
            String string6 = string5;
            adnRecordCache.sendErrorResponse(message3, string6);
            return;
        }
        int n5 = -1;
        int n6 = 1;
        Iterator<AdnRecord> iterator = arrayList.iterator();
        while (true) {
            block8: {
                block7: {
                    if (!iterator.hasNext()) break block7;
                    AdnRecord adnRecord3 = adnRecord;
                    AdnRecord adnRecord4 = iterator.next();
                    AdnRecord adnRecord5 = adnRecord4;
                    if (!adnRecord3.isEqual(adnRecord5)) break block8;
                    n5 = n6;
                }
                if (n5 != -1) break;
                StringBuilder stringBuilder = new StringBuilder().append("Adn record don't exist for ");
                AdnRecord adnRecord6 = adnRecord;
                String string7 = stringBuilder.append(adnRecord6).toString();
                AdnRecordCache adnRecordCache = this;
                Message message4 = message;
                String string8 = string7;
                adnRecordCache.sendErrorResponse(message4, string8);
                return;
            }
            ++n6;
        }
        SparseArray<Message> sparseArray = this.userWriteResponse;
        int n7 = n;
        if (sparseArray.get(n7) != null) {
            StringBuilder stringBuilder = new StringBuilder().append("Have pending update for EF:");
            int n8 = n;
            String string9 = stringBuilder.append(n8).toString();
            AdnRecordCache adnRecordCache = this;
            Message message5 = message;
            String string10 = string9;
            adnRecordCache.sendErrorResponse(message5, string10);
            return;
        }
        SparseArray<Message> sparseArray2 = this.userWriteResponse;
        int n9 = n;
        Message message6 = message;
        sparseArray2.put(n9, message6);
        PhoneBase phoneBase = this.phone;
        AdnRecordLoader adnRecordLoader = new AdnRecordLoader(phoneBase);
        AdnRecordCache adnRecordCache = this;
        int n10 = 2;
        int n11 = n;
        int n12 = n5;
        AdnRecord adnRecord7 = adnRecord2;
        Message message7 = adnRecordCache.obtainMessage(n10, n11, n12, adnRecord7);
        AdnRecord adnRecord8 = adnRecord2;
        int n13 = n;
        String string11 = string2;
        adnRecordLoader.updateEF(adnRecord8, n13, n2, n5, string11, message7);
    }
}

