/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.util.Log;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;
import java.util.List;

public abstract class Call {
    protected final String LOG_TAG;
    protected boolean isGeneric;
    public State state;

    public Call() {
        State state;
        this.state = state = State.IDLE;
        this.isGeneric = false;
        this.LOG_TAG = "Call";
    }

    public abstract List<Connection> getConnections();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getEarliestConnectTime() {
        long l = Long.MAX_VALUE;
        List<Connection> list = this.getConnections();
        if (list.size() == 0) {
            return 0L;
        }
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            long l2 = list.get(n).getConnectTime();
            if (l2 < l) {
                l = l2;
            }
            ++n;
        }
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Connection getEarliestConnection() {
        long l = Long.MAX_VALUE;
        Connection connection = null;
        List<Connection> list = this.getConnections();
        if (list.size() == 0) {
            return null;
        }
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            Connection connection2 = list.get(n);
            long l2 = connection2.getCreateTime();
            if (l2 < l) {
                connection = connection2;
                l = l2;
            }
            ++n;
        }
        return connection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getEarliestCreateTime() {
        long l = Long.MAX_VALUE;
        List<Connection> list = this.getConnections();
        if (list.size() == 0) {
            return 0L;
        }
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            long l2 = list.get(n).getCreateTime();
            if (l2 < l) {
                l = l2;
            }
            ++n;
        }
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Connection getLatestConnection() {
        List<Connection> list = this.getConnections();
        if (list.size() == 0) {
            return null;
        }
        long l = 0L;
        Connection connection = null;
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            Connection connection2 = list.get(n);
            long l2 = connection2.getCreateTime();
            if (l2 > l) {
                connection = connection2;
                l = l2;
            }
            ++n;
        }
        return connection;
    }

    public abstract Phone getPhone();

    public State getState() {
        return this.state;
    }

    public abstract void hangup() throws CallStateException;

    public void hangupIfAlive() {
        if (!this.getState().isAlive()) {
            return;
        }
        try {
            this.hangup();
            return;
        }
        catch (CallStateException callStateException) {
            String string2 = " hangupIfActive: caught " + callStateException;
            int n = Log.w("Call", string2);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasConnection(Connection connection) {
        if (connection.getCall() != this) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasConnections() {
        List<Connection> list = this.getConnections();
        if (list == null) {
            return false;
        }
        if (list.size() <= 0) return false;
        return true;
    }

    public boolean isDialingOrAlerting() {
        return this.getState().isDialing();
    }

    public boolean isGeneric() {
        return this.isGeneric;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isIdle() {
        if (this.getState().isAlive()) return false;
        return true;
    }

    public abstract boolean isMultiparty();

    public boolean isRinging() {
        return this.getState().isRinging();
    }

    public void setGeneric(boolean bl) {
        this.isGeneric = bl;
    }

    public static final class State
    extends Enum<State> {
        private static final /* synthetic */ State[] $VALUES;
        public static final /* enum */ State ACTIVE;
        public static final /* enum */ State ALERTING;
        public static final /* enum */ State DIALING;
        public static final /* enum */ State DISCONNECTED;
        public static final /* enum */ State DISCONNECTING;
        public static final /* enum */ State HOLDING;
        public static final /* enum */ State IDLE;
        public static final /* enum */ State INCOMING;
        public static final /* enum */ State WAITING;

        static {
            IDLE = new State();
            ACTIVE = new State();
            HOLDING = new State();
            DIALING = new State();
            ALERTING = new State();
            INCOMING = new State();
            WAITING = new State();
            DISCONNECTED = new State();
            DISCONNECTING = new State();
            State state = IDLE;
            State state2 = ACTIVE;
            State state3 = HOLDING;
            State state4 = DIALING;
            State state5 = ALERTING;
            State state6 = INCOMING;
            State state7 = WAITING;
            State state8 = DISCONNECTED;
            State state9 = DISCONNECTING;
            State[] stateArray = new State[]{state, state2, state3, state4, state5, state6, state7, state8, state9};
            $VALUES = stateArray;
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isAlive() {
            State state = IDLE;
            if (this == state) return false;
            State state2 = DISCONNECTED;
            if (this == state2) return false;
            State state3 = DISCONNECTING;
            if (this == state3) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isDialing() {
            State state = DIALING;
            if (this == state) return true;
            State state2 = ALERTING;
            if (this != state2) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isRinging() {
            State state = INCOMING;
            if (this == state) return true;
            State state2 = WAITING;
            if (this != state2) return false;
            return true;
        }
    }
}

