/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.media.AudioManager;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.sip.SipPhone;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class CallManager {
    private static final boolean DBG = true;
    private static final int EVENT_CALL_WAITING = 108;
    private static final int EVENT_CDMA_OTA_STATUS_CHANGE = 111;
    private static final int EVENT_DISCONNECT = 100;
    private static final int EVENT_DISPLAY_INFO = 109;
    private static final int EVENT_ECM_TIMER_RESET = 115;
    private static final int EVENT_INCOMING_RING = 104;
    private static final int EVENT_IN_CALL_VOICE_PRIVACY_OFF = 107;
    private static final int EVENT_IN_CALL_VOICE_PRIVACY_ON = 106;
    private static final int EVENT_MMI_COMPLETE = 114;
    private static final int EVENT_MMI_INITIATE = 113;
    private static final int EVENT_NEW_RINGING_CONNECTION = 102;
    private static final int EVENT_POST_DIAL_CHARACTER = 119;
    private static final int EVENT_PRECISE_CALL_STATE_CHANGED = 101;
    private static final int EVENT_RESEND_INCALL_MUTE = 112;
    private static final int EVENT_RINGBACK_TONE = 105;
    private static final int EVENT_SERVICE_STATE_CHANGED = 118;
    private static final int EVENT_SIGNAL_INFO = 110;
    private static final int EVENT_SUBSCRIPTION_INFO_READY = 116;
    private static final int EVENT_SUPP_SERVICE_FAILED = 117;
    private static final int EVENT_UNKNOWN_CONNECTION = 103;
    private static final CallManager INSTANCE = new CallManager();
    private static final String LOG_TAG = "CallManager";
    private static final boolean VDBG;
    private final ArrayList<Connection> emptyConnections;
    private final ArrayList<Call> mBackgroundCalls;
    protected final RegistrantList mCallWaitingRegistrants;
    protected final RegistrantList mCdmaOtaStatusChangeRegistrants;
    private Phone mDefaultPhone;
    protected final RegistrantList mDisconnectRegistrants;
    protected final RegistrantList mDisplayInfoRegistrants;
    protected final RegistrantList mEcmTimerResetRegistrants;
    private final ArrayList<Call> mForegroundCalls;
    private Handler mHandler;
    protected final RegistrantList mInCallVoicePrivacyOffRegistrants;
    protected final RegistrantList mInCallVoicePrivacyOnRegistrants;
    protected final RegistrantList mIncomingRingRegistrants;
    protected final RegistrantList mMmiCompleteRegistrants;
    protected final RegistrantList mMmiInitiateRegistrants;
    protected final RegistrantList mMmiRegistrants;
    protected final RegistrantList mNewRingingConnectionRegistrants;
    private final ArrayList<Phone> mPhones;
    protected final RegistrantList mPostDialCharacterRegistrants;
    protected final RegistrantList mPreciseCallStateRegistrants;
    protected final RegistrantList mResendIncallMuteRegistrants;
    protected final RegistrantList mRingbackToneRegistrants;
    private final ArrayList<Call> mRingingCalls;
    protected final RegistrantList mServiceStateChangedRegistrants;
    protected final RegistrantList mSignalInfoRegistrants;
    protected final RegistrantList mSubscriptionInfoReadyRegistrants;
    protected final RegistrantList mSuppServiceFailedRegistrants;
    protected final RegistrantList mUnknownConnectionRegistrants;

    private CallManager() {
        Handler handler;
        RegistrantList registrantList;
        RegistrantList registrantList2;
        RegistrantList registrantList3;
        RegistrantList registrantList4;
        RegistrantList registrantList5;
        RegistrantList registrantList6;
        RegistrantList registrantList7;
        RegistrantList registrantList8;
        RegistrantList registrantList9;
        RegistrantList registrantList10;
        RegistrantList registrantList11;
        RegistrantList registrantList12;
        RegistrantList registrantList13;
        RegistrantList registrantList14;
        RegistrantList registrantList15;
        RegistrantList registrantList16;
        RegistrantList registrantList17;
        RegistrantList registrantList18;
        RegistrantList registrantList19;
        RegistrantList registrantList20;
        RegistrantList registrantList21;
        ArrayList arrayList = new ArrayList();
        this.emptyConnections = arrayList;
        this.mPreciseCallStateRegistrants = registrantList21 = new RegistrantList();
        this.mNewRingingConnectionRegistrants = registrantList20 = new RegistrantList();
        this.mIncomingRingRegistrants = registrantList19 = new RegistrantList();
        this.mDisconnectRegistrants = registrantList18 = new RegistrantList();
        this.mMmiRegistrants = registrantList17 = new RegistrantList();
        this.mUnknownConnectionRegistrants = registrantList16 = new RegistrantList();
        this.mRingbackToneRegistrants = registrantList15 = new RegistrantList();
        this.mInCallVoicePrivacyOnRegistrants = registrantList14 = new RegistrantList();
        this.mInCallVoicePrivacyOffRegistrants = registrantList13 = new RegistrantList();
        this.mCallWaitingRegistrants = registrantList12 = new RegistrantList();
        this.mDisplayInfoRegistrants = registrantList11 = new RegistrantList();
        this.mSignalInfoRegistrants = registrantList10 = new RegistrantList();
        this.mCdmaOtaStatusChangeRegistrants = registrantList9 = new RegistrantList();
        this.mResendIncallMuteRegistrants = registrantList8 = new RegistrantList();
        this.mMmiInitiateRegistrants = registrantList7 = new RegistrantList();
        this.mMmiCompleteRegistrants = registrantList6 = new RegistrantList();
        this.mEcmTimerResetRegistrants = registrantList5 = new RegistrantList();
        this.mSubscriptionInfoReadyRegistrants = registrantList4 = new RegistrantList();
        this.mSuppServiceFailedRegistrants = registrantList3 = new RegistrantList();
        this.mServiceStateChangedRegistrants = registrantList2 = new RegistrantList();
        this.mPostDialCharacterRegistrants = registrantList = new RegistrantList();
        this.mHandler = handler = new Handler(){

            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 100: {
                        RegistrantList registrantList = CallManager.this.mDisconnectRegistrants;
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        registrantList.notifyRegistrants(asyncResult);
                        return;
                    }
                    case 101: {
                        RegistrantList registrantList = CallManager.this.mPreciseCallStateRegistrants;
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        registrantList.notifyRegistrants(asyncResult);
                        return;
                    }
                    case 102: {
                        if (CallManager.this.getActiveFgCallState().isDialing() || CallManager.this.hasMoreThanOneRingingCall()) {
                            Connection connection = (Connection)((AsyncResult)message.obj).result;
                            try {
                                StringBuilder stringBuilder = new StringBuilder().append("silently drop incoming call: ");
                                Call call = connection.getCall();
                                String string2 = stringBuilder.append(call).toString();
                                int n = Log.d(CallManager.LOG_TAG, string2);
                                connection.getCall().hangup();
                                return;
                            }
                            catch (CallStateException callStateException) {
                                int n = Log.w(CallManager.LOG_TAG, "new ringing connection", callStateException);
                                return;
                            }
                        }
                        RegistrantList registrantList = CallManager.this.mNewRingingConnectionRegistrants;
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        registrantList.notifyRegistrants(asyncResult);
                        return;
                    }
                    case 103: {
                        RegistrantList registrantList = CallManager.this.mUnknownConnectionRegistrants;
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        registrantList.notifyRegistrants(asyncResult);
                        return;
                    }
                    case 104: {
                        if (CallManager.this.hasActiveFgCall()) {
                            return;
                        }
                        RegistrantList registrantList = CallManager.this.mIncomingRingRegistrants;
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        registrantList.notifyRegistrants(asyncResult);
                        return;
                    }
                    case 105: {
                        RegistrantList registrantList = CallManager.this.mRingbackToneRegistrants;
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        registrantList.notifyRegistrants(asyncResult);
                        return;
                    }
                    case 106: {
                        RegistrantList registrantList = CallManager.this.mInCallVoicePrivacyOnRegistrants;
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        registrantList.notifyRegistrants(asyncResult);
                        return;
                    }
                    case 107: {
                        RegistrantList registrantList = CallManager.this.mInCallVoicePrivacyOffRegistrants;
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        registrantList.notifyRegistrants(asyncResult);
                        return;
                    }
                    case 108: {
                        RegistrantList registrantList = CallManager.this.mCallWaitingRegistrants;
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        registrantList.notifyRegistrants(asyncResult);
                        return;
                    }
                    case 109: {
                        RegistrantList registrantList = CallManager.this.mDisplayInfoRegistrants;
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        registrantList.notifyRegistrants(asyncResult);
                        return;
                    }
                    case 110: {
                        RegistrantList registrantList = CallManager.this.mSignalInfoRegistrants;
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        registrantList.notifyRegistrants(asyncResult);
                        return;
                    }
                    case 111: {
                        RegistrantList registrantList = CallManager.this.mCdmaOtaStatusChangeRegistrants;
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        registrantList.notifyRegistrants(asyncResult);
                        return;
                    }
                    case 112: {
                        RegistrantList registrantList = CallManager.this.mResendIncallMuteRegistrants;
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        registrantList.notifyRegistrants(asyncResult);
                        return;
                    }
                    case 113: {
                        RegistrantList registrantList = CallManager.this.mMmiInitiateRegistrants;
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        registrantList.notifyRegistrants(asyncResult);
                        return;
                    }
                    case 114: {
                        RegistrantList registrantList = CallManager.this.mMmiCompleteRegistrants;
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        registrantList.notifyRegistrants(asyncResult);
                        return;
                    }
                    case 115: {
                        RegistrantList registrantList = CallManager.this.mEcmTimerResetRegistrants;
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        registrantList.notifyRegistrants(asyncResult);
                        return;
                    }
                    case 116: {
                        RegistrantList registrantList = CallManager.this.mSubscriptionInfoReadyRegistrants;
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        registrantList.notifyRegistrants(asyncResult);
                        return;
                    }
                    case 117: {
                        RegistrantList registrantList = CallManager.this.mSuppServiceFailedRegistrants;
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        registrantList.notifyRegistrants(asyncResult);
                        return;
                    }
                    case 118: {
                        RegistrantList registrantList = CallManager.this.mServiceStateChangedRegistrants;
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        registrantList.notifyRegistrants(asyncResult);
                        return;
                    }
                    case 119: 
                }
                int n = 0;
                int n2;
                while (n < (n2 = CallManager.this.mPostDialCharacterRegistrants.size())) {
                    int n3;
                    Object object;
                    Message message2 = ((Registrant)CallManager.this.mPostDialCharacterRegistrants.get(n)).messageForRegistrant();
                    message2.obj = object = message.obj;
                    message2.arg1 = n3 = message.arg1;
                    message2.sendToTarget();
                    ++n;
                }
                return;
            }
        };
        ArrayList arrayList2 = new ArrayList();
        this.mPhones = arrayList2;
        ArrayList arrayList3 = new ArrayList();
        this.mRingingCalls = arrayList3;
        ArrayList arrayList4 = new ArrayList();
        this.mBackgroundCalls = arrayList4;
        ArrayList arrayList5 = new ArrayList();
        this.mForegroundCalls = arrayList5;
        this.mDefaultPhone = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean canDial(Phone phone) {
        int n = phone.getServiceState().getState();
        boolean bl = this.hasActiveRingingCall();
        boolean bl2 = this.hasActiveFgCall();
        boolean bl3 = this.hasActiveBgCall();
        boolean bl4 = bl2 && bl3;
        Call.State state = this.getActiveFgCallState();
        if (n == 3) return false;
        if (bl) return false;
        if (bl4) return false;
        Call.State state2 = Call.State.ACTIVE;
        if (state == state2) return true;
        Call.State state3 = Call.State.IDLE;
        if (state == state3) return true;
        Call.State state4 = Call.State.DISCONNECTED;
        if (state != state4) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Context getContext() {
        Phone phone = this.getDefaultPhone();
        if (phone != null) return phone.getContext();
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Call getFirstActiveCall(ArrayList<Call> arrayList) {
        Call call;
        Iterator<Call> iterator = arrayList.iterator();
        do {
            if (!iterator.hasNext()) return null;
        } while ((call = iterator.next()).isIdle());
        return call;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Call getFirstCallOfState(ArrayList<Call> arrayList, Call.State state) {
        Call call;
        Iterator<Call> iterator = arrayList.iterator();
        do {
            if (!iterator.hasNext()) return null;
        } while ((call = iterator.next()).getState() != state);
        return call;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Call getFirstNonIdleCall(List<Call> list) {
        Call call = null;
        Iterator<Call> iterator = list.iterator();
        while (iterator.hasNext()) {
            Call.State state;
            Call call2 = iterator.next();
            if (!call2.isIdle()) {
                return call2;
            }
            Call.State state2 = call2.getState();
            if (state2 == (state = Call.State.IDLE) || call != null) continue;
            call = call2;
        }
        return call;
    }

    public static CallManager getInstance() {
        return INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Phone getPhoneBase(Phone phone) {
        if (!(phone instanceof PhoneProxy)) return phone;
        return phone.getForegroundCall().getPhone();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasMoreThanOneRingingCall() {
        int n = 0;
        Iterator<Call> iterator = this.mRingingCalls.iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while (!iterator.next().getState().isRinging() || ++n <= 1);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isSamePhone(Phone phone, Phone phone2) {
        Phone phone3;
        Phone phone4 = CallManager.getPhoneBase(phone);
        if (phone4 != (phone3 = CallManager.getPhoneBase(phone2))) return false;
        return true;
    }

    private void registerForPhoneStates(Phone phone) {
        Handler handler = this.mHandler;
        phone.registerForPreciseCallStateChanged(handler, 101, null);
        Handler handler2 = this.mHandler;
        phone.registerForDisconnect(handler2, 100, null);
        Handler handler3 = this.mHandler;
        phone.registerForNewRingingConnection(handler3, 102, null);
        Handler handler4 = this.mHandler;
        phone.registerForUnknownConnection(handler4, 103, null);
        Handler handler5 = this.mHandler;
        phone.registerForIncomingRing(handler5, 104, null);
        Handler handler6 = this.mHandler;
        phone.registerForRingbackTone(handler6, 105, null);
        Handler handler7 = this.mHandler;
        phone.registerForInCallVoicePrivacyOn(handler7, 106, null);
        Handler handler8 = this.mHandler;
        phone.registerForInCallVoicePrivacyOff(handler8, 107, null);
        Handler handler9 = this.mHandler;
        phone.registerForDisplayInfo(handler9, 109, null);
        Handler handler10 = this.mHandler;
        phone.registerForSignalInfo(handler10, 110, null);
        Handler handler11 = this.mHandler;
        phone.registerForResendIncallMute(handler11, 112, null);
        Handler handler12 = this.mHandler;
        phone.registerForMmiInitiate(handler12, 113, null);
        Handler handler13 = this.mHandler;
        phone.registerForMmiComplete(handler13, 114, null);
        Handler handler14 = this.mHandler;
        phone.registerForSuppServiceFailed(handler14, 117, null);
        Handler handler15 = this.mHandler;
        phone.registerForServiceStateChanged(handler15, 118, null);
        if (phone.getPhoneType() == 1 || phone.getPhoneType() == 2) {
            Handler handler16 = this.mHandler;
            phone.setOnPostDialCharacter(handler16, 119, null);
        }
        if (phone.getPhoneType() != 2) {
            return;
        }
        Handler handler17 = this.mHandler;
        phone.registerForCdmaOtaStatusChange(handler17, 111, null);
        Handler handler18 = this.mHandler;
        phone.registerForSubscriptionInfoReady(handler18, 116, null);
        Handler handler19 = this.mHandler;
        phone.registerForCallWaiting(handler19, 108, null);
        Handler handler20 = this.mHandler;
        phone.registerForEcmTimerReset(handler20, 115, null);
    }

    private void unregisterForPhoneStates(Phone phone) {
        Handler handler = this.mHandler;
        phone.unregisterForPreciseCallStateChanged(handler);
        Handler handler2 = this.mHandler;
        phone.unregisterForDisconnect(handler2);
        Handler handler3 = this.mHandler;
        phone.unregisterForNewRingingConnection(handler3);
        Handler handler4 = this.mHandler;
        phone.unregisterForUnknownConnection(handler4);
        Handler handler5 = this.mHandler;
        phone.unregisterForIncomingRing(handler5);
        Handler handler6 = this.mHandler;
        phone.unregisterForRingbackTone(handler6);
        Handler handler7 = this.mHandler;
        phone.unregisterForInCallVoicePrivacyOn(handler7);
        Handler handler8 = this.mHandler;
        phone.unregisterForInCallVoicePrivacyOff(handler8);
        Handler handler9 = this.mHandler;
        phone.unregisterForDisplayInfo(handler9);
        Handler handler10 = this.mHandler;
        phone.unregisterForSignalInfo(handler10);
        Handler handler11 = this.mHandler;
        phone.unregisterForResendIncallMute(handler11);
        Handler handler12 = this.mHandler;
        phone.unregisterForMmiInitiate(handler12);
        Handler handler13 = this.mHandler;
        phone.unregisterForMmiComplete(handler13);
        Handler handler14 = this.mHandler;
        phone.unregisterForSuppServiceFailed(handler14);
        Handler handler15 = this.mHandler;
        phone.unregisterForServiceStateChanged(handler15);
        if (phone.getPhoneType() == 1 || phone.getPhoneType() == 2) {
            phone.setOnPostDialCharacter(null, 119, null);
        }
        if (phone.getPhoneType() != 2) {
            return;
        }
        Handler handler16 = this.mHandler;
        phone.unregisterForCdmaOtaStatusChange(handler16);
        Handler handler17 = this.mHandler;
        phone.unregisterForSubscriptionInfoReady(handler17);
        Handler handler18 = this.mHandler;
        phone.unregisterForCallWaiting(handler18);
        Handler handler19 = this.mHandler;
        phone.unregisterForEcmTimerReset(handler19);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void acceptCall(Call call) throws CallStateException {
        Phone phone = call.getPhone();
        if (this.hasActiveFgCall()) {
            Phone phone2 = this.getActiveFgCall().getPhone();
            boolean bl = !phone2.getBackgroundCall().isIdle();
            boolean bl2 = phone2 == phone;
            if (bl2 && bl) {
                this.getActiveFgCall().hangup();
            } else if (!bl2 && !bl) {
                phone2.switchHoldingAndActive();
            } else if (!bl2 && bl) {
                this.getActiveFgCall().hangup();
            }
        }
        phone.acceptCall();
    }

    public boolean canConference(Call call) {
        Phone phone = null;
        Object object = null;
        if (this.hasActiveFgCall()) {
            phone = this.getActiveFgCall().getPhone();
        }
        if (call != null) {
            object = call.getPhone();
        }
        Class<? extends Object> clazz = object.getClass();
        Class<? extends Object> clazz2 = phone.getClass();
        return clazz.equals(clazz2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canTransfer(Call call) {
        Phone phone = null;
        Phone phone2 = null;
        if (this.hasActiveFgCall()) {
            phone = this.getActiveFgCall().getPhone();
        }
        if (call != null) {
            phone2 = call.getPhone();
        }
        if (phone2 != phone) return false;
        if (!phone.canTransfer()) return false;
        return true;
    }

    public void clearDisconnected() {
        Iterator<Phone> iterator = this.mPhones.iterator();
        while (iterator.hasNext()) {
            iterator.next().clearDisconnected();
        }
        return;
    }

    public void conference(Call call) throws CallStateException {
        Phone phone = this.getFgPhone();
        if (phone instanceof SipPhone) {
            ((SipPhone)phone).conference(call);
            return;
        }
        if (this.canConference(call)) {
            phone.conference();
            return;
        }
        throw new CallStateException("Can't conference foreground and selected background call");
    }

    /*
     * Enabled aggressive block sorting
     */
    public Connection dial(Phone phone, String string2) throws CallStateException {
        Phone phone2 = CallManager.getPhoneBase(phone);
        if (!this.canDial(phone)) {
            throw new CallStateException("cannot dial in current state");
        }
        if (!this.hasActiveFgCall()) return phone2.dial(string2);
        Phone phone3 = this.getActiveFgCall().getPhone();
        boolean bl = !phone3.getBackgroundCall().isIdle();
        StringBuilder stringBuilder = new StringBuilder().append("hasBgCall: ").append(bl).append(" sameChannel:");
        boolean bl2 = phone3 == phone2;
        String string3 = stringBuilder.append(bl2).toString();
        int n = Log.d(LOG_TAG, string3);
        if (phone3 == phone2) return phone2.dial(string2);
        if (bl) {
            int n2 = Log.d(LOG_TAG, "Hangup");
            this.getActiveFgCall().hangup();
            return phone2.dial(string2);
        }
        int n3 = Log.d(LOG_TAG, "Switch");
        phone3.switchHoldingAndActive();
        return phone2.dial(string2);
    }

    public Connection dial(Phone phone, String string2, UUSInfo uUSInfo) throws CallStateException {
        return phone.dial(string2, uUSInfo);
    }

    public void explicitCallTransfer(Call call) throws CallStateException {
        if (!this.canTransfer(call)) {
            return;
        }
        call.getPhone().explicitCallTransfer();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Call getActiveFgCall() {
        ArrayList<Call> arrayList = this.mForegroundCalls;
        Call call = this.getFirstNonIdleCall(arrayList);
        if (call != null) return call;
        if (this.mDefaultPhone != null) return this.mDefaultPhone.getForegroundCall();
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Call.State getActiveFgCallState() {
        Call call = this.getActiveFgCall();
        if (call == null) return Call.State.IDLE;
        return call.getState();
    }

    public List<Phone> getAllPhones() {
        return Collections.unmodifiableList(this.mPhones);
    }

    public List<Call> getBackgroundCalls() {
        return Collections.unmodifiableList(this.mBackgroundCalls);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Connection> getBgCallConnections() {
        Call call = this.getFirstActiveBgCall();
        if (call == null) return this.emptyConnections;
        return call.getConnections();
    }

    public Phone getBgPhone() {
        return this.getFirstActiveBgCall().getPhone();
    }

    public Phone getDefaultPhone() {
        return this.mDefaultPhone;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Connection> getFgCallConnections() {
        Call call = this.getActiveFgCall();
        if (call == null) return this.emptyConnections;
        return call.getConnections();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Connection getFgCallLatestConnection() {
        Call call = this.getActiveFgCall();
        if (call == null) return null;
        return call.getLatestConnection();
    }

    public Phone getFgPhone() {
        return this.getActiveFgCall().getPhone();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Call getFirstActiveBgCall() {
        ArrayList<Call> arrayList = this.mBackgroundCalls;
        Call call = this.getFirstNonIdleCall(arrayList);
        if (call != null) return call;
        if (this.mDefaultPhone != null) return this.mDefaultPhone.getBackgroundCall();
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Call getFirstActiveRingingCall() {
        ArrayList<Call> arrayList = this.mRingingCalls;
        Call call = this.getFirstNonIdleCall(arrayList);
        if (call != null) return call;
        if (this.mDefaultPhone != null) return this.mDefaultPhone.getRingingCall();
        return null;
    }

    public List<Call> getForegroundCalls() {
        return Collections.unmodifiableList(this.mForegroundCalls);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getMute() {
        if (this.hasActiveFgCall()) {
            return this.getActiveFgCall().getPhone().getMute();
        }
        if (!this.hasActiveBgCall()) return false;
        return this.getFirstActiveBgCall().getPhone().getMute();
    }

    public List<? extends MmiCode> getPendingMmiCodes(Phone phone) {
        int n = Log.e(LOG_TAG, "getPendingMmiCodes not implemented");
        return null;
    }

    public List<Call> getRingingCalls() {
        return Collections.unmodifiableList(this.mRingingCalls);
    }

    public Phone getRingingPhone() {
        return this.getFirstActiveRingingCall().getPhone();
    }

    public int getServiceState() {
        int n = 1;
        Iterator<Phone> iterator = this.mPhones.iterator();
        while (true) {
            int n2;
            block6: {
                block5: {
                    if (!iterator.hasNext()) break block5;
                    n2 = iterator.next().getServiceState().getState();
                    if (n2 != 0) break block6;
                    n = n2;
                }
                return n;
            }
            if (n2 == 1) {
                if (n != 2 && n != 3) continue;
                n = n2;
                continue;
            }
            if (n2 != 2 || n != 3) continue;
            n = n2;
        }
    }

    public Phone.State getState() {
        Phone.State state = Phone.State.IDLE;
        for (Phone phone : this.mPhones) {
            Phone.State state2;
            Phone.State state3;
            Phone.State state4;
            Phone.State state5 = phone.getState();
            if (state5 == (state4 = Phone.State.RINGING)) {
                state = Phone.State.RINGING;
                continue;
            }
            Phone.State state6 = phone.getState();
            if (state6 != (state3 = Phone.State.OFFHOOK) || state != (state2 = Phone.State.IDLE)) continue;
            state = Phone.State.OFFHOOK;
        }
        return state;
    }

    public void hangupForegroundResumeBackground(Call call) throws CallStateException {
        if (!this.hasActiveFgCall()) {
            return;
        }
        Phone phone = this.getFgPhone();
        if (call == null) {
            return;
        }
        Phone phone2 = call.getPhone();
        if (phone == phone2) {
            this.getActiveFgCall().hangup();
            return;
        }
        this.getActiveFgCall().hangup();
        this.switchHoldingAndActive(call);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasActiveBgCall() {
        ArrayList<Call> arrayList = this.mBackgroundCalls;
        if (this.getFirstActiveCall(arrayList) == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasActiveFgCall() {
        ArrayList<Call> arrayList = this.mForegroundCalls;
        if (this.getFirstActiveCall(arrayList) == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasActiveRingingCall() {
        ArrayList<Call> arrayList = this.mRingingCalls;
        if (this.getFirstActiveCall(arrayList) == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasDisconnectedBgCall() {
        ArrayList<Call> arrayList = this.mBackgroundCalls;
        Call.State state = Call.State.DISCONNECTED;
        if (this.getFirstCallOfState(arrayList, state) == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasDisconnectedFgCall() {
        ArrayList<Call> arrayList = this.mForegroundCalls;
        Call.State state = Call.State.DISCONNECTED;
        if (this.getFirstCallOfState(arrayList, state) == null) return false;
        return true;
    }

    public void registerForCallWaiting(Handler handler, int n, Object object) {
        this.mCallWaitingRegistrants.addUnique(handler, n, object);
    }

    public void registerForCdmaOtaStatusChange(Handler handler, int n, Object object) {
        this.mCdmaOtaStatusChangeRegistrants.addUnique(handler, n, object);
    }

    public void registerForDisconnect(Handler handler, int n, Object object) {
        this.mDisconnectRegistrants.addUnique(handler, n, object);
    }

    public void registerForDisplayInfo(Handler handler, int n, Object object) {
        this.mDisplayInfoRegistrants.addUnique(handler, n, object);
    }

    public void registerForEcmTimerReset(Handler handler, int n, Object object) {
        this.mEcmTimerResetRegistrants.addUnique(handler, n, object);
    }

    public void registerForInCallVoicePrivacyOff(Handler handler, int n, Object object) {
        this.mInCallVoicePrivacyOffRegistrants.addUnique(handler, n, object);
    }

    public void registerForInCallVoicePrivacyOn(Handler handler, int n, Object object) {
        this.mInCallVoicePrivacyOnRegistrants.addUnique(handler, n, object);
    }

    public void registerForIncomingRing(Handler handler, int n, Object object) {
        this.mIncomingRingRegistrants.addUnique(handler, n, object);
    }

    public void registerForMmiComplete(Handler handler, int n, Object object) {
        this.mMmiCompleteRegistrants.addUnique(handler, n, object);
    }

    public void registerForMmiInitiate(Handler handler, int n, Object object) {
        this.mMmiInitiateRegistrants.addUnique(handler, n, object);
    }

    public void registerForNewRingingConnection(Handler handler, int n, Object object) {
        this.mNewRingingConnectionRegistrants.addUnique(handler, n, object);
    }

    public void registerForPostDialCharacter(Handler handler, int n, Object object) {
        this.mPostDialCharacterRegistrants.addUnique(handler, n, object);
    }

    public void registerForPreciseCallStateChanged(Handler handler, int n, Object object) {
        this.mPreciseCallStateRegistrants.addUnique(handler, n, object);
    }

    public void registerForResendIncallMute(Handler handler, int n, Object object) {
        this.mResendIncallMuteRegistrants.addUnique(handler, n, object);
    }

    public void registerForRingbackTone(Handler handler, int n, Object object) {
        this.mRingbackToneRegistrants.addUnique(handler, n, object);
    }

    public void registerForServiceStateChanged(Handler handler, int n, Object object) {
        this.mServiceStateChangedRegistrants.addUnique(handler, n, object);
    }

    public void registerForSignalInfo(Handler handler, int n, Object object) {
        this.mSignalInfoRegistrants.addUnique(handler, n, object);
    }

    public void registerForSubscriptionInfoReady(Handler handler, int n, Object object) {
        this.mSubscriptionInfoReadyRegistrants.addUnique(handler, n, object);
    }

    public void registerForSuppServiceFailed(Handler handler, int n, Object object) {
        this.mSuppServiceFailedRegistrants.addUnique(handler, n, object);
    }

    public void registerForUnknownConnection(Handler handler, int n, Object object) {
        this.mUnknownConnectionRegistrants.addUnique(handler, n, object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean registerPhone(Phone phone) {
        Phone phone2 = CallManager.getPhoneBase(phone);
        if (phone2 == null) return false;
        if (this.mPhones.contains(phone2)) return false;
        StringBuilder stringBuilder = new StringBuilder().append("registerPhone(");
        String string2 = phone.getPhoneName();
        String string3 = stringBuilder.append(string2).append(" ").append(phone).append(")").toString();
        int n = Log.d(LOG_TAG, string3);
        if (this.mPhones.isEmpty()) {
            this.mDefaultPhone = phone2;
        }
        boolean bl = this.mPhones.add(phone2);
        ArrayList<Call> arrayList = this.mRingingCalls;
        Call call = phone2.getRingingCall();
        boolean bl2 = arrayList.add(call);
        ArrayList<Call> arrayList2 = this.mBackgroundCalls;
        Call call2 = phone2.getBackgroundCall();
        boolean bl3 = arrayList2.add(call2);
        ArrayList<Call> arrayList3 = this.mForegroundCalls;
        Call call3 = phone2.getForegroundCall();
        boolean bl4 = arrayList3.add(call3);
        this.registerForPhoneStates(phone2);
        return true;
    }

    public void rejectCall(Call call) throws CallStateException {
        call.getPhone().rejectCall();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean sendBurstDtmf(String string2, int n, int n2, Message message) {
        if (!this.hasActiveFgCall()) return false;
        this.getActiveFgCall().getPhone().sendBurstDtmf(string2, n, n2, message);
        return true;
    }

    public boolean sendDtmf(char c) {
        boolean bl = false;
        if (this.hasActiveFgCall()) {
            this.getActiveFgCall().getPhone().sendDtmf(c);
            bl = true;
        }
        return bl;
    }

    public boolean sendUssdResponse(Phone phone, String string2) {
        int n = Log.e(LOG_TAG, "sendUssdResponse not implemented");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setAudioMode() {
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        int n = 0;
        int[] nArray = 2.$SwitchMap$com$android$internal$telephony$Phone$State;
        int n2 = this.getState().ordinal();
        switch (nArray[n2]) {
            case 1: {
                n = 1;
            }
            default: {
                break;
            }
            case 2: {
                Call.State state;
                Call.State state2;
                Call.State state3;
                Phone phone = this.getFgPhone();
                Call.State state4 = this.getActiveFgCallState();
                if (state4 == (state3 = Call.State.IDLE) || (state2 = this.getActiveFgCallState()) == (state = Call.State.DISCONNECTED)) break;
                n = phone instanceof SipPhone ? 3 : 2;
            }
        }
        if (audioManager.getMode() != n) {
            return;
        }
        audioManager.setMode(n);
    }

    public void setEchoSuppressionEnabled(boolean bl) {
        if (!this.hasActiveFgCall()) {
            return;
        }
        this.getActiveFgCall().getPhone().setEchoSuppressionEnabled(bl);
    }

    public void setMute(boolean bl) {
        if (!this.hasActiveFgCall()) {
            return;
        }
        this.getActiveFgCall().getPhone().setMute(bl);
    }

    public boolean startDtmf(char c) {
        boolean bl = false;
        if (this.hasActiveFgCall()) {
            this.getActiveFgCall().getPhone().startDtmf(c);
            bl = true;
        }
        return bl;
    }

    public void stopDtmf() {
        if (!this.hasActiveFgCall()) {
            return;
        }
        this.getFgPhone().stopDtmf();
    }

    public void switchHoldingAndActive(Call call) throws CallStateException {
        Phone phone = null;
        Phone phone2 = null;
        if (this.hasActiveFgCall()) {
            phone = this.getActiveFgCall().getPhone();
        }
        if (call != null) {
            phone2 = call.getPhone();
        }
        if (phone != null) {
            phone.switchHoldingAndActive();
        }
        if (phone2 == null) {
            return;
        }
        if (phone2 == phone) {
            return;
        }
        phone2.switchHoldingAndActive();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("########### Dump CallManager ############");
        StringBuilder stringBuilder3 = new StringBuilder().append("\nCallManager state = ");
        Phone.State state = this.getState();
        String string2 = stringBuilder3.append((Object)state).toString();
        StringBuilder stringBuilder4 = stringBuilder.append(string2);
        Call call = this.getActiveFgCall();
        StringBuilder stringBuilder5 = new StringBuilder().append("\n   - Foreground: ");
        Call.State state2 = this.getActiveFgCallState();
        String string3 = stringBuilder5.append((Object)state2).toString();
        StringBuilder stringBuilder6 = stringBuilder.append(string3);
        StringBuilder stringBuilder7 = new StringBuilder().append(" from ");
        Phone phone = call.getPhone();
        String string4 = stringBuilder7.append(phone).toString();
        StringBuilder stringBuilder8 = stringBuilder.append(string4);
        StringBuilder stringBuilder9 = stringBuilder.append("\n     Conn: ");
        List<Connection> list = this.getFgCallConnections();
        StringBuilder stringBuilder10 = stringBuilder9.append(list);
        Call call2 = this.getFirstActiveBgCall();
        StringBuilder stringBuilder11 = new StringBuilder().append("\n   - Background: ");
        Call.State state3 = call2.getState();
        String string5 = stringBuilder11.append((Object)state3).toString();
        StringBuilder stringBuilder12 = stringBuilder.append(string5);
        StringBuilder stringBuilder13 = new StringBuilder().append(" from ");
        Phone phone2 = call2.getPhone();
        String string6 = stringBuilder13.append(phone2).toString();
        StringBuilder stringBuilder14 = stringBuilder.append(string6);
        StringBuilder stringBuilder15 = stringBuilder.append("\n     Conn: ");
        List<Connection> list2 = this.getBgCallConnections();
        StringBuilder stringBuilder16 = stringBuilder15.append(list2);
        Call call3 = this.getFirstActiveRingingCall();
        StringBuilder stringBuilder17 = new StringBuilder().append("\n   - Ringing: ");
        Call.State state4 = call3.getState();
        String string7 = stringBuilder17.append((Object)state4).toString();
        StringBuilder stringBuilder18 = stringBuilder.append(string7);
        StringBuilder stringBuilder19 = new StringBuilder().append(" from ");
        Phone phone3 = call3.getPhone();
        String string8 = stringBuilder19.append(phone3).toString();
        StringBuilder stringBuilder20 = stringBuilder.append(string8);
        for (Phone phone4 : this.getAllPhones()) {
            if (phone4 == null) continue;
            StringBuilder stringBuilder21 = new StringBuilder().append("\n Phone: ").append(phone4).append(", name = ");
            String string9 = phone4.getPhoneName();
            StringBuilder stringBuilder22 = stringBuilder21.append(string9).append(", state = ");
            Phone.State state5 = phone4.getState();
            String string10 = stringBuilder22.append((Object)state5).toString();
            StringBuilder stringBuilder23 = stringBuilder.append(string10);
            Call call4 = phone4.getForegroundCall();
            StringBuilder stringBuilder24 = stringBuilder.append("\n   - Foreground: ").append(call4);
            Call call5 = phone4.getBackgroundCall();
            StringBuilder stringBuilder25 = stringBuilder.append(" Background: ").append(call5);
            Call call6 = phone4.getRingingCall();
            StringBuilder stringBuilder26 = stringBuilder.append(" Ringing: ").append(call6);
        }
        StringBuilder stringBuilder27 = stringBuilder.append("\n########## End Dump CallManager ##########");
        return stringBuilder.toString();
    }

    public void unregisterForCallWaiting(Handler handler) {
        this.mCallWaitingRegistrants.remove(handler);
    }

    public void unregisterForCdmaOtaStatusChange(Handler handler) {
        this.mCdmaOtaStatusChangeRegistrants.remove(handler);
    }

    public void unregisterForDisconnect(Handler handler) {
        this.mDisconnectRegistrants.remove(handler);
    }

    public void unregisterForDisplayInfo(Handler handler) {
        this.mDisplayInfoRegistrants.remove(handler);
    }

    public void unregisterForEcmTimerReset(Handler handler) {
        this.mEcmTimerResetRegistrants.remove(handler);
    }

    public void unregisterForInCallVoicePrivacyOff(Handler handler) {
        this.mInCallVoicePrivacyOffRegistrants.remove(handler);
    }

    public void unregisterForInCallVoicePrivacyOn(Handler handler) {
        this.mInCallVoicePrivacyOnRegistrants.remove(handler);
    }

    public void unregisterForIncomingRing(Handler handler) {
        this.mIncomingRingRegistrants.remove(handler);
    }

    public void unregisterForMmiComplete(Handler handler) {
        this.mMmiCompleteRegistrants.remove(handler);
    }

    public void unregisterForMmiInitiate(Handler handler) {
        this.mMmiInitiateRegistrants.remove(handler);
    }

    public void unregisterForNewRingingConnection(Handler handler) {
        this.mNewRingingConnectionRegistrants.remove(handler);
    }

    public void unregisterForPostDialCharacter(Handler handler) {
        this.mPostDialCharacterRegistrants.remove(handler);
    }

    public void unregisterForPreciseCallStateChanged(Handler handler) {
        this.mPreciseCallStateRegistrants.remove(handler);
    }

    public void unregisterForResendIncallMute(Handler handler) {
        this.mResendIncallMuteRegistrants.remove(handler);
    }

    public void unregisterForRingbackTone(Handler handler) {
        this.mRingbackToneRegistrants.remove(handler);
    }

    public void unregisterForServiceStateChanged(Handler handler) {
        this.mServiceStateChangedRegistrants.remove(handler);
    }

    public void unregisterForSignalInfo(Handler handler) {
        this.mSignalInfoRegistrants.remove(handler);
    }

    public void unregisterForSubscriptionInfoReady(Handler handler) {
        this.mSubscriptionInfoReadyRegistrants.remove(handler);
    }

    public void unregisterForSuppServiceFailed(Handler handler) {
        this.mSuppServiceFailedRegistrants.remove(handler);
    }

    public void unregisterForUnknownConnection(Handler handler) {
        this.mUnknownConnectionRegistrants.remove(handler);
    }

    public void unregisterPhone(Phone phone) {
        Phone phone2;
        Phone phone3 = CallManager.getPhoneBase(phone);
        if (phone3 == null) {
            return;
        }
        if (!this.mPhones.contains(phone3)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append("unregisterPhone(");
        String string2 = phone.getPhoneName();
        String string3 = stringBuilder.append(string2).append(" ").append(phone).append(")").toString();
        int n = Log.d(LOG_TAG, string3);
        boolean bl = this.mPhones.remove(phone3);
        ArrayList<Call> arrayList = this.mRingingCalls;
        Call call = phone3.getRingingCall();
        boolean bl2 = arrayList.remove(call);
        ArrayList<Call> arrayList2 = this.mBackgroundCalls;
        Call call2 = phone3.getBackgroundCall();
        boolean bl3 = arrayList2.remove(call2);
        ArrayList<Call> arrayList3 = this.mForegroundCalls;
        Call call3 = phone3.getForegroundCall();
        boolean bl4 = arrayList3.remove(call3);
        this.unregisterForPhoneStates(phone3);
        Phone phone4 = this.mDefaultPhone;
        if (phone3 != phone4) {
            return;
        }
        if (this.mPhones.isEmpty()) {
            this.mDefaultPhone = null;
            return;
        }
        this.mDefaultPhone = phone2 = this.mPhones.get(0);
    }
}

