/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.provider.ContactsContract;
import android.telephony.PhoneNumberUtils;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;

public class CallerInfo {
    public static final String PAYPHONE_NUMBER = "-3";
    public static final String PRIVATE_NUMBER = "-2";
    private static final String TAG = "CallerInfo";
    public static final String UNKNOWN_NUMBER = "-1";
    private static final boolean VDBG = Log.isLoggable("CallerInfo", 2);
    public Drawable cachedPhoto;
    public String cnapName;
    public boolean contactExists;
    public Uri contactRefUri;
    public Uri contactRingtoneUri;
    public boolean isCachedPhotoCurrent;
    private boolean mIsEmergency = false;
    private boolean mIsVoiceMail = false;
    public String name;
    public int namePresentation;
    public boolean needUpdate;
    public String numberLabel;
    public int numberPresentation;
    public int numberType;
    public long person_id;
    public String phoneLabel;
    public String phoneNumber;
    public int photoResource;
    public boolean shouldSendToVoicemail;

    static CallerInfo doSecondaryLookupIfNecessary(Context context, String string2, CallerInfo callerInfo) {
        int n;
        String string3;
        if (!callerInfo.contactExists && PhoneNumberUtils.isUriNumber(string2) && PhoneNumberUtils.isGlobalPhoneNumber(string3 = string2.substring(0, n = string2.indexOf(64)))) {
            Uri uri = ContactsContract.PhoneLookup.CONTENT_FILTER_URI;
            String string4 = Uri.encode(string3);
            Uri uri2 = Uri.withAppendedPath(uri, string4);
            callerInfo = CallerInfo.getCallerInfo(context, uri2);
        }
        return callerInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getCallerId(Context context, String string2) {
        CallerInfo callerInfo = CallerInfo.getCallerInfo(context, string2);
        String string3 = null;
        if (callerInfo == null) return string3;
        String string4 = callerInfo.name;
        if (TextUtils.isEmpty(string4)) return string2;
        return string4;
    }

    public static CallerInfo getCallerInfo(Context context, Uri uri) {
        ContentResolver contentResolver = context.getContentResolver();
        Uri uri2 = uri;
        String string2 = null;
        String[] stringArray = null;
        String string3 = null;
        Cursor cursor = contentResolver.query(uri2, null, string2, stringArray, string3);
        return CallerInfo.getCallerInfo(context, uri, cursor);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CallerInfo getCallerInfo(Context context, Uri uri, Cursor cursor) {
        String string2;
        CallerInfo callerInfo = new CallerInfo();
        callerInfo.photoResource = 0;
        callerInfo.phoneLabel = null;
        callerInfo.numberType = 0;
        callerInfo.numberLabel = null;
        callerInfo.cachedPhoto = null;
        callerInfo.isCachedPhotoCurrent = false;
        callerInfo.contactExists = false;
        if (VDBG) {
            int n = Log.v(TAG, "construct callerInfo from cursor");
        }
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                Uri uri2;
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                int n6 = cursor.getColumnIndex("display_name");
                if (n6 != -1) {
                    String string3;
                    callerInfo.name = string3 = cursor.getString(n6);
                }
                if ((n5 = cursor.getColumnIndex("number")) != -1) {
                    String string4;
                    callerInfo.phoneNumber = string4 = cursor.getString(n5);
                }
                if ((n4 = cursor.getColumnIndex("label")) != -1 && (n3 = cursor.getColumnIndex("type")) != -1) {
                    String string5;
                    String string6;
                    int n7;
                    callerInfo.numberType = n7 = cursor.getInt(n3);
                    callerInfo.numberLabel = string6 = cursor.getString(n4);
                    int n8 = callerInfo.numberType;
                    String string7 = callerInfo.numberLabel;
                    callerInfo.phoneLabel = string5 = ((Object)ContactsContract.CommonDataKinds.Phone.getDisplayLabel(context, n8, string7)).toString();
                }
                if ((n2 = CallerInfo.getColumnIndexForPersonId(uri, cursor)) != -1) {
                    long l;
                    callerInfo.person_id = l = cursor.getLong(n2);
                    if (VDBG) {
                        StringBuilder stringBuilder = new StringBuilder().append("==> got info.person_id: ");
                        long l2 = callerInfo.person_id;
                        String string8 = stringBuilder.append(l2).toString();
                        int n9 = Log.v(TAG, string8);
                    }
                } else {
                    String string9 = "Couldn't find person_id column for " + uri;
                    int n10 = Log.w(TAG, string9);
                }
                callerInfo.contactRingtoneUri = (n = cursor.getColumnIndex("custom_ringtone")) != -1 && cursor.getString(n) != null ? (uri2 = Uri.parse(cursor.getString(n))) : null;
                int n11 = cursor.getColumnIndex("send_to_voicemail");
                boolean bl = n11 != -1 && cursor.getInt(n11) == 1;
                callerInfo.shouldSendToVoicemail = bl;
                callerInfo.contactExists = true;
            }
            cursor.close();
        }
        callerInfo.needUpdate = false;
        callerInfo.name = string2 = CallerInfo.normalize(callerInfo.name);
        callerInfo.contactRefUri = uri;
        return callerInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CallerInfo getCallerInfo(Context context, String string2) {
        if (TextUtils.isEmpty(string2)) {
            return null;
        }
        if (PhoneNumberUtils.isEmergencyNumber(string2)) {
            return new CallerInfo().markAsEmergency(context);
        }
        if (PhoneNumberUtils.isVoiceMailNumber(string2)) {
            return new CallerInfo().markAsVoiceMail();
        }
        Uri uri = ContactsContract.PhoneLookup.CONTENT_FILTER_URI;
        String string3 = Uri.encode(string2);
        Uri uri2 = Uri.withAppendedPath(uri, string3);
        CallerInfo callerInfo = CallerInfo.getCallerInfo(context, uri2);
        CallerInfo callerInfo2 = CallerInfo.doSecondaryLookupIfNecessary(context, string2, callerInfo);
        if (!TextUtils.isEmpty(callerInfo2.phoneNumber)) return callerInfo2;
        callerInfo2.phoneNumber = string2;
        return callerInfo2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int getColumnIndexForPersonId(Uri uri, Cursor cursor) {
        if (VDBG) {
            String string2 = "- getColumnIndexForPersonId: contactRef URI = '" + uri + "'...";
            int n = Log.v(TAG, string2);
        }
        String string3 = uri.toString();
        String string4 = null;
        if (string3.startsWith("content://com.android.contacts/data/phones")) {
            if (VDBG) {
                int n = Log.v(TAG, "'data/phones' URI; using RawContacts.CONTACT_ID");
            }
            string4 = "contact_id";
        } else if (string3.startsWith("content://com.android.contacts/data")) {
            if (VDBG) {
                int n = Log.v(TAG, "'data' URI; using Data.CONTACT_ID");
            }
            string4 = "contact_id";
        } else if (string3.startsWith("content://com.android.contacts/phone_lookup")) {
            if (VDBG) {
                int n = Log.v(TAG, "'phone_lookup' URI; using PhoneLookup._ID");
            }
            string4 = "_id";
        } else {
            String string5 = "Unexpected prefix for contactRef '" + string3 + "'";
            int n = Log.w(TAG, string5);
        }
        int n = string4 != null ? cursor.getColumnIndex(string4) : -1;
        if (VDBG) {
            String string6 = "==> Using column '" + string4 + "' (columnIndex = " + n + ") for person_id lookup...";
            int n2 = Log.v(TAG, string6);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String normalize(String string2) {
        if (string2 == null) return string2;
        if (string2.length() <= 0) return null;
        return string2;
    }

    public boolean isEmergencyNumber() {
        return this.mIsEmergency;
    }

    public boolean isVoiceMailNumber() {
        return this.mIsVoiceMail;
    }

    CallerInfo markAsEmergency(Context context) {
        String string2;
        this.phoneNumber = string2 = context.getString(17039999);
        this.photoResource = 17302080;
        this.mIsEmergency = true;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    CallerInfo markAsVoiceMail() {
        this.mIsVoiceMail = true;
        try {
            String string2;
            this.phoneNumber = string2 = TelephonyManager.getDefault().getVoiceMailAlphaTag();
            return this;
        }
        catch (SecurityException securityException) {
            int n = Log.e(TAG, "Cannot access VoiceMail.", securityException);
            return this;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128).append("CallerInfo { ");
        StringBuilder stringBuilder2 = new StringBuilder().append("name ");
        String string2 = this.name == null ? "null" : "non-null";
        String string3 = stringBuilder2.append(string2).toString();
        StringBuilder stringBuilder3 = stringBuilder.append(string3);
        StringBuilder stringBuilder4 = new StringBuilder().append(", phoneNumber ");
        String string4 = this.phoneNumber == null ? "null" : "non-null";
        String string5 = stringBuilder4.append(string4).toString();
        return stringBuilder3.append(string5).append(" }").toString();
    }
}

