/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.AsyncQueryHandler;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.provider.ContactsContract;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import com.android.internal.telephony.CallerInfo;

public class CallerInfoAsyncQuery {
    private static final boolean DBG = false;
    private static final int EVENT_ADD_LISTENER = 2;
    private static final int EVENT_EMERGENCY_NUMBER = 4;
    private static final int EVENT_END_OF_QUEUE = 3;
    private static final int EVENT_NEW_QUERY = 1;
    private static final int EVENT_VOICEMAIL_NUMBER = 5;
    private static final String LOG_TAG = "CallerInfoAsyncQuery";
    private CallerInfoAsyncQueryHandler mHandler;

    private CallerInfoAsyncQuery() {
    }

    private void allocate(Context context, Uri uri) {
        CallerInfoAsyncQueryHandler callerInfoAsyncQueryHandler;
        if (context == null || uri == null) {
            throw new QueryPoolException("Bad context or query uri.");
        }
        this.mHandler = callerInfoAsyncQueryHandler = new CallerInfoAsyncQueryHandler(context);
        Context context2 = CallerInfoAsyncQueryHandler.access$302(this.mHandler, context);
        Uri uri2 = CallerInfoAsyncQueryHandler.access$402(this.mHandler, uri);
    }

    private void release() {
        Context context = CallerInfoAsyncQueryHandler.access$302(this.mHandler, null);
        Uri uri = CallerInfoAsyncQueryHandler.access$402(this.mHandler, null);
        CallerInfo callerInfo = CallerInfoAsyncQueryHandler.access$502(this.mHandler, null);
        this.mHandler = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String sanitizeUriToString(Uri uri) {
        if (uri == null) return "";
        String string2 = uri.toString();
        int n = string2.lastIndexOf(47);
        if (n <= 0) return string2;
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = string2.substring(0, n);
        return stringBuilder.append(string3).append("/xxxxxxx").toString();
    }

    public static CallerInfoAsyncQuery startQuery(int n, Context context, Uri uri, OnQueryCompleteListener onQueryCompleteListener, Object object) {
        CallerInfoAsyncQuery callerInfoAsyncQuery = new CallerInfoAsyncQuery();
        callerInfoAsyncQuery.allocate(context, uri);
        CookieWrapper cookieWrapper = new CookieWrapper();
        cookieWrapper.listener = onQueryCompleteListener;
        cookieWrapper.cookie = object;
        cookieWrapper.event = 1;
        CallerInfoAsyncQueryHandler callerInfoAsyncQueryHandler = callerInfoAsyncQuery.mHandler;
        int n2 = n;
        Uri uri2 = uri;
        String string2 = null;
        String[] stringArray = null;
        String string3 = null;
        callerInfoAsyncQueryHandler.startQuery(n2, cookieWrapper, uri2, null, string2, stringArray, string3);
        return callerInfoAsyncQuery;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CallerInfoAsyncQuery startQuery(int n, Context context, String string2, OnQueryCompleteListener onQueryCompleteListener, Object object) {
        String[] stringArray;
        String string3;
        Uri uri;
        if (PhoneNumberUtils.isUriNumber(string2)) {
            uri = ContactsContract.Data.CONTENT_URI;
            string3 = "upper(data1)=? AND mimetype='vnd.android.cursor.item/sip_address'";
            String string4 = string2.toUpperCase();
            stringArray = new String[]{string4};
        } else {
            Uri uri2 = ContactsContract.PhoneLookup.CONTENT_FILTER_URI;
            String string5 = Uri.encode(string2);
            uri = Uri.withAppendedPath(uri2, string5);
            string3 = null;
            stringArray = null;
        }
        CallerInfoAsyncQuery callerInfoAsyncQuery = new CallerInfoAsyncQuery();
        callerInfoAsyncQuery.allocate(context, uri);
        CookieWrapper cookieWrapper = new CookieWrapper();
        cookieWrapper.listener = onQueryCompleteListener;
        cookieWrapper.cookie = object;
        cookieWrapper.number = string2;
        cookieWrapper.event = PhoneNumberUtils.isEmergencyNumber(string2) ? 4 : (PhoneNumberUtils.isVoiceMailNumber(string2) ? 5 : 1);
        CallerInfoAsyncQueryHandler callerInfoAsyncQueryHandler = callerInfoAsyncQuery.mHandler;
        int n2 = n;
        String string6 = null;
        callerInfoAsyncQueryHandler.startQuery(n2, cookieWrapper, uri, null, string3, stringArray, string6);
        return callerInfoAsyncQuery;
    }

    public void addQueryListener(int n, OnQueryCompleteListener onQueryCompleteListener, Object object) {
        CookieWrapper cookieWrapper = new CookieWrapper();
        cookieWrapper.listener = onQueryCompleteListener;
        cookieWrapper.cookie = object;
        cookieWrapper.event = 2;
        CallerInfoAsyncQueryHandler callerInfoAsyncQueryHandler = this.mHandler;
        int n2 = n;
        String[] stringArray = null;
        String string2 = null;
        String[] stringArray2 = null;
        String string3 = null;
        callerInfoAsyncQueryHandler.startQuery(n2, cookieWrapper, null, stringArray, string2, stringArray2, string3);
    }

    private class CallerInfoAsyncQueryHandler
    extends AsyncQueryHandler {
        private CallerInfo mCallerInfo;
        private Context mQueryContext;
        private Uri mQueryUri;

        private CallerInfoAsyncQueryHandler(Context context) {
            ContentResolver contentResolver = context.getContentResolver();
            super(contentResolver);
        }

        static /* synthetic */ Context access$302(CallerInfoAsyncQueryHandler callerInfoAsyncQueryHandler, Context context) {
            callerInfoAsyncQueryHandler.mQueryContext = context;
            return context;
        }

        static /* synthetic */ Uri access$402(CallerInfoAsyncQueryHandler callerInfoAsyncQueryHandler, Uri uri) {
            callerInfoAsyncQueryHandler.mQueryUri = uri;
            return uri;
        }

        static /* synthetic */ CallerInfo access$502(CallerInfoAsyncQueryHandler callerInfoAsyncQueryHandler, CallerInfo callerInfo) {
            callerInfoAsyncQueryHandler.mCallerInfo = callerInfo;
            return callerInfo;
        }

        @Override
        protected Handler createHandler(Looper looper) {
            return new CallerInfoWorkerHandler(looper);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected void onQueryComplete(int n, Object object, Cursor cursor) {
            CookieWrapper cookieWrapper = (CookieWrapper)object;
            if (cookieWrapper == null) {
                return;
            }
            if (cookieWrapper.event == 3) {
                CallerInfoAsyncQuery.this.release();
                return;
            }
            if (this.mCallerInfo == null) {
                if (this.mQueryContext == null || this.mQueryUri == null) {
                    throw new QueryPoolException("Bad context or query uri, or CallerInfoAsyncQuery already released.");
                }
                if (cookieWrapper.event == 4) {
                    CallerInfo callerInfo;
                    CallerInfo callerInfo2 = new CallerInfo();
                    Context context = this.mQueryContext;
                    this.mCallerInfo = callerInfo = callerInfo2.markAsEmergency(context);
                } else if (cookieWrapper.event == 5) {
                    CallerInfo callerInfo;
                    this.mCallerInfo = callerInfo = new CallerInfo().markAsVoiceMail();
                } else {
                    CallerInfo callerInfo;
                    CallerInfo callerInfo3;
                    Context context = this.mQueryContext;
                    Uri uri = this.mQueryUri;
                    this.mCallerInfo = callerInfo3 = CallerInfo.getCallerInfo(context, uri, cursor);
                    Context context2 = this.mQueryContext;
                    String string2 = cookieWrapper.number;
                    CallerInfo callerInfo4 = this.mCallerInfo;
                    CallerInfo callerInfo5 = CallerInfo.doSecondaryLookupIfNecessary(context2, string2, callerInfo4);
                    if (callerInfo5 != (callerInfo = this.mCallerInfo)) {
                        this.mCallerInfo = callerInfo5;
                    }
                    if (!TextUtils.isEmpty(cookieWrapper.number)) {
                        String string3;
                        CallerInfo callerInfo6 = this.mCallerInfo;
                        callerInfo6.phoneNumber = string3 = PhoneNumberUtils.formatNumber(cookieWrapper.number);
                    }
                }
                CookieWrapper cookieWrapper2 = new CookieWrapper();
                cookieWrapper2.event = 3;
                CallerInfoAsyncQueryHandler callerInfoAsyncQueryHandler = this;
                int n2 = n;
                String[] stringArray = null;
                String string4 = null;
                String[] stringArray2 = null;
                String string5 = null;
                callerInfoAsyncQueryHandler.startQuery(n2, cookieWrapper2, null, stringArray, string4, stringArray2, string5);
            }
            if (cookieWrapper.listener == null) {
                return;
            }
            OnQueryCompleteListener onQueryCompleteListener = cookieWrapper.listener;
            Object object2 = cookieWrapper.cookie;
            CallerInfo callerInfo = this.mCallerInfo;
            onQueryCompleteListener.onQueryComplete(n, object2, callerInfo);
        }

        protected class CallerInfoWorkerHandler
        extends AsyncQueryHandler.WorkerHandler {
            public CallerInfoWorkerHandler(Looper looper) {
                super(looper);
            }

            @Override
            public void handleMessage(Message message) {
                int n;
                AsyncQueryHandler.WorkerArgs workerArgs = (AsyncQueryHandler.WorkerArgs)message.obj;
                CookieWrapper cookieWrapper = (CookieWrapper)workerArgs.cookie;
                if (cookieWrapper == null) {
                    super.handleMessage(message);
                    return;
                }
                switch (cookieWrapper.event) {
                    default: {
                        return;
                    }
                    case 1: {
                        super.handleMessage(message);
                        return;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                }
                Handler handler = workerArgs.handler;
                int n2 = message.what;
                Message message2 = handler.obtainMessage(n2);
                message2.obj = workerArgs;
                message2.arg1 = n = message.arg1;
                message2.sendToTarget();
            }
        }
    }

    public static class QueryPoolException
    extends SQLException {
        public QueryPoolException(String string2) {
            super(string2);
        }
    }

    private static final class CookieWrapper {
        public Object cookie;
        public int event;
        public OnQueryCompleteListener listener;
        public String number;

        private CookieWrapper() {
        }
    }

    public static interface OnQueryCompleteListener {
        public void onQueryComplete(int var1, Object var2, CallerInfo var3);
    }
}

