/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.util.Log;

public class CommandException
extends RuntimeException {
    private Error e;

    public CommandException(Error error) {
        String string2 = error.toString();
        super(string2);
        this.e = error;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CommandException fromRilErrno(int n) {
        switch (n) {
            default: {
                String string2 = "Unrecognized RIL errno " + n;
                int n2 = Log.e("GSM", string2);
                Error error = Error.INVALID_RESPONSE;
                return new CommandException(error);
            }
            case 0: {
                return null;
            }
            case -1: {
                Error error = Error.INVALID_RESPONSE;
                return new CommandException(error);
            }
            case 1: {
                Error error = Error.RADIO_NOT_AVAILABLE;
                return new CommandException(error);
            }
            case 2: {
                Error error = Error.GENERIC_FAILURE;
                return new CommandException(error);
            }
            case 3: {
                Error error = Error.PASSWORD_INCORRECT;
                return new CommandException(error);
            }
            case 4: {
                Error error = Error.SIM_PIN2;
                return new CommandException(error);
            }
            case 5: {
                Error error = Error.SIM_PUK2;
                return new CommandException(error);
            }
            case 6: {
                Error error = Error.REQUEST_NOT_SUPPORTED;
                return new CommandException(error);
            }
            case 8: {
                Error error = Error.OP_NOT_ALLOWED_DURING_VOICE_CALL;
                return new CommandException(error);
            }
            case 9: {
                Error error = Error.OP_NOT_ALLOWED_BEFORE_REG_NW;
                return new CommandException(error);
            }
            case 10: {
                Error error = Error.SMS_FAIL_RETRY;
                return new CommandException(error);
            }
            case 11: {
                Error error = Error.SIM_ABSENT;
                return new CommandException(error);
            }
            case 12: {
                Error error = Error.SUBSCRIPTION_NOT_AVAILABLE;
                return new CommandException(error);
            }
            case 13: {
                Error error = Error.MODE_NOT_SUPPORTED;
                return new CommandException(error);
            }
            case 14: {
                Error error = Error.FDN_CHECK_FAILURE;
                return new CommandException(error);
            }
            case 15: 
        }
        Error error = Error.ILLEGAL_SIM_OR_ME;
        return new CommandException(error);
    }

    public Error getCommandError() {
        return this.e;
    }

    public static final class Error
    extends Enum<Error> {
        private static final /* synthetic */ Error[] $VALUES;
        public static final /* enum */ Error FDN_CHECK_FAILURE;
        public static final /* enum */ Error GENERIC_FAILURE;
        public static final /* enum */ Error ILLEGAL_SIM_OR_ME;
        public static final /* enum */ Error INVALID_RESPONSE;
        public static final /* enum */ Error MODE_NOT_SUPPORTED;
        public static final /* enum */ Error OP_NOT_ALLOWED_BEFORE_REG_NW;
        public static final /* enum */ Error OP_NOT_ALLOWED_DURING_VOICE_CALL;
        public static final /* enum */ Error PASSWORD_INCORRECT;
        public static final /* enum */ Error RADIO_NOT_AVAILABLE;
        public static final /* enum */ Error REQUEST_NOT_SUPPORTED;
        public static final /* enum */ Error SIM_ABSENT;
        public static final /* enum */ Error SIM_PIN2;
        public static final /* enum */ Error SIM_PUK2;
        public static final /* enum */ Error SMS_FAIL_RETRY;
        public static final /* enum */ Error SUBSCRIPTION_NOT_AVAILABLE;

        static {
            INVALID_RESPONSE = new Error();
            RADIO_NOT_AVAILABLE = new Error();
            GENERIC_FAILURE = new Error();
            PASSWORD_INCORRECT = new Error();
            SIM_PIN2 = new Error();
            SIM_PUK2 = new Error();
            REQUEST_NOT_SUPPORTED = new Error();
            OP_NOT_ALLOWED_DURING_VOICE_CALL = new Error();
            OP_NOT_ALLOWED_BEFORE_REG_NW = new Error();
            SMS_FAIL_RETRY = new Error();
            SIM_ABSENT = new Error();
            SUBSCRIPTION_NOT_AVAILABLE = new Error();
            MODE_NOT_SUPPORTED = new Error();
            FDN_CHECK_FAILURE = new Error();
            ILLEGAL_SIM_OR_ME = new Error();
            Error error = INVALID_RESPONSE;
            Error error2 = RADIO_NOT_AVAILABLE;
            Error error3 = GENERIC_FAILURE;
            Error error4 = PASSWORD_INCORRECT;
            Error error5 = SIM_PIN2;
            Error error6 = SIM_PUK2;
            Error error7 = REQUEST_NOT_SUPPORTED;
            Error error8 = OP_NOT_ALLOWED_DURING_VOICE_CALL;
            Error error9 = OP_NOT_ALLOWED_BEFORE_REG_NW;
            Error error10 = SMS_FAIL_RETRY;
            Error error11 = SIM_ABSENT;
            Error error12 = SUBSCRIPTION_NOT_AVAILABLE;
            Error error13 = MODE_NOT_SUPPORTED;
            Error error14 = FDN_CHECK_FAILURE;
            Error error15 = ILLEGAL_SIM_OR_ME;
            Error[] errorArray = new Error[]{error, error2, error3, error4, error5, error6, error7, error8, error9, error10, error11, error12, error13, error14, error15};
            $VALUES = errorArray;
        }

        public static Error valueOf(String string2) {
            return Enum.valueOf(Error.class, string2);
        }

        public static Error[] values() {
            return (Error[])$VALUES.clone();
        }
    }
}

