/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.UUSInfo;

public abstract class Connection {
    private static String LOG_TAG;
    public static int PRESENTATION_ALLOWED;
    public static int PRESENTATION_PAYPHONE;
    public static int PRESENTATION_RESTRICTED;
    public static int PRESENTATION_UNKNOWN;
    Object userData;

    static {
        PRESENTATION_ALLOWED = 1;
        PRESENTATION_RESTRICTED = 2;
        PRESENTATION_UNKNOWN = 3;
        PRESENTATION_PAYPHONE = 4;
        LOG_TAG = "TelephonyConnection";
    }

    public abstract void cancelPostDial();

    public void clearUserData() {
        this.userData = null;
    }

    public abstract String getAddress();

    public abstract Call getCall();

    public String getCnapName() {
        return null;
    }

    public int getCnapNamePresentation() {
        return 0;
    }

    public abstract long getConnectTime();

    public abstract long getCreateTime();

    public abstract DisconnectCause getDisconnectCause();

    public abstract long getDisconnectTime();

    public abstract long getDurationMillis();

    public abstract long getHoldDurationMillis();

    public abstract int getNumberPresentation();

    public String getOrigDialString() {
        return null;
    }

    public abstract PostDialState getPostDialState();

    public abstract String getRemainingPostDialString();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Call.State getState() {
        Call call = this.getCall();
        if (call != null) return call.getState();
        return Call.State.IDLE;
    }

    public abstract UUSInfo getUUSInfo();

    public Object getUserData() {
        return this.userData;
    }

    public abstract void hangup() throws CallStateException;

    public boolean isAlive() {
        return this.getState().isAlive();
    }

    public abstract boolean isIncoming();

    public boolean isRinging() {
        return this.getState().isRinging();
    }

    public abstract void proceedAfterWaitChar();

    public abstract void proceedAfterWildChar(String var1);

    public abstract void separate() throws CallStateException;

    public void setUserData(Object object) {
        this.userData = object;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        if (Log.isLoggable(LOG_TAG, 3)) {
            StringBuilder stringBuilder2 = new StringBuilder().append("addr: ");
            String string2 = this.getAddress();
            String string3 = stringBuilder2.append(string2).toString();
            StringBuilder stringBuilder3 = stringBuilder.append(string3);
            StringBuilder stringBuilder4 = new StringBuilder().append(" pres.: ");
            int n = this.getNumberPresentation();
            String string4 = stringBuilder4.append(n).toString();
            StringBuilder stringBuilder5 = stringBuilder3.append(string4);
            StringBuilder stringBuilder6 = new StringBuilder().append(" dial: ");
            String string5 = this.getOrigDialString();
            String string6 = stringBuilder6.append(string5).toString();
            StringBuilder stringBuilder7 = stringBuilder5.append(string6);
            StringBuilder stringBuilder8 = new StringBuilder().append(" postdial: ");
            String string7 = this.getRemainingPostDialString();
            String string8 = stringBuilder8.append(string7).toString();
            StringBuilder stringBuilder9 = stringBuilder7.append(string8);
            StringBuilder stringBuilder10 = new StringBuilder().append(" cnap name: ");
            String string9 = this.getCnapName();
            String string10 = stringBuilder10.append(string9).toString();
            StringBuilder stringBuilder11 = stringBuilder9.append(string10);
            StringBuilder stringBuilder12 = new StringBuilder().append("(");
            int n2 = this.getCnapNamePresentation();
            String string11 = stringBuilder12.append(n2).append(")").toString();
            StringBuilder stringBuilder13 = stringBuilder11.append(string11);
        }
        StringBuilder stringBuilder14 = new StringBuilder().append(" incoming: ");
        boolean bl = this.isIncoming();
        String string12 = stringBuilder14.append(bl).toString();
        StringBuilder stringBuilder15 = stringBuilder.append(string12);
        StringBuilder stringBuilder16 = new StringBuilder().append(" state: ");
        Call.State state = this.getState();
        String string13 = stringBuilder16.append((Object)state).toString();
        StringBuilder stringBuilder17 = stringBuilder15.append(string13);
        StringBuilder stringBuilder18 = new StringBuilder().append(" post dial state: ");
        PostDialState postDialState = this.getPostDialState();
        String string14 = stringBuilder18.append((Object)postDialState).toString();
        StringBuilder stringBuilder19 = stringBuilder17.append(string14);
        return stringBuilder.toString();
    }

    public static final class PostDialState
    extends Enum<PostDialState> {
        private static final /* synthetic */ PostDialState[] $VALUES;
        public static final /* enum */ PostDialState CANCELLED;
        public static final /* enum */ PostDialState COMPLETE;
        public static final /* enum */ PostDialState NOT_STARTED;
        public static final /* enum */ PostDialState PAUSE;
        public static final /* enum */ PostDialState STARTED;
        public static final /* enum */ PostDialState WAIT;
        public static final /* enum */ PostDialState WILD;

        static {
            NOT_STARTED = new PostDialState();
            STARTED = new PostDialState();
            WAIT = new PostDialState();
            WILD = new PostDialState();
            COMPLETE = new PostDialState();
            CANCELLED = new PostDialState();
            PAUSE = new PostDialState();
            PostDialState postDialState = NOT_STARTED;
            PostDialState postDialState2 = STARTED;
            PostDialState postDialState3 = WAIT;
            PostDialState postDialState4 = WILD;
            PostDialState postDialState5 = COMPLETE;
            PostDialState postDialState6 = CANCELLED;
            PostDialState postDialState7 = PAUSE;
            PostDialState[] postDialStateArray = new PostDialState[]{postDialState, postDialState2, postDialState3, postDialState4, postDialState5, postDialState6, postDialState7};
            $VALUES = postDialStateArray;
        }

        public static PostDialState valueOf(String string2) {
            return Enum.valueOf(PostDialState.class, string2);
        }

        public static PostDialState[] values() {
            return (PostDialState[])$VALUES.clone();
        }
    }

    public static final class DisconnectCause
    extends Enum<DisconnectCause> {
        private static final /* synthetic */ DisconnectCause[] $VALUES;
        public static final /* enum */ DisconnectCause BUSY;
        public static final /* enum */ DisconnectCause CALL_BARRED;
        public static final /* enum */ DisconnectCause CDMA_ACCESS_BLOCKED;
        public static final /* enum */ DisconnectCause CDMA_ACCESS_FAILURE;
        public static final /* enum */ DisconnectCause CDMA_DROP;
        public static final /* enum */ DisconnectCause CDMA_INTERCEPT;
        public static final /* enum */ DisconnectCause CDMA_LOCKED_UNTIL_POWER_CYCLE;
        public static final /* enum */ DisconnectCause CDMA_NOT_EMERGENCY;
        public static final /* enum */ DisconnectCause CDMA_PREEMPTED;
        public static final /* enum */ DisconnectCause CDMA_REORDER;
        public static final /* enum */ DisconnectCause CDMA_RETRY_ORDER;
        public static final /* enum */ DisconnectCause CDMA_SO_REJECT;
        public static final /* enum */ DisconnectCause CONGESTION;
        public static final /* enum */ DisconnectCause CS_RESTRICTED;
        public static final /* enum */ DisconnectCause CS_RESTRICTED_EMERGENCY;
        public static final /* enum */ DisconnectCause CS_RESTRICTED_NORMAL;
        public static final /* enum */ DisconnectCause ERROR_UNSPECIFIED;
        public static final /* enum */ DisconnectCause FDN_BLOCKED;
        public static final /* enum */ DisconnectCause ICC_ERROR;
        public static final /* enum */ DisconnectCause INCOMING_MISSED;
        public static final /* enum */ DisconnectCause INCOMING_REJECTED;
        public static final /* enum */ DisconnectCause INVALID_CREDENTIALS;
        public static final /* enum */ DisconnectCause INVALID_NUMBER;
        public static final /* enum */ DisconnectCause LIMIT_EXCEEDED;
        public static final /* enum */ DisconnectCause LOCAL;
        public static final /* enum */ DisconnectCause LOST_SIGNAL;
        public static final /* enum */ DisconnectCause MMI;
        public static final /* enum */ DisconnectCause NORMAL;
        public static final /* enum */ DisconnectCause NOT_DISCONNECTED;
        public static final /* enum */ DisconnectCause NUMBER_UNREACHABLE;
        public static final /* enum */ DisconnectCause OUT_OF_NETWORK;
        public static final /* enum */ DisconnectCause OUT_OF_SERVICE;
        public static final /* enum */ DisconnectCause POWER_OFF;
        public static final /* enum */ DisconnectCause SERVER_ERROR;
        public static final /* enum */ DisconnectCause SERVER_UNREACHABLE;
        public static final /* enum */ DisconnectCause TIMED_OUT;
        public static final /* enum */ DisconnectCause UNOBTAINABLE_NUMBER;

        static {
            NOT_DISCONNECTED = new DisconnectCause();
            INCOMING_MISSED = new DisconnectCause();
            NORMAL = new DisconnectCause();
            LOCAL = new DisconnectCause();
            BUSY = new DisconnectCause();
            CONGESTION = new DisconnectCause();
            MMI = new DisconnectCause();
            INVALID_NUMBER = new DisconnectCause();
            NUMBER_UNREACHABLE = new DisconnectCause();
            SERVER_UNREACHABLE = new DisconnectCause();
            INVALID_CREDENTIALS = new DisconnectCause();
            OUT_OF_NETWORK = new DisconnectCause();
            SERVER_ERROR = new DisconnectCause();
            TIMED_OUT = new DisconnectCause();
            LOST_SIGNAL = new DisconnectCause();
            LIMIT_EXCEEDED = new DisconnectCause();
            INCOMING_REJECTED = new DisconnectCause();
            POWER_OFF = new DisconnectCause();
            OUT_OF_SERVICE = new DisconnectCause();
            ICC_ERROR = new DisconnectCause();
            CALL_BARRED = new DisconnectCause();
            FDN_BLOCKED = new DisconnectCause();
            CS_RESTRICTED = new DisconnectCause();
            CS_RESTRICTED_NORMAL = new DisconnectCause();
            CS_RESTRICTED_EMERGENCY = new DisconnectCause();
            UNOBTAINABLE_NUMBER = new DisconnectCause();
            CDMA_LOCKED_UNTIL_POWER_CYCLE = new DisconnectCause();
            CDMA_DROP = new DisconnectCause();
            CDMA_INTERCEPT = new DisconnectCause();
            CDMA_REORDER = new DisconnectCause();
            CDMA_SO_REJECT = new DisconnectCause();
            CDMA_RETRY_ORDER = new DisconnectCause();
            CDMA_ACCESS_FAILURE = new DisconnectCause();
            CDMA_PREEMPTED = new DisconnectCause();
            CDMA_NOT_EMERGENCY = new DisconnectCause();
            CDMA_ACCESS_BLOCKED = new DisconnectCause();
            ERROR_UNSPECIFIED = new DisconnectCause();
            DisconnectCause disconnectCause = NOT_DISCONNECTED;
            DisconnectCause disconnectCause2 = INCOMING_MISSED;
            DisconnectCause disconnectCause3 = NORMAL;
            DisconnectCause disconnectCause4 = LOCAL;
            DisconnectCause disconnectCause5 = BUSY;
            DisconnectCause disconnectCause6 = CONGESTION;
            DisconnectCause disconnectCause7 = MMI;
            DisconnectCause disconnectCause8 = INVALID_NUMBER;
            DisconnectCause disconnectCause9 = NUMBER_UNREACHABLE;
            DisconnectCause disconnectCause10 = SERVER_UNREACHABLE;
            DisconnectCause disconnectCause11 = INVALID_CREDENTIALS;
            DisconnectCause disconnectCause12 = OUT_OF_NETWORK;
            DisconnectCause disconnectCause13 = SERVER_ERROR;
            DisconnectCause disconnectCause14 = TIMED_OUT;
            DisconnectCause disconnectCause15 = LOST_SIGNAL;
            DisconnectCause disconnectCause16 = LIMIT_EXCEEDED;
            DisconnectCause disconnectCause17 = INCOMING_REJECTED;
            DisconnectCause disconnectCause18 = POWER_OFF;
            DisconnectCause disconnectCause19 = OUT_OF_SERVICE;
            DisconnectCause disconnectCause20 = ICC_ERROR;
            DisconnectCause disconnectCause21 = CALL_BARRED;
            DisconnectCause disconnectCause22 = FDN_BLOCKED;
            DisconnectCause disconnectCause23 = CS_RESTRICTED;
            DisconnectCause disconnectCause24 = CS_RESTRICTED_NORMAL;
            DisconnectCause disconnectCause25 = CS_RESTRICTED_EMERGENCY;
            DisconnectCause disconnectCause26 = UNOBTAINABLE_NUMBER;
            DisconnectCause disconnectCause27 = CDMA_LOCKED_UNTIL_POWER_CYCLE;
            DisconnectCause disconnectCause28 = CDMA_DROP;
            DisconnectCause disconnectCause29 = CDMA_INTERCEPT;
            DisconnectCause disconnectCause30 = CDMA_REORDER;
            DisconnectCause disconnectCause31 = CDMA_SO_REJECT;
            DisconnectCause disconnectCause32 = CDMA_RETRY_ORDER;
            DisconnectCause disconnectCause33 = CDMA_ACCESS_FAILURE;
            DisconnectCause disconnectCause34 = CDMA_PREEMPTED;
            DisconnectCause disconnectCause35 = CDMA_NOT_EMERGENCY;
            DisconnectCause disconnectCause36 = CDMA_ACCESS_BLOCKED;
            DisconnectCause disconnectCause37 = ERROR_UNSPECIFIED;
            DisconnectCause[] disconnectCauseArray = new DisconnectCause[]{disconnectCause, disconnectCause2, disconnectCause3, disconnectCause4, disconnectCause5, disconnectCause6, disconnectCause7, disconnectCause8, disconnectCause9, disconnectCause10, disconnectCause11, disconnectCause12, disconnectCause13, disconnectCause14, disconnectCause15, disconnectCause16, disconnectCause17, disconnectCause18, disconnectCause19, disconnectCause20, disconnectCause21, disconnectCause22, disconnectCause23, disconnectCause24, disconnectCause25, disconnectCause26, disconnectCause27, disconnectCause28, disconnectCause29, disconnectCause30, disconnectCause31, disconnectCause32, disconnectCause33, disconnectCause34, disconnectCause35, disconnectCause36, disconnectCause37};
            $VALUES = disconnectCauseArray;
        }

        public static DisconnectCause valueOf(String string2) {
            return Enum.valueOf(DisconnectCause.class, string2);
        }

        public static DisconnectCause[] values() {
            return (DisconnectCause[])$VALUES.clone();
        }
    }
}

