/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Message;
import android.os.SystemProperties;
import android.util.EventLog;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.gsm.ApnSetting;
import com.android.internal.util.HierarchicalState;
import com.android.internal.util.HierarchicalStateMachine;

public abstract class DataConnection
extends HierarchicalStateMachine {
    protected static final boolean DBG = true;
    protected static final int EVENT_CONNECT = 2;
    protected static final int EVENT_DEACTIVATE_DONE = 5;
    protected static final int EVENT_DISCONNECT = 6;
    protected static final int EVENT_GET_LAST_FAIL_DONE = 4;
    protected static final int EVENT_LOG_BAD_DNS_ADDRESS = 50100;
    protected static final int EVENT_RESET = 1;
    protected static final int EVENT_SETUP_DATA_CONNECTION_DONE = 3;
    protected static final String NULL_IP = "0.0.0.0";
    protected static int mCount;
    protected static Object mCountLock;
    protected int cid;
    protected long createTime;
    protected String[] dnsServers;
    protected String gatewayAddress;
    protected String interfaceName;
    protected String ipAddress;
    protected FailCause lastFailCause;
    protected long lastFailTime;
    private DcActivatingState mActivatingState;
    private DcActiveState mActiveState;
    private DcDefaultState mDefaultState;
    private DcDisconnectingBadDnsState mDisconnectingBadDnsState;
    private DcDisconnectingState mDisconnectingState;
    private DcInactiveState mInactiveState;
    protected int mTag;
    protected PhoneBase phone;
    Object userData;

    static {
        mCountLock = new Object();
    }

    protected DataConnection(PhoneBase phoneBase, String string2) {
        super(string2);
        DcDisconnectingBadDnsState dcDisconnectingBadDnsState;
        DcDisconnectingState dcDisconnectingState;
        DcActiveState dcActiveState;
        DcActivatingState dcActivatingState;
        DcInactiveState dcInactiveState;
        DcDefaultState dcDefaultState;
        this.mDefaultState = dcDefaultState = new DcDefaultState();
        this.mInactiveState = dcInactiveState = new DcInactiveState();
        this.mActivatingState = dcActivatingState = new DcActivatingState();
        this.mActiveState = dcActiveState = new DcActiveState();
        this.mDisconnectingState = dcDisconnectingState = new DcDisconnectingState();
        this.mDisconnectingBadDnsState = dcDisconnectingBadDnsState = new DcDisconnectingBadDnsState();
        this.log("DataConnection constructor E");
        this.phone = phoneBase;
        this.cid = -1;
        String[] stringArray = new String[2];
        this.dnsServers = stringArray;
        this.clearSettings();
        this.setDbg(false);
        DcDefaultState dcDefaultState2 = this.mDefaultState;
        this.addState(dcDefaultState2);
        DcInactiveState dcInactiveState2 = this.mInactiveState;
        DcDefaultState dcDefaultState3 = this.mDefaultState;
        this.addState(dcInactiveState2, dcDefaultState3);
        DcActivatingState dcActivatingState2 = this.mActivatingState;
        DcDefaultState dcDefaultState4 = this.mDefaultState;
        this.addState(dcActivatingState2, dcDefaultState4);
        DcActiveState dcActiveState2 = this.mActiveState;
        DcDefaultState dcDefaultState5 = this.mDefaultState;
        this.addState(dcActiveState2, dcDefaultState5);
        DcDisconnectingState dcDisconnectingState2 = this.mDisconnectingState;
        DcDefaultState dcDefaultState6 = this.mDefaultState;
        this.addState(dcDisconnectingState2, dcDefaultState6);
        DcDisconnectingBadDnsState dcDisconnectingBadDnsState2 = this.mDisconnectingBadDnsState;
        DcDefaultState dcDefaultState7 = this.mDefaultState;
        this.addState(dcDisconnectingBadDnsState2, dcDefaultState7);
        DcInactiveState dcInactiveState3 = this.mInactiveState;
        this.setInitialState(dcInactiveState3);
        this.log("DataConnection constructor X");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void notifyConnectCompleted(ConnectionParams connectionParams, FailCause failCause) {
        int n;
        Message message = connectionParams.onCompletedMsg;
        if (message == null) {
            return;
        }
        long l = System.currentTimeMillis();
        message.arg1 = n = this.cid;
        FailCause failCause2 = FailCause.NONE;
        if (failCause == failCause2) {
            this.createTime = l;
            AsyncResult asyncResult = AsyncResult.forMessage(message);
        } else {
            this.lastFailCause = failCause;
            this.lastFailTime = l;
            Exception exception = new Exception();
            AsyncResult asyncResult = AsyncResult.forMessage(message, (Object)failCause, exception);
        }
        String string2 = "notifyConnection at " + l + " cause=" + (Object)((Object)failCause);
        this.log(string2);
        message.sendToTarget();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void notifyDisconnectCompleted(DisconnectParams disconnectParams) {
        this.log("NotifyDisconnectCompleted");
        if (disconnectParams.onCompletedMsg != null) {
            Message message = disconnectParams.onCompletedMsg;
            String string2 = "msg.what=%d msg.obj=%s";
            Object[] objectArray = new Object[2];
            Integer n = message.what;
            objectArray[0] = n;
            int n2 = 1;
            String string3 = message.obj instanceof String ? (String)message.obj : "<no-reason>";
            objectArray[n2] = string3;
            String string4 = String.format(string2, objectArray);
            this.log(string4);
            AsyncResult asyncResult = AsyncResult.forMessage(message);
            message.sendToTarget();
        }
        if (disconnectParams.lockObj != null) {
            ResetSynchronouslyLock resetSynchronouslyLock = disconnectParams.lockObj;
            synchronized (resetSynchronouslyLock) {
                disconnectParams.lockObj.notify();
            }
        }
        this.clearSettings();
    }

    /*
     * Enabled aggressive block sorting
     */
    private SetupResult onSetupConnectionCompleted(AsyncResult asyncResult) {
        SetupResult setupResult;
        String[] stringArray = (String[])asyncResult.result;
        ConnectionParams connectionParams = (ConnectionParams)asyncResult.userObj;
        if (asyncResult.exception != null) {
            CommandException.Error error;
            CommandException.Error error2;
            StringBuilder stringBuilder = new StringBuilder().append("DataConnection Init failed ");
            Throwable throwable = asyncResult.exception;
            String string2 = stringBuilder.append(throwable).toString();
            this.log(string2);
            if (asyncResult.exception instanceof CommandException && (error2 = ((CommandException)asyncResult.exception).getCommandError()) == (error = CommandException.Error.RADIO_NOT_AVAILABLE)) {
                FailCause failCause;
                setupResult = SetupResult.ERR_BadCommand;
                setupResult.mFailCause = failCause = FailCause.RADIO_NOT_AVAILABLE;
            } else {
                setupResult = SetupResult.ERR_Other;
            }
        } else {
            int n = connectionParams.tag;
            int n2 = this.mTag;
            if (n != n2) {
                StringBuilder stringBuilder = new StringBuilder().append("BUG: onSetupConnectionCompleted is stale cp.tag=");
                int n3 = connectionParams.tag;
                StringBuilder stringBuilder2 = stringBuilder.append(n3).append(", mtag=");
                int n4 = this.mTag;
                String string3 = stringBuilder2.append(n4).toString();
                this.log(string3);
                setupResult = SetupResult.ERR_Stale;
            } else if (stringArray.length >= 2) {
                String string4;
                int n5;
                this.cid = n5 = Integer.parseInt(stringArray[0]);
                this.interfaceName = string4 = stringArray[1];
                if (stringArray.length > 2) {
                    String string5;
                    String string6;
                    String string7;
                    String string8;
                    this.ipAddress = string8 = stringArray[2];
                    StringBuilder stringBuilder = new StringBuilder().append("net.");
                    String string9 = this.interfaceName;
                    String string10 = stringBuilder.append(string9).append(".").toString();
                    this.gatewayAddress = string7 = SystemProperties.get(string10 + "gw");
                    String[] stringArray2 = this.dnsServers;
                    stringArray2[0] = string6 = SystemProperties.get(string10 + "dns1");
                    String[] stringArray3 = this.dnsServers;
                    stringArray3[1] = string5 = SystemProperties.get(string10 + "dns2");
                    StringBuilder stringBuilder3 = new StringBuilder().append("interface=");
                    String string11 = this.interfaceName;
                    StringBuilder stringBuilder4 = stringBuilder3.append(string11).append(" ipAddress=");
                    String string12 = this.ipAddress;
                    StringBuilder stringBuilder5 = stringBuilder4.append(string12).append(" gateway=");
                    String string13 = this.gatewayAddress;
                    StringBuilder stringBuilder6 = stringBuilder5.append(string13).append(" DNS1=");
                    String string14 = this.dnsServers[0];
                    StringBuilder stringBuilder7 = stringBuilder6.append(string14).append(" DNS2=");
                    String string15 = this.dnsServers[1];
                    String string16 = stringBuilder7.append(string15).toString();
                    this.log(string16);
                    String[] stringArray4 = this.dnsServers;
                    setupResult = this.isDnsOk(stringArray4) ? SetupResult.SUCCESS : SetupResult.ERR_BadDns;
                } else {
                    setupResult = SetupResult.SUCCESS;
                }
            } else {
                setupResult = SetupResult.ERR_Other;
            }
        }
        StringBuilder stringBuilder = new StringBuilder().append("DataConnection setup result='").append((Object)setupResult).append("' on cid=");
        int n = this.cid;
        String string17 = stringBuilder.append(n).toString();
        this.log(string17);
        return setupResult;
    }

    private void tearDownData(Object object) {
        if (this.phone.mCM.getRadioState().isOn()) {
            this.log("tearDownData radio is on, call deactivateDataCall");
            CommandsInterface commandsInterface = this.phone.mCM;
            int n = this.cid;
            Message message = this.obtainMessage(5, object);
            commandsInterface.deactivateDataCall(n, message);
            return;
        }
        this.log("tearDownData radio is off sendMessage EVENT_DEACTIVATE_DONE immediately");
        AsyncResult asyncResult = new AsyncResult(object, null, null);
        Message message = this.obtainMessage(5, asyncResult);
        this.sendMessage(message);
    }

    protected void clearSettings() {
        FailCause failCause;
        this.log("clearSettings");
        this.createTime = 65535L;
        this.lastFailTime = 65535L;
        this.lastFailCause = failCause = FailCause.NONE;
        this.interfaceName = null;
        this.ipAddress = null;
        this.gatewayAddress = null;
        this.dnsServers[0] = null;
        this.dnsServers[1] = null;
    }

    public void connect(Message message) {
        ConnectionParams connectionParams = new ConnectionParams(null, message);
        Message message2 = this.obtainMessage(2, connectionParams);
        this.sendMessage(message2);
    }

    public void connect(Message message, ApnSetting apnSetting) {
        ConnectionParams connectionParams = new ConnectionParams(apnSetting, message);
        Message message2 = this.obtainMessage(2, connectionParams);
        this.sendMessage(message2);
    }

    public void disconnect(Message message) {
        DisconnectParams disconnectParams = new DisconnectParams(message);
        Message message2 = this.obtainMessage(6, disconnectParams);
        this.sendMessage(message2);
    }

    public long getConnectionTime() {
        return this.createTime;
    }

    public String[] getDnsServers() {
        return this.dnsServers;
    }

    protected abstract FailCause getFailCauseFromRequest(int var1);

    public String getGatewayAddress() {
        return this.gatewayAddress;
    }

    public String getInterface() {
        return this.interfaceName;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public FailCause getLastFailCause() {
        return this.lastFailCause;
    }

    public long getLastFailTime() {
        return this.lastFailTime;
    }

    public String getStateAsString() {
        return this.getCurrentState().getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isActive() {
        DcActiveState dcActiveState;
        HierarchicalState hierarchicalState = this.getCurrentState();
        if (hierarchicalState != (dcActiveState = this.mActiveState)) return false;
        return true;
    }

    protected abstract boolean isDnsOk(String[] var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isInactive() {
        DcInactiveState dcInactiveState;
        HierarchicalState hierarchicalState = this.getCurrentState();
        if (hierarchicalState != (dcInactiveState = this.mInactiveState)) return false;
        return true;
    }

    protected abstract void log(String var1);

    protected abstract void onConnect(ConnectionParams var1);

    public void reset(Message message) {
        DisconnectParams disconnectParams = new DisconnectParams(message);
        Message message2 = this.obtainMessage(1, disconnectParams);
        this.sendMessage(message2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resetSynchronously() {
        ResetSynchronouslyLock resetSynchronouslyLock = new ResetSynchronouslyLock();
        synchronized (resetSynchronouslyLock) {
            DisconnectParams disconnectParams = new DisconnectParams(resetSynchronouslyLock);
            Message message = this.obtainMessage(1, disconnectParams);
            this.sendMessage(message);
            try {
                resetSynchronouslyLock.wait();
            }
            catch (InterruptedException interruptedException) {
                this.log("blockingReset: unexpected interrupted of wait()");
            }
            return;
        }
    }

    public abstract String toString();

    private class DcDisconnectingBadDnsState
    extends HierarchicalState {
        private DcDisconnectingBadDnsState() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean processMessage(Message message) {
            switch (message.what) {
                default: {
                    DataConnection dataConnection = DataConnection.this;
                    StringBuilder stringBuilder = new StringBuilder().append("DcDisconnectingBadDnsState not handled msg.what=");
                    int n = message.what;
                    String string2 = stringBuilder.append(n).toString();
                    dataConnection.log(string2);
                    return false;
                }
                case 5: 
            }
            ConnectionParams connectionParams = (ConnectionParams)((AsyncResult)message.obj).userObj;
            int n = connectionParams.tag;
            int n2 = DataConnection.this.mTag;
            if (n != n2) {
                DataConnection.this.log("DcDisconnectingBadDnsState msg.what=EVENT_DEACTIVATE_DONE");
                DcInactiveState dcInactiveState = DataConnection.this.mInactiveState;
                FailCause failCause = FailCause.UNKNOWN;
                dcInactiveState.setEnterNotificationParams(connectionParams, failCause);
                DataConnection dataConnection = DataConnection.this;
                DcInactiveState dcInactiveState2 = DataConnection.this.mInactiveState;
                dataConnection.transitionTo(dcInactiveState2);
                return true;
            }
            DataConnection dataConnection = DataConnection.this;
            StringBuilder stringBuilder = new StringBuilder().append("DcDisconnectingBadDnsState EVENT_DEACTIVE_DONE stale dp.tag=");
            int n3 = connectionParams.tag;
            StringBuilder stringBuilder2 = stringBuilder.append(n3).append(", mTag=");
            int n4 = DataConnection.this.mTag;
            String string3 = stringBuilder2.append(n4).toString();
            dataConnection.log(string3);
            return true;
        }
    }

    private class DcDisconnectingState
    extends HierarchicalState {
        private DcDisconnectingState() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean processMessage(Message message) {
            switch (message.what) {
                default: {
                    DataConnection dataConnection = DataConnection.this;
                    StringBuilder stringBuilder = new StringBuilder().append("DcDisconnectingState not handled msg.what=");
                    int n = message.what;
                    String string2 = stringBuilder.append(n).toString();
                    dataConnection.log(string2);
                    return false;
                }
                case 5: 
            }
            DataConnection.this.log("DcDisconnectingState msg.what=EVENT_DEACTIVATE_DONE");
            AsyncResult asyncResult = (AsyncResult)message.obj;
            DisconnectParams disconnectParams = (DisconnectParams)asyncResult.userObj;
            int n = disconnectParams.tag;
            int n2 = DataConnection.this.mTag;
            if (n != n2) {
                DcInactiveState dcInactiveState = DataConnection.this.mInactiveState;
                DisconnectParams disconnectParams2 = (DisconnectParams)asyncResult.userObj;
                dcInactiveState.setEnterNotificationParams(disconnectParams2);
                DataConnection dataConnection = DataConnection.this;
                DcInactiveState dcInactiveState2 = DataConnection.this.mInactiveState;
                dataConnection.transitionTo(dcInactiveState2);
                return true;
            }
            DataConnection dataConnection = DataConnection.this;
            StringBuilder stringBuilder = new StringBuilder().append("DcDisconnectState EVENT_DEACTIVATE_DONE stale dp.tag=");
            int n3 = disconnectParams.tag;
            StringBuilder stringBuilder2 = stringBuilder.append(n3).append(" mTag=");
            int n4 = DataConnection.this.mTag;
            String string3 = stringBuilder2.append(n4).toString();
            dataConnection.log(string3);
            return true;
        }
    }

    private class DcActiveState
    extends HierarchicalState {
        private ConnectionParams mConnectionParams = null;
        private FailCause mFailCause = null;

        private DcActiveState() {
        }

        @Override
        public void enter() {
            if (this.mConnectionParams == null) {
                return;
            }
            if (this.mFailCause == null) {
                return;
            }
            DataConnection.this.log("DcActiveState: enter notifyConnectCompleted");
            DataConnection dataConnection = DataConnection.this;
            ConnectionParams connectionParams = this.mConnectionParams;
            FailCause failCause = this.mFailCause;
            dataConnection.notifyConnectCompleted(connectionParams, failCause);
        }

        @Override
        protected void exit() {
            this.mConnectionParams = null;
            this.mFailCause = null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean processMessage(Message message) {
            int n;
            switch (message.what) {
                default: {
                    DataConnection dataConnection = DataConnection.this;
                    StringBuilder stringBuilder = new StringBuilder().append("DcActiveState nothandled msg.what=");
                    int n2 = message.what;
                    String string2 = stringBuilder.append(n2).toString();
                    dataConnection.log(string2);
                    return false;
                }
                case 6: 
            }
            DataConnection.this.log("DcActiveState msg.what=EVENT_DISCONNECT");
            DisconnectParams disconnectParams = (DisconnectParams)message.obj;
            disconnectParams.tag = n = DataConnection.this.mTag;
            DataConnection.this.tearDownData(disconnectParams);
            DataConnection dataConnection = DataConnection.this;
            DcDisconnectingState dcDisconnectingState = DataConnection.this.mDisconnectingState;
            dataConnection.transitionTo(dcDisconnectingState);
            return true;
        }

        public void setEnterNotificationParams(ConnectionParams connectionParams, FailCause failCause) {
            DataConnection.this.log("DcInactiveState: setEnterNoticationParams cp,cause");
            this.mConnectionParams = connectionParams;
            this.mFailCause = failCause;
        }
    }

    private class DcActivatingState
    extends HierarchicalState {
        private DcActivatingState() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected boolean processMessage(Message message) {
            switch (message.what) {
                default: {
                    DataConnection dataConnection = DataConnection.this;
                    StringBuilder stringBuilder = new StringBuilder().append("DcActivatingState not handled msg.what=");
                    int n = message.what;
                    String string2 = stringBuilder.append(n).toString();
                    dataConnection.log(string2);
                    return false;
                }
                case 6: {
                    DataConnection.this.log("DcActivatingState deferring msg.what=EVENT_DISCONNECT");
                    DataConnection.this.deferMessage(message);
                    return true;
                }
                case 3: {
                    DataConnection.this.log("DcActivatingState msg.what=EVENT_SETUP_DATA_CONNECTION_DONE");
                    AsyncResult asyncResult = (AsyncResult)message.obj;
                    ConnectionParams connectionParams = (ConnectionParams)asyncResult.userObj;
                    SetupResult setupResult = DataConnection.this.onSetupConnectionCompleted(asyncResult);
                    int[] nArray = 1.$SwitchMap$com$android$internal$telephony$DataConnection$SetupResult;
                    int n = setupResult.ordinal();
                    switch (nArray[n]) {
                        default: {
                            throw new RuntimeException("Unkown SetupResult, should not happen");
                        }
                        case 5: {
                            DcActiveState dcActiveState = DataConnection.this.mActiveState;
                            FailCause failCause = FailCause.NONE;
                            dcActiveState.setEnterNotificationParams(connectionParams, failCause);
                            DataConnection dataConnection = DataConnection.this;
                            DcActiveState dcActiveState2 = DataConnection.this.mActiveState;
                            dataConnection.transitionTo(dcActiveState2);
                            return true;
                        }
                        case 1: {
                            DcInactiveState dcInactiveState = DataConnection.this.mInactiveState;
                            FailCause failCause = setupResult.mFailCause;
                            dcInactiveState.setEnterNotificationParams(connectionParams, failCause);
                            DataConnection dataConnection = DataConnection.this;
                            DcInactiveState dcInactiveState2 = DataConnection.this.mInactiveState;
                            dataConnection.transitionTo(dcInactiveState2);
                            return true;
                        }
                        case 2: {
                            String string3 = DataConnection.this.dnsServers[0];
                            int n2 = EventLog.writeEvent(50100, string3);
                            DataConnection.this.tearDownData(connectionParams);
                            DataConnection dataConnection = DataConnection.this;
                            DcDisconnectingBadDnsState dcDisconnectingBadDnsState = DataConnection.this.mDisconnectingBadDnsState;
                            dataConnection.transitionTo(dcDisconnectingBadDnsState);
                        }
                        case 4: {
                            return true;
                        }
                        case 3: {
                            CommandsInterface commandsInterface = DataConnection.this.phone.mCM;
                            Message message2 = DataConnection.this.obtainMessage(4, connectionParams);
                            commandsInterface.getLastDataCallFailCause(message2);
                        }
                    }
                    return true;
                }
                case 4: 
            }
            AsyncResult asyncResult = (AsyncResult)message.obj;
            ConnectionParams connectionParams = (ConnectionParams)asyncResult.userObj;
            FailCause failCause = FailCause.UNKNOWN;
            int n = connectionParams.tag;
            int n3 = DataConnection.this.mTag;
            if (n != n3) {
                DataConnection.this.log("DcActivatingState msg.what=EVENT_GET_LAST_FAIL_DONE");
                if (asyncResult.exception == null) {
                    int n4 = ((int[])asyncResult.result)[0];
                    failCause = DataConnection.this.getFailCauseFromRequest(n4);
                }
                DataConnection.this.mInactiveState.setEnterNotificationParams(connectionParams, failCause);
                DataConnection dataConnection = DataConnection.this;
                DcInactiveState dcInactiveState = DataConnection.this.mInactiveState;
                dataConnection.transitionTo(dcInactiveState);
                return true;
            } else {
                DataConnection dataConnection = DataConnection.this;
                StringBuilder stringBuilder = new StringBuilder().append("DcActivatingState EVENT_GET_LAST_FAIL_DONE is stale cp.tag=");
                int n5 = connectionParams.tag;
                StringBuilder stringBuilder2 = stringBuilder.append(n5).append(", mTag=");
                int n6 = DataConnection.this.mTag;
                String string4 = stringBuilder2.append(n6).toString();
                dataConnection.log(string4);
            }
            return true;
        }
    }

    private class DcInactiveState
    extends HierarchicalState {
        private ConnectionParams mConnectionParams = null;
        private DisconnectParams mDisconnectParams = null;
        private FailCause mFailCause = null;

        private DcInactiveState() {
        }

        @Override
        protected void enter() {
            int n;
            DataConnection dataConnection = DataConnection.this;
            dataConnection.mTag = n = dataConnection.mTag + 1;
            if (this.mConnectionParams != null && this.mFailCause != null) {
                DataConnection.this.log("DcInactiveState: enter notifyConnectCompleted");
                DataConnection dataConnection2 = DataConnection.this;
                ConnectionParams connectionParams = this.mConnectionParams;
                FailCause failCause = this.mFailCause;
                dataConnection2.notifyConnectCompleted(connectionParams, failCause);
            }
            if (this.mDisconnectParams == null) {
                return;
            }
            DataConnection.this.log("DcInactiveState: enter notifyDisconnectCompleted");
            DataConnection dataConnection3 = DataConnection.this;
            DisconnectParams disconnectParams = this.mDisconnectParams;
            dataConnection3.notifyDisconnectCompleted(disconnectParams);
        }

        @Override
        protected void exit() {
            this.mConnectionParams = null;
            this.mFailCause = null;
            this.mDisconnectParams = null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean processMessage(Message message) {
            int n;
            switch (message.what) {
                default: {
                    DataConnection dataConnection = DataConnection.this;
                    StringBuilder stringBuilder = new StringBuilder().append("DcInactiveState nothandled msg.what=");
                    int n2 = message.what;
                    String string2 = stringBuilder.append(n2).toString();
                    dataConnection.log(string2);
                    return false;
                }
                case 1: {
                    DataConnection.this.log("DcInactiveState: msg.what=EVENT_RESET, ignore we're already reset");
                    if (message.obj == null) return true;
                    DataConnection dataConnection = DataConnection.this;
                    DisconnectParams disconnectParams = (DisconnectParams)message.obj;
                    dataConnection.notifyDisconnectCompleted(disconnectParams);
                    return true;
                }
                case 2: 
            }
            DataConnection.this.log("DcInactiveState msg.what=EVENT_CONNECT");
            ConnectionParams connectionParams = (ConnectionParams)message.obj;
            connectionParams.tag = n = DataConnection.this.mTag;
            DataConnection.this.onConnect(connectionParams);
            DataConnection dataConnection = DataConnection.this;
            DcActivatingState dcActivatingState = DataConnection.this.mActivatingState;
            dataConnection.transitionTo(dcActivatingState);
            return true;
        }

        public void setEnterNotificationParams(ConnectionParams connectionParams, FailCause failCause) {
            DataConnection.this.log("DcInactiveState: setEnterNoticationParams cp,cause");
            this.mConnectionParams = connectionParams;
            this.mFailCause = failCause;
        }

        public void setEnterNotificationParams(DisconnectParams disconnectParams) {
            DataConnection.this.log("DcInactiveState: setEnterNoticationParams dp");
            this.mDisconnectParams = disconnectParams;
        }
    }

    private class DcDefaultState
    extends HierarchicalState {
        private DcDefaultState() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean processMessage(Message message) {
            switch (message.what) {
                default: {
                    DataConnection dataConnection = DataConnection.this;
                    StringBuilder stringBuilder = new StringBuilder().append("DcDefaultState: shouldn't happen but ignore msg.what=");
                    int n = message.what;
                    String string2 = stringBuilder.append(n).toString();
                    dataConnection.log(string2);
                    return true;
                }
                case 1: {
                    DataConnection.this.log("DcDefaultState: msg.what=EVENT_RESET");
                    DataConnection.this.clearSettings();
                    if (message.obj != null) {
                        DataConnection dataConnection = DataConnection.this;
                        DisconnectParams disconnectParams = (DisconnectParams)message.obj;
                        dataConnection.notifyDisconnectCompleted(disconnectParams);
                    }
                    DataConnection dataConnection = DataConnection.this;
                    DcInactiveState dcInactiveState = DataConnection.this.mInactiveState;
                    dataConnection.transitionTo(dcInactiveState);
                    return true;
                }
                case 2: {
                    DataConnection.this.log("DcDefaultState: msg.what=EVENT_CONNECT, fail not expected");
                    ConnectionParams connectionParams = (ConnectionParams)message.obj;
                    DataConnection dataConnection = DataConnection.this;
                    FailCause failCause = FailCause.UNKNOWN;
                    dataConnection.notifyConnectCompleted(connectionParams, failCause);
                    return true;
                }
                case 6: 
            }
            DataConnection.this.log("DcDefaultState: msg.what=EVENT_DISCONNECT");
            DataConnection dataConnection = DataConnection.this;
            DisconnectParams disconnectParams = (DisconnectParams)message.obj;
            dataConnection.notifyDisconnectCompleted(disconnectParams);
            return true;
        }
    }

    public static final class FailCause
    extends Enum<FailCause> {
        private static final /* synthetic */ FailCause[] $VALUES;
        public static final /* enum */ FailCause ACTIVATION_REJECT_GGSN;
        public static final /* enum */ FailCause ACTIVATION_REJECT_UNSPECIFIED;
        public static final /* enum */ FailCause GPRS_REGISTRATION_FAIL;
        public static final /* enum */ FailCause INSUFFICIENT_RESOURCES;
        public static final /* enum */ FailCause MISSING_UNKNOWN_APN;
        public static final /* enum */ FailCause NONE;
        public static final /* enum */ FailCause NSAPI_IN_USE;
        public static final /* enum */ FailCause OPERATOR_BARRED;
        public static final /* enum */ FailCause PROTOCOL_ERRORS;
        public static final /* enum */ FailCause RADIO_NOT_AVAILABLE;
        public static final /* enum */ FailCause REGISTRATION_FAIL;
        public static final /* enum */ FailCause SERVICE_OPTION_NOT_SUBSCRIBED;
        public static final /* enum */ FailCause SERVICE_OPTION_NOT_SUPPORTED;
        public static final /* enum */ FailCause SERVICE_OPTION_OUT_OF_ORDER;
        public static final /* enum */ FailCause UNKNOWN;
        public static final /* enum */ FailCause UNKNOWN_PDP_ADDRESS;
        public static final /* enum */ FailCause USER_AUTHENTICATION;

        static {
            NONE = new FailCause();
            OPERATOR_BARRED = new FailCause();
            INSUFFICIENT_RESOURCES = new FailCause();
            MISSING_UNKNOWN_APN = new FailCause();
            UNKNOWN_PDP_ADDRESS = new FailCause();
            USER_AUTHENTICATION = new FailCause();
            ACTIVATION_REJECT_GGSN = new FailCause();
            ACTIVATION_REJECT_UNSPECIFIED = new FailCause();
            SERVICE_OPTION_NOT_SUPPORTED = new FailCause();
            SERVICE_OPTION_NOT_SUBSCRIBED = new FailCause();
            SERVICE_OPTION_OUT_OF_ORDER = new FailCause();
            NSAPI_IN_USE = new FailCause();
            PROTOCOL_ERRORS = new FailCause();
            REGISTRATION_FAIL = new FailCause();
            GPRS_REGISTRATION_FAIL = new FailCause();
            UNKNOWN = new FailCause();
            RADIO_NOT_AVAILABLE = new FailCause();
            FailCause failCause = NONE;
            FailCause failCause2 = OPERATOR_BARRED;
            FailCause failCause3 = INSUFFICIENT_RESOURCES;
            FailCause failCause4 = MISSING_UNKNOWN_APN;
            FailCause failCause5 = UNKNOWN_PDP_ADDRESS;
            FailCause failCause6 = USER_AUTHENTICATION;
            FailCause failCause7 = ACTIVATION_REJECT_GGSN;
            FailCause failCause8 = ACTIVATION_REJECT_UNSPECIFIED;
            FailCause failCause9 = SERVICE_OPTION_NOT_SUPPORTED;
            FailCause failCause10 = SERVICE_OPTION_NOT_SUBSCRIBED;
            FailCause failCause11 = SERVICE_OPTION_OUT_OF_ORDER;
            FailCause failCause12 = NSAPI_IN_USE;
            FailCause failCause13 = PROTOCOL_ERRORS;
            FailCause failCause14 = REGISTRATION_FAIL;
            FailCause failCause15 = GPRS_REGISTRATION_FAIL;
            FailCause failCause16 = UNKNOWN;
            FailCause failCause17 = RADIO_NOT_AVAILABLE;
            FailCause[] failCauseArray = new FailCause[]{failCause, failCause2, failCause3, failCause4, failCause5, failCause6, failCause7, failCause8, failCause9, failCause10, failCause11, failCause12, failCause13, failCause14, failCause15, failCause16, failCause17};
            $VALUES = failCauseArray;
        }

        public static FailCause valueOf(String string2) {
            return Enum.valueOf(FailCause.class, string2);
        }

        public static FailCause[] values() {
            return (FailCause[])$VALUES.clone();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isEventLoggable() {
            FailCause failCause = OPERATOR_BARRED;
            if (this == failCause) return true;
            FailCause failCause2 = INSUFFICIENT_RESOURCES;
            if (this == failCause2) return true;
            FailCause failCause3 = UNKNOWN_PDP_ADDRESS;
            if (this == failCause3) return true;
            FailCause failCause4 = USER_AUTHENTICATION;
            if (this == failCause4) return true;
            FailCause failCause5 = ACTIVATION_REJECT_GGSN;
            if (this == failCause5) return true;
            FailCause failCause6 = ACTIVATION_REJECT_UNSPECIFIED;
            if (this == failCause6) return true;
            FailCause failCause7 = SERVICE_OPTION_NOT_SUBSCRIBED;
            if (this == failCause7) return true;
            FailCause failCause8 = SERVICE_OPTION_NOT_SUPPORTED;
            if (this == failCause8) return true;
            FailCause failCause9 = SERVICE_OPTION_OUT_OF_ORDER;
            if (this == failCause9) return true;
            FailCause failCause10 = NSAPI_IN_USE;
            if (this == failCause10) return true;
            FailCause failCause11 = PROTOCOL_ERRORS;
            if (this != failCause11) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isPermanentFail() {
            FailCause failCause = OPERATOR_BARRED;
            if (this == failCause) return true;
            FailCause failCause2 = MISSING_UNKNOWN_APN;
            if (this == failCause2) return true;
            FailCause failCause3 = UNKNOWN_PDP_ADDRESS;
            if (this == failCause3) return true;
            FailCause failCause4 = USER_AUTHENTICATION;
            if (this == failCause4) return true;
            FailCause failCause5 = ACTIVATION_REJECT_GGSN;
            if (this == failCause5) return true;
            FailCause failCause6 = ACTIVATION_REJECT_UNSPECIFIED;
            if (this == failCause6) return true;
            FailCause failCause7 = SERVICE_OPTION_NOT_SUPPORTED;
            if (this == failCause7) return true;
            FailCause failCause8 = SERVICE_OPTION_NOT_SUBSCRIBED;
            if (this == failCause8) return true;
            FailCause failCause9 = NSAPI_IN_USE;
            if (this == failCause9) return true;
            FailCause failCause10 = PROTOCOL_ERRORS;
            if (this != failCause10) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String toString() {
            int[] nArray = 1.$SwitchMap$com$android$internal$telephony$DataConnection$FailCause;
            int n = this.ordinal();
            switch (nArray[n]) {
                default: {
                    return "Unknown Data Error";
                }
                case 1: {
                    return "No Error";
                }
                case 2: {
                    return "Operator Barred";
                }
                case 3: {
                    return "Insufficient Resources";
                }
                case 4: {
                    return "Missing / Unknown APN";
                }
                case 5: {
                    return "Unknown PDP Address";
                }
                case 6: {
                    return "Error User Authentication";
                }
                case 7: {
                    return "Activation Reject GGSN";
                }
                case 8: {
                    return "Activation Reject unspecified";
                }
                case 9: {
                    return "Data Not Supported";
                }
                case 10: {
                    return "Data Not subscribed";
                }
                case 11: {
                    return "Data Services Out of Order";
                }
                case 12: {
                    return "NSAPI in use";
                }
                case 13: {
                    return "Protocol Errors";
                }
                case 14: {
                    return "Network Registration Failure";
                }
                case 15: {
                    return "Data Network Registration Failure";
                }
                case 16: 
            }
            return "Radio Not Available";
        }
    }

    protected static class DisconnectParams {
        public ResetSynchronouslyLock lockObj;
        public Message onCompletedMsg;
        public int tag;

        public DisconnectParams(Message message) {
            this.onCompletedMsg = message;
        }

        public DisconnectParams(ResetSynchronouslyLock resetSynchronouslyLock) {
            this.lockObj = resetSynchronouslyLock;
        }
    }

    class ResetSynchronouslyLock {
        ResetSynchronouslyLock() {
        }
    }

    protected static class ConnectionParams {
        public ApnSetting apn;
        public Message onCompletedMsg;
        public int tag;

        public ConnectionParams(ApnSetting apnSetting, Message message) {
            this.apn = apnSetting;
            this.onCompletedMsg = message;
        }
    }

    protected static final class SetupResult
    extends Enum<SetupResult> {
        private static final /* synthetic */ SetupResult[] $VALUES;
        public static final /* enum */ SetupResult ERR_BadCommand = new SetupResult();
        public static final /* enum */ SetupResult ERR_BadDns = new SetupResult();
        public static final /* enum */ SetupResult ERR_Other = new SetupResult();
        public static final /* enum */ SetupResult ERR_Stale = new SetupResult();
        public static final /* enum */ SetupResult SUCCESS = new SetupResult();
        public FailCause mFailCause;

        static {
            SetupResult setupResult = ERR_BadCommand;
            SetupResult setupResult2 = ERR_BadDns;
            SetupResult setupResult3 = ERR_Other;
            SetupResult setupResult4 = ERR_Stale;
            SetupResult setupResult5 = SUCCESS;
            SetupResult[] setupResultArray = new SetupResult[]{setupResult, setupResult2, setupResult3, setupResult4, setupResult5};
            $VALUES = setupResultArray;
        }

        public static SetupResult valueOf(String string2) {
            return Enum.valueOf(SetupResult.class, string2);
        }

        public static SetupResult[] values() {
            return (SetupResult[])$VALUES.clone();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String toString() {
            int[] nArray = 1.$SwitchMap$com$android$internal$telephony$DataConnection$SetupResult;
            int n = this.ordinal();
            switch (nArray[n]) {
                default: {
                    return "unknown";
                }
                case 1: {
                    return "Bad Command";
                }
                case 2: {
                    return "Bad DNS";
                }
                case 3: {
                    return "Other error";
                }
                case 4: {
                    return "Stale command";
                }
                case 5: 
            }
            return "SUCCESS";
        }
    }
}

