/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.PendingIntent;
import android.content.ContentResolver;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.RetryManager;
import java.util.ArrayList;

public abstract class DataConnectionTracker
extends Handler {
    protected static final int APN_DEFAULT_ID = 0;
    protected static final int APN_DUN_ID = 3;
    protected static final int APN_HIPRI_ID = 4;
    protected static final int APN_INVALID_ID = 255;
    protected static final int APN_MMS_ID = 1;
    protected static final int APN_NUM_TYPES = 5;
    protected static final String APN_RESTORE_DELAY_PROP_NAME = "android.telephony.apn-restore";
    protected static final int APN_SUPL_ID = 2;
    protected static final boolean DBG = false;
    protected static final String DEFAULT_DATA_RETRY_CONFIG = "default_randomization=2000,5000,10000,20000,40000,80000:5000,160000:5000,320000:5000,640000:5000,1280000:5000,1800000:5000";
    protected static final int DEFAULT_MAX_PDP_RESET_FAIL = 3;
    protected static final int DEFAULT_PING_DEADLINE = 5;
    protected static final int DISABLED = 0;
    protected static final int ENABLED = 1;
    protected static final int EVENT_APN_CHANGED = 29;
    protected static final int EVENT_CDMA_DATA_DETACHED = 30;
    protected static final int EVENT_CDMA_OTA_PROVISION = 35;
    public static final int EVENT_CLEAN_UP_CONNECTION = 34;
    protected static final int EVENT_DATA_SETUP_COMPLETE = 1;
    protected static final int EVENT_DATA_STATE_CHANGED = 6;
    protected static final int EVENT_DISCONNECT_DONE = 25;
    protected static final int EVENT_ENABLE_NEW_APN = 23;
    protected static final int EVENT_GET_PDP_LIST_COMPLETE = 11;
    protected static final int EVENT_GPRS_ATTACHED = 26;
    protected static final int EVENT_GPRS_DETACHED = 19;
    protected static final int EVENT_LINK_STATE_CHANGED = 20;
    protected static final int EVENT_NV_READY = 31;
    protected static final int EVENT_POLL_PDP = 7;
    protected static final int EVENT_PS_RESTRICT_DISABLED = 33;
    protected static final int EVENT_PS_RESTRICT_ENABLED = 32;
    protected static final int EVENT_RADIO_AVAILABLE = 3;
    protected static final int EVENT_RADIO_OFF_OR_NOT_AVAILABLE = 12;
    protected static final int EVENT_RECORDS_LOADED = 4;
    protected static final int EVENT_RESET_DONE = 38;
    protected static final int EVENT_RESTART_RADIO = 36;
    protected static final int EVENT_RESTORE_DEFAULT_APN = 24;
    protected static final int EVENT_ROAMING_OFF = 22;
    protected static final int EVENT_ROAMING_ON = 21;
    protected static final int EVENT_SET_MASTER_DATA_ENABLE = 37;
    protected static final int EVENT_START_NETSTAT_POLL = 27;
    protected static final int EVENT_START_RECOVERY = 28;
    protected static final int EVENT_TRY_SETUP_DATA = 5;
    protected static final int EVENT_VOICE_CALL_ENDED = 15;
    protected static final int EVENT_VOICE_CALL_STARTED = 14;
    protected static final int NO_RECV_POLL_LIMIT = 24;
    protected static final String NULL_IP = "0.0.0.0";
    protected static final int NUMBER_SENT_PACKETS_OF_HANG = 10;
    protected static final int POLL_LONGEST_RTT = 120000;
    protected static final int POLL_NETSTAT_MILLIS = 1000;
    protected static final int POLL_NETSTAT_SCREEN_OFF_MILLIS = 600000;
    protected static final int POLL_NETSTAT_SLOW_MILLIS = 5000;
    protected static final int RESTORE_DEFAULT_APN_DELAY = 60000;
    protected static final String SECONDARY_DATA_RETRY_CONFIG = "max_retries=3, 5000, 5000, 5000";
    protected final String LOG_TAG;
    protected Activity activity;
    protected int cidActive;
    protected boolean[] dataEnabled;
    protected int enabledCount;
    protected Handler mDataConnectionTracker;
    protected boolean mIsWifiConnected;
    protected boolean mMasterDataEnabled = true;
    protected int mNoRecvPollCount;
    protected PendingIntent mReconnectIntent;
    protected String mRequestedApnType;
    protected RetryManager mRetryMgr;
    protected boolean netStatPollEnabled;
    protected int netStatPollPeriod;
    protected PhoneBase phone;
    protected long rxPkts;
    protected long sentSinceLastRecv;
    protected State state;
    protected long txPkts;

    protected DataConnectionTracker(PhoneBase phoneBase) {
        RetryManager retryManager;
        State state;
        Activity activity;
        this.LOG_TAG = "DataConnectionTracker";
        boolean[] blArray = new boolean[5];
        this.dataEnabled = blArray;
        this.enabledCount = 0;
        this.mRequestedApnType = "default";
        this.activity = activity = Activity.NONE;
        this.state = state = State.IDLE;
        this.mDataConnectionTracker = null;
        this.mNoRecvPollCount = 0;
        this.netStatPollEnabled = false;
        this.mRetryMgr = retryManager = new RetryManager();
        this.mIsWifiConnected = false;
        this.mReconnectIntent = null;
        this.phone = phoneBase;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setEnabled(int n, boolean bl) {
        Message message = this.obtainMessage(23);
        message.arg1 = n;
        int n2 = bl ? 1 : 0;
        message.arg2 = n2;
        boolean bl2 = this.sendMessage(message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String apnIdToType(int n) {
        switch (n) {
            default: {
                String string2 = "Unknown id (" + n + ") in apnIdToType";
                int n2 = Log.e("DataConnectionTracker", string2);
                return "default";
            }
            case 0: {
                return "default";
            }
            case 1: {
                return "mms";
            }
            case 2: {
                return "supl";
            }
            case 3: {
                return "dun";
            }
            case 4: 
        }
        return "hipri";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int apnTypeToId(String string2) {
        if (TextUtils.equals(string2, "default")) {
            return 0;
        }
        if (TextUtils.equals(string2, "mms")) {
            return 1;
        }
        if (TextUtils.equals(string2, "supl")) {
            return 2;
        }
        if (TextUtils.equals(string2, "dun")) {
            return 3;
        }
        if (!TextUtils.equals(string2, "hipri")) return -1;
        return 4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int disableApnType(String string2) {
        synchronized (this) {
            int n;
            block4: {
                int n2;
                n = n2 = this.apnTypeToId(string2);
                if (n != -1) break block4;
                return 3;
            }
            if (!this.isEnabled(n)) return 3;
            this.setEnabled(n, false);
            if (!this.isApnTypeActive("default")) return 1;
            boolean bl = this.dataEnabled[0];
            if (bl == null) return 1;
            return 0;
        }
    }

    public abstract void dispose();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int enableApnType(String string2) {
        synchronized (this) {
            int n;
            block6: {
                int n2;
                n = n2 = this.apnTypeToId(string2);
                if (n != -1) break block6;
                return 3;
            }
            if (!this.isApnTypeAvailable(string2)) {
                return 2;
            }
            this.setEnabled(n, true);
            if (!this.isApnTypeActive(string2)) return 1;
            State state = this.state;
            State state2 = State.INITING;
            if (state == state2) {
                return 1;
            }
            State state3 = this.state;
            State state4 = State.CONNECTED;
            if (state3 != state4) return 1;
            return 0;
        }
    }

    protected abstract String getActiveApnString();

    protected abstract String[] getActiveApnTypes();

    public Activity getActivity() {
        return this.activity;
    }

    public abstract ArrayList<DataConnection> getAllDataConnections();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getAnyDataEnabled() {
        if (this.enabledCount == 0) return false;
        return true;
    }

    public boolean getDataEnabled() {
        synchronized (this) {
            boolean bl = this.dataEnabled[0];
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getDataOnRoamingEnabled() {
        try {
            int n = Settings.Secure.getInt(this.phone.getContext().getContentResolver(), "data_roaming");
            if (n <= 0) return false;
            return true;
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            return false;
        }
    }

    protected abstract String[] getDnsServers(String var1);

    protected abstract String getGateway(String var1);

    protected abstract String getInterfaceName(String var1);

    protected abstract String getIpAddress(String var1);

    public State getState() {
        return this.state;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getStateInString() {
        int[] nArray = 1.$SwitchMap$com$android$internal$telephony$DataConnectionTracker$State;
        int n = this.state.ordinal();
        switch (nArray[n]) {
            default: {
                return "ERRO";
            }
            case 1: {
                return "IDLE";
            }
            case 2: {
                return "INIT";
            }
            case 3: {
                return "CING";
            }
            case 4: {
                return "SCAN";
            }
            case 5: {
                return "CNTD";
            }
            case 6: {
                return "DING";
            }
            case 7: 
        }
        return "FAIL";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                StringBuilder stringBuilder = new StringBuilder().append("Unidentified event = ");
                int n = message.what;
                String string2 = stringBuilder.append(n).toString();
                int n2 = Log.e("DATA", string2);
                return;
            }
            case 23: {
                int n = message.arg1;
                int n3 = message.arg2;
                this.onEnableApn(n, n3);
                return;
            }
            case 5: {
                String string3 = null;
                if (message.obj instanceof String) {
                    string3 = (String)message.obj;
                }
                boolean bl = this.onTrySetupData(string3);
                return;
            }
            case 22: {
                if (!this.getDataOnRoamingEnabled()) {
                    this.mRetryMgr.resetRetryCount();
                }
                this.onRoamingOff();
                return;
            }
            case 21: {
                this.onRoamingOn();
                return;
            }
            case 3: {
                this.onRadioAvailable();
                return;
            }
            case 12: {
                this.onRadioOffOrNotAvailable();
                return;
            }
            case 1: {
                int n;
                this.cidActive = n = message.arg1;
                AsyncResult asyncResult = (AsyncResult)message.obj;
                this.onDataSetupComplete(asyncResult);
                return;
            }
            case 25: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                this.onDisconnectDone(asyncResult);
                return;
            }
            case 14: {
                this.onVoiceCallStarted();
                return;
            }
            case 15: {
                this.onVoiceCallEnded();
                return;
            }
            case 34: {
                boolean bl = message.arg1 != 0;
                String string4 = (String)message.obj;
                this.onCleanUpConnection(bl, string4);
                return;
            }
            case 37: {
                boolean bl = message.arg1 == 1;
                this.onSetDataEnabled(bl);
                return;
            }
            case 38: 
        }
        AsyncResult asyncResult = (AsyncResult)message.obj;
        this.onResetDone(asyncResult);
    }

    protected abstract boolean isApnTypeActive(String var1);

    protected abstract boolean isApnTypeAvailable(String var1);

    public abstract boolean isDataConnectionAsDesired();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isEnabled(int n) {
        synchronized (this) {
            if (n == -1) return false;
            return this.dataEnabled[n];
        }
    }

    protected abstract void log(String var1);

    protected abstract void onCleanUpConnection(boolean var1, String var2);

    protected abstract void onDataSetupComplete(AsyncResult var1);

    protected abstract void onDisconnectDone(AsyncResult var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onEnableApn(int n, int n2) {
        synchronized (this) {
            if (n2 == 1) {
                String string2;
                if (this.dataEnabled[n] == null) {
                    int n3;
                    this.dataEnabled[n] = true;
                    this.enabledCount = n3 = this.enabledCount + 1;
                }
                if (!this.isApnTypeActive(string2 = this.apnIdToType(n))) {
                    this.mRequestedApnType = string2;
                    this.onEnableNewApn();
                }
            } else if (this.dataEnabled[n] != null) {
                int n4;
                this.dataEnabled[n] = false;
                this.enabledCount = n4 = this.enabledCount - 1;
                if (this.enabledCount == 0) {
                    this.onCleanUpConnection(true, "dataDisabled");
                } else if (this.dataEnabled[0] && !this.isApnTypeActive("default")) {
                    this.mRequestedApnType = "default";
                    this.onEnableNewApn();
                }
            }
            return;
        }
    }

    protected void onEnableNewApn() {
    }

    protected abstract void onRadioAvailable();

    protected abstract void onRadioOffOrNotAvailable();

    protected abstract void onResetDone(AsyncResult var1);

    protected abstract void onRoamingOff();

    protected abstract void onRoamingOn();

    protected void onSetDataEnabled(boolean bl) {
        if (this.mMasterDataEnabled != bl) {
            return;
        }
        this.mMasterDataEnabled = bl;
        if (bl) {
            this.mRetryMgr.resetRetryCount();
            boolean bl2 = this.onTrySetupData("dataEnabled");
            return;
        }
        this.onCleanUpConnection(true, "dataDisabled");
    }

    protected abstract boolean onTrySetupData(String var1);

    protected abstract void onVoiceCallEnded();

    protected abstract void onVoiceCallStarted();

    protected abstract void restartRadio();

    /*
     * Enabled aggressive block sorting
     */
    public boolean setDataEnabled(boolean bl) {
        Message message = this.obtainMessage(37);
        int n = bl ? 1 : 0;
        message.arg1 = n;
        boolean bl2 = this.sendMessage(message);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDataOnRoamingEnabled(boolean bl) {
        if (this.getDataOnRoamingEnabled() != bl) {
            return;
        }
        ContentResolver contentResolver = this.phone.getContext().getContentResolver();
        String string2 = "data_roaming";
        int n = bl ? 1 : 0;
        boolean bl2 = Settings.Secure.putInt(contentResolver, string2, n);
        if (!this.phone.getServiceState().getRoaming()) {
            return;
        }
        if (bl) {
            this.mRetryMgr.resetRetryCount();
        }
        Message message = this.obtainMessage(21);
        boolean bl3 = this.sendMessage(message);
    }

    protected abstract void setState(State var1);

    protected abstract void startNetStatPoll();

    protected abstract void stopNetStatPoll();

    public static final class Activity
    extends Enum<Activity> {
        private static final /* synthetic */ Activity[] $VALUES;
        public static final /* enum */ Activity DATAIN;
        public static final /* enum */ Activity DATAINANDOUT;
        public static final /* enum */ Activity DATAOUT;
        public static final /* enum */ Activity DORMANT;
        public static final /* enum */ Activity NONE;

        static {
            NONE = new Activity();
            DATAIN = new Activity();
            DATAOUT = new Activity();
            DATAINANDOUT = new Activity();
            DORMANT = new Activity();
            Activity activity = NONE;
            Activity activity2 = DATAIN;
            Activity activity3 = DATAOUT;
            Activity activity4 = DATAINANDOUT;
            Activity activity5 = DORMANT;
            Activity[] activityArray = new Activity[]{activity, activity2, activity3, activity4, activity5};
            $VALUES = activityArray;
        }

        public static Activity valueOf(String string2) {
            return Enum.valueOf(Activity.class, string2);
        }

        public static Activity[] values() {
            return (Activity[])$VALUES.clone();
        }
    }

    public static final class State
    extends Enum<State> {
        private static final /* synthetic */ State[] $VALUES;
        public static final /* enum */ State CONNECTED;
        public static final /* enum */ State CONNECTING;
        public static final /* enum */ State DISCONNECTING;
        public static final /* enum */ State FAILED;
        public static final /* enum */ State IDLE;
        public static final /* enum */ State INITING;
        public static final /* enum */ State SCANNING;

        static {
            IDLE = new State();
            INITING = new State();
            CONNECTING = new State();
            SCANNING = new State();
            CONNECTED = new State();
            DISCONNECTING = new State();
            FAILED = new State();
            State state = IDLE;
            State state2 = INITING;
            State state3 = CONNECTING;
            State state4 = SCANNING;
            State state5 = CONNECTED;
            State state6 = DISCONNECTING;
            State state7 = FAILED;
            State[] stateArray = new State[]{state, state2, state3, state4, state5, state6, state7};
            $VALUES = stateArray;
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }
    }
}

