/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneNotifier;

public class DefaultPhoneNotifier
implements PhoneNotifier {
    private static final boolean DBG = true;
    static final String LOG_TAG = "GSM";
    private ITelephonyRegistry mRegistry;

    DefaultPhoneNotifier() {
        ITelephonyRegistry iTelephonyRegistry;
        this.mRegistry = iTelephonyRegistry = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int convertCallState(Phone.State state) {
        int[] nArray = 1.$SwitchMap$com$android$internal$telephony$Phone$State;
        int n = state.ordinal();
        switch (nArray[n]) {
            default: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: 
        }
        return 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Phone.State convertCallState(int n) {
        switch (n) {
            default: {
                return Phone.State.IDLE;
            }
            case 1: {
                return Phone.State.RINGING;
            }
            case 2: 
        }
        return Phone.State.OFFHOOK;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int convertDataActivityState(Phone.DataActivityState dataActivityState) {
        int[] nArray = 1.$SwitchMap$com$android$internal$telephony$Phone$DataActivityState;
        int n = dataActivityState.ordinal();
        switch (nArray[n]) {
            default: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: 
        }
        return 4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Phone.DataActivityState convertDataActivityState(int n) {
        switch (n) {
            default: {
                return Phone.DataActivityState.NONE;
            }
            case 1: {
                return Phone.DataActivityState.DATAIN;
            }
            case 2: {
                return Phone.DataActivityState.DATAOUT;
            }
            case 3: {
                return Phone.DataActivityState.DATAINANDOUT;
            }
            case 4: 
        }
        return Phone.DataActivityState.DORMANT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int convertDataState(Phone.DataState dataState) {
        int[] nArray = 1.$SwitchMap$com$android$internal$telephony$Phone$DataState;
        int n = dataState.ordinal();
        switch (nArray[n]) {
            default: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: 
        }
        return 3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Phone.DataState convertDataState(int n) {
        switch (n) {
            default: {
                return Phone.DataState.DISCONNECTED;
            }
            case 1: {
                return Phone.DataState.CONNECTING;
            }
            case 2: {
                return Phone.DataState.CONNECTED;
            }
            case 3: 
        }
        return Phone.DataState.SUSPENDED;
    }

    private void log(String string2) {
        String string3 = "[PhoneNotifier] " + string2;
        int n = Log.d(LOG_TAG, string3);
    }

    @Override
    public void notifyCallForwardingChanged(Phone phone) {
        try {
            ITelephonyRegistry iTelephonyRegistry = this.mRegistry;
            boolean bl = phone.getCallForwardingIndicator();
            iTelephonyRegistry.notifyCallForwardingChanged(bl);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void notifyCellLocation(Phone phone) {
        Bundle bundle = new Bundle();
        phone.getCellLocation().fillInNotifierBundle(bundle);
        try {
            this.mRegistry.notifyCellLocation(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void notifyDataActivity(Phone phone) {
        try {
            ITelephonyRegistry iTelephonyRegistry = this.mRegistry;
            int n = DefaultPhoneNotifier.convertDataActivityState(phone.getDataActivityState());
            iTelephonyRegistry.notifyDataActivity(n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void notifyDataConnection(Phone phone, String string2) {
        TelephonyManager telephonyManager = TelephonyManager.getDefault();
        try {
            ITelephonyRegistry iTelephonyRegistry = this.mRegistry;
            int n = DefaultPhoneNotifier.convertDataState(phone.getDataConnectionState());
            boolean bl = phone.isDataConnectivityPossible();
            String string3 = phone.getActiveApn();
            String[] stringArray = phone.getActiveApnTypes();
            String string4 = phone.getInterfaceName(null);
            int n2 = telephonyManager != null ? telephonyManager.getNetworkType() : 0;
            String string5 = phone.getGateway(null);
            String string6 = string2;
            iTelephonyRegistry.notifyDataConnection(n, bl, string6, string3, stringArray, string4, n2, string5);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void notifyDataConnectionFailed(Phone phone, String string2) {
        try {
            this.mRegistry.notifyDataConnectionFailed(string2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void notifyMessageWaitingChanged(Phone phone) {
        try {
            ITelephonyRegistry iTelephonyRegistry = this.mRegistry;
            boolean bl = phone.getMessageWaitingIndicator();
            iTelephonyRegistry.notifyMessageWaitingChanged(bl);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void notifyPhoneState(Phone phone) {
        Call call = phone.getRingingCall();
        String string2 = "";
        if (call != null && call.getEarliestConnection() != null) {
            string2 = call.getEarliestConnection().getAddress();
        }
        try {
            ITelephonyRegistry iTelephonyRegistry = this.mRegistry;
            int n = DefaultPhoneNotifier.convertCallState(phone.getState());
            iTelephonyRegistry.notifyCallState(n, string2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void notifyServiceState(Phone phone) {
        try {
            ITelephonyRegistry iTelephonyRegistry = this.mRegistry;
            ServiceState serviceState = phone.getServiceState();
            iTelephonyRegistry.notifyServiceState(serviceState);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void notifySignalStrength(Phone phone) {
        try {
            ITelephonyRegistry iTelephonyRegistry = this.mRegistry;
            SignalStrength signalStrength = phone.getSignalStrength();
            iTelephonyRegistry.notifySignalStrength(signalStrength);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }
}

