/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.telephony.PhoneNumberUtils;
import android.util.Log;
import com.android.internal.telephony.ATParseEx;
import com.android.internal.telephony.ATResponseParser;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.UUSInfo;

public class DriverCall
implements Comparable {
    static final String LOG_TAG = "RILB";
    public int TOA;
    public int als;
    public int index;
    public boolean isMT;
    public boolean isMpty;
    public boolean isVoice;
    public boolean isVoicePrivacy;
    public String name;
    public int namePresentation;
    public String number;
    public int numberPresentation;
    public State state;
    public UUSInfo uusInfo;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static DriverCall fromCLCCLine(String string2) {
        DriverCall driverCall = new DriverCall();
        ATResponseParser aTResponseParser = new ATResponseParser(string2);
        try {
            String string3;
            int n;
            String string4;
            int n2;
            boolean bl;
            State state;
            boolean bl2;
            int n3;
            driverCall.index = n3 = aTResponseParser.nextInt();
            driverCall.isMT = bl2 = aTResponseParser.nextBoolean();
            driverCall.state = state = DriverCall.stateFromCLCC(aTResponseParser.nextInt());
            boolean bl3 = aTResponseParser.nextInt() == 0;
            driverCall.isVoice = bl3;
            driverCall.isMpty = bl = aTResponseParser.nextBoolean();
            driverCall.numberPresentation = n2 = Connection.PRESENTATION_ALLOWED;
            if (!aTResponseParser.hasMore()) return driverCall;
            driverCall.number = string4 = PhoneNumberUtils.extractNetworkPortionAlt(aTResponseParser.nextString());
            if (driverCall.number.length() == 0) {
                driverCall.number = null;
            }
            driverCall.TOA = n = aTResponseParser.nextInt();
            String string5 = driverCall.number;
            int n4 = driverCall.TOA;
            driverCall.number = string3 = PhoneNumberUtils.stringFromStringAndTOA(string5, n4);
            return driverCall;
        }
        catch (ATParseEx aTParseEx) {
            String string6 = "Invalid CLCC line: '" + string2 + "'";
            int n = Log.e(LOG_TAG, string6);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int presentationFromCLIP(int n) throws ATParseEx {
        switch (n) {
            default: {
                String string2 = "illegal presentation " + n;
                throw new ATParseEx(string2);
            }
            case 0: {
                return Connection.PRESENTATION_ALLOWED;
            }
            case 1: {
                return Connection.PRESENTATION_RESTRICTED;
            }
            case 2: {
                return Connection.PRESENTATION_UNKNOWN;
            }
            case 3: 
        }
        return Connection.PRESENTATION_PAYPHONE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static State stateFromCLCC(int n) throws ATParseEx {
        switch (n) {
            default: {
                String string2 = "illegal call state " + n;
                throw new ATParseEx(string2);
            }
            case 0: {
                return State.ACTIVE;
            }
            case 1: {
                return State.HOLDING;
            }
            case 2: {
                return State.DIALING;
            }
            case 3: {
                return State.ALERTING;
            }
            case 4: {
                return State.INCOMING;
            }
            case 5: 
        }
        return State.WAITING;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int compareTo(Object object) {
        DriverCall driverCall = (DriverCall)object;
        int n = this.index;
        int n2 = driverCall.index;
        if (n < n2) {
            return -1;
        }
        int n3 = this.index;
        int n4 = driverCall.index;
        if (n3 == n4) return 1;
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("id=");
        int n = this.index;
        StringBuilder stringBuilder2 = stringBuilder.append(n).append(",");
        State state = this.state;
        StringBuilder stringBuilder3 = stringBuilder2.append((Object)state).append(",").append("toa=");
        int n2 = this.TOA;
        StringBuilder stringBuilder4 = stringBuilder3.append(n2).append(",");
        String string2 = this.isMpty ? "conf" : "norm";
        StringBuilder stringBuilder5 = stringBuilder4.append(string2).append(",");
        String string3 = this.isMT ? "mt" : "mo";
        StringBuilder stringBuilder6 = stringBuilder5.append(string3).append(",");
        int n3 = this.als;
        StringBuilder stringBuilder7 = stringBuilder6.append(n3).append(",");
        String string4 = this.isVoice ? "voc" : "nonvoc";
        StringBuilder stringBuilder8 = stringBuilder7.append(string4).append(",");
        String string5 = this.isVoicePrivacy ? "evp" : "noevp";
        StringBuilder stringBuilder9 = stringBuilder8.append(string5).append(",").append(",cli=");
        int n4 = this.numberPresentation;
        StringBuilder stringBuilder10 = stringBuilder9.append(n4).append(",").append(",");
        int n5 = this.namePresentation;
        return stringBuilder10.append(n5).toString();
    }

    public static final class State
    extends Enum<State> {
        private static final /* synthetic */ State[] $VALUES;
        public static final /* enum */ State ACTIVE = new State();
        public static final /* enum */ State ALERTING;
        public static final /* enum */ State DIALING;
        public static final /* enum */ State HOLDING;
        public static final /* enum */ State INCOMING;
        public static final /* enum */ State WAITING;

        static {
            HOLDING = new State();
            DIALING = new State();
            ALERTING = new State();
            INCOMING = new State();
            WAITING = new State();
            State state = ACTIVE;
            State state2 = HOLDING;
            State state3 = DIALING;
            State state4 = ALERTING;
            State state5 = INCOMING;
            State state6 = WAITING;
            State[] stateArray = new State[]{state, state2, state3, state4, state5, state6};
            $VALUES = stateArray;
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }
    }
}

