/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;

public interface IPhoneStateListener
extends IInterface {
    public void onCallForwardingIndicatorChanged(boolean var1) throws RemoteException;

    public void onCallStateChanged(int var1, String var2) throws RemoteException;

    public void onCellLocationChanged(Bundle var1) throws RemoteException;

    public void onDataActivity(int var1) throws RemoteException;

    public void onDataConnectionStateChanged(int var1, int var2) throws RemoteException;

    public void onMessageWaitingIndicatorChanged(boolean var1) throws RemoteException;

    public void onServiceStateChanged(ServiceState var1) throws RemoteException;

    public void onSignalStrengthChanged(int var1) throws RemoteException;

    public void onSignalStrengthsChanged(SignalStrength var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPhoneStateListener {
        private static final String DESCRIPTOR = "com.android.internal.telephony.IPhoneStateListener";
        static final int TRANSACTION_onCallForwardingIndicatorChanged = 4;
        static final int TRANSACTION_onCallStateChanged = 6;
        static final int TRANSACTION_onCellLocationChanged = 5;
        static final int TRANSACTION_onDataActivity = 8;
        static final int TRANSACTION_onDataConnectionStateChanged = 7;
        static final int TRANSACTION_onMessageWaitingIndicatorChanged = 3;
        static final int TRANSACTION_onServiceStateChanged = 1;
        static final int TRANSACTION_onSignalStrengthChanged = 2;
        static final int TRANSACTION_onSignalStrengthsChanged = 9;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static IPhoneStateListener asInterface(IBinder iBinder) {
            void var1_2;
            if (iBinder == null) {
                return var1_2;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IPhoneStateListener) {
                IPhoneStateListener iPhoneStateListener = (IPhoneStateListener)iInterface;
                return var1_2;
            }
            Proxy proxy = new Proxy(iBinder);
            return var1_2;
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            void var6_19;
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    void var6_7;
                    parcel.enforceInterface(DESCRIPTOR);
                    if (parcel.readInt() != 0) {
                        ServiceState serviceState = ServiceState.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var6_8 = null;
                    }
                    this.onServiceStateChanged((ServiceState)var6_7);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n3 = parcel.readInt();
                    this.onSignalStrengthChanged(n3);
                    return true;
                }
                case 3: {
                    void var6_10;
                    parcel.enforceInterface(DESCRIPTOR);
                    if (parcel.readInt() != 0) {
                        Object var6_9 = null;
                    } else {
                        Object var6_11 = null;
                    }
                    this.onMessageWaitingIndicatorChanged((boolean)var6_10);
                    return true;
                }
                case 4: {
                    void var6_13;
                    parcel.enforceInterface(DESCRIPTOR);
                    if (parcel.readInt() != 0) {
                        Object var6_12 = null;
                    } else {
                        Object var6_14 = null;
                    }
                    this.onCallForwardingIndicatorChanged((boolean)var6_13);
                    return true;
                }
                case 5: {
                    void var6_16;
                    parcel.enforceInterface(DESCRIPTOR);
                    if (parcel.readInt() != 0) {
                        Bundle bundle = Bundle.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var6_17 = null;
                    }
                    this.onCellLocationChanged((Bundle)var6_16);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n4 = parcel.readInt();
                    String string2 = parcel.readString();
                    this.onCallStateChanged(n4, string2);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n5 = parcel.readInt();
                    int n6 = parcel.readInt();
                    this.onDataConnectionStateChanged(n5, n6);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n7 = parcel.readInt();
                    this.onDataActivity(n7);
                    return true;
                }
                case 9: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            if (parcel.readInt() != 0) {
                SignalStrength signalStrength = SignalStrength.CREATOR.createFromParcel(parcel);
            } else {
                Object var6_20 = null;
            }
            this.onSignalStrengthsChanged((SignalStrength)var6_19);
            return true;
        }

        private static class Proxy
        implements IPhoneStateListener {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onCallForwardingIndicatorChanged(boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    boolean bl2 = this.mRemote.transact(4, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void onCallStateChanged(int n, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(6, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onCellLocationChanged(Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl = this.mRemote.transact(5, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void onDataActivity(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    boolean bl = this.mRemote.transact(8, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void onDataConnectionStateChanged(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    boolean bl = this.mRemote.transact(7, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onMessageWaitingIndicatorChanged(boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    boolean bl2 = this.mRemote.transact(3, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onServiceStateChanged(ServiceState serviceState) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (serviceState != null) {
                        parcel.writeInt(1);
                        serviceState.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl = this.mRemote.transact(1, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void onSignalStrengthChanged(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    boolean bl = this.mRemote.transact(2, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onSignalStrengthsChanged(SignalStrength signalStrength) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (signalStrength != null) {
                        parcel.writeInt(1);
                        signalStrength.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl = this.mRemote.transact(9, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }
        }
    }
}

