/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import com.android.internal.telephony.IPhoneStateListener;

public interface ITelephonyRegistry
extends IInterface {
    public void listen(String var1, IPhoneStateListener var2, int var3, boolean var4) throws RemoteException;

    public void notifyCallForwardingChanged(boolean var1) throws RemoteException;

    public void notifyCallState(int var1, String var2) throws RemoteException;

    public void notifyCellLocation(Bundle var1) throws RemoteException;

    public void notifyDataActivity(int var1) throws RemoteException;

    public void notifyDataConnection(int var1, boolean var2, String var3, String var4, String[] var5, String var6, int var7, String var8) throws RemoteException;

    public void notifyDataConnectionFailed(String var1) throws RemoteException;

    public void notifyMessageWaitingChanged(boolean var1) throws RemoteException;

    public void notifyServiceState(ServiceState var1) throws RemoteException;

    public void notifySignalStrength(SignalStrength var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITelephonyRegistry {
        private static final String DESCRIPTOR = "com.android.internal.telephony.ITelephonyRegistry";
        static final int TRANSACTION_listen = 1;
        static final int TRANSACTION_notifyCallForwardingChanged = 6;
        static final int TRANSACTION_notifyCallState = 2;
        static final int TRANSACTION_notifyCellLocation = 10;
        static final int TRANSACTION_notifyDataActivity = 7;
        static final int TRANSACTION_notifyDataConnection = 8;
        static final int TRANSACTION_notifyDataConnectionFailed = 9;
        static final int TRANSACTION_notifyMessageWaitingChanged = 5;
        static final int TRANSACTION_notifyServiceState = 3;
        static final int TRANSACTION_notifySignalStrength = 4;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static ITelephonyRegistry asInterface(IBinder iBinder) {
            void var1_2;
            if (iBinder == null) {
                return var1_2;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof ITelephonyRegistry) {
                ITelephonyRegistry iTelephonyRegistry = (ITelephonyRegistry)iInterface;
                return var1_2;
            }
            Proxy proxy = new Proxy(iBinder);
            return var1_2;
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string2 = parcel.readString();
                    IPhoneStateListener iPhoneStateListener = IPhoneStateListener.Stub.asInterface(parcel.readStrongBinder());
                    int n3 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    this.listen(string2, iPhoneStateListener, n3, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n4 = parcel.readInt();
                    String string3 = parcel.readString();
                    this.notifyCallState(n4, string3);
                    parcel2.writeNoException();
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ServiceState serviceState = parcel.readInt() != 0 ? ServiceState.CREATOR.createFromParcel(parcel) : null;
                    this.notifyServiceState(serviceState);
                    parcel2.writeNoException();
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    SignalStrength signalStrength = parcel.readInt() != 0 ? SignalStrength.CREATOR.createFromParcel(parcel) : null;
                    this.notifySignalStrength(signalStrength);
                    parcel2.writeNoException();
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.notifyMessageWaitingChanged(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.notifyCallForwardingChanged(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n5 = parcel.readInt();
                    this.notifyDataActivity(n5);
                    parcel2.writeNoException();
                    return true;
                }
                case 8: {
                    IPhoneStateListener iPhoneStateListener;
                    parcel.enforceInterface(DESCRIPTOR);
                    int n6 = parcel.readInt();
                    if (parcel.readInt() != 0) {
                        Object var7_14 = null;
                    } else {
                        boolean bl = false;
                    }
                    String string4 = parcel.readString();
                    String string5 = parcel.readString();
                    String[] stringArray = parcel.createStringArray();
                    String string6 = parcel.readString();
                    int n7 = parcel.readInt();
                    String string7 = parcel.readString();
                    this.notifyDataConnection(n6, (boolean)iPhoneStateListener, string4, string5, stringArray, string6, n7, string7);
                    parcel2.writeNoException();
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string8 = parcel.readString();
                    this.notifyDataConnectionFailed(string8);
                    parcel2.writeNoException();
                    return true;
                }
                case 10: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
            this.notifyCellLocation(bundle);
            parcel2.writeNoException();
            return true;
        }

        private static class Proxy
        implements ITelephonyRegistry {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void listen(String string2, IPhoneStateListener iPhoneStateListener, int n, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    IBinder iBinder = iPhoneStateListener != null ? iPhoneStateListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    iBinder = bl ? null : null;
                    parcel.writeInt((int)iBinder);
                    boolean bl2 = this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void notifyCallForwardingChanged(boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    boolean bl2 = this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void notifyCallState(int n, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void notifyCellLocation(Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl = this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void notifyDataActivity(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    boolean bl = this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void notifyDataConnection(int n, boolean bl, String string2, String string3, String[] stringArray, String string4, int n2, String string5) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    int n3 = bl ? 1 : 0;
                    parcel.writeInt(n3);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    parcel.writeStringArray(stringArray);
                    parcel.writeString(string4);
                    parcel.writeInt(n2);
                    parcel.writeString(string5);
                    boolean bl2 = this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void notifyDataConnectionFailed(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void notifyMessageWaitingChanged(boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    boolean bl2 = this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void notifyServiceState(ServiceState serviceState) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (serviceState != null) {
                        parcel.writeInt(1);
                        serviceState.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl = this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void notifySignalStrength(SignalStrength signalStrength) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (signalStrength != null) {
                        parcel.writeInt(1);
                        signalStrength.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl = this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

