/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.ActivityManagerNative;
import android.content.Intent;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IccCardApplication;
import com.android.internal.telephony.IccCardStatus;
import com.android.internal.telephony.PhoneBase;

public abstract class IccCard {
    private static final int EVENT_CHANGE_FACILITY_FDN_DONE = 11;
    private static final int EVENT_CHANGE_FACILITY_LOCK_DONE = 8;
    private static final int EVENT_CHANGE_ICC_PASSWORD_DONE = 9;
    private static final int EVENT_GET_ICC_STATUS_DONE = 2;
    protected static final int EVENT_ICC_LOCKED_OR_ABSENT = 1;
    protected static final int EVENT_ICC_READY = 6;
    private static final int EVENT_PINPUK_DONE = 4;
    private static final int EVENT_QUERY_FACILITY_FDN_DONE = 10;
    private static final int EVENT_QUERY_FACILITY_LOCK_DONE = 7;
    protected static final int EVENT_RADIO_OFF_OR_NOT_AVAILABLE = 3;
    private static final int EVENT_REPOLL_STATUS_DONE = 5;
    public static final String INTENT_KEY_ICC_STATE = "ss";
    public static final String INTENT_KEY_LOCKED_REASON = "reason";
    public static final String INTENT_VALUE_ICC_ABSENT = "ABSENT";
    public static final String INTENT_VALUE_ICC_IMSI = "IMSI";
    public static final String INTENT_VALUE_ICC_LOADED = "LOADED";
    public static final String INTENT_VALUE_ICC_LOCKED = "LOCKED";
    public static final String INTENT_VALUE_ICC_NOT_READY = "NOT_READY";
    public static final String INTENT_VALUE_ICC_READY = "READY";
    public static final String INTENT_VALUE_LOCKED_NETWORK = "NETWORK";
    public static final String INTENT_VALUE_LOCKED_ON_PIN = "PIN";
    public static final String INTENT_VALUE_LOCKED_ON_PUK = "PUK";
    private RegistrantList mAbsentRegistrants;
    protected boolean mDbg;
    private boolean mDesiredFdnEnabled;
    private boolean mDesiredPinLocked;
    protected Handler mHandler;
    private IccCardStatus mIccCardStatus = null;
    private boolean mIccFdnEnabled;
    private boolean mIccPinLocked;
    protected String mLogTag;
    private RegistrantList mNetworkLockedRegistrants;
    protected PhoneBase mPhone;
    private RegistrantList mPinLockedRegistrants;
    protected State mState = null;

    public IccCard(PhoneBase phoneBase, String string2, Boolean bl) {
        boolean bl2;
        Handler handler;
        RegistrantList registrantList;
        RegistrantList registrantList2;
        RegistrantList registrantList3;
        this.mAbsentRegistrants = registrantList3 = new RegistrantList();
        this.mPinLockedRegistrants = registrantList2 = new RegistrantList();
        this.mNetworkLockedRegistrants = registrantList = new RegistrantList();
        this.mIccPinLocked = true;
        this.mIccFdnEnabled = false;
        this.mHandler = handler = new Handler(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void handleMessage(Message message) {
                Throwable throwable;
                switch (message.what) {
                    default: {
                        String string2 = IccCard.this.mLogTag;
                        StringBuilder stringBuilder = new StringBuilder().append("[IccCard] Unknown Event ");
                        int n = message.what;
                        String string3 = stringBuilder.append(n).toString();
                        int n2 = Log.e(string2, string3);
                        return;
                    }
                    case 3: {
                        IccCard.this.mState = null;
                        IccCard.this.updateStateProperty();
                        IccCard.this.broadcastIccStateChangedIntent(IccCard.INTENT_VALUE_ICC_NOT_READY, null);
                        return;
                    }
                    case 6: {
                        CommandsInterface commandsInterface = IccCard.this.mPhone.mCM;
                        Message message2 = this.obtainMessage(2);
                        commandsInterface.getIccCardStatus(message2);
                        CommandsInterface commandsInterface2 = IccCard.this.mPhone.mCM;
                        Message message3 = this.obtainMessage(7);
                        commandsInterface2.queryFacilityLock("SC", "", 7, message3);
                        CommandsInterface commandsInterface3 = IccCard.this.mPhone.mCM;
                        Message message4 = this.obtainMessage(10);
                        commandsInterface3.queryFacilityLock("FD", "", 7, message4);
                        return;
                    }
                    case 1: {
                        CommandsInterface commandsInterface = IccCard.this.mPhone.mCM;
                        Message message5 = this.obtainMessage(2);
                        commandsInterface.getIccCardStatus(message5);
                        CommandsInterface commandsInterface4 = IccCard.this.mPhone.mCM;
                        Message message6 = this.obtainMessage(7);
                        commandsInterface4.queryFacilityLock("SC", "", 7, message6);
                        return;
                    }
                    case 2: {
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        IccCard.this.getIccCardStatusDone(asyncResult);
                        return;
                    }
                    case 4: {
                        Throwable throwable2;
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        AsyncResult asyncResult2 = AsyncResult.forMessage((Message)asyncResult.userObj);
                        asyncResult2.exception = throwable2 = asyncResult.exception;
                        CommandsInterface commandsInterface = IccCard.this.mPhone.mCM;
                        Object object = asyncResult.userObj;
                        Message message7 = this.obtainMessage(5, object);
                        commandsInterface.getIccCardStatus(message7);
                        return;
                    }
                    case 5: {
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        IccCard.this.getIccCardStatusDone(asyncResult);
                        ((Message)asyncResult.userObj).sendToTarget();
                        return;
                    }
                    case 7: {
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        IccCard.this.onQueryFacilityLock(asyncResult);
                        return;
                    }
                    case 10: {
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        IccCard.this.onQueryFdnEnabled(asyncResult);
                        return;
                    }
                    case 8: {
                        Throwable throwable3;
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        if (asyncResult.exception == null) {
                            IccCard iccCard = IccCard.this;
                            boolean bl = IccCard.this.mDesiredPinLocked;
                            boolean bl2 = IccCard.access$302(iccCard, bl);
                            if (IccCard.this.mDbg) {
                                IccCard iccCard2 = IccCard.this;
                                StringBuilder stringBuilder = new StringBuilder().append("EVENT_CHANGE_FACILITY_LOCK_DONE: mIccPinLocked= ");
                                boolean bl3 = IccCard.this.mIccPinLocked;
                                String string4 = stringBuilder.append(bl3).toString();
                                iccCard2.log(string4);
                            }
                        } else {
                            String string5 = IccCard.this.mLogTag;
                            StringBuilder stringBuilder = new StringBuilder().append("Error change facility lock with exception ");
                            Throwable throwable4 = asyncResult.exception;
                            String string6 = stringBuilder.append(throwable4).toString();
                            int n = Log.e(string5, string6);
                        }
                        AsyncResult asyncResult3 = AsyncResult.forMessage((Message)asyncResult.userObj);
                        asyncResult3.exception = throwable3 = asyncResult.exception;
                        ((Message)asyncResult.userObj).sendToTarget();
                        return;
                    }
                    case 11: {
                        Throwable throwable5;
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        if (asyncResult.exception == null) {
                            IccCard iccCard = IccCard.this;
                            boolean bl = IccCard.this.mDesiredFdnEnabled;
                            boolean bl4 = IccCard.access$602(iccCard, bl);
                            if (IccCard.this.mDbg) {
                                IccCard iccCard3 = IccCard.this;
                                StringBuilder stringBuilder = new StringBuilder().append("EVENT_CHANGE_FACILITY_FDN_DONE: mIccFdnEnabled=");
                                boolean bl5 = IccCard.this.mIccFdnEnabled;
                                String string7 = stringBuilder.append(bl5).toString();
                                iccCard3.log(string7);
                            }
                        } else {
                            String string8 = IccCard.this.mLogTag;
                            StringBuilder stringBuilder = new StringBuilder().append("Error change facility fdn with exception ");
                            Throwable throwable6 = asyncResult.exception;
                            String string9 = stringBuilder.append(throwable6).toString();
                            int n = Log.e(string8, string9);
                        }
                        AsyncResult asyncResult4 = AsyncResult.forMessage((Message)asyncResult.userObj);
                        asyncResult4.exception = throwable5 = asyncResult.exception;
                        ((Message)asyncResult.userObj).sendToTarget();
                        return;
                    }
                    case 9: 
                }
                AsyncResult asyncResult = (AsyncResult)message.obj;
                if (asyncResult.exception != null) {
                    String string10 = IccCard.this.mLogTag;
                    StringBuilder stringBuilder = new StringBuilder().append("Error in change sim password with exception");
                    Throwable throwable7 = asyncResult.exception;
                    String string11 = stringBuilder.append(throwable7).toString();
                    int n = Log.e(string10, string11);
                }
                AsyncResult asyncResult5 = AsyncResult.forMessage((Message)asyncResult.userObj);
                asyncResult5.exception = throwable = asyncResult.exception;
                ((Message)asyncResult.userObj).sendToTarget();
            }
        };
        this.mPhone = phoneBase;
        this.mLogTag = string2;
        this.mDbg = bl2 = bl.booleanValue();
    }

    static /* synthetic */ boolean access$302(IccCard iccCard, boolean bl) {
        iccCard.mIccPinLocked = bl;
        return bl;
    }

    static /* synthetic */ boolean access$602(IccCard iccCard, boolean bl) {
        iccCard.mIccFdnEnabled = bl;
        return bl;
    }

    private void getIccCardStatusDone(AsyncResult asyncResult) {
        if (asyncResult.exception != null) {
            String string2 = this.mLogTag;
            Throwable throwable = asyncResult.exception;
            int n = Log.e(string2, "Error getting ICC status. RIL_REQUEST_GET_ICC_STATUS should never return an error", throwable);
            return;
        }
        IccCardStatus iccCardStatus = (IccCardStatus)asyncResult.result;
        this.handleIccCardStatus(iccCardStatus);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleIccCardStatus(IccCardStatus iccCardStatus) {
        State state;
        State state2;
        State state3;
        State state4;
        State state5;
        State state6;
        State state7 = this.mState;
        this.mIccCardStatus = iccCardStatus;
        this.mState = state6 = this.getIccCardState();
        this.updateStateProperty();
        State state8 = State.PIN_REQUIRED;
        boolean bl = state7 != state8 && state6 == (state5 = State.PIN_REQUIRED) || state7 != (state4 = State.PUK_REQUIRED) && state6 == (state3 = State.PUK_REQUIRED);
        State state9 = State.ABSENT;
        boolean bl2 = state7 != state9 && state6 == (state2 = State.ABSENT);
        State state10 = State.NETWORK_LOCKED;
        boolean bl3 = state7 != state10 && state6 == (state = State.NETWORK_LOCKED);
        if (bl) {
            if (this.mDbg) {
                this.log("Notify SIM pin or puk locked.");
            }
            this.mPinLockedRegistrants.notifyRegistrants();
            State state11 = State.PIN_REQUIRED;
            String string2 = state6 == state11 ? INTENT_VALUE_LOCKED_ON_PIN : INTENT_VALUE_LOCKED_ON_PUK;
            this.broadcastIccStateChangedIntent(INTENT_VALUE_ICC_LOCKED, string2);
            return;
        }
        if (bl2) {
            if (this.mDbg) {
                this.log("Notify SIM missing.");
            }
            this.mAbsentRegistrants.notifyRegistrants();
            this.broadcastIccStateChangedIntent(INTENT_VALUE_ICC_ABSENT, null);
            return;
        }
        if (!bl3) {
            return;
        }
        if (this.mDbg) {
            this.log("Notify SIM network locked.");
        }
        this.mNetworkLockedRegistrants.notifyRegistrants();
        this.broadcastIccStateChangedIntent(INTENT_VALUE_ICC_LOCKED, INTENT_VALUE_LOCKED_NETWORK);
    }

    private void log(String string2) {
        String string3 = this.mLogTag;
        String string4 = "[IccCard] " + string2;
        int n = Log.d(string3, string4);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onQueryFacilityLock(AsyncResult asyncResult) {
        if (asyncResult.exception != null) {
            if (!this.mDbg) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Error in querying facility lock:");
            Throwable throwable = asyncResult.exception;
            String string2 = stringBuilder.append(throwable).toString();
            this.log(string2);
            return;
        }
        int[] nArray = (int[])asyncResult.result;
        if (nArray.length == 0) {
            int n = Log.e(this.mLogTag, "[IccCard] Bogus facility lock response");
            return;
        }
        boolean bl = nArray[0] != 0;
        this.mIccPinLocked = bl;
        if (!this.mDbg) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Query facility lock : ");
        boolean bl2 = this.mIccPinLocked;
        String string3 = stringBuilder.append(bl2).toString();
        this.log(string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onQueryFdnEnabled(AsyncResult asyncResult) {
        if (asyncResult.exception != null) {
            if (!this.mDbg) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Error in querying facility lock:");
            Throwable throwable = asyncResult.exception;
            String string2 = stringBuilder.append(throwable).toString();
            this.log(string2);
            return;
        }
        int[] nArray = (int[])asyncResult.result;
        if (nArray.length == 0) {
            int n = Log.e(this.mLogTag, "[IccCard] Bogus facility lock response");
            return;
        }
        boolean bl = nArray[0] != 0;
        this.mIccFdnEnabled = bl;
        if (!this.mDbg) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Query facility lock : ");
        boolean bl2 = this.mIccFdnEnabled;
        String string3 = stringBuilder.append(bl2).toString();
        this.log(string3);
    }

    public void broadcastIccStateChangedIntent(String string2, String string3) {
        Intent intent = new Intent("android.intent.action.SIM_STATE_CHANGED");
        Intent intent2 = intent.addFlags(0x20000000);
        String string4 = this.mPhone.getPhoneName();
        Intent intent3 = intent.putExtra("phoneName", string4);
        Intent intent4 = intent.putExtra(INTENT_KEY_ICC_STATE, string2);
        Intent intent5 = intent.putExtra(INTENT_KEY_LOCKED_REASON, string3);
        if (this.mDbg) {
            String string5 = "Broadcasting intent ACTION_SIM_STATE_CHANGED " + string2 + " reason " + string3;
            this.log(string5);
        }
        ActivityManagerNative.broadcastStickyIntent(intent, "android.permission.READ_PHONE_STATE");
    }

    public void changeIccFdnPassword(String string2, String string3, Message message) {
        if (this.mDbg) {
            String string4 = "Change Pin2 old: " + string2 + " new: " + string3;
            this.log(string4);
        }
        CommandsInterface commandsInterface = this.mPhone.mCM;
        Message message2 = this.mHandler.obtainMessage(9, message);
        commandsInterface.changeIccPin2(string2, string3, message2);
    }

    public void changeIccLockPassword(String string2, String string3, Message message) {
        if (this.mDbg) {
            String string4 = "Change Pin1 old: " + string2 + " new: " + string3;
            this.log(string4);
        }
        CommandsInterface commandsInterface = this.mPhone.mCM;
        Message message2 = this.mHandler.obtainMessage(9, message);
        commandsInterface.changeIccPin(string2, string3, message2);
    }

    public abstract void dispose();

    protected void finalize() {
        if (!this.mDbg) {
            return;
        }
        int n = Log.d(this.mLogTag, "IccCard finalized");
    }

    /*
     * Enabled aggressive block sorting
     */
    public State getIccCardState() {
        CommandsInterface.RadioState radioState;
        CommandsInterface.RadioState radioState2;
        CommandsInterface.RadioState radioState3;
        CommandsInterface.RadioState radioState4;
        CommandsInterface.RadioState radioState5;
        if (this.mIccCardStatus == null) {
            int n = Log.e(this.mLogTag, "[IccCard] IccCardStatus is null");
            return State.ABSENT;
        }
        if (!this.mIccCardStatus.getCardState().isCardPresent()) {
            return State.ABSENT;
        }
        CommandsInterface.RadioState radioState6 = this.mPhone.mCM.getRadioState();
        if (radioState6 == (radioState5 = CommandsInterface.RadioState.RADIO_OFF)) return State.NOT_READY;
        CommandsInterface.RadioState radioState7 = CommandsInterface.RadioState.RADIO_UNAVAILABLE;
        if (radioState6 == radioState7) return State.NOT_READY;
        CommandsInterface.RadioState radioState8 = CommandsInterface.RadioState.SIM_NOT_READY;
        if (radioState6 == radioState8) return State.NOT_READY;
        CommandsInterface.RadioState radioState9 = CommandsInterface.RadioState.RUIM_NOT_READY;
        if (radioState6 == radioState9) return State.NOT_READY;
        CommandsInterface.RadioState radioState10 = CommandsInterface.RadioState.NV_NOT_READY;
        if (radioState6 == radioState10) return State.NOT_READY;
        CommandsInterface.RadioState radioState11 = CommandsInterface.RadioState.NV_READY;
        if (radioState6 == radioState11) {
            return State.NOT_READY;
        }
        CommandsInterface.RadioState radioState12 = CommandsInterface.RadioState.SIM_LOCKED_OR_ABSENT;
        if (radioState6 != radioState12 && radioState6 != (radioState4 = CommandsInterface.RadioState.SIM_READY) && radioState6 != (radioState3 = CommandsInterface.RadioState.RUIM_LOCKED_OR_ABSENT) && radioState6 != (radioState2 = CommandsInterface.RadioState.RUIM_READY)) {
            return State.ABSENT;
        }
        CommandsInterface.RadioState radioState13 = CommandsInterface.RadioState.RUIM_LOCKED_OR_ABSENT;
        int n = radioState6 == radioState13 || radioState6 == (radioState = CommandsInterface.RadioState.RUIM_READY) ? this.mIccCardStatus.getCdmaSubscriptionAppIndex() : this.mIccCardStatus.getGsmUmtsSubscriptionAppIndex();
        IccCardApplication iccCardApplication = this.mIccCardStatus.getApplication(n);
        if (iccCardApplication == null) {
            int n2 = Log.e(this.mLogTag, "[IccCard] Subscription Application in not present");
            return State.ABSENT;
        }
        if (iccCardApplication.app_state.isPinRequired()) {
            return State.PIN_REQUIRED;
        }
        if (iccCardApplication.app_state.isPukRequired()) {
            return State.PUK_REQUIRED;
        }
        if (iccCardApplication.app_state.isSubscriptionPersoEnabled()) {
            return State.NETWORK_LOCKED;
        }
        if (iccCardApplication.app_state.isAppReady()) {
            return State.READY;
        }
        if (!iccCardApplication.app_state.isAppNotReady()) return State.NOT_READY;
        return State.NOT_READY;
    }

    public boolean getIccFdnEnabled() {
        return this.mIccFdnEnabled;
    }

    public boolean getIccLockEnabled() {
        return this.mIccPinLocked;
    }

    public abstract String getServiceProviderName();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public State getState() {
        if (this.mState != null) return this.mState;
        int[] nArray = 2.$SwitchMap$com$android$internal$telephony$CommandsInterface$RadioState;
        int n = this.mPhone.mCM.getRadioState().ordinal();
        switch (nArray[n]) {
            default: {
                int n2 = Log.e(this.mLogTag, "IccCard.getState(): case should never be reached");
                return State.UNKNOWN;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return State.UNKNOWN;
            }
            case 5: 
            case 6: {
                return State.UNKNOWN;
            }
            case 7: 
            case 8: 
            case 9: {
                return State.READY;
            }
            case 10: 
        }
        return State.ABSENT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasIccCard() {
        if (!this.mPhone.getPhoneName().equals("GSM")) return false;
        return this.mIccCardStatus.getCardState().isCardPresent();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isApplicationOnIcc(IccCardApplication.AppType appType) {
        int n;
        if (this.mIccCardStatus == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < (n = this.mIccCardStatus.getNumApplications())) {
            IccCardApplication iccCardApplication = this.mIccCardStatus.getApplication(n2);
            if (iccCardApplication != null && iccCardApplication.app_type == appType) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void registerForAbsent(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.mAbsentRegistrants.add(registrant);
        State state = this.getState();
        State state2 = State.ABSENT;
        if (state != state2) {
            return;
        }
        registrant.notifyRegistrant();
    }

    public void registerForLocked(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.mPinLockedRegistrants.add(registrant);
        if (!this.getState().isPinLocked()) {
            return;
        }
        registrant.notifyRegistrant();
    }

    public void registerForNetworkLocked(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.mNetworkLockedRegistrants.add(registrant);
        State state = this.getState();
        State state2 = State.NETWORK_LOCKED;
        if (state != state2) {
            return;
        }
        registrant.notifyRegistrant();
    }

    public void setIccFdnEnabled(boolean bl, String string2, Message message) {
        this.mDesiredFdnEnabled = bl;
        CommandsInterface commandsInterface = this.mPhone.mCM;
        Message message2 = this.mHandler.obtainMessage(11, message);
        boolean bl2 = bl;
        String string3 = string2;
        commandsInterface.setFacilityLock("FD", bl2, string3, 15, message2);
    }

    public void setIccLockEnabled(boolean bl, String string2, Message message) {
        this.mDesiredPinLocked = bl;
        CommandsInterface commandsInterface = this.mPhone.mCM;
        Message message2 = this.mHandler.obtainMessage(8, message);
        boolean bl2 = bl;
        String string3 = string2;
        commandsInterface.setFacilityLock("SC", bl2, string3, 7, message2);
    }

    public void supplyNetworkDepersonalization(String string2, Message message) {
        if (this.mDbg) {
            String string3 = "Network Despersonalization: " + string2;
            this.log(string3);
        }
        CommandsInterface commandsInterface = this.mPhone.mCM;
        Message message2 = this.mHandler.obtainMessage(4, message);
        commandsInterface.supplyNetworkDepersonalization(string2, message2);
    }

    public void supplyPin(String string2, Message message) {
        CommandsInterface commandsInterface = this.mPhone.mCM;
        Message message2 = this.mHandler.obtainMessage(4, message);
        commandsInterface.supplyIccPin(string2, message2);
    }

    public void supplyPin2(String string2, Message message) {
        CommandsInterface commandsInterface = this.mPhone.mCM;
        Message message2 = this.mHandler.obtainMessage(4, message);
        commandsInterface.supplyIccPin2(string2, message2);
    }

    public void supplyPuk(String string2, String string3, Message message) {
        CommandsInterface commandsInterface = this.mPhone.mCM;
        Message message2 = this.mHandler.obtainMessage(4, message);
        commandsInterface.supplyIccPuk(string2, string3, message2);
    }

    public void supplyPuk2(String string2, String string3, Message message) {
        CommandsInterface commandsInterface = this.mPhone.mCM;
        Message message2 = this.mHandler.obtainMessage(4, message);
        commandsInterface.supplyIccPuk2(string2, string3, message2);
    }

    public void unregisterForAbsent(Handler handler) {
        this.mAbsentRegistrants.remove(handler);
    }

    public void unregisterForLocked(Handler handler) {
        this.mPinLockedRegistrants.remove(handler);
    }

    public void unregisterForNetworkLocked(Handler handler) {
        this.mNetworkLockedRegistrants.remove(handler);
    }

    protected void updateStateProperty() {
        PhoneBase phoneBase = this.mPhone;
        String string2 = this.getState().toString();
        phoneBase.setSystemProperty("gsm.sim.state", string2);
    }

    public static final class State
    extends Enum<State> {
        private static final /* synthetic */ State[] $VALUES;
        public static final /* enum */ State ABSENT;
        public static final /* enum */ State NETWORK_LOCKED;
        public static final /* enum */ State NOT_READY;
        public static final /* enum */ State PIN_REQUIRED;
        public static final /* enum */ State PUK_REQUIRED;
        public static final /* enum */ State READY;
        public static final /* enum */ State UNKNOWN;

        static {
            UNKNOWN = new State();
            ABSENT = new State();
            PIN_REQUIRED = new State();
            PUK_REQUIRED = new State();
            NETWORK_LOCKED = new State();
            READY = new State();
            NOT_READY = new State();
            State state = UNKNOWN;
            State state2 = ABSENT;
            State state3 = PIN_REQUIRED;
            State state4 = PUK_REQUIRED;
            State state5 = NETWORK_LOCKED;
            State state6 = READY;
            State state7 = NOT_READY;
            State[] stateArray = new State[]{state, state2, state3, state4, state5, state6, state7};
            $VALUES = stateArray;
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isPinLocked() {
            State state = PIN_REQUIRED;
            if (this == state) return true;
            State state2 = PUK_REQUIRED;
            if (this != state2) return false;
            return true;
        }
    }
}

