/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IccConstants;
import com.android.internal.telephony.IccException;
import com.android.internal.telephony.IccFileTypeMismatch;
import com.android.internal.telephony.IccIoResult;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.PhoneBase;
import java.util.ArrayList;

public abstract class IccFileHandler
extends Handler
implements IccConstants {
    protected static final int COMMAND_GET_RESPONSE = 192;
    protected static final int COMMAND_READ_BINARY = 176;
    protected static final int COMMAND_READ_RECORD = 178;
    protected static final int COMMAND_SEEK = 162;
    protected static final int COMMAND_UPDATE_BINARY = 214;
    protected static final int COMMAND_UPDATE_RECORD = 220;
    protected static final int EF_TYPE_CYCLIC = 3;
    protected static final int EF_TYPE_LINEAR_FIXED = 1;
    protected static final int EF_TYPE_TRANSPARENT = 0;
    protected static final int EVENT_GET_BINARY_SIZE_DONE = 4;
    protected static final int EVENT_GET_EF_LINEAR_RECORD_SIZE_DONE = 8;
    protected static final int EVENT_GET_RECORD_SIZE_DONE = 6;
    protected static final int EVENT_READ_BINARY_DONE = 5;
    protected static final int EVENT_READ_ICON_DONE = 10;
    protected static final int EVENT_READ_IMG_DONE = 9;
    protected static final int EVENT_READ_RECORD_DONE = 7;
    protected static final int GET_RESPONSE_EF_IMG_SIZE_BYTES = 10;
    protected static final int GET_RESPONSE_EF_SIZE_BYTES = 15;
    protected static final int READ_RECORD_MODE_ABSOLUTE = 4;
    protected static final int RESPONSE_DATA_ACCESS_CONDITION_1 = 8;
    protected static final int RESPONSE_DATA_ACCESS_CONDITION_2 = 9;
    protected static final int RESPONSE_DATA_ACCESS_CONDITION_3 = 10;
    protected static final int RESPONSE_DATA_FILE_ID_1 = 4;
    protected static final int RESPONSE_DATA_FILE_ID_2 = 5;
    protected static final int RESPONSE_DATA_FILE_SIZE_1 = 2;
    protected static final int RESPONSE_DATA_FILE_SIZE_2 = 3;
    protected static final int RESPONSE_DATA_FILE_STATUS = 11;
    protected static final int RESPONSE_DATA_FILE_TYPE = 6;
    protected static final int RESPONSE_DATA_LENGTH = 12;
    protected static final int RESPONSE_DATA_RECORD_LENGTH = 14;
    protected static final int RESPONSE_DATA_RFU_1 = 0;
    protected static final int RESPONSE_DATA_RFU_2 = 1;
    protected static final int RESPONSE_DATA_RFU_3 = 7;
    protected static final int RESPONSE_DATA_STRUCTURE = 13;
    protected static final int TYPE_DF = 2;
    protected static final int TYPE_EF = 4;
    protected static final int TYPE_MF = 1;
    protected static final int TYPE_RFU;
    protected PhoneBase phone;

    protected IccFileHandler(PhoneBase phoneBase) {
        this.phone = phoneBase;
    }

    private void sendResult(Message message, Object object, Throwable throwable) {
        if (message == null) {
            return;
        }
        AsyncResult asyncResult = AsyncResult.forMessage(message, object, throwable);
        message.sendToTarget();
    }

    public void dispose() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getCommonIccEFPath(int n) {
        switch (n) {
            default: {
                return null;
            }
            case 28474: 
            case 28475: 
            case 28480: 
            case 28489: 
            case 28490: 
            case 28491: 
            case 28492: {
                return "3F007F10";
            }
            case 12258: {
                return "3F00";
            }
            case 20256: 
        }
        return "3F007F105F50";
    }

    public void getEFLinearRecordSize(int n, Message message) {
        LoadLinearFixedContext loadLinearFixedContext = new LoadLinearFixedContext(n, message);
        Message message2 = this.obtainMessage(8, loadLinearFixedContext);
        CommandsInterface commandsInterface = this.phone.mCM;
        String string2 = this.getEFPath(n);
        int n2 = n;
        int n3 = 0;
        String string3 = null;
        commandsInterface.iccIO(192, n2, string2, 0, n3, 15, null, string3, message2);
    }

    protected abstract String getEFPath(int var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleMessage(Message message) {
        Exception exception2;
        block32: {
            Message message2 = null;
            try {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 9: {
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        LoadLinearFixedContext loadLinearFixedContext = (LoadLinearFixedContext)asyncResult.userObj;
                        IccIoResult iccIoResult = (IccIoResult)asyncResult.result;
                        message2 = loadLinearFixedContext.onLoaded;
                        if (iccIoResult.getException() == null) {
                            return;
                        }
                        byte[] byArray = iccIoResult.payload;
                        Throwable throwable = asyncResult.exception;
                        IccFileHandler iccFileHandler = this;
                        Message message3 = message2;
                        byte[] byArray2 = byArray;
                        Throwable throwable2 = throwable;
                        iccFileHandler.sendResult(message3, byArray2, throwable2);
                        return;
                    }
                    case 10: {
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        message2 = (Message)asyncResult.userObj;
                        IccIoResult iccIoResult = (IccIoResult)asyncResult.result;
                        if (iccIoResult.getException() == null) {
                            return;
                        }
                        byte[] byArray = iccIoResult.payload;
                        Throwable throwable = asyncResult.exception;
                        IccFileHandler iccFileHandler = this;
                        Message message4 = message2;
                        byte[] byArray3 = byArray;
                        Throwable throwable3 = throwable;
                        iccFileHandler.sendResult(message4, byArray3, throwable3);
                        return;
                    }
                    case 8: {
                        byte by;
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        LoadLinearFixedContext loadLinearFixedContext = (LoadLinearFixedContext)asyncResult.userObj;
                        IccIoResult iccIoResult = (IccIoResult)asyncResult.result;
                        message2 = loadLinearFixedContext.onLoaded;
                        if (asyncResult.exception != null) {
                            Throwable throwable = asyncResult.exception;
                            IccFileHandler iccFileHandler = this;
                            Message message5 = message2;
                            Object var27_39 = null;
                            Throwable throwable4 = throwable;
                            iccFileHandler.sendResult(message5, var27_39, throwable4);
                            return;
                        }
                        IccException iccException = iccIoResult.getException();
                        if (iccException != null) {
                            IccFileHandler iccFileHandler = this;
                            Message message6 = message2;
                            Object var32_48 = null;
                            IccException iccException2 = iccException;
                            iccFileHandler.sendResult(message6, var32_48, iccException2);
                            return;
                        }
                        byte[] byArray = iccIoResult.payload;
                        byte by2 = byArray[6];
                        if (4 != by2 && 1 == (by = byArray[13])) {
                            int n;
                            int n2;
                            int n3;
                            int[] nArray = new int[3];
                            nArray[0] = n3 = byArray[14] & 0xFF;
                            int n4 = (byArray[2] & 0xFF) << 8;
                            int n5 = byArray[3] & 0xFF;
                            nArray[1] = n2 = n4 + n5;
                            int n6 = nArray[1];
                            int n7 = nArray[0];
                            nArray[2] = n = n6 / n7;
                            IccFileHandler iccFileHandler = this;
                            Message message7 = message2;
                            int[] nArray2 = nArray;
                            Throwable throwable = null;
                            iccFileHandler.sendResult(message7, nArray2, throwable);
                            return;
                        }
                        throw new IccFileTypeMismatch();
                    }
                    case 6: {
                        int n;
                        int n8;
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        LoadLinearFixedContext loadLinearFixedContext = (LoadLinearFixedContext)asyncResult.userObj;
                        IccIoResult iccIoResult = (IccIoResult)asyncResult.result;
                        message2 = loadLinearFixedContext.onLoaded;
                        if (asyncResult.exception != null) {
                            Throwable throwable = asyncResult.exception;
                            IccFileHandler iccFileHandler = this;
                            Message message8 = message2;
                            Object var53_72 = null;
                            Throwable throwable5 = throwable;
                            iccFileHandler.sendResult(message8, var53_72, throwable5);
                            return;
                        }
                        IccException iccException = iccIoResult.getException();
                        if (iccException != null) {
                            IccFileHandler iccFileHandler = this;
                            Message message9 = message2;
                            Object var57_76 = null;
                            IccException iccException3 = iccException;
                            iccFileHandler.sendResult(message9, var57_76, iccException3);
                            return;
                        }
                        byte[] byArray = iccIoResult.payload;
                        int n9 = loadLinearFixedContext.efid;
                        int n10 = loadLinearFixedContext.recordNum;
                        byte by = byArray[6];
                        if (4 != by) {
                            throw new IccFileTypeMismatch();
                        }
                        byte by3 = byArray[13];
                        if (1 != by3) {
                            throw new IccFileTypeMismatch();
                        }
                        loadLinearFixedContext.recordSize = n8 = byArray[14] & 0xFF;
                        int n11 = (byArray[2] & 0xFF) << 8;
                        int n12 = byArray[3] & 0xFF;
                        int n13 = n11 + n12;
                        int n14 = loadLinearFixedContext.recordSize;
                        loadLinearFixedContext.countRecords = n = n13 / n14;
                        if (loadLinearFixedContext.loadAll) {
                            int n15 = loadLinearFixedContext.countRecords;
                            ArrayList arrayList = new ArrayList(n15);
                            loadLinearFixedContext.results = arrayList;
                        }
                        CommandsInterface commandsInterface = this.phone.mCM;
                        int n16 = loadLinearFixedContext.efid;
                        int n17 = loadLinearFixedContext.efid;
                        IccFileHandler iccFileHandler = this;
                        int n18 = n17;
                        String string2 = iccFileHandler.getEFPath(n18);
                        int n19 = loadLinearFixedContext.recordNum;
                        int n20 = loadLinearFixedContext.recordSize;
                        IccFileHandler iccFileHandler2 = this;
                        int n21 = 7;
                        LoadLinearFixedContext loadLinearFixedContext2 = loadLinearFixedContext;
                        Message message10 = iccFileHandler2.obtainMessage(n21, loadLinearFixedContext2);
                        commandsInterface.iccIO(178, n16, string2, n19, 4, n20, null, null, message10);
                        return;
                    }
                    case 4: {
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        message2 = (Message)asyncResult.userObj;
                        IccIoResult iccIoResult = (IccIoResult)asyncResult.result;
                        if (asyncResult.exception != null) {
                            Throwable throwable = asyncResult.exception;
                            IccFileHandler iccFileHandler = this;
                            Message message11 = message2;
                            Object var86_105 = null;
                            Throwable throwable6 = throwable;
                            iccFileHandler.sendResult(message11, var86_105, throwable6);
                            return;
                        }
                        IccException iccException = iccIoResult.getException();
                        if (iccException != null) {
                            IccFileHandler iccFileHandler = this;
                            Message message12 = message2;
                            Object var90_109 = null;
                            IccException iccException4 = iccException;
                            iccFileHandler.sendResult(message12, var90_109, iccException4);
                            return;
                        }
                        byte[] byArray = iccIoResult.payload;
                        int n = message.arg1;
                        byte by = byArray[6];
                        if (4 != by) {
                            throw new IccFileTypeMismatch();
                        }
                        if (byArray[13] != null) {
                            throw new IccFileTypeMismatch();
                        }
                        int n22 = (byArray[2] & 0xFF) << 8;
                        int n23 = byArray[3] & 0xFF;
                        int n24 = n22 + n23;
                        CommandsInterface commandsInterface = this.phone.mCM;
                        IccFileHandler iccFileHandler = this;
                        int n25 = n;
                        String string3 = iccFileHandler.getEFPath(n25);
                        IccFileHandler iccFileHandler3 = this;
                        int n26 = 5;
                        int n27 = n;
                        int n28 = 0;
                        Message message13 = message2;
                        Message message14 = iccFileHandler3.obtainMessage(n26, n27, n28, message13);
                        commandsInterface.iccIO(176, n, string3, 0, 0, n24, null, null, message14);
                        return;
                    }
                    case 7: {
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        LoadLinearFixedContext loadLinearFixedContext = (LoadLinearFixedContext)asyncResult.userObj;
                        IccIoResult iccIoResult = (IccIoResult)asyncResult.result;
                        message2 = loadLinearFixedContext.onLoaded;
                        if (asyncResult.exception != null) {
                            Throwable throwable = asyncResult.exception;
                            IccFileHandler iccFileHandler = this;
                            Message message15 = message2;
                            Object var110_129 = null;
                            Throwable throwable7 = throwable;
                            iccFileHandler.sendResult(message15, var110_129, throwable7);
                            return;
                        }
                        IccException iccException = iccIoResult.getException();
                        if (iccException != null) {
                            IccFileHandler iccFileHandler = this;
                            Message message16 = message2;
                            Object var114_133 = null;
                            IccException iccException5 = iccException;
                            iccFileHandler.sendResult(message16, var114_133, iccException5);
                            return;
                        }
                        if (!loadLinearFixedContext.loadAll) {
                            byte[] byArray = iccIoResult.payload;
                            IccFileHandler iccFileHandler = this;
                            Message message17 = message2;
                            byte[] byArray4 = byArray;
                            Throwable throwable = null;
                            iccFileHandler.sendResult(message17, byArray4, throwable);
                            return;
                        }
                        ArrayList<byte[]> arrayList = loadLinearFixedContext.results;
                        byte[] byArray = iccIoResult.payload;
                        boolean bl = arrayList.add(byArray);
                        int n = loadLinearFixedContext.recordNum + 1;
                        loadLinearFixedContext.recordNum = n;
                        int n29 = loadLinearFixedContext.recordNum;
                        int n30 = loadLinearFixedContext.countRecords;
                        if (n29 > n30) {
                            ArrayList<byte[]> arrayList2 = loadLinearFixedContext.results;
                            IccFileHandler iccFileHandler = this;
                            Message message18 = message2;
                            ArrayList<byte[]> arrayList3 = arrayList2;
                            Throwable throwable = null;
                            iccFileHandler.sendResult(message18, arrayList3, throwable);
                            return;
                        }
                        CommandsInterface commandsInterface = this.phone.mCM;
                        int n31 = loadLinearFixedContext.efid;
                        int n32 = loadLinearFixedContext.efid;
                        IccFileHandler iccFileHandler = this;
                        int n33 = n32;
                        String string4 = iccFileHandler.getEFPath(n33);
                        int n34 = loadLinearFixedContext.recordNum;
                        int n35 = loadLinearFixedContext.recordSize;
                        IccFileHandler iccFileHandler4 = this;
                        int n36 = 7;
                        LoadLinearFixedContext loadLinearFixedContext3 = loadLinearFixedContext;
                        Message message19 = iccFileHandler4.obtainMessage(n36, loadLinearFixedContext3);
                        commandsInterface.iccIO(178, n31, string4, n34, 4, n35, null, null, message19);
                        return;
                    }
                    case 5: 
                }
                AsyncResult asyncResult = (AsyncResult)message.obj;
                message2 = (Message)asyncResult.userObj;
                IccIoResult iccIoResult = (IccIoResult)asyncResult.result;
                if (asyncResult.exception != null) {
                    Throwable throwable = asyncResult.exception;
                    IccFileHandler iccFileHandler = this;
                    Message message20 = message2;
                    Object var147_166 = null;
                    Throwable throwable8 = throwable;
                    iccFileHandler.sendResult(message20, var147_166, throwable8);
                    return;
                }
                IccException iccException = iccIoResult.getException();
                if (iccException != null) {
                    IccFileHandler iccFileHandler = this;
                    Message message21 = message2;
                    Object var151_170 = null;
                    IccException iccException6 = iccException;
                    iccFileHandler.sendResult(message21, var151_170, iccException6);
                    return;
                }
                byte[] byArray = iccIoResult.payload;
                IccFileHandler iccFileHandler = this;
                Message message22 = message2;
                byte[] byArray5 = byArray;
                Throwable throwable = null;
                iccFileHandler.sendResult(message22, byArray5, throwable);
                return;
            }
            catch (Exception exception2) {
                if (message2 == null) break block32;
                IccFileHandler iccFileHandler = this;
                Message message23 = message2;
                Object var15_27 = null;
                Exception exception3 = exception2;
                iccFileHandler.sendResult(message23, var15_27, exception3);
                return;
            }
        }
        StringBuilder stringBuilder = new StringBuilder().append("uncaught exception");
        Exception exception4 = exception2;
        String string5 = stringBuilder.append(exception4).toString();
        IccFileHandler iccFileHandler = this;
        String string6 = string5;
        iccFileHandler.loge(string6);
    }

    public void loadEFImgLinearFixed(int n, Message message) {
        LoadLinearFixedContext loadLinearFixedContext = new LoadLinearFixedContext(20256, n, message);
        Message message2 = this.obtainMessage(9, loadLinearFixedContext);
        CommandsInterface commandsInterface = this.phone.mCM;
        int n2 = n;
        String string2 = null;
        commandsInterface.iccIO(192, 20256, "img", n2, 4, 10, null, string2, message2);
    }

    public void loadEFImgTransparent(int n, int n2, int n3, int n4, Message message) {
        Message message2 = this.obtainMessage(10, n, 0, message);
        CommandsInterface commandsInterface = this.phone.mCM;
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        String string2 = null;
        commandsInterface.iccIO(176, n5, "img", n6, n7, n8, null, string2, message2);
    }

    public void loadEFLinearFixed(int n, int n2, Message message) {
        LoadLinearFixedContext loadLinearFixedContext = new LoadLinearFixedContext(n, n2, message);
        Message message2 = this.obtainMessage(6, loadLinearFixedContext);
        CommandsInterface commandsInterface = this.phone.mCM;
        String string2 = this.getEFPath(n);
        int n3 = n;
        int n4 = 0;
        String string3 = null;
        commandsInterface.iccIO(192, n3, string2, 0, n4, 15, null, string3, message2);
    }

    public void loadEFLinearFixedAll(int n, Message message) {
        LoadLinearFixedContext loadLinearFixedContext = new LoadLinearFixedContext(n, message);
        Message message2 = this.obtainMessage(6, loadLinearFixedContext);
        CommandsInterface commandsInterface = this.phone.mCM;
        String string2 = this.getEFPath(n);
        int n2 = n;
        int n3 = 0;
        String string3 = null;
        commandsInterface.iccIO(192, n2, string2, 0, n3, 15, null, string3, message2);
    }

    public void loadEFTransparent(int n, Message message) {
        Message message2 = this.obtainMessage(4, n, 0, message);
        CommandsInterface commandsInterface = this.phone.mCM;
        String string2 = this.getEFPath(n);
        int n2 = n;
        int n3 = 0;
        String string3 = null;
        commandsInterface.iccIO(192, n2, string2, 0, n3, 15, null, string3, message2);
    }

    protected abstract void logd(String var1);

    protected abstract void loge(String var1);

    public void updateEFLinearFixed(int n, int n2, byte[] byArray, String string2, Message message) {
        CommandsInterface commandsInterface = this.phone.mCM;
        String string3 = this.getEFPath(n);
        int n3 = byArray.length;
        String string4 = IccUtils.bytesToHexString(byArray);
        int n4 = n;
        int n5 = n2;
        String string5 = string2;
        Message message2 = message;
        commandsInterface.iccIO(220, n4, string3, n5, 4, n3, string4, string5, message2);
    }

    public void updateEFTransparent(int n, byte[] byArray, Message message) {
        CommandsInterface commandsInterface = this.phone.mCM;
        String string2 = this.getEFPath(n);
        int n2 = byArray.length;
        String string3 = IccUtils.bytesToHexString(byArray);
        int n3 = n;
        int n4 = 0;
        Message message2 = message;
        commandsInterface.iccIO(214, n3, string2, 0, n4, n2, string3, null, message2);
    }

    static class LoadLinearFixedContext {
        int countRecords;
        int efid;
        boolean loadAll;
        Message onLoaded;
        int recordNum;
        int recordSize;
        ArrayList<byte[]> results;

        LoadLinearFixedContext(int n, int n2, Message message) {
            this.efid = n;
            this.recordNum = n2;
            this.onLoaded = message;
            this.loadAll = false;
        }

        LoadLinearFixedContext(int n, Message message) {
            this.efid = n;
            this.recordNum = 1;
            this.loadAll = true;
            this.onLoaded = message;
        }
    }
}

