/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ServiceManager;
import com.android.internal.telephony.AdnRecord;
import com.android.internal.telephony.AdnRecordCache;
import com.android.internal.telephony.IIccPhoneBook;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccCardApplication;
import com.android.internal.telephony.PhoneBase;
import java.util.List;

public abstract class IccPhoneBookInterfaceManager
extends IIccPhoneBook.Stub {
    protected static final boolean ALLOW_SIM_OP_IN_UI_THREAD = false;
    protected static final boolean DBG = true;
    protected static final int EVENT_GET_SIZE_DONE = 1;
    protected static final int EVENT_LOAD_DONE = 2;
    protected static final int EVENT_UPDATE_DONE = 3;
    protected AdnRecordCache adnCache;
    protected Handler mBaseHandler;
    protected final Object mLock;
    protected PhoneBase phone;
    protected int[] recordSize;
    protected List<AdnRecord> records;
    protected boolean success;

    public IccPhoneBookInterfaceManager(PhoneBase phoneBase) {
        Handler handler;
        Object object;
        this.mLock = object = new Object();
        this.mBaseHandler = handler = new Handler(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 1: {
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        Object object = IccPhoneBookInterfaceManager.this.mLock;
                        synchronized (object) {
                            if (asyncResult.exception == null) {
                                IccPhoneBookInterfaceManager iccPhoneBookInterfaceManager = IccPhoneBookInterfaceManager.this;
                                int[] nArray = (int[])asyncResult.result;
                                iccPhoneBookInterfaceManager.recordSize = nArray;
                                IccPhoneBookInterfaceManager iccPhoneBookInterfaceManager2 = IccPhoneBookInterfaceManager.this;
                                StringBuilder stringBuilder = new StringBuilder().append("GET_RECORD_SIZE Size ");
                                int n = IccPhoneBookInterfaceManager.this.recordSize[0];
                                StringBuilder stringBuilder2 = stringBuilder.append(n).append(" total ");
                                int n2 = IccPhoneBookInterfaceManager.this.recordSize[1];
                                StringBuilder stringBuilder3 = stringBuilder2.append(n2).append(" #record ");
                                int n3 = IccPhoneBookInterfaceManager.this.recordSize[2];
                                String string2 = stringBuilder3.append(n3).toString();
                                iccPhoneBookInterfaceManager2.logd(string2);
                                IccPhoneBookInterfaceManager.this.mLock.notifyAll();
                            }
                            return;
                        }
                    }
                    case 3: {
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        Object object = IccPhoneBookInterfaceManager.this.mLock;
                        synchronized (object) {
                            IccPhoneBookInterfaceManager iccPhoneBookInterfaceManager = IccPhoneBookInterfaceManager.this;
                            boolean bl = asyncResult.exception == null;
                            iccPhoneBookInterfaceManager.success = bl;
                            IccPhoneBookInterfaceManager.this.mLock.notifyAll();
                            return;
                        }
                    }
                    case 2: 
                }
                AsyncResult asyncResult = (AsyncResult)message.obj;
                Object object = IccPhoneBookInterfaceManager.this.mLock;
                synchronized (object) {
                    if (asyncResult.exception == null) {
                        List list;
                        IccPhoneBookInterfaceManager iccPhoneBookInterfaceManager = IccPhoneBookInterfaceManager.this;
                        iccPhoneBookInterfaceManager.records = list = (List)asyncResult.result;
                    } else {
                        IccPhoneBookInterfaceManager.this.logd("Cannot load ADN records");
                        if (IccPhoneBookInterfaceManager.this.records != null) {
                            IccPhoneBookInterfaceManager.this.records.clear();
                        }
                    }
                    IccPhoneBookInterfaceManager.this.mLock.notifyAll();
                    return;
                }
            }
        };
        this.phone = phoneBase;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int updateEfForIccType(int n) {
        IccCardApplication.AppType appType;
        if (n != 28474) return n;
        IccCard iccCard = this.phone.getIccCard();
        if (!iccCard.isApplicationOnIcc(appType = IccCardApplication.AppType.APPTYPE_USIM)) return n;
        return 20272;
    }

    protected void checkThread() {
        Looper looper;
        Looper looper2 = this.mBaseHandler.getLooper();
        if (!looper2.equals(looper = Looper.myLooper())) {
            return;
        }
        this.loge("query() called on the main UI thread!");
        throw new IllegalStateException("You cannot call query on this provder from the main UI thread.");
    }

    public void dispose() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<AdnRecord> getAdnRecordsInEf(int n) {
        if (this.phone.getContext().checkCallingOrSelfPermission("android.permission.READ_CONTACTS") != 0) {
            throw new SecurityException("Requires android.permission.READ_CONTACTS permission");
        }
        int n2 = this.updateEfForIccType(n);
        String string2 = "getAdnRecordsInEF: efid=" + n2;
        this.logd(string2);
        Object object = this.mLock;
        synchronized (object) {
            this.checkThread();
            Message message = this.mBaseHandler.obtainMessage(2);
            AdnRecordCache adnRecordCache = this.adnCache;
            int n3 = this.adnCache.extensionEfForEf(n2);
            adnRecordCache.requestLoadAllAdnLike(n2, n3, message);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException interruptedException) {
                this.logd("interrupted while trying to load from the SIM");
            }
            return this.records;
        }
    }

    @Override
    public abstract int[] getAdnRecordsSize(int var1);

    protected abstract void logd(String var1);

    protected abstract void loge(String var1);

    protected void publish() {
        ServiceManager.addService("simphonebook", this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean updateAdnRecordsInEfByIndex(int n, String string2, String string3, int n2, String string4) {
        if (this.phone.getContext().checkCallingOrSelfPermission("android.permission.WRITE_CONTACTS") != 0) {
            throw new SecurityException("Requires android.permission.WRITE_CONTACTS permission");
        }
        String string5 = "updateAdnRecordsInEfByIndex: efid=" + n + " Index=" + n2 + " ==> " + "(" + string2 + "," + string3 + ")" + " pin2=" + string4;
        this.logd(string5);
        Object object = this.mLock;
        synchronized (object) {
            this.checkThread();
            this.success = false;
            Message message = this.mBaseHandler.obtainMessage(3);
            AdnRecord adnRecord = new AdnRecord(string2, string3);
            AdnRecordCache adnRecordCache = this.adnCache;
            int n3 = n;
            int n4 = n2;
            String string6 = string4;
            adnRecordCache.updateAdnByIndex(n3, adnRecord, n4, string6, message);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException interruptedException) {
                this.logd("interrupted while trying to update by index");
            }
            return this.success;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean updateAdnRecordsInEfBySearch(int n, String string2, String string3, String string4, String string5, String string6) {
        if (this.phone.getContext().checkCallingOrSelfPermission("android.permission.WRITE_CONTACTS") != 0) {
            throw new SecurityException("Requires android.permission.WRITE_CONTACTS permission");
        }
        String string7 = "updateAdnRecordsInEfBySearch: efid=" + n + " (" + string2 + "," + string3 + ")" + "==>" + " (" + string4 + "," + string5 + ")" + " pin2=" + string6;
        this.logd(string7);
        Object object = this.mLock;
        synchronized (object) {
            this.checkThread();
            this.success = false;
            Message message = this.mBaseHandler.obtainMessage(3);
            AdnRecord adnRecord = new AdnRecord(string2, string3);
            AdnRecord adnRecord2 = new AdnRecord(string4, string5);
            AdnRecordCache adnRecordCache = this.adnCache;
            int n2 = n;
            String string8 = string6;
            adnRecordCache.updateAdnBySearch(n2, adnRecord, adnRecord2, string8, message);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException interruptedException) {
                this.logd("interrupted while trying to update by search");
            }
            return this.success;
        }
    }
}

