/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.net.Uri;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.AdnRecord;
import com.android.internal.telephony.ArrayListCursor;
import com.android.internal.telephony.IIccPhoneBook;
import java.util.ArrayList;
import java.util.List;

public class IccProvider
extends ContentProvider {
    private static final String[] ADDRESS_BOOK_COLUMN_NAMES;
    private static final int ADN = 1;
    private static final boolean DBG = false;
    private static final int FDN = 2;
    private static final int SDN = 3;
    private static final String STR_EMAILS = "emails";
    private static final String STR_NUMBER = "number";
    private static final String STR_PIN2 = "pin2";
    private static final String STR_TAG = "tag";
    private static final String TAG = "IccProvider";
    private static final UriMatcher URL_MATCHER;
    private boolean mSimulator;

    static {
        String[] stringArray = new String[]{"name", STR_NUMBER, STR_EMAILS};
        ADDRESS_BOOK_COLUMN_NAMES = stringArray;
        URL_MATCHER = new UriMatcher(-1);
        URL_MATCHER.addURI("icc", "adn", 1);
        URL_MATCHER.addURI("icc", "fdn", 2);
        URL_MATCHER.addURI("icc", "sdn", 3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean addIccRecordToEf(int n, String string2, String string3, String[] stringArray, String string4) {
        boolean bl = false;
        try {
            IIccPhoneBook iIccPhoneBook = IIccPhoneBook.Stub.asInterface(ServiceManager.getService("simphonebook"));
            if (iIccPhoneBook == null) return bl;
            int n2 = n;
            String string5 = string2;
            String string6 = string3;
            String string7 = string4;
            boolean bl2 = iIccPhoneBook.updateAdnRecordsInEfBySearch(n2, "", "", string5, string6, string7);
            return bl2;
        }
        catch (SecurityException securityException) {
            return bl;
        }
        catch (RemoteException remoteException) {
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean deleteIccRecordFromEf(int n, String string2, String string3, String[] stringArray, String string4) {
        boolean bl = false;
        try {
            IIccPhoneBook iIccPhoneBook = IIccPhoneBook.Stub.asInterface(ServiceManager.getService("simphonebook"));
            if (iIccPhoneBook == null) return bl;
            int n2 = n;
            String string5 = string2;
            String string6 = string3;
            String string7 = string4;
            boolean bl2 = iIccPhoneBook.updateAdnRecordsInEfBySearch(n2, string5, string6, "", "", string7);
            return bl2;
        }
        catch (SecurityException securityException) {
            return bl;
        }
        catch (RemoteException remoteException) {
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList<ArrayList> loadFromEf(int n) {
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        List<AdnRecord> list = null;
        try {
            IIccPhoneBook iIccPhoneBook = IIccPhoneBook.Stub.asInterface(ServiceManager.getService("simphonebook"));
            if (iIccPhoneBook != null) {
                List<AdnRecord> list2;
                list = list2 = iIccPhoneBook.getAdnRecordsInEf(n);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (RemoteException remoteException) {}
        if (list != null) {
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                AdnRecord adnRecord = list.get(i);
                this.loadRecord(adnRecord, arrayList);
            }
            return arrayList;
        } else {
            int n3 = Log.w(TAG, "Cannot load ADN records");
            arrayList.clear();
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void loadRecord(AdnRecord adnRecord, ArrayList<ArrayList> arrayList) {
        if (adnRecord.isEmpty()) {
            return;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string2 = adnRecord.getAlphaTag();
        String string3 = adnRecord.getNumber();
        String[] stringArray = adnRecord.getEmails();
        boolean bl = arrayList2.add(string2);
        boolean bl2 = arrayList2.add(string3);
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray != null) {
            for (String string4 : stringArray) {
                StringBuilder stringBuilder2 = stringBuilder.append(string4);
                StringBuilder stringBuilder3 = stringBuilder.append(",");
            }
            String string5 = stringBuilder.toString();
            boolean bl3 = arrayList2.add(string5);
        } else {
            boolean bl4 = arrayList2.add(null);
        }
        boolean bl5 = arrayList.add(arrayList2);
    }

    private void log(String string2) {
        String string3 = "[IccProvider] " + string2;
        int n = Log.d(TAG, string3);
    }

    private String normalizeValue(String string2) {
        int n;
        int n2 = string2.length();
        String string3 = string2;
        if (string2.charAt(0) == '\'' && string2.charAt(n = n2 - 1) == '\'') {
            int n3 = n2 - 1;
            string3 = string2.substring(1, n3);
        }
        return string3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean updateIccRecordInEf(int n, String string2, String string3, String string4, String string5, String string6) {
        boolean bl = false;
        try {
            IIccPhoneBook iIccPhoneBook = IIccPhoneBook.Stub.asInterface(ServiceManager.getService("simphonebook"));
            if (iIccPhoneBook == null) return bl;
            int n2 = n;
            String string7 = string2;
            String string8 = string3;
            String string9 = string4;
            String string10 = string5;
            String string11 = string6;
            boolean bl2 = iIccPhoneBook.updateAdnRecordsInEfBySearch(n2, string7, string8, string9, string10, string11);
            return bl2;
        }
        catch (SecurityException securityException) {
            return bl;
        }
        catch (RemoteException remoteException) {
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int delete(Uri uri, String string2, String[] stringArray) {
        int n;
        UriMatcher uriMatcher = URL_MATCHER;
        Uri uri2 = uri;
        switch (uriMatcher.match(uri2)) {
            default: {
                StringBuilder stringBuilder = new StringBuilder().append("Cannot insert into URL: ");
                Uri uri3 = uri;
                String string3 = stringBuilder.append(uri3).toString();
                throw new UnsupportedOperationException(string3);
            }
            case 1: {
                n = 28474;
                break;
            }
            case 2: {
                n = 28475;
            }
        }
        String string4 = null;
        String string5 = null;
        Object var12_12 = null;
        String string6 = null;
        String string7 = string2;
        String string8 = "AND";
        String[] stringArray2 = string7.split(string8);
        int n2 = stringArray2.length;
        while ((n2 += -1) >= 0) {
            String string9 = stringArray2[n2];
            String[] stringArray3 = string9.split("=");
            if (stringArray3.length != 2) {
                String string10 = "resolve: bad whereClause parameter: " + string9;
                int n3 = Log.e(TAG, string10);
                continue;
            }
            String string11 = stringArray3[0].trim();
            String string12 = stringArray3[1].trim();
            if (STR_TAG.equals(string11)) {
                IccProvider iccProvider = this;
                String string13 = string12;
                string4 = iccProvider.normalizeValue(string13);
                continue;
            }
            if (STR_NUMBER.equals(string11)) {
                IccProvider iccProvider = this;
                String string14 = string12;
                string5 = iccProvider.normalizeValue(string14);
                continue;
            }
            if (STR_EMAILS.equals(string11)) {
                var12_12 = null;
                continue;
            }
            if (!STR_PIN2.equals(string11)) continue;
            IccProvider iccProvider = this;
            String string15 = string12;
            string6 = iccProvider.normalizeValue(string15);
        }
        if (TextUtils.isEmpty(string5)) {
            return 0;
        }
        if (n == 28475 && TextUtils.isEmpty(string6)) {
            return 0;
        }
        if (this.deleteIccRecordFromEf(n, string4, string5, var12_12, string6)) return 1;
        return 0;
    }

    @Override
    public String getType(Uri uri) {
        switch (URL_MATCHER.match(uri)) {
            default: {
                String string2 = "Unknown URL " + uri;
                throw new IllegalArgumentException(string2);
            }
            case 1: 
            case 2: 
            case 3: 
        }
        return "vnd.android.cursor.dir/sim-contact";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Uri insert(Uri uri, ContentValues contentValues) {
        String string2;
        String string3;
        int n;
        String string4 = null;
        int n2 = URL_MATCHER.match(uri);
        switch (n2) {
            default: {
                String string5 = "Cannot insert into URL: " + uri;
                throw new UnsupportedOperationException(string5);
            }
            case 1: {
                n = 28474;
                break;
            }
            case 2: {
                n = 28475;
                string4 = contentValues.getAsString(STR_PIN2);
            }
        }
        if (!this.addIccRecordToEf(n, string3 = contentValues.getAsString(STR_TAG), string2 = contentValues.getAsString(STR_NUMBER), null, string4)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("content://icc/");
        switch (n2) {
            case 1: {
                StringBuilder stringBuilder2 = stringBuilder.append("adn/");
            }
            default: {
                break;
            }
            case 2: {
                StringBuilder stringBuilder3 = stringBuilder.append("fdn/");
            }
        }
        StringBuilder stringBuilder4 = stringBuilder.append(0);
        return Uri.parse(stringBuilder.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onCreate() {
        if (!TextUtils.isEmpty(SystemProperties.get("ro.product.device"))) {
            this.mSimulator = false;
            return true;
        }
        this.mSimulator = true;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        ArrayList<ArrayList> arrayList;
        if (!this.mSimulator) {
            switch (URL_MATCHER.match(uri)) {
                default: {
                    String string4 = "Unknown URL " + uri;
                    throw new IllegalArgumentException(string4);
                }
                case 1: {
                    arrayList = this.loadFromEf(28474);
                    break;
                }
                case 2: {
                    arrayList = this.loadFromEf(28475);
                    break;
                }
                case 3: {
                    arrayList = this.loadFromEf(28489);
                    break;
                }
            }
        } else {
            arrayList = new ArrayList(4);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            boolean bl = arrayList2.add("Ron Stevens/H");
            boolean bl2 = arrayList2.add("512-555-5038");
            boolean bl3 = arrayList.add(arrayList2);
            ArrayList<String> arrayList3 = new ArrayList<String>();
            boolean bl4 = arrayList3.add("Ron Stevens/M");
            boolean bl5 = arrayList3.add("512-555-8305");
            boolean bl6 = arrayList.add(arrayList3);
            ArrayList<String> arrayList4 = new ArrayList<String>();
            boolean bl7 = arrayList4.add("Melissa Owens");
            boolean bl8 = arrayList4.add("512-555-8305");
            boolean bl9 = arrayList.add(arrayList4);
            ArrayList<String> arrayList5 = new ArrayList<String>();
            boolean bl10 = arrayList5.add("Directory Assistence");
            boolean bl11 = arrayList5.add("411");
            boolean bl12 = arrayList.add(arrayList5);
        }
        String[] stringArray3 = ADDRESS_BOOK_COLUMN_NAMES;
        return new ArrayListCursor(stringArray3, arrayList);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        String string3;
        String string4;
        String string5;
        String string6;
        int n;
        String string7 = null;
        switch (URL_MATCHER.match(uri)) {
            default: {
                String string8 = "Cannot insert into URL: " + uri;
                throw new UnsupportedOperationException(string8);
            }
            case 1: {
                n = 28474;
                break;
            }
            case 2: {
                n = 28475;
                string7 = contentValues.getAsString(STR_PIN2);
            }
        }
        if (this.updateIccRecordInEf(n, string6 = contentValues.getAsString(STR_TAG), string5 = contentValues.getAsString(STR_NUMBER), string4 = contentValues.getAsString("newTag"), string3 = contentValues.getAsString("newNumber"), string7)) return 1;
        return 0;
    }
}

