/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import com.android.internal.telephony.AdnRecord;
import com.android.internal.telephony.AdnRecordCache;
import com.android.internal.telephony.AdnRecordLoader;
import com.android.internal.telephony.IccConstants;
import com.android.internal.telephony.PhoneBase;

public abstract class IccRecords
extends Handler
implements IccConstants {
    protected static final boolean DBG = true;
    protected static final int EVENT_SET_MSISDN_DONE = 30;
    protected static final int SPN_RULE_SHOW_PLMN = 2;
    protected static final int SPN_RULE_SHOW_SPN = 1;
    protected static final int UNINITIALIZED = 255;
    protected static final int UNKNOWN;
    protected AdnRecordCache adnCache;
    protected int countVoiceMessages;
    public String iccid;
    protected boolean isVoiceMailFixed;
    protected int mailboxIndex;
    protected int mncLength;
    protected String msisdn;
    protected String msisdnTag;
    protected String newVoiceMailNum;
    protected String newVoiceMailTag;
    protected PhoneBase phone;
    protected RegistrantList recordsLoadedRegistrants;
    protected boolean recordsRequested;
    protected int recordsToLoad;
    protected String spn;
    protected int spnDisplayCondition;
    protected String voiceMailNum;
    protected String voiceMailTag;

    public IccRecords(PhoneBase phoneBase) {
        RegistrantList registrantList;
        this.recordsLoadedRegistrants = registrantList = new RegistrantList();
        this.recordsRequested = false;
        this.msisdn = null;
        this.msisdnTag = null;
        this.voiceMailNum = null;
        this.voiceMailTag = null;
        this.newVoiceMailNum = null;
        this.newVoiceMailTag = null;
        this.isVoiceMailFixed = false;
        this.countVoiceMessages = 0;
        this.mncLength = -1;
        this.mailboxIndex = 0;
        this.phone = phoneBase;
    }

    public AdnRecordCache getAdnCache() {
        return this.adnCache;
    }

    protected abstract int getDisplayRule(String var1);

    public String getMsisdnAlphaTag() {
        return this.msisdnTag;
    }

    public String getMsisdnNumber() {
        return this.msisdn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getRecordsLoaded() {
        if (this.recordsToLoad != 0) return false;
        if (!this.recordsRequested) return false;
        return true;
    }

    public String getServiceProviderName() {
        return this.spn;
    }

    public String getVoiceMailAlphaTag() {
        return this.voiceMailTag;
    }

    public String getVoiceMailNumber() {
        return this.voiceMailNum;
    }

    public int getVoiceMessageCount() {
        return this.countVoiceMessages;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getVoiceMessageWaiting() {
        if (this.countVoiceMessages == 0) return false;
        return true;
    }

    @Override
    public abstract void handleMessage(Message var1);

    protected abstract void log(String var1);

    protected abstract void onAllRecordsLoaded();

    protected abstract void onRadioOffOrNotAvailable();

    protected abstract void onRecordLoaded();

    public abstract void onRefresh(boolean var1, int[] var2);

    public void registerForRecordsLoaded(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.recordsLoadedRegistrants.add(registrant);
        if (this.recordsToLoad != 0) {
            return;
        }
        if (!this.recordsRequested) {
            return;
        }
        AsyncResult asyncResult = new AsyncResult(null, null, null);
        registrant.notifyRegistrant(asyncResult);
    }

    public void setMsisdnNumber(String string2, String string3, Message message) {
        this.msisdn = string3;
        this.msisdnTag = string2;
        StringBuilder stringBuilder = new StringBuilder().append("Set MSISDN: ");
        String string4 = this.msisdnTag;
        StringBuilder stringBuilder2 = stringBuilder.append(string4).append(" ");
        String string5 = this.msisdn;
        String string6 = stringBuilder2.append(string5).toString();
        this.log(string6);
        String string7 = this.msisdnTag;
        String string8 = this.msisdn;
        AdnRecord adnRecord = new AdnRecord(string7, string8);
        PhoneBase phoneBase = this.phone;
        AdnRecordLoader adnRecordLoader = new AdnRecordLoader(phoneBase);
        Message message2 = this.obtainMessage(30, message);
        adnRecordLoader.updateEF(adnRecord, 28480, 28490, 1, null, message2);
    }

    public abstract void setVoiceMailNumber(String var1, String var2, Message var3);

    public abstract void setVoiceMessageWaiting(int var1, int var2);

    public void unregisterForRecordsLoaded(Handler handler) {
        this.recordsLoadedRegistrants.remove(handler);
    }
}

