/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.PendingIntent;
import android.content.Context;
import android.util.Log;
import com.android.internal.telephony.ISms;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsRawData;
import com.android.internal.util.HexDump;
import java.util.ArrayList;
import java.util.List;

public abstract class IccSmsInterfaceManager
extends ISms.Stub {
    protected Context mContext;
    protected SMSDispatcher mDispatcher;
    protected PhoneBase mPhone;

    protected IccSmsInterfaceManager(PhoneBase phoneBase) {
        Context context;
        this.mPhone = phoneBase;
        this.mContext = context = phoneBase.getContext();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected ArrayList<SmsRawData> buildValidRawData(ArrayList<byte[]> arrayList) {
        int n = arrayList.size();
        ArrayList<SmsRawData> arrayList2 = new ArrayList<SmsRawData>(n);
        int n2 = 0;
        while (n2 < n) {
            if (arrayList.get(n2)[0] == null) {
                boolean bl = arrayList2.add(null);
            } else {
                byte[] byArray = arrayList.get(n2);
                SmsRawData smsRawData = new SmsRawData(byArray);
                boolean bl = arrayList2.add(smsRawData);
            }
            ++n2;
        }
        return arrayList2;
    }

    protected void enforceReceiveAndSend(String string2) {
        this.mContext.enforceCallingPermission("android.permission.RECEIVE_SMS", string2);
        this.mContext.enforceCallingPermission("android.permission.SEND_SMS", string2);
    }

    protected abstract void log(String var1);

    protected byte[] makeSmsRecordData(int n, byte[] byArray) {
        byte by;
        byte[] byArray2 = new byte[176];
        byArray2[0] = by = (byte)(n & 7);
        int n2 = byArray.length;
        System.arraycopy(byArray, 0, byArray2, 1, n2);
        for (int i = byArray.length + 1; i < 176; ++i) {
            byArray2[i] = -1;
        }
        return byArray2;
    }

    @Override
    public void sendData(String string2, String string3, int n, byte[] byArray, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        this.mPhone.getContext().enforceCallingPermission("android.permission.SEND_SMS", "Sending SMS message");
        if (Log.isLoggable("SMS", 2)) {
            StringBuilder stringBuilder = new StringBuilder().append("sendData: destAddr=").append(string2).append(" scAddr=").append(string3).append(" destPort=").append(n).append(" data='");
            String string4 = HexDump.toHexString(byArray);
            String string5 = stringBuilder.append(string4).append("' sentIntent=").append(pendingIntent).append(" deliveryIntent=").append(pendingIntent2).toString();
            this.log(string5);
        }
        SMSDispatcher sMSDispatcher = this.mDispatcher;
        String string6 = string2;
        String string7 = string3;
        int n2 = n;
        byte[] byArray2 = byArray;
        PendingIntent pendingIntent3 = pendingIntent;
        PendingIntent pendingIntent4 = pendingIntent2;
        sMSDispatcher.sendData(string6, string7, n2, byArray2, pendingIntent3, pendingIntent4);
    }

    @Override
    public void sendMultipartText(String string2, String string3, List<String> list, List<PendingIntent> list2, List<PendingIntent> list3) {
        this.mPhone.getContext().enforceCallingPermission("android.permission.SEND_SMS", "Sending SMS message");
        if (Log.isLoggable("SMS", 2)) {
            int n = 0;
            for (String string4 : list) {
                StringBuilder stringBuilder = new StringBuilder().append("sendMultipartText: destAddr=").append(string2).append(", srAddr=").append(string3).append(", part[");
                int n2 = n + 1;
                String string5 = stringBuilder.append(n).append("]=").append(string4).toString();
                this.log(string5);
                n = n2;
            }
        }
        SMSDispatcher sMSDispatcher = this.mDispatcher;
        ArrayList arrayList = (ArrayList)list;
        ArrayList arrayList2 = (ArrayList)list2;
        ArrayList arrayList3 = (ArrayList)list3;
        String string6 = string2;
        String string7 = string3;
        sMSDispatcher.sendMultipartText(string6, string7, arrayList, arrayList2, arrayList3);
    }

    @Override
    public void sendText(String string2, String string3, String string4, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        this.mPhone.getContext().enforceCallingPermission("android.permission.SEND_SMS", "Sending SMS message");
        if (Log.isLoggable("SMS", 2)) {
            String string5 = "sendText: destAddr=" + string2 + " scAddr=" + string3 + " text='" + string4 + "' sentIntent=" + pendingIntent + " deliveryIntent=" + pendingIntent2;
            this.log(string5);
        }
        SMSDispatcher sMSDispatcher = this.mDispatcher;
        String string6 = string2;
        String string7 = string3;
        String string8 = string4;
        PendingIntent pendingIntent3 = pendingIntent;
        PendingIntent pendingIntent4 = pendingIntent2;
        sMSDispatcher.sendText(string6, string7, string8, pendingIntent3, pendingIntent4);
    }
}

