/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.graphics.Bitmap;
import android.util.Log;
import com.android.internal.telephony.GsmAlphabet;
import java.io.UnsupportedEncodingException;

public class IccUtils {
    static final String LOG_TAG = "IccUtils";

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String adnStringFieldToString(byte[] byArray, int n, int n2) {
        boolean bl;
        int n3;
        if (n2 >= 1 && byArray[n] == 65408) {
            void var7_8;
            n3 = (n2 - 1) / 2;
            bl = false;
            try {
                int n4 = n + 1;
                int n5 = n3 * 2;
                String string2 = new String(byArray, n4, n5, "utf-16be");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                int n6 = Log.e(LOG_TAG, "implausible UnsupportedEncodingException", unsupportedEncodingException);
                boolean bl2 = bl;
            }
            if (var7_8 != null) {
                int n7 = var7_8.length();
                while (n7 > 0) {
                    int n8 = n7 - 1;
                    if (var7_8.charAt(n8) != '\uffff') return var7_8.substring(0, n7);
                    n7 += -1;
                }
                return var7_8.substring(0, n7);
            }
        }
        bl = false;
        boolean bl3 = false;
        n3 = 0;
        if (n2 >= 3 && byArray[n] == 65409) {
            int n9 = n + 1;
            int n10 = byArray[n9] & 0xFF;
            int n11 = n2 - 3;
            n3 = n10 > n11 ? n2 - 3 : n10;
            int n12 = n + 2;
            char c = (char)((byArray[n12] & 0xFF) << 7);
            n += 3;
            bl = true;
        } else if (n2 >= 4 && byArray[n] == 65410) {
            int n13 = n + 1;
            int n14 = byArray[n13] & 0xFF;
            int n15 = n2 - 4;
            n3 = n14 > n15 ? n2 - 4 : n14;
            int n16 = n + 2;
            int n17 = (byArray[n16] & 0xFF) << 8;
            int n18 = n + 3;
            int n19 = byArray[n18] & 0xFF;
            char c = (char)(n17 | n19);
            n += 4;
            bl = true;
        }
        if (!bl) {
            return GsmAlphabet.gsm8BitUnpackedToString(byArray, n, n2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n20 = n3;
        while (n20 > 0) {
            void var24_37;
            int n21;
            int n22;
            int n23;
            if (byArray[n] < 0) {
                void var7_12;
                char c = (char)((byArray[n] & 0x7F) + var7_12);
                StringBuilder stringBuilder2 = stringBuilder.append(c);
                n23 = n + 1;
                n22 = n20 + -1;
            } else {
                n22 = n20;
            }
            for (n21 = 0; n21 < n22 && byArray[var24_37 = n23 + n21] >= 0; ++n21) {
            }
            String string3 = GsmAlphabet.gsm8BitUnpackedToString(byArray, n23, n21);
            StringBuilder stringBuilder3 = stringBuilder.append(string3);
            int n24 = n23 + n21;
            int n25 = n22 - n21;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String bcdToString(byte[] byArray, int n, int n2) {
        int n3 = n2 * 2;
        StringBuilder stringBuilder = new StringBuilder(n3);
        int n4 = n;
        while (true) {
            int n5;
            block4: {
                block3: {
                    int n6;
                    if (n4 >= (n6 = n + n2) || (n5 = byArray[n4] & 0xF) > 9) break block3;
                    char c = (char)(n5 + 48);
                    StringBuilder stringBuilder2 = stringBuilder.append(c);
                    n5 = byArray[n4] >> 4 & 0xF;
                    if (n5 <= 9) break block4;
                }
                return stringBuilder.toString();
            }
            char c = (char)(n5 + 48);
            StringBuilder stringBuilder3 = stringBuilder.append(c);
            ++n4;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int bitToRGB(int n) {
        if (n != 1) return -16777216;
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String bytesToHexString(byte[] byArray) {
        int n;
        if (byArray == null) {
            return null;
        }
        int n2 = byArray.length * 2;
        StringBuilder stringBuilder = new StringBuilder(n2);
        int n3 = 0;
        while (n3 < (n = byArray.length)) {
            int n4 = byArray[n3] >> 4 & 0xF;
            char c = "0123456789abcdef".charAt(n4);
            StringBuilder stringBuilder2 = stringBuilder.append(c);
            int n5 = byArray[n3] & 0xF;
            char c2 = "0123456789abcdef".charAt(n5);
            StringBuilder stringBuilder3 = stringBuilder.append(c2);
            ++n3;
        }
        return stringBuilder.toString();
    }

    public static int cdmaBcdByteToInt(byte by) {
        int n = 0;
        if ((by & 0xF0) <= 144) {
            n = (by >> 4 & 0xF) * 10;
        }
        if ((by & 0xF) <= 9) {
            int n2 = by & 0xF;
            n += n2;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int[] getCLUT(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return null;
        }
        int[] nArray = new int[n2];
        int n3 = n2 * 3;
        int n4 = n + n3;
        int n5 = n;
        int n6 = 0;
        int n7 = -16777216;
        while (true) {
            int n8;
            int n9 = n6 + 1;
            int n10 = n5 + 1;
            int n11 = (byArray[n5] & 0xFF) << 16 | n7;
            int n12 = n10 + 1;
            int n13 = (byArray[n10] & 0xFF) << 8;
            int n14 = n11 | n13;
            int n15 = n12 + 1;
            int n16 = byArray[n12] & 0xFF;
            nArray[n6] = n8 = n14 | n16;
            if (n15 >= n4) {
                return nArray;
            }
            n6 = n9;
            n5 = n15;
        }
    }

    public static int gsmBcdByteToInt(byte by) {
        int n = 0;
        if ((by & 0xF0) <= 144) {
            n = by >> 4 & 0xF;
        }
        if ((by & 0xF) <= 9) {
            int n2 = (by & 0xF) * 10;
            n += n2;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int hexCharToInt(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        String string2 = "invalid hex char '" + c + "'";
        throw new RuntimeException(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] hexStringToBytes(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = string2.length();
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        while (n2 < n) {
            byte by;
            int n3 = n2 / 2;
            int n4 = IccUtils.hexCharToInt(string2.charAt(n2)) << 4;
            int n5 = n2 + 1;
            int n6 = IccUtils.hexCharToInt(string2.charAt(n5));
            byArray[n3] = by = (byte)(n4 | n6);
            n2 += 2;
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int[] mapTo2OrderBitColor(byte[] byArray, int n, int n2, int[] nArray, int n3) {
        if (8 % n3 != 0) {
            int n4 = Log.e(LOG_TAG, "not event number of color");
            return IccUtils.mapToNon2OrderBitColor(byArray, n, n2, nArray, n3);
        }
        int n5 = 1;
        switch (n3) {
            case 1: {
                n5 = 1;
                break;
            }
            case 2: {
                n5 = 3;
                break;
            }
            case 4: {
                n5 = 15;
                break;
            }
            case 8: {
                n5 = 255;
            }
        }
        int[] nArray2 = new int[n2];
        int n6 = 0;
        int n7 = 8 / n3;
        int n8 = n;
        while (n6 < n2) {
            n = n8 + 1;
            byte by = byArray[n8];
            int n9 = n6;
            for (int i = 0; i < n7; ++i) {
                int n10;
                int n11 = n7 - i - 1;
                int n12 = n9 + 1;
                int n13 = n11 * n3;
                int n14 = by >> n13 & n5;
                nArray2[n9] = n10 = nArray[n14];
                n9 = n12;
            }
            n6 = n9;
            n8 = n;
        }
        int n15 = n8;
        return nArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int[] mapToNon2OrderBitColor(byte[] byArray, int n, int n2, int[] nArray, int n3) {
        if (8 % n3 != 0) return new int[n2];
        int n4 = Log.e(LOG_TAG, "not odd number of color");
        return IccUtils.mapTo2OrderBitColor(byArray, n, n2, nArray, n3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String networkNameToString(byte[] byArray, int n, int n2) {
        String string2;
        if ((byArray[n] & 0x80) != 128) return "";
        if (n2 < 1) {
            return "";
        }
        switch (byArray[n] >>> 4 & 7) {
            default: {
                string2 = "";
                break;
            }
            case 0: {
                int n3 = byArray[n] & 7;
                int n4 = ((n2 - 1) * 8 - n3) / 7;
                int n5 = n + 1;
                string2 = GsmAlphabet.gsm7BitPackedToString(byArray, n5, n4);
                break;
            }
            case 1: {
                try {
                    int n6 = n + 1;
                    int n7 = n2 - 1;
                    string2 = new String(byArray, n6, n7, "utf-16");
                    break;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string2 = "";
                    int n8 = Log.e(LOG_TAG, "implausible UnsupportedEncodingException", unsupportedEncodingException);
                }
            }
        }
        if ((byArray[n] & 0x40) == 0) return string2;
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Bitmap parseToBnW(byte[] byArray, int n) {
        int n2 = 0 + 1;
        int n3 = byArray[0] & 0xFF;
        int n4 = n2 + 1;
        int n5 = byArray[n2] & 0xFF;
        int n6 = n3 * n5;
        int[] nArray = new int[n6];
        int n7 = 7;
        byte by = 0;
        int n8 = 0;
        int n9 = n4;
        while (n8 < n6) {
            int n10;
            int n11;
            if (n8 % 8 == 0) {
                n11 = n9 + 1;
                by = byArray[n9];
                n7 = 7;
            } else {
                n11 = n9;
            }
            int n12 = n8 + 1;
            int n13 = n7 + -1;
            nArray[n8] = n10 = IccUtils.bitToRGB(by >> n7 & 1);
            int n14 = n13;
            n8 = n12;
            n9 = n11;
        }
        if (n8 != n6) {
            int n15 = Log.e(LOG_TAG, "parse end and size error");
        }
        Bitmap.Config config = Bitmap.Config.ARGB_8888;
        return Bitmap.createBitmap(nArray, n3, n5, config);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Bitmap parseToRGB(byte[] byArray, int n, boolean bl) {
        int[] nArray;
        int n2 = 0 + 1;
        int n3 = byArray[0] & 0xFF;
        int n4 = n2 + 1;
        int n5 = byArray[n2] & 0xFF;
        int n6 = n4 + 1;
        int n7 = byArray[n4] & 0xFF;
        int n8 = n6 + 1;
        int n9 = byArray[n6] & 0xFF;
        int n10 = n8 + 1;
        int n11 = (byArray[n8] & 0xFF) << 8;
        int n12 = n10 + 1;
        int n13 = byArray[n10] & 0xFF;
        int n14 = n11 | n13;
        int n15 = n - 6;
        int[] nArray2 = IccUtils.getCLUT(byArray, n14, n9);
        if (!bl) {
            int n16 = n9 - 1;
            nArray2[n16] = 0;
        }
        if (8 % n7 == 0) {
            int n17 = n3 * n5;
            nArray = IccUtils.mapTo2OrderBitColor(byArray, n12, n17, nArray2, n7);
        } else {
            int n18 = n3 * n5;
            nArray = IccUtils.mapToNon2OrderBitColor(byArray, n12, n18, nArray2, n7);
        }
        Bitmap.Config config = Bitmap.Config.RGB_565;
        return Bitmap.createBitmap(nArray, n3, n5, config);
    }
}

