/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.ActivityManagerNative;
import android.app.AlarmManager;
import android.content.Context;
import android.content.res.Configuration;
import android.net.wifi.WifiManager;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.PhoneBase;
import java.util.Arrays;

public final class MccTable {
    private static final int[] IND_CODES;
    private static final String[] LANG_STRINGS;
    static final String LOG_TAG = "MccTable";
    private static final short[] MCC_CODES;
    private static final String[] TZ_STRINGS;

    static {
        String[] stringArray = new String[]{"", "Africa/Johannesburg", "Asia/Beijing", "Asia/Seoul", "Asia/Singapore", "Asia/Tokyo", "Australia/Sydney", "Europe/Amsterdam", "Europe/Berlin", "Europe/Dublin", "Europe/London", "Europe/Madrid", "Europe/Paris", "Europe/Prague", "Europe/Rome", "Europe/Vienna", "Europe/Warsaw", "Europe/Zurich", "Pacific/Auckland"};
        TZ_STRINGS = stringArray;
        String[] stringArray2 = new String[]{"", "cs", "de", "en", "es", "fr", "it", "ja", "ko", "nl", "zh"};
        LANG_STRINGS = stringArray2;
        null[0] = 202;
        null[1] = 204;
        null[2] = 206;
        null[3] = 208;
        null[4] = 212;
        null[5] = 213;
        null[6] = 214;
        null[7] = 216;
        null[8] = 218;
        null[9] = 219;
        null[10] = 220;
        null[11] = 222;
        null[12] = 225;
        null[13] = 226;
        null[14] = 228;
        null[15] = 230;
        null[16] = 231;
        null[17] = 232;
        null[18] = 234;
        null[19] = 235;
        null[20] = 238;
        null[21] = 240;
        null[22] = 242;
        null[23] = 244;
        null[24] = 246;
        null[25] = 247;
        null[26] = 248;
        null[27] = 250;
        null[28] = 255;
        null[29] = 257;
        null[30] = 259;
        null[31] = 260;
        null[32] = 262;
        null[33] = 266;
        null[34] = 268;
        null[35] = 270;
        null[36] = 272;
        null[37] = 274;
        null[38] = 276;
        null[39] = 278;
        null[40] = 280;
        null[41] = 282;
        null[42] = 283;
        null[43] = 284;
        null[44] = 286;
        null[45] = 288;
        null[46] = 289;
        null[47] = 290;
        null[48] = 292;
        null[49] = 293;
        null[50] = 294;
        null[51] = 295;
        null[52] = 297;
        null[53] = 302;
        null[54] = 308;
        null[55] = 310;
        null[56] = 311;
        null[57] = 312;
        null[58] = 313;
        null[59] = 314;
        null[60] = 315;
        null[61] = 316;
        null[62] = 330;
        null[63] = 332;
        null[64] = 334;
        null[65] = 338;
        null[66] = 340;
        null[67] = 342;
        null[68] = 344;
        null[69] = 346;
        null[70] = 348;
        null[71] = 350;
        null[72] = 352;
        null[73] = 354;
        null[74] = 356;
        null[75] = 358;
        null[76] = 360;
        null[77] = 362;
        null[78] = 363;
        null[79] = 364;
        null[80] = 365;
        null[81] = 366;
        null[82] = 368;
        null[83] = 370;
        null[84] = 372;
        null[85] = 374;
        null[86] = 376;
        null[87] = 400;
        null[88] = 401;
        null[89] = 402;
        null[90] = 404;
        null[91] = 405;
        null[92] = 410;
        null[93] = 412;
        null[94] = 413;
        null[95] = 414;
        null[96] = 415;
        null[97] = 416;
        null[98] = 417;
        null[99] = 418;
        null[100] = 419;
        null[101] = 420;
        null[102] = 421;
        null[103] = 422;
        null[104] = 423;
        null[105] = 424;
        null[106] = 425;
        null[107] = 426;
        null[108] = 427;
        null[109] = 428;
        null[110] = 429;
        null[111] = 430;
        null[112] = 431;
        null[113] = 432;
        null[114] = 434;
        null[115] = 436;
        null[116] = 437;
        null[117] = 438;
        null[118] = 440;
        null[119] = 441;
        null[120] = 450;
        null[121] = 452;
        null[122] = 454;
        null[123] = 455;
        null[124] = 456;
        null[125] = 457;
        null[126] = 460;
        null[127] = 461;
        null[128] = 466;
        null[129] = 467;
        null[130] = 470;
        null[131] = 472;
        null[132] = 502;
        null[133] = 505;
        null[134] = 510;
        null[135] = 514;
        null[136] = 515;
        null[137] = 520;
        null[138] = 525;
        null[139] = 528;
        null[140] = 530;
        null[141] = 534;
        null[142] = 535;
        null[143] = 536;
        null[144] = 537;
        null[145] = 539;
        null[146] = 540;
        null[147] = 541;
        null[148] = 542;
        null[149] = 543;
        null[150] = 544;
        null[151] = 545;
        null[152] = 546;
        null[153] = 547;
        null[154] = 548;
        null[155] = 549;
        null[156] = 550;
        null[157] = 551;
        null[158] = 552;
        null[159] = 602;
        null[160] = 603;
        null[161] = 604;
        null[162] = 605;
        null[163] = 606;
        null[164] = 607;
        null[165] = 608;
        null[166] = 609;
        null[167] = 610;
        null[168] = 611;
        null[169] = 612;
        null[170] = 613;
        null[171] = 614;
        null[172] = 615;
        null[173] = 616;
        null[174] = 617;
        null[175] = 618;
        null[176] = 619;
        null[177] = 620;
        null[178] = 621;
        null[179] = 622;
        null[180] = 623;
        null[181] = 624;
        null[182] = 625;
        null[183] = 626;
        null[184] = 627;
        null[185] = 628;
        null[186] = 629;
        null[187] = 630;
        null[188] = 631;
        null[189] = 632;
        null[190] = 633;
        null[191] = 634;
        null[192] = 635;
        null[193] = 636;
        null[194] = 637;
        null[195] = 638;
        null[196] = 639;
        null[197] = 640;
        null[198] = 641;
        null[199] = 642;
        null[200] = 643;
        null[201] = 645;
        null[202] = 646;
        null[203] = 647;
        null[204] = 648;
        null[205] = 649;
        null[206] = 650;
        null[207] = 651;
        null[208] = 652;
        null[209] = 653;
        null[210] = 654;
        null[211] = 655;
        null[212] = 657;
        null[213] = 702;
        null[214] = 704;
        null[215] = 706;
        null[216] = 708;
        null[217] = 710;
        null[218] = 712;
        null[219] = 714;
        null[220] = 716;
        null[221] = 722;
        null[222] = 724;
        null[223] = 730;
        null[224] = 732;
        null[225] = 734;
        null[226] = 736;
        null[227] = 738;
        null[228] = 740;
        null[229] = 742;
        null[230] = 744;
        null[231] = 746;
        null[232] = 748;
        null[233] = 750;
        MCC_CODES = null;
        IND_CODES = new int[]{1735525376, 1852599417, 1650787328, 1718748357, 1835205632, 1633944576, 1702036660, 1752499200, 1650525184, 1752302592, 1920140288, 1769211110, 1986069734, 1919878144, 1667761426, 1668967633, 1936393216, 1635020018, 1734503587, 1734503587, 1684734976, 1936000000, 1852769280, 1718158336, 1819542528, 1819673600, 1701118976, 1920271360, 1969292288, 1652098048, 1835271168, 1886127360, 1684368514, 1734935552, 0x70740400, 1819608064, 1768227987, 1769145344, 1634468864, 1836319744, 1668875264, 1734673408, 1634534400, 1650918400, 1953629184, 1718551552, 1734673408, 1735132160, 1936524288, 1936458752, 1835729920, 1818821632, 1835336704, 1667325440, 1886192640, 1970494979, 1970494979, 1970494979, 1970494979, 1970494979, 1970494979, 1970494979, 1886520320, 1986593792, 1836582400, 1785529856, 1735394304, 0x62620600, 1634141696, 1803093504, 0x76670600, 1651311616, 1734607872, 1836254208, 1802372096, 1818428416, 1986200576, 1852572672, 1635189760, 1651704832, 1634272768, 1684866048, 1668613120, 1684997120, 1752433664, 0x74740400, 1952646144, 1635386368, 1803158528, 1651770368, 1768817664, 1768817664, 1886061568, 1634075648, 1818952704, 1835860992, 1818362880, 1785660416, 1937310720, 1769014272, 1802961920, 1935737856, 2036663296, 1869415424, 1886585856, 1634010112, 1768686592, 1650983936, 1902183424, 1835926528, 1852834816, 1634010112, 1634010112, 1769079808, 1970930688, 1953104896, 1801913344, 1953301504, 1785754711, 1785754711, 1802660920, 1986921472, 1751843840, 1835992064, 1801978880, 1818297344, 1668181034, 1668181034, 0x74770400, 1802503168, 1650721792, 1836450816, 1836647424, 1635081315, 1768162304, 1953235968, 1885864960, 1952973824, 1936153667, 1651377152, 1853490467, 1836057600, 1735721984, 1852965888, 1885799424, 1953432576, 1935803392, 1987380224, 1718223872, 2003174400, 1634927616, 1802044416, 1851982848, 1885733888, 1667957760, 2004026368, 1718420480, 1835533312, 0x70770400, 1701250048, 1685718016, 1835074560, 1953367040, 1819870208, 1735197696, 1936589824, 1836188672, 1835795456, 1735263232, 1667826688, 1650852864, 1852113920, 1952908288, 1651115008, 1836385280, 1819411456, 1936458752, 1734870016, 1852244992, 1952711680, 1667630080, 1668088832, 1668678656, 1936983040, 1735459840, 1734411264, 1667695616, 1667695616, 1634665472, 1735853056, 1935868928, 1935934464, 1920402432, 1702102016, 1936655360, 1684669440, 1801782272, 1954153472, 1969685504, 1651049472, 1836712960, 2053964800, 1835467776, 1919222784, 2054620160, 1851851776, 1836516352, 1819476992, 1651966976, 1937376256, 1802306560, 2053178387, 1701970944, 1652163584, 1735656448, 1937114112, 1752040960, 1852376064, 1668416512, 1885406208, 1885668352, 1634862592, 1651639296, 1668023296, 1668220416, 1986331648, 1651442688, 1735984128, 1700987904, 1734738944, 1886979072, 1936851968, 1970865152, 1718289408};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String countryCodeForMcc(int n) {
        short[] sArray = MCC_CODES;
        short s = (short)n;
        int n2 = Arrays.binarySearch(sArray, s);
        if (n2 < 0) {
            return "";
        }
        int n3 = IND_CODES[n2];
        byte by = (byte)(n3 >>> 24 & 0xFF);
        byte by2 = (byte)(n3 >>> 16 & 0xFF);
        byte[] byArray = new byte[]{by, by2};
        return new String(byArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String defaultLanguageForMcc(int n) {
        short[] sArray = MCC_CODES;
        short s = (short)n;
        int n2 = Arrays.binarySearch(sArray, s);
        if (n2 < 0) {
            return null;
        }
        int n3 = IND_CODES[n2] & 0xF;
        String string2 = LANG_STRINGS[n3];
        if (string2 != "") return string2;
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String defaultTimeZoneForMcc(int n) {
        short[] sArray = MCC_CODES;
        short s = (short)n;
        int n2 = Arrays.binarySearch(sArray, s);
        if (n2 < 0) {
            return null;
        }
        int n3 = IND_CODES[n2] >>> 4 & 0x1F;
        String string2 = TZ_STRINGS[n3];
        if (string2 != "") return string2;
        return null;
    }

    private static void setLocaleFromMccIfNeeded(PhoneBase phoneBase, int n) {
        String string2 = MccTable.defaultLanguageForMcc(n);
        String string3 = MccTable.countryCodeForMcc(n);
        String string4 = "locale set to " + string2 + "_" + string3;
        int n2 = Log.d(LOG_TAG, string4);
        phoneBase.setSystemLocale(string2, string3);
    }

    private static void setTimezoneFromMccIfNeeded(PhoneBase phoneBase, int n) {
        String string2 = SystemProperties.get("persist.sys.timezone");
        if (string2 != null && string2.length() != 0) {
            return;
        }
        String string3 = MccTable.defaultTimeZoneForMcc(n);
        if (string3 == null) {
            return;
        }
        if (string3.length() <= 0) {
            return;
        }
        ((AlarmManager)phoneBase.getContext().getSystemService("alarm")).setTimeZone(string3);
        String string4 = "timezone set to " + string3;
        int n2 = Log.d(LOG_TAG, string4);
    }

    private static void setWifiChannelsFromMcc(PhoneBase phoneBase, int n) {
        int n2 = MccTable.wifiChannelsForMcc(n);
        if (n2 == 0) {
            return;
        }
        Context context = phoneBase.getContext();
        String string2 = "WIFI_NUM_ALLOWED_CHANNELS set to " + n2;
        int n3 = Log.d(LOG_TAG, string2);
        boolean bl = ((WifiManager)context.getSystemService("wifi")).setNumAllowedChannels(n2, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int smallestDigitsMccForMnc(int n) {
        short[] sArray = MCC_CODES;
        short s = (short)n;
        int n2 = Arrays.binarySearch(sArray, s);
        if (n2 >= 0) return IND_CODES[n2] >>> 9 & 3;
        return 2;
    }

    public static void updateMccMncConfiguration(PhoneBase phoneBase, String string2) {
        int n;
        int n2;
        if (TextUtils.isEmpty(string2)) {
            return;
        }
        int n3 = 0;
        int n4 = 3;
        try {
            int n5;
            n2 = Integer.parseInt(string2.substring(n3, n4));
            n = n5 = Integer.parseInt(string2.substring(3));
        }
        catch (NumberFormatException numberFormatException) {
            int n6 = Log.e(LOG_TAG, "Error parsing IMSI");
            return;
        }
        String string3 = "updateMccMncConfiguration: mcc=" + n2 + ", mnc=" + n;
        int n7 = Log.d(LOG_TAG, string3);
        if (n2 != 0) {
            MccTable.setTimezoneFromMccIfNeeded(phoneBase, n2);
            MccTable.setLocaleFromMccIfNeeded(phoneBase, n2);
            MccTable.setWifiChannelsFromMcc(phoneBase, n2);
        }
        try {
            Configuration configuration = ActivityManagerNative.getDefault().getConfiguration();
            if (n2 != 0) {
                configuration.mcc = n2;
            }
            if (n != 0) {
                configuration.mnc = n;
            }
            ActivityManagerNative.getDefault().updateConfiguration(configuration);
            return;
        }
        catch (RemoteException remoteException) {
            int n8 = Log.e(LOG_TAG, "Can't update configuration", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int wifiChannelsForMcc(int n) {
        short[] sArray = MCC_CODES;
        short s = (short)n;
        int n2 = Arrays.binarySearch(sArray, s);
        if (n2 >= 0) return IND_CODES[n2] >>> 11 & 0xF;
        return 0;
    }
}

