/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.net.wifi.WifiManager;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.telephony.ServiceState;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DataConnectionTracker;
import com.android.internal.telephony.IccFileHandler;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.test.SimulatedRadioControl;
import java.util.Locale;

public abstract class PhoneBase
extends Handler
implements Phone {
    public static final String CLIR_KEY = "clir_key";
    public static final String DATA_DISABLED_ON_BOOT_KEY = "disabled_on_boot_key";
    public static final String DNS_SERVER_CHECK_DISABLED_KEY = "dns_server_check_disabled_key";
    protected static final int EVENT_CALL_RING = 14;
    protected static final int EVENT_CALL_RING_CONTINUE = 15;
    protected static final int EVENT_EMERGENCY_CALLBACK_MODE_ENTER = 25;
    protected static final int EVENT_EXIT_EMERGENCY_CALLBACK_RESPONSE = 26;
    protected static final int EVENT_GET_BASEBAND_VERSION_DONE = 6;
    protected static final int EVENT_GET_CALL_FORWARD_DONE = 13;
    protected static final int EVENT_GET_DEVICE_IDENTITY_DONE = 21;
    protected static final int EVENT_GET_IMEISV_DONE = 10;
    protected static final int EVENT_GET_IMEI_DONE = 9;
    protected static final int EVENT_GET_SIM_STATUS_DONE = 11;
    protected static final int EVENT_MMI_DONE = 4;
    protected static final int EVENT_NV_READY = 23;
    protected static final int EVENT_RADIO_AVAILABLE = 1;
    protected static final int EVENT_RADIO_OFF_OR_NOT_AVAILABLE = 8;
    protected static final int EVENT_RADIO_ON = 5;
    protected static final int EVENT_REGISTERED_TO_NETWORK = 19;
    protected static final int EVENT_RUIM_RECORDS_LOADED = 22;
    protected static final int EVENT_SET_CALL_FORWARD_DONE = 12;
    protected static final int EVENT_SET_CLIR_COMPLETE = 18;
    protected static final int EVENT_SET_ENHANCED_VP = 24;
    protected static final int EVENT_SET_NETWORK_AUTOMATIC_COMPLETE = 17;
    protected static final int EVENT_SET_NETWORK_MANUAL_COMPLETE = 16;
    protected static final int EVENT_SET_VM_NUMBER_DONE = 20;
    protected static final int EVENT_SIM_RECORDS_LOADED = 3;
    protected static final int EVENT_SSN = 2;
    protected static final int EVENT_USSD = 7;
    private static final boolean LOCAL_DEBUG = true;
    private static final String LOG_TAG = "PHONE";
    public static final String NETWORK_SELECTION_KEY = "network_selection_key";
    public static final String NETWORK_SELECTION_NAME_KEY = "network_selection_name_key";
    public CommandsInterface mCM;
    int mCallRingContinueToken = 0;
    int mCallRingDelay;
    protected Context mContext;
    public DataConnectionTracker mDataConnection;
    protected final RegistrantList mDisconnectRegistrants;
    boolean mDnsCheckDisabled = false;
    boolean mDoesRilSendMultipleCallRing;
    protected IccFileHandler mIccFileHandler;
    protected final RegistrantList mIncomingRingRegistrants;
    public boolean mIsTheCurrentActivePhone = true;
    protected Looper mLooper;
    protected final RegistrantList mMmiCompleteRegistrants;
    protected final RegistrantList mMmiRegistrants;
    protected final RegistrantList mNewRingingConnectionRegistrants;
    protected PhoneNotifier mNotifier;
    protected final RegistrantList mPreciseCallStateRegistrants;
    protected final RegistrantList mServiceStateRegistrants;
    protected SimulatedRadioControl mSimulatedRadioControl;
    protected final RegistrantList mSuppServiceFailedRegistrants;
    boolean mUnitTestMode;
    protected final RegistrantList mUnknownConnectionRegistrants;

    protected PhoneBase(PhoneNotifier phoneNotifier, Context context, CommandsInterface commandsInterface) {
        this(phoneNotifier, context, commandsInterface, false);
    }

    protected PhoneBase(PhoneNotifier phoneNotifier, Context context, CommandsInterface commandsInterface, boolean bl) {
        int n;
        boolean bl2;
        boolean bl3;
        Looper looper;
        RegistrantList registrantList;
        RegistrantList registrantList2;
        RegistrantList registrantList3;
        RegistrantList registrantList4;
        RegistrantList registrantList5;
        RegistrantList registrantList6;
        RegistrantList registrantList7;
        RegistrantList registrantList8;
        RegistrantList registrantList9;
        this.mPreciseCallStateRegistrants = registrantList9 = new RegistrantList();
        this.mNewRingingConnectionRegistrants = registrantList8 = new RegistrantList();
        this.mIncomingRingRegistrants = registrantList7 = new RegistrantList();
        this.mDisconnectRegistrants = registrantList6 = new RegistrantList();
        this.mServiceStateRegistrants = registrantList5 = new RegistrantList();
        this.mMmiCompleteRegistrants = registrantList4 = new RegistrantList();
        this.mMmiRegistrants = registrantList3 = new RegistrantList();
        this.mUnknownConnectionRegistrants = registrantList2 = new RegistrantList();
        this.mSuppServiceFailedRegistrants = registrantList = new RegistrantList();
        this.mNotifier = phoneNotifier;
        this.mContext = context;
        this.mLooper = looper = Looper.myLooper();
        this.mCM = commandsInterface;
        this.setPropertiesByCarrier();
        this.setUnitTestMode(bl);
        this.mDnsCheckDisabled = bl3 = PreferenceManager.getDefaultSharedPreferences(context).getBoolean(DNS_SERVER_CHECK_DISABLED_KEY, false);
        this.mCM.setOnCallRing(this, 14, null);
        this.mDoesRilSendMultipleCallRing = bl2 = SystemProperties.getBoolean("ro.telephony.call_ring.multiple", true);
        StringBuilder stringBuilder = new StringBuilder().append("mDoesRilSendMultipleCallRing=");
        boolean bl4 = this.mDoesRilSendMultipleCallRing;
        String string2 = stringBuilder.append(bl4).toString();
        int n2 = Log.d(LOG_TAG, string2);
        this.mCallRingDelay = n = SystemProperties.getInt("ro.telephony.call_ring.delay", 3000);
        StringBuilder stringBuilder2 = new StringBuilder().append("mCallRingDelay=");
        int n3 = this.mCallRingDelay;
        String string3 = stringBuilder2.append(n3).toString();
        int n4 = Log.d(LOG_TAG, string3);
    }

    private void checkCorrectThread(Handler handler) {
        Looper looper;
        Looper looper2 = handler.getLooper();
        if (looper2 == (looper = this.mLooper)) {
            return;
        }
        throw new RuntimeException("com.android.internal.telephony.Phone must be used from within one thread");
    }

    private String getSavedNetworkSelection() {
        return PreferenceManager.getDefaultSharedPreferences(this.getContext()).getString(NETWORK_SELECTION_KEY, "");
    }

    private void logUnexpectedCdmaMethodCall(String string2) {
        String string3 = "Error! " + string2 + "() in PhoneBase should not be " + "called, CDMAPhone inactive.";
        int n = Log.e(LOG_TAG, string3);
    }

    private void notifyIncomingRing() {
        AsyncResult asyncResult = new AsyncResult(null, this, null);
        this.mIncomingRingRegistrants.notifyRegistrants(asyncResult);
    }

    private void sendIncomingCallRingNotification(int n) {
        int n2;
        if (!this.mDoesRilSendMultipleCallRing && n != (n2 = this.mCallRingContinueToken)) {
            int n3 = Log.d(LOG_TAG, "Sending notifyIncomingRing");
            this.notifyIncomingRing();
            Message message = this.obtainMessage(15, n, 0);
            long l = this.mCallRingDelay;
            boolean bl = this.sendMessageDelayed(message, l);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Ignoring ring notification request, mDoesRilSendMultipleCallRing=");
        boolean bl = this.mDoesRilSendMultipleCallRing;
        StringBuilder stringBuilder2 = stringBuilder.append(bl).append(" token=").append(n).append(" mCallRingContinueToken=");
        int n4 = this.mCallRingContinueToken;
        String string2 = stringBuilder2.append(n4).toString();
        int n5 = Log.d(LOG_TAG, string2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setPropertiesByCarrier() {
        int n;
        String string2;
        block12: {
            String string3 = SystemProperties.get("ro.carrier");
            if (string3 == null) {
                return;
            }
            if (string3.length() == 0) {
                return;
            }
            if ("unknown".equals(string3)) {
                return;
            }
            CharSequence[] charSequenceArray = this.mContext.getResources().getTextArray(17235997);
            int n2 = 0;
            while (true) {
                int n3;
                if (n2 >= (n3 = charSequenceArray.length)) {
                    return;
                }
                String string4 = ((Object)charSequenceArray[n2]).toString();
                if (string3.equals(string4)) {
                    int n4;
                    int n5 = n2 + 1;
                    string2 = ((Object)charSequenceArray[n5]).toString();
                    n = 0;
                    int n6 = n2 + 2;
                    n = n4 = Integer.parseInt(((Object)charSequenceArray[n6]).toString());
                    break block12;
                }
                n2 += 3;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String string5 = string2.substring(0, 2);
        String string6 = "";
        if (string2.length() >= 5) {
            string6 = string2.substring(3, 5);
        }
        this.setSystemLocale(string5, string6);
        if (n == 0) {
            return;
        }
        try {
            int n7 = Settings.Secure.getInt(this.mContext.getContentResolver(), "wifi_num_allowed_channels");
            return;
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            boolean bl = ((WifiManager)this.mContext.getSystemService("wifi")).setNumAllowedChannels(n, false);
            return;
        }
    }

    @Override
    public int disableApnType(String string2) {
        return this.mDataConnection.disableApnType(string2);
    }

    @Override
    public void disableDnsCheck(boolean bl) {
        this.mDnsCheckDisabled = bl;
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences(this.getContext()).edit();
        SharedPreferences.Editor editor2 = editor.putBoolean(DNS_SERVER_CHECK_DISABLED_KEY, bl);
        editor.apply();
    }

    public void dispose() {
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            this.mCM.unSetOnCallRing(this);
            this.mDataConnection.onCleanUpConnection(false, "radioTurnedOff");
            this.mIsTheCurrentActivePhone = false;
            return;
        }
    }

    @Override
    public int enableApnType(String string2) {
        return this.mDataConnection.enableApnType(string2);
    }

    @Override
    public void enableEnhancedVoicePrivacy(boolean bl, Message message) {
        this.logUnexpectedCdmaMethodCall("enableEnhancedVoicePrivacy");
    }

    @Override
    public void exitEmergencyCallbackMode() {
        this.logUnexpectedCdmaMethodCall("exitEmergencyCallbackMode");
    }

    @Override
    public String getActiveApn() {
        return this.mDataConnection.getActiveApnString();
    }

    @Override
    public String[] getActiveApnTypes() {
        return this.mDataConnection.getActiveApnTypes();
    }

    @Override
    public int getCdmaEriIconIndex() {
        this.logUnexpectedCdmaMethodCall("getCdmaEriIconIndex");
        return -1;
    }

    @Override
    public int getCdmaEriIconMode() {
        this.logUnexpectedCdmaMethodCall("getCdmaEriIconMode");
        return -1;
    }

    @Override
    public String getCdmaEriText() {
        this.logUnexpectedCdmaMethodCall("getCdmaEriText");
        return "GSM nw, no ERI";
    }

    @Override
    public String getCdmaMin() {
        this.logUnexpectedCdmaMethodCall("getCdmaMin");
        return null;
    }

    @Override
    public String getCdmaPrlVersion() {
        this.logUnexpectedCdmaMethodCall("getCdmaPrlVersion");
        return null;
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public String[] getDnsServers(String string2) {
        return this.mDataConnection.getDnsServers(string2);
    }

    @Override
    public void getEnhancedVoicePrivacy(Message message) {
        this.logUnexpectedCdmaMethodCall("getEnhancedVoicePrivacy");
    }

    @Override
    public String getGateway(String string2) {
        return this.mDataConnection.getGateway(string2);
    }

    public Handler getHandler() {
        return this;
    }

    public abstract IccFileHandler getIccFileHandler();

    @Override
    public String getInterfaceName(String string2) {
        return this.mDataConnection.getInterfaceName(string2);
    }

    @Override
    public String getIpAddress(String string2) {
        return this.mDataConnection.getIpAddress(string2);
    }

    @Override
    public abstract String getPhoneName();

    @Override
    public abstract int getPhoneType();

    @Override
    public void getPreferredNetworkType(Message message) {
        this.mCM.getPreferredNetworkType(message);
    }

    @Override
    public SimulatedRadioControl getSimulatedRadioControl() {
        return this.mSimulatedRadioControl;
    }

    @Override
    public void getSmscAddress(Message message) {
        this.mCM.getSmscAddress(message);
    }

    @Override
    public abstract Phone.State getState();

    @Override
    public boolean getUnitTestMode() {
        return this.mUnitTestMode;
    }

    @Override
    public int getVoiceMessageCount() {
        return 0;
    }

    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                throw new RuntimeException("unexpected event not handled");
            }
            case 14: {
                Phone.State state;
                Phone.State state2;
                StringBuilder stringBuilder = new StringBuilder().append("Event EVENT_CALL_RING Received state=");
                Phone.State state3 = this.getState();
                String string2 = stringBuilder.append((Object)state3).toString();
                int n = Log.d(LOG_TAG, string2);
                if (((AsyncResult)message.obj).exception != null) {
                    return;
                }
                Phone.State state4 = this.getState();
                if (!(this.mDoesRilSendMultipleCallRing || state4 != (state2 = Phone.State.RINGING) && state4 != (state = Phone.State.IDLE))) {
                    int n2;
                    int n3 = this.mCallRingContinueToken = (n2 = this.mCallRingContinueToken + 1);
                    this.sendIncomingCallRingNotification(n3);
                    return;
                }
                this.notifyIncomingRing();
                return;
            }
            case 15: 
        }
        StringBuilder stringBuilder = new StringBuilder().append("Event EVENT_CALL_RING_CONTINUE Received stat=");
        Phone.State state = this.getState();
        String string3 = stringBuilder.append((Object)state).toString();
        int n = Log.d(LOG_TAG, string3);
        Phone.State state5 = this.getState();
        Phone.State state6 = Phone.State.RINGING;
        if (state5 != state6) {
            return;
        }
        int n4 = message.arg1;
        this.sendIncomingCallRingNotification(n4);
    }

    @Override
    public void invokeOemRilRequestRaw(byte[] byArray, Message message) {
        this.mCM.invokeOemRilRequestRaw(byArray, message);
    }

    @Override
    public void invokeOemRilRequestStrings(String[] stringArray, Message message) {
        this.mCM.invokeOemRilRequestStrings(stringArray, message);
    }

    @Override
    public boolean isDataConnectivityEnabled() {
        return this.mDataConnection.getDataEnabled();
    }

    @Override
    public boolean isDnsCheckDisabled() {
        return this.mDnsCheckDisabled;
    }

    @Override
    public boolean isMinInfoReady() {
        this.logUnexpectedCdmaMethodCall("isMinInfoReady");
        return false;
    }

    @Override
    public boolean isOtaSpNumber(String string2) {
        this.logUnexpectedCdmaMethodCall("isOtaSpNumber");
        return false;
    }

    @Override
    public void notifyDataActivity() {
        this.mNotifier.notifyDataActivity(this);
    }

    public void notifyDataConnection(String string2) {
        this.mNotifier.notifyDataConnection(this, string2);
    }

    protected void notifyDisconnectP(Connection connection) {
        AsyncResult asyncResult = new AsyncResult(null, connection, null);
        this.mDisconnectRegistrants.notifyRegistrants(asyncResult);
    }

    public void notifyMessageWaitingIndicator() {
        this.mNotifier.notifyMessageWaitingChanged(this);
    }

    protected void notifyNewRingingConnectionP(Connection connection) {
        AsyncResult asyncResult = new AsyncResult(null, connection, null);
        this.mNewRingingConnectionRegistrants.notifyRegistrants(asyncResult);
    }

    protected void notifyPreciseCallStateChangedP() {
        AsyncResult asyncResult = new AsyncResult(null, this, null);
        this.mPreciseCallStateRegistrants.notifyRegistrants(asyncResult);
    }

    protected void notifyServiceStateChangedP(ServiceState serviceState) {
        AsyncResult asyncResult = new AsyncResult(null, serviceState, null);
        this.mServiceStateRegistrants.notifyRegistrants(asyncResult);
        this.mNotifier.notifyServiceState(this);
    }

    @Override
    public void queryAvailableBandMode(Message message) {
        this.mCM.queryAvailableBandMode(message);
    }

    @Override
    public void queryCdmaRoamingPreference(Message message) {
        this.mCM.queryCdmaRoamingPreference(message);
    }

    @Override
    public void queryTTYMode(Message message) {
        this.mCM.queryTTYMode(message);
    }

    @Override
    public void registerFoT53ClirlInfo(Handler handler, int n, Object object) {
        this.mCM.registerFoT53ClirlInfo(handler, n, object);
    }

    @Override
    public void registerForCallWaiting(Handler handler, int n, Object object) {
        this.logUnexpectedCdmaMethodCall("registerForCallWaiting");
    }

    @Override
    public void registerForCdmaOtaStatusChange(Handler handler, int n, Object object) {
        this.logUnexpectedCdmaMethodCall("registerForCdmaOtaStatusChange");
    }

    @Override
    public void registerForDisconnect(Handler handler, int n, Object object) {
        this.checkCorrectThread(handler);
        this.mDisconnectRegistrants.addUnique(handler, n, object);
    }

    @Override
    public void registerForDisplayInfo(Handler handler, int n, Object object) {
        this.mCM.registerForDisplayInfo(handler, n, object);
    }

    @Override
    public void registerForEcmTimerReset(Handler handler, int n, Object object) {
        this.logUnexpectedCdmaMethodCall("registerForEcmTimerReset");
    }

    @Override
    public void registerForInCallVoicePrivacyOff(Handler handler, int n, Object object) {
        this.mCM.registerForInCallVoicePrivacyOff(handler, n, object);
    }

    @Override
    public void registerForInCallVoicePrivacyOn(Handler handler, int n, Object object) {
        this.mCM.registerForInCallVoicePrivacyOn(handler, n, object);
    }

    @Override
    public void registerForIncomingRing(Handler handler, int n, Object object) {
        this.checkCorrectThread(handler);
        this.mIncomingRingRegistrants.addUnique(handler, n, object);
    }

    @Override
    public void registerForLineControlInfo(Handler handler, int n, Object object) {
        this.mCM.registerForLineControlInfo(handler, n, object);
    }

    @Override
    public void registerForMmiComplete(Handler handler, int n, Object object) {
        this.checkCorrectThread(handler);
        this.mMmiCompleteRegistrants.addUnique(handler, n, object);
    }

    @Override
    public void registerForMmiInitiate(Handler handler, int n, Object object) {
        this.checkCorrectThread(handler);
        this.mMmiRegistrants.addUnique(handler, n, object);
    }

    @Override
    public void registerForNewRingingConnection(Handler handler, int n, Object object) {
        this.checkCorrectThread(handler);
        this.mNewRingingConnectionRegistrants.addUnique(handler, n, object);
    }

    @Override
    public void registerForNumberInfo(Handler handler, int n, Object object) {
        this.mCM.registerForNumberInfo(handler, n, object);
    }

    @Override
    public void registerForPreciseCallStateChanged(Handler handler, int n, Object object) {
        this.checkCorrectThread(handler);
        this.mPreciseCallStateRegistrants.addUnique(handler, n, object);
    }

    @Override
    public void registerForRedirectedNumberInfo(Handler handler, int n, Object object) {
        this.mCM.registerForRedirectedNumberInfo(handler, n, object);
    }

    @Override
    public void registerForResendIncallMute(Handler handler, int n, Object object) {
        this.mCM.registerForResendIncallMute(handler, n, object);
    }

    @Override
    public void registerForRingbackTone(Handler handler, int n, Object object) {
        this.mCM.registerForRingbackTone(handler, n, object);
    }

    @Override
    public void registerForServiceStateChanged(Handler handler, int n, Object object) {
        this.checkCorrectThread(handler);
        this.mServiceStateRegistrants.add(handler, n, object);
    }

    @Override
    public void registerForSignalInfo(Handler handler, int n, Object object) {
        this.mCM.registerForSignalInfo(handler, n, object);
    }

    @Override
    public void registerForSubscriptionInfoReady(Handler handler, int n, Object object) {
        this.logUnexpectedCdmaMethodCall("registerForSubscriptionInfoReady");
    }

    @Override
    public void registerForSuppServiceFailed(Handler handler, int n, Object object) {
        this.checkCorrectThread(handler);
        this.mSuppServiceFailedRegistrants.addUnique(handler, n, object);
    }

    @Override
    public void registerForT53AudioControlInfo(Handler handler, int n, Object object) {
        this.mCM.registerForT53AudioControlInfo(handler, n, object);
    }

    @Override
    public void registerForUnknownConnection(Handler handler, int n, Object object) {
        this.checkCorrectThread(handler);
        this.mUnknownConnectionRegistrants.addUnique(handler, n, object);
    }

    public void restoreSavedNetworkSelection(Message message) {
        String string2 = this.getSavedNetworkSelection();
        if (TextUtils.isEmpty(string2)) {
            this.mCM.setNetworkSelectionModeAutomatic(message);
            return;
        }
        this.mCM.setNetworkSelectionModeManual(string2, message);
    }

    @Override
    public void sendBurstDtmf(String string2, int n, int n2, Message message) {
        this.logUnexpectedCdmaMethodCall("sendBurstDtmf");
    }

    @Override
    public void setBandMode(int n, Message message) {
        this.mCM.setBandMode(n, message);
    }

    @Override
    public void setCdmaRoamingPreference(int n, Message message) {
        this.mCM.setCdmaRoamingPreference(n, message);
    }

    @Override
    public void setCdmaSubscription(int n, Message message) {
        this.mCM.setCdmaSubscription(n, message);
    }

    @Override
    public void setEchoSuppressionEnabled(boolean bl) {
    }

    @Override
    public void setOnEcbModeExitResponse(Handler handler, int n, Object object) {
        this.logUnexpectedCdmaMethodCall("setOnEcbModeExitResponse");
    }

    @Override
    public void setPreferredNetworkType(int n, Message message) {
        this.mCM.setPreferredNetworkType(n, message);
    }

    @Override
    public void setSmscAddress(String string2, Message message) {
        this.mCM.setSmscAddress(string2, message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSystemLocale(String string2, String string3) {
        int n;
        String string4;
        int n2;
        String[] stringArray;
        String string5 = SystemProperties.get("persist.sys.language");
        String string6 = SystemProperties.get("persist.sys.country");
        if (string2 == null) {
            return;
        }
        string2 = string2.toLowerCase();
        if (string3 == null) {
            string3 = "";
        }
        string3 = string3.toUpperCase();
        if (string5 != null && string5.length() != 0) {
            return;
        }
        if (string6 != null && string6.length() != 0) {
            return;
        }
        try {
            stringArray = this.mContext.getAssets().getLocales();
            n2 = stringArray.length;
            string4 = null;
            n = 0;
        }
        catch (Exception exception) {
            return;
        }
        while (true) {
            block13: {
                block14: {
                    Locale locale;
                    block12: {
                        if (n >= n2) break block12;
                        if (stringArray[n] == null || stringArray[n].length() < 5 || !stringArray[n].substring(0, 2).equals(string2)) break block13;
                        if (!stringArray[n].substring(3, 5).equals(string3)) break block14;
                        string4 = stringArray[n];
                    }
                    if (string4 == null) {
                        return;
                    }
                    IActivityManager iActivityManager = ActivityManagerNative.getDefault();
                    Configuration configuration = iActivityManager.getConfiguration();
                    String string7 = string4.substring(0, 2);
                    String string8 = string4.substring(3, 5);
                    configuration.locale = locale = new Locale(string7, string8);
                    configuration.userSetLocale = true;
                    iActivityManager.updateConfiguration(configuration);
                    return;
                }
                if (string4 == null) {
                    string4 = stringArray[n];
                }
            }
            ++n;
        }
    }

    public void setSystemProperty(String string2, String string3) {
        if (this.getUnitTestMode()) {
            return;
        }
        SystemProperties.set(string2, string3);
    }

    @Override
    public void setTTYMode(int n, Message message) {
        this.mCM.setTTYMode(n, message);
    }

    @Override
    public void setUnitTestMode(boolean bl) {
        this.mUnitTestMode = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void simulateDataConnection(Phone.DataState dataState) {
        DataConnectionTracker.State state;
        int[] nArray = 1.$SwitchMap$com$android$internal$telephony$Phone$DataState;
        int n = dataState.ordinal();
        switch (nArray[n]) {
            default: {
                state = DataConnectionTracker.State.CONNECTING;
                break;
            }
            case 1: {
                state = DataConnectionTracker.State.CONNECTED;
                break;
            }
            case 2: {
                state = DataConnectionTracker.State.CONNECTED;
                break;
            }
            case 3: {
                state = DataConnectionTracker.State.FAILED;
            }
        }
        this.mDataConnection.setState(state);
        this.notifyDataConnection(null);
    }

    @Override
    public void unregisterForCallWaiting(Handler handler) {
        this.logUnexpectedCdmaMethodCall("unregisterForCallWaiting");
    }

    @Override
    public void unregisterForCdmaOtaStatusChange(Handler handler) {
        this.logUnexpectedCdmaMethodCall("unregisterForCdmaOtaStatusChange");
    }

    @Override
    public void unregisterForDisconnect(Handler handler) {
        this.mDisconnectRegistrants.remove(handler);
    }

    @Override
    public void unregisterForDisplayInfo(Handler handler) {
        this.mCM.unregisterForDisplayInfo(handler);
    }

    @Override
    public void unregisterForEcmTimerReset(Handler handler) {
        this.logUnexpectedCdmaMethodCall("unregisterForEcmTimerReset");
    }

    @Override
    public void unregisterForInCallVoicePrivacyOff(Handler handler) {
        this.mCM.unregisterForInCallVoicePrivacyOff(handler);
    }

    @Override
    public void unregisterForInCallVoicePrivacyOn(Handler handler) {
        this.mCM.unregisterForInCallVoicePrivacyOn(handler);
    }

    @Override
    public void unregisterForIncomingRing(Handler handler) {
        this.mIncomingRingRegistrants.remove(handler);
    }

    @Override
    public void unregisterForLineControlInfo(Handler handler) {
        this.mCM.unregisterForLineControlInfo(handler);
    }

    @Override
    public void unregisterForMmiComplete(Handler handler) {
        this.checkCorrectThread(handler);
        this.mMmiCompleteRegistrants.remove(handler);
    }

    @Override
    public void unregisterForMmiInitiate(Handler handler) {
        this.mMmiRegistrants.remove(handler);
    }

    @Override
    public void unregisterForNewRingingConnection(Handler handler) {
        this.mNewRingingConnectionRegistrants.remove(handler);
    }

    @Override
    public void unregisterForNumberInfo(Handler handler) {
        this.mCM.unregisterForNumberInfo(handler);
    }

    @Override
    public void unregisterForPreciseCallStateChanged(Handler handler) {
        this.mPreciseCallStateRegistrants.remove(handler);
    }

    @Override
    public void unregisterForRedirectedNumberInfo(Handler handler) {
        this.mCM.unregisterForRedirectedNumberInfo(handler);
    }

    @Override
    public void unregisterForResendIncallMute(Handler handler) {
        this.mCM.unregisterForResendIncallMute(handler);
    }

    @Override
    public void unregisterForRingbackTone(Handler handler) {
        this.mCM.unregisterForRingbackTone(handler);
    }

    @Override
    public void unregisterForServiceStateChanged(Handler handler) {
        this.mServiceStateRegistrants.remove(handler);
    }

    @Override
    public void unregisterForSignalInfo(Handler handler) {
        this.mCM.unregisterForSignalInfo(handler);
    }

    @Override
    public void unregisterForSubscriptionInfoReady(Handler handler) {
        this.logUnexpectedCdmaMethodCall("unregisterForSubscriptionInfoReady");
    }

    @Override
    public void unregisterForSuppServiceFailed(Handler handler) {
        this.mSuppServiceFailedRegistrants.remove(handler);
    }

    @Override
    public void unregisterForT53AudioControlInfo(Handler handler) {
        this.mCM.unregisterForT53AudioControlInfo(handler);
    }

    @Override
    public void unregisterForT53ClirInfo(Handler handler) {
        this.mCM.unregisterForT53ClirInfo(handler);
    }

    @Override
    public void unregisterForUnknownConnection(Handler handler) {
        this.mUnknownConnectionRegistrants.remove(handler);
    }

    @Override
    public void unsetOnEcbModeExitResponse(Handler handler) {
        this.logUnexpectedCdmaMethodCall("unsetOnEcbModeExitResponse");
    }
}

