/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.net.LocalServerSocket;
import android.os.Looper;
import android.provider.Settings;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DefaultPhoneNotifier;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.RIL;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.sip.SipPhone;
import com.android.internal.telephony.sip.SipPhoneFactory;
import java.io.IOException;

public class PhoneFactory {
    static final String LOG_TAG = "PHONE";
    static final int SOCKET_OPEN_MAX_RETRY = 3;
    static final int SOCKET_OPEN_RETRY_MILLIS = 2000;
    static final int preferredCdmaSubscription = 1;
    static final int preferredNetworkMode;
    private static CommandsInterface sCommandsInterface;
    private static Context sContext;
    private static Looper sLooper;
    private static boolean sMadeDefaults;
    private static PhoneNotifier sPhoneNotifier;
    private static Phone sProxyPhone;

    static {
        sProxyPhone = null;
        sCommandsInterface = null;
        sMadeDefaults = false;
    }

    public static Phone getCdmaPhone() {
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            Context context = sContext;
            CommandsInterface commandsInterface = sCommandsInterface;
            PhoneNotifier phoneNotifier = sPhoneNotifier;
            CDMAPhone cDMAPhone = new CDMAPhone(context, commandsInterface, phoneNotifier);
            return cDMAPhone;
        }
    }

    public static Phone getDefaultPhone() {
        Looper looper = sLooper;
        Looper looper2 = Looper.myLooper();
        if (looper != looper2) {
            throw new RuntimeException("PhoneFactory.getDefaultPhone must be called from Looper thread");
        }
        if (!sMadeDefaults) {
            throw new IllegalStateException("Default phones haven't been made yet!");
        }
        return sProxyPhone;
    }

    public static Phone getGsmPhone() {
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            Context context = sContext;
            CommandsInterface commandsInterface = sCommandsInterface;
            PhoneNotifier phoneNotifier = sPhoneNotifier;
            GSMPhone gSMPhone = new GSMPhone(context, commandsInterface, phoneNotifier);
            return gSMPhone;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getPhoneType(int n) {
        int n2 = 1;
        switch (n) {
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
            }
            default: {
                return n2;
            }
            case 7: 
        }
        return 2;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void makeDefaultPhone(Context var0) {
        synchronized (Phone.class) {
            if (PhoneFactory.sMadeDefaults) ** GOTO lbl44
            PhoneFactory.sLooper = Looper.myLooper();
            PhoneFactory.sContext = var0;
            if (PhoneFactory.sLooper == null) {
                throw new RuntimeException("PhoneFactory.makeDefaultPhone must be called from Looper thread");
            }
            var2_1 = 0;
            while (true) {
                block16: {
                    var3_2 = false;
                    ++var2_1;
                    try {
                        var4_3 = new LocalServerSocket("com.android.internal.telephony");
                    }
                    catch (IOException var20_4) {
                        var3_2 = true;
                    }
                    if (var3_2) break block16;
                    PhoneFactory.sPhoneNotifier = new DefaultPhoneNotifier();
                    var5_7 = Settings.Secure.getInt(var0.getContentResolver(), "preferred_network_mode", 0);
                    var6_8 = new StringBuilder().append("Network Mode set to ");
                    var7_9 = Integer.toString(var5_7);
                    var8_10 = var6_8.append(var7_9).toString();
                    var9_11 = Log.i("PHONE", var8_10);
                    var10_12 = Settings.Secure.getInt(var0.getContentResolver(), "preferred_cdma_subscription", 1);
                    var11_13 = new StringBuilder().append("Cdma Subscription set to ");
                    var12_14 = Integer.toString(var10_12);
                    var13_15 = var11_13.append(var12_14).toString();
                    var14_16 = Log.i("PHONE", var13_15);
                    PhoneFactory.sCommandsInterface = new RIL(var0, var5_7, var10_12);
                    var15_17 = PhoneFactory.getPhoneType(var5_7);
                    if (var15_17 == 1) {
                        var16_18 = Log.i("PHONE", "Creating GSMPhone");
                        var17_19 = PhoneFactory.sCommandsInterface;
                        var18_20 = PhoneFactory.sPhoneNotifier;
                        var19_21 = new GSMPhone(var0, var17_19, var18_20);
                        PhoneFactory.sProxyPhone = new PhoneProxy(var19_21);
                    } else if (var15_17 == 2) {
                        var24_22 = Log.i("PHONE", "Creating CDMAPhone");
                        var25_23 = PhoneFactory.sCommandsInterface;
                        var26_24 = PhoneFactory.sPhoneNotifier;
                        var27_25 = new CDMAPhone(var0, var25_23, var26_24);
                        PhoneFactory.sProxyPhone = new PhoneProxy(var27_25);
                    }
                    PhoneFactory.sMadeDefaults = true;
lbl44:
                    // 2 sources

                    return;
                }
                if (var2_1 > 3) {
                    throw new RuntimeException("PhoneFactory probably already running");
                }
                var21_5 = 2000L;
                try {
                    Thread.sleep(var21_5);
                }
                catch (InterruptedException var23_6) {
                }
            }
        }
    }

    public static void makeDefaultPhones(Context context) {
        PhoneFactory.makeDefaultPhone(context);
    }

    public static SipPhone makeSipPhone(String string2) {
        Context context = sContext;
        PhoneNotifier phoneNotifier = sPhoneNotifier;
        return SipPhoneFactory.makePhone(string2, context, phoneNotifier);
    }
}

