/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.ActivityManagerNative;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.os.SystemProperties;
import android.telephony.CellLocation;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccPhoneBookInterfaceManager;
import com.android.internal.telephony.IccPhoneBookInterfaceManagerProxy;
import com.android.internal.telephony.IccSmsInterfaceManager;
import com.android.internal.telephony.IccSmsInterfaceManagerProxy;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.PhoneSubInfo;
import com.android.internal.telephony.PhoneSubInfoProxy;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.NetworkInfo;
import com.android.internal.telephony.test.SimulatedRadioControl;
import java.util.List;

public class PhoneProxy
extends Handler
implements Phone {
    private static final int EVENT_RADIO_TECHNOLOGY_CHANGED = 1;
    private static final String LOG_TAG = "PHONE";
    public static final Object lockForRadioTechnologyChange = new Object();
    private Phone mActivePhone;
    private CommandsInterface mCommandsInterface;
    private IccPhoneBookInterfaceManagerProxy mIccPhoneBookInterfaceManagerProxy;
    private IccSmsInterfaceManagerProxy mIccSmsInterfaceManagerProxy;
    private String mOutgoingPhone;
    private PhoneSubInfoProxy mPhoneSubInfoProxy;
    private boolean mResetModemOnRadioTechnologyChange = false;

    public PhoneProxy(Phone phone) {
        CommandsInterface commandsInterface;
        PhoneSubInfoProxy phoneSubInfoProxy;
        IccPhoneBookInterfaceManagerProxy iccPhoneBookInterfaceManagerProxy;
        IccSmsInterfaceManagerProxy iccSmsInterfaceManagerProxy;
        boolean bl;
        this.mActivePhone = phone;
        this.mResetModemOnRadioTechnologyChange = bl = SystemProperties.getBoolean("persist.radio.reset_on_switch", false);
        IccSmsInterfaceManager iccSmsInterfaceManager = phone.getIccSmsInterfaceManager();
        this.mIccSmsInterfaceManagerProxy = iccSmsInterfaceManagerProxy = new IccSmsInterfaceManagerProxy(iccSmsInterfaceManager);
        IccPhoneBookInterfaceManager iccPhoneBookInterfaceManager = phone.getIccPhoneBookInterfaceManager();
        this.mIccPhoneBookInterfaceManagerProxy = iccPhoneBookInterfaceManagerProxy = new IccPhoneBookInterfaceManagerProxy(iccPhoneBookInterfaceManager);
        PhoneSubInfo phoneSubInfo = phone.getPhoneSubInfo();
        this.mPhoneSubInfoProxy = phoneSubInfoProxy = new PhoneSubInfoProxy(phoneSubInfo);
        this.mCommandsInterface = commandsInterface = ((PhoneBase)this.mActivePhone).mCM;
        this.mCommandsInterface.registerForRadioTechnologyChanged(this, 1, null);
    }

    private void logd(String string2) {
        String string3 = "[PhoneProxy] " + string2;
        int n = Log.d(LOG_TAG, string3);
    }

    private void loge(String string2) {
        String string3 = "[PhoneProxy] " + string2;
        int n = Log.e(LOG_TAG, string3);
    }

    private void logv(String string2) {
        String string3 = "[PhoneProxy] " + string2;
        int n = Log.v(LOG_TAG, string3);
    }

    private void logw(String string2) {
        String string3 = "[PhoneProxy] " + string2;
        int n = Log.w(LOG_TAG, string3);
    }

    @Override
    public void acceptCall() throws CallStateException {
        this.mActivePhone.acceptCall();
    }

    @Override
    public void activateCellBroadcastSms(int n, Message message) {
        this.mActivePhone.activateCellBroadcastSms(n, message);
    }

    @Override
    public boolean canConference() {
        return this.mActivePhone.canConference();
    }

    @Override
    public boolean canTransfer() {
        return this.mActivePhone.canTransfer();
    }

    @Override
    public void clearDisconnected() {
        this.mActivePhone.clearDisconnected();
    }

    @Override
    public void conference() throws CallStateException {
        this.mActivePhone.conference();
    }

    @Override
    public Connection dial(String string2) throws CallStateException {
        return this.mActivePhone.dial(string2);
    }

    @Override
    public Connection dial(String string2, UUSInfo uUSInfo) throws CallStateException {
        return this.mActivePhone.dial(string2, uUSInfo);
    }

    @Override
    public int disableApnType(String string2) {
        return this.mActivePhone.disableApnType(string2);
    }

    @Override
    public boolean disableDataConnectivity() {
        return this.mActivePhone.disableDataConnectivity();
    }

    @Override
    public void disableDnsCheck(boolean bl) {
        this.mActivePhone.disableDnsCheck(bl);
    }

    @Override
    public void disableLocationUpdates() {
        this.mActivePhone.disableLocationUpdates();
    }

    @Override
    public int enableApnType(String string2) {
        return this.mActivePhone.enableApnType(string2);
    }

    @Override
    public boolean enableDataConnectivity() {
        return this.mActivePhone.enableDataConnectivity();
    }

    @Override
    public void enableEnhancedVoicePrivacy(boolean bl, Message message) {
        this.mActivePhone.enableEnhancedVoicePrivacy(bl, message);
    }

    @Override
    public void enableLocationUpdates() {
        this.mActivePhone.enableLocationUpdates();
    }

    @Override
    public void exitEmergencyCallbackMode() {
        this.mActivePhone.exitEmergencyCallbackMode();
    }

    @Override
    public void explicitCallTransfer() throws CallStateException {
        this.mActivePhone.explicitCallTransfer();
    }

    @Override
    public String getActiveApn() {
        return this.mActivePhone.getActiveApn();
    }

    @Override
    public String[] getActiveApnTypes() {
        return this.mActivePhone.getActiveApnTypes();
    }

    @Override
    public void getAvailableNetworks(Message message) {
        this.mActivePhone.getAvailableNetworks(message);
    }

    @Override
    public Call getBackgroundCall() {
        return this.mActivePhone.getBackgroundCall();
    }

    @Override
    public boolean getCallForwardingIndicator() {
        return this.mActivePhone.getCallForwardingIndicator();
    }

    @Override
    public void getCallForwardingOption(int n, Message message) {
        this.mActivePhone.getCallForwardingOption(n, message);
    }

    @Override
    public void getCallWaiting(Message message) {
        this.mActivePhone.getCallWaiting(message);
    }

    @Override
    public int getCdmaEriIconIndex() {
        return this.mActivePhone.getCdmaEriIconIndex();
    }

    @Override
    public int getCdmaEriIconMode() {
        return this.mActivePhone.getCdmaEriIconMode();
    }

    @Override
    public String getCdmaEriText() {
        return this.mActivePhone.getCdmaEriText();
    }

    @Override
    public String getCdmaMin() {
        return this.mActivePhone.getCdmaMin();
    }

    @Override
    public String getCdmaPrlVersion() {
        return this.mActivePhone.getCdmaPrlVersion();
    }

    @Override
    public void getCellBroadcastSmsConfig(Message message) {
        this.mActivePhone.getCellBroadcastSmsConfig(message);
    }

    @Override
    public CellLocation getCellLocation() {
        return this.mActivePhone.getCellLocation();
    }

    @Override
    public Context getContext() {
        return this.mActivePhone.getContext();
    }

    @Override
    public List<DataConnection> getCurrentDataConnectionList() {
        return this.mActivePhone.getCurrentDataConnectionList();
    }

    @Override
    public Phone.DataActivityState getDataActivityState() {
        return this.mActivePhone.getDataActivityState();
    }

    @Override
    public void getDataCallList(Message message) {
        this.mActivePhone.getDataCallList(message);
    }

    @Override
    public Phone.DataState getDataConnectionState() {
        return this.mActivePhone.getDataConnectionState();
    }

    @Override
    public boolean getDataRoamingEnabled() {
        return this.mActivePhone.getDataRoamingEnabled();
    }

    @Override
    public String getDeviceId() {
        return this.mActivePhone.getDeviceId();
    }

    @Override
    public String getDeviceSvn() {
        return this.mActivePhone.getDeviceSvn();
    }

    @Override
    public String[] getDnsServers(String string2) {
        return this.mActivePhone.getDnsServers(string2);
    }

    @Override
    public void getEnhancedVoicePrivacy(Message message) {
        this.mActivePhone.getEnhancedVoicePrivacy(message);
    }

    @Override
    public String getEsn() {
        return this.mActivePhone.getEsn();
    }

    @Override
    public Call getForegroundCall() {
        return this.mActivePhone.getForegroundCall();
    }

    @Override
    public String getGateway(String string2) {
        return this.mActivePhone.getGateway(string2);
    }

    @Override
    public IccCard getIccCard() {
        return this.mActivePhone.getIccCard();
    }

    @Override
    public IccPhoneBookInterfaceManager getIccPhoneBookInterfaceManager() {
        return this.mActivePhone.getIccPhoneBookInterfaceManager();
    }

    @Override
    public boolean getIccRecordsLoaded() {
        return this.mActivePhone.getIccRecordsLoaded();
    }

    @Override
    public String getIccSerialNumber() {
        return this.mActivePhone.getIccSerialNumber();
    }

    @Override
    public IccSmsInterfaceManager getIccSmsInterfaceManager() {
        return this.mActivePhone.getIccSmsInterfaceManager();
    }

    @Override
    public String getInterfaceName(String string2) {
        return this.mActivePhone.getInterfaceName(string2);
    }

    @Override
    public String getIpAddress(String string2) {
        return this.mActivePhone.getIpAddress(string2);
    }

    @Override
    public String getLine1AlphaTag() {
        return this.mActivePhone.getLine1AlphaTag();
    }

    @Override
    public String getLine1Number() {
        return this.mActivePhone.getLine1Number();
    }

    @Override
    public String getMeid() {
        return this.mActivePhone.getMeid();
    }

    @Override
    public boolean getMessageWaitingIndicator() {
        return this.mActivePhone.getMessageWaitingIndicator();
    }

    @Override
    public boolean getMute() {
        return this.mActivePhone.getMute();
    }

    @Override
    public void getNeighboringCids(Message message) {
        this.mActivePhone.getNeighboringCids(message);
    }

    @Override
    public void getOutgoingCallerIdDisplay(Message message) {
        this.mActivePhone.getOutgoingCallerIdDisplay(message);
    }

    @Override
    public List<? extends MmiCode> getPendingMmiCodes() {
        return this.mActivePhone.getPendingMmiCodes();
    }

    @Override
    public String getPhoneName() {
        return this.mActivePhone.getPhoneName();
    }

    @Override
    public PhoneSubInfo getPhoneSubInfo() {
        return this.mActivePhone.getPhoneSubInfo();
    }

    @Override
    public int getPhoneType() {
        return this.mActivePhone.getPhoneType();
    }

    @Override
    public void getPreferredNetworkType(Message message) {
        this.mActivePhone.getPreferredNetworkType(message);
    }

    @Override
    public Call getRingingCall() {
        return this.mActivePhone.getRingingCall();
    }

    @Override
    public ServiceState getServiceState() {
        return this.mActivePhone.getServiceState();
    }

    @Override
    public SignalStrength getSignalStrength() {
        return this.mActivePhone.getSignalStrength();
    }

    @Override
    public SimulatedRadioControl getSimulatedRadioControl() {
        return this.mActivePhone.getSimulatedRadioControl();
    }

    @Override
    public void getSmscAddress(Message message) {
        this.mActivePhone.getSmscAddress(message);
    }

    @Override
    public Phone.State getState() {
        return this.mActivePhone.getState();
    }

    @Override
    public String getSubscriberId() {
        return this.mActivePhone.getSubscriberId();
    }

    @Override
    public boolean getUnitTestMode() {
        return this.mActivePhone.getUnitTestMode();
    }

    @Override
    public String getVoiceMailAlphaTag() {
        return this.mActivePhone.getVoiceMailAlphaTag();
    }

    @Override
    public String getVoiceMailNumber() {
        return this.mActivePhone.getVoiceMailNumber();
    }

    @Override
    public int getVoiceMessageCount() {
        return this.mActivePhone.getVoiceMessageCount();
    }

    @Override
    public boolean handleInCallMmiCommands(String string2) throws CallStateException {
        return this.mActivePhone.handleInCallMmiCommands(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                StringBuilder stringBuilder = new StringBuilder().append("Error! This handler was not registered for this message type. Message: ");
                int n = message.what;
                String string2 = stringBuilder.append(n).toString();
                int n2 = Log.e(LOG_TAG, string2);
                break;
            }
            case 1: {
                CommandsInterface commandsInterface;
                String string3;
                this.mOutgoingPhone = string3 = ((PhoneBase)this.mActivePhone).getPhoneName();
                StringBuilder stringBuilder = new StringBuilder().append("Switching phone from ");
                String string4 = this.mOutgoingPhone;
                StringBuilder stringBuilder2 = stringBuilder.append(string4).append("Phone to ");
                String string5 = this.mOutgoingPhone.equals("GSM") ? "CDMAPhone" : "GSMPhone";
                String string6 = stringBuilder2.append(string5).toString();
                this.logd(string6);
                boolean bl = false;
                if (this.mResetModemOnRadioTechnologyChange && this.mCommandsInterface.getRadioState().isOn()) {
                    bl = true;
                    this.logd("Setting Radio Power to Off");
                    this.mCommandsInterface.setRadioPower(false, null);
                }
                if (this.mOutgoingPhone.equals("GSM")) {
                    Phone phone;
                    this.logd("Make a new CDMAPhone and destroy the old GSMPhone.");
                    ((GSMPhone)this.mActivePhone).dispose();
                    Phone phone2 = this.mActivePhone;
                    this.mActivePhone = phone = PhoneFactory.getCdmaPhone();
                    ((GSMPhone)phone2).removeReferences();
                } else {
                    Phone phone;
                    this.logd("Make a new GSMPhone and destroy the old CDMAPhone.");
                    ((CDMAPhone)this.mActivePhone).dispose();
                    Phone phone3 = this.mActivePhone;
                    this.mActivePhone = phone = PhoneFactory.getGsmPhone();
                    ((CDMAPhone)phone3).removeReferences();
                }
                if (this.mResetModemOnRadioTechnologyChange) {
                    this.logd("Resetting Radio");
                    this.mCommandsInterface.setRadioPower(bl, null);
                }
                IccSmsInterfaceManagerProxy iccSmsInterfaceManagerProxy = this.mIccSmsInterfaceManagerProxy;
                IccSmsInterfaceManager iccSmsInterfaceManager = this.mActivePhone.getIccSmsInterfaceManager();
                iccSmsInterfaceManagerProxy.setmIccSmsInterfaceManager(iccSmsInterfaceManager);
                IccPhoneBookInterfaceManagerProxy iccPhoneBookInterfaceManagerProxy = this.mIccPhoneBookInterfaceManagerProxy;
                IccPhoneBookInterfaceManager iccPhoneBookInterfaceManager = this.mActivePhone.getIccPhoneBookInterfaceManager();
                iccPhoneBookInterfaceManagerProxy.setmIccPhoneBookInterfaceManager(iccPhoneBookInterfaceManager);
                PhoneSubInfoProxy phoneSubInfoProxy = this.mPhoneSubInfoProxy;
                PhoneSubInfo phoneSubInfo = this.mActivePhone.getPhoneSubInfo();
                phoneSubInfoProxy.setmPhoneSubInfo(phoneSubInfo);
                this.mCommandsInterface = commandsInterface = ((PhoneBase)this.mActivePhone).mCM;
                Intent intent = new Intent("android.intent.action.RADIO_TECHNOLOGY");
                Intent intent2 = intent.addFlags(0x20000000);
                String string7 = this.mActivePhone.getPhoneName();
                Intent intent3 = intent.putExtra("phoneName", string7);
                ActivityManagerNative.broadcastStickyIntent(intent, null);
            }
        }
        super.handleMessage(message);
    }

    @Override
    public boolean handlePinMmi(String string2) {
        return this.mActivePhone.handlePinMmi(string2);
    }

    @Override
    public void invokeOemRilRequestRaw(byte[] byArray, Message message) {
        this.mActivePhone.invokeOemRilRequestRaw(byArray, message);
    }

    @Override
    public void invokeOemRilRequestStrings(String[] stringArray, Message message) {
        this.mActivePhone.invokeOemRilRequestStrings(stringArray, message);
    }

    @Override
    public boolean isDataConnectivityEnabled() {
        return this.mActivePhone.isDataConnectivityEnabled();
    }

    @Override
    public boolean isDataConnectivityPossible() {
        return this.mActivePhone.isDataConnectivityPossible();
    }

    @Override
    public boolean isDnsCheckDisabled() {
        return this.mActivePhone.isDnsCheckDisabled();
    }

    @Override
    public boolean isMinInfoReady() {
        return this.mActivePhone.isMinInfoReady();
    }

    @Override
    public boolean isOtaSpNumber(String string2) {
        return this.mActivePhone.isOtaSpNumber(string2);
    }

    @Override
    public void notifyDataActivity() {
        this.mActivePhone.notifyDataActivity();
    }

    @Override
    public void queryAvailableBandMode(Message message) {
        this.mActivePhone.queryAvailableBandMode(message);
    }

    @Override
    public void queryCdmaRoamingPreference(Message message) {
        this.mActivePhone.queryCdmaRoamingPreference(message);
    }

    @Override
    public void queryTTYMode(Message message) {
        this.mActivePhone.queryTTYMode(message);
    }

    @Override
    public void registerFoT53ClirlInfo(Handler handler, int n, Object object) {
        this.mActivePhone.registerFoT53ClirlInfo(handler, n, object);
    }

    @Override
    public void registerForCallWaiting(Handler handler, int n, Object object) {
        this.mActivePhone.registerForCallWaiting(handler, n, object);
    }

    @Override
    public void registerForCdmaOtaStatusChange(Handler handler, int n, Object object) {
        this.mActivePhone.registerForCdmaOtaStatusChange(handler, n, object);
    }

    @Override
    public void registerForDisconnect(Handler handler, int n, Object object) {
        this.mActivePhone.registerForDisconnect(handler, n, object);
    }

    @Override
    public void registerForDisplayInfo(Handler handler, int n, Object object) {
        this.mActivePhone.registerForDisplayInfo(handler, n, object);
    }

    @Override
    public void registerForEcmTimerReset(Handler handler, int n, Object object) {
        this.mActivePhone.registerForEcmTimerReset(handler, n, object);
    }

    @Override
    public void registerForInCallVoicePrivacyOff(Handler handler, int n, Object object) {
        this.mActivePhone.registerForInCallVoicePrivacyOff(handler, n, object);
    }

    @Override
    public void registerForInCallVoicePrivacyOn(Handler handler, int n, Object object) {
        this.mActivePhone.registerForInCallVoicePrivacyOn(handler, n, object);
    }

    @Override
    public void registerForIncomingRing(Handler handler, int n, Object object) {
        this.mActivePhone.registerForIncomingRing(handler, n, object);
    }

    @Override
    public void registerForLineControlInfo(Handler handler, int n, Object object) {
        this.mActivePhone.registerForLineControlInfo(handler, n, object);
    }

    @Override
    public void registerForMmiComplete(Handler handler, int n, Object object) {
        this.mActivePhone.registerForMmiComplete(handler, n, object);
    }

    @Override
    public void registerForMmiInitiate(Handler handler, int n, Object object) {
        this.mActivePhone.registerForMmiInitiate(handler, n, object);
    }

    @Override
    public void registerForNewRingingConnection(Handler handler, int n, Object object) {
        this.mActivePhone.registerForNewRingingConnection(handler, n, object);
    }

    @Override
    public void registerForNumberInfo(Handler handler, int n, Object object) {
        this.mActivePhone.registerForNumberInfo(handler, n, object);
    }

    @Override
    public void registerForPreciseCallStateChanged(Handler handler, int n, Object object) {
        this.mActivePhone.registerForPreciseCallStateChanged(handler, n, object);
    }

    @Override
    public void registerForRedirectedNumberInfo(Handler handler, int n, Object object) {
        this.mActivePhone.registerForRedirectedNumberInfo(handler, n, object);
    }

    @Override
    public void registerForResendIncallMute(Handler handler, int n, Object object) {
        this.mActivePhone.registerForResendIncallMute(handler, n, object);
    }

    @Override
    public void registerForRingbackTone(Handler handler, int n, Object object) {
        this.mActivePhone.registerForRingbackTone(handler, n, object);
    }

    @Override
    public void registerForServiceStateChanged(Handler handler, int n, Object object) {
        this.mActivePhone.registerForServiceStateChanged(handler, n, object);
    }

    @Override
    public void registerForSignalInfo(Handler handler, int n, Object object) {
        this.mActivePhone.registerForSignalInfo(handler, n, object);
    }

    @Override
    public void registerForSubscriptionInfoReady(Handler handler, int n, Object object) {
        this.mActivePhone.registerForSubscriptionInfoReady(handler, n, object);
    }

    @Override
    public void registerForSuppServiceFailed(Handler handler, int n, Object object) {
        this.mActivePhone.registerForSuppServiceFailed(handler, n, object);
    }

    @Override
    public void registerForSuppServiceNotification(Handler handler, int n, Object object) {
        this.mActivePhone.registerForSuppServiceNotification(handler, n, object);
    }

    @Override
    public void registerForT53AudioControlInfo(Handler handler, int n, Object object) {
        this.mActivePhone.registerForT53AudioControlInfo(handler, n, object);
    }

    @Override
    public void registerForUnknownConnection(Handler handler, int n, Object object) {
        this.mActivePhone.registerForUnknownConnection(handler, n, object);
    }

    @Override
    public void rejectCall() throws CallStateException {
        this.mActivePhone.rejectCall();
    }

    @Override
    public void selectNetworkManually(NetworkInfo networkInfo, Message message) {
        this.mActivePhone.selectNetworkManually(networkInfo, message);
    }

    @Override
    public void sendBurstDtmf(String string2, int n, int n2, Message message) {
        this.mActivePhone.sendBurstDtmf(string2, n, n2, message);
    }

    @Override
    public void sendDtmf(char c) {
        this.mActivePhone.sendDtmf(c);
    }

    @Override
    public void sendUssdResponse(String string2) {
        this.mActivePhone.sendUssdResponse(string2);
    }

    @Override
    public void setBandMode(int n, Message message) {
        this.mActivePhone.setBandMode(n, message);
    }

    @Override
    public void setCallForwardingOption(int n, int n2, String string2, int n3, Message message) {
        Phone phone = this.mActivePhone;
        int n4 = n;
        int n5 = n2;
        String string3 = string2;
        int n6 = n3;
        Message message2 = message;
        phone.setCallForwardingOption(n4, n5, string3, n6, message2);
    }

    @Override
    public void setCallWaiting(boolean bl, Message message) {
        this.mActivePhone.setCallWaiting(bl, message);
    }

    @Override
    public void setCdmaRoamingPreference(int n, Message message) {
        this.mActivePhone.setCdmaRoamingPreference(n, message);
    }

    @Override
    public void setCdmaSubscription(int n, Message message) {
        this.mActivePhone.setCdmaSubscription(n, message);
    }

    @Override
    public void setCellBroadcastSmsConfig(int[] nArray, Message message) {
        this.mActivePhone.setCellBroadcastSmsConfig(nArray, message);
    }

    @Override
    public void setDataRoamingEnabled(boolean bl) {
        this.mActivePhone.setDataRoamingEnabled(bl);
    }

    @Override
    public void setEchoSuppressionEnabled(boolean bl) {
        this.mActivePhone.setEchoSuppressionEnabled(bl);
    }

    @Override
    public void setLine1Number(String string2, String string3, Message message) {
        this.mActivePhone.setLine1Number(string2, string3, message);
    }

    @Override
    public void setMute(boolean bl) {
        this.mActivePhone.setMute(bl);
    }

    @Override
    public void setNetworkSelectionModeAutomatic(Message message) {
        this.mActivePhone.setNetworkSelectionModeAutomatic(message);
    }

    @Override
    public void setOnEcbModeExitResponse(Handler handler, int n, Object object) {
        this.mActivePhone.setOnEcbModeExitResponse(handler, n, object);
    }

    @Override
    public void setOnPostDialCharacter(Handler handler, int n, Object object) {
        this.mActivePhone.setOnPostDialCharacter(handler, n, object);
    }

    @Override
    public void setOutgoingCallerIdDisplay(int n, Message message) {
        this.mActivePhone.setOutgoingCallerIdDisplay(n, message);
    }

    @Override
    public void setPreferredNetworkType(int n, Message message) {
        this.mActivePhone.setPreferredNetworkType(n, message);
    }

    @Override
    public void setRadioPower(boolean bl) {
        this.mActivePhone.setRadioPower(bl);
    }

    @Override
    public void setSmscAddress(String string2, Message message) {
        this.mActivePhone.setSmscAddress(string2, message);
    }

    @Override
    public void setTTYMode(int n, Message message) {
        this.mActivePhone.setTTYMode(n, message);
    }

    @Override
    public void setUnitTestMode(boolean bl) {
        this.mActivePhone.setUnitTestMode(bl);
    }

    @Override
    public void setVoiceMailNumber(String string2, String string3, Message message) {
        this.mActivePhone.setVoiceMailNumber(string2, string3, message);
    }

    @Override
    public void startDtmf(char c) {
        this.mActivePhone.startDtmf(c);
    }

    @Override
    public void stopDtmf() {
        this.mActivePhone.stopDtmf();
    }

    @Override
    public void switchHoldingAndActive() throws CallStateException {
        this.mActivePhone.switchHoldingAndActive();
    }

    @Override
    public void unregisterForCallWaiting(Handler handler) {
        this.mActivePhone.unregisterForCallWaiting(handler);
    }

    @Override
    public void unregisterForCdmaOtaStatusChange(Handler handler) {
        this.mActivePhone.unregisterForCdmaOtaStatusChange(handler);
    }

    @Override
    public void unregisterForDisconnect(Handler handler) {
        this.mActivePhone.unregisterForDisconnect(handler);
    }

    @Override
    public void unregisterForDisplayInfo(Handler handler) {
        this.mActivePhone.unregisterForDisplayInfo(handler);
    }

    @Override
    public void unregisterForEcmTimerReset(Handler handler) {
        this.mActivePhone.unregisterForEcmTimerReset(handler);
    }

    @Override
    public void unregisterForInCallVoicePrivacyOff(Handler handler) {
        this.mActivePhone.unregisterForInCallVoicePrivacyOff(handler);
    }

    @Override
    public void unregisterForInCallVoicePrivacyOn(Handler handler) {
        this.mActivePhone.unregisterForInCallVoicePrivacyOn(handler);
    }

    @Override
    public void unregisterForIncomingRing(Handler handler) {
        this.mActivePhone.unregisterForIncomingRing(handler);
    }

    @Override
    public void unregisterForLineControlInfo(Handler handler) {
        this.mActivePhone.unregisterForLineControlInfo(handler);
    }

    @Override
    public void unregisterForMmiComplete(Handler handler) {
        this.mActivePhone.unregisterForMmiComplete(handler);
    }

    @Override
    public void unregisterForMmiInitiate(Handler handler) {
        this.mActivePhone.unregisterForMmiInitiate(handler);
    }

    @Override
    public void unregisterForNewRingingConnection(Handler handler) {
        this.mActivePhone.unregisterForNewRingingConnection(handler);
    }

    @Override
    public void unregisterForNumberInfo(Handler handler) {
        this.mActivePhone.unregisterForNumberInfo(handler);
    }

    @Override
    public void unregisterForPreciseCallStateChanged(Handler handler) {
        this.mActivePhone.unregisterForPreciseCallStateChanged(handler);
    }

    @Override
    public void unregisterForRedirectedNumberInfo(Handler handler) {
        this.mActivePhone.unregisterForRedirectedNumberInfo(handler);
    }

    @Override
    public void unregisterForResendIncallMute(Handler handler) {
        this.mActivePhone.unregisterForResendIncallMute(handler);
    }

    @Override
    public void unregisterForRingbackTone(Handler handler) {
        this.mActivePhone.unregisterForRingbackTone(handler);
    }

    @Override
    public void unregisterForServiceStateChanged(Handler handler) {
        this.mActivePhone.unregisterForServiceStateChanged(handler);
    }

    @Override
    public void unregisterForSignalInfo(Handler handler) {
        this.mActivePhone.unregisterForSignalInfo(handler);
    }

    @Override
    public void unregisterForSubscriptionInfoReady(Handler handler) {
        this.mActivePhone.unregisterForSubscriptionInfoReady(handler);
    }

    @Override
    public void unregisterForSuppServiceFailed(Handler handler) {
        this.mActivePhone.unregisterForSuppServiceFailed(handler);
    }

    @Override
    public void unregisterForSuppServiceNotification(Handler handler) {
        this.mActivePhone.unregisterForSuppServiceNotification(handler);
    }

    @Override
    public void unregisterForT53AudioControlInfo(Handler handler) {
        this.mActivePhone.unregisterForT53AudioControlInfo(handler);
    }

    @Override
    public void unregisterForT53ClirInfo(Handler handler) {
        this.mActivePhone.unregisterForT53ClirInfo(handler);
    }

    @Override
    public void unregisterForUnknownConnection(Handler handler) {
        this.mActivePhone.unregisterForUnknownConnection(handler);
    }

    @Override
    public void unsetOnEcbModeExitResponse(Handler handler) {
        this.mActivePhone.unsetOnEcbModeExitResponse(handler);
    }

    @Override
    public void updateServiceLocation() {
        this.mActivePhone.updateServiceLocation();
    }
}

