/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Message;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.util.Log;
import com.android.internal.telephony.Phone;

@Deprecated
public final class PhoneStateIntentReceiver
extends BroadcastReceiver {
    private static final boolean DBG = false;
    private static final String LOG_TAG = "PHONE";
    private static final int NOTIF_MAX = 32;
    private static final int NOTIF_PHONE = 1;
    private static final int NOTIF_SERVICE = 2;
    private static final int NOTIF_SIGNAL = 4;
    private int mAsuEventWhat;
    private Context mContext;
    private IntentFilter mFilter;
    private int mLocationEventWhat;
    Phone.State mPhoneState;
    private int mPhoneStateEventWhat;
    ServiceState mServiceState;
    private int mServiceStateEventWhat;
    SignalStrength mSignalStrength;
    private Handler mTarget;
    private int mWants;

    public PhoneStateIntentReceiver() {
        IntentFilter intentFilter;
        SignalStrength signalStrength;
        ServiceState serviceState;
        Phone.State state;
        this.mPhoneState = state = Phone.State.IDLE;
        this.mServiceState = serviceState = new ServiceState();
        this.mSignalStrength = signalStrength = new SignalStrength();
        this.mFilter = intentFilter = new IntentFilter();
    }

    public PhoneStateIntentReceiver(Context context, Handler handler) {
        this();
        this.setContext(context);
        this.setTarget(handler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getNotifyPhoneCallState() {
        if ((this.mWants & 1) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getNotifyServiceState() {
        if ((this.mWants & 2) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getNotifySignalStrength() {
        if ((this.mWants & 4) == 0) return false;
        return true;
    }

    public Phone.State getPhoneState() {
        if ((this.mWants & 1) == 0) {
            throw new RuntimeException("client must call notifyPhoneCallState(int)");
        }
        return this.mPhoneState;
    }

    public ServiceState getServiceState() {
        if ((this.mWants & 2) == 0) {
            throw new RuntimeException("client must call notifyServiceState(int)");
        }
        return this.mServiceState;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getSignalStrength() {
        if ((this.mWants & 4) == 0) {
            throw new RuntimeException("client must call notifySignalStrength(int)");
        }
        int n = this.mSignalStrength.getGsmSignalStrength();
        if (n != 99) return n;
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getSignalStrengthDbm() {
        if ((this.mWants & 4) == 0) {
            throw new RuntimeException("client must call notifySignalStrength(int)");
        }
        int n = -1;
        if (!this.mSignalStrength.isGsm()) {
            return this.mSignalStrength.getCdmaDbm();
        }
        int n2 = this.mSignalStrength.getGsmSignalStrength();
        int n3 = n2 == 99 ? -1 : n2;
        if (n3 == -1) return n;
        return n3 * 2 + -113;
    }

    public void notifyPhoneCallState(int n) {
        int n2;
        this.mWants = n2 = this.mWants | 1;
        this.mPhoneStateEventWhat = n;
        this.mFilter.addAction("android.intent.action.PHONE_STATE");
    }

    public void notifyServiceState(int n) {
        int n2;
        this.mWants = n2 = this.mWants | 2;
        this.mServiceStateEventWhat = n;
        this.mFilter.addAction("android.intent.action.SERVICE_STATE");
    }

    public void notifySignalStrength(int n) {
        int n2;
        this.mWants = n2 = this.mWants | 4;
        this.mAsuEventWhat = n;
        this.mFilter.addAction("android.intent.action.SIG_STR");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onReceive(Context context, Intent intent) {
        String string2 = intent.getAction();
        try {
            if ("android.intent.action.SIG_STR".equals(string2)) {
                SignalStrength signalStrength;
                this.mSignalStrength = signalStrength = SignalStrength.newFromBundle(intent.getExtras());
                if (this.mTarget == null) {
                    return;
                }
                if (!this.getNotifySignalStrength()) {
                    return;
                }
                Handler handler = this.mTarget;
                int n = this.mAsuEventWhat;
                Message message = Message.obtain(handler, n);
                boolean bl = this.mTarget.sendMessage(message);
                return;
            }
            if ("android.intent.action.PHONE_STATE".equals(string2)) {
                Phone.State state;
                String string3 = intent.getStringExtra("state");
                this.mPhoneState = state = Enum.valueOf(Phone.State.class, string3);
                if (this.mTarget == null) {
                    return;
                }
                if (!this.getNotifyPhoneCallState()) {
                    return;
                }
                Handler handler = this.mTarget;
                int n = this.mPhoneStateEventWhat;
                Message message = Message.obtain(handler, n);
                boolean bl = this.mTarget.sendMessage(message);
                return;
            }
        }
        catch (Exception exception) {
            String string4 = "[PhoneStateIntentRecv] caught " + exception;
            int n = Log.e(LOG_TAG, string4);
            exception.printStackTrace();
            return;
        }
        {
            ServiceState serviceState;
            if (!"android.intent.action.SERVICE_STATE".equals(string2)) {
                return;
            }
            this.mServiceState = serviceState = ServiceState.newFromBundle(intent.getExtras());
            if (this.mTarget == null) {
                return;
            }
            if (!this.getNotifyServiceState()) {
                return;
            }
            Handler handler = this.mTarget;
            int n = this.mServiceStateEventWhat;
            Message message = Message.obtain(handler, n);
            boolean bl = this.mTarget.sendMessage(message);
            return;
        }
    }

    public void registerIntent() {
        Context context = this.mContext;
        IntentFilter intentFilter = this.mFilter;
        Intent intent = context.registerReceiver(this, intentFilter);
    }

    public void setContext(Context context) {
        this.mContext = context;
    }

    public void setTarget(Handler handler) {
        this.mTarget = handler;
    }

    public void unregisterIntent() {
        this.mContext.unregisterReceiver(this);
    }
}

