/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.os.Binder;
import android.telephony.PhoneNumberUtils;
import android.util.Log;
import com.android.internal.telephony.IPhoneSubInfo;
import com.android.internal.telephony.Phone;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class PhoneSubInfo
extends IPhoneSubInfo.Stub {
    private static final String CALL_PRIVILEGED = "android.permission.CALL_PRIVILEGED";
    static final String LOG_TAG = "PHONE";
    private static final String READ_PHONE_STATE = "android.permission.READ_PHONE_STATE";
    private Context mContext;
    private Phone mPhone;

    public PhoneSubInfo(Phone phone) {
        Context context;
        this.mPhone = phone;
        this.mContext = context = phone.getContext();
    }

    public void dispose() {
    }

    @Override
    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            StringBuilder stringBuilder = new StringBuilder().append("Permission Denial: can't dump PhoneSubInfo from from pid=");
            int n = Binder.getCallingPid();
            StringBuilder stringBuilder2 = stringBuilder.append(n).append(", uid=");
            int n2 = Binder.getCallingUid();
            String string2 = stringBuilder2.append(n2).toString();
            printWriter.println(string2);
            return;
        }
        printWriter.println("Phone Subscriber Info:");
        StringBuilder stringBuilder = new StringBuilder().append("  Phone Type = ");
        String string3 = this.mPhone.getPhoneName();
        String string4 = stringBuilder.append(string3).toString();
        printWriter.println(string4);
        StringBuilder stringBuilder3 = new StringBuilder().append("  Device ID = ");
        String string5 = this.mPhone.getDeviceId();
        String string6 = stringBuilder3.append(string5).toString();
        printWriter.println(string6);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            int n = Log.e(LOG_TAG, "Error while finalizing:", throwable);
        }
        int n = Log.d(LOG_TAG, "PhoneSubInfo finalized");
    }

    @Override
    public String getCompleteVoiceMailNumber() {
        this.mContext.enforceCallingOrSelfPermission(CALL_PRIVILEGED, "Requires CALL_PRIVILEGED");
        String string2 = this.mPhone.getVoiceMailNumber();
        int n = Log.d(LOG_TAG, "VM: PhoneSubInfo.getCompleteVoiceMailNUmber: ");
        return string2;
    }

    @Override
    public String getDeviceId() {
        this.mContext.enforceCallingOrSelfPermission(READ_PHONE_STATE, "Requires READ_PHONE_STATE");
        return this.mPhone.getDeviceId();
    }

    @Override
    public String getDeviceSvn() {
        this.mContext.enforceCallingOrSelfPermission(READ_PHONE_STATE, "Requires READ_PHONE_STATE");
        return this.mPhone.getDeviceSvn();
    }

    @Override
    public String getIccSerialNumber() {
        this.mContext.enforceCallingOrSelfPermission(READ_PHONE_STATE, "Requires READ_PHONE_STATE");
        return this.mPhone.getIccSerialNumber();
    }

    @Override
    public String getLine1AlphaTag() {
        this.mContext.enforceCallingOrSelfPermission(READ_PHONE_STATE, "Requires READ_PHONE_STATE");
        return this.mPhone.getLine1AlphaTag();
    }

    @Override
    public String getLine1Number() {
        this.mContext.enforceCallingOrSelfPermission(READ_PHONE_STATE, "Requires READ_PHONE_STATE");
        return this.mPhone.getLine1Number();
    }

    @Override
    public String getSubscriberId() {
        this.mContext.enforceCallingOrSelfPermission(READ_PHONE_STATE, "Requires READ_PHONE_STATE");
        return this.mPhone.getSubscriberId();
    }

    @Override
    public String getVoiceMailAlphaTag() {
        this.mContext.enforceCallingOrSelfPermission(READ_PHONE_STATE, "Requires READ_PHONE_STATE");
        return this.mPhone.getVoiceMailAlphaTag();
    }

    @Override
    public String getVoiceMailNumber() {
        this.mContext.enforceCallingOrSelfPermission(READ_PHONE_STATE, "Requires READ_PHONE_STATE");
        String string2 = PhoneNumberUtils.extractNetworkPortion(this.mPhone.getVoiceMailNumber());
        int n = Log.d(LOG_TAG, "VM: PhoneSubInfo.getVoiceMailNUmber: ");
        return string2;
    }
}

