/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.LocalSocket;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.telephony.NeighboringCellInfo;
import android.telephony.PhoneNumberUtils;
import android.telephony.SmsMessage;
import android.util.Log;
import com.android.internal.telephony.BaseCommands;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DataCallState;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.IccCardApplication;
import com.android.internal.telephony.IccCardStatus;
import com.android.internal.telephony.IccIoResult;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.RILRequest;
import com.android.internal.telephony.SmsResponse;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.cdma.CdmaCallWaitingNotification;
import com.android.internal.telephony.cdma.CdmaInformationRecords;
import com.android.internal.telephony.gsm.NetworkInfo;
import com.android.internal.telephony.gsm.SmsBroadcastConfigInfo;
import com.android.internal.telephony.gsm.SuppServiceNotification;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public final class RIL
extends BaseCommands
implements CommandsInterface {
    private static final int CDMA_BROADCAST_SMS_NO_OF_SERVICE_CATEGORIES = 31;
    private static final int CDMA_BSI_NO_OF_INTS_STRUCT = 3;
    private static final boolean DBG = false;
    private static final int DEFAULT_WAKE_LOCK_TIMEOUT = 30000;
    static final int EVENT_SEND = 1;
    static final int EVENT_WAKE_LOCK_TIMEOUT = 2;
    static final String LOG_TAG = "RILJ";
    static final int RESPONSE_SOLICITED = 0;
    static final int RESPONSE_UNSOLICITED = 1;
    static final boolean RILJ_LOGD = true;
    static final boolean RILJ_LOGV = false;
    static final int RIL_MAX_COMMAND_BYTES = 8192;
    static final String SOCKET_NAME_RIL = "rild";
    static final int SOCKET_OPEN_RETRY_MILLIS = 4000;
    private Context mContext;
    private boolean mInitialRadioStateChange = true;
    BroadcastReceiver mIntentReceiver;
    Object mLastNITZTimeInfo;
    RILReceiver mReceiver;
    Thread mReceiverThread;
    int mRequestMessagesPending;
    int mRequestMessagesWaiting;
    ArrayList<RILRequest> mRequestsList;
    RILSender mSender;
    HandlerThread mSenderThread;
    LocalSocket mSocket;
    PowerManager.WakeLock mWakeLock;
    int mWakeLockTimeout;

    public RIL(Context context) {
        this(context, 0, 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public RIL(Context context, int n, int n2) {
        super(context);
        Thread thread;
        RILReceiver rILReceiver;
        RILSender rILSender;
        HandlerThread handlerThread;
        int n3;
        PowerManager.WakeLock wakeLock;
        BroadcastReceiver broadcastReceiver;
        ArrayList arrayList = new ArrayList();
        this.mRequestsList = arrayList;
        this.mIntentReceiver = broadcastReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.intent.action.SCREEN_ON")) {
                    RIL.this.sendScreenState(true);
                    return;
                }
                if (intent.getAction().equals("android.intent.action.SCREEN_OFF")) {
                    RIL.this.sendScreenState(false);
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder().append("RIL received unexpected Intent: ");
                String string2 = intent.getAction();
                String string3 = stringBuilder.append(string2).toString();
                int n = Log.w(RIL.LOG_TAG, string3);
            }
        };
        this.mCdmaSubscription = n2;
        this.mNetworkMode = n;
        switch (n) {
            default: {
                this.mPhoneType = 2;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.mPhoneType = 1;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.mPhoneType = 2;
                break;
            }
            case 7: {
                this.mPhoneType = 2;
            }
        }
        this.mWakeLock = wakeLock = ((PowerManager)context.getSystemService("power")).newWakeLock(1, LOG_TAG);
        this.mWakeLock.setReferenceCounted(false);
        this.mWakeLockTimeout = n3 = SystemProperties.getInt("ro.ril.wake_lock_timeout", 30000);
        this.mRequestMessagesPending = 0;
        this.mRequestMessagesWaiting = 0;
        this.mContext = context;
        this.mSenderThread = handlerThread = new HandlerThread("RILSender");
        this.mSenderThread.start();
        Looper looper = this.mSenderThread.getLooper();
        this.mSender = rILSender = new RILSender(looper);
        RILReceiver rILReceiver2 = this.mReceiver = (rILReceiver = new RILReceiver());
        this.mReceiverThread = thread = new Thread(rILReceiver2, "RILReceiver");
        this.mReceiverThread.start();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        BroadcastReceiver broadcastReceiver2 = this.mIntentReceiver;
        Intent intent = context.registerReceiver(broadcastReceiver2, intentFilter);
    }

    static /* synthetic */ RILRequest access$100(RIL rIL, int n) {
        return rIL.findAndRemoveRequestFromList(n);
    }

    static /* synthetic */ int access$200(InputStream inputStream, byte[] byArray) throws IOException {
        return RIL.readRilMessage(inputStream, byArray);
    }

    static /* synthetic */ void access$300(RIL rIL, Parcel parcel) {
        rIL.processResponse(parcel);
    }

    static /* synthetic */ void access$400(RIL rIL, int n, boolean bl) {
        rIL.clearRequestsList(n, bl);
    }

    private void acquireWakeLock() {
        PowerManager.WakeLock wakeLock = this.mWakeLock;
        synchronized (wakeLock) {
            int n;
            this.mWakeLock.acquire();
            this.mRequestMessagesPending = n = this.mRequestMessagesPending + 1;
            this.mSender.removeMessages(2);
            Message message = this.mSender.obtainMessage(2);
            RILSender rILSender = this.mSender;
            long l = this.mWakeLockTimeout;
            boolean bl = rILSender.sendMessageDelayed(message, l);
            return;
        }
    }

    private void clearRequestsList(int n, boolean bl) {
        ArrayList<RILRequest> arrayList = this.mRequestsList;
        synchronized (arrayList) {
            int n2 = this.mRequestsList.size();
            if (bl) {
                StringBuilder stringBuilder = new StringBuilder().append("WAKE_LOCK_TIMEOUT  mReqPending=");
                int n3 = this.mRequestMessagesPending;
                String string2 = stringBuilder.append(n3).append(" mRequestList=").append(n2).toString();
                int n4 = Log.d(LOG_TAG, string2);
            }
            for (int i = 0; i < n2; ++i) {
                RILRequest rILRequest = this.mRequestsList.get(i);
                if (bl) {
                    StringBuilder stringBuilder = new StringBuilder().append(i).append(": [");
                    int n5 = rILRequest.mSerial;
                    StringBuilder stringBuilder2 = stringBuilder.append(n5).append("] ");
                    String string3 = RIL.requestToString(rILRequest.mRequest);
                    String string4 = stringBuilder2.append(string3).toString();
                    int n6 = Log.d(LOG_TAG, string4);
                }
                rILRequest.onError(n, null);
                rILRequest.release();
            }
            this.mRequestsList.clear();
            this.mRequestMessagesWaiting = 0;
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RILRequest findAndRemoveRequestFromList(int n) {
        ArrayList<RILRequest> arrayList = this.mRequestsList;
        synchronized (arrayList) {
            int n2 = 0;
            int n3 = this.mRequestsList.size();
            while (n2 < n3) {
                RILRequest rILRequest = this.mRequestsList.get(n2);
                if (rILRequest.mSerial != n) {
                    int n4;
                    RILRequest rILRequest2 = this.mRequestsList.remove(n2);
                    if (this.mRequestMessagesWaiting <= 0) return rILRequest;
                    this.mRequestMessagesWaiting = n4 = this.mRequestMessagesWaiting - 1;
                    return rILRequest;
                }
                ++n2;
            }
            return null;
        }
    }

    private void notifyRegistrantsCdmaInfoRec(CdmaInformationRecords cdmaInformationRecords) {
        if (cdmaInformationRecords.record instanceof CdmaInformationRecords.CdmaDisplayInfoRec) {
            if (this.mDisplayInfoRegistrants == null) {
                return;
            }
            Object object = cdmaInformationRecords.record;
            this.unsljLogRet(1027, object);
            RegistrantList registrantList = this.mDisplayInfoRegistrants;
            Object object2 = cdmaInformationRecords.record;
            AsyncResult asyncResult = new AsyncResult(null, object2, null);
            registrantList.notifyRegistrants(asyncResult);
            return;
        }
        if (cdmaInformationRecords.record instanceof CdmaInformationRecords.CdmaSignalInfoRec) {
            if (this.mSignalInfoRegistrants == null) {
                return;
            }
            Object object = cdmaInformationRecords.record;
            this.unsljLogRet(1027, object);
            RegistrantList registrantList = this.mSignalInfoRegistrants;
            Object object3 = cdmaInformationRecords.record;
            AsyncResult asyncResult = new AsyncResult(null, object3, null);
            registrantList.notifyRegistrants(asyncResult);
            return;
        }
        if (cdmaInformationRecords.record instanceof CdmaInformationRecords.CdmaNumberInfoRec) {
            if (this.mNumberInfoRegistrants == null) {
                return;
            }
            Object object = cdmaInformationRecords.record;
            this.unsljLogRet(1027, object);
            RegistrantList registrantList = this.mNumberInfoRegistrants;
            Object object4 = cdmaInformationRecords.record;
            AsyncResult asyncResult = new AsyncResult(null, object4, null);
            registrantList.notifyRegistrants(asyncResult);
            return;
        }
        if (cdmaInformationRecords.record instanceof CdmaInformationRecords.CdmaRedirectingNumberInfoRec) {
            if (this.mRedirNumInfoRegistrants == null) {
                return;
            }
            Object object = cdmaInformationRecords.record;
            this.unsljLogRet(1027, object);
            RegistrantList registrantList = this.mRedirNumInfoRegistrants;
            Object object5 = cdmaInformationRecords.record;
            AsyncResult asyncResult = new AsyncResult(null, object5, null);
            registrantList.notifyRegistrants(asyncResult);
            return;
        }
        if (cdmaInformationRecords.record instanceof CdmaInformationRecords.CdmaLineControlInfoRec) {
            if (this.mLineControlInfoRegistrants == null) {
                return;
            }
            Object object = cdmaInformationRecords.record;
            this.unsljLogRet(1027, object);
            RegistrantList registrantList = this.mLineControlInfoRegistrants;
            Object object6 = cdmaInformationRecords.record;
            AsyncResult asyncResult = new AsyncResult(null, object6, null);
            registrantList.notifyRegistrants(asyncResult);
            return;
        }
        if (cdmaInformationRecords.record instanceof CdmaInformationRecords.CdmaT53ClirInfoRec) {
            if (this.mT53ClirInfoRegistrants == null) {
                return;
            }
            Object object = cdmaInformationRecords.record;
            this.unsljLogRet(1027, object);
            RegistrantList registrantList = this.mT53ClirInfoRegistrants;
            Object object7 = cdmaInformationRecords.record;
            AsyncResult asyncResult = new AsyncResult(null, object7, null);
            registrantList.notifyRegistrants(asyncResult);
            return;
        }
        if (!(cdmaInformationRecords.record instanceof CdmaInformationRecords.CdmaT53AudioControlInfoRec)) {
            return;
        }
        if (this.mT53AudCntrlInfoRegistrants == null) {
            return;
        }
        Object object = cdmaInformationRecords.record;
        this.unsljLogRet(1027, object);
        RegistrantList registrantList = this.mT53AudCntrlInfoRegistrants;
        Object object8 = cdmaInformationRecords.record;
        AsyncResult asyncResult = new AsyncResult(null, object8, null);
        registrantList.notifyRegistrants(asyncResult);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processResponse(Parcel parcel) {
        int n = parcel.readInt();
        if (n == 1) {
            this.processUnsolicited(parcel);
        } else if (n == 0) {
            this.processSolicited(parcel);
        }
        this.releaseWakeLockIfDone();
    }

    /*
     * Exception decompiling
     */
    private void processSolicited(Parcel var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 659->666)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processUnsolicited(Parcel parcel) {
        Iterator iterator;
        Object object;
        int n = parcel.readInt();
        switch (n) {
            default: {
                StringBuilder stringBuilder = new StringBuilder().append("Unrecognized unsol response: ");
                int n2 = n;
                String string2 = stringBuilder.append(n2).toString();
                throw new RuntimeException(string2);
            }
            case 1000: {
                Object object2;
                object = object2 = this.responseVoid(parcel);
                break;
            }
            case 1001: {
                try {
                    object = this.responseVoid(parcel);
                    break;
                }
                catch (Throwable throwable) {
                    StringBuilder stringBuilder = new StringBuilder().append("Exception processing unsol response: ");
                    int n3 = n;
                    StringBuilder stringBuilder2 = stringBuilder.append(n3).append("Exception:");
                    String string3 = throwable.toString();
                    String string4 = stringBuilder2.append(string3).toString();
                    int n4 = Log.e(LOG_TAG, string4);
                    return;
                }
            }
            case 1002: {
                object = this.responseVoid(parcel);
                break;
            }
            case 1003: {
                object = this.responseString(parcel);
                break;
            }
            case 1004: {
                object = this.responseString(parcel);
                break;
            }
            case 1005: {
                object = this.responseInts(parcel);
                break;
            }
            case 1006: {
                object = this.responseStrings(parcel);
                break;
            }
            case 1008: {
                object = this.responseString(parcel);
                break;
            }
            case 1009: {
                object = this.responseSignalStrength(parcel);
                break;
            }
            case 1010: {
                object = this.responseDataCallList(parcel);
                break;
            }
            case 1011: {
                object = this.responseSuppServiceNotification(parcel);
                break;
            }
            case 1012: {
                object = this.responseVoid(parcel);
                break;
            }
            case 1013: {
                object = this.responseString(parcel);
                break;
            }
            case 1014: {
                object = this.responseString(parcel);
                break;
            }
            case 1015: {
                object = this.responseInts(parcel);
                break;
            }
            case 1016: {
                object = this.responseVoid(parcel);
                break;
            }
            case 1017: {
                object = this.responseInts(parcel);
                break;
            }
            case 1018: {
                object = this.responseCallRing(parcel);
                break;
            }
            case 1023: {
                object = this.responseInts(parcel);
                break;
            }
            case 1019: {
                object = this.responseVoid(parcel);
                break;
            }
            case 1020: {
                object = this.responseCdmaSms(parcel);
                break;
            }
            case 1021: {
                object = this.responseString(parcel);
                break;
            }
            case 1022: {
                object = this.responseVoid(parcel);
                break;
            }
            case 1024: {
                object = this.responseVoid(parcel);
                break;
            }
            case 1025: {
                object = this.responseCdmaCallWaiting(parcel);
                break;
            }
            case 1026: {
                object = this.responseInts(parcel);
                break;
            }
            case 1027: {
                object = this.responseCdmaInformationRecord(parcel);
                break;
            }
            case 1028: {
                object = this.responseRaw(parcel);
                break;
            }
            case 1029: {
                object = this.responseInts(parcel);
                break;
            }
            case 1030: {
                Object object2;
                object = object2 = this.responseVoid(parcel);
            }
        }
        switch (n) {
            default: {
                return;
            }
            case 1000: {
                int n5 = parcel.readInt();
                RIL rIL = this;
                int n6 = n5;
                rIL.setRadioStateFromRILInt(n6);
                String string5 = this.mState.toString();
                RIL rIL2 = this;
                int n7 = n;
                String string6 = string5;
                rIL2.unsljLogMore(n7, string6);
                return;
            }
            case 1001: {
                RIL rIL = this;
                int n8 = n;
                rIL.unsljLog(n8);
                RegistrantList registrantList = this.mCallStateRegistrants;
                AsyncResult asyncResult = new AsyncResult(null, null, null);
                registrantList.notifyRegistrants(asyncResult);
                return;
            }
            case 1002: {
                RIL rIL = this;
                int n9 = n;
                rIL.unsljLog(n9);
                RegistrantList registrantList = this.mNetworkStateRegistrants;
                AsyncResult asyncResult = new AsyncResult(null, null, null);
                registrantList.notifyRegistrants(asyncResult);
                return;
            }
            case 1003: {
                AsyncResult asyncResult;
                String string7;
                RIL rIL = this;
                int n10 = n;
                rIL.unsljLog(n10);
                String[] stringArray = new String[2];
                stringArray[1] = string7 = (String)object;
                SmsMessage smsMessage = SmsMessage.newFromCMT(stringArray);
                if (this.mSMSRegistrant == null) {
                    return;
                }
                Registrant registrant = this.mSMSRegistrant;
                AsyncResult asyncResult2 = asyncResult;
                Object var38_39 = null;
                SmsMessage smsMessage2 = smsMessage;
                Throwable throwable = null;
                asyncResult2(var38_39, smsMessage2, throwable);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1004: {
                AsyncResult asyncResult;
                RIL rIL = this;
                int n11 = n;
                Object object3 = object;
                rIL.unsljLogRet(n11, object3);
                if (this.mSmsStatusRegistrant == null) {
                    return;
                }
                Registrant registrant = this.mSmsStatusRegistrant;
                AsyncResult asyncResult3 = asyncResult;
                Object var47_48 = null;
                Object object4 = object;
                Throwable throwable = null;
                asyncResult3(var47_48, object4, throwable);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1005: {
                AsyncResult asyncResult;
                RIL rIL = this;
                int n12 = n;
                Object object5 = object;
                rIL.unsljLogRet(n12, object5);
                int[] nArray = (int[])object;
                int n13 = nArray.length;
                int n14 = 1;
                if (n13 != n14) {
                    StringBuilder stringBuilder = new StringBuilder().append(" NEW_SMS_ON_SIM ERROR with wrong length ");
                    int n15 = nArray.length;
                    String string8 = stringBuilder.append(n15).toString();
                    RIL rIL3 = this;
                    String string9 = string8;
                    rIL3.riljLog(string9);
                    return;
                }
                if (this.mSmsOnSimRegistrant == null) {
                    return;
                }
                Registrant registrant = this.mSmsOnSimRegistrant;
                AsyncResult asyncResult4 = asyncResult;
                Object var59_60 = null;
                int[] nArray2 = nArray;
                Throwable throwable = null;
                asyncResult4(var59_60, nArray2, throwable);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1006: {
                AsyncResult asyncResult;
                String[] stringArray = (String[])object;
                int n16 = stringArray.length;
                int n17 = 2;
                if (n16 < n17) {
                    String string10 = ((String[])object)[0];
                    stringArray = new String[]{string10, null};
                }
                String string11 = stringArray[0];
                RIL rIL = this;
                int n18 = n;
                String string12 = string11;
                rIL.unsljLogMore(n18, string12);
                if (this.mUSSDRegistrant == null) {
                    return;
                }
                Registrant registrant = this.mUSSDRegistrant;
                AsyncResult asyncResult5 = asyncResult;
                Object var78_79 = null;
                String[] stringArray2 = stringArray;
                Throwable throwable = null;
                asyncResult5(var78_79, stringArray2, throwable);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1008: {
                Object[] objectArray;
                RIL rIL = this;
                int n19 = n;
                Object object6 = object;
                rIL.unsljLogRet(n19, object6);
                long l = parcel.readLong();
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = object;
                Long l2 = l;
                objectArray2[1] = l2;
                if (this.mNITZTimeRegistrant != null) {
                    AsyncResult asyncResult;
                    Registrant registrant = this.mNITZTimeRegistrant;
                    AsyncResult asyncResult6 = asyncResult;
                    Object var91_91 = null;
                    Object[] objectArray3 = objectArray2;
                    Throwable throwable = null;
                    asyncResult6(var91_91, objectArray3, throwable);
                    registrant.notifyRegistrant(asyncResult);
                    return;
                }
                this.mLastNITZTimeInfo = objectArray = objectArray2;
                return;
            }
            case 1009: {
                AsyncResult asyncResult;
                if (this.mSignalStrengthRegistrant == null) {
                    return;
                }
                Registrant registrant = this.mSignalStrengthRegistrant;
                AsyncResult asyncResult7 = asyncResult;
                Object var98_98 = null;
                Object object7 = object;
                Throwable throwable = null;
                asyncResult7(var98_98, object7, throwable);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1010: {
                AsyncResult asyncResult;
                RIL rIL = this;
                int n20 = n;
                Object object8 = object;
                rIL.unsljLogRet(n20, object8);
                RegistrantList registrantList = this.mDataConnectionRegistrants;
                AsyncResult asyncResult8 = asyncResult;
                Object var107_107 = null;
                Object object9 = object;
                Throwable throwable = null;
                asyncResult8(var107_107, object9, throwable);
                registrantList.notifyRegistrants(asyncResult);
                return;
            }
            case 1011: {
                AsyncResult asyncResult;
                RIL rIL = this;
                int n21 = n;
                Object object10 = object;
                rIL.unsljLogRet(n21, object10);
                if (this.mSsnRegistrant == null) {
                    return;
                }
                Registrant registrant = this.mSsnRegistrant;
                AsyncResult asyncResult9 = asyncResult;
                Object var116_116 = null;
                Object object11 = object;
                Throwable throwable = null;
                asyncResult9(var116_116, object11, throwable);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1012: {
                AsyncResult asyncResult;
                RIL rIL = this;
                int n22 = n;
                rIL.unsljLog(n22);
                if (this.mStkSessionEndRegistrant == null) {
                    return;
                }
                Registrant registrant = this.mStkSessionEndRegistrant;
                AsyncResult asyncResult10 = asyncResult;
                Object var124_124 = null;
                Object object12 = object;
                Throwable throwable = null;
                asyncResult10(var124_124, object12, throwable);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1013: {
                AsyncResult asyncResult;
                RIL rIL = this;
                int n23 = n;
                Object object13 = object;
                rIL.unsljLogRet(n23, object13);
                if (this.mStkProCmdRegistrant == null) {
                    return;
                }
                Registrant registrant = this.mStkProCmdRegistrant;
                AsyncResult asyncResult11 = asyncResult;
                Object var133_133 = null;
                Object object14 = object;
                Throwable throwable = null;
                asyncResult11(var133_133, object14, throwable);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1014: {
                AsyncResult asyncResult;
                RIL rIL = this;
                int n24 = n;
                Object object15 = object;
                rIL.unsljLogRet(n24, object15);
                if (this.mStkEventRegistrant == null) {
                    return;
                }
                Registrant registrant = this.mStkEventRegistrant;
                AsyncResult asyncResult12 = asyncResult;
                Object var142_142 = null;
                Object object16 = object;
                Throwable throwable = null;
                asyncResult12(var142_142, object16, throwable);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1015: {
                AsyncResult asyncResult;
                RIL rIL = this;
                int n25 = n;
                Object object17 = object;
                rIL.unsljLogRet(n25, object17);
                if (this.mStkCallSetUpRegistrant == null) {
                    return;
                }
                Registrant registrant = this.mStkCallSetUpRegistrant;
                AsyncResult asyncResult13 = asyncResult;
                Object var151_151 = null;
                Object object18 = object;
                Throwable throwable = null;
                asyncResult13(var151_151, object18, throwable);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1016: {
                RIL rIL = this;
                int n26 = n;
                rIL.unsljLog(n26);
                if (this.mIccSmsFullRegistrant == null) {
                    return;
                }
                this.mIccSmsFullRegistrant.notifyRegistrant();
                return;
            }
            case 1017: {
                AsyncResult asyncResult;
                RIL rIL = this;
                int n27 = n;
                Object object19 = object;
                rIL.unsljLogRet(n27, object19);
                if (this.mIccRefreshRegistrant == null) {
                    return;
                }
                Registrant registrant = this.mIccRefreshRegistrant;
                AsyncResult asyncResult14 = asyncResult;
                Object var162_162 = null;
                Object object20 = object;
                Throwable throwable = null;
                asyncResult14(var162_162, object20, throwable);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1018: {
                AsyncResult asyncResult;
                RIL rIL = this;
                int n28 = n;
                Object object21 = object;
                rIL.unsljLogRet(n28, object21);
                if (this.mRingRegistrant == null) {
                    return;
                }
                Registrant registrant = this.mRingRegistrant;
                AsyncResult asyncResult15 = asyncResult;
                Object var171_171 = null;
                Object object22 = object;
                Throwable throwable = null;
                asyncResult15(var171_171, object22, throwable);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1023: {
                AsyncResult asyncResult;
                RIL rIL = this;
                int n29 = n;
                Object object23 = object;
                rIL.unsljLogvRet(n29, object23);
                if (this.mRestrictedStateRegistrant == null) {
                    return;
                }
                Registrant registrant = this.mRestrictedStateRegistrant;
                AsyncResult asyncResult16 = asyncResult;
                Object var180_180 = null;
                Object object24 = object;
                Throwable throwable = null;
                asyncResult16(var180_180, object24, throwable);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1019: {
                RIL rIL = this;
                int n30 = n;
                rIL.unsljLog(n30);
                if (this.mIccStatusChangedRegistrants == null) {
                    return;
                }
                this.mIccStatusChangedRegistrants.notifyRegistrants();
                return;
            }
            case 1020: {
                AsyncResult asyncResult;
                RIL rIL = this;
                int n31 = n;
                rIL.unsljLog(n31);
                SmsMessage smsMessage = (SmsMessage)object;
                if (this.mSMSRegistrant == null) {
                    return;
                }
                Registrant registrant = this.mSMSRegistrant;
                AsyncResult asyncResult17 = asyncResult;
                Object var190_190 = null;
                SmsMessage smsMessage3 = smsMessage;
                Throwable throwable = null;
                asyncResult17(var190_190, smsMessage3, throwable);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1021: {
                AsyncResult asyncResult;
                RIL rIL = this;
                int n32 = n;
                rIL.unsljLog(n32);
                if (this.mGsmBroadcastSmsRegistrant == null) {
                    return;
                }
                Registrant registrant = this.mGsmBroadcastSmsRegistrant;
                AsyncResult asyncResult18 = asyncResult;
                Object var198_198 = null;
                Object object25 = object;
                Throwable throwable = null;
                asyncResult18(var198_198, object25, throwable);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1022: {
                RIL rIL = this;
                int n33 = n;
                rIL.unsljLog(n33);
                if (this.mIccSmsFullRegistrant == null) {
                    return;
                }
                this.mIccSmsFullRegistrant.notifyRegistrant();
                return;
            }
            case 1024: {
                RIL rIL = this;
                int n34 = n;
                rIL.unsljLog(n34);
                if (this.mEmergencyCallbackModeRegistrant == null) {
                    return;
                }
                this.mEmergencyCallbackModeRegistrant.notifyRegistrant();
                return;
            }
            case 1025: {
                AsyncResult asyncResult;
                RIL rIL = this;
                int n35 = n;
                Object object26 = object;
                rIL.unsljLogRet(n35, object26);
                if (this.mCallWaitingInfoRegistrants == null) {
                    return;
                }
                RegistrantList registrantList = this.mCallWaitingInfoRegistrants;
                AsyncResult asyncResult19 = asyncResult;
                Object var211_211 = null;
                Object object27 = object;
                Throwable throwable = null;
                asyncResult19(var211_211, object27, throwable);
                registrantList.notifyRegistrants(asyncResult);
                return;
            }
            case 1026: {
                AsyncResult asyncResult;
                RIL rIL = this;
                int n36 = n;
                Object object28 = object;
                rIL.unsljLogRet(n36, object28);
                if (this.mOtaProvisionRegistrants == null) {
                    return;
                }
                RegistrantList registrantList = this.mOtaProvisionRegistrants;
                AsyncResult asyncResult20 = asyncResult;
                Object var220_220 = null;
                Object object29 = object;
                Throwable throwable = null;
                asyncResult20(var220_220, object29, throwable);
                registrantList.notifyRegistrants(asyncResult);
                return;
            }
            case 1027: {
                ArrayList arrayList;
                try {
                    arrayList = (ArrayList)object;
                }
                catch (ClassCastException classCastException) {
                    String string13 = LOG_TAG;
                    String string14 = "Unexpected exception casting to listInfoRecs";
                    ClassCastException classCastException2 = classCastException;
                    int n37 = Log.e(string13, string14, classCastException2);
                    return;
                }
                iterator = arrayList.iterator();
                break;
            }
            case 1028: {
                AsyncResult asyncResult;
                String string15 = IccUtils.bytesToHexString((byte[])object);
                RIL rIL = this;
                int n38 = n;
                String string16 = string15;
                rIL.unsljLogvRet(n38, string16);
                if (this.mUnsolOemHookRawRegistrant == null) {
                    return;
                }
                Registrant registrant = this.mUnsolOemHookRawRegistrant;
                AsyncResult asyncResult21 = asyncResult;
                Object var243_243 = null;
                Object object30 = object;
                Throwable throwable = null;
                asyncResult21(var243_243, object30, throwable);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1029: {
                RIL rIL = this;
                int n39 = n;
                Object object31 = object;
                rIL.unsljLogvRet(n39, object31);
                if (this.mRingbackToneRegistrants == null) {
                    return;
                }
                int n40 = ((int[])object)[0];
                n40 = 1;
                boolean bl = n40 == n40;
                RegistrantList registrantList = this.mRingbackToneRegistrants;
                Boolean bl2 = bl;
                AsyncResult asyncResult = new AsyncResult(null, bl2, null);
                registrantList.notifyRegistrants(asyncResult);
                return;
            }
            case 1030: {
                AsyncResult asyncResult;
                RIL rIL = this;
                int n41 = n;
                Object object32 = object;
                rIL.unsljLogRet(n41, object32);
                if (this.mResendIncallMuteRegistrants == null) {
                    return;
                }
                RegistrantList registrantList = this.mResendIncallMuteRegistrants;
                AsyncResult asyncResult22 = asyncResult;
                Object var261_260 = null;
                Object object33 = object;
                Throwable throwable = null;
                asyncResult22(var261_260, object33, throwable);
                registrantList.notifyRegistrants(asyncResult);
                return;
            }
        }
        while (iterator.hasNext()) {
            CdmaInformationRecords cdmaInformationRecords = (CdmaInformationRecords)iterator.next();
            RIL rIL = this;
            int n42 = n;
            CdmaInformationRecords cdmaInformationRecords2 = cdmaInformationRecords;
            rIL.unsljLogRet(n42, cdmaInformationRecords2);
            RIL rIL4 = this;
            CdmaInformationRecords cdmaInformationRecords3 = cdmaInformationRecords;
            rIL4.notifyRegistrantsCdmaInfoRec(cdmaInformationRecords3);
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int readRilMessage(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        int n2 = 0;
        int n3 = 4;
        do {
            if ((n = inputStream.read(byArray, n2, n3)) < 0) {
                int n4 = Log.e(LOG_TAG, "Hit EOS reading message length");
                return -1;
            }
            n2 += n;
        } while ((n3 -= n) > 0);
        int n5 = (byArray[0] & 0xFF) << 24;
        int n6 = (byArray[1] & 0xFF) << 16;
        int n7 = n5 | n6;
        int n8 = (byArray[2] & 0xFF) << 8;
        int n9 = n7 | n8;
        int n10 = byArray[3] & 0xFF;
        int n11 = n9 | n10;
        n2 = 0;
        n3 = n11;
        do {
            if ((n = inputStream.read(byArray, n2, n3)) < 0) {
                String string2 = "Hit EOS reading message.  messageLength=" + n11 + " remaining=" + n3;
                int n12 = Log.e(LOG_TAG, string2);
                return -1;
            }
            n2 += n;
        } while ((n3 -= n) > 0);
        return n11;
    }

    private void releaseWakeLockIfDone() {
        PowerManager.WakeLock wakeLock = this.mWakeLock;
        synchronized (wakeLock) {
            if (this.mWakeLock.isHeld() && this.mRequestMessagesPending == 0 && this.mRequestMessagesWaiting == 0) {
                this.mSender.removeMessages(2);
                this.mWakeLock.release();
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String requestToString(int n) {
        switch (n) {
            default: {
                return "<unknown request>";
            }
            case 1: {
                return "GET_SIM_STATUS";
            }
            case 2: {
                return "ENTER_SIM_PIN";
            }
            case 3: {
                return "ENTER_SIM_PUK";
            }
            case 4: {
                return "ENTER_SIM_PIN2";
            }
            case 5: {
                return "ENTER_SIM_PUK2";
            }
            case 6: {
                return "CHANGE_SIM_PIN";
            }
            case 7: {
                return "CHANGE_SIM_PIN2";
            }
            case 8: {
                return "ENTER_NETWORK_DEPERSONALIZATION";
            }
            case 9: {
                return "GET_CURRENT_CALLS";
            }
            case 10: {
                return "DIAL";
            }
            case 11: {
                return "GET_IMSI";
            }
            case 12: {
                return "HANGUP";
            }
            case 13: {
                return "HANGUP_WAITING_OR_BACKGROUND";
            }
            case 14: {
                return "HANGUP_FOREGROUND_RESUME_BACKGROUND";
            }
            case 15: {
                return "REQUEST_SWITCH_WAITING_OR_HOLDING_AND_ACTIVE";
            }
            case 16: {
                return "CONFERENCE";
            }
            case 17: {
                return "UDUB";
            }
            case 18: {
                return "LAST_CALL_FAIL_CAUSE";
            }
            case 19: {
                return "SIGNAL_STRENGTH";
            }
            case 20: {
                return "REGISTRATION_STATE";
            }
            case 21: {
                return "GPRS_REGISTRATION_STATE";
            }
            case 22: {
                return "OPERATOR";
            }
            case 23: {
                return "RADIO_POWER";
            }
            case 24: {
                return "DTMF";
            }
            case 25: {
                return "SEND_SMS";
            }
            case 26: {
                return "SEND_SMS_EXPECT_MORE";
            }
            case 27: {
                return "SETUP_DATA_CALL";
            }
            case 28: {
                return "SIM_IO";
            }
            case 29: {
                return "SEND_USSD";
            }
            case 30: {
                return "CANCEL_USSD";
            }
            case 31: {
                return "GET_CLIR";
            }
            case 32: {
                return "SET_CLIR";
            }
            case 33: {
                return "QUERY_CALL_FORWARD_STATUS";
            }
            case 34: {
                return "SET_CALL_FORWARD";
            }
            case 35: {
                return "QUERY_CALL_WAITING";
            }
            case 36: {
                return "SET_CALL_WAITING";
            }
            case 37: {
                return "SMS_ACKNOWLEDGE";
            }
            case 38: {
                return "GET_IMEI";
            }
            case 39: {
                return "GET_IMEISV";
            }
            case 40: {
                return "ANSWER";
            }
            case 41: {
                return "DEACTIVATE_DATA_CALL";
            }
            case 42: {
                return "QUERY_FACILITY_LOCK";
            }
            case 43: {
                return "SET_FACILITY_LOCK";
            }
            case 44: {
                return "CHANGE_BARRING_PASSWORD";
            }
            case 45: {
                return "QUERY_NETWORK_SELECTION_MODE";
            }
            case 46: {
                return "SET_NETWORK_SELECTION_AUTOMATIC";
            }
            case 47: {
                return "SET_NETWORK_SELECTION_MANUAL";
            }
            case 48: {
                return "QUERY_AVAILABLE_NETWORKS ";
            }
            case 49: {
                return "DTMF_START";
            }
            case 50: {
                return "DTMF_STOP";
            }
            case 51: {
                return "BASEBAND_VERSION";
            }
            case 52: {
                return "SEPARATE_CONNECTION";
            }
            case 53: {
                return "SET_MUTE";
            }
            case 54: {
                return "GET_MUTE";
            }
            case 55: {
                return "QUERY_CLIP";
            }
            case 56: {
                return "LAST_DATA_CALL_FAIL_CAUSE";
            }
            case 57: {
                return "DATA_CALL_LIST";
            }
            case 58: {
                return "RESET_RADIO";
            }
            case 59: {
                return "OEM_HOOK_RAW";
            }
            case 60: {
                return "OEM_HOOK_STRINGS";
            }
            case 61: {
                return "SCREEN_STATE";
            }
            case 62: {
                return "SET_SUPP_SVC_NOTIFICATION";
            }
            case 63: {
                return "WRITE_SMS_TO_SIM";
            }
            case 64: {
                return "DELETE_SMS_ON_SIM";
            }
            case 65: {
                return "SET_BAND_MODE";
            }
            case 66: {
                return "QUERY_AVAILABLE_BAND_MODE";
            }
            case 67: {
                return "REQUEST_STK_GET_PROFILE";
            }
            case 68: {
                return "REQUEST_STK_SET_PROFILE";
            }
            case 69: {
                return "REQUEST_STK_SEND_ENVELOPE_COMMAND";
            }
            case 70: {
                return "REQUEST_STK_SEND_TERMINAL_RESPONSE";
            }
            case 71: {
                return "REQUEST_STK_HANDLE_CALL_SETUP_REQUESTED_FROM_SIM";
            }
            case 72: {
                return "REQUEST_EXPLICIT_CALL_TRANSFER";
            }
            case 73: {
                return "REQUEST_SET_PREFERRED_NETWORK_TYPE";
            }
            case 74: {
                return "REQUEST_GET_PREFERRED_NETWORK_TYPE";
            }
            case 75: {
                return "REQUEST_GET_NEIGHBORING_CELL_IDS";
            }
            case 76: {
                return "REQUEST_SET_LOCATION_UPDATES";
            }
            case 77: {
                return "RIL_REQUEST_CDMA_SET_SUBSCRIPTION";
            }
            case 78: {
                return "RIL_REQUEST_CDMA_SET_ROAMING_PREFERENCE";
            }
            case 79: {
                return "RIL_REQUEST_CDMA_QUERY_ROAMING_PREFERENCE";
            }
            case 80: {
                return "RIL_REQUEST_SET_TTY_MODE";
            }
            case 81: {
                return "RIL_REQUEST_QUERY_TTY_MODE";
            }
            case 82: {
                return "RIL_REQUEST_CDMA_SET_PREFERRED_VOICE_PRIVACY_MODE";
            }
            case 83: {
                return "RIL_REQUEST_CDMA_QUERY_PREFERRED_VOICE_PRIVACY_MODE";
            }
            case 84: {
                return "RIL_REQUEST_CDMA_FLASH";
            }
            case 85: {
                return "RIL_REQUEST_CDMA_BURST_DTMF";
            }
            case 87: {
                return "RIL_REQUEST_CDMA_SEND_SMS";
            }
            case 88: {
                return "RIL_REQUEST_CDMA_SMS_ACKNOWLEDGE";
            }
            case 89: {
                return "RIL_REQUEST_GSM_GET_BROADCAST_CONFIG";
            }
            case 90: {
                return "RIL_REQUEST_GSM_SET_BROADCAST_CONFIG";
            }
            case 92: {
                return "RIL_REQUEST_CDMA_GET_BROADCAST_CONFIG";
            }
            case 93: {
                return "RIL_REQUEST_CDMA_SET_BROADCAST_CONFIG";
            }
            case 91: {
                return "RIL_REQUEST_GSM_BROADCAST_ACTIVATION";
            }
            case 86: {
                return "RIL_REQUEST_CDMA_VALIDATE_AND_WRITE_AKEY";
            }
            case 94: {
                return "RIL_REQUEST_CDMA_BROADCAST_ACTIVATION";
            }
            case 95: {
                return "RIL_REQUEST_CDMA_SUBSCRIPTION";
            }
            case 96: {
                return "RIL_REQUEST_CDMA_WRITE_SMS_TO_RUIM";
            }
            case 97: {
                return "RIL_REQUEST_CDMA_DELETE_SMS_ON_RUIM";
            }
            case 98: {
                return "RIL_REQUEST_DEVICE_IDENTITY";
            }
            case 100: {
                return "RIL_REQUEST_GET_SMSC_ADDRESS";
            }
            case 101: {
                return "RIL_REQUEST_SET_SMSC_ADDRESS";
            }
            case 99: {
                return "REQUEST_EXIT_EMERGENCY_CALLBACK_MODE";
            }
            case 102: {
                return "RIL_REQUEST_REPORT_SMS_MEMORY_STATUS";
            }
            case 103: 
        }
        return "RIL_REQUEST_REPORT_STK_SERVICE_IS_RUNNING";
    }

    private Object responseCallForward(Parcel parcel) {
        int n = parcel.readInt();
        CallForwardInfo[] callForwardInfoArray = new CallForwardInfo[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            String string2;
            int n3;
            int n4;
            int n5;
            int n6;
            CallForwardInfo callForwardInfo;
            callForwardInfoArray[i] = callForwardInfo = new CallForwardInfo();
            CallForwardInfo callForwardInfo2 = callForwardInfoArray[i];
            callForwardInfo2.status = n6 = parcel.readInt();
            CallForwardInfo callForwardInfo3 = callForwardInfoArray[i];
            callForwardInfo3.reason = n5 = parcel.readInt();
            CallForwardInfo callForwardInfo4 = callForwardInfoArray[i];
            callForwardInfo4.serviceClass = n4 = parcel.readInt();
            CallForwardInfo callForwardInfo5 = callForwardInfoArray[i];
            callForwardInfo5.toa = n3 = parcel.readInt();
            CallForwardInfo callForwardInfo6 = callForwardInfoArray[i];
            callForwardInfo6.number = string2 = parcel.readString();
            CallForwardInfo callForwardInfo7 = callForwardInfoArray[i];
            callForwardInfo7.timeSeconds = n2 = parcel.readInt();
        }
        return callForwardInfoArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object responseCallList(Parcel parcel) {
        int n = parcel.readInt();
        ArrayList<DriverCall> arrayList = new ArrayList<DriverCall>(n);
        int n2 = 0;
        while (true) {
            String string2;
            int n3;
            String string3;
            int n4;
            String string4;
            int n5;
            int n6;
            int n7;
            DriverCall.State state;
            if (n2 >= n) {
                Collections.sort(arrayList);
                return arrayList;
            }
            DriverCall driverCall = new DriverCall();
            driverCall.state = state = DriverCall.stateFromCLCC(parcel.readInt());
            driverCall.index = n7 = parcel.readInt();
            driverCall.TOA = n6 = parcel.readInt();
            boolean bl = parcel.readInt() != 0;
            driverCall.isMpty = bl;
            boolean bl2 = parcel.readInt() != 0;
            driverCall.isMT = bl2;
            driverCall.als = n5 = parcel.readInt();
            boolean bl3 = parcel.readInt() != 0;
            driverCall.isVoice = bl3;
            boolean bl4 = parcel.readInt() != 0;
            driverCall.isVoicePrivacy = bl4;
            driverCall.number = string4 = parcel.readString();
            driverCall.numberPresentation = n4 = DriverCall.presentationFromCLIP(parcel.readInt());
            driverCall.name = string3 = parcel.readString();
            driverCall.namePresentation = n3 = parcel.readInt();
            if (parcel.readInt() == 1) {
                UUSInfo uUSInfo;
                UUSInfo uUSInfo2 = driverCall.uusInfo = (uUSInfo = new UUSInfo());
                int n8 = parcel.readInt();
                uUSInfo2.setType(n8);
                UUSInfo uUSInfo3 = driverCall.uusInfo;
                int n9 = parcel.readInt();
                uUSInfo3.setDcs(n9);
                byte[] byArray = parcel.createByteArray();
                driverCall.uusInfo.setUserData(byArray);
                Object[] objectArray = new Object[3];
                Integer n10 = driverCall.uusInfo.getType();
                objectArray[0] = n10;
                Integer n11 = driverCall.uusInfo.getDcs();
                objectArray[1] = n11;
                Integer n12 = driverCall.uusInfo.getUserData().length;
                objectArray[2] = n12;
                String string5 = String.format("Incoming UUS : type=%d, dcs=%d, length=%d", objectArray);
                int n13 = Log.v(LOG_TAG, string5);
                StringBuilder stringBuilder = new StringBuilder().append("Incoming UUS : data (string)=");
                byte[] byArray2 = driverCall.uusInfo.getUserData();
                String string6 = new String(byArray2);
                String string7 = stringBuilder.append(string6).toString();
                int n14 = Log.v(LOG_TAG, string7);
                StringBuilder stringBuilder2 = new StringBuilder().append("Incoming UUS : data (hex): ");
                String string8 = IccUtils.bytesToHexString(driverCall.uusInfo.getUserData());
                String string9 = stringBuilder2.append(string8).toString();
                int n15 = Log.v(LOG_TAG, string9);
            } else {
                int n16 = Log.v(LOG_TAG, "Incoming UUS : NOT present!");
            }
            String string10 = driverCall.number;
            int n17 = driverCall.TOA;
            driverCall.number = string2 = PhoneNumberUtils.stringFromStringAndTOA(string10, n17);
            boolean bl5 = arrayList.add(driverCall);
            if (driverCall.isVoicePrivacy) {
                this.mVoicePrivacyOnRegistrants.notifyRegistrants();
                int n18 = Log.d(LOG_TAG, "InCall VoicePrivacy is enabled");
            } else {
                this.mVoicePrivacyOffRegistrants.notifyRegistrants();
                int n19 = Log.d(LOG_TAG, "InCall VoicePrivacy is disabled");
            }
            ++n2;
        }
    }

    private Object responseCallRing(Parcel parcel) {
        char c;
        char c2;
        char c3;
        char c4 = (char)parcel.readInt();
        char[] cArray = new char[]{c4, c3 = (char)parcel.readInt(), c2 = (char)parcel.readInt(), c = (char)parcel.readInt()};
        return cArray;
    }

    private Object responseCdmaBroadcastConfig(Parcel parcel) {
        int[] nArray;
        int n = parcel.readInt();
        if (n == 0) {
            int n2 = 94;
            nArray = new int[n2];
            nArray[0] = 31;
            for (int i = 1; i < n2; i += 3) {
                int n3;
                int n4 = i + 0;
                nArray[n4] = n3 = i / 3;
                int n5 = i + 1;
                nArray[n5] = 1;
                int n6 = i + 2;
                nArray[n6] = 0;
            }
        } else {
            int n7 = n * 3 + 1;
            nArray = new int[n7];
            nArray[0] = n;
            for (int i = 1; i < n7; ++i) {
                int n8;
                nArray[i] = n8 = parcel.readInt();
            }
        }
        return nArray;
    }

    private Object responseCdmaCallWaiting(Parcel parcel) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        String string2;
        int n6;
        String string3;
        CdmaCallWaitingNotification cdmaCallWaitingNotification = new CdmaCallWaitingNotification();
        cdmaCallWaitingNotification.number = string3 = parcel.readString();
        cdmaCallWaitingNotification.numberPresentation = n6 = CdmaCallWaitingNotification.presentationFromCLIP(parcel.readInt());
        cdmaCallWaitingNotification.name = string2 = parcel.readString();
        cdmaCallWaitingNotification.namePresentation = n5 = cdmaCallWaitingNotification.numberPresentation;
        cdmaCallWaitingNotification.isPresent = n4 = parcel.readInt();
        cdmaCallWaitingNotification.signalType = n3 = parcel.readInt();
        cdmaCallWaitingNotification.alertPitch = n2 = parcel.readInt();
        cdmaCallWaitingNotification.signal = n = parcel.readInt();
        return cdmaCallWaitingNotification;
    }

    private ArrayList<CdmaInformationRecords> responseCdmaInformationRecord(Parcel parcel) {
        int n = parcel.readInt();
        ArrayList<CdmaInformationRecords> arrayList = new ArrayList<CdmaInformationRecords>(n);
        for (int i = 0; i < n; ++i) {
            CdmaInformationRecords cdmaInformationRecords = new CdmaInformationRecords(parcel);
            boolean bl = arrayList.add(cdmaInformationRecords);
        }
        return arrayList;
    }

    private Object responseCdmaSms(Parcel parcel) {
        return SmsMessage.newFromParcel(parcel);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object responseCellList(Parcel parcel) {
        int n = parcel.readInt();
        ArrayList<NeighboringCellInfo> arrayList = new ArrayList<NeighboringCellInfo>();
        String string2 = SystemProperties.get("gsm.network.type", "unknown");
        int n2 = string2.equals("GPRS") ? 1 : (string2.equals("EDGE") ? 2 : (string2.equals("UMTS") ? 3 : (string2.equals("HSDPA") ? 8 : (string2.equals("HSUPA") ? 9 : (string2.equals("HSPA") ? 10 : 0)))));
        if (n2 != 0) {
            for (int i = 0; i < n; ++i) {
                int n3 = parcel.readInt();
                String string3 = parcel.readString();
                NeighboringCellInfo neighboringCellInfo = new NeighboringCellInfo(n3, string3, n2);
                boolean bl = arrayList.add(neighboringCellInfo);
            }
        }
        return arrayList;
    }

    private Object responseDataCallList(Parcel parcel) {
        int n = parcel.readInt();
        ArrayList<DataCallState> arrayList = new ArrayList<DataCallState>(n);
        for (int i = 0; i < n; ++i) {
            String string2;
            String string3;
            String string4;
            int n2;
            int n3;
            DataCallState dataCallState = new DataCallState();
            dataCallState.cid = n3 = parcel.readInt();
            dataCallState.active = n2 = parcel.readInt();
            dataCallState.type = string4 = parcel.readString();
            dataCallState.apn = string3 = parcel.readString();
            dataCallState.address = string2 = parcel.readString();
            boolean bl = arrayList.add(dataCallState);
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object responseGmsBroadcastConfig(Parcel parcel) {
        int n = parcel.readInt();
        ArrayList<SmsBroadcastConfigInfo> arrayList = new ArrayList<SmsBroadcastConfigInfo>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = parcel.readInt();
            int n4 = parcel.readInt();
            int n5 = parcel.readInt();
            int n6 = parcel.readInt();
            boolean bl = parcel.readInt() == 1;
            SmsBroadcastConfigInfo smsBroadcastConfigInfo = new SmsBroadcastConfigInfo(n3, n4, n5, n6, bl);
            boolean bl2 = arrayList.add(smsBroadcastConfigInfo);
            ++n2;
        }
        return arrayList;
    }

    private Object responseICC_IO(Parcel parcel) {
        int n = parcel.readInt();
        int n2 = parcel.readInt();
        String string2 = parcel.readString();
        StringBuilder stringBuilder = new StringBuilder().append("< iccIO:  0x");
        String string3 = Integer.toHexString(n);
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append(" 0x");
        String string4 = Integer.toHexString(n2);
        String string5 = stringBuilder2.append(string4).append(" ").append(string2).toString();
        this.riljLog(string5);
        return new IccIoResult(n, n2, string2);
    }

    private Object responseIccCardStatus(Parcel parcel) {
        IccCardStatus iccCardStatus = new IccCardStatus();
        int n = parcel.readInt();
        iccCardStatus.setCardState(n);
        int n2 = parcel.readInt();
        iccCardStatus.setUniversalPinState(n2);
        int n3 = parcel.readInt();
        iccCardStatus.setGsmUmtsSubscriptionAppIndex(n3);
        int n4 = parcel.readInt();
        iccCardStatus.setCdmaSubscriptionAppIndex(n4);
        int n5 = parcel.readInt();
        if (n5 > 8) {
            n5 = 8;
        }
        iccCardStatus.setNumApplications(n5);
        for (int i = 0; i < n5; ++i) {
            int n6;
            int n7;
            int n8;
            String string2;
            String string3;
            IccCardApplication.PersoSubState persoSubState;
            IccCardApplication.AppState appState;
            IccCardApplication.AppType appType;
            IccCardApplication iccCardApplication = new IccCardApplication();
            int n9 = parcel.readInt();
            iccCardApplication.app_type = appType = iccCardApplication.AppTypeFromRILInt(n9);
            int n10 = parcel.readInt();
            iccCardApplication.app_state = appState = iccCardApplication.AppStateFromRILInt(n10);
            int n11 = parcel.readInt();
            iccCardApplication.perso_substate = persoSubState = iccCardApplication.PersoSubstateFromRILInt(n11);
            iccCardApplication.aid = string3 = parcel.readString();
            iccCardApplication.app_label = string2 = parcel.readString();
            iccCardApplication.pin1_replaced = n8 = parcel.readInt();
            iccCardApplication.pin1 = n7 = parcel.readInt();
            iccCardApplication.pin2 = n6 = parcel.readInt();
            iccCardStatus.addApplication(iccCardApplication);
        }
        return iccCardStatus;
    }

    private Object responseInts(Parcel parcel) {
        int n = parcel.readInt();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            nArray[i] = n2 = parcel.readInt();
        }
        return nArray;
    }

    private Object responseNetworkInfos(Parcel parcel) {
        int n;
        String[] stringArray = (String[])this.responseStrings(parcel);
        if (stringArray.length % 4 != 0) {
            StringBuilder stringBuilder = new StringBuilder().append("RIL_REQUEST_QUERY_AVAILABLE_NETWORKS: invalid response. Got ");
            int n2 = stringArray.length;
            String string2 = stringBuilder.append(n2).append(" strings, expected multible of 4").toString();
            throw new RuntimeException(string2);
        }
        int n3 = stringArray.length / 4;
        ArrayList<NetworkInfo> arrayList = new ArrayList<NetworkInfo>(n3);
        for (int i = 0; i < (n = stringArray.length); i += 4) {
            int n4 = i + 0;
            String string3 = stringArray[n4];
            int n5 = i + 1;
            String string4 = stringArray[n5];
            int n6 = i + 2;
            String string5 = stringArray[n6];
            int n7 = i + 3;
            String string6 = stringArray[n7];
            NetworkInfo networkInfo = new NetworkInfo(string3, string4, string5, string6);
            boolean bl = arrayList.add(networkInfo);
        }
        return arrayList;
    }

    private Object responseRaw(Parcel parcel) {
        return parcel.createByteArray();
    }

    private Object responseSMS(Parcel parcel) {
        int n = parcel.readInt();
        String string2 = parcel.readString();
        int n2 = parcel.readInt();
        return new SmsResponse(n, string2, n2);
    }

    private Object responseSignalStrength(Parcel parcel) {
        int[] nArray = new int[7];
        for (int i = 0; i < 7; ++i) {
            int n;
            nArray[i] = n = parcel.readInt();
        }
        return nArray;
    }

    private Object responseString(Parcel parcel) {
        return parcel.readString();
    }

    private Object responseStrings(Parcel parcel) {
        return parcel.readStringArray();
    }

    private Object responseSuppServiceNotification(Parcel parcel) {
        String string2;
        int n;
        int n2;
        int n3;
        int n4;
        SuppServiceNotification suppServiceNotification = new SuppServiceNotification();
        suppServiceNotification.notificationType = n4 = parcel.readInt();
        suppServiceNotification.code = n3 = parcel.readInt();
        suppServiceNotification.index = n2 = parcel.readInt();
        suppServiceNotification.type = n = parcel.readInt();
        suppServiceNotification.number = string2 = parcel.readString();
        return suppServiceNotification;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String responseToString(int n) {
        switch (n) {
            default: {
                return "<unknown reponse>";
            }
            case 1000: {
                return "UNSOL_RESPONSE_RADIO_STATE_CHANGED";
            }
            case 1001: {
                return "UNSOL_RESPONSE_CALL_STATE_CHANGED";
            }
            case 1002: {
                return "UNSOL_RESPONSE_NETWORK_STATE_CHANGED";
            }
            case 1003: {
                return "UNSOL_RESPONSE_NEW_SMS";
            }
            case 1004: {
                return "UNSOL_RESPONSE_NEW_SMS_STATUS_REPORT";
            }
            case 1005: {
                return "UNSOL_RESPONSE_NEW_SMS_ON_SIM";
            }
            case 1006: {
                return "UNSOL_ON_USSD";
            }
            case 1007: {
                return "UNSOL_ON_USSD_REQUEST";
            }
            case 1008: {
                return "UNSOL_NITZ_TIME_RECEIVED";
            }
            case 1009: {
                return "UNSOL_SIGNAL_STRENGTH";
            }
            case 1010: {
                return "UNSOL_DATA_CALL_LIST_CHANGED";
            }
            case 1011: {
                return "UNSOL_SUPP_SVC_NOTIFICATION";
            }
            case 1012: {
                return "UNSOL_STK_SESSION_END";
            }
            case 1013: {
                return "UNSOL_STK_PROACTIVE_COMMAND";
            }
            case 1014: {
                return "UNSOL_STK_EVENT_NOTIFY";
            }
            case 1015: {
                return "UNSOL_STK_CALL_SETUP";
            }
            case 1016: {
                return "UNSOL_SIM_SMS_STORAGE_FULL";
            }
            case 1017: {
                return "UNSOL_SIM_REFRESH";
            }
            case 1018: {
                return "UNSOL_CALL_RING";
            }
            case 1019: {
                return "UNSOL_RESPONSE_SIM_STATUS_CHANGED";
            }
            case 1020: {
                return "UNSOL_RESPONSE_CDMA_NEW_SMS";
            }
            case 1021: {
                return "UNSOL_RESPONSE_NEW_BROADCAST_SMS";
            }
            case 1022: {
                return "UNSOL_CDMA_RUIM_SMS_STORAGE_FULL";
            }
            case 1023: {
                return "UNSOL_RESTRICTED_STATE_CHANGED";
            }
            case 1024: {
                return "UNSOL_ENTER_EMERGENCY_CALLBACK_MODE";
            }
            case 1025: {
                return "UNSOL_CDMA_CALL_WAITING";
            }
            case 1026: {
                return "UNSOL_CDMA_OTA_PROVISION_STATUS";
            }
            case 1027: {
                return "UNSOL_CDMA_INFO_REC";
            }
            case 1028: {
                return "UNSOL_OEM_HOOK_RAW";
            }
            case 1029: {
                return "UNSOL_RINGBACK_TONG";
            }
            case 1030: 
        }
        return "UNSOL_RESEND_INCALL_MUTE";
    }

    private Object responseVoid(Parcel parcel) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String retToString(int n, Object object) {
        block12: {
            StringBuilder stringBuilder;
            if (object == null) {
                return "";
            }
            switch (n) {
                default: {
                    if (object instanceof int[]) {
                        int[] nArray = (int[])object;
                        int n2 = nArray.length;
                        stringBuilder = new StringBuilder("{");
                        if (n2 <= 0) break;
                        int n3 = 0 + 1;
                        int n4 = nArray[0];
                        StringBuilder stringBuilder2 = stringBuilder.append(n4);
                        while (n3 < n2) {
                            StringBuilder stringBuilder3 = stringBuilder.append(", ");
                            int n5 = n3 + 1;
                            int n6 = nArray[n3];
                            StringBuilder stringBuilder4 = stringBuilder3.append(n6);
                            n3 = n5;
                        }
                        break;
                    }
                    break block12;
                }
                case 11: 
                case 38: 
                case 39: {
                    return "";
                }
            }
            StringBuilder stringBuilder5 = stringBuilder.append("}");
            String string2 = stringBuilder.toString();
            return string2;
        }
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            int n7 = stringArray.length;
            StringBuilder stringBuilder = new StringBuilder("{");
            if (n7 > 0) {
                int n8 = 0 + 1;
                String string3 = stringArray[0];
                StringBuilder stringBuilder6 = stringBuilder.append(string3);
                while (n8 < n7) {
                    StringBuilder stringBuilder7 = stringBuilder.append(", ");
                    int n9 = n8 + 1;
                    String string4 = stringArray[n8];
                    StringBuilder stringBuilder8 = stringBuilder7.append(string4);
                    int n10 = n9;
                }
            }
            StringBuilder stringBuilder9 = stringBuilder.append("}");
            return stringBuilder.toString();
        }
        int n11 = n;
        int n12 = 9;
        if (n11 == n12) {
            ArrayList arrayList = (ArrayList)object;
            StringBuilder stringBuilder = new StringBuilder(" ");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                DriverCall driverCall = (DriverCall)iterator.next();
                StringBuilder stringBuilder10 = stringBuilder.append("[").append(driverCall).append("] ");
            }
            return stringBuilder.toString();
        }
        int n13 = n;
        int n14 = 75;
        if (n13 != n14) return object.toString();
        ArrayList arrayList = (ArrayList)object;
        StringBuilder stringBuilder = new StringBuilder(" ");
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            NeighboringCellInfo neighboringCellInfo = (NeighboringCellInfo)iterator.next();
            StringBuilder stringBuilder11 = stringBuilder.append(neighboringCellInfo).append(" ");
        }
        return stringBuilder.toString();
    }

    private void riljLog(String string2) {
        int n = Log.d(LOG_TAG, string2);
    }

    private void riljLogv(String string2) {
        int n = Log.v(LOG_TAG, string2);
    }

    private void send(RILRequest rILRequest) {
        Message message = this.mSender.obtainMessage(1, rILRequest);
        this.acquireWakeLock();
        message.sendToTarget();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void sendScreenState(boolean bl) {
        RILRequest rILRequest = RILRequest.obtain(61, null);
        rILRequest.mp.writeInt(1);
        Parcel parcel = rILRequest.mp;
        int n = bl ? 1 : 0;
        parcel.writeInt(n);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).append(": ").append(bl).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setRadioStateFromRILInt(int n) {
        CommandsInterface.RadioState radioState;
        switch (n) {
            default: {
                String string2 = "Unrecognized RIL_RadioState: " + n;
                throw new RuntimeException(string2);
            }
            case 0: {
                radioState = CommandsInterface.RadioState.RADIO_OFF;
                break;
            }
            case 1: {
                radioState = CommandsInterface.RadioState.RADIO_UNAVAILABLE;
                break;
            }
            case 2: {
                radioState = CommandsInterface.RadioState.SIM_NOT_READY;
                break;
            }
            case 3: {
                radioState = CommandsInterface.RadioState.SIM_LOCKED_OR_ABSENT;
                break;
            }
            case 4: {
                radioState = CommandsInterface.RadioState.SIM_READY;
                break;
            }
            case 5: {
                radioState = CommandsInterface.RadioState.RUIM_NOT_READY;
                break;
            }
            case 6: {
                radioState = CommandsInterface.RadioState.RUIM_READY;
                break;
            }
            case 7: {
                radioState = CommandsInterface.RadioState.RUIM_LOCKED_OR_ABSENT;
                break;
            }
            case 8: {
                radioState = CommandsInterface.RadioState.NV_NOT_READY;
                break;
            }
            case 9: {
                radioState = CommandsInterface.RadioState.NV_READY;
            }
        }
        if (this.mInitialRadioStateChange) {
            if (radioState.isOn()) {
                int n2 = Log.d(LOG_TAG, "Radio ON @ init; reset to OFF");
                this.setRadioPower(false, null);
            } else {
                this.setRadioState(radioState);
            }
            this.mInitialRadioStateChange = false;
            return;
        }
        this.setRadioState(radioState);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int translateStatus(int n) {
        switch (n & 7) {
            default: {
                return 1;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 0;
            }
            case 5: {
                return 3;
            }
            case 7: 
        }
        return 2;
    }

    private void unsljLog(int n) {
        StringBuilder stringBuilder = new StringBuilder().append("[UNSL]< ");
        String string2 = RIL.responseToString(n);
        String string3 = stringBuilder.append(string2).toString();
        this.riljLog(string3);
    }

    private void unsljLogMore(int n, String string2) {
        StringBuilder stringBuilder = new StringBuilder().append("[UNSL]< ");
        String string3 = RIL.responseToString(n);
        String string4 = stringBuilder.append(string3).append(" ").append(string2).toString();
        this.riljLog(string4);
    }

    private void unsljLogRet(int n, Object object) {
        StringBuilder stringBuilder = new StringBuilder().append("[UNSL]< ");
        String string2 = RIL.responseToString(n);
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" ");
        String string3 = this.retToString(n, object);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
    }

    private void unsljLogvRet(int n, Object object) {
        StringBuilder stringBuilder = new StringBuilder().append("[UNSL]< ");
        String string2 = RIL.responseToString(n);
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" ");
        String string3 = this.retToString(n, object);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLogv(string4);
    }

    @Override
    public void acceptCall(Message message) {
        RILRequest rILRequest = RILRequest.obtain(40, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void acknowledgeLastIncomingCdmaSms(boolean bl, int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(88, message);
        Parcel parcel = rILRequest.mp;
        int n2 = bl ? 0 : 1;
        parcel.writeInt(n2);
        rILRequest.mp.writeInt(n);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).append(" ").append(bl).append(" ").append(n).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void acknowledgeLastIncomingGsmSms(boolean bl, int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(37, message);
        rILRequest.mp.writeInt(2);
        Parcel parcel = rILRequest.mp;
        int n2 = bl ? 1 : 0;
        parcel.writeInt(n2);
        rILRequest.mp.writeInt(n);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).append(" ").append(bl).append(" ").append(n).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void cancelPendingUssd(Message message) {
        RILRequest rILRequest = RILRequest.obtain(30, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void changeBarringPassword(String string2, String string3, String string4, Message message) {
        RILRequest rILRequest = RILRequest.obtain(44, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string5).append("> ");
        String string6 = RIL.requestToString(rILRequest.mRequest);
        String string7 = stringBuilder2.append(string6).toString();
        this.riljLog(string7);
        rILRequest.mp.writeInt(3);
        rILRequest.mp.writeString(string2);
        rILRequest.mp.writeString(string3);
        rILRequest.mp.writeString(string4);
        this.send(rILRequest);
    }

    @Override
    public void changeIccPin(String string2, String string3, Message message) {
        RILRequest rILRequest = RILRequest.obtain(6, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string4).append("> ");
        String string5 = RIL.requestToString(rILRequest.mRequest);
        String string6 = stringBuilder2.append(string5).toString();
        this.riljLog(string6);
        rILRequest.mp.writeInt(2);
        rILRequest.mp.writeString(string2);
        rILRequest.mp.writeString(string3);
        this.send(rILRequest);
    }

    @Override
    public void changeIccPin2(String string2, String string3, Message message) {
        RILRequest rILRequest = RILRequest.obtain(7, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string4).append("> ");
        String string5 = RIL.requestToString(rILRequest.mRequest);
        String string6 = stringBuilder2.append(string5).toString();
        this.riljLog(string6);
        rILRequest.mp.writeInt(2);
        rILRequest.mp.writeString(string2);
        rILRequest.mp.writeString(string3);
        this.send(rILRequest);
    }

    @Override
    public void conference(Message message) {
        RILRequest rILRequest = RILRequest.obtain(16, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void deactivateDataCall(int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(41, message);
        rILRequest.mp.writeInt(1);
        Parcel parcel = rILRequest.mp;
        String string2 = Integer.toString(n);
        parcel.writeString(string2);
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append("> ");
        String string4 = RIL.requestToString(rILRequest.mRequest);
        String string5 = stringBuilder2.append(string4).append(" ").append(n).toString();
        this.riljLog(string5);
        this.send(rILRequest);
    }

    @Override
    public void deactivateDefaultPDP(int n, Message message) {
        this.deactivateDataCall(n, message);
    }

    @Override
    public void deleteSmsOnRuim(int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(97, message);
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeInt(n);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).append(" ").append(n).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void deleteSmsOnSim(int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(64, message);
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeInt(n);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).append(" ").append(n).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void dial(String string2, int n, Message message) {
        this.dial(string2, n, null, message);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void dial(String string2, int n, UUSInfo uUSInfo, Message message) {
        RILRequest rILRequest = RILRequest.obtain(10, message);
        rILRequest.mp.writeString(string2);
        rILRequest.mp.writeInt(n);
        rILRequest.mp.writeInt(0);
        if (uUSInfo == null) {
            rILRequest.mp.writeInt(0);
        } else {
            rILRequest.mp.writeInt(1);
            Parcel parcel = rILRequest.mp;
            int n2 = uUSInfo.getType();
            parcel.writeInt(n2);
            Parcel parcel2 = rILRequest.mp;
            int n3 = uUSInfo.getDcs();
            parcel2.writeInt(n3);
            Parcel parcel3 = rILRequest.mp;
            byte[] byArray = uUSInfo.getUserData();
            parcel3.writeByteArray(byArray);
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append("> ");
        String string4 = RIL.requestToString(rILRequest.mRequest);
        String string5 = stringBuilder2.append(string4).toString();
        this.riljLog(string5);
        this.send(rILRequest);
    }

    @Override
    public void exitEmergencyCallbackMode(Message message) {
        RILRequest rILRequest = RILRequest.obtain(99, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void explicitCallTransfer(Message message) {
        RILRequest rILRequest = RILRequest.obtain(72, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void getAvailableNetworks(Message message) {
        RILRequest rILRequest = RILRequest.obtain(48, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void getBasebandVersion(Message message) {
        RILRequest rILRequest = RILRequest.obtain(51, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void getCDMASubscription(Message message) {
        RILRequest rILRequest = RILRequest.obtain(95, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void getCLIR(Message message) {
        RILRequest rILRequest = RILRequest.obtain(31, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void getCdmaBroadcastConfig(Message message) {
        RILRequest rILRequest = RILRequest.obtain(92, message);
        this.send(rILRequest);
    }

    @Override
    public void getCurrentCalls(Message message) {
        RILRequest rILRequest = RILRequest.obtain(9, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void getDataCallList(Message message) {
        RILRequest rILRequest = RILRequest.obtain(57, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void getDeviceIdentity(Message message) {
        RILRequest rILRequest = RILRequest.obtain(98, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void getGPRSRegistrationState(Message message) {
        RILRequest rILRequest = RILRequest.obtain(21, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void getGsmBroadcastConfig(Message message) {
        RILRequest rILRequest = RILRequest.obtain(89, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void getIMEI(Message message) {
        RILRequest rILRequest = RILRequest.obtain(38, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void getIMEISV(Message message) {
        RILRequest rILRequest = RILRequest.obtain(39, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void getIMSI(Message message) {
        RILRequest rILRequest = RILRequest.obtain(11, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> getIMSI:RIL_REQUEST_GET_IMSI ").append(11).append(" ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void getIccCardStatus(Message message) {
        RILRequest rILRequest = RILRequest.obtain(1, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void getLastCallFailCause(Message message) {
        RILRequest rILRequest = RILRequest.obtain(18, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void getLastDataCallFailCause(Message message) {
        RILRequest rILRequest = RILRequest.obtain(56, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void getLastPdpFailCause(Message message) {
        this.getLastDataCallFailCause(message);
    }

    @Override
    public void getMute(Message message) {
        RILRequest rILRequest = RILRequest.obtain(54, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void getNeighboringCids(Message message) {
        RILRequest rILRequest = RILRequest.obtain(75, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void getNetworkSelectionMode(Message message) {
        RILRequest rILRequest = RILRequest.obtain(45, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void getOperator(Message message) {
        RILRequest rILRequest = RILRequest.obtain(22, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void getPDPContextList(Message message) {
        this.getDataCallList(message);
    }

    @Override
    public void getPreferredNetworkType(Message message) {
        RILRequest rILRequest = RILRequest.obtain(74, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void getPreferredVoicePrivacy(Message message) {
        RILRequest rILRequest = RILRequest.obtain(83, message);
        this.send(rILRequest);
    }

    @Override
    public void getRegistrationState(Message message) {
        RILRequest rILRequest = RILRequest.obtain(20, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void getSignalStrength(Message message) {
        RILRequest rILRequest = RILRequest.obtain(19, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void getSmscAddress(Message message) {
        RILRequest rILRequest = RILRequest.obtain(100, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handleCallSetupRequestFromSim(boolean bl, Message message) {
        RILRequest rILRequest = RILRequest.obtain(71, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        int[] nArray = new int[1];
        int n = bl ? 1 : 0;
        nArray[0] = n;
        rILRequest.mp.writeIntArray(nArray);
        this.send(rILRequest);
    }

    @Override
    public void hangupConnection(int n, Message message) {
        String string2 = "hangupConnection: gsmIndex=" + n;
        this.riljLog(string2);
        RILRequest rILRequest = RILRequest.obtain(12, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append("> ");
        String string4 = RIL.requestToString(rILRequest.mRequest);
        String string5 = stringBuilder2.append(string4).append(" ").append(n).toString();
        this.riljLog(string5);
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeInt(n);
        this.send(rILRequest);
    }

    @Override
    public void hangupForegroundResumeBackground(Message message) {
        RILRequest rILRequest = RILRequest.obtain(14, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void hangupWaitingOrBackground(Message message) {
        RILRequest rILRequest = RILRequest.obtain(13, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void iccIO(int n, int n2, String string2, int n3, int n4, int n5, String string3, String string4, Message message) {
        RILRequest rILRequest = RILRequest.obtain(28, message);
        rILRequest.mp.writeInt(n);
        rILRequest.mp.writeInt(n2);
        rILRequest.mp.writeString(string2);
        rILRequest.mp.writeInt(n3);
        rILRequest.mp.writeInt(n4);
        rILRequest.mp.writeInt(n5);
        rILRequest.mp.writeString(string3);
        rILRequest.mp.writeString(string4);
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string5).append("> iccIO: ");
        String string6 = RIL.requestToString(rILRequest.mRequest);
        StringBuilder stringBuilder3 = stringBuilder2.append(string6).append(" 0x");
        String string7 = Integer.toHexString(n);
        StringBuilder stringBuilder4 = stringBuilder3.append(string7).append(" 0x");
        String string8 = Integer.toHexString(n2);
        String string9 = stringBuilder4.append(string8).append(" ").append(" path: ").append(string2).append(",").append(n3).append(",").append(n4).append(",").append(n5).toString();
        this.riljLog(string9);
        this.send(rILRequest);
    }

    @Override
    public void invokeOemRilRequestRaw(byte[] byArray, Message message) {
        RILRequest rILRequest = RILRequest.obtain(59, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        StringBuilder stringBuilder3 = stringBuilder2.append(string3).append("[");
        String string4 = IccUtils.bytesToHexString(byArray);
        String string5 = stringBuilder3.append(string4).append("]").toString();
        this.riljLog(string5);
        rILRequest.mp.writeByteArray(byArray);
        this.send(rILRequest);
    }

    @Override
    public void invokeOemRilRequestStrings(String[] stringArray, Message message) {
        RILRequest rILRequest = RILRequest.obtain(60, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        rILRequest.mp.writeStringArray(stringArray);
        this.send(rILRequest);
    }

    @Override
    protected void onRadioAvailable() {
        this.sendScreenState(true);
    }

    @Override
    public void queryAvailableBandMode(Message message) {
        RILRequest rILRequest = RILRequest.obtain(66, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void queryCLIP(Message message) {
        RILRequest rILRequest = RILRequest.obtain(55, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void queryCallForwardStatus(int n, int n2, String string2, Message message) {
        RILRequest rILRequest = RILRequest.obtain(33, message);
        rILRequest.mp.writeInt(2);
        rILRequest.mp.writeInt(n);
        rILRequest.mp.writeInt(n2);
        Parcel parcel = rILRequest.mp;
        int n3 = PhoneNumberUtils.toaFromString(string2);
        parcel.writeInt(n3);
        rILRequest.mp.writeString(string2);
        rILRequest.mp.writeInt(0);
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append("> ");
        String string4 = RIL.requestToString(rILRequest.mRequest);
        String string5 = stringBuilder2.append(string4).append(" ").append(n).append(" ").append(n2).toString();
        this.riljLog(string5);
        this.send(rILRequest);
    }

    @Override
    public void queryCallWaiting(int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(35, message);
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeInt(n);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).append(" ").append(n).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void queryCdmaRoamingPreference(Message message) {
        RILRequest rILRequest = RILRequest.obtain(79, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void queryFacilityLock(String string2, String string3, int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(42, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string4).append("> ");
        String string5 = RIL.requestToString(rILRequest.mRequest);
        String string6 = stringBuilder2.append(string5).toString();
        this.riljLog(string6);
        rILRequest.mp.writeInt(3);
        rILRequest.mp.writeString(string2);
        rILRequest.mp.writeString(string3);
        Parcel parcel = rILRequest.mp;
        String string7 = Integer.toString(n);
        parcel.writeString(string7);
        this.send(rILRequest);
    }

    @Override
    public void queryTTYMode(Message message) {
        RILRequest rILRequest = RILRequest.obtain(81, message);
        this.send(rILRequest);
    }

    @Override
    public void rejectCall(Message message) {
        RILRequest rILRequest = RILRequest.obtain(17, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void reportSmsMemoryStatus(boolean bl, Message message) {
        int n = 1;
        RILRequest rILRequest = RILRequest.obtain(102, message);
        rILRequest.mp.writeInt(n);
        Parcel parcel = rILRequest.mp;
        if (!bl) {
            n = 0;
        }
        parcel.writeInt(n);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).append(": ").append(bl).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void reportStkServiceIsRunning(Message message) {
        RILRequest rILRequest = RILRequest.obtain(103, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void resetRadio(Message message) {
        RILRequest rILRequest = RILRequest.obtain(58, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void sendBurstDtmf(String string2, int n, int n2, Message message) {
        RILRequest rILRequest = RILRequest.obtain(85, message);
        rILRequest.mp.writeInt(3);
        rILRequest.mp.writeString(string2);
        Parcel parcel = rILRequest.mp;
        String string3 = Integer.toString(n);
        parcel.writeString(string3);
        Parcel parcel2 = rILRequest.mp;
        String string4 = Integer.toString(n2);
        parcel2.writeString(string4);
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string5).append("> ");
        String string6 = RIL.requestToString(rILRequest.mRequest);
        String string7 = stringBuilder2.append(string6).append(" : ").append(string2).toString();
        this.riljLog(string7);
        this.send(rILRequest);
    }

    @Override
    public void sendCDMAFeatureCode(String string2, Message message) {
        RILRequest rILRequest = RILRequest.obtain(84, message);
        rILRequest.mp.writeString(string2);
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append("> ");
        String string4 = RIL.requestToString(rILRequest.mRequest);
        String string5 = stringBuilder2.append(string4).append(" : ").append(string2).toString();
        this.riljLog(string5);
        this.send(rILRequest);
    }

    @Override
    public void sendCdmaSms(byte[] byArray, Message message) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        RILRequest rILRequest = RILRequest.obtain(87, message);
        try {
            int n;
            Parcel parcel = rILRequest.mp;
            int n2 = dataInputStream.readInt();
            parcel.writeInt(n2);
            Parcel parcel2 = rILRequest.mp;
            byte by = (byte)dataInputStream.readInt();
            parcel2.writeByte(by);
            Parcel parcel3 = rILRequest.mp;
            int n3 = dataInputStream.readInt();
            parcel3.writeInt(n3);
            Parcel parcel4 = rILRequest.mp;
            int n4 = dataInputStream.read();
            parcel4.writeInt(n4);
            Parcel parcel5 = rILRequest.mp;
            int n5 = dataInputStream.read();
            parcel5.writeInt(n5);
            Parcel parcel6 = rILRequest.mp;
            int n6 = dataInputStream.read();
            parcel6.writeInt(n6);
            Parcel parcel7 = rILRequest.mp;
            int n7 = dataInputStream.read();
            parcel7.writeInt(n7);
            int n8 = dataInputStream.read();
            Parcel parcel8 = rILRequest.mp;
            byte by2 = (byte)n8;
            parcel8.writeByte(by2);
            for (n = 0; n < n8; ++n) {
                Parcel parcel9 = rILRequest.mp;
                byte by3 = dataInputStream.readByte();
                parcel9.writeByte(by3);
            }
            Parcel parcel10 = rILRequest.mp;
            int n9 = dataInputStream.read();
            parcel10.writeInt(n9);
            Parcel parcel11 = rILRequest.mp;
            byte by4 = (byte)dataInputStream.read();
            parcel11.writeByte(by4);
            int n10 = dataInputStream.read();
            Parcel parcel12 = rILRequest.mp;
            byte by5 = (byte)n10;
            parcel12.writeByte(by5);
            for (n = 0; n < n10; ++n) {
                Parcel parcel13 = rILRequest.mp;
                byte by6 = dataInputStream.readByte();
                parcel13.writeByte(by6);
            }
            int n11 = dataInputStream.read();
            rILRequest.mp.writeInt(n11);
            for (n = 0; n < n11; ++n) {
                Parcel parcel14 = rILRequest.mp;
                byte by7 = dataInputStream.readByte();
                parcel14.writeByte(by7);
            }
        }
        catch (IOException iOException) {
            String string2 = "sendSmsCdma: conversion from input stream to object failed: " + iOException;
            this.riljLog(string2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append("> ");
        String string4 = RIL.requestToString(rILRequest.mRequest);
        String string5 = stringBuilder2.append(string4).toString();
        this.riljLog(string5);
        this.send(rILRequest);
    }

    @Override
    public void sendDtmf(char c, Message message) {
        RILRequest rILRequest = RILRequest.obtain(24, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        Parcel parcel = rILRequest.mp;
        String string5 = Character.toString(c);
        parcel.writeString(string5);
        this.send(rILRequest);
    }

    @Override
    public void sendEnvelope(String string2, Message message) {
        RILRequest rILRequest = RILRequest.obtain(69, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append("> ");
        String string4 = RIL.requestToString(rILRequest.mRequest);
        String string5 = stringBuilder2.append(string4).toString();
        this.riljLog(string5);
        rILRequest.mp.writeString(string2);
        this.send(rILRequest);
    }

    @Override
    public void sendSMS(String string2, String string3, Message message) {
        RILRequest rILRequest = RILRequest.obtain(25, message);
        rILRequest.mp.writeInt(2);
        rILRequest.mp.writeString(string2);
        rILRequest.mp.writeString(string3);
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string4).append("> ");
        String string5 = RIL.requestToString(rILRequest.mRequest);
        String string6 = stringBuilder2.append(string5).toString();
        this.riljLog(string6);
        this.send(rILRequest);
    }

    @Override
    public void sendTerminalResponse(String string2, Message message) {
        RILRequest rILRequest = RILRequest.obtain(70, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append("> ");
        String string4 = RIL.requestToString(rILRequest.mRequest);
        String string5 = stringBuilder2.append(string4).toString();
        this.riljLog(string5);
        rILRequest.mp.writeString(string2);
        this.send(rILRequest);
    }

    @Override
    public void sendUSSD(String string2, Message message) {
        RILRequest rILRequest = RILRequest.obtain(29, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append("> ");
        String string4 = RIL.requestToString(rILRequest.mRequest);
        String string5 = stringBuilder2.append(string4).append(" ").append(string2).toString();
        this.riljLog(string5);
        rILRequest.mp.writeString(string2);
        this.send(rILRequest);
    }

    @Override
    public void separateConnection(int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(52, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).append(" ").append(n).toString();
        this.riljLog(string4);
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeInt(n);
        this.send(rILRequest);
    }

    @Override
    public void setBandMode(int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(65, message);
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeInt(n);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).append(" ").append(n).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void setCLIR(int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(32, message);
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeInt(n);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).append(" ").append(n).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void setCallForward(int n, int n2, int n3, String string2, int n4, Message message) {
        RILRequest rILRequest = RILRequest.obtain(34, message);
        rILRequest.mp.writeInt(n);
        rILRequest.mp.writeInt(n2);
        rILRequest.mp.writeInt(n3);
        Parcel parcel = rILRequest.mp;
        int n5 = PhoneNumberUtils.toaFromString(string2);
        parcel.writeInt(n5);
        rILRequest.mp.writeString(string2);
        rILRequest.mp.writeInt(n4);
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append("> ");
        String string4 = RIL.requestToString(rILRequest.mRequest);
        String string5 = stringBuilder2.append(string4).append(" ").append(n).append(" ").append(n2).append(" ").append(n3).append(n4).toString();
        this.riljLog(string5);
        this.send(rILRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setCallWaiting(boolean bl, int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(36, message);
        rILRequest.mp.writeInt(2);
        Parcel parcel = rILRequest.mp;
        int n2 = bl ? 1 : 0;
        parcel.writeInt(n2);
        rILRequest.mp.writeInt(n);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).append(" ").append(bl).append(", ").append(n).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void setCdmaBroadcastActivation(boolean bl, Message message) {
        int n = 1;
        RILRequest rILRequest = RILRequest.obtain(94, message);
        rILRequest.mp.writeInt(n);
        Parcel parcel = rILRequest.mp;
        if (bl) {
            n = 0;
        }
        parcel.writeInt(n);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void setCdmaBroadcastConfig(int[] nArray, Message message) {
        int n;
        RILRequest rILRequest = RILRequest.obtain(93, message);
        for (int i = 0; i < (n = nArray.length); ++i) {
            Parcel parcel = rILRequest.mp;
            int n2 = nArray[i];
            parcel.writeInt(n2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void setCdmaRoamingPreference(int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(78, message);
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeInt(n);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).append(" : ").append(n).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void setCdmaSubscription(int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(77, message);
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeInt(n);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).append(" : ").append(n).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setFacilityLock(String string2, boolean bl, String string3, int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(43, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string4).append("> ");
        String string5 = RIL.requestToString(rILRequest.mRequest);
        String string6 = stringBuilder2.append(string5).toString();
        this.riljLog(string6);
        rILRequest.mp.writeInt(4);
        rILRequest.mp.writeString(string2);
        String string7 = bl ? "1" : "0";
        rILRequest.mp.writeString(string7);
        rILRequest.mp.writeString(string3);
        Parcel parcel = rILRequest.mp;
        String string8 = Integer.toString(n);
        parcel.writeString(string8);
        this.send(rILRequest);
    }

    @Override
    public void setGsmBroadcastActivation(boolean bl, Message message) {
        int n = 1;
        RILRequest rILRequest = RILRequest.obtain(91, message);
        rILRequest.mp.writeInt(n);
        Parcel parcel = rILRequest.mp;
        if (bl) {
            n = 0;
        }
        parcel.writeInt(n);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setGsmBroadcastConfig(SmsBroadcastConfigInfo[] smsBroadcastConfigInfoArray, Message message) {
        RILRequest rILRequest = RILRequest.obtain(90, message);
        int n = smsBroadcastConfigInfoArray.length;
        rILRequest.mp.writeInt(n);
        for (int i = 0; i < n; ++i) {
            Parcel parcel = rILRequest.mp;
            int n2 = smsBroadcastConfigInfoArray[i].getFromServiceId();
            parcel.writeInt(n2);
            Parcel parcel2 = rILRequest.mp;
            int n3 = smsBroadcastConfigInfoArray[i].getToServiceId();
            parcel2.writeInt(n3);
            Parcel parcel3 = rILRequest.mp;
            int n4 = smsBroadcastConfigInfoArray[i].getFromCodeScheme();
            parcel3.writeInt(n4);
            Parcel parcel4 = rILRequest.mp;
            int n5 = smsBroadcastConfigInfoArray[i].getToCodeScheme();
            parcel4.writeInt(n5);
            Parcel parcel5 = rILRequest.mp;
            int n6 = smsBroadcastConfigInfoArray[i].isSelected() ? 1 : 0;
            parcel5.writeInt(n6);
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).append(" with ").append(n).append("configs : ").toString();
        this.riljLog(string4);
        int n7 = 0;
        while (true) {
            if (n7 >= n) {
                this.send(rILRequest);
                return;
            }
            String string5 = smsBroadcastConfigInfoArray[n7].toString();
            this.riljLog(string5);
            ++n7;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setLocationUpdates(boolean bl, Message message) {
        int n = 1;
        RILRequest rILRequest = RILRequest.obtain(76, message);
        rILRequest.mp.writeInt(n);
        Parcel parcel = rILRequest.mp;
        if (!bl) {
            n = 0;
        }
        parcel.writeInt(n);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).append(": ").append(bl).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setMute(boolean bl, Message message) {
        RILRequest rILRequest = RILRequest.obtain(53, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).append(" ").append(bl).toString();
        this.riljLog(string4);
        rILRequest.mp.writeInt(1);
        Parcel parcel = rILRequest.mp;
        int n = bl ? 1 : 0;
        parcel.writeInt(n);
        this.send(rILRequest);
    }

    @Override
    public void setNetworkSelectionModeAutomatic(Message message) {
        RILRequest rILRequest = RILRequest.obtain(46, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void setNetworkSelectionModeManual(String string2, Message message) {
        RILRequest rILRequest = RILRequest.obtain(47, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append("> ");
        String string4 = RIL.requestToString(rILRequest.mRequest);
        String string5 = stringBuilder2.append(string4).append(" ").append(string2).toString();
        this.riljLog(string5);
        rILRequest.mp.writeString(string2);
        this.send(rILRequest);
    }

    @Override
    public void setOnNITZTime(Handler handler, int n, Object object) {
        super.setOnNITZTime(handler, n, object);
        if (this.mLastNITZTimeInfo == null) {
            return;
        }
        Registrant registrant = this.mNITZTimeRegistrant;
        Object object2 = this.mLastNITZTimeInfo;
        AsyncResult asyncResult = new AsyncResult(null, object2, null);
        registrant.notifyRegistrant(asyncResult);
        this.mLastNITZTimeInfo = null;
    }

    @Override
    public void setPhoneType(int n) {
        this.mPhoneType = n;
    }

    @Override
    public void setPreferredNetworkType(int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(73, message);
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeInt(n);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).append(" : ").append(n).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setPreferredVoicePrivacy(boolean bl, Message message) {
        int n = 1;
        RILRequest rILRequest = RILRequest.obtain(82, message);
        rILRequest.mp.writeInt(n);
        Parcel parcel = rILRequest.mp;
        if (!bl) {
            n = 0;
        }
        parcel.writeInt(n);
        this.send(rILRequest);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setRadioPower(boolean bl, Message message) {
        if (this.mInitialRadioStateChange) {
            Object object = this.mStateMonitor;
            synchronized (object) {
                if (!this.mState.isOn()) {
                    RILRequest rILRequest = RILRequest.obtain(73, null);
                    rILRequest.mp.writeInt(1);
                    Parcel parcel = rILRequest.mp;
                    int n = this.mNetworkMode;
                    parcel.writeInt(n);
                    StringBuilder stringBuilder = new StringBuilder();
                    String string2 = rILRequest.serialString();
                    StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
                    String string3 = RIL.requestToString(rILRequest.mRequest);
                    StringBuilder stringBuilder3 = stringBuilder2.append(string3).append(" : ");
                    int n2 = this.mNetworkMode;
                    String string4 = stringBuilder3.append(n2).toString();
                    this.riljLog(string4);
                    this.send(rILRequest);
                    RILRequest rILRequest2 = RILRequest.obtain(77, null);
                    rILRequest2.mp.writeInt(1);
                    Parcel parcel2 = rILRequest2.mp;
                    int n3 = this.mCdmaSubscription;
                    parcel2.writeInt(n3);
                    StringBuilder stringBuilder4 = new StringBuilder();
                    String string5 = rILRequest2.serialString();
                    StringBuilder stringBuilder5 = stringBuilder4.append(string5).append("> ");
                    String string6 = RIL.requestToString(rILRequest2.mRequest);
                    StringBuilder stringBuilder6 = stringBuilder5.append(string6).append(" : ");
                    int n4 = this.mCdmaSubscription;
                    String string7 = stringBuilder6.append(n4).toString();
                    this.riljLog(string7);
                    this.send(rILRequest2);
                }
            }
        }
        RILRequest rILRequest = RILRequest.obtain(23, message);
        rILRequest.mp.writeInt(1);
        Parcel parcel = rILRequest.mp;
        int n = bl ? 1 : 0;
        parcel.writeInt(n);
        StringBuilder stringBuilder = new StringBuilder();
        String string8 = rILRequest.serialString();
        StringBuilder stringBuilder7 = stringBuilder.append(string8).append("> ");
        String string9 = RIL.requestToString(rILRequest.mRequest);
        String string10 = stringBuilder7.append(string9).toString();
        this.riljLog(string10);
        this.send(rILRequest);
    }

    @Override
    public void setSmscAddress(String string2, Message message) {
        RILRequest rILRequest = RILRequest.obtain(101, message);
        rILRequest.mp.writeString(string2);
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append("> ");
        String string4 = RIL.requestToString(rILRequest.mRequest);
        String string5 = stringBuilder2.append(string4).append(" : ").append(string2).toString();
        this.riljLog(string5);
        this.send(rILRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setSuppServiceNotifications(boolean bl, Message message) {
        int n = 1;
        RILRequest rILRequest = RILRequest.obtain(62, message);
        rILRequest.mp.writeInt(n);
        Parcel parcel = rILRequest.mp;
        if (!bl) {
            n = 0;
        }
        parcel.writeInt(n);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void setTTYMode(int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(80, message);
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeInt(n);
        this.send(rILRequest);
    }

    @Override
    public void setupDataCall(String string2, String string3, String string4, String string5, String string6, String string7, Message message) {
        RILRequest rILRequest = RILRequest.obtain(27, message);
        rILRequest.mp.writeInt(6);
        rILRequest.mp.writeString(string2);
        rILRequest.mp.writeString(string3);
        rILRequest.mp.writeString(string4);
        rILRequest.mp.writeString(string5);
        rILRequest.mp.writeString(string6);
        rILRequest.mp.writeString(string7);
        StringBuilder stringBuilder = new StringBuilder();
        String string8 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string8).append("> ");
        String string9 = RIL.requestToString(rILRequest.mRequest);
        String string10 = stringBuilder2.append(string9).append(" ").append(string2).append(" ").append(string3).append(" ").append(string4).append(" ").append(string5).append(" ").append(string6).append(" ").append(string7).toString();
        this.riljLog(string10);
        this.send(rILRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setupDefaultPDP(String string2, String string3, String string4, Message message) {
        int n = string3 != null ? 3 : 0;
        String string5 = Integer.toString(1);
        String string6 = Integer.toString(n);
        RIL rIL = this;
        String string7 = string2;
        String string8 = string3;
        String string9 = string4;
        Message message2 = message;
        rIL.setupDataCall(string5, "", string7, string8, string9, string6, message2);
    }

    @Override
    public void startDtmf(char c, Message message) {
        RILRequest rILRequest = RILRequest.obtain(49, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        Parcel parcel = rILRequest.mp;
        String string5 = Character.toString(c);
        parcel.writeString(string5);
        this.send(rILRequest);
    }

    @Override
    public void stopDtmf(Message message) {
        RILRequest rILRequest = RILRequest.obtain(50, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void supplyIccPin(String string2, Message message) {
        RILRequest rILRequest = RILRequest.obtain(2, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append("> ");
        String string4 = RIL.requestToString(rILRequest.mRequest);
        String string5 = stringBuilder2.append(string4).toString();
        this.riljLog(string5);
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeString(string2);
        this.send(rILRequest);
    }

    @Override
    public void supplyIccPin2(String string2, Message message) {
        RILRequest rILRequest = RILRequest.obtain(4, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append("> ");
        String string4 = RIL.requestToString(rILRequest.mRequest);
        String string5 = stringBuilder2.append(string4).toString();
        this.riljLog(string5);
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeString(string2);
        this.send(rILRequest);
    }

    @Override
    public void supplyIccPuk(String string2, String string3, Message message) {
        RILRequest rILRequest = RILRequest.obtain(3, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string4).append("> ");
        String string5 = RIL.requestToString(rILRequest.mRequest);
        String string6 = stringBuilder2.append(string5).toString();
        this.riljLog(string6);
        rILRequest.mp.writeInt(2);
        rILRequest.mp.writeString(string2);
        rILRequest.mp.writeString(string3);
        this.send(rILRequest);
    }

    @Override
    public void supplyIccPuk2(String string2, String string3, Message message) {
        RILRequest rILRequest = RILRequest.obtain(5, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string4).append("> ");
        String string5 = RIL.requestToString(rILRequest.mRequest);
        String string6 = stringBuilder2.append(string5).toString();
        this.riljLog(string6);
        rILRequest.mp.writeInt(2);
        rILRequest.mp.writeString(string2);
        rILRequest.mp.writeString(string3);
        this.send(rILRequest);
    }

    @Override
    public void supplyNetworkDepersonalization(String string2, Message message) {
        RILRequest rILRequest = RILRequest.obtain(8, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append("> ");
        String string4 = RIL.requestToString(rILRequest.mRequest);
        String string5 = stringBuilder2.append(string4).toString();
        this.riljLog(string5);
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeString(string2);
        this.send(rILRequest);
    }

    @Override
    public void switchWaitingOrHoldingAndActive(Message message) {
        RILRequest rILRequest = RILRequest.obtain(15, message);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("> ");
        String string3 = RIL.requestToString(rILRequest.mRequest);
        String string4 = stringBuilder2.append(string3).toString();
        this.riljLog(string4);
        this.send(rILRequest);
    }

    @Override
    public void writeSmsToRuim(int n, String string2, Message message) {
        int n2 = this.translateStatus(n);
        RILRequest rILRequest = RILRequest.obtain(96, message);
        rILRequest.mp.writeInt(n2);
        rILRequest.mp.writeString(string2);
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append("> ");
        String string4 = RIL.requestToString(rILRequest.mRequest);
        String string5 = stringBuilder2.append(string4).append(" ").append(n2).toString();
        this.riljLog(string5);
        this.send(rILRequest);
    }

    @Override
    public void writeSmsToSim(int n, String string2, String string3, Message message) {
        int n2 = this.translateStatus(n);
        RILRequest rILRequest = RILRequest.obtain(63, message);
        rILRequest.mp.writeInt(n2);
        rILRequest.mp.writeString(string3);
        rILRequest.mp.writeString(string2);
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = rILRequest.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string4).append("> ");
        String string5 = RIL.requestToString(rILRequest.mRequest);
        String string6 = stringBuilder2.append(string5).append(" ").append(n2).toString();
        this.riljLog(string6);
        this.send(rILRequest);
    }

    class RILReceiver
    implements Runnable {
        byte[] buffer;

        RILReceiver() {
            byte[] byArray = new byte[8192];
            this.buffer = byArray;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 11[TRYBLOCK] [19 : 312->383)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    class RILSender
    extends Handler
    implements Runnable {
        byte[] dataLength;

        public RILSender(Looper looper) {
            super(looper);
            byte[] byArray = new byte[4];
            this.dataLength = byArray;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message var1_1) {
            var2_2 = (RILRequest)var1_1.obj;
            switch (var1_1.what) {
                default: {
                    return;
                }
                case 1: {
                    var3_3 = false;
                    try {
                        var4_4 = RIL.this.mSocket;
                        if (var4_4 == null) {
                            var2_2.onError(1, null);
                            var2_2.release();
                            if (RIL.this.mRequestMessagesPending <= 0) return;
                            var5_5 = RIL.this;
                            var5_5.mRequestMessagesPending = var6_6 = var5_5.mRequestMessagesPending - 1;
                            return;
                        }
                        var7_7 = RIL.this.mRequestsList;
                        synchronized (var7_7) {
                        }
                    }
                    catch (IOException var17_18) {
                        var18_19 = Log.e("RILJ", "IOException", var17_18);
                        var19_20 = RIL.this;
                        var20_21 = var2_2.mSerial;
                        if (RIL.access$100(var19_20, var20_21) != null || !var3_3) {
                            var2_2.onError(1, null);
                            var2_2.release();
                        }
lbl26:
                        // 6 sources

                        while (true) {
                            if (var3_3) {
                                return;
                            }
                            if (RIL.this.mRequestMessagesPending <= 0) {
                                return;
                            }
                            var21_22 = RIL.this;
                            var21_22.mRequestMessagesPending = var22_23 = var21_22.mRequestMessagesPending - 1;
                            return;
                        }
                    }
                    {
                        var8_9 = RIL.this.mRequestsList.add(var2_2);
                        var9_10 = RIL.this;
                        var9_10.mRequestMessagesWaiting = var10_11 = var9_10.mRequestMessagesWaiting + 1;
                    }
                    try {
                        if (RIL.this.mRequestMessagesPending > 0) {
                            var11_12 = RIL.this;
                            var11_12.mRequestMessagesPending = var12_13 = var11_12.mRequestMessagesPending - 1;
                        }
                        var3_3 = true;
                        var13_14 = var2_2.mp.marshall();
                        var2_2.mp.recycle();
                        var2_2.mp = null;
                        if (var13_14.length > 8192) {
                            var14_15 = new StringBuilder().append("Parcel larger than max bytes allowed! ");
                            var15_16 = var13_14.length;
                            var16_17 = var14_15.append(var15_16).toString();
                            throw new RuntimeException(var16_17);
                        }
                    }
                    catch (RuntimeException var24_24) {
                        var25_25 = Log.e("RILJ", "Uncaught exception ", var24_24);
                        var26_26 = RIL.this;
                        var27_27 = var2_2.mSerial;
                        if (RIL.access$100(var26_26, var27_27) == null && var3_3) ** GOTO lbl26
                        var2_2.onError(2, null);
                        var2_2.release();
                        ** GOTO lbl26
                    }
                    {
                        var28_28 = this.dataLength;
                        this.dataLength[1] = 0;
                        var28_28[0] = 0;
                        var29_29 = this.dataLength;
                        var29_29[2] = var30_30 = (byte)(var13_14.length >> 8 & 255);
                        var31_31 = this.dataLength;
                        var31_31[3] = var32_32 = (byte)(var13_14.length & 255);
                        var33_33 = var4_4.getOutputStream();
                        var34_34 = this.dataLength;
                        var33_33.write(var34_34);
                        var4_4.getOutputStream().write(var13_14);
                        ** continue;
                    }
                }
                case 2: 
            }
            var7_8 = RIL.this.mWakeLock;
            synchronized (var7_8) {
                if (RIL.this.mWakeLock.isHeld() == false) return;
                if (RIL.this.mRequestMessagesWaiting != 0) {
                    var35_35 = new StringBuilder().append("NOTE: mReqWaiting is NOT 0 but");
                    var36_36 = RIL.this.mRequestMessagesWaiting;
                    var37_37 = var35_35.append(var36_36).append(" at TIMEOUT, reset!").append(" There still msg waitng for response").toString();
                    var38_38 = Log.d("RILJ", var37_37);
                    RIL.this.mRequestMessagesWaiting = 0;
                    var23_39 = RIL.this.mRequestsList;
                    synchronized (var23_39) {
                        var39_40 = RIL.this.mRequestsList.size();
                        var40_41 = "WAKE_LOCK_TIMEOUT  mRequestList=" + var39_40;
                        var41_42 = Log.d("RILJ", var40_41);
                        for (var42_43 = 0; var42_43 < var39_40; ++var42_43) {
                            var43_44 = RIL.this.mRequestsList.get(var42_43);
                            var44_45 = new StringBuilder().append(var42_43).append(": [");
                            var45_46 = var43_44.mSerial;
                            var46_47 = var44_45.append(var45_46).append("] ");
                            var47_48 = RIL.requestToString(var43_44.mRequest);
                            var48_49 = var46_47.append(var47_48).toString();
                            var49_50 = Log.d("RILJ", var48_49);
                        }
                    }
                }
                if (RIL.this.mRequestMessagesPending != 0) {
                    var50_51 = new StringBuilder().append("ERROR: mReqPending is NOT 0 but");
                    var51_52 = RIL.this.mRequestMessagesPending;
                    var52_53 = var50_51.append(var51_52).append(" at TIMEOUT, reset!").toString();
                    var53_54 = Log.e("RILJ", var52_53);
                    RIL.this.mRequestMessagesPending = 0;
                }
                RIL.this.mWakeLock.release();
                return;
            }
        }

        @Override
        public void run() {
        }
    }
}

