/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Message;
import android.os.Parcel;
import android.util.Log;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.RIL;

class RILRequest {
    static final String LOG_TAG = "RILJ";
    private static final int MAX_POOL_SIZE = 4;
    static int sNextSerial = 0;
    private static RILRequest sPool;
    private static int sPoolSize;
    private static Object sPoolSync;
    static Object sSerialMonitor;
    RILRequest mNext;
    int mRequest;
    Message mResult;
    int mSerial;
    Parcel mp;

    static {
        sSerialMonitor = new Object();
        sPoolSync = new Object();
        sPool = null;
        sPoolSize = 0;
    }

    private RILRequest() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static RILRequest obtain(int n, Message message) {
        Parcel parcel;
        RILRequest rILRequest = null;
        Object object = sPoolSync;
        // MONITORENTER : object
        if (sPool != null) {
            rILRequest = sPool;
            sPool = rILRequest.mNext;
            rILRequest.mNext = null;
            --sPoolSize;
        }
        // MONITOREXIT : object
        if (rILRequest == null) {
            rILRequest = new RILRequest();
        }
        Object object2 = sSerialMonitor;
        // MONITORENTER : object2
        int n2 = sNextSerial;
        sNextSerial = n2 + 1;
        rILRequest.mSerial = n2;
        // MONITOREXIT : object2
        rILRequest.mRequest = n;
        rILRequest.mResult = message;
        rILRequest.mp = parcel = Parcel.obtain();
        if (message != null && message.getTarget() == null) {
            throw new NullPointerException("Message target must not be null");
        }
        rILRequest.mp.writeInt(n);
        Parcel parcel2 = rILRequest.mp;
        int n3 = rILRequest.mSerial;
        parcel2.writeInt(n3);
        return rILRequest;
    }

    static void resetSerial() {
        Object object = sSerialMonitor;
        synchronized (object) {
            sNextSerial = 0;
            return;
        }
    }

    void onError(int n, Object object) {
        CommandException commandException = CommandException.fromRilErrno(n);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.serialString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("< ");
        String string3 = RIL.requestToString(this.mRequest);
        String string4 = stringBuilder2.append(string3).append(" error: ").append(commandException).toString();
        int n2 = Log.d(LOG_TAG, string4);
        if (this.mResult != null) {
            AsyncResult asyncResult = AsyncResult.forMessage(this.mResult, object, commandException);
            this.mResult.sendToTarget();
        }
        if (this.mp == null) {
            return;
        }
        this.mp.recycle();
        this.mp = null;
    }

    void release() {
        Object object = sPoolSync;
        synchronized (object) {
            if (sPoolSize < 4) {
                RILRequest rILRequest;
                this.mNext = rILRequest = sPool;
                sPool = this;
                ++sPoolSize;
            }
            return;
        }
    }

    String serialString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder(8);
        String string2 = Integer.toString(this.mSerial);
        StringBuilder stringBuilder2 = stringBuilder.append('[');
        int n2 = string2.length();
        for (int i = 0; i < (n = 4 - n2); ++i) {
            StringBuilder stringBuilder3 = stringBuilder.append('0');
        }
        StringBuilder stringBuilder4 = stringBuilder.append(string2);
        StringBuilder stringBuilder5 = stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

