/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import java.util.ArrayList;
import java.util.Random;

public class RetryManager {
    public static final boolean DBG = false;
    public static final String LOG_TAG = "RetryManager";
    private int mMaxRetryCount;
    private ArrayList<RetryRec> mRetryArray;
    private int mRetryCount;
    private boolean mRetryForever;
    private Random rng;

    public RetryManager() {
        Random random;
        ArrayList arrayList = new ArrayList();
        this.mRetryArray = arrayList;
        this.rng = random = new Random();
    }

    private void log(String string2) {
        int n = Log.d(LOG_TAG, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int nextRandomizationTime(int n) {
        int n2 = this.mRetryArray.get((int)n).mRandomizationTime;
        if (n2 != 0) return this.rng.nextInt(n2);
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Pair<Boolean, Integer> parseNonNegativeInt(String string2, String string3) {
        try {
            int n = Integer.parseInt(string3);
            Boolean bl = this.validateNonNegativeInt(string2, n);
            Integer n2 = n;
            return new Pair<Boolean, Integer>(bl, n2);
        }
        catch (NumberFormatException numberFormatException) {
            String string4 = string2 + " bad value: " + string3;
            int n = Log.e(LOG_TAG, string4, numberFormatException);
            Boolean bl = false;
            Integer n3 = 0;
            return new Pair<Boolean, Integer>(bl, n3);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validateNonNegativeInt(String string2, int n) {
        if (n >= 0) return true;
        String string3 = string2 + " bad value: is < 0";
        int n2 = Log.e(LOG_TAG, string3);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean configure(int n, int n2, int n3) {
        if (!this.validateNonNegativeInt("maxRetryCount", n)) {
            return false;
        }
        if (!this.validateNonNegativeInt("retryTime", n2)) {
            return false;
        }
        if (!this.validateNonNegativeInt("randomizationTime", n3)) {
            return false;
        }
        this.mMaxRetryCount = n;
        this.resetRetryCount();
        this.mRetryArray.clear();
        ArrayList<RetryRec> arrayList = this.mRetryArray;
        RetryRec retryRec = new RetryRec(n2, n3);
        boolean bl = arrayList.add(retryRec);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean configure(String string2) {
        int n;
        int n2;
        int n3;
        if (string2.startsWith("\"") && string2.endsWith("\"")) {
            int n4 = string2.length() - 1;
            string2 = string2.substring(1, n4);
        }
        if (TextUtils.isEmpty(string2)) {
            return false;
        }
        int n5 = 0;
        this.mMaxRetryCount = 0;
        this.resetRetryCount();
        this.mRetryArray.clear();
        String[] stringArray = string2.split(",");
        for (int i = 0; i < (n3 = stringArray.length); ++i) {
            int n6;
            String string3;
            Pair<Boolean, Integer> pair;
            String string4;
            String[] stringArray2 = stringArray[i].split("=", 2);
            stringArray2[0] = string4 = stringArray2[0].trim();
            if (stringArray2.length > 1) {
                int n7;
                String string5;
                stringArray2[1] = string5 = stringArray2[1].trim();
                if (TextUtils.equals(stringArray2[0], "default_randomization")) {
                    String string6 = stringArray2[0];
                    String string7 = stringArray2[1];
                    pair = this.parseNonNegativeInt(string6, string7);
                    if (!((Boolean)pair.first).booleanValue()) {
                        return false;
                    }
                    n5 = (Integer)pair.second;
                    continue;
                }
                if (!TextUtils.equals(stringArray2[0], "max_retries")) {
                    StringBuilder stringBuilder = new StringBuilder().append("Unrecognized configuration name value pair: ");
                    String string8 = stringArray[i];
                    String string9 = stringBuilder.append(string8).toString();
                    int n8 = Log.e(LOG_TAG, string9);
                    return false;
                }
                String string10 = stringArray2[1];
                if (TextUtils.equals("infinite", string10)) {
                    this.mRetryForever = true;
                    continue;
                }
                String string11 = stringArray2[0];
                String string12 = stringArray2[1];
                pair = this.parseNonNegativeInt(string11, string12);
                if (!((Boolean)pair.first).booleanValue()) {
                    return false;
                }
                this.mMaxRetryCount = n7 = ((Integer)pair.second).intValue();
                continue;
            }
            stringArray2 = stringArray[i].split(":", 2);
            stringArray2[0] = string3 = stringArray2[0].trim();
            RetryRec retryRec = new RetryRec(0, 0);
            String string13 = stringArray2[0];
            pair = this.parseNonNegativeInt("delayTime", string13);
            if (!((Boolean)pair.first).booleanValue()) {
                return false;
            }
            retryRec.mDelayTime = n6 = ((Integer)pair.second).intValue();
            if (stringArray2.length > 1) {
                int n9;
                String string14;
                stringArray2[1] = string14 = stringArray2[1].trim();
                String string15 = stringArray2[1];
                pair = this.parseNonNegativeInt("randomizationTime", string15);
                if (!((Boolean)pair.first).booleanValue()) {
                    return false;
                }
                retryRec.mRandomizationTime = n9 = ((Integer)pair.second).intValue();
            } else {
                retryRec.mRandomizationTime = n5;
            }
            boolean bl = this.mRetryArray.add(retryRec);
        }
        int n10 = this.mRetryArray.size();
        if (n10 <= (n2 = this.mMaxRetryCount)) return true;
        this.mMaxRetryCount = n = this.mRetryArray.size();
        return true;
    }

    public int getRetryCount() {
        return this.mRetryCount;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getRetryTimer() {
        int n = this.mRetryCount;
        int n2 = this.mRetryArray.size();
        int n3 = n < n2 ? this.mRetryCount : this.mRetryArray.size() - 1;
        if (n3 < 0) return 0;
        int n4 = this.mRetryArray.size();
        if (n3 >= n4) return 0;
        int n5 = this.mRetryArray.get((int)n3).mDelayTime;
        int n6 = this.nextRandomizationTime(n3);
        return n5 + n6;
    }

    public void increaseRetryCount() {
        int n;
        int n2 = this.mRetryCount + 1;
        this.mRetryCount = n2;
        int n3 = this.mRetryCount;
        int n4 = this.mMaxRetryCount;
        if (n3 <= n4) {
            return;
        }
        this.mRetryCount = n = this.mMaxRetryCount;
    }

    public boolean isRetryForever() {
        return this.mRetryForever;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRetryNeeded() {
        if (this.mRetryForever) return true;
        int n = this.mRetryCount;
        int n2 = this.mMaxRetryCount;
        if (n >= n2) return false;
        return true;
    }

    public void resetRetryCount() {
        this.mRetryCount = 0;
        this.mRetryForever = false;
    }

    public void retryForeverUsingLastTimeout() {
        int n;
        this.mRetryCount = n = this.mMaxRetryCount;
        this.mRetryForever = true;
    }

    public void setRetryCount(int n) {
        this.mRetryCount = n;
        int n2 = this.mRetryCount;
        int n3 = this.mMaxRetryCount;
        if (n2 > n3) {
            int n4;
            this.mRetryCount = n4 = this.mMaxRetryCount;
        }
        if (this.mRetryCount < 0) {
            this.mRetryCount = 0;
        }
        this.mRetryForever = false;
    }

    private static class RetryRec {
        int mDelayTime;
        int mRandomizationTime;

        RetryRec(int n, int n2) {
            this.mDelayTime = n;
            this.mRandomizationTime = n2;
        }
    }
}

