/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AlertDialog;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.database.SQLException;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.provider.Settings;
import android.provider.Telephony;
import android.telephony.SmsMessage;
import android.util.Log;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.SmsResponse;
import com.android.internal.telephony.WapPushOverSms;
import com.android.internal.util.HexDump;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public abstract class SMSDispatcher
extends Handler {
    private static final int DEFAULT_SMS_CHECK_PERIOD = 3600000;
    private static final int DEFAULT_SMS_MAX_COUNT = 100;
    private static final int DEFAULT_SMS_TIMEOUT = 6000;
    protected static final int EVENT_ALERT_TIMEOUT = 9;
    protected static final int EVENT_ICC_FULL = 6;
    protected static final int EVENT_NEW_SMS = 1;
    protected static final int EVENT_NEW_SMS_STATUS_REPORT = 5;
    protected static final int EVENT_POST_ALERT = 7;
    protected static final int EVENT_RADIO_ON = 12;
    protected static final int EVENT_REPORT_MEMORY_STATUS_DONE = 11;
    protected static final int EVENT_SEND_CONFIRMED_SMS = 8;
    protected static final int EVENT_SEND_RETRY = 3;
    protected static final int EVENT_SEND_SMS_COMPLETE = 2;
    protected static final int EVENT_STOP_SENDING = 10;
    private static final int MAX_SEND_RETRIES = 3;
    private static final int MO_MSG_QUEUE_LIMIT = 5;
    protected static final String[] RAW_PROJECTION;
    private static final String SEND_NEXT_MSG_EXTRA = "SendNextMsg";
    private static final int SEND_RETRY_DELAY = 2000;
    private static final int SINGLE_PART_SMS = 1;
    private static final String TAG = "SMS";
    protected static int mRemainingMessages;
    private static int sConcatenatedRef;
    private final int WAKE_LOCK_TIMEOUT;
    protected final ArrayList<SmsTracker> deliveryPendingList;
    protected CommandsInterface mCm;
    protected Context mContext;
    private SmsCounter mCounter;
    private DialogInterface.OnClickListener mListener;
    protected Phone mPhone;
    protected final Uri mRawUri;
    protected boolean mReportMemoryStatusPending;
    protected ContentResolver mResolver;
    private BroadcastReceiver mResultReceiver;
    private ArrayList<SmsTracker> mSTrackers;
    protected boolean mStorageAvailable;
    private PowerManager.WakeLock mWakeLock;
    protected final WapPushOverSms mWapPush;

    static {
        String[] stringArray = new String[]{"pdu", "sequence", "destination_port"};
        RAW_PROJECTION = stringArray;
        mRemainingMessages = -1;
    }

    protected SMSDispatcher(PhoneBase phoneBase) {
        SmsCounter smsCounter;
        CommandsInterface commandsInterface;
        ContentResolver contentResolver;
        Context context;
        WapPushOverSms wapPushOverSms;
        BroadcastReceiver broadcastReceiver;
        DialogInterface.OnClickListener onClickListener;
        Uri uri;
        this.mRawUri = uri = Uri.withAppendedPath(Telephony.Sms.CONTENT_URI, "raw");
        ArrayList arrayList = new ArrayList(5);
        this.mSTrackers = arrayList;
        this.WAKE_LOCK_TIMEOUT = 5000;
        this.mStorageAvailable = true;
        this.mReportMemoryStatusPending = false;
        ArrayList arrayList2 = new ArrayList();
        this.deliveryPendingList = arrayList2;
        this.mListener = onClickListener = new DialogInterface.OnClickListener(){

            @Override
            public void onClick(DialogInterface dialogInterface, int n) {
                if (n == -1) {
                    int n2 = Log.d(SMSDispatcher.TAG, "click YES to send out sms");
                    SMSDispatcher sMSDispatcher = SMSDispatcher.this;
                    Message message = SMSDispatcher.this.obtainMessage(8);
                    boolean bl = sMSDispatcher.sendMessage(message);
                    return;
                }
                if (n != -1) {
                    return;
                }
                int n3 = Log.d(SMSDispatcher.TAG, "click NO to stop sending");
                SMSDispatcher sMSDispatcher = SMSDispatcher.this;
                Message message = SMSDispatcher.this.obtainMessage(10);
                boolean bl = sMSDispatcher.sendMessage(message);
            }
        };
        this.mResultReceiver = broadcastReceiver = new BroadcastReceiver(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.intent.action.DEVICE_STORAGE_FULL")) {
                    SMSDispatcher.this.mStorageAvailable = false;
                    CommandsInterface commandsInterface = SMSDispatcher.this.mCm;
                    Message message = SMSDispatcher.this.obtainMessage(11);
                    commandsInterface.reportSmsMemoryStatus(false, message);
                    return;
                }
                if (intent.getAction().equals("android.intent.action.DEVICE_STORAGE_NOT_FULL")) {
                    SMSDispatcher.this.mStorageAvailable = true;
                    CommandsInterface commandsInterface = SMSDispatcher.this.mCm;
                    Message message = SMSDispatcher.this.obtainMessage(11);
                    commandsInterface.reportSmsMemoryStatus(true, message);
                    return;
                }
                int n = this.getResultCode();
                boolean bl = n == -1 || n == 1;
                SMSDispatcher.this.acknowledgeLastIncomingSms(bl, n, null);
            }
        };
        this.mPhone = phoneBase;
        this.mWapPush = wapPushOverSms = new WapPushOverSms(phoneBase, this);
        this.mContext = context = phoneBase.getContext();
        this.mResolver = contentResolver = this.mContext.getContentResolver();
        this.mCm = commandsInterface = phoneBase.mCM;
        this.createWakelock();
        int n = Settings.Secure.getInt(this.mResolver, "sms_outgoing_check_interval_ms", 3600000);
        int n2 = Settings.Secure.getInt(this.mResolver, "sms_outgoing_check_max_count", 100);
        this.mCounter = smsCounter = new SmsCounter(n2, n);
        this.mCm.setOnNewSMS(this, 1, null);
        this.mCm.setOnSmsStatus(this, 5, null);
        this.mCm.setOnIccSmsFull(this, 6, null);
        this.mCm.registerForOn(this, 12, null);
        sConcatenatedRef = new Random().nextInt(256);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.DEVICE_STORAGE_FULL");
        intentFilter.addAction("android.intent.action.DEVICE_STORAGE_NOT_FULL");
        Context context2 = this.mContext;
        BroadcastReceiver broadcastReceiver2 = this.mResultReceiver;
        Intent intent = context2.registerReceiver(broadcastReceiver2, intentFilter);
    }

    private void createWakelock() {
        PowerManager.WakeLock wakeLock;
        this.mWakeLock = wakeLock = ((PowerManager)this.mContext.getSystemService("power")).newWakeLock(1, "SMSDispatcher");
        this.mWakeLock.setReferenceCounted(true);
    }

    protected static int getNextConcatenatedRef() {
        return ++sConcatenatedRef;
    }

    private void handleIccFull() {
        Intent intent = new Intent("android.provider.Telephony.SIM_FULL");
        this.mWakeLock.acquire(5000L);
        this.mContext.sendBroadcast(intent, "android.permission.RECEIVE_SMS");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isMultipartTracker(SmsTracker smsTracker) {
        if (smsTracker.mData.get("parts") == null) return false;
        return true;
    }

    private void notifyAndAcknowledgeLastIncomingSms(boolean bl, int n, Message message) {
        if (!bl) {
            Intent intent = new Intent("android.provider.Telephony.SMS_REJECTED");
            Intent intent2 = intent.putExtra("result", n);
            this.mWakeLock.acquire(5000L);
            this.mContext.sendBroadcast(intent, "android.permission.RECEIVE_SMS");
        }
        this.acknowledgeLastIncomingSms(bl, n, message);
    }

    protected SmsTracker SmsTrackerFactory(HashMap hashMap, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        return new SmsTracker(hashMap, pendingIntent, pendingIntent2);
    }

    protected abstract void acknowledgeLastIncomingSms(boolean var1, int var2, Message var3);

    protected abstract void activateCellBroadcastSms(int var1, Message var2);

    void dispatch(Intent intent, String string2) {
        this.mWakeLock.acquire(5000L);
        Context context = this.mContext;
        BroadcastReceiver broadcastReceiver = this.mResultReceiver;
        Intent intent2 = intent;
        String string3 = string2;
        SMSDispatcher sMSDispatcher = this;
        Bundle bundle = null;
        context.sendOrderedBroadcast(intent2, string3, broadcastReceiver, sMSDispatcher, -1, null, bundle);
    }

    protected abstract int dispatchMessage(SmsMessageBase var1);

    protected void dispatchPdus(byte[][] byArray) {
        Intent intent = new Intent("android.provider.Telephony.SMS_RECEIVED");
        Intent intent2 = intent.putExtra("pdus", (Serializable)byArray);
        this.dispatch(intent, "android.permission.RECEIVE_SMS");
    }

    protected void dispatchPortAddressedPdus(byte[][] byArray, int n) {
        Uri uri = Uri.parse("sms://localhost:" + n);
        Intent intent = new Intent("android.intent.action.DATA_SMS_RECEIVED", uri);
        Intent intent2 = intent.putExtra("pdus", (Serializable)byArray);
        this.dispatch(intent, "android.permission.RECEIVE_SMS");
    }

    public void dispose() {
        this.mCm.unSetOnNewSMS(this);
        this.mCm.unSetOnSmsStatus(this);
        this.mCm.unSetOnIccSmsFull(this);
        this.mCm.unregisterForOn(this);
    }

    protected void finalize() {
        int n = Log.d(TAG, "SMSDispatcher finalized");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getAppNameByIntent(PendingIntent pendingIntent) {
        Resources resources = Resources.getSystem();
        if (pendingIntent == null) return resources.getString(17040151);
        return pendingIntent.getTargetPackage();
    }

    protected abstract void getCellBroadcastSmsConfig(Message var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                return;
            }
            case 1: {
                boolean bl;
                int n;
                int n2 = Log.d(TAG, "New SMS Message Received");
                AsyncResult asyncResult = (AsyncResult)message.obj;
                if (asyncResult.exception != null) {
                    StringBuilder stringBuilder = new StringBuilder().append("Exception processing incoming SMS. Exception:");
                    Throwable throwable = asyncResult.exception;
                    String string2 = stringBuilder.append(throwable).toString();
                    int n3 = Log.e(TAG, string2);
                    return;
                }
                SmsMessage smsMessage = (SmsMessage)asyncResult.result;
                try {
                    SmsMessageBase smsMessageBase = smsMessage.mWrappedSmsMessage;
                    n = this.dispatchMessage(smsMessageBase);
                    if (n == -1) {
                        return;
                    }
                    bl = n == 1;
                }
                catch (RuntimeException runtimeException) {
                    int n4 = Log.e(TAG, "Exception dispatching message", runtimeException);
                    this.notifyAndAcknowledgeLastIncomingSms(false, 2, null);
                    return;
                }
                this.notifyAndAcknowledgeLastIncomingSms(bl, n, null);
                return;
            }
            case 2: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                this.handleSendComplete(asyncResult);
                return;
            }
            case 3: {
                SmsTracker smsTracker = (SmsTracker)message.obj;
                this.sendSms(smsTracker);
                return;
            }
            case 5: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                this.handleStatusReport(asyncResult);
                return;
            }
            case 6: {
                this.handleIccFull();
                return;
            }
            case 7: {
                SmsTracker smsTracker = (SmsTracker)message.obj;
                this.handleReachSentLimit(smsTracker);
                return;
            }
            case 9: {
                ((AlertDialog)message.obj).dismiss();
                message.obj = null;
                if (!this.mSTrackers.isEmpty()) {
                    try {
                        this.mSTrackers.remove((int)0).mSentIntent.send(5);
                    }
                    catch (PendingIntent.CanceledException canceledException) {
                        int n = Log.e(TAG, "failed to send back RESULT_ERROR_LIMIT_EXCEEDED");
                    }
                }
                int n = Log.d(TAG, "EVENT_ALERT_TIMEOUT, message stop sending");
                return;
            }
            case 8: {
                if (this.mSTrackers.isEmpty()) {
                    return;
                }
                ArrayList<SmsTracker> arrayList = this.mSTrackers;
                int n = this.mSTrackers.size() - 1;
                SmsTracker smsTracker = arrayList.remove(n);
                if (this.isMultipartTracker(smsTracker)) {
                    this.sendMultipartSms(smsTracker);
                } else {
                    this.sendSms(smsTracker);
                }
                Object object = message.obj;
                this.removeMessages(9, object);
                return;
            }
            case 10: {
                if (this.mSTrackers.isEmpty()) {
                    return;
                }
                try {
                    ArrayList<SmsTracker> arrayList = this.mSTrackers;
                    int n = this.mSTrackers.size() - 1;
                    arrayList.remove((int)n).mSentIntent.send(5);
                }
                catch (PendingIntent.CanceledException canceledException) {
                    int n = Log.e(TAG, "failed to send back RESULT_ERROR_LIMIT_EXCEEDED");
                }
                Object object = message.obj;
                this.removeMessages(9, object);
                return;
            }
            case 11: {
                if (((AsyncResult)message.obj).exception != null) {
                    this.mReportMemoryStatusPending = true;
                    StringBuilder stringBuilder = new StringBuilder().append("Memory status report to modem pending : mStorageAvailable = ");
                    boolean bl = this.mStorageAvailable;
                    String string3 = stringBuilder.append(bl).toString();
                    int n = Log.v(TAG, string3);
                    return;
                }
                this.mReportMemoryStatusPending = false;
                return;
            }
            case 12: 
        }
        if (!this.mReportMemoryStatusPending) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Sending pending memory status report : mStorageAvailable = ");
        boolean bl = this.mStorageAvailable;
        String string4 = stringBuilder.append(bl).toString();
        int n = Log.v(TAG, string4);
        CommandsInterface commandsInterface = this.mCm;
        boolean bl2 = this.mStorageAvailable;
        Message message2 = this.obtainMessage(11);
        commandsInterface.reportSmsMemoryStatus(bl2, message2);
    }

    /*
     * Unable to fully structure code
     */
    protected void handleNotInService(int var1_1, SmsTracker var2_2) {
        if (var2_2.mSentIntent == null) {
            return;
        }
        if (var1_1 != 3) ** GOTO lbl7
        try {
            var2_2.mSentIntent.send(2);
            return;
lbl7:
            // 1 sources

            var2_2.mSentIntent.send(4);
            return;
        }
        catch (PendingIntent.CanceledException var3_3) {
            return;
        }
    }

    protected void handleReachSentLimit(SmsTracker smsTracker) {
        if (this.mSTrackers.size() >= 5) {
            try {
                smsTracker.mSentIntent.send(5);
                return;
            }
            catch (PendingIntent.CanceledException canceledException) {
                int n = Log.e(TAG, "failed to send back RESULT_ERROR_LIMIT_EXCEEDED");
                return;
            }
        }
        Resources resources = Resources.getSystem();
        PendingIntent pendingIntent = smsTracker.mSentIntent;
        String string2 = this.getAppNameByIntent(pendingIntent);
        Context context = this.mContext;
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        String string3 = resources.getString(17040152);
        AlertDialog.Builder builder2 = builder.setTitle(string3);
        StringBuilder stringBuilder = new StringBuilder().append(string2).append(" ");
        String string4 = resources.getString(17040153);
        String string5 = stringBuilder.append(string4).toString();
        AlertDialog.Builder builder3 = builder2.setMessage(string5);
        String string6 = resources.getString(17040154);
        DialogInterface.OnClickListener onClickListener = this.mListener;
        AlertDialog.Builder builder4 = builder3.setPositiveButton(string6, onClickListener);
        String string7 = resources.getString(17040155);
        DialogInterface.OnClickListener onClickListener2 = this.mListener;
        AlertDialog alertDialog = builder4.setNegativeButton(string7, onClickListener2).create();
        alertDialog.getWindow().setType(2003);
        alertDialog.show();
        boolean bl = this.mSTrackers.add(smsTracker);
        Message message = this.obtainMessage(9, alertDialog);
        boolean bl2 = this.sendMessageDelayed(message, 6000L);
    }

    protected void handleSendComplete(AsyncResult asyncResult) {
        CommandException.Error error;
        CommandException.Error error2;
        SmsTracker smsTracker = (SmsTracker)asyncResult.userObj;
        PendingIntent pendingIntent = smsTracker.mSentIntent;
        if (asyncResult.exception == null) {
            String string2 = "SMS send complete. Broadcasting intent: " + pendingIntent;
            int n = Log.d(TAG, string2);
            if (smsTracker.mDeliveryIntent != null) {
                int n2;
                smsTracker.mMessageRef = n2 = ((SmsResponse)asyncResult.result).messageRef;
                boolean bl = this.deliveryPendingList.add(smsTracker);
            }
            if (pendingIntent == null) {
                return;
            }
            try {
                if (mRemainingMessages > -1) {
                    --mRemainingMessages;
                }
                if (mRemainingMessages == 0) {
                    Intent intent = new Intent();
                    Intent intent2 = intent.putExtra(SEND_NEXT_MSG_EXTRA, true);
                    Context context = this.mContext;
                    pendingIntent.send(context, -1, intent);
                    return;
                }
                pendingIntent.send(-1);
                return;
            }
            catch (PendingIntent.CanceledException canceledException) {
                return;
            }
        }
        int n = Log.d(TAG, "SMS send failed");
        int n3 = this.mPhone.getServiceState().getState();
        if (n3 != 0) {
            this.handleNotInService(n3, smsTracker);
            return;
        }
        CommandException.Error error3 = ((CommandException)asyncResult.exception).getCommandError();
        if (error3 == (error2 = CommandException.Error.SMS_FAIL_RETRY) && smsTracker.mRetryCount < 3) {
            int n4;
            smsTracker.mRetryCount = n4 = smsTracker.mRetryCount + 1;
            Message message = this.obtainMessage(3, smsTracker);
            boolean bl = this.sendMessageDelayed(message, 2000L);
            return;
        }
        if (smsTracker.mSentIntent == null) {
            return;
        }
        int n5 = 1;
        CommandException.Error error4 = ((CommandException)asyncResult.exception).getCommandError();
        if (error4 == (error = CommandException.Error.FDN_CHECK_FAILURE)) {
            n5 = 6;
        }
        try {
            Intent intent = new Intent();
            if (asyncResult.result != null) {
                int n6 = ((SmsResponse)asyncResult.result).errorCode;
                Intent intent3 = intent.putExtra("errorCode", n6);
            }
            if (mRemainingMessages > -1) {
                --mRemainingMessages;
            }
            if (mRemainingMessages == 0) {
                Intent intent4 = intent.putExtra(SEND_NEXT_MSG_EXTRA, true);
            }
            PendingIntent pendingIntent2 = smsTracker.mSentIntent;
            Context context = this.mContext;
            pendingIntent2.send(context, n5, intent);
            return;
        }
        catch (PendingIntent.CanceledException canceledException) {
            return;
        }
    }

    protected abstract void handleStatusReport(AsyncResult var1);

    /*
     * Unable to fully structure code
     */
    protected int processMessagePart(SmsMessageBase var1_1, SmsHeader.ConcatRef var2_2, SmsHeader.PortAddrs var3_3) {
        block14: {
            block15: {
                block13: {
                    block12: {
                        var5_5 = var4_4;
                        var6_6 = "reference_number =";
                        var5_5(var6_6);
                        var7_7 = var2_2.refNumber;
                        var8_8 = var4_4;
                        var9_9 = var7_7;
                        var10_10 = var8_8.append(var9_9);
                        var11_11 = var4_4;
                        var12_12 = " AND address = ?";
                        var13_13 = var11_11.append(var12_12);
                        var15_15 = var1_1.getOriginatingAddress();
                        var14_14 = new String[]{var15_15};
                        var16_16 = null;
                        var17_17 = this.mResolver;
                        var18_18 = this.mRawUri;
                        var19_19 = SMSDispatcher.RAW_PROJECTION;
                        var20_20 = var4_4.toString();
                        var21_21 = var17_17.query(var18_18, var19_19, var20_20, var14_14, null);
                        var22_22 = var21_21.getCount();
                        var23_23 = var2_2.msgCount - 1;
                        if (var22_22 == var23_23) break block12;
                        var24_24 = new ContentValues();
                        var25_25 = var1_1.getTimestampMillis();
                        var27_26 = new Long(var25_25);
                        var28_27 = var24_24;
                        var29_28 = "date";
                        var30_29 = var27_26;
                        var28_27.put(var29_28, var30_29);
                        var31_30 = HexDump.toHexString(var1_1.getPdu());
                        var32_31 = var24_24;
                        var33_32 = "pdu";
                        var34_33 = var31_30;
                        var32_31.put(var33_32, var34_33);
                        var35_34 = var1_1.getOriginatingAddress();
                        var36_35 = var24_24;
                        var37_36 = "address";
                        var38_37 = var35_34;
                        var36_35.put(var37_36, var38_37);
                        var39_38 = var2_2.refNumber;
                        var40_39 = var24_24;
                        var41_40 = "reference_number";
                        var42_41 = var39_38;
                        var40_39.put(var41_40, var42_41);
                        var43_42 = var2_2.msgCount;
                        var44_43 = var24_24;
                        var45_44 = "count";
                        var46_45 = var43_42;
                        var44_43.put(var45_44, var46_45);
                        var47_46 = var2_2.seqNumber;
                        var48_47 = var24_24;
                        var49_48 = "sequence";
                        var50_49 = var47_46;
                        var48_47.put(var49_48, var50_49);
                        if (var3_3 != null) {
                            var51_50 = var3_3.destPort;
                            var52_51 = var24_24;
                            var53_52 = "destination_port";
                            var54_53 = var51_50;
                            var52_51.put(var53_52, var54_53);
                        }
                        var55_54 = this.mResolver;
                        var56_55 = this.mRawUri;
                        var57_56 = var55_54;
                        var58_57 = var56_55;
                        var59_58 = var24_24;
                        var60_59 = var57_56.insert(var58_57, var59_58);
                        var61_60 = 1;
                        if (var21_21 == null) ** GOTO lbl71
lbl69:
                        // 2 sources

                        while (true) {
                            var21_21.close();
lbl71:
                            // 5 sources

                            return var61_60;
                        }
                    }
                    try {
                        var62_61 = var21_21.getColumnIndex("pdu");
                        var63_62 = var21_21.getColumnIndex("sequence");
                        var64_63 = new byte[var2_2.msgCount];
                        var65_64 = 0;
                        while (var65_64 < var22_22) {
                            var66_65 = var21_21.moveToNext();
                            var67_66 = var21_21;
                            var68_67 = var63_62;
                            var69_68 = (int)var67_66.getLong(var68_67) - 1;
                            var70_69 = var21_21;
                            var71_70 = var62_61;
                            var72_71 = HexDump.hexStringToByteArray(var70_69.getString(var71_70));
                            var64_63[var69_68] = (byte)var72_71;
                            var73_72 = var65_64 + 1;
                        }
                        var74_73 = var2_2.seqNumber - 1;
                        var75_74 = var1_1.getPdu();
                        var64_63[var74_73] = (byte)var75_74;
                        var76_75 = this.mResolver;
                        var77_76 = this.mRawUri;
                        var78_77 = var4_4.toString();
                        var79_78 = var76_75.delete(var77_76, var78_77, var14_14);
                        if (var21_21 == null) break block13;
                    }
                    catch (SQLException var88_87) {
                        try {
                            var89_88 = Log.e("SMS", "Can't access multipart SMS database", var88_87);
                            var61_60 = 2;
                            if (var21_21 == null) ** GOTO lbl71
                            ** continue;
                        }
                        catch (Throwable var90_89) {
                            if (var21_21 != null) {
                                var21_21.close();
                            }
                            throw var90_89;
                        }
                    }
                    var21_21.close();
                }
                if (var3_3 == null) break block14;
                if (var3_3.destPort != 2948) break block15;
                var80_79 = new ByteArrayOutputStream();
                for (var65_64 = 0; var65_64 < (var81_80 = var2_2.msgCount); ++var65_64) {
                    var82_81 = SmsMessage.createFromPdu((byte[])var64_63[var65_64]).getUserData();
                    var83_82 = var82_81.length;
                    var84_83 = var80_79;
                    var85_84 = var82_81;
                    var86_85 = 0;
                    var87_86 = var83_82;
                    var84_83.write(var85_84, var86_85, var87_86);
                }
                var91_90 = this.mWapPush;
                var92_91 = var80_79.toByteArray();
                var61_60 = var91_90.dispatchWapPdu(var92_91);
                ** GOTO lbl71
            }
            var93_92 = var3_3.destPort;
            var94_93 = this;
            var95_94 = var64_63;
            var96_95 = var93_92;
            var94_93.dispatchPortAddressedPdus((byte[][])var95_94, var96_95);
lbl134:
            // 2 sources

            while (true) {
                var61_60 = -1;
                ** continue;
                break;
            }
        }
        var97_96 = this;
        var98_97 = var64_63;
        var97_96.dispatchPdus((byte[][])var98_97);
        ** while (true)
    }

    protected abstract void sendData(String var1, String var2, int var3, byte[] var4, PendingIntent var5, PendingIntent var6);

    protected abstract void sendMultipartSms(SmsTracker var1);

    protected abstract void sendMultipartText(String var1, String var2, ArrayList<String> var3, ArrayList<PendingIntent> var4, ArrayList<PendingIntent> var5);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sendRawPdu(byte[] byArray, byte[] byArray2, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        if (byArray2 == null) {
            if (pendingIntent == null) {
                return;
            }
            int n = 3;
            try {
                pendingIntent.send(n);
                return;
            }
            catch (PendingIntent.CanceledException canceledException) {
                return;
            }
        }
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        byte[] byArray3 = hashMap.put("smsc", byArray);
        byte[] byArray4 = hashMap.put("pdu", byArray2);
        SmsTracker smsTracker = new SmsTracker(hashMap, pendingIntent, pendingIntent2);
        int n = this.mPhone.getServiceState().getState();
        if (n != 0) {
            this.handleNotInService(n, smsTracker);
            return;
        }
        String string2 = this.getAppNameByIntent(pendingIntent);
        if (this.mCounter.check(string2, 1)) {
            this.sendSms(smsTracker);
            return;
        }
        Message message = this.obtainMessage(7, smsTracker);
        boolean bl = this.sendMessage(message);
    }

    protected abstract void sendSms(SmsTracker var1);

    protected abstract void sendText(String var1, String var2, String var3, PendingIntent var4, PendingIntent var5);

    protected abstract void setCellBroadcastConfig(int[] var1, Message var2);

    protected static class SmsTracker {
        public HashMap mData;
        public PendingIntent mDeliveryIntent;
        public int mMessageRef;
        public int mRetryCount;
        public PendingIntent mSentIntent;

        SmsTracker(HashMap hashMap, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
            this.mData = hashMap;
            this.mSentIntent = pendingIntent;
            this.mDeliveryIntent = pendingIntent2;
            this.mRetryCount = 0;
        }
    }

    private class SmsCounter {
        private int mCheckPeriod;
        private int mMaxAllowed;
        private HashMap<String, ArrayList<Long>> mSmsStamp;

        SmsCounter(int n, int n2) {
            this.mMaxAllowed = n;
            this.mCheckPeriod = n2;
            HashMap hashMap = new HashMap();
            this.mSmsStamp = hashMap;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isUnderLimit(ArrayList<Long> arrayList, int n) {
            int n2;
            long l;
            long l2;
            long l3;
            long l4;
            Long l5 = System.currentTimeMillis();
            StringBuilder stringBuilder = new StringBuilder().append("SMS send size=");
            int n3 = arrayList.size();
            String string2 = stringBuilder.append(n3).append("time=").append(l5).toString();
            int n4 = Log.d(SMSDispatcher.TAG, string2);
            while (arrayList.size() > 0 && (l4 = (l3 = l5.longValue()) - (l2 = arrayList.get(0).longValue())) > (l = (long)this.mCheckPeriod)) {
                Long l6 = arrayList.remove(0);
            }
            int n5 = arrayList.size() + n;
            if (n5 > (n2 = this.mMaxAllowed)) return false;
            int n6 = 0;
            while (n6 < n) {
                boolean bl = arrayList.add(l5);
                ++n6;
            }
            return true;
        }

        boolean check(String string2, int n) {
            if (!this.mSmsStamp.containsKey(string2)) {
                HashMap<String, ArrayList<Long>> hashMap = this.mSmsStamp;
                ArrayList arrayList = new ArrayList();
                ArrayList arrayList2 = hashMap.put(string2, arrayList);
            }
            ArrayList<Long> arrayList = this.mSmsStamp.get(string2);
            return this.isUnderLimit(arrayList, n);
        }
    }
}

