/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import com.android.internal.telephony.CommandsInterface;

public abstract class ServiceStateTracker
extends Handler {
    protected static final int DATA_ACCESS_CDMA_1xRTT = 6;
    protected static final int DATA_ACCESS_CDMA_EvDo_0 = 7;
    protected static final int DATA_ACCESS_CDMA_EvDo_A = 8;
    protected static final int DATA_ACCESS_CDMA_EvDo_B = 12;
    protected static final int DATA_ACCESS_CDMA_IS95A = 4;
    protected static final int DATA_ACCESS_CDMA_IS95B = 5;
    protected static final int DATA_ACCESS_EDGE = 2;
    protected static final int DATA_ACCESS_GPRS = 1;
    protected static final int DATA_ACCESS_HSDPA = 9;
    protected static final int DATA_ACCESS_HSPA = 11;
    protected static final int DATA_ACCESS_HSUPA = 10;
    protected static final int DATA_ACCESS_UMTS = 3;
    protected static final int DATA_ACCESS_UNKNOWN = 0;
    public static final int DATA_STATE_POLL_SLEEP_MS = 100;
    protected static final boolean DBG = true;
    public static final int DEFAULT_GPRS_CHECK_PERIOD_MILLIS = 60000;
    protected static final int EVENT_CHECK_REPORT_GPRS = 22;
    protected static final int EVENT_ERI_FILE_LOADED = 36;
    protected static final int EVENT_GET_LOC_DONE = 15;
    protected static final int EVENT_GET_LOC_DONE_CDMA = 31;
    protected static final int EVENT_GET_PREFERRED_NETWORK_TYPE = 19;
    protected static final int EVENT_GET_SIGNAL_STRENGTH = 3;
    protected static final int EVENT_GET_SIGNAL_STRENGTH_CDMA = 29;
    protected static final int EVENT_LOCATION_UPDATES_ENABLED = 18;
    protected static final int EVENT_NETWORK_STATE_CHANGED = 2;
    protected static final int EVENT_NETWORK_STATE_CHANGED_CDMA = 30;
    protected static final int EVENT_NITZ_TIME = 11;
    protected static final int EVENT_NV_LOADED = 33;
    protected static final int EVENT_NV_READY = 35;
    protected static final int EVENT_OTA_PROVISION_STATUS_CHANGE = 37;
    protected static final int EVENT_POLL_SIGNAL_STRENGTH = 10;
    protected static final int EVENT_POLL_SIGNAL_STRENGTH_CDMA = 28;
    protected static final int EVENT_POLL_STATE_CDMA_SUBSCRIPTION = 34;
    protected static final int EVENT_POLL_STATE_GPRS = 5;
    protected static final int EVENT_POLL_STATE_NETWORK_SELECTION_MODE = 14;
    protected static final int EVENT_POLL_STATE_OPERATOR = 6;
    protected static final int EVENT_POLL_STATE_OPERATOR_CDMA = 25;
    protected static final int EVENT_POLL_STATE_REGISTRATION = 4;
    protected static final int EVENT_POLL_STATE_REGISTRATION_CDMA = 24;
    protected static final int EVENT_RADIO_AVAILABLE = 13;
    protected static final int EVENT_RADIO_STATE_CHANGED = 1;
    protected static final int EVENT_RESET_PREFERRED_NETWORK_TYPE = 21;
    protected static final int EVENT_RESTRICTED_STATE_CHANGED = 23;
    protected static final int EVENT_RUIM_READY = 26;
    protected static final int EVENT_RUIM_RECORDS_LOADED = 27;
    protected static final int EVENT_SET_PREFERRED_NETWORK_TYPE = 20;
    protected static final int EVENT_SET_RADIO_POWER_OFF = 38;
    protected static final int EVENT_SIGNAL_STRENGTH_UPDATE = 12;
    protected static final int EVENT_SIGNAL_STRENGTH_UPDATE_CDMA = 32;
    protected static final int EVENT_SIM_READY = 17;
    protected static final int EVENT_SIM_RECORDS_LOADED = 16;
    protected static final String[] GMT_COUNTRY_CODES;
    protected static final int POLL_PERIOD_MILLIS = 20000;
    protected static final String REGISTRATION_DENIED_AUTH = "Authentication Failure";
    protected static final String REGISTRATION_DENIED_GEN = "General";
    protected static final String TIMEZONE_PROPERTY = "persist.sys.timezone";
    protected CommandsInterface cm;
    protected boolean dontPollSignalStrength = false;
    protected boolean mDesiredPowerState;
    public SignalStrength mSignalStrength;
    private boolean mWantContinuousLocationUpdates;
    private boolean mWantSingleLocationUpdate;
    protected RegistrantList networkAttachedRegistrants;
    protected ServiceState newSS;
    protected int[] pollingContext;
    protected RegistrantList roamingOffRegistrants;
    protected RegistrantList roamingOnRegistrants;
    public ServiceState ss;

    static {
        String[] stringArray = new String[]{"bf", "ci", "eh", "fo", "gh", "gm", "gn", "gw", "ie", "lr", "is", "ma", "ml", "mr", "pt", "sl", "sn", "st", "tg", "uk"};
        GMT_COUNTRY_CODES = stringArray;
    }

    public ServiceStateTracker() {
        RegistrantList registrantList;
        RegistrantList registrantList2;
        RegistrantList registrantList3;
        this.networkAttachedRegistrants = registrantList3 = new RegistrantList();
        this.roamingOnRegistrants = registrantList2 = new RegistrantList();
        this.roamingOffRegistrants = registrantList = new RegistrantList();
    }

    protected void cancelPollState() {
        int[] nArray = new int[1];
        this.pollingContext = nArray;
    }

    public void disableLocationUpdates() {
        this.mWantContinuousLocationUpdates = false;
        if (this.mWantSingleLocationUpdate) {
            return;
        }
        if (this.mWantContinuousLocationUpdates) {
            return;
        }
        this.cm.setLocationUpdates(false, null);
    }

    protected void disableSingleLocationUpdate() {
        this.mWantSingleLocationUpdate = false;
        if (this.mWantSingleLocationUpdate) {
            return;
        }
        if (this.mWantContinuousLocationUpdates) {
            return;
        }
        this.cm.setLocationUpdates(false, null);
    }

    public void enableLocationUpdates() {
        if (this.mWantSingleLocationUpdate) {
            return;
        }
        if (this.mWantContinuousLocationUpdates) {
            return;
        }
        this.mWantContinuousLocationUpdates = true;
        CommandsInterface commandsInterface = this.cm;
        Message message = this.obtainMessage(18);
        commandsInterface.setLocationUpdates(true, message);
    }

    public void enableSingleLocationUpdate() {
        if (this.mWantSingleLocationUpdate) {
            return;
        }
        if (this.mWantContinuousLocationUpdates) {
            return;
        }
        this.mWantSingleLocationUpdate = true;
        CommandsInterface commandsInterface = this.cm;
        Message message = this.obtainMessage(18);
        commandsInterface.setLocationUpdates(true, message);
    }

    public boolean getDesiredPowerState() {
        return this.mDesiredPowerState;
    }

    @Override
    public abstract void handleMessage(Message var1);

    protected abstract void handlePollStateResult(int var1, AsyncResult var2);

    protected abstract void powerOffRadioSafely();

    public void reRegisterNetwork(Message message) {
        CommandsInterface commandsInterface = this.cm;
        Message message2 = this.obtainMessage(19, message);
        commandsInterface.getPreferredNetworkType(message2);
    }

    public void registerForRoamingOff(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.roamingOffRegistrants.add(registrant);
        if (this.ss.getRoaming()) {
            return;
        }
        registrant.notifyRegistrant();
    }

    public void registerForRoamingOn(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.roamingOnRegistrants.add(registrant);
        if (!this.ss.getRoaming()) {
            return;
        }
        registrant.notifyRegistrant();
    }

    protected abstract void setPowerStateToDesired();

    public void setRadioPower(boolean bl) {
        this.mDesiredPowerState = bl;
        this.setPowerStateToDesired();
    }

    public void unregisterForRoamingOff(Handler handler) {
        this.roamingOffRegistrants.remove(handler);
    }

    public void unregisterForRoamingOn(Handler handler) {
        this.roamingOnRegistrants.remove(handler);
    }

    protected abstract void updateSpnDisplay();
}

