/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import com.android.internal.util.HexDump;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class SmsHeader {
    public static final int ELT_ID_APPLICATION_PORT_ADDRESSING_16_BIT = 5;
    public static final int ELT_ID_APPLICATION_PORT_ADDRESSING_8_BIT = 4;
    public static final int ELT_ID_CHARACTER_SIZE_WVG_OBJECT = 25;
    public static final int ELT_ID_COMPRESSION_CONTROL = 22;
    public static final int ELT_ID_CONCATENATED_16_BIT_REFERENCE = 8;
    public static final int ELT_ID_CONCATENATED_8_BIT_REFERENCE = 0;
    public static final int ELT_ID_ENHANCED_VOICE_MAIL_INFORMATION = 35;
    public static final int ELT_ID_EXTENDED_OBJECT = 20;
    public static final int ELT_ID_EXTENDED_OBJECT_DATA_REQUEST_CMD = 26;
    public static final int ELT_ID_HYPERLINK_FORMAT_ELEMENT = 33;
    public static final int ELT_ID_LARGE_ANIMATION = 14;
    public static final int ELT_ID_LARGE_PICTURE = 16;
    public static final int ELT_ID_OBJECT_DISTR_INDICATOR = 23;
    public static final int ELT_ID_PREDEFINED_ANIMATION = 13;
    public static final int ELT_ID_PREDEFINED_SOUND = 11;
    public static final int ELT_ID_REPLY_ADDRESS_ELEMENT = 34;
    public static final int ELT_ID_REUSED_EXTENDED_OBJECT = 21;
    public static final int ELT_ID_RFC_822_EMAIL_HEADER = 32;
    public static final int ELT_ID_SMALL_ANIMATION = 15;
    public static final int ELT_ID_SMALL_PICTURE = 17;
    public static final int ELT_ID_SMSC_CONTROL_PARAMS = 6;
    public static final int ELT_ID_SPECIAL_SMS_MESSAGE_INDICATION = 1;
    public static final int ELT_ID_STANDARD_WVG_OBJECT = 24;
    public static final int ELT_ID_TEXT_FORMATTING = 10;
    public static final int ELT_ID_UDH_SOURCE_INDICATION = 7;
    public static final int ELT_ID_USER_DEFINED_SOUND = 12;
    public static final int ELT_ID_USER_PROMPT_INDICATOR = 19;
    public static final int ELT_ID_VARIABLE_PICTURE = 18;
    public static final int ELT_ID_WIRELESS_CTRL_MSG_PROTOCOL = 9;
    public static final int PORT_WAP_PUSH = 2948;
    public static final int PORT_WAP_WSP = 9200;
    public ConcatRef concatRef;
    public ArrayList<MiscElt> miscEltList;
    public PortAddrs portAddrs;

    public SmsHeader() {
        ArrayList arrayList = new ArrayList();
        this.miscEltList = arrayList;
    }

    public static SmsHeader fromByteArray(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        SmsHeader smsHeader = new SmsHeader();
        block6: while (byteArrayInputStream.available() > 0) {
            int n;
            int n2;
            int n3 = byteArrayInputStream.read();
            int n4 = byteArrayInputStream.read();
            switch (n3) {
                default: {
                    MiscElt miscElt = new MiscElt();
                    miscElt.id = n3;
                    byte[] byArray2 = new byte[n4];
                    byte[] byArray3 = miscElt.data = byArray2;
                    int n5 = byteArrayInputStream.read(byArray3, 0, n4);
                    boolean bl = smsHeader.miscEltList.add(miscElt);
                    continue block6;
                }
                case 0: {
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    ConcatRef concatRef = new ConcatRef();
                    concatRef.refNumber = n10 = byteArrayInputStream.read();
                    concatRef.msgCount = n9 = byteArrayInputStream.read();
                    concatRef.seqNumber = n8 = byteArrayInputStream.read();
                    concatRef.isEightBits = true;
                    if (concatRef.msgCount == 0 || concatRef.seqNumber == 0 || (n7 = concatRef.seqNumber) > (n6 = concatRef.msgCount)) continue block6;
                    smsHeader.concatRef = concatRef;
                    continue block6;
                }
                case 8: {
                    int n11;
                    int n12;
                    int n13;
                    int n14;
                    int n15;
                    ConcatRef concatRef = new ConcatRef();
                    int n16 = byteArrayInputStream.read() << 8;
                    int n17 = byteArrayInputStream.read();
                    concatRef.refNumber = n15 = n16 | n17;
                    concatRef.msgCount = n14 = byteArrayInputStream.read();
                    concatRef.seqNumber = n13 = byteArrayInputStream.read();
                    concatRef.isEightBits = false;
                    if (concatRef.msgCount == 0 || concatRef.seqNumber == 0 || (n12 = concatRef.seqNumber) > (n11 = concatRef.msgCount)) continue block6;
                    smsHeader.concatRef = concatRef;
                    continue block6;
                }
                case 4: {
                    int n18;
                    int n19;
                    PortAddrs portAddrs = new PortAddrs();
                    portAddrs.destPort = n19 = byteArrayInputStream.read();
                    portAddrs.origPort = n18 = byteArrayInputStream.read();
                    portAddrs.areEightBits = true;
                    smsHeader.portAddrs = portAddrs;
                    continue block6;
                }
                case 5: 
            }
            PortAddrs portAddrs = new PortAddrs();
            int n20 = byteArrayInputStream.read() << 8;
            int n21 = byteArrayInputStream.read();
            portAddrs.destPort = n2 = n20 | n21;
            int n22 = byteArrayInputStream.read() << 8;
            int n23 = byteArrayInputStream.read();
            portAddrs.origPort = n = n22 | n23;
            portAddrs.areEightBits = false;
            smsHeader.portAddrs = portAddrs;
        }
        return smsHeader;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static byte[] toByteArray(SmsHeader smsHeader) {
        PortAddrs portAddrs;
        if (smsHeader.portAddrs == null && smsHeader.concatRef == null && smsHeader.miscEltList.size() == 0) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(140);
        ConcatRef concatRef = smsHeader.concatRef;
        if (concatRef != null) {
            if (concatRef.isEightBits) {
                byteArrayOutputStream.write(0);
                byteArrayOutputStream.write(3);
                int n = concatRef.refNumber;
                byteArrayOutputStream.write(n);
            } else {
                byteArrayOutputStream.write(8);
                byteArrayOutputStream.write(4);
                int n = concatRef.refNumber >>> 8;
                byteArrayOutputStream.write(n);
                int n2 = concatRef.refNumber & 0xFF;
                byteArrayOutputStream.write(n2);
            }
            int n = concatRef.msgCount;
            byteArrayOutputStream.write(n);
            int n3 = concatRef.seqNumber;
            byteArrayOutputStream.write(n3);
        }
        if ((portAddrs = smsHeader.portAddrs) != null) {
            if (portAddrs.areEightBits) {
                byteArrayOutputStream.write(4);
                byteArrayOutputStream.write(2);
                int n = portAddrs.destPort;
                byteArrayOutputStream.write(n);
                int n4 = portAddrs.origPort;
                byteArrayOutputStream.write(n4);
            } else {
                byteArrayOutputStream.write(5);
                byteArrayOutputStream.write(4);
                int n = portAddrs.destPort >>> 8;
                byteArrayOutputStream.write(n);
                int n5 = portAddrs.destPort & 0xFF;
                byteArrayOutputStream.write(n5);
                int n6 = portAddrs.origPort >>> 8;
                byteArrayOutputStream.write(n6);
                int n7 = portAddrs.origPort & 0xFF;
                byteArrayOutputStream.write(n7);
            }
        }
        Iterator<MiscElt> iterator = smsHeader.miscEltList.iterator();
        while (iterator.hasNext()) {
            MiscElt miscElt = iterator.next();
            int n = miscElt.id;
            byteArrayOutputStream.write(n);
            int n8 = miscElt.data.length;
            byteArrayOutputStream.write(n8);
            byte[] byArray = miscElt.data;
            int n9 = miscElt.data.length;
            byteArrayOutputStream.write(byArray, 0, n9);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("UserDataHeader ");
        StringBuilder stringBuilder3 = stringBuilder.append("{ ConcatRef ");
        if (this.concatRef == null) {
            StringBuilder stringBuilder4 = stringBuilder.append("unset");
        } else {
            StringBuilder stringBuilder5 = new StringBuilder().append("{ refNumber=");
            int n = this.concatRef.refNumber;
            String string2 = stringBuilder5.append(n).toString();
            StringBuilder stringBuilder6 = stringBuilder.append(string2);
            StringBuilder stringBuilder7 = new StringBuilder().append(", msgCount=");
            int n2 = this.concatRef.msgCount;
            String string3 = stringBuilder7.append(n2).toString();
            StringBuilder stringBuilder8 = stringBuilder.append(string3);
            StringBuilder stringBuilder9 = new StringBuilder().append(", seqNumber=");
            int n3 = this.concatRef.seqNumber;
            String string4 = stringBuilder9.append(n3).toString();
            StringBuilder stringBuilder10 = stringBuilder.append(string4);
            StringBuilder stringBuilder11 = new StringBuilder().append(", isEightBits=");
            boolean bl = this.concatRef.isEightBits;
            String string5 = stringBuilder11.append(bl).toString();
            StringBuilder stringBuilder12 = stringBuilder.append(string5);
            StringBuilder stringBuilder13 = stringBuilder.append(" }");
        }
        StringBuilder stringBuilder14 = stringBuilder.append(", PortAddrs ");
        if (this.portAddrs == null) {
            StringBuilder stringBuilder15 = stringBuilder.append("unset");
        } else {
            StringBuilder stringBuilder16 = new StringBuilder().append("{ destPort=");
            int n = this.portAddrs.destPort;
            String string6 = stringBuilder16.append(n).toString();
            StringBuilder stringBuilder17 = stringBuilder.append(string6);
            StringBuilder stringBuilder18 = new StringBuilder().append(", origPort=");
            int n4 = this.portAddrs.origPort;
            String string7 = stringBuilder18.append(n4).toString();
            StringBuilder stringBuilder19 = stringBuilder.append(string7);
            StringBuilder stringBuilder20 = new StringBuilder().append(", areEightBits=");
            boolean bl = this.portAddrs.areEightBits;
            String string8 = stringBuilder20.append(bl).toString();
            StringBuilder stringBuilder21 = stringBuilder.append(string8);
            StringBuilder stringBuilder22 = stringBuilder.append(" }");
        }
        Iterator<MiscElt> iterator = this.miscEltList.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                StringBuilder stringBuilder23 = stringBuilder.append(" }");
                return stringBuilder.toString();
            }
            MiscElt miscElt = iterator.next();
            StringBuilder stringBuilder24 = stringBuilder.append(", MiscElt ");
            StringBuilder stringBuilder25 = new StringBuilder().append("{ id=");
            int n = miscElt.id;
            String string9 = stringBuilder25.append(n).toString();
            StringBuilder stringBuilder26 = stringBuilder.append(string9);
            StringBuilder stringBuilder27 = new StringBuilder().append(", length=");
            int n5 = miscElt.data.length;
            String string10 = stringBuilder27.append(n5).toString();
            StringBuilder stringBuilder28 = stringBuilder.append(string10);
            StringBuilder stringBuilder29 = new StringBuilder().append(", data=");
            String string11 = HexDump.toHexString(miscElt.data);
            String string12 = stringBuilder29.append(string11).toString();
            StringBuilder stringBuilder30 = stringBuilder.append(string12);
            StringBuilder stringBuilder31 = stringBuilder.append(" }");
        }
    }

    public static class MiscElt {
        public byte[] data;
        public int id;
    }

    public static class ConcatRef {
        public boolean isEightBits;
        public int msgCount;
        public int refNumber;
        public int seqNumber;
    }

    public static class PortAddrs {
        public boolean areEightBits;
        public int destPort;
        public int origPort;
    }
}

